/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EligibilityRequest", profile="http://hl7.org/fhir/Profile/EligibilityRequest")
public class EligibilityRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<EligibilityRequestStatus> status;
    @Child(name="priority", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Desired processing priority", formalDefinition="Immediate (STAT), best effort (NORMAL), deferred (DEFER).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/process-priority")
    protected CodeableConcept priority;
    @Child(name="patient", type={Patient.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="serviced", type={DateType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Estimated date or dates of Service", formalDefinition="The date or dates when the enclosed suite of services were performed or completed.")
    protected Type serviced;
    @Child(name="created", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="enterer", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Author", formalDefinition="Person who created the invoice/claim/pre-determination or pre-authorization.")
    protected Reference enterer;
    protected Practitioner entererTarget;
    @Child(name="provider", type={Practitioner.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference provider;
    protected Practitioner providerTarget;
    @Child(name="organization", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="insurer", type={Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Target", formalDefinition="The Insurer who is target  of the request.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="facility", type={Location.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Servicing Facility", formalDefinition="Facility where the services were provided.")
    protected Reference facility;
    protected Location facilityTarget;
    @Child(name="coverage", type={Coverage.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected Reference coverage;
    protected Coverage coverageTarget;
    @Child(name="businessArrangement", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
    protected StringType businessArrangement;
    @Child(name="benefitCategory", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of services covered", formalDefinition="Dental, Vision, Medical, Pharmacy, Rehab etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-category")
    protected CodeableConcept benefitCategory;
    @Child(name="benefitSubCategory", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed services covered within the type", formalDefinition="Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-subcategory")
    protected CodeableConcept benefitSubCategory;
    private static final long serialVersionUID = 899259023L;
    @SearchParamDefinition(name="identifier", path="EligibilityRequest.identifier", description="The business identifier of the Eligibility", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="provider", path="EligibilityRequest.provider", description="The reference to the provider", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("EligibilityRequest:provider").toLocked();
    @SearchParamDefinition(name="patient", path="EligibilityRequest.patient", description="The reference to the patient", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EligibilityRequest:patient").toLocked();
    @SearchParamDefinition(name="created", path="EligibilityRequest.created", description="The creation date for the EOB", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="organization", path="EligibilityRequest.organization", description="The reference to the providing organization", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("EligibilityRequest:organization").toLocked();
    @SearchParamDefinition(name="enterer", path="EligibilityRequest.enterer", description="The party who is responsible for the request", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("EligibilityRequest:enterer").toLocked();
    @SearchParamDefinition(name="facility", path="EligibilityRequest.facility", description="Facility responsible for the goods and services", type="reference", target={Location.class})
    public static final String SP_FACILITY = "facility";
    public static final ReferenceClientParam FACILITY = new ReferenceClientParam("facility");
    public static final Include INCLUDE_FACILITY = new Include("EligibilityRequest:facility").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EligibilityRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EligibilityRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EligibilityRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EligibilityRequestStatus>(new EligibilityRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EligibilityRequest setStatusElement(Enumeration<EligibilityRequestStatus> value) {
        this.status = value;
        return this;
    }

    public EligibilityRequestStatus getStatus() {
        return this.status == null ? null : (EligibilityRequestStatus)((Object)this.status.getValue());
    }

    public EligibilityRequest setStatus(EligibilityRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<EligibilityRequestStatus>(new EligibilityRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public EligibilityRequest setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public EligibilityRequest setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public EligibilityRequest setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Type getServiced() {
        return this.serviced;
    }

    public DateType getServicedDateType() throws FHIRException {
        if (!(this.serviced instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (DateType)this.serviced;
    }

    public boolean hasServicedDateType() {
        return this.serviced instanceof DateType;
    }

    public Period getServicedPeriod() throws FHIRException {
        if (!(this.serviced instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (Period)this.serviced;
    }

    public boolean hasServicedPeriod() {
        return this.serviced instanceof Period;
    }

    public boolean hasServiced() {
        return this.serviced != null && !this.serviced.isEmpty();
    }

    public EligibilityRequest setServiced(Type value) {
        this.serviced = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EligibilityRequest setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EligibilityRequest setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public EligibilityRequest setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Practitioner getEntererTarget() {
        if (this.entererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.entererTarget = new Practitioner();
            }
        }
        return this.entererTarget;
    }

    public EligibilityRequest setEntererTarget(Practitioner value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public EligibilityRequest setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Practitioner getProviderTarget() {
        if (this.providerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.providerTarget = new Practitioner();
            }
        }
        return this.providerTarget;
    }

    public EligibilityRequest setProviderTarget(Practitioner value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public EligibilityRequest setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public EligibilityRequest setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public EligibilityRequest setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public EligibilityRequest setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getFacility() {
        if (this.facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facility = new Reference();
            }
        }
        return this.facility;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public EligibilityRequest setFacility(Reference value) {
        this.facility = value;
        return this;
    }

    public Location getFacilityTarget() {
        if (this.facilityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityTarget = new Location();
            }
        }
        return this.facilityTarget;
    }

    public EligibilityRequest setFacilityTarget(Location value) {
        this.facilityTarget = value;
        return this;
    }

    public Reference getCoverage() {
        if (this.coverage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.coverage");
            }
            if (Configuration.doAutoCreate()) {
                this.coverage = new Reference();
            }
        }
        return this.coverage;
    }

    public boolean hasCoverage() {
        return this.coverage != null && !this.coverage.isEmpty();
    }

    public EligibilityRequest setCoverage(Reference value) {
        this.coverage = value;
        return this;
    }

    public Coverage getCoverageTarget() {
        if (this.coverageTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.coverage");
            }
            if (Configuration.doAutoCreate()) {
                this.coverageTarget = new Coverage();
            }
        }
        return this.coverageTarget;
    }

    public EligibilityRequest setCoverageTarget(Coverage value) {
        this.coverageTarget = value;
        return this;
    }

    public StringType getBusinessArrangementElement() {
        if (this.businessArrangement == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.businessArrangement");
            }
            if (Configuration.doAutoCreate()) {
                this.businessArrangement = new StringType();
            }
        }
        return this.businessArrangement;
    }

    public boolean hasBusinessArrangementElement() {
        return this.businessArrangement != null && !this.businessArrangement.isEmpty();
    }

    public boolean hasBusinessArrangement() {
        return this.businessArrangement != null && !this.businessArrangement.isEmpty();
    }

    public EligibilityRequest setBusinessArrangementElement(StringType value) {
        this.businessArrangement = value;
        return this;
    }

    public String getBusinessArrangement() {
        return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
    }

    public EligibilityRequest setBusinessArrangement(String value) {
        if (Utilities.noString((String)value)) {
            this.businessArrangement = null;
        } else {
            if (this.businessArrangement == null) {
                this.businessArrangement = new StringType();
            }
            this.businessArrangement.setValue(value);
        }
        return this;
    }

    public CodeableConcept getBenefitCategory() {
        if (this.benefitCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.benefitCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.benefitCategory = new CodeableConcept();
            }
        }
        return this.benefitCategory;
    }

    public boolean hasBenefitCategory() {
        return this.benefitCategory != null && !this.benefitCategory.isEmpty();
    }

    public EligibilityRequest setBenefitCategory(CodeableConcept value) {
        this.benefitCategory = value;
        return this;
    }

    public CodeableConcept getBenefitSubCategory() {
        if (this.benefitSubCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.benefitSubCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.benefitSubCategory = new CodeableConcept();
            }
        }
        return this.benefitSubCategory;
    }

    public boolean hasBenefitSubCategory() {
        return this.benefitSubCategory != null && !this.benefitSubCategory.isEmpty();
    }

    public EligibilityRequest setBenefitSubCategory(CodeableConcept value) {
        this.benefitSubCategory = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("status", "code", "The status of the resource instance.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("priority", "CodeableConcept", "Immediate (STAT), best effort (NORMAL), deferred (DEFER).", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.serviced));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property(SP_ENTERER, "Reference(Practitioner)", "Person who created the invoice/claim/pre-determination or pre-authorization.", 0, Integer.MAX_VALUE, this.enterer));
        childrenList.add(new Property(SP_PROVIDER, "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("insurer", "Reference(Organization)", "The Insurer who is target  of the request.", 0, Integer.MAX_VALUE, this.insurer));
        childrenList.add(new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, Integer.MAX_VALUE, this.facility));
        childrenList.add(new Property("coverage", "Reference(Coverage)", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.coverage));
        childrenList.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, Integer.MAX_VALUE, this.businessArrangement));
        childrenList.add(new Property("benefitCategory", "CodeableConcept", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, Integer.MAX_VALUE, this.benefitCategory));
        childrenList.add(new Property("benefitSubCategory", "CodeableConcept", "Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.", 0, Integer.MAX_VALUE, this.benefitSubCategory));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.priority;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 1379209295: {
                Base[] baseArray;
                if (this.serviced == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.serviced;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.enterer;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.provider;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.organization;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.insurer;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.facility;
                }
                return baseArray;
            }
            case -351767064: {
                Base[] baseArray;
                if (this.coverage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.coverage;
                }
                return baseArray;
            }
            case 259920682: {
                Base[] baseArray;
                if (this.businessArrangement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.businessArrangement;
                }
                return baseArray;
            }
            case -1023390027: {
                Base[] baseArray;
                if (this.benefitCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.benefitCategory;
                }
                return baseArray;
            }
            case 1987878471: {
                Base[] baseArray;
                if (this.benefitSubCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.benefitSubCategory;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EligibilityRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 1379209295: {
                this.serviced = this.castToType(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case 501116579: {
                this.facility = this.castToReference(value);
                return value;
            }
            case -351767064: {
                this.coverage = this.castToReference(value);
                return value;
            }
            case 259920682: {
                this.businessArrangement = this.castToString(value);
                return value;
            }
            case -1023390027: {
                this.benefitCategory = this.castToCodeableConcept(value);
                return value;
            }
            case 1987878471: {
                this.benefitSubCategory = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new EligibilityRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("priority")) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("serviced[x]")) {
            this.serviced = this.castToType(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = this.castToReference(value);
        } else if (name.equals("insurer")) {
            this.insurer = this.castToReference(value);
        } else if (name.equals(SP_FACILITY)) {
            this.facility = this.castToReference(value);
        } else if (name.equals("coverage")) {
            this.coverage = this.castToReference(value);
        } else if (name.equals("businessArrangement")) {
            this.businessArrangement = this.castToString(value);
        } else if (name.equals("benefitCategory")) {
            this.benefitCategory = this.castToCodeableConcept(value);
        } else if (name.equals("benefitSubCategory")) {
            this.benefitSubCategory = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1927922223: {
                return this.getServiced();
            }
            case 1379209295: {
                return this.getServiced();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case -987494927: {
                return this.getProvider();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 501116579: {
                return this.getFacility();
            }
            case -351767064: {
                return this.getCoverage();
            }
            case 259920682: {
                return this.getBusinessArrangementElement();
            }
            case -1023390027: {
                return this.getBenefitCategory();
            }
            case 1987878471: {
                return this.getBenefitSubCategory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1379209295: {
                return new String[]{"date", "Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 501116579: {
                return new String[]{"Reference"};
            }
            case -351767064: {
                return new String[]{"Reference"};
            }
            case 259920682: {
                return new String[]{"string"};
            }
            case -1023390027: {
                return new String[]{"CodeableConcept"};
            }
            case 1987878471: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type EligibilityRequest.status");
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("servicedDate")) {
            this.serviced = new DateType();
            return this.serviced;
        }
        if (name.equals("servicedPeriod")) {
            this.serviced = new Period();
            return this.serviced;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type EligibilityRequest.created");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("insurer")) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals(SP_FACILITY)) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("coverage")) {
            this.coverage = new Reference();
            return this.coverage;
        }
        if (name.equals("businessArrangement")) {
            throw new FHIRException("Cannot call addChild on a primitive type EligibilityRequest.businessArrangement");
        }
        if (name.equals("benefitCategory")) {
            this.benefitCategory = new CodeableConcept();
            return this.benefitCategory;
        }
        if (name.equals("benefitSubCategory")) {
            this.benefitSubCategory = new CodeableConcept();
            return this.benefitSubCategory;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EligibilityRequest";
    }

    @Override
    public EligibilityRequest copy() {
        EligibilityRequest dst = new EligibilityRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.serviced = this.serviced == null ? null : this.serviced.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.facility = this.facility == null ? null : this.facility.copy();
        dst.coverage = this.coverage == null ? null : this.coverage.copy();
        dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
        dst.benefitCategory = this.benefitCategory == null ? null : this.benefitCategory.copy();
        dst.benefitSubCategory = this.benefitSubCategory == null ? null : this.benefitSubCategory.copy();
        return dst;
    }

    protected EligibilityRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof EligibilityRequest)) {
            return false;
        }
        EligibilityRequest o = (EligibilityRequest)other;
        return EligibilityRequest.compareDeep(this.identifier, o.identifier, true) && EligibilityRequest.compareDeep(this.status, o.status, true) && EligibilityRequest.compareDeep(this.priority, o.priority, true) && EligibilityRequest.compareDeep(this.patient, o.patient, true) && EligibilityRequest.compareDeep(this.serviced, o.serviced, true) && EligibilityRequest.compareDeep(this.created, o.created, true) && EligibilityRequest.compareDeep(this.enterer, o.enterer, true) && EligibilityRequest.compareDeep(this.provider, o.provider, true) && EligibilityRequest.compareDeep(this.organization, o.organization, true) && EligibilityRequest.compareDeep(this.insurer, o.insurer, true) && EligibilityRequest.compareDeep(this.facility, o.facility, true) && EligibilityRequest.compareDeep(this.coverage, o.coverage, true) && EligibilityRequest.compareDeep(this.businessArrangement, o.businessArrangement, true) && EligibilityRequest.compareDeep(this.benefitCategory, o.benefitCategory, true) && EligibilityRequest.compareDeep(this.benefitSubCategory, o.benefitSubCategory, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof EligibilityRequest)) {
            return false;
        }
        EligibilityRequest o = (EligibilityRequest)other;
        return EligibilityRequest.compareValues(this.status, o.status, true) && EligibilityRequest.compareValues(this.created, o.created, true) && EligibilityRequest.compareValues(this.businessArrangement, o.businessArrangement, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.priority, this.patient, this.serviced, this.created, this.enterer, this.provider, this.organization, this.insurer, this.facility, this.coverage, this.businessArrangement, this.benefitCategory, this.benefitSubCategory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EligibilityRequest;
    }

    public static class EligibilityRequestStatusEnumFactory
    implements EnumFactory<EligibilityRequestStatus> {
        @Override
        public EligibilityRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EligibilityRequestStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return EligibilityRequestStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return EligibilityRequestStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return EligibilityRequestStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EligibilityRequestStatus code '" + codeString + "'");
        }

        public Enumeration<EligibilityRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EligibilityRequestStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown EligibilityRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EligibilityRequestStatus code) {
            if (code == EligibilityRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == EligibilityRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EligibilityRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == EligibilityRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EligibilityRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum EligibilityRequestStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static EligibilityRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EligibilityRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

