/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DeviceMetric;
import org.hl7.fhir.dstu3.model.DeviceRequest;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.NutritionOrder;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SampledData;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Observation", profile="http://hl7.org/fhir/Profile/Observation")
public class Observation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for observation", formalDefinition="A unique identifier assigned to this observation.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ProcedureRequest.class, ReferralRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="The status of the result value.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-status")
    protected Enumeration<ObservationStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Classification of  type of observation", formalDefinition="A code that classifies the general type of observation being made.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"name\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what this is about", formalDefinition="The patient, or group of patients, location, or device whose characteristics (direct or indirect) are described by the observation and into whose record the observation is placed.  Comments: Indirect characteristics may be those of a specimen, fetus, donor,  other observer (for example a relative or EMT), or any observation made about the subject.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Healthcare event during which this observation is made", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically relevant time/time-period for observation", formalDefinition="The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.")
    protected Type effective;
    @Child(name="issued", type={InstantType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time this was made available", formalDefinition="The date and time this observation was made available to providers, typically after the results have been reviewed and verified.")
    protected InstantType issued;
    @Child(name="performer", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for the observation", formalDefinition="Who was responsible for asserting the observed value as \"true\".")
    protected List<Reference> performer;
    protected List<Resource> performerTarget;
    @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, BooleanType.class, Range.class, Ratio.class, SampledData.class, Attachment.class, TimeType.class, DateTimeType.class, Period.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Actual result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value.")
    protected Type value;
    @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why the result is missing", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-valueabsentreason")
    protected CodeableConcept dataAbsentReason;
    @Child(name="interpretation", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="High, low, normal, etc.", formalDefinition="The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-interpretation")
    protected CodeableConcept interpretation;
    @Child(name="comment", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about result", formalDefinition="May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.")
    protected StringType comment;
    @Child(name="bodySite", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Observed body part", formalDefinition="Indicates the site on the subject's body where the observation was made (i.e. the target site).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="method", type={CodeableConcept.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How it was done", formalDefinition="Indicates the mechanism used to perform the observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-methods")
    protected CodeableConcept method;
    @Child(name="specimen", type={Specimen.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen used for this observation", formalDefinition="The specimen that was used when this observation was made.")
    protected Reference specimen;
    protected Specimen specimenTarget;
    @Child(name="device", type={Device.class, DeviceMetric.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(Measurement) Device", formalDefinition="The device used to generate the observation data.")
    protected Reference device;
    protected Resource deviceTarget;
    @Child(name="referenceRange", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Provides guide for interpretation", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range.")
    protected List<ObservationReferenceRangeComponent> referenceRange;
    @Child(name="related", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource related to this observation", formalDefinition="A  reference to another resource (usually another Observation) whose relationship is defined by the relationship type code.")
    protected List<ObservationRelatedComponent> related;
    @Child(name="component", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Component results", formalDefinition="Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.")
    protected List<ObservationComponentComponent> component;
    private static final long serialVersionUID = -1771290322L;
    @SearchParamDefinition(name="date", path="Observation.effective", description="Obtained date/time. If the obtained element is a period, a date that falls in the period", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="combo-data-absent-reason", path="Observation.dataAbsentReason | Observation.component.dataAbsentReason", description="The reason why the expected value in the element Observation.value[x] or Observation.component.value[x] is missing.", type="token")
    public static final String SP_COMBO_DATA_ABSENT_REASON = "combo-data-absent-reason";
    public static final TokenClientParam COMBO_DATA_ABSENT_REASON = new TokenClientParam("combo-data-absent-reason");
    @SearchParamDefinition(name="code", path="Observation.code", description="The code of the observation type", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="combo-code-value-quantity", path="Observation | Observation.component", description="Code and quantity value parameter pair, including in components", type="composite", compositeOf={"combo-code", "combo-value-quantity"})
    public static final String SP_COMBO_CODE_VALUE_QUANTITY = "combo-code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> COMBO_CODE_VALUE_QUANTITY = new CompositeClientParam("combo-code-value-quantity");
    @SearchParamDefinition(name="subject", path="Observation.subject", description="The subject that the observation is about", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient")}, target={Device.class, Group.class, Location.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Observation:subject").toLocked();
    @SearchParamDefinition(name="component-data-absent-reason", path="Observation.component.dataAbsentReason", description="The reason why the expected value in the element Observation.component.value[x] is missing.", type="token")
    public static final String SP_COMPONENT_DATA_ABSENT_REASON = "component-data-absent-reason";
    public static final TokenClientParam COMPONENT_DATA_ABSENT_REASON = new TokenClientParam("component-data-absent-reason");
    @SearchParamDefinition(name="value-concept", path="Observation.value.as(CodeableConcept)", description="The value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_VALUE_CONCEPT = "value-concept";
    public static final TokenClientParam VALUE_CONCEPT = new TokenClientParam("value-concept");
    @SearchParamDefinition(name="value-date", path="Observation.value.as(DateTime) | Observation.value.as(Period)", description="The value of the observation, if the value is a date or period of time", type="date")
    public static final String SP_VALUE_DATE = "value-date";
    public static final DateClientParam VALUE_DATE = new DateClientParam("value-date");
    @SearchParamDefinition(name="code-value-string", path="Observation", description="Code and string value parameter pair", type="composite", compositeOf={"code", "value-string"})
    public static final String SP_CODE_VALUE_STRING = "code-value-string";
    public static final CompositeClientParam<TokenClientParam, StringClientParam> CODE_VALUE_STRING = new CompositeClientParam("code-value-string");
    @SearchParamDefinition(name="component-code-value-quantity", path="Observation.component", description="Component code and component quantity value parameter pair", type="composite", compositeOf={"component-code", "component-value-quantity"})
    public static final String SP_COMPONENT_CODE_VALUE_QUANTITY = "component-code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> COMPONENT_CODE_VALUE_QUANTITY = new CompositeClientParam("component-code-value-quantity");
    @SearchParamDefinition(name="based-on", path="Observation.basedOn", description="Reference to the test or procedure request.", type="reference", target={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ProcedureRequest.class, ReferralRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Observation:based-on").toLocked();
    @SearchParamDefinition(name="related", path="Observation.related", description="Related Observations - search on related-type and related-target together", type="composite", compositeOf={"related-target", "related-type"})
    public static final String SP_RELATED = "related";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATED = new CompositeClientParam("related");
    @SearchParamDefinition(name="code-value-date", path="Observation", description="Code and date/time value parameter pair", type="composite", compositeOf={"code", "value-date"})
    public static final String SP_CODE_VALUE_DATE = "code-value-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> CODE_VALUE_DATE = new CompositeClientParam("code-value-date");
    @SearchParamDefinition(name="patient", path="Observation.subject", description="The subject that the observation is about (if patient)", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Observation:patient").toLocked();
    @SearchParamDefinition(name="specimen", path="Observation.specimen", description="Specimen used for this observation", type="reference", target={Specimen.class})
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("Observation:specimen").toLocked();
    @SearchParamDefinition(name="component-code", path="Observation.component.code", description="The component code of the observation type", type="token")
    public static final String SP_COMPONENT_CODE = "component-code";
    public static final TokenClientParam COMPONENT_CODE = new TokenClientParam("component-code");
    @SearchParamDefinition(name="code-value-quantity", path="Observation", description="Code and quantity value parameter pair", type="composite", compositeOf={"code", "value-quantity"})
    public static final String SP_CODE_VALUE_QUANTITY = "code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CODE_VALUE_QUANTITY = new CompositeClientParam("code-value-quantity");
    @SearchParamDefinition(name="context", path="Observation.context", description="Healthcare event  (Episode-of-care or Encounter) related to the observation", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("Observation:context").toLocked();
    @SearchParamDefinition(name="combo-code-value-concept", path="Observation | Observation.component", description="Code and coded value parameter pair, including in components", type="composite", compositeOf={"combo-code", "combo-value-concept"})
    public static final String SP_COMBO_CODE_VALUE_CONCEPT = "combo-code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> COMBO_CODE_VALUE_CONCEPT = new CompositeClientParam("combo-code-value-concept");
    @SearchParamDefinition(name="value-string", path="Observation.value.as(String)", description="The value of the observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_VALUE_STRING = "value-string";
    public static final StringClientParam VALUE_STRING = new StringClientParam("value-string");
    @SearchParamDefinition(name="identifier", path="Observation.identifier", description="The unique id for a particular observation", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="performer", path="Observation.performer", description="Who performed the observation", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Observation:performer").toLocked();
    @SearchParamDefinition(name="combo-code", path="Observation.code | Observation.component.code", description="The code of the observation type or component type", type="token")
    public static final String SP_COMBO_CODE = "combo-code";
    public static final TokenClientParam COMBO_CODE = new TokenClientParam("combo-code");
    @SearchParamDefinition(name="method", path="Observation.method", description="The method used for the observation", type="token")
    public static final String SP_METHOD = "method";
    public static final TokenClientParam METHOD = new TokenClientParam("method");
    @SearchParamDefinition(name="value-quantity", path="Observation.value.as(Quantity)", description="The value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_VALUE_QUANTITY = "value-quantity";
    public static final QuantityClientParam VALUE_QUANTITY = new QuantityClientParam("value-quantity");
    @SearchParamDefinition(name="component-value-quantity", path="Observation.component.value.as(Quantity)", description="The value of the component observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_COMPONENT_VALUE_QUANTITY = "component-value-quantity";
    public static final QuantityClientParam COMPONENT_VALUE_QUANTITY = new QuantityClientParam("component-value-quantity");
    @SearchParamDefinition(name="data-absent-reason", path="Observation.dataAbsentReason", description="The reason why the expected value in the element Observation.value[x] is missing.", type="token")
    public static final String SP_DATA_ABSENT_REASON = "data-absent-reason";
    public static final TokenClientParam DATA_ABSENT_REASON = new TokenClientParam("data-absent-reason");
    @SearchParamDefinition(name="combo-value-quantity", path="Observation.value.as(Quantity) | Observation.component.value.as(Quantity)", description="The value or component value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_COMBO_VALUE_QUANTITY = "combo-value-quantity";
    public static final QuantityClientParam COMBO_VALUE_QUANTITY = new QuantityClientParam("combo-value-quantity");
    @SearchParamDefinition(name="encounter", path="Observation.context", description="Encounter related to the observation", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Observation:encounter").toLocked();
    @SearchParamDefinition(name="related-type", path="Observation.related.type", description="has-member | derived-from | sequel-to | replaces | qualified-by | interfered-by", type="token")
    public static final String SP_RELATED_TYPE = "related-type";
    public static final TokenClientParam RELATED_TYPE = new TokenClientParam("related-type");
    @SearchParamDefinition(name="related-target", path="Observation.related.target", description="Resource that is related to this one", type="reference", target={Observation.class, QuestionnaireResponse.class, Sequence.class})
    public static final String SP_RELATED_TARGET = "related-target";
    public static final ReferenceClientParam RELATED_TARGET = new ReferenceClientParam("related-target");
    public static final Include INCLUDE_RELATED_TARGET = new Include("Observation:related-target").toLocked();
    @SearchParamDefinition(name="code-value-concept", path="Observation", description="Code and coded value parameter pair", type="composite", compositeOf={"code", "value-concept"})
    public static final String SP_CODE_VALUE_CONCEPT = "code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CODE_VALUE_CONCEPT = new CompositeClientParam("code-value-concept");
    @SearchParamDefinition(name="component-code-value-concept", path="Observation.component", description="Component code and component coded value parameter pair", type="composite", compositeOf={"component-code", "component-value-concept"})
    public static final String SP_COMPONENT_CODE_VALUE_CONCEPT = "component-code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> COMPONENT_CODE_VALUE_CONCEPT = new CompositeClientParam("component-code-value-concept");
    @SearchParamDefinition(name="component-value-concept", path="Observation.component.value.as(CodeableConcept)", description="The value of the component observation, if the value is a CodeableConcept", type="token")
    public static final String SP_COMPONENT_VALUE_CONCEPT = "component-value-concept";
    public static final TokenClientParam COMPONENT_VALUE_CONCEPT = new TokenClientParam("component-value-concept");
    @SearchParamDefinition(name="category", path="Observation.category", description="The classification of the type of observation", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="device", path="Observation.device", description="The Device that generated the observation data.", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class, DeviceMetric.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("Observation:device").toLocked();
    @SearchParamDefinition(name="combo-value-concept", path="Observation.value.as(CodeableConcept) | Observation.component.value.as(CodeableConcept)", description="The value or component value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_COMBO_VALUE_CONCEPT = "combo-value-concept";
    public static final TokenClientParam COMBO_VALUE_CONCEPT = new TokenClientParam("combo-value-concept");
    @SearchParamDefinition(name="status", path="Observation.status", description="The status of the observation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Observation() {
    }

    public Observation(Enumeration<ObservationStatus> status, CodeableConcept code) {
        this.status = status;
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Observation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Observation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Observation setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Observation addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public Enumeration<ObservationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ObservationStatus>(new ObservationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Observation setStatusElement(Enumeration<ObservationStatus> value) {
        this.status = value;
        return this;
    }

    public ObservationStatus getStatus() {
        return this.status == null ? null : (ObservationStatus)((Object)this.status.getValue());
    }

    public Observation setStatus(ObservationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ObservationStatus>(new ObservationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Observation setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Observation addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Observation setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Observation setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Observation setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public Observation setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public Observation setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public Observation setEffective(Type value) {
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Observation setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Observation setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Observation setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public Observation addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    @Deprecated
    public List<Resource> getPerformerTarget() {
        if (this.performerTarget == null) {
            this.performerTarget = new ArrayList<Resource>();
        }
        return this.performerTarget;
    }

    public Type getValue() {
        return this.value;
    }

    public Quantity getValueQuantity() throws FHIRException {
        if (!(this.value instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Quantity)this.value;
    }

    public boolean hasValueQuantity() {
        return this.value instanceof Quantity;
    }

    public CodeableConcept getValueCodeableConcept() throws FHIRException {
        if (!(this.value instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.value;
    }

    public boolean hasValueCodeableConcept() {
        return this.value instanceof CodeableConcept;
    }

    public StringType getValueStringType() throws FHIRException {
        if (!(this.value instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (StringType)this.value;
    }

    public boolean hasValueStringType() {
        return this.value instanceof StringType;
    }

    public BooleanType getValueBooleanType() throws FHIRException {
        if (!(this.value instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.value;
    }

    public boolean hasValueBooleanType() {
        return this.value instanceof BooleanType;
    }

    public Range getValueRange() throws FHIRException {
        if (!(this.value instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Range)this.value;
    }

    public boolean hasValueRange() {
        return this.value instanceof Range;
    }

    public Ratio getValueRatio() throws FHIRException {
        if (!(this.value instanceof Ratio)) {
            throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Ratio)this.value;
    }

    public boolean hasValueRatio() {
        return this.value instanceof Ratio;
    }

    public SampledData getValueSampledData() throws FHIRException {
        if (!(this.value instanceof SampledData)) {
            throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (SampledData)this.value;
    }

    public boolean hasValueSampledData() {
        return this.value instanceof SampledData;
    }

    public Attachment getValueAttachment() throws FHIRException {
        if (!(this.value instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Attachment)this.value;
    }

    public boolean hasValueAttachment() {
        return this.value instanceof Attachment;
    }

    public TimeType getValueTimeType() throws FHIRException {
        if (!(this.value instanceof TimeType)) {
            throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (TimeType)this.value;
    }

    public boolean hasValueTimeType() {
        return this.value instanceof TimeType;
    }

    public DateTimeType getValueDateTimeType() throws FHIRException {
        if (!(this.value instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.value;
    }

    public boolean hasValueDateTimeType() {
        return this.value instanceof DateTimeType;
    }

    public Period getValuePeriod() throws FHIRException {
        if (!(this.value instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Period)this.value;
    }

    public boolean hasValuePeriod() {
        return this.value instanceof Period;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Observation setValue(Type value) {
        this.value = value;
        return this;
    }

    public CodeableConcept getDataAbsentReason() {
        if (this.dataAbsentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.dataAbsentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.dataAbsentReason = new CodeableConcept();
            }
        }
        return this.dataAbsentReason;
    }

    public boolean hasDataAbsentReason() {
        return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
    }

    public Observation setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
        return this;
    }

    public CodeableConcept getInterpretation() {
        if (this.interpretation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.interpretation");
            }
            if (Configuration.doAutoCreate()) {
                this.interpretation = new CodeableConcept();
            }
        }
        return this.interpretation;
    }

    public boolean hasInterpretation() {
        return this.interpretation != null && !this.interpretation.isEmpty();
    }

    public Observation setInterpretation(CodeableConcept value) {
        this.interpretation = value;
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Observation setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Observation setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public Observation setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public Observation setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public Reference getSpecimen() {
        if (this.specimen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimen = new Reference();
            }
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        return this.specimen != null && !this.specimen.isEmpty();
    }

    public Observation setSpecimen(Reference value) {
        this.specimen = value;
        return this;
    }

    public Specimen getSpecimenTarget() {
        if (this.specimenTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimenTarget = new Specimen();
            }
        }
        return this.specimenTarget;
    }

    public Observation setSpecimenTarget(Specimen value) {
        this.specimenTarget = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public Observation setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Resource getDeviceTarget() {
        return this.deviceTarget;
    }

    public Observation setDeviceTarget(Resource value) {
        this.deviceTarget = value;
        return this;
    }

    public List<ObservationReferenceRangeComponent> getReferenceRange() {
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        return this.referenceRange;
    }

    public Observation setReferenceRange(List<ObservationReferenceRangeComponent> theReferenceRange) {
        this.referenceRange = theReferenceRange;
        return this;
    }

    public boolean hasReferenceRange() {
        if (this.referenceRange == null) {
            return false;
        }
        for (ObservationReferenceRangeComponent item : this.referenceRange) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationReferenceRangeComponent addReferenceRange() {
        ObservationReferenceRangeComponent t = new ObservationReferenceRangeComponent();
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        this.referenceRange.add(t);
        return t;
    }

    public Observation addReferenceRange(ObservationReferenceRangeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        this.referenceRange.add(t);
        return this;
    }

    public ObservationReferenceRangeComponent getReferenceRangeFirstRep() {
        if (this.getReferenceRange().isEmpty()) {
            this.addReferenceRange();
        }
        return this.getReferenceRange().get(0);
    }

    public List<ObservationRelatedComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelatedComponent>();
        }
        return this.related;
    }

    public Observation setRelated(List<ObservationRelatedComponent> theRelated) {
        this.related = theRelated;
        return this;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (ObservationRelatedComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationRelatedComponent addRelated() {
        ObservationRelatedComponent t = new ObservationRelatedComponent();
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelatedComponent>();
        }
        this.related.add(t);
        return t;
    }

    public Observation addRelated(ObservationRelatedComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelatedComponent>();
        }
        this.related.add(t);
        return this;
    }

    public ObservationRelatedComponent getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public List<ObservationComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        return this.component;
    }

    public Observation setComponent(List<ObservationComponentComponent> theComponent) {
        this.component = theComponent;
        return this;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (ObservationComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationComponentComponent addComponent() {
        ObservationComponentComponent t = new ObservationComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public Observation addComponent(ObservationComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    public ObservationComponentComponent getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            this.addComponent();
        }
        return this.getComponent().get(0);
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this observation.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ProcedureRequest|ReferralRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the result value.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of observation being made.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"name\".", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The patient, or group of patients, location, or device whose characteristics (direct or indirect) are described by the observation and into whose record the observation is placed.  Comments: Indirect characteristics may be those of a specimen, fetus, donor,  other observer (for example a relative or EMT), or any observation made about the subject.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.", 0, Integer.MAX_VALUE, this.context));
        childrenList.add(new Property("effective[x]", "dateTime|Period", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, Integer.MAX_VALUE, this.effective));
        childrenList.add(new Property("issued", "instant", "The date and time this observation was made available to providers, typically after the results have been reviewed and verified.", 0, Integer.MAX_VALUE, this.issued));
        childrenList.add(new Property(SP_PERFORMER, "Reference(Practitioner|Organization|Patient|RelatedPerson)", "Who was responsible for asserting the observed value as \"true\".", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property("value[x]", "Quantity|CodeableConcept|string|boolean|Range|Ratio|SampledData|Attachment|time|dateTime|Period", "The information determined as a result of making the observation, if the information has a simple value.", 0, Integer.MAX_VALUE, this.value));
        childrenList.add(new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.value[x] is missing.", 0, Integer.MAX_VALUE, this.dataAbsentReason));
        childrenList.add(new Property("interpretation", "CodeableConcept", "The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.", 0, Integer.MAX_VALUE, this.interpretation));
        childrenList.add(new Property("comment", "string", "May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.", 0, Integer.MAX_VALUE, this.comment));
        childrenList.add(new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the observation was made (i.e. the target site).", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property(SP_METHOD, "CodeableConcept", "Indicates the mechanism used to perform the observation.", 0, Integer.MAX_VALUE, this.method));
        childrenList.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "The specimen that was used when this observation was made.", 0, Integer.MAX_VALUE, this.specimen));
        childrenList.add(new Property(SP_DEVICE, "Reference(Device|DeviceMetric)", "The device used to generate the observation data.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("referenceRange", "", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange));
        childrenList.add(new Property(SP_RELATED, "", "A  reference to another resource (usually another Observation) whose relationship is defined by the relationship type code.", 0, Integer.MAX_VALUE, this.related));
        childrenList.add(new Property("component", "", "Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.context;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.effective;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.value;
                }
                return baseArray;
            }
            case 1034315687: {
                Base[] baseArray;
                if (this.dataAbsentReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.dataAbsentReason;
                }
                return baseArray;
            }
            case -297950712: {
                Base[] baseArray;
                if (this.interpretation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.interpretation;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.comment;
                }
                return baseArray;
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.bodySite;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.method;
                }
                return baseArray;
            }
            case -2132868344: {
                Base[] baseArray;
                if (this.specimen == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.specimen;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.device;
                }
                return baseArray;
            }
            case -1912545102: {
                return this.referenceRange == null ? new Base[]{} : this.referenceRange.toArray(new Base[this.referenceRange.size()]);
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
            case -1399907075: {
                return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new ObservationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = this.castToType(value);
                return value;
            }
            case -1179159893: {
                this.issued = this.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(this.castToReference(value));
                return value;
            }
            case 111972721: {
                this.value = this.castToType(value);
                return value;
            }
            case 1034315687: {
                this.dataAbsentReason = this.castToCodeableConcept(value);
                return value;
            }
            case -297950712: {
                this.interpretation = this.castToCodeableConcept(value);
                return value;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
            case 1702620169: {
                this.bodySite = this.castToCodeableConcept(value);
                return value;
            }
            case -1077554975: {
                this.method = this.castToCodeableConcept(value);
                return value;
            }
            case -2132868344: {
                this.specimen = this.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                return value;
            }
            case -1912545102: {
                this.getReferenceRange().add((ObservationReferenceRangeComponent)((Object)value));
                return value;
            }
            case 1090493483: {
                this.getRelated().add((ObservationRelatedComponent)((Object)value));
                return value;
            }
            case -1399907075: {
                this.getComponent().add((ObservationComponentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ObservationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = this.castToType(value);
        } else if (name.equals("issued")) {
            this.issued = this.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add(this.castToReference(value));
        } else if (name.equals("value[x]")) {
            this.value = this.castToType(value);
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = this.castToCodeableConcept(value);
        } else if (name.equals("interpretation")) {
            this.interpretation = this.castToCodeableConcept(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = this.castToCodeableConcept(value);
        } else if (name.equals(SP_METHOD)) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SPECIMEN)) {
            this.specimen = this.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("referenceRange")) {
            this.getReferenceRange().add((ObservationReferenceRangeComponent)((Object)value));
        } else if (name.equals(SP_RELATED)) {
            this.getRelated().add((ObservationRelatedComponent)((Object)value));
        } else if (name.equals("component")) {
            this.getComponent().add((ObservationComponentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case -1410166417: {
                return this.getValue();
            }
            case 111972721: {
                return this.getValue();
            }
            case 1034315687: {
                return this.getDataAbsentReason();
            }
            case -297950712: {
                return this.getInterpretation();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case -2132868344: {
                return this.getSpecimen();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1912545102: {
                return this.addReferenceRange();
            }
            case 1090493483: {
                return this.addRelated();
            }
            case -1399907075: {
                return this.addComponent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 111972721: {
                return new String[]{"Quantity", "CodeableConcept", "string", "boolean", "Range", "Ratio", "SampledData", "Attachment", "time", "dateTime", "Period"};
            }
            case 1034315687: {
                return new String[]{"CodeableConcept"};
            }
            case -297950712: {
                return new String[]{"CodeableConcept"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -1912545102: {
                return new String[0];
            }
            case 1090493483: {
                return new String[0];
            }
            case -1399907075: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("issued")) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("valueQuantity")) {
            this.value = new Quantity();
            return this.value;
        }
        if (name.equals("valueCodeableConcept")) {
            this.value = new CodeableConcept();
            return this.value;
        }
        if (name.equals("valueString")) {
            this.value = new StringType();
            return this.value;
        }
        if (name.equals("valueBoolean")) {
            this.value = new BooleanType();
            return this.value;
        }
        if (name.equals("valueRange")) {
            this.value = new Range();
            return this.value;
        }
        if (name.equals("valueRatio")) {
            this.value = new Ratio();
            return this.value;
        }
        if (name.equals("valueSampledData")) {
            this.value = new SampledData();
            return this.value;
        }
        if (name.equals("valueAttachment")) {
            this.value = new Attachment();
            return this.value;
        }
        if (name.equals("valueTime")) {
            this.value = new TimeType();
            return this.value;
        }
        if (name.equals("valueDateTime")) {
            this.value = new DateTimeType();
            return this.value;
        }
        if (name.equals("valuePeriod")) {
            this.value = new Period();
            return this.value;
        }
        if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = new CodeableConcept();
            return this.dataAbsentReason;
        }
        if (name.equals("interpretation")) {
            this.interpretation = new CodeableConcept();
            return this.interpretation;
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.comment");
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals(SP_METHOD)) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals(SP_SPECIMEN)) {
            this.specimen = new Reference();
            return this.specimen;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("referenceRange")) {
            return this.addReferenceRange();
        }
        if (name.equals(SP_RELATED)) {
            return this.addRelated();
        }
        if (name.equals("component")) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Observation";
    }

    @Override
    public Observation copy() {
        Observation dst = new Observation();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Enumeration<ObservationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference : this.performer) {
                dst.performer.add(reference.copy());
            }
        }
        dst.value = this.value == null ? null : this.value.copy();
        dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
        dst.interpretation = this.interpretation == null ? null : this.interpretation.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.specimen = this.specimen == null ? null : this.specimen.copy();
        Reference reference = dst.device = this.device == null ? null : this.device.copy();
        if (this.referenceRange != null) {
            dst.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            for (ObservationReferenceRangeComponent observationReferenceRangeComponent : this.referenceRange) {
                dst.referenceRange.add(observationReferenceRangeComponent.copy());
            }
        }
        if (this.related != null) {
            dst.related = new ArrayList<ObservationRelatedComponent>();
            for (ObservationRelatedComponent observationRelatedComponent : this.related) {
                dst.related.add(observationRelatedComponent.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<ObservationComponentComponent>();
            for (ObservationComponentComponent observationComponentComponent : this.component) {
                dst.component.add(observationComponentComponent.copy());
            }
        }
        return dst;
    }

    protected Observation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Observation)) {
            return false;
        }
        Observation o = (Observation)other;
        return Observation.compareDeep(this.identifier, o.identifier, true) && Observation.compareDeep(this.basedOn, o.basedOn, true) && Observation.compareDeep(this.status, o.status, true) && Observation.compareDeep(this.category, o.category, true) && Observation.compareDeep(this.code, o.code, true) && Observation.compareDeep(this.subject, o.subject, true) && Observation.compareDeep(this.context, o.context, true) && Observation.compareDeep(this.effective, o.effective, true) && Observation.compareDeep(this.issued, o.issued, true) && Observation.compareDeep(this.performer, o.performer, true) && Observation.compareDeep(this.value, o.value, true) && Observation.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && Observation.compareDeep(this.interpretation, o.interpretation, true) && Observation.compareDeep(this.comment, o.comment, true) && Observation.compareDeep(this.bodySite, o.bodySite, true) && Observation.compareDeep(this.method, o.method, true) && Observation.compareDeep(this.specimen, o.specimen, true) && Observation.compareDeep(this.device, o.device, true) && Observation.compareDeep(this.referenceRange, o.referenceRange, true) && Observation.compareDeep(this.related, o.related, true) && Observation.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Observation)) {
            return false;
        }
        Observation o = (Observation)other;
        return Observation.compareValues(this.status, o.status, true) && Observation.compareValues(this.issued, o.issued, true) && Observation.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.status, this.category, this.code, this.subject, this.context, this.effective, this.issued, this.performer, this.value, this.dataAbsentReason, this.interpretation, this.comment, this.bodySite, this.method, this.specimen, this.device, this.referenceRange, this.related, this.component});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Observation;
    }

    @Block
    public static class ObservationComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of component observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"code\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, Range.class, Ratio.class, SampledData.class, Attachment.class, TimeType.class, DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual component result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value.")
        protected Type value;
        @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the component result is missing", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-valueabsentreason")
        protected CodeableConcept dataAbsentReason;
        @Child(name="interpretation", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="High, low, normal, etc.", formalDefinition="The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-interpretation")
        protected CodeableConcept interpretation;
        @Child(name="referenceRange", type={ObservationReferenceRangeComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Provides guide for interpretation of component result", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range.")
        protected List<ObservationReferenceRangeComponent> referenceRange;
        private static final long serialVersionUID = -846379911L;

        public ObservationComponentComponent() {
        }

        public ObservationComponentComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ObservationComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public Range getValueRange() throws FHIRException {
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this.value instanceof Ratio;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this.value instanceof SampledData;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this.value instanceof Attachment;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this.value instanceof TimeType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this.value instanceof Period;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ObservationComponentComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public CodeableConcept getDataAbsentReason() {
            if (this.dataAbsentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.dataAbsentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataAbsentReason = new CodeableConcept();
                }
            }
            return this.dataAbsentReason;
        }

        public boolean hasDataAbsentReason() {
            return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
        }

        public ObservationComponentComponent setDataAbsentReason(CodeableConcept value) {
            this.dataAbsentReason = value;
            return this;
        }

        public CodeableConcept getInterpretation() {
            if (this.interpretation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.interpretation");
                }
                if (Configuration.doAutoCreate()) {
                    this.interpretation = new CodeableConcept();
                }
            }
            return this.interpretation;
        }

        public boolean hasInterpretation() {
            return this.interpretation != null && !this.interpretation.isEmpty();
        }

        public ObservationComponentComponent setInterpretation(CodeableConcept value) {
            this.interpretation = value;
            return this;
        }

        public List<ObservationReferenceRangeComponent> getReferenceRange() {
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            return this.referenceRange;
        }

        public ObservationComponentComponent setReferenceRange(List<ObservationReferenceRangeComponent> theReferenceRange) {
            this.referenceRange = theReferenceRange;
            return this;
        }

        public boolean hasReferenceRange() {
            if (this.referenceRange == null) {
                return false;
            }
            for (ObservationReferenceRangeComponent item : this.referenceRange) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ObservationReferenceRangeComponent addReferenceRange() {
            ObservationReferenceRangeComponent t = new ObservationReferenceRangeComponent();
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            this.referenceRange.add(t);
            return t;
        }

        public ObservationComponentComponent addReferenceRange(ObservationReferenceRangeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            this.referenceRange.add(t);
            return this;
        }

        public ObservationReferenceRangeComponent getReferenceRangeFirstRep() {
            if (this.getReferenceRange().isEmpty()) {
                this.addReferenceRange();
            }
            return this.getReferenceRange().get(0);
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Observation.SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"code\".", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("value[x]", "Quantity|CodeableConcept|string|Range|Ratio|SampledData|Attachment|time|dateTime|Period", "The information determined as a result of making the observation, if the information has a simple value.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.value[x] is missing.", 0, Integer.MAX_VALUE, this.dataAbsentReason));
            childrenList.add(new Property("interpretation", "CodeableConcept", "The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.", 0, Integer.MAX_VALUE, this.interpretation));
            childrenList.add(new Property("referenceRange", "@Observation.referenceRange", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 1034315687: {
                    Base[] baseArray;
                    if (this.dataAbsentReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dataAbsentReason;
                    }
                    return baseArray;
                }
                case -297950712: {
                    Base[] baseArray;
                    if (this.interpretation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.interpretation;
                    }
                    return baseArray;
                }
                case -1912545102: {
                    return this.referenceRange == null ? new Base[]{} : this.referenceRange.toArray(new Base[this.referenceRange.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
                case 1034315687: {
                    this.dataAbsentReason = this.castToCodeableConcept(value);
                    return value;
                }
                case -297950712: {
                    this.interpretation = this.castToCodeableConcept(value);
                    return value;
                }
                case -1912545102: {
                    this.getReferenceRange().add((ObservationReferenceRangeComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Observation.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else if (name.equals("dataAbsentReason")) {
                this.dataAbsentReason = this.castToCodeableConcept(value);
            } else if (name.equals("interpretation")) {
                this.interpretation = this.castToCodeableConcept(value);
            } else if (name.equals("referenceRange")) {
                this.getReferenceRange().add((ObservationReferenceRangeComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 1034315687: {
                    return this.getDataAbsentReason();
                }
                case -297950712: {
                    return this.getInterpretation();
                }
                case -1912545102: {
                    return this.addReferenceRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "CodeableConcept", "string", "Range", "Ratio", "SampledData", "Attachment", "time", "dateTime", "Period"};
                }
                case 1034315687: {
                    return new String[]{"CodeableConcept"};
                }
                case -297950712: {
                    return new String[]{"CodeableConcept"};
                }
                case -1912545102: {
                    return new String[]{"@Observation.referenceRange"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Observation.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("dataAbsentReason")) {
                this.dataAbsentReason = new CodeableConcept();
                return this.dataAbsentReason;
            }
            if (name.equals("interpretation")) {
                this.interpretation = new CodeableConcept();
                return this.interpretation;
            }
            if (name.equals("referenceRange")) {
                return this.addReferenceRange();
            }
            return super.addChild(name);
        }

        @Override
        public ObservationComponentComponent copy() {
            ObservationComponentComponent dst = new ObservationComponentComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
            CodeableConcept codeableConcept = dst.interpretation = this.interpretation == null ? null : this.interpretation.copy();
            if (this.referenceRange != null) {
                dst.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
                for (ObservationReferenceRangeComponent i : this.referenceRange) {
                    dst.referenceRange.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ObservationComponentComponent)) {
                return false;
            }
            ObservationComponentComponent o = (ObservationComponentComponent)other;
            return ObservationComponentComponent.compareDeep(this.code, o.code, true) && ObservationComponentComponent.compareDeep(this.value, o.value, true) && ObservationComponentComponent.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && ObservationComponentComponent.compareDeep(this.interpretation, o.interpretation, true) && ObservationComponentComponent.compareDeep(this.referenceRange, o.referenceRange, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ObservationComponentComponent)) {
                return false;
            }
            ObservationComponentComponent o = (ObservationComponentComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.value, this.dataAbsentReason, this.interpretation, this.referenceRange});
        }

        @Override
        public String fhirType() {
            return "Observation.component";
        }
    }

    @Block
    public static class ObservationRelatedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="has-member | derived-from | sequel-to | replaces | qualified-by | interfered-by", formalDefinition="A code specifying the kind of relationship that exists with the target resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-relationshiptypes")
        protected Enumeration<ObservationRelationshipType> type;
        @Child(name="target", type={Observation.class, QuestionnaireResponse.class, Sequence.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource that is related to this one", formalDefinition="A reference to the observation or [[[QuestionnaireResponse]]] resource that is related to this observation.")
        protected Reference target;
        protected Resource targetTarget;
        private static final long serialVersionUID = 1541802577L;

        public ObservationRelatedComponent() {
        }

        public ObservationRelatedComponent(Reference target) {
            this.target = target;
        }

        public Enumeration<ObservationRelationshipType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationRelatedComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ObservationRelationshipType>(new ObservationRelationshipTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ObservationRelatedComponent setTypeElement(Enumeration<ObservationRelationshipType> value) {
            this.type = value;
            return this;
        }

        public ObservationRelationshipType getType() {
            return this.type == null ? null : (ObservationRelationshipType)((Object)this.type.getValue());
        }

        public ObservationRelatedComponent setType(ObservationRelationshipType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<ObservationRelationshipType>(new ObservationRelationshipTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationRelatedComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ObservationRelatedComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public Resource getTargetTarget() {
            return this.targetTarget;
        }

        public ObservationRelatedComponent setTargetTarget(Resource value) {
            this.targetTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", Observation.SP_CODE, "A code specifying the kind of relationship that exists with the target resource.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("target", "Reference(Observation|QuestionnaireResponse|Sequence)", "A reference to the observation or [[[QuestionnaireResponse]]] resource that is related to this observation.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ObservationRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -880905839: {
                    this.target = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ObservationRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("target")) {
                this.target = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{Observation.SP_CODE};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Observation.type");
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public ObservationRelatedComponent copy() {
            ObservationRelatedComponent dst = new ObservationRelatedComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.target = this.target == null ? null : this.target.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ObservationRelatedComponent)) {
                return false;
            }
            ObservationRelatedComponent o = (ObservationRelatedComponent)other;
            return ObservationRelatedComponent.compareDeep(this.type, o.type, true) && ObservationRelatedComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ObservationRelatedComponent)) {
                return false;
            }
            ObservationRelatedComponent o = (ObservationRelatedComponent)other;
            return ObservationRelatedComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.target});
        }

        @Override
        public String fhirType() {
            return "Observation.related";
        }
    }

    @Block
    public static class ObservationReferenceRangeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="low", type={SimpleQuantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Low Range, if relevant", formalDefinition="The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).")
        protected SimpleQuantity low;
        @Child(name="high", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="High Range, if relevant", formalDefinition="The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).")
        protected SimpleQuantity high;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference range qualifier", formalDefinition="Codes to indicate the what part of the targeted reference population it applies to. For example, the normal or therapeutic range.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-meaning")
        protected CodeableConcept type;
        @Child(name="appliesTo", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Reference range population", formalDefinition="Codes to indicate the target population this reference range applies to.  For example, a reference range may be based on the normal population or a particular sex or race.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-appliesto")
        protected List<CodeableConcept> appliesTo;
        @Child(name="age", type={Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable age range, if relevant", formalDefinition="The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.")
        protected Range age;
        @Child(name="text", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text based reference range in an observation", formalDefinition="Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of 'normals'.")
        protected StringType text;
        private static final long serialVersionUID = -955638831L;

        public SimpleQuantity getLow() {
            if (this.low == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.low");
                }
                if (Configuration.doAutoCreate()) {
                    this.low = new SimpleQuantity();
                }
            }
            return this.low;
        }

        public boolean hasLow() {
            return this.low != null && !this.low.isEmpty();
        }

        public ObservationReferenceRangeComponent setLow(SimpleQuantity value) {
            this.low = value;
            return this;
        }

        public SimpleQuantity getHigh() {
            if (this.high == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.high");
                }
                if (Configuration.doAutoCreate()) {
                    this.high = new SimpleQuantity();
                }
            }
            return this.high;
        }

        public boolean hasHigh() {
            return this.high != null && !this.high.isEmpty();
        }

        public ObservationReferenceRangeComponent setHigh(SimpleQuantity value) {
            this.high = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ObservationReferenceRangeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getAppliesTo() {
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            return this.appliesTo;
        }

        public ObservationReferenceRangeComponent setAppliesTo(List<CodeableConcept> theAppliesTo) {
            this.appliesTo = theAppliesTo;
            return this;
        }

        public boolean hasAppliesTo() {
            if (this.appliesTo == null) {
                return false;
            }
            for (CodeableConcept item : this.appliesTo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAppliesTo() {
            CodeableConcept t = new CodeableConcept();
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return t;
        }

        public ObservationReferenceRangeComponent addAppliesTo(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return this;
        }

        public CodeableConcept getAppliesToFirstRep() {
            if (this.getAppliesTo().isEmpty()) {
                this.addAppliesTo();
            }
            return this.getAppliesTo().get(0);
        }

        public Range getAge() {
            if (this.age == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.age");
                }
                if (Configuration.doAutoCreate()) {
                    this.age = new Range();
                }
            }
            return this.age;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public ObservationReferenceRangeComponent setAge(Range value) {
            this.age = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ObservationReferenceRangeComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ObservationReferenceRangeComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("low", "SimpleQuantity", "The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).", 0, Integer.MAX_VALUE, this.low));
            childrenList.add(new Property("high", "SimpleQuantity", "The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).", 0, Integer.MAX_VALUE, this.high));
            childrenList.add(new Property("type", "CodeableConcept", "Codes to indicate the what part of the targeted reference population it applies to. For example, the normal or therapeutic range.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("appliesTo", "CodeableConcept", "Codes to indicate the target population this reference range applies to.  For example, a reference range may be based on the normal population or a particular sex or race.", 0, Integer.MAX_VALUE, this.appliesTo));
            childrenList.add(new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, Integer.MAX_VALUE, this.age));
            childrenList.add(new Property("text", "string", "Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of 'normals'.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 107348: {
                    Base[] baseArray;
                    if (this.low == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.low;
                    }
                    return baseArray;
                }
                case 3202466: {
                    Base[] baseArray;
                    if (this.high == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.high;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case -2089924569: {
                    return this.appliesTo == null ? new Base[]{} : this.appliesTo.toArray(new Base[this.appliesTo.size()]);
                }
                case 96511: {
                    Base[] baseArray;
                    if (this.age == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.age;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 107348: {
                    this.low = this.castToSimpleQuantity(value);
                    return value;
                }
                case 3202466: {
                    this.high = this.castToSimpleQuantity(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -2089924569: {
                    this.getAppliesTo().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 96511: {
                    this.age = this.castToRange(value);
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("low")) {
                this.low = this.castToSimpleQuantity(value);
            } else if (name.equals("high")) {
                this.high = this.castToSimpleQuantity(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("appliesTo")) {
                this.getAppliesTo().add(this.castToCodeableConcept(value));
            } else if (name.equals("age")) {
                this.age = this.castToRange(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 107348: {
                    return this.getLow();
                }
                case 3202466: {
                    return this.getHigh();
                }
                case 3575610: {
                    return this.getType();
                }
                case -2089924569: {
                    return this.addAppliesTo();
                }
                case 96511: {
                    return this.getAge();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 107348: {
                    return new String[]{"SimpleQuantity"};
                }
                case 3202466: {
                    return new String[]{"SimpleQuantity"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -2089924569: {
                    return new String[]{"CodeableConcept"};
                }
                case 96511: {
                    return new String[]{"Range"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("low")) {
                this.low = new SimpleQuantity();
                return this.low;
            }
            if (name.equals("high")) {
                this.high = new SimpleQuantity();
                return this.high;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("appliesTo")) {
                return this.addAppliesTo();
            }
            if (name.equals("age")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Observation.text");
            }
            return super.addChild(name);
        }

        @Override
        public ObservationReferenceRangeComponent copy() {
            ObservationReferenceRangeComponent dst = new ObservationReferenceRangeComponent();
            this.copyValues(dst);
            dst.low = this.low == null ? null : this.low.copy();
            dst.high = this.high == null ? null : this.high.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.appliesTo != null) {
                dst.appliesTo = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.appliesTo) {
                    dst.appliesTo.add(i.copy());
                }
            }
            dst.age = this.age == null ? null : this.age.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ObservationReferenceRangeComponent)) {
                return false;
            }
            ObservationReferenceRangeComponent o = (ObservationReferenceRangeComponent)other;
            return ObservationReferenceRangeComponent.compareDeep(this.low, o.low, true) && ObservationReferenceRangeComponent.compareDeep(this.high, o.high, true) && ObservationReferenceRangeComponent.compareDeep(this.type, o.type, true) && ObservationReferenceRangeComponent.compareDeep(this.appliesTo, o.appliesTo, true) && ObservationReferenceRangeComponent.compareDeep(this.age, o.age, true) && ObservationReferenceRangeComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ObservationReferenceRangeComponent)) {
                return false;
            }
            ObservationReferenceRangeComponent o = (ObservationReferenceRangeComponent)other;
            return ObservationReferenceRangeComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.low, this.high, this.type, this.appliesTo, this.age, this.text});
        }

        @Override
        public String fhirType() {
            return "Observation.referenceRange";
        }
    }

    public static class ObservationRelationshipTypeEnumFactory
    implements EnumFactory<ObservationRelationshipType> {
        @Override
        public ObservationRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("has-member".equals(codeString)) {
                return ObservationRelationshipType.HASMEMBER;
            }
            if ("derived-from".equals(codeString)) {
                return ObservationRelationshipType.DERIVEDFROM;
            }
            if ("sequel-to".equals(codeString)) {
                return ObservationRelationshipType.SEQUELTO;
            }
            if ("replaces".equals(codeString)) {
                return ObservationRelationshipType.REPLACES;
            }
            if ("qualified-by".equals(codeString)) {
                return ObservationRelationshipType.QUALIFIEDBY;
            }
            if ("interfered-by".equals(codeString)) {
                return ObservationRelationshipType.INTERFEREDBY;
            }
            throw new IllegalArgumentException("Unknown ObservationRelationshipType code '" + codeString + "'");
        }

        public Enumeration<ObservationRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ObservationRelationshipType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("has-member".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.HASMEMBER);
            }
            if ("derived-from".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.DERIVEDFROM);
            }
            if ("sequel-to".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.SEQUELTO);
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.REPLACES);
            }
            if ("qualified-by".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.QUALIFIEDBY);
            }
            if ("interfered-by".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.INTERFEREDBY);
            }
            throw new FHIRException("Unknown ObservationRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(ObservationRelationshipType code) {
            if (code == ObservationRelationshipType.HASMEMBER) {
                return "has-member";
            }
            if (code == ObservationRelationshipType.DERIVEDFROM) {
                return "derived-from";
            }
            if (code == ObservationRelationshipType.SEQUELTO) {
                return "sequel-to";
            }
            if (code == ObservationRelationshipType.REPLACES) {
                return "replaces";
            }
            if (code == ObservationRelationshipType.QUALIFIEDBY) {
                return "qualified-by";
            }
            if (code == ObservationRelationshipType.INTERFEREDBY) {
                return "interfered-by";
            }
            return "?";
        }

        @Override
        public String toSystem(ObservationRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum ObservationRelationshipType {
        HASMEMBER,
        DERIVEDFROM,
        SEQUELTO,
        REPLACES,
        QUALIFIEDBY,
        INTERFEREDBY,
        NULL;


        public static ObservationRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("has-member".equals(codeString)) {
                return HASMEMBER;
            }
            if ("derived-from".equals(codeString)) {
                return DERIVEDFROM;
            }
            if ("sequel-to".equals(codeString)) {
                return SEQUELTO;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("qualified-by".equals(codeString)) {
                return QUALIFIEDBY;
            }
            if ("interfered-by".equals(codeString)) {
                return INTERFEREDBY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ObservationRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HASMEMBER: {
                    return "has-member";
                }
                case DERIVEDFROM: {
                    return "derived-from";
                }
                case SEQUELTO: {
                    return "sequel-to";
                }
                case REPLACES: {
                    return "replaces";
                }
                case QUALIFIEDBY: {
                    return "qualified-by";
                }
                case INTERFEREDBY: {
                    return "interfered-by";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HASMEMBER: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case DERIVEDFROM: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case SEQUELTO: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case REPLACES: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case QUALIFIEDBY: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case INTERFEREDBY: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HASMEMBER: {
                    return "This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.";
                }
                case DERIVEDFROM: {
                    return "The target resource (Observation or QuestionnaireResponse) is part of the information from which this observation value is derived. (e.g. calculated anion gap, Apgar score)  NOTE:  \"derived-from\" is the only logical choice when referencing QuestionnaireResponse.";
                }
                case SEQUELTO: {
                    return "This observation follows the target observation (e.g. timed tests such as Glucose Tolerance Test).";
                }
                case REPLACES: {
                    return "This observation replaces a previous observation (i.e. a revised value). The target observation is now obsolete.";
                }
                case QUALIFIEDBY: {
                    return "The value of the target observation qualifies (refines) the semantics of the source observation (e.g. a lipemia measure target from a plasma measure).";
                }
                case INTERFEREDBY: {
                    return "The value of the target observation interferes (degrades quality, or prevents valid observation) with the semantics of the source observation (e.g. a hemolysis measure target from a plasma potassium measure, which has no value).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HASMEMBER: {
                    return "Has Member";
                }
                case DERIVEDFROM: {
                    return "Derived From";
                }
                case SEQUELTO: {
                    return "Sequel To";
                }
                case REPLACES: {
                    return "Replaces";
                }
                case QUALIFIEDBY: {
                    return "Qualified By";
                }
                case INTERFEREDBY: {
                    return "Interfered By";
                }
            }
            return "?";
        }
    }

    public static class ObservationStatusEnumFactory
    implements EnumFactory<ObservationStatus> {
        @Override
        public ObservationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return ObservationStatus.REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return ObservationStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return ObservationStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return ObservationStatus.AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return ObservationStatus.CORRECTED;
            }
            if ("cancelled".equals(codeString)) {
                return ObservationStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ObservationStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ObservationStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ObservationStatus code '" + codeString + "'");
        }

        public Enumeration<ObservationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ObservationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.REGISTERED);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.AMENDED);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.CORRECTED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ObservationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ObservationStatus code) {
            if (code == ObservationStatus.REGISTERED) {
                return "registered";
            }
            if (code == ObservationStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == ObservationStatus.FINAL) {
                return "final";
            }
            if (code == ObservationStatus.AMENDED) {
                return "amended";
            }
            if (code == ObservationStatus.CORRECTED) {
                return "corrected";
            }
            if (code == ObservationStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ObservationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ObservationStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ObservationStatus code) {
            return code.getSystem();
        }
    }

    public static enum ObservationStatus {
        REGISTERED,
        PRELIMINARY,
        FINAL,
        AMENDED,
        CORRECTED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ObservationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ObservationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/observation-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the observation is registered, but there is no result yet available.";
                }
                case PRELIMINARY: {
                    return "This is an initial or interim observation: data may be incomplete or unverified.";
                }
                case FINAL: {
                    return "The observation is complete.";
                }
                case AMENDED: {
                    return "Subsequent to being Final, the observation has been modified subsequent.  This includes updates/new information and corrections.";
                }
                case CORRECTED: {
                    return "Subsequent to being Final, the observation has been modified to correct an error in the test result.";
                }
                case CANCELLED: {
                    return "The observation is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The observation has been withdrawn following previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring system does not know which.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

