/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ServiceProduct;

public class ServiceProductEnumFactory
implements EnumFactory<ServiceProduct> {
    @Override
    public ServiceProduct fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("exam".equals(codeString)) {
            return ServiceProduct.EXAM;
        }
        if ("flushot".equals(codeString)) {
            return ServiceProduct.FLUSHOT;
        }
        throw new IllegalArgumentException("Unknown ServiceProduct code '" + codeString + "'");
    }

    @Override
    public String toCode(ServiceProduct code) {
        if (code == ServiceProduct.EXAM) {
            return "exam";
        }
        if (code == ServiceProduct.FLUSHOT) {
            return "flushot";
        }
        return "?";
    }

    @Override
    public String toSystem(ServiceProduct code) {
        return code.getSystem();
    }
}

