/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import org.hl7.fhir.dstu3.formats.JsonParserBase;
import org.hl7.fhir.dstu3.model.Account;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.AdverseEvent;
import org.hl7.fhir.dstu3.model.Age;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base64BinaryType;
import org.hl7.fhir.dstu3.model.Basic;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.BodySite;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CareTeam;
import org.hl7.fhir.dstu3.model.ChargeItem;
import org.hl7.fhir.dstu3.model.Claim;
import org.hl7.fhir.dstu3.model.ClaimResponse;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.CompartmentDefinition;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DeviceComponent;
import org.hl7.fhir.dstu3.model.DeviceMetric;
import org.hl7.fhir.dstu3.model.DeviceRequest;
import org.hl7.fhir.dstu3.model.DeviceUseStatement;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.Distance;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.EligibilityRequest;
import org.hl7.fhir.dstu3.model.EligibilityResponse;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.EnrollmentRequest;
import org.hl7.fhir.dstu3.model.EnrollmentResponse;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.ExtensionHelper;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.GuidanceResponse;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingManifest;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Linkage;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.MessageDefinition;
import org.hl7.fhir.dstu3.model.MessageHeader;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.NamingSystem;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.NutritionOrder;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.ParameterDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.PaymentNotice;
import org.hl7.fhir.dstu3.model.PaymentReconciliation;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.ProcessRequest;
import org.hl7.fhir.dstu3.model.ProcessResponse;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.dstu3.model.ResearchStudy;
import org.hl7.fhir.dstu3.model.ResearchSubject;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.RiskAssessment;
import org.hl7.fhir.dstu3.model.SampledData;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.ServiceDefinition;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Slot;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.SupplyDelivery;
import org.hl7.fhir.dstu3.model.SupplyRequest;
import org.hl7.fhir.dstu3.model.Task;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class JsonParser
extends JsonParserBase {
    @Override
    protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
        super.parseElementProperties(json, element);
        if (json.has("extension")) {
            JsonArray array = json.getAsJsonArray("extension");
            for (int i = 0; i < array.size(); ++i) {
                element.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseBackboneProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, element);
        if (json.has("modifierExtension")) {
            JsonArray array = json.getAsJsonArray("modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                element.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, element);
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        if (s != null) {
            res.setValue(e.fromCode(s));
        }
        return res;
    }

    protected DateType parseDate(String v) throws IOException, FHIRFormatError {
        DateType res = new DateType(v);
        return res;
    }

    protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(v);
        return res;
    }

    protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
        CodeType res = new CodeType(v);
        return res;
    }

    protected StringType parseString(String v) throws IOException, FHIRFormatError {
        StringType res = new StringType(v);
        return res;
    }

    protected IntegerType parseInteger(Long v) throws IOException, FHIRFormatError {
        IntegerType res = new IntegerType(v);
        return res;
    }

    protected OidType parseOid(String v) throws IOException, FHIRFormatError {
        OidType res = new OidType(v);
        return res;
    }

    protected UriType parseUri(String v) throws IOException, FHIRFormatError {
        UriType res = new UriType(v);
        return res;
    }

    protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
        UuidType res = new UuidType(v);
        return res;
    }

    protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
        InstantType res = new InstantType(v);
        return res;
    }

    protected BooleanType parseBoolean(Boolean v) throws IOException, FHIRFormatError {
        BooleanType res = new BooleanType(v);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(v);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(v);
        return res;
    }

    protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(v);
        return res;
    }

    protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
        TimeType res = new TimeType(v);
        return res;
    }

    protected IdType parseId(String v) throws IOException, FHIRFormatError {
        IdType res = new IdType(v);
        return res;
    }

    protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(v);
        return res;
    }

    protected DecimalType parseDecimal(BigDecimal v) throws IOException, FHIRFormatError {
        DecimalType res = new DecimalType(v);
        return res;
    }

    protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseExtensionProperties(json, res);
        return res;
    }

    protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
        Type value;
        this.parseTypeProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseNarrativeProperties(json, res);
        return res;
    }

    protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("div")) {
            res.setDiv(this.parseXhtml(json.get("div").getAsString()));
        }
    }

    protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseReferenceProperties(json, res);
        return res;
    }

    protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
    }

    protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseQuantityProperties(json, res);
        return res;
    }

    protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
    }

    protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
        Period res = new Period();
        this.parsePeriodProperties(json, res);
        return res;
    }

    protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseDateTime(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseDateTime(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
    }

    protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseAttachmentProperties(json, res);
        return res;
    }

    protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseUnsignedInt(json.get("size").getAsString()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
        }
        if (json.has("hash")) {
            res.setHashElement(this.parseBase64Binary(json.get("hash").getAsString()));
        }
        if (json.has("_hash")) {
            this.parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("creation")) {
            res.setCreationElement(this.parseDateTime(json.get("creation").getAsString()));
        }
        if (json.has("_creation")) {
            this.parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
        }
    }

    protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseDurationProperties(json, res);
        return res;
    }

    protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
        Count res = new Count();
        this.parseCountProperties(json, res);
        return res;
    }

    protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
        Range res = new Range();
        this.parseRangeProperties(json, res);
        return res;
    }

    protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseSimpleQuantity(json.getAsJsonObject("low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseSimpleQuantity(json.getAsJsonObject("high")));
        }
    }

    protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseAnnotationProperties(json, res);
        return res;
    }

    protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        Type author = this.parseType("author", json);
        if (author != null) {
            res.setAuthor(author);
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
    }

    protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
        Money res = new Money();
        this.parseMoneyProperties(json, res);
        return res;
    }

    protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseIdentifierProperties(json, res);
        return res;
    }

    protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("assigner")) {
            res.setAssigner(this.parseReference(json.getAsJsonObject("assigner")));
        }
    }

    protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseCodingProperties(json, res);
        return res;
    }

    protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(json.get("userSelected").getAsBoolean()));
        }
        if (json.has("_userSelected")) {
            this.parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
        }
    }

    protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseSignatureProperties(json, res);
        return res;
    }

    protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
        Type onBehalfOf;
        Type who;
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseInstant(json.get("when").getAsString()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
        }
        if ((who = this.parseType("who", json)) != null) {
            res.setWho(who);
        }
        if ((onBehalfOf = this.parseType("onBehalfOf", json)) != null) {
            res.setOnBehalfOf(onBehalfOf);
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("blob")) {
            res.setBlobElement(this.parseBase64Binary(json.get("blob").getAsString()));
        }
        if (json.has("_blob")) {
            this.parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
        }
    }

    protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseSampledDataProperties(json, res);
        return res;
    }

    protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("origin")) {
            res.setOrigin(this.parseSimpleQuantity(json.getAsJsonObject("origin")));
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
        }
        if (json.has("_lowerLimit")) {
            this.parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
        }
        if (json.has("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(json.get("upperLimit").getAsBigDecimal()));
        }
        if (json.has("_upperLimit")) {
            this.parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
        }
        if (json.has("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(json.get("dimensions").getAsString()));
        }
        if (json.has("_dimensions")) {
            this.parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseString(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
        }
    }

    protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseRatioProperties(json, res);
        return res;
    }

    protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("numerator")) {
            res.setNumerator(this.parseQuantity(json.getAsJsonObject("numerator")));
        }
        if (json.has("denominator")) {
            res.setDenominator(this.parseQuantity(json.getAsJsonObject("denominator")));
        }
    }

    protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseDistanceProperties(json, res);
        return res;
    }

    protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
        Age res = new Age();
        this.parseAgeProperties(json, res);
        return res;
    }

    protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseCodeableConceptProperties(json, res);
        return res;
    }

    protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("coding")) {
            JsonArray array = json.getAsJsonArray("coding");
            for (int i = 0; i < array.size(); ++i) {
                res.getCoding().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
    }

    protected SimpleQuantity parseSimpleQuantity(JsonObject json) throws IOException, FHIRFormatError {
        SimpleQuantity res = new SimpleQuantity();
        this.parseSimpleQuantityProperties(json, res);
        return res;
    }

    protected void parseSimpleQuantityProperties(JsonObject json, SimpleQuantity res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
    }

    protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseMetaProperties(json, res);
        return res;
    }

    protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseId(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
        }
        if (json.has("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(json.get("lastUpdated").getAsString()));
        }
        if (json.has("_lastUpdated")) {
            this.parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("security")) {
            array = json.getAsJsonArray("security");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurity().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("tag")) {
            array = json.getAsJsonArray("tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
        Address res = new Address();
        this.parseAddressProperties(json, res);
        return res;
    }

    protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("line")) {
            array = json.getAsJsonArray("line");
            for (i = 0; i < array.size(); ++i) {
                res.getLine().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_line")) {
            array = json.getAsJsonArray("_line");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLine().size()) {
                    res.getLine().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
            }
        }
        if (json.has("city")) {
            res.setCityElement(this.parseString(json.get("city").getAsString()));
        }
        if (json.has("_city")) {
            this.parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
        }
        if (json.has("district")) {
            res.setDistrictElement(this.parseString(json.get("district").getAsString()));
        }
        if (json.has("_district")) {
            this.parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseString(json.get("state").getAsString()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
        }
        if (json.has("postalCode")) {
            res.setPostalCodeElement(this.parseString(json.get("postalCode").getAsString()));
        }
        if (json.has("_postalCode")) {
            this.parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
        }
        if (json.has("country")) {
            res.setCountryElement(this.parseString(json.get("country").getAsString()));
        }
        if (json.has("_country")) {
            this.parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseTriggerDefinitionProperties(json, res);
        return res;
    }

    protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
        Type eventTiming;
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("eventName")) {
            res.setEventNameElement(this.parseString(json.get("eventName").getAsString()));
        }
        if (json.has("_eventName")) {
            this.parseElementProperties(json.getAsJsonObject("_eventName"), res.getEventNameElement());
        }
        if ((eventTiming = this.parseType("eventTiming", json)) != null) {
            res.setEventTiming(eventTiming);
        }
        if (json.has("eventData")) {
            res.setEventData(this.parseDataRequirement(json.getAsJsonObject("eventData")));
        }
    }

    protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
        Contributor res = new Contributor();
        this.parseContributorProperties(json, res);
        return res;
    }

    protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("contact")) {
            JsonArray array = json.getAsJsonArray("contact");
            for (int i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseDataRequirementProperties(json, res);
        return res;
    }

    protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("mustSupport")) {
            array = json.getAsJsonArray("mustSupport");
            for (i = 0; i < array.size(); ++i) {
                res.getMustSupport().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_mustSupport")) {
            array = json.getAsJsonArray("_mustSupport");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMustSupport().size()) {
                    res.getMustSupport().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
            }
        }
        if (json.has("codeFilter")) {
            array = json.getAsJsonArray("codeFilter");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeFilter().add(this.parseDataRequirementDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("dateFilter")) {
            array = json.getAsJsonArray("dateFilter");
            for (i = 0; i < array.size(); ++i) {
                res.getDateFilter().add(this.parseDataRequirementDataRequirementDateFilterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseDataRequirementDataRequirementCodeFilterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDataRequirementDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type valueSet;
        this.parseTypeProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        if (json.has("valueCode")) {
            array = json.getAsJsonArray("valueCode");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCode().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_valueCode")) {
            array = json.getAsJsonArray("_valueCode");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getValueCode().size()) {
                    res.getValueCode().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getValueCode().get(i));
            }
        }
        if (json.has("valueCoding")) {
            array = json.getAsJsonArray("valueCoding");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCoding().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("valueCodeableConcept")) {
            array = json.getAsJsonArray("valueCodeableConcept");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCodeableConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseDataRequirementDataRequirementDateFilterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDataRequirementDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
        Type value;
        this.parseTypeProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
        Dosage res = new Dosage();
        this.parseDosageProperties(json, res);
        return res;
    }

    protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
        Type rate;
        Type dose;
        Type asNeeded;
        this.parseTypeProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parseInteger(json.get("sequence").getAsLong()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("additionalInstruction")) {
            JsonArray array = json.getAsJsonArray("additionalInstruction");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdditionalInstruction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(json.get("patientInstruction").getAsString()));
        }
        if (json.has("_patientInstruction")) {
            this.parseElementProperties(json.getAsJsonObject("_patientInstruction"), res.getPatientInstructionElement());
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(json.getAsJsonObject("site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        if (json.has("maxDosePerAdministration")) {
            res.setMaxDosePerAdministration(this.parseSimpleQuantity(json.getAsJsonObject("maxDosePerAdministration")));
        }
        if (json.has("maxDosePerLifetime")) {
            res.setMaxDosePerLifetime(this.parseSimpleQuantity(json.getAsJsonObject("maxDosePerLifetime")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
    }

    protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
        RelatedArtifact res = new RelatedArtifact();
        this.parseRelatedArtifactProperties(json, res);
        return res;
    }

    protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("citation")) {
            res.setCitationElement(this.parseString(json.get("citation").getAsString()));
        }
        if (json.has("_citation")) {
            this.parseElementProperties(json.getAsJsonObject("_citation"), res.getCitationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("document")) {
            res.setDocument(this.parseAttachment(json.getAsJsonObject("document")));
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
    }

    protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
        ContactDetail res = new ContactDetail();
        this.parseContactDetailProperties(json, res);
        return res;
    }

    protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseHumanNameProperties(json, res);
        return res;
    }

    protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("family")) {
            res.setFamilyElement(this.parseString(json.get("family").getAsString()));
        }
        if (json.has("_family")) {
            this.parseElementProperties(json.getAsJsonObject("_family"), res.getFamilyElement());
        }
        if (json.has("given")) {
            array = json.getAsJsonArray("given");
            for (i = 0; i < array.size(); ++i) {
                res.getGiven().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_given")) {
            array = json.getAsJsonArray("_given");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getGiven().size()) {
                    res.getGiven().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
            }
        }
        if (json.has("prefix")) {
            array = json.getAsJsonArray("prefix");
            for (i = 0; i < array.size(); ++i) {
                res.getPrefix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_prefix")) {
            array = json.getAsJsonArray("_prefix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPrefix().size()) {
                    res.getPrefix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
            }
        }
        if (json.has("suffix")) {
            array = json.getAsJsonArray("suffix");
            for (i = 0; i < array.size(); ++i) {
                res.getSuffix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_suffix")) {
            array = json.getAsJsonArray("_suffix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSuffix().size()) {
                    res.getSuffix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseContactPointProperties(json, res);
        return res;
    }

    protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
        UsageContext res = new UsageContext();
        this.parseUsageContextProperties(json, res);
        return res;
    }

    protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
        Type value;
        this.parseTypeProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseTimingProperties(json, res);
        return res;
    }

    protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseTypeProperties(json, res);
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_event")) {
            array = json.getAsJsonArray("_event");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getEvent().size()) {
                    res.getEvent().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
            }
        }
        if (json.has("repeat")) {
            res.setRepeat(this.parseTimingTimingRepeatComponent(json.getAsJsonObject("repeat"), res));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner) throws IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseTimingTimingRepeatComponentProperties(json, owner, res);
        return res;
    }

    protected void parseTimingTimingRepeatComponentProperties(JsonObject json, Timing owner, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseTypeProperties(json, res);
        Type bounds = this.parseType("bounds", json);
        if (bounds != null) {
            res.setBounds(bounds);
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("countMax")) {
            res.setCountMaxElement(this.parseInteger(json.get("countMax").getAsLong()));
        }
        if (json.has("_countMax")) {
            this.parseElementProperties(json.getAsJsonObject("_countMax"), res.getCountMaxElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(json.get("durationMax").getAsBigDecimal()));
        }
        if (json.has("_durationMax")) {
            this.parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
        }
        if (json.has("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_durationUnit")) {
            this.parseElementProperties(json.getAsJsonObject("_durationUnit"), res.getDurationUnitElement());
        }
        if (json.has("frequency")) {
            res.setFrequencyElement(this.parseInteger(json.get("frequency").getAsLong()));
        }
        if (json.has("_frequency")) {
            this.parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
        }
        if (json.has("frequencyMax")) {
            res.setFrequencyMaxElement(this.parseInteger(json.get("frequencyMax").getAsLong()));
        }
        if (json.has("_frequencyMax")) {
            this.parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
        }
        if (json.has("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(json.get("periodMax").getAsBigDecimal()));
        }
        if (json.has("_periodMax")) {
            this.parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
        }
        if (json.has("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_periodUnit")) {
            this.parseElementProperties(json.getAsJsonObject("_periodUnit"), res.getPeriodUnitElement());
        }
        if (json.has("dayOfWeek")) {
            array = json.getAsJsonArray("dayOfWeek");
            for (i = 0; i < array.size(); ++i) {
                res.getDayOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
            }
        }
        if (json.has("_dayOfWeek")) {
            array = json.getAsJsonArray("_dayOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDayOfWeek().size()) {
                    res.getDayOfWeek().add(this.parseEnumeration(null, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDayOfWeek().get(i));
            }
        }
        if (json.has("timeOfDay")) {
            array = json.getAsJsonArray("timeOfDay");
            for (i = 0; i < array.size(); ++i) {
                res.getTimeOfDay().add(this.parseTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_timeOfDay")) {
            array = json.getAsJsonArray("_timeOfDay");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTimeOfDay().size()) {
                    res.getTimeOfDay().add(this.parseTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTimeOfDay().get(i));
            }
        }
        if (json.has("when")) {
            array = json.getAsJsonArray("when");
            for (i = 0; i < array.size(); ++i) {
                res.getWhen().add(this.parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
            }
        }
        if (json.has("_when")) {
            array = json.getAsJsonArray("_when");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getWhen().size()) {
                    res.getWhen().add(this.parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getWhen().get(i));
            }
        }
        if (json.has("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(json.get("offset").getAsString()));
        }
        if (json.has("_offset")) {
            this.parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
        }
    }

    protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementDefinitionProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type maxValue;
        Type minValue;
        Type pattern;
        Type fixed;
        Type defaultValue;
        int i2;
        JsonArray array2;
        this.parseTypeProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("representation")) {
            array2 = json.getAsJsonArray("representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRepresentation().add(this.parseEnumeration(array2.get(i2).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            }
        }
        if (json.has("_representation")) {
            array2 = json.getAsJsonArray("_representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getRepresentation().size()) {
                    res.getRepresentation().add(this.parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getRepresentation().get(i2));
            }
        }
        if (json.has("sliceName")) {
            res.setSliceNameElement(this.parseString(json.get("sliceName").getAsString()));
        }
        if (json.has("_sliceName")) {
            this.parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("code")) {
            array2 = json.getAsJsonArray("code");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("slicing")) {
            res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(json.getAsJsonObject("slicing"), res));
        }
        if (json.has("short")) {
            res.setShortElement(this.parseString(json.get("short").getAsString()));
        }
        if (json.has("_short")) {
            this.parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseMarkdown(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseMarkdown(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("alias")) {
            array2 = json.getAsJsonArray("alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getAlias().add(this.parseString(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array2 = json.getAsJsonArray("_alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getAlias().get(i2));
            }
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(json.getAsJsonObject("base"), res));
        }
        if (json.has("contentReference")) {
            res.setContentReferenceElement(this.parseUri(json.get("contentReference").getAsString()));
        }
        if (json.has("_contentReference")) {
            this.parseElementProperties(json.getAsJsonObject("_contentReference"), res.getContentReferenceElement());
        }
        if (json.has("type")) {
            array2 = json.getAsJsonArray("type");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        if ((defaultValue = this.parseType("defaultValue", json)) != null) {
            res.setDefaultValue(defaultValue);
        }
        if (json.has("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(json.get("meaningWhenMissing").getAsString()));
        }
        if (json.has("_meaningWhenMissing")) {
            this.parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
        }
        if (json.has("orderMeaning")) {
            res.setOrderMeaningElement(this.parseString(json.get("orderMeaning").getAsString()));
        }
        if (json.has("_orderMeaning")) {
            this.parseElementProperties(json.getAsJsonObject("_orderMeaning"), res.getOrderMeaningElement());
        }
        if ((fixed = this.parseType("fixed", json)) != null) {
            res.setFixed(fixed);
        }
        if ((pattern = this.parseType("pattern", json)) != null) {
            res.setPattern(pattern);
        }
        if (json.has("example")) {
            JsonArray array3 = json.getAsJsonArray("example");
            for (int i3 = 0; i3 < array3.size(); ++i3) {
                res.getExample().add(this.parseElementDefinitionElementDefinitionExampleComponent(array3.get(i3).getAsJsonObject(), res));
            }
        }
        if ((minValue = this.parseType("minValue", json)) != null) {
            res.setMinValue(minValue);
        }
        if ((maxValue = this.parseType("maxValue", json)) != null) {
            res.setMaxValue(maxValue);
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseId(array.get(i).getAsString()));
            }
        }
        if (json.has("_condition")) {
            array = json.getAsJsonArray("_condition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCondition().size()) {
                    res.getCondition().add(this.parseId(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
            }
        }
        if (json.has("constraint")) {
            array = json.getAsJsonArray("constraint");
            for (i = 0; i < array.size(); ++i) {
                res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(json.get("mustSupport").getAsBoolean()));
        }
        if (json.has("_mustSupport")) {
            this.parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
        }
        if (json.has("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(json.get("isModifier").getAsBoolean()));
        }
        if (json.has("_isModifier")) {
            this.parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
        }
        if (json.has("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(json.get("isSummary").getAsBoolean()));
        }
        if (json.has("_isSummary")) {
            this.parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
        }
        if (json.has("binding")) {
            res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(json.getAsJsonObject("binding"), res));
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementDefinitionElementDefinitionSlicingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("discriminator")) {
            JsonArray array = json.getAsJsonArray("discriminator");
            for (int i = 0; i < array.size(); ++i) {
                res.getDiscriminator().add(this.parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("ordered")) {
            res.setOrderedElement(this.parseBoolean(json.get("ordered").getAsBoolean()));
        }
        if (json.has("_ordered")) {
            this.parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
        }
        if (json.has("rules")) {
            res.setRulesElement(this.parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        }
        if (json.has("_rules")) {
            this.parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
        }
    }

    protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        this.parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementDefinitionElementDefinitionBaseComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementDefinitionTypeRefComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseTypeProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseUri(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseUri(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
        }
        if (json.has("targetProfile")) {
            res.setTargetProfileElement(this.parseUri(json.get("targetProfile").getAsString()));
        }
        if (json.has("_targetProfile")) {
            this.parseElementProperties(json.getAsJsonObject("_targetProfile"), res.getTargetProfileElement());
        }
        if (json.has("aggregation")) {
            array = json.getAsJsonArray("aggregation");
            for (i = 0; i < array.size(); ++i) {
                res.getAggregation().add(this.parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            }
        }
        if (json.has("_aggregation")) {
            array = json.getAsJsonArray("_aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAggregation().size()) {
                    res.getAggregation().add(this.parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
        }
    }

    protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
        this.parseElementDefinitionElementDefinitionExampleComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
        Type value;
        this.parseTypeProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementDefinitionElementDefinitionConstraintComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseId(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("human")) {
            res.setHumanElement(this.parseString(json.get("human").getAsString()));
        }
        if (json.has("_human")) {
            this.parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementDefinitionElementDefinitionBindingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
        Type valueSet;
        this.parseTypeProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementDefinitionElementDefinitionMappingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseElementDefinitionElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("map")) {
            res.setMapElement(this.parseString(json.get("map").getAsString()));
        }
        if (json.has("_map")) {
            this.parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
    }

    protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseParameterDefinitionProperties(json, res);
        return res;
    }

    protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
        this.parseTypeProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
    }

    protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("text")) {
            res.setText(this.parseNarrative(json.getAsJsonObject("text")));
        }
        if (json.has("contained")) {
            array = json.getAsJsonArray("contained");
            for (i = 0; i < array.size(); ++i) {
                res.getContained().add(this.parseResource(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("extension")) {
            array = json.getAsJsonArray("extension");
            for (i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modifierExtension")) {
            array = json.getAsJsonArray("modifierExtension");
            for (i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseParametersProperties(json, res);
        return res;
    }

    protected void parseParametersProperties(JsonObject json, Parameters res) throws IOException, FHIRFormatError {
        this.parseResourceProperties(json, res);
        if (json.has("parameter")) {
            JsonArray array = json.getAsJsonArray("parameter");
            for (int i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json, Parameters owner) throws IOException, FHIRFormatError {
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseParametersParametersParameterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseParametersParametersParameterComponentProperties(JsonObject json, Parameters owner, Parameters.ParametersParameterComponent res) throws IOException, FHIRFormatError {
        Type value;
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(json.getAsJsonObject("resource")));
        }
        if (json.has("part")) {
            JsonArray array = json.getAsJsonArray("part");
            for (int i = 0; i < array.size(); ++i) {
                res.getPart().add(this.parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
        if (json.has("id")) {
            res.setIdElement(this.parseId(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
        }
        if (json.has("meta")) {
            res.setMeta(this.parseMeta(json.getAsJsonObject("meta")));
        }
        if (json.has("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(json.get("implicitRules").getAsString()));
        }
        if (json.has("_implicitRules")) {
            this.parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
    }

    protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
        Account res = new Account();
        this.parseAccountProperties(json, res);
        return res;
    }

    protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("active")) {
            res.setActive(this.parsePeriod(json.getAsJsonObject("active")));
        }
        if (json.has("balance")) {
            res.setBalance(this.parseMoney(json.getAsJsonObject("balance")));
        }
        if (json.has("coverage")) {
            array = json.getAsJsonArray("coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseAccountCoverageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("guarantor")) {
            array = json.getAsJsonArray("guarantor");
            for (i = 0; i < array.size(); ++i) {
                res.getGuarantor().add(this.parseAccountGuarantorComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
        Account.CoverageComponent res = new Account.CoverageComponent();
        this.parseAccountCoverageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAccountCoverageComponentProperties(JsonObject json, Account owner, Account.CoverageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parsePositiveInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
    }

    protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
        Account.GuarantorComponent res = new Account.GuarantorComponent();
        this.parseAccountGuarantorComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAccountGuarantorComponentProperties(JsonObject json, Account owner, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
        if (json.has("onHold")) {
            res.setOnHoldElement(this.parseBoolean(json.get("onHold").getAsBoolean()));
        }
        if (json.has("_onHold")) {
            this.parseElementProperties(json.getAsJsonObject("_onHold"), res.getOnHoldElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition res = new ActivityDefinition();
        this.parseActivityDefinitionProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
        int i;
        Type product;
        Type timing;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(json.getAsJsonObject("effectivePeriod")));
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getUseContext().add(this.parseUsageContext(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("contributor")) {
            array = json.getAsJsonArray("contributor");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getContributor().add(this.parseContributor(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getContact().add(this.parseContactDetail(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getLibrary().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("participant")) {
            JsonArray array2 = json.getAsJsonArray("participant");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getParticipant().add(this.parseActivityDefinitionActivityDefinitionParticipantComponent(array2.get(i3).getAsJsonObject(), res));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("dosage")) {
            JsonArray array3 = json.getAsJsonArray("dosage");
            for (i = 0; i < array3.size(); ++i) {
                res.getDosage().add(this.parseDosage(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            JsonArray array4 = json.getAsJsonArray("bodySite");
            for (i = 0; i < array4.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("transform")) {
            res.setTransform(this.parseReference(json.getAsJsonObject("transform")));
        }
        if (json.has("dynamicValue")) {
            JsonArray array5 = json.getAsJsonArray("dynamicValue");
            for (i = 0; i < array5.size(); ++i) {
                res.getDynamicValue().add(this.parseActivityDefinitionActivityDefinitionDynamicValueComponent(array5.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        this.parseActivityDefinitionActivityDefinitionParticipantComponentProperties(json, owner, res);
        return res;
    }

    protected void parseActivityDefinitionActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
    }

    protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        this.parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(json, owner, res);
        return res;
    }

    protected void parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseString(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
    }

    protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent res = new AdverseEvent();
        this.parseAdverseEventProperties(json, res);
        return res;
    }

    protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), AdverseEvent.AdverseEventCategory.NULL, new AdverseEvent.AdverseEventCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("seriousness")) {
            res.setSeriousness(this.parseCodeableConcept(json.getAsJsonObject("seriousness")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(json.getAsJsonObject("recorder")));
        }
        if (json.has("eventParticipant")) {
            res.setEventParticipant(this.parseReference(json.getAsJsonObject("eventParticipant")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("suspectEntity")) {
            array = json.getAsJsonArray("suspectEntity");
            for (i = 0; i < array.size(); ++i) {
                res.getSuspectEntity().add(this.parseAdverseEventAdverseEventSuspectEntityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("subjectMedicalHistory")) {
            array = json.getAsJsonArray("subjectMedicalHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getSubjectMedicalHistory().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referenceDocument")) {
            array = json.getAsJsonArray("referenceDocument");
            for (i = 0; i < array.size(); ++i) {
                res.getReferenceDocument().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("study")) {
            array = json.getAsJsonArray("study");
            for (i = 0; i < array.size(); ++i) {
                res.getStudy().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(JsonObject json, AdverseEvent owner) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
        this.parseAdverseEventAdverseEventSuspectEntityComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAdverseEventAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("instance")) {
            res.setInstance(this.parseReference(json.getAsJsonObject("instance")));
        }
        if (json.has("causality")) {
            res.setCausalityElement(this.parseEnumeration(json.get("causality").getAsString(), AdverseEvent.AdverseEventCausality.NULL, new AdverseEvent.AdverseEventCausalityEnumFactory()));
        }
        if (json.has("_causality")) {
            this.parseElementProperties(json.getAsJsonObject("_causality"), res.getCausalityElement());
        }
        if (json.has("causalityAssessment")) {
            res.setCausalityAssessment(this.parseCodeableConcept(json.getAsJsonObject("causalityAssessment")));
        }
        if (json.has("causalityProductRelatedness")) {
            res.setCausalityProductRelatednessElement(this.parseString(json.get("causalityProductRelatedness").getAsString()));
        }
        if (json.has("_causalityProductRelatedness")) {
            this.parseElementProperties(json.getAsJsonObject("_causalityProductRelatedness"), res.getCausalityProductRelatednessElement());
        }
        if (json.has("causalityMethod")) {
            res.setCausalityMethod(this.parseCodeableConcept(json.getAsJsonObject("causalityMethod")));
        }
        if (json.has("causalityAuthor")) {
            res.setCausalityAuthor(this.parseReference(json.getAsJsonObject("causalityAuthor")));
        }
        if (json.has("causalityResult")) {
            res.setCausalityResult(this.parseCodeableConcept(json.getAsJsonObject("causalityResult")));
        }
    }

    protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseAllergyIntoleranceProperties(json, res);
        return res;
    }

    protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
        int i;
        Type onset;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatusElement(this.parseEnumeration(json.get("clinicalStatus").getAsString(), AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL, new AllergyIntolerance.AllergyIntoleranceClinicalStatusEnumFactory()));
        }
        if (json.has("_clinicalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatusElement(this.parseEnumeration(json.get("verificationStatus").getAsString(), AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL, new AllergyIntolerance.AllergyIntoleranceVerificationStatusEnumFactory()));
        }
        if (json.has("_verificationStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseEnumeration(array.get(i2).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
            }
        }
        if (json.has("_category")) {
            array = json.getAsJsonArray("_category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getCategory().size()) {
                    res.getCategory().add(this.parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getCategory().get(i2));
            }
        }
        if (json.has("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        }
        if (json.has("_criticality")) {
            this.parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("assertedDate")) {
            res.setAssertedDateElement(this.parseDateTime(json.get("assertedDate").getAsString()));
        }
        if (json.has("_assertedDate")) {
            this.parseElementProperties(json.getAsJsonObject("_assertedDate"), res.getAssertedDateElement());
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(json.getAsJsonObject("recorder")));
        }
        if (json.has("asserter")) {
            res.setAsserter(this.parseReference(json.getAsJsonObject("asserter")));
        }
        if (json.has("lastOccurrence")) {
            res.setLastOccurrenceElement(this.parseDateTime(json.get("lastOccurrence").getAsString()));
        }
        if (json.has("_lastOccurrence")) {
            this.parseElementProperties(json.getAsJsonObject("_lastOccurrence"), res.getLastOccurrenceElement());
        }
        if (json.has("note")) {
            JsonArray array2 = json.getAsJsonArray("note");
            for (i = 0; i < array2.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reaction")) {
            JsonArray array3 = json.getAsJsonArray("reaction");
            for (i = 0; i < array3.size(); ++i) {
                res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(json.getAsJsonObject("substance")));
        }
        if (json.has("manifestation")) {
            array = json.getAsJsonArray("manifestation");
            for (i = 0; i < array.size(); ++i) {
                res.getManifestation().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseAppointmentProperties(json, res);
        return res;
    }

    protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(json.getAsJsonObject("appointmentType")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseUnsignedInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(json.get("minutesDuration").getAsString()));
        }
        if (json.has("_minutesDuration")) {
            this.parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
        }
        if (json.has("slot")) {
            array = json.getAsJsonArray("slot");
            for (i = 0; i < array.size(); ++i) {
                res.getSlot().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("incomingReferral")) {
            array = json.getAsJsonArray("incomingReferral");
            for (i = 0; i < array.size(); ++i) {
                res.getIncomingReferral().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("requestedPeriod")) {
            array = json.getAsJsonArray("requestedPeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getRequestedPeriod().add(this.parsePeriod(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json, Appointment owner) throws IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseAppointmentAppointmentParticipantComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAppointmentAppointmentParticipantComponentProperties(JsonObject json, Appointment owner, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
    }

    protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseAppointmentResponseProperties(json, res);
        return res;
    }

    protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(json.getAsJsonObject("appointment")));
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("participantType")) {
            array = json.getAsJsonArray("participantType");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipantType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
        }
        if (json.has("_participantStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
    }

    protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseAuditEventProperties(json, res);
        return res;
    }

    protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("subtype")) {
            array = json.getAsJsonArray("subtype");
            for (i = 0; i < array.size(); ++i) {
                res.getSubtype().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("outcomeDesc")) {
            res.setOutcomeDescElement(this.parseString(json.get("outcomeDesc").getAsString()));
        }
        if (json.has("_outcomeDesc")) {
            this.parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
        }
        if (json.has("purposeOfEvent")) {
            array = json.getAsJsonArray("purposeOfEvent");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfEvent().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseAuditEventAuditEventAgentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("source")) {
            res.setSource(this.parseAuditEventAuditEventSourceComponent(json.getAsJsonObject("source"), res));
        }
        if (json.has("entity")) {
            array = json.getAsJsonArray("entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseAuditEventAuditEventEntityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseAuditEventAuditEventAgentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAuditEventAuditEventAgentComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            array = json.getAsJsonArray("role");
            for (i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("userId")) {
            res.setUserId(this.parseIdentifier(json.getAsJsonObject("userId")));
        }
        if (json.has("altId")) {
            res.setAltIdElement(this.parseString(json.get("altId").getAsString()));
        }
        if (json.has("_altId")) {
            this.parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("requestor")) {
            res.setRequestorElement(this.parseBoolean(json.get("requestor").getAsBoolean()));
        }
        if (json.has("_requestor")) {
            this.parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("media")) {
            res.setMedia(this.parseCoding(json.getAsJsonObject("media")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseAuditEventAuditEventAgentNetworkComponent(json.getAsJsonObject("network"), owner));
        }
        if (json.has("purposeOfUse")) {
            array = json.getAsJsonArray("purposeOfUse");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfUse().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
        this.parseAuditEventAuditEventAgentNetworkComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAuditEventAuditEventAgentNetworkComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("address")) {
            res.setAddressElement(this.parseString(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseAuditEventAuditEventSourceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAuditEventAuditEventSourceComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("site")) {
            res.setSiteElement(this.parseString(json.get("site").getAsString()));
        }
        if (json.has("_site")) {
            this.parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseAuditEventAuditEventEntityComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAuditEventAuditEventEntityComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCoding(json.getAsJsonObject("role")));
        }
        if (json.has("lifecycle")) {
            res.setLifecycle(this.parseCoding(json.getAsJsonObject("lifecycle")));
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("query")) {
            res.setQueryElement(this.parseBase64Binary(json.get("query").getAsString()));
        }
        if (json.has("_query")) {
            this.parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseAuditEventAuditEventEntityDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseAuditEventAuditEventEntityDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseAuditEventAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseBase64Binary(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
    }

    protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseBasicProperties(json, res);
        return res;
    }

    protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDate(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
    }

    protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseBinaryProperties(json, res);
        return res;
    }

    protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
        this.parseResourceProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("securityContext")) {
            res.setSecurityContext(this.parseReference(json.getAsJsonObject("securityContext")));
        }
        if (json.has("content")) {
            res.setContentElement(this.parseBase64Binary(json.get("content").getAsString()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
        }
    }

    protected BodySite parseBodySite(JsonObject json) throws IOException, FHIRFormatError {
        BodySite res = new BodySite();
        this.parseBodySiteProperties(json, res);
        return res;
    }

    protected void parseBodySiteProperties(JsonObject json, BodySite res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("qualifier")) {
            array = json.getAsJsonArray("qualifier");
            for (i = 0; i < array.size(); ++i) {
                res.getQualifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
    }

    protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseBundleProperties(json, res);
        return res;
    }

    protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseUnsignedInt(json.get("total").getAsString()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("signature")) {
            res.setSignature(this.parseSignature(json.getAsJsonObject("signature")));
        }
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBundleBundleLinkComponentProperties(json, owner, res);
        return res;
    }

    protected void parseBundleBundleLinkComponentProperties(JsonObject json, Bundle owner, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("relation")) {
            res.setRelationElement(this.parseString(json.get("relation").getAsString()));
        }
        if (json.has("_relation")) {
            this.parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBundleBundleEntryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseBundleBundleEntryComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("link")) {
            JsonArray array = json.getAsJsonArray("link");
            for (int i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("fullUrl")) {
            res.setFullUrlElement(this.parseUri(json.get("fullUrl").getAsString()));
        }
        if (json.has("_fullUrl")) {
            this.parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(json.getAsJsonObject("resource")));
        }
        if (json.has("search")) {
            res.setSearch(this.parseBundleBundleEntrySearchComponent(json.getAsJsonObject("search"), owner));
        }
        if (json.has("request")) {
            res.setRequest(this.parseBundleBundleEntryRequestComponent(json.getAsJsonObject("request"), owner));
        }
        if (json.has("response")) {
            res.setResponse(this.parseBundleBundleEntryResponseComponent(json.getAsJsonObject("response"), owner));
        }
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBundleBundleEntrySearchComponentProperties(json, owner, res);
        return res;
    }

    protected void parseBundleBundleEntrySearchComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("score")) {
            res.setScoreElement(this.parseDecimal(json.get("score").getAsBigDecimal()));
        }
        if (json.has("_score")) {
            this.parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
        }
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBundleBundleEntryRequestComponentProperties(json, owner, res);
        return res;
    }

    protected void parseBundleBundleEntryRequestComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("method")) {
            res.setMethodElement(this.parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        }
        if (json.has("_method")) {
            this.parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(json.get("ifNoneMatch").getAsString()));
        }
        if (json.has("_ifNoneMatch")) {
            this.parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
        }
        if (json.has("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(json.get("ifModifiedSince").getAsString()));
        }
        if (json.has("_ifModifiedSince")) {
            this.parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
        }
        if (json.has("ifMatch")) {
            res.setIfMatchElement(this.parseString(json.get("ifMatch").getAsString()));
        }
        if (json.has("_ifMatch")) {
            this.parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
        }
        if (json.has("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(json.get("ifNoneExist").getAsString()));
        }
        if (json.has("_ifNoneExist")) {
            this.parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
        }
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBundleBundleEntryResponseComponentProperties(json, owner, res);
        return res;
    }

    protected void parseBundleBundleEntryResponseComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseString(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("location")) {
            res.setLocationElement(this.parseUri(json.get("location").getAsString()));
        }
        if (json.has("_location")) {
            this.parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
        }
        if (json.has("etag")) {
            res.setEtagElement(this.parseString(json.get("etag").getAsString()));
        }
        if (json.has("_etag")) {
            this.parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
        }
        if (json.has("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(json.get("lastModified").getAsString()));
        }
        if (json.has("_lastModified")) {
            this.parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseResource(json.getAsJsonObject("outcome")));
        }
    }

    protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement res = new CapabilityStatement();
        this.parseCapabilityStatementProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("instantiates")) {
            array = json.getAsJsonArray("instantiates");
            for (i = 0; i < array.size(); ++i) {
                res.getInstantiates().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiates")) {
            array = json.getAsJsonArray("_instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiates().size()) {
                    res.getInstantiates().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
            }
        }
        if (json.has("software")) {
            res.setSoftware(this.parseCapabilityStatementCapabilityStatementSoftwareComponent(json.getAsJsonObject("software"), res));
        }
        if (json.has("implementation")) {
            res.setImplementation(this.parseCapabilityStatementCapabilityStatementImplementationComponent(json.getAsJsonObject("implementation"), res));
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("acceptUnknown")) {
            res.setAcceptUnknownElement(this.parseEnumeration(json.get("acceptUnknown").getAsString(), CapabilityStatement.UnknownContentCode.NULL, new CapabilityStatement.UnknownContentCodeEnumFactory()));
        }
        if (json.has("_acceptUnknown")) {
            this.parseElementProperties(json.getAsJsonObject("_acceptUnknown"), res.getAcceptUnknownElement());
        }
        if (json.has("format")) {
            array = json.getAsJsonArray("format");
            for (i = 0; i < array.size(); ++i) {
                res.getFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_format")) {
            array = json.getAsJsonArray("_format");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFormat().size()) {
                    res.getFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
            }
        }
        if (json.has("patchFormat")) {
            array = json.getAsJsonArray("patchFormat");
            for (i = 0; i < array.size(); ++i) {
                res.getPatchFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_patchFormat")) {
            array = json.getAsJsonArray("_patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPatchFormat().size()) {
                    res.getPatchFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
            }
        }
        if (json.has("implementationGuide")) {
            array = json.getAsJsonArray("implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                res.getImplementationGuide().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_implementationGuide")) {
            array = json.getAsJsonArray("_implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImplementationGuide().size()) {
                    res.getImplementationGuide().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
            }
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("rest")) {
            array = json.getAsJsonArray("rest");
            for (i = 0; i < array.size(); ++i) {
                res.getRest().add(this.parseCapabilityStatementCapabilityStatementRestComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("messaging")) {
            array = json.getAsJsonArray("messaging");
            for (i = 0; i < array.size(); ++i) {
                res.getMessaging().add(this.parseCapabilityStatementCapabilityStatementMessagingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("document")) {
            array = json.getAsJsonArray("document");
            for (i = 0; i < array.size(); ++i) {
                res.getDocument().add(this.parseCapabilityStatementCapabilityStatementDocumentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(json.get("releaseDate").getAsString()));
        }
        if (json.has("_releaseDate")) {
            this.parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.parseCapabilityStatementCapabilityStatementImplementationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
        this.parseCapabilityStatementCapabilityStatementRestComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("security")) {
            res.setSecurity(this.parseCapabilityStatementCapabilityStatementRestSecurityComponent(json.getAsJsonObject("security"), owner));
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCapabilityStatementCapabilityStatementRestResourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatementSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatementCapabilityStatementRestOperationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                res.getCompartment().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_compartment")) {
            array = json.getAsJsonArray("_compartment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCompartment().size()) {
                    res.getCompartment().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("cors")) {
            res.setCorsElement(this.parseBoolean(json.get("cors").getAsBoolean()));
        }
        if (json.has("_cors")) {
            this.parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
        }
        if (json.has("service")) {
            array = json.getAsJsonArray("service");
            for (i = 0; i < array.size(); ++i) {
                res.getService().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("certificate")) {
            array = json.getAsJsonArray("certificate");
            for (i = 0; i < array.size(); ++i) {
                res.getCertificate().add(this.parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res = new CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent();
        this.parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("blob")) {
            res.setBlobElement(this.parseBase64Binary(json.get("blob").getAsString()));
        }
        if (json.has("_blob")) {
            this.parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatementResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
        }
        if (json.has("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(json.get("readHistory").getAsBoolean()));
        }
        if (json.has("_readHistory")) {
            this.parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
        }
        if (json.has("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(json.get("updateCreate").getAsBoolean()));
        }
        if (json.has("_updateCreate")) {
            this.parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
        }
        if (json.has("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(json.get("conditionalCreate").getAsBoolean()));
        }
        if (json.has("_conditionalCreate")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
        }
        if (json.has("conditionalRead")) {
            res.setConditionalReadElement(this.parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
        }
        if (json.has("_conditionalRead")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalRead"), res.getConditionalReadElement());
        }
        if (json.has("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
        }
        if (json.has("_conditionalUpdate")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
        }
        if (json.has("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
        }
        if (json.has("_conditionalDelete")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
        }
        if (json.has("referencePolicy")) {
            array = json.getAsJsonArray("referencePolicy");
            for (i = 0; i < array.size(); ++i) {
                res.getReferencePolicy().add(this.parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
            }
        }
        if (json.has("_referencePolicy")) {
            array = json.getAsJsonArray("_referencePolicy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getReferencePolicy().size()) {
                    res.getReferencePolicy().add(this.parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getReferencePolicy().get(i));
            }
        }
        if (json.has("searchInclude")) {
            array = json.getAsJsonArray("searchInclude");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchInclude")) {
            array = json.getAsJsonArray("_searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchInclude().size()) {
                    res.getSearchInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
            }
        }
        if (json.has("searchRevInclude")) {
            array = json.getAsJsonArray("searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchRevInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchRevInclude")) {
            array = json.getAsJsonArray("_searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchRevInclude().size()) {
                    res.getSearchRevInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
        this.parseCapabilityStatementResourceInteractionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseUri(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
        this.parseCapabilityStatementSystemInteractionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestOperationComponent parseCapabilityStatementCapabilityStatementRestOperationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestOperationComponent res = new CapabilityStatement.CapabilityStatementRestOperationComponent();
        this.parseCapabilityStatementCapabilityStatementRestOperationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementRestOperationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.parseCapabilityStatementCapabilityStatementMessagingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(json.get("reliableCache").getAsString()));
        }
        if (json.has("_reliableCache")) {
            this.parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("supportedMessage")) {
            array = json.getAsJsonArray("supportedMessage");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportedMessage().add(this.parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCapabilityStatementCapabilityStatementMessagingEventComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("protocol")) {
            res.setProtocol(this.parseCoding(json.getAsJsonObject("protocol")));
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUri(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        this.parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingEventComponent parseCapabilityStatementCapabilityStatementMessagingEventComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEventComponent res = new CapabilityStatement.CapabilityStatementMessagingEventComponent();
        this.parseCapabilityStatementCapabilityStatementMessagingEventComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementMessagingEventComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEventComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), CapabilityStatement.MessageSignificanceCategory.NULL, new CapabilityStatement.MessageSignificanceCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("focus")) {
            res.setFocusElement(this.parseCode(json.get("focus").getAsString()));
        }
        if (json.has("_focus")) {
            this.parseElementProperties(json.getAsJsonObject("_focus"), res.getFocusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.parseCapabilityStatementCapabilityStatementDocumentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCapabilityStatementCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
    }

    protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseCarePlanProperties(json, res);
        return res;
    }

    protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i = 0; i < array.size(); ++i) {
                res.getDefinition().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i = 0; i < array.size(); ++i) {
                res.getReplaces().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            array = json.getAsJsonArray("activity");
            for (i = 0; i < array.size(); ++i) {
                res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseCarePlanCarePlanActivityComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCarePlanCarePlanActivityComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("outcomeCodeableConcept")) {
            array = json.getAsJsonArray("outcomeCodeableConcept");
            for (i = 0; i < array.size(); ++i) {
                res.getOutcomeCodeableConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcomeReference")) {
            array = json.getAsJsonArray("outcomeReference");
            for (i = 0; i < array.size(); ++i) {
                res.getOutcomeReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("progress")) {
            array = json.getAsJsonArray("progress");
            for (i = 0; i < array.size(); ++i) {
                res.getProgress().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("detail")) {
            res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(json.getAsJsonObject("detail"), owner));
        }
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseCarePlanCarePlanActivityDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCarePlanCarePlanActivityDetailComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws IOException, FHIRFormatError {
        Type product;
        Type scheduled;
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReasonElement(this.parseString(json.get("statusReason").getAsString()));
        }
        if (json.has("_statusReason")) {
            this.parseElementProperties(json.getAsJsonObject("_statusReason"), res.getStatusReasonElement());
        }
        if (json.has("prohibited")) {
            res.setProhibitedElement(this.parseBoolean(json.get("prohibited").getAsBoolean()));
        }
        if (json.has("_prohibited")) {
            this.parseElementProperties(json.getAsJsonObject("_prohibited"), res.getProhibitedElement());
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getPerformer().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("dailyAmount")) {
            res.setDailyAmount(this.parseSimpleQuantity(json.getAsJsonObject("dailyAmount")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
    }

    protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseCareTeamProperties(json, res);
        return res;
    }

    protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseCareTeamCareTeamParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("managingOrganization")) {
            array = json.getAsJsonArray("managingOrganization");
            for (i = 0; i < array.size(); ++i) {
                res.getManagingOrganization().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(JsonObject json, CareTeam owner) throws IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseCareTeamCareTeamParticipantComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCareTeamCareTeamParticipantComponentProperties(JsonObject json, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(json.getAsJsonObject("member")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItem res = new ChargeItem();
        this.parseChargeItemProperties(json, res);
        return res;
    }

    protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
        int i;
        Type occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDefinition().add(this.parseUri(array.get(i2).getAsString()));
            }
        }
        if (json.has("_definition")) {
            array = json.getAsJsonArray("_definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getDefinition().size()) {
                    res.getDefinition().add(this.parseUri(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getDefinition().get(i2));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPartOf().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("participant")) {
            JsonArray array2 = json.getAsJsonArray("participant");
            for (i = 0; i < array2.size(); ++i) {
                res.getParticipant().add(this.parseChargeItemChargeItemParticipantComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("performingOrganization")) {
            res.setPerformingOrganization(this.parseReference(json.getAsJsonObject("performingOrganization")));
        }
        if (json.has("requestingOrganization")) {
            res.setRequestingOrganization(this.parseReference(json.getAsJsonObject("requestingOrganization")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("bodysite")) {
            JsonArray array3 = json.getAsJsonArray("bodysite");
            for (i = 0; i < array3.size(); ++i) {
                res.getBodysite().add(this.parseCodeableConcept(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("factorOverride")) {
            res.setFactorOverrideElement(this.parseDecimal(json.get("factorOverride").getAsBigDecimal()));
        }
        if (json.has("_factorOverride")) {
            this.parseElementProperties(json.getAsJsonObject("_factorOverride"), res.getFactorOverrideElement());
        }
        if (json.has("priceOverride")) {
            res.setPriceOverride(this.parseMoney(json.getAsJsonObject("priceOverride")));
        }
        if (json.has("overrideReason")) {
            res.setOverrideReasonElement(this.parseString(json.get("overrideReason").getAsString()));
        }
        if (json.has("_overrideReason")) {
            this.parseElementProperties(json.getAsJsonObject("_overrideReason"), res.getOverrideReasonElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("enteredDate")) {
            res.setEnteredDateElement(this.parseDateTime(json.get("enteredDate").getAsString()));
        }
        if (json.has("_enteredDate")) {
            this.parseElementProperties(json.getAsJsonObject("_enteredDate"), res.getEnteredDateElement());
        }
        if (json.has("reason")) {
            JsonArray array4 = json.getAsJsonArray("reason");
            for (i = 0; i < array4.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("service")) {
            JsonArray array5 = json.getAsJsonArray("service");
            for (i = 0; i < array5.size(); ++i) {
                res.getService().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("account")) {
            JsonArray array6 = json.getAsJsonArray("account");
            for (i = 0; i < array6.size(); ++i) {
                res.getAccount().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array7 = json.getAsJsonArray("note");
            for (i = 0; i < array7.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInformation")) {
            JsonArray array8 = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array8.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
    }

    protected ChargeItem.ChargeItemParticipantComponent parseChargeItemChargeItemParticipantComponent(JsonObject json, ChargeItem owner) throws IOException, FHIRFormatError {
        ChargeItem.ChargeItemParticipantComponent res = new ChargeItem.ChargeItemParticipantComponent();
        this.parseChargeItemChargeItemParticipantComponentProperties(json, owner, res);
        return res;
    }

    protected void parseChargeItemChargeItemParticipantComponentProperties(JsonObject json, ChargeItem owner, ChargeItem.ChargeItemParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
    }

    protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseClaimProperties(json, res);
        return res;
    }

    protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            array = json.getAsJsonArray("subType");
            for (i = 0; i < array.size(); ++i) {
                res.getSubType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(json.getAsJsonObject("billablePeriod")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(json.getAsJsonObject("insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(json.getAsJsonObject("fundsReserve")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseClaimRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(json.getAsJsonObject("prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(json.getAsJsonObject("originalPrescription")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(json.getAsJsonObject("payee"), res));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(json.getAsJsonObject("referral")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(json.getAsJsonObject("facility")));
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseClaimCareTeamComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("information")) {
            array = json.getAsJsonArray("information");
            for (i = 0; i < array.size(); ++i) {
                res.getInformation().add(this.parseClaimSpecialConditionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseClaimProcedureComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("insurance")) {
            array = json.getAsJsonArray("insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseClaimInsuranceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("accident")) {
            res.setAccident(this.parseClaimAccidentComponent(json.getAsJsonObject("accident"), res));
        }
        if (json.has("employmentImpacted")) {
            res.setEmploymentImpacted(this.parsePeriod(json.getAsJsonObject("employmentImpacted")));
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parsePeriod(json.getAsJsonObject("hospitalization")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(json.getAsJsonObject("total")));
        }
    }

    protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
        this.parseClaimRelatedClaimComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim owner, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("claim")) {
            res.setClaim(this.parseReference(json.getAsJsonObject("claim")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(json.getAsJsonObject("reference")));
        }
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseClaimPayeeComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimPayeeComponentProperties(JsonObject json, Claim owner, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("resourceType")) {
            res.setResourceType(this.parseCoding(json.getAsJsonObject("resourceType")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
    }

    protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.CareTeamComponent res = new Claim.CareTeamComponent();
        this.parseClaimCareTeamComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim owner, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseBoolean(json.get("responsible").getAsBoolean()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("qualification")) {
            res.setQualification(this.parseCodeableConcept(json.getAsJsonObject("qualification")));
        }
    }

    protected Claim.SpecialConditionComponent parseClaimSpecialConditionComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.SpecialConditionComponent res = new Claim.SpecialConditionComponent();
        this.parseClaimSpecialConditionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimSpecialConditionComponentProperties(JsonObject json, Claim owner, Claim.SpecialConditionComponent res) throws IOException, FHIRFormatError {
        Type value;
        Type timing;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseClaimDiagnosisComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim owner, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
        Type diagnosis;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if ((diagnosis = this.parseType("diagnosis", json)) != null) {
            res.setDiagnosis(diagnosis);
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(json.getAsJsonObject("packageCode")));
        }
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseClaimProcedureComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimProcedureComponentProperties(JsonObject json, Claim owner, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
        Type procedure;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
    }

    protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.InsuranceComponent res = new Claim.InsuranceComponent();
        this.parseClaimInsuranceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim owner, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
    }

    protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.AccidentComponent res = new Claim.AccidentComponent();
        this.parseClaimAccidentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimAccidentComponentProperties(JsonObject json, Claim owner, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
        Type location;
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
    }

    protected Claim.ItemComponent parseClaimItemComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.ItemComponent res = new Claim.ItemComponent();
        this.parseClaimItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimItemComponentProperties(JsonObject json, Claim owner, Claim.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type location;
        Type serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("careTeamLinkId")) {
            array2 = json.getAsJsonArray("careTeamLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCareTeamLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_careTeamLinkId")) {
            array2 = json.getAsJsonArray("_careTeamLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getCareTeamLinkId().size()) {
                    res.getCareTeamLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getCareTeamLinkId().get(i2));
            }
        }
        if (json.has("diagnosisLinkId")) {
            array2 = json.getAsJsonArray("diagnosisLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisLinkId")) {
            array2 = json.getAsJsonArray("_diagnosisLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDiagnosisLinkId().size()) {
                    res.getDiagnosisLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getDiagnosisLinkId().get(i2));
            }
        }
        if (json.has("procedureLinkId")) {
            array2 = json.getAsJsonArray("procedureLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProcedureLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_procedureLinkId")) {
            array2 = json.getAsJsonArray("_procedureLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getProcedureLinkId().size()) {
                    res.getProcedureLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getProcedureLinkId().get(i2));
            }
        }
        if (json.has("informationLinkId")) {
            array2 = json.getAsJsonArray("informationLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getInformationLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_informationLinkId")) {
            array2 = json.getAsJsonArray("_informationLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInformationLinkId().size()) {
                    res.getInformationLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInformationLinkId().get(i2));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array2 = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array2 = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            array = json.getAsJsonArray("encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseClaimDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimDetailComponentProperties(JsonObject json, Claim owner, Claim.DetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseClaimSubDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim owner, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseClaimResponseProperties(json, res);
        return res;
    }

    protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(json.getAsJsonObject("insurer")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("payeeType")) {
            res.setPayeeType(this.parseCodeableConcept(json.getAsJsonObject("payeeType")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimResponseItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseClaimResponseErrorComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("totalCost")) {
            res.setTotalCost(this.parseMoney(json.getAsJsonObject("totalCost")));
        }
        if (json.has("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(json.getAsJsonObject("unallocDeductable")));
        }
        if (json.has("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(json.getAsJsonObject("totalBenefit")));
        }
        if (json.has("payment")) {
            res.setPayment(this.parseClaimResponsePaymentComponent(json.getAsJsonObject("payment"), res));
        }
        if (json.has("reserved")) {
            res.setReserved(this.parseCoding(json.getAsJsonObject("reserved")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("processNote")) {
            array = json.getAsJsonArray("processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseClaimResponseNoteComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("communicationRequest")) {
            array = json.getAsJsonArray("communicationRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunicationRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("insurance")) {
            array = json.getAsJsonArray("insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseClaimResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
        this.parseClaimResponseItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
        this.parseClaimResponseAdjudicationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseClaimResponseItemDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseClaimResponseSubDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseClaimResponseAddedItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            array = json.getAsJsonArray("sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getSequenceLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_sequenceLinkId")) {
            array = json.getAsJsonArray("_sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSequenceLinkId().size()) {
                    res.getSequenceLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
        this.parseClaimResponseAddedItemsDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseAddedItemsDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemsDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
        this.parseClaimResponseErrorComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("detailSequenceLinkId")) {
            res.setDetailSequenceLinkIdElement(this.parsePositiveInt(json.get("detailSequenceLinkId").getAsString()));
        }
        if (json.has("_detailSequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_detailSequenceLinkId"), res.getDetailSequenceLinkIdElement());
        }
        if (json.has("subdetailSequenceLinkId")) {
            res.setSubdetailSequenceLinkIdElement(this.parsePositiveInt(json.get("subdetailSequenceLinkId").getAsString()));
        }
        if (json.has("_subdetailSequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_subdetailSequenceLinkId"), res.getSubdetailSequenceLinkIdElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
    }

    protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
        this.parseClaimResponsePaymentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("adjustment")) {
            res.setAdjustment(this.parseMoney(json.getAsJsonObject("adjustment")));
        }
        if (json.has("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
    }

    protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
        this.parseClaimResponseNoteComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(json.getAsJsonObject("language")));
        }
    }

    protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
        this.parseClaimResponseInsuranceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
    }

    protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseClinicalImpressionProperties(json, res);
        return res;
    }

    protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
        int i;
        Type effective;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("assessor")) {
            res.setAssessor(this.parseReference(json.getAsJsonObject("assessor")));
        }
        if (json.has("previous")) {
            res.setPrevious(this.parseReference(json.getAsJsonObject("previous")));
        }
        if (json.has("problem")) {
            JsonArray array = json.getAsJsonArray("problem");
            for (i = 0; i < array.size(); ++i) {
                res.getProblem().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("investigation")) {
            JsonArray array = json.getAsJsonArray("investigation");
            for (i = 0; i < array.size(); ++i) {
                res.getInvestigation().add(this.parseClinicalImpressionClinicalImpressionInvestigationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("protocol")) {
            JsonArray array = json.getAsJsonArray("protocol");
            for (i = 0; i < array.size(); ++i) {
                res.getProtocol().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_protocol")) {
            JsonArray array = json.getAsJsonArray("_protocol");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProtocol().size()) {
                    res.getProtocol().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProtocol().get(i));
            }
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseString(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
        }
        if (json.has("finding")) {
            JsonArray array = json.getAsJsonArray("finding");
            for (i = 0; i < array.size(); ++i) {
                res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("prognosisCodeableConcept")) {
            JsonArray array = json.getAsJsonArray("prognosisCodeableConcept");
            for (i = 0; i < array.size(); ++i) {
                res.getPrognosisCodeableConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prognosisReference")) {
            JsonArray array = json.getAsJsonArray("prognosisReference");
            for (i = 0; i < array.size(); ++i) {
                res.getPrognosisReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        this.parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseClinicalImpressionClinicalImpressionFindingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseClinicalImpressionClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
        if (json.has("basis")) {
            res.setBasisElement(this.parseString(json.get("basis").getAsString()));
        }
        if (json.has("_basis")) {
            this.parseElementProperties(json.getAsJsonObject("_basis"), res.getBasisElement());
        }
    }

    protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseCodeSystemProperties(json, res);
        return res;
    }

    protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(json.get("caseSensitive").getAsBoolean()));
        }
        if (json.has("_caseSensitive")) {
            this.parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseUri(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
        }
        if (json.has("hierarchyMeaning")) {
            res.setHierarchyMeaningElement(this.parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
        }
        if (json.has("_hierarchyMeaning")) {
            this.parseElementProperties(json.getAsJsonObject("_hierarchyMeaning"), res.getHierarchyMeaningElement());
        }
        if (json.has("compositional")) {
            res.setCompositionalElement(this.parseBoolean(json.get("compositional").getAsBoolean()));
        }
        if (json.has("_compositional")) {
            this.parseElementProperties(json.getAsJsonObject("_compositional"), res.getCompositionalElement());
        }
        if (json.has("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(json.get("versionNeeded").getAsBoolean()));
        }
        if (json.has("_versionNeeded")) {
            this.parseElementProperties(json.getAsJsonObject("_versionNeeded"), res.getVersionNeededElement());
        }
        if (json.has("content")) {
            res.setContentElement(this.parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseUnsignedInt(json.get("count").getAsString()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("filter")) {
            array = json.getAsJsonArray("filter");
            for (i = 0; i < array.size(); ++i) {
                res.getFilter().add(this.parseCodeSystemCodeSystemFilterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemPropertyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseCodeSystemCodeSystemFilterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCodeSystemCodeSystemFilterComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("operator")) {
            array = json.getAsJsonArray("operator");
            for (i = 0; i < array.size(); ++i) {
                res.getOperator().add(this.parseEnumeration(array.get(i).getAsString(), CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
            }
        }
        if (json.has("_operator")) {
            array = json.getAsJsonArray("_operator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOperator().size()) {
                    res.getOperator().add(this.parseEnumeration(null, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
            }
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
    }

    protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
        this.parseCodeSystemPropertyComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseCodeSystemConceptDefinitionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseString(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("designation")) {
            array = json.getAsJsonArray("designation");
            for (i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemConceptPropertyComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseCodeSystemConceptDefinitionDesignationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
    }

    protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
        this.parseCodeSystemConceptPropertyComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
        Type value;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseCommunicationProperties(json, res);
        return res;
    }

    protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i = 0; i < array.size(); ++i) {
                res.getDefinition().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("notDone")) {
            res.setNotDoneElement(this.parseBoolean(json.get("notDone").getAsBoolean()));
        }
        if (json.has("_notDone")) {
            this.parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
        }
        if (json.has("notDoneReason")) {
            res.setNotDoneReason(this.parseCodeableConcept(json.getAsJsonObject("notDoneReason")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("sent")) {
            res.setSentElement(this.parseDateTime(json.get("sent").getAsString()));
        }
        if (json.has("_sent")) {
            this.parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
        }
        if (json.has("received")) {
            res.setReceivedElement(this.parseDateTime(json.get("received").getAsString()));
        }
        if (json.has("_received")) {
            this.parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json, Communication owner) throws IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseCommunicationCommunicationPayloadComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCommunicationCommunicationPayloadComponentProperties(JsonObject json, Communication owner, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseCommunicationRequestProperties(json, res);
        return res;
    }

    protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
        int i;
        Type occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReplaces().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(json.getAsJsonObject("groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRecipient().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTopic().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("requester")) {
            res.setRequester(this.parseCommunicationRequestCommunicationRequestRequesterComponent(json.getAsJsonObject("requester"), res));
        }
        if (json.has("reasonCode")) {
            JsonArray array2 = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array2.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            JsonArray array3 = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array3.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array4 = json.getAsJsonArray("note");
            for (i = 0; i < array4.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array4.get(i).getAsJsonObject()));
            }
        }
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseCommunicationRequestCommunicationRequestPayloadComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCommunicationRequestCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected CommunicationRequest.CommunicationRequestRequesterComponent parseCommunicationRequestCommunicationRequestRequesterComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestRequesterComponent res = new CommunicationRequest.CommunicationRequestRequesterComponent();
        this.parseCommunicationRequestCommunicationRequestRequesterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCommunicationRequestCommunicationRequestRequesterComponentProperties(JsonObject json, CommunicationRequest owner, CommunicationRequest.CommunicationRequestRequesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("agent")) {
            res.setAgent(this.parseReference(json.getAsJsonObject("agent")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseCompartmentDefinitionProperties(json, res);
        return res;
    }

    protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("search")) {
            res.setSearchElement(this.parseBoolean(json.get("search").getAsBoolean()));
        }
        if (json.has("_search")) {
            this.parseElementProperties(json.getAsJsonObject("_search"), res.getSearchElement());
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCompartmentDefinitionCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("param")) {
            array = json.getAsJsonArray("param");
            for (i = 0; i < array.size(); ++i) {
                res.getParam().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_param")) {
            array = json.getAsJsonArray("_param");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getParam().size()) {
                    res.getParam().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
    }

    protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseCompositionProperties(json, res);
        return res;
    }

    protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(json.getAsJsonObject("class")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("confidentiality")) {
            res.setConfidentialityElement(this.parseEnumeration(json.get("confidentiality").getAsString(), Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
        }
        if (json.has("_confidentiality")) {
            this.parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
        }
        if (json.has("attester")) {
            array = json.getAsJsonArray("attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(json.getAsJsonObject("custodian")));
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseCompositionCompositionRelatesToComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseCompositionCompositionAttesterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCompositionCompositionAttesterComponentProperties(JsonObject json, Composition owner, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            array = json.getAsJsonArray("mode");
            for (i = 0; i < array.size(); ++i) {
                res.getMode().add(this.parseEnumeration(array.get(i).getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
            }
        }
        if (json.has("_mode")) {
            array = json.getAsJsonArray("_mode");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMode().size()) {
                    res.getMode().add(this.parseEnumeration(null, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getMode().get(i));
            }
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
    }

    protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
        this.parseCompositionCompositionRelatesToComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCompositionCompositionRelatesToComponentProperties(JsonObject json, Composition owner, Composition.CompositionRelatesToComponent res) throws IOException, FHIRFormatError {
        Type target;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseCompositionCompositionEventComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCompositionCompositionEventComponentProperties(JsonObject json, Composition owner, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseCompositionSectionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCompositionSectionComponentProperties(JsonObject json, Composition owner, Composition.SectionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(json.getAsJsonObject("text")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(json.getAsJsonObject("orderedBy")));
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(json.getAsJsonObject("emptyReason")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseConceptMapProperties(json, res);
        return res;
    }

    protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
        Type target;
        Type source;
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if (json.has("group")) {
            JsonArray array2 = json.getAsJsonArray("group");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getGroup().add(this.parseConceptMapConceptMapGroupComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
    }

    protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
        this.parseConceptMapConceptMapGroupComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConceptMapConceptMapGroupComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("sourceVersion")) {
            res.setSourceVersionElement(this.parseString(json.get("sourceVersion").getAsString()));
        }
        if (json.has("_sourceVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceVersion"), res.getSourceVersionElement());
        }
        if (json.has("target")) {
            res.setTargetElement(this.parseUri(json.get("target").getAsString()));
        }
        if (json.has("_target")) {
            this.parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
        }
        if (json.has("targetVersion")) {
            res.setTargetVersionElement(this.parseString(json.get("targetVersion").getAsString()));
        }
        if (json.has("_targetVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_targetVersion"), res.getTargetVersionElement());
        }
        if (json.has("element")) {
            JsonArray array = json.getAsJsonArray("element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("unmapped")) {
            res.setUnmapped(this.parseConceptMapConceptMapGroupUnmappedComponent(json.getAsJsonObject("unmapped"), owner));
        }
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseConceptMapSourceElementComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("target")) {
            JsonArray array = json.getAsJsonArray("target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseConceptMapTargetElementComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("equivalence")) {
            res.setEquivalenceElement(this.parseEnumeration(json.get("equivalence").getAsString(), Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
        }
        if (json.has("_equivalence")) {
            this.parseElementProperties(json.getAsJsonObject("_equivalence"), res.getEquivalenceElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("dependsOn")) {
            array = json.getAsJsonArray("dependsOn");
            for (i = 0; i < array.size(); ++i) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("product")) {
            array = json.getAsJsonArray("product");
            for (i = 0; i < array.size(); ++i) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseConceptMapOtherElementComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("property")) {
            res.setPropertyElement(this.parseUri(json.get("property").getAsString()));
        }
        if (json.has("_property")) {
            this.parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseString(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
    }

    protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
        this.parseConceptMapConceptMapGroupUnmappedComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConceptMapConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
    }

    protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseConditionProperties(json, res);
        return res;
    }

    protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type abatement;
        Type onset;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatusElement(this.parseEnumeration(json.get("clinicalStatus").getAsString(), Condition.ConditionClinicalStatus.NULL, new Condition.ConditionClinicalStatusEnumFactory()));
        }
        if (json.has("_clinicalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatusElement(this.parseEnumeration(json.get("verificationStatus").getAsString(), Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
        }
        if (json.has("_verificationStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
        }
        if (json.has("category")) {
            array2 = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(json.getAsJsonObject("severity")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("bodySite")) {
            array2 = json.getAsJsonArray("bodySite");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBodySite().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if ((abatement = this.parseType("abatement", json)) != null) {
            res.setAbatement(abatement);
        }
        if (json.has("assertedDate")) {
            res.setAssertedDateElement(this.parseDateTime(json.get("assertedDate").getAsString()));
        }
        if (json.has("_assertedDate")) {
            this.parseElementProperties(json.getAsJsonObject("_assertedDate"), res.getAssertedDateElement());
        }
        if (json.has("asserter")) {
            res.setAsserter(this.parseReference(json.getAsJsonObject("asserter")));
        }
        if (json.has("stage")) {
            res.setStage(this.parseConditionConditionStageComponent(json.getAsJsonObject("stage"), res));
        }
        if (json.has("evidence")) {
            array = json.getAsJsonArray("evidence");
            for (i = 0; i < array.size(); ++i) {
                res.getEvidence().add(this.parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseConditionConditionStageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConditionConditionStageComponentProperties(JsonObject json, Condition owner, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("summary")) {
            res.setSummary(this.parseCodeableConcept(json.getAsJsonObject("summary")));
        }
        if (json.has("assessment")) {
            JsonArray array = json.getAsJsonArray("assessment");
            for (int i = 0; i < array.size(); ++i) {
                res.getAssessment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseConditionConditionEvidenceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConditionConditionEvidenceComponentProperties(JsonObject json, Condition owner, Condition.ConditionEvidenceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
        Consent res = new Consent();
        this.parseConsentProperties(json, res);
        return res;
    }

    protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
        int i;
        Type source;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("consentingParty")) {
            array = json.getAsJsonArray("consentingParty");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getConsentingParty().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getActor().add(this.parseConsentConsentActorComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAction().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("organization")) {
            array = json.getAsJsonArray("organization");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getOrganization().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if (json.has("policy")) {
            JsonArray array2 = json.getAsJsonArray("policy");
            for (i = 0; i < array2.size(); ++i) {
                res.getPolicy().add(this.parseConsentConsentPolicyComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("policyRule")) {
            res.setPolicyRuleElement(this.parseUri(json.get("policyRule").getAsString()));
        }
        if (json.has("_policyRule")) {
            this.parseElementProperties(json.getAsJsonObject("_policyRule"), res.getPolicyRuleElement());
        }
        if (json.has("securityLabel")) {
            JsonArray array3 = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array3.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            JsonArray array4 = json.getAsJsonArray("purpose");
            for (i = 0; i < array4.size(); ++i) {
                res.getPurpose().add(this.parseCoding(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(json.getAsJsonObject("dataPeriod")));
        }
        if (json.has("data")) {
            JsonArray array5 = json.getAsJsonArray("data");
            for (i = 0; i < array5.size(); ++i) {
                res.getData().add(this.parseConsentConsentDataComponent(array5.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("except")) {
            JsonArray array6 = json.getAsJsonArray("except");
            for (i = 0; i < array6.size(); ++i) {
                res.getExcept().add(this.parseConsentExceptComponent(array6.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Consent.ConsentActorComponent parseConsentConsentActorComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
        Consent.ConsentActorComponent res = new Consent.ConsentActorComponent();
        this.parseConsentConsentActorComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConsentConsentActorComponentProperties(JsonObject json, Consent owner, Consent.ConsentActorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
    }

    protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
        Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
        this.parseConsentConsentPolicyComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConsentConsentPolicyComponentProperties(JsonObject json, Consent owner, Consent.ConsentPolicyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("authority")) {
            res.setAuthorityElement(this.parseUri(json.get("authority").getAsString()));
        }
        if (json.has("_authority")) {
            this.parseElementProperties(json.getAsJsonObject("_authority"), res.getAuthorityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
    }

    protected Consent.ConsentDataComponent parseConsentConsentDataComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
        Consent.ConsentDataComponent res = new Consent.ConsentDataComponent();
        this.parseConsentConsentDataComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConsentConsentDataComponentProperties(JsonObject json, Consent owner, Consent.ConsentDataComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("meaning")) {
            res.setMeaningElement(this.parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
        }
        if (json.has("_meaning")) {
            this.parseElementProperties(json.getAsJsonObject("_meaning"), res.getMeaningElement());
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
    }

    protected Consent.ExceptComponent parseConsentExceptComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
        Consent.ExceptComponent res = new Consent.ExceptComponent();
        this.parseConsentExceptComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConsentExceptComponentProperties(JsonObject json, Consent owner, Consent.ExceptComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Consent.ConsentExceptType.NULL, new Consent.ConsentExceptTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseConsentExceptActorComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            array = json.getAsJsonArray("purpose");
            for (i = 0; i < array.size(); ++i) {
                res.getPurpose().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("class")) {
            array = json.getAsJsonArray("class");
            for (i = 0; i < array.size(); ++i) {
                res.getClass_().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(json.getAsJsonObject("dataPeriod")));
        }
        if (json.has("data")) {
            array = json.getAsJsonArray("data");
            for (i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseConsentExceptDataComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Consent.ExceptActorComponent parseConsentExceptActorComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
        Consent.ExceptActorComponent res = new Consent.ExceptActorComponent();
        this.parseConsentExceptActorComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConsentExceptActorComponentProperties(JsonObject json, Consent owner, Consent.ExceptActorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
    }

    protected Consent.ExceptDataComponent parseConsentExceptDataComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
        Consent.ExceptDataComponent res = new Consent.ExceptDataComponent();
        this.parseConsentExceptDataComponentProperties(json, owner, res);
        return res;
    }

    protected void parseConsentExceptDataComponentProperties(JsonObject json, Consent owner, Consent.ExceptDataComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("meaning")) {
            res.setMeaningElement(this.parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
        }
        if (json.has("_meaning")) {
            this.parseElementProperties(json.getAsJsonObject("_meaning"), res.getMeaningElement());
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
    }

    protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseContractProperties(json, res);
        return res;
    }

    protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
        int i;
        Type binding;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(json.getAsJsonObject("applies")));
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTopic().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("authority")) {
            array = json.getAsJsonArray("authority");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthority().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("domain")) {
            array = json.getAsJsonArray("domain");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDomain().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            array = json.getAsJsonArray("subType");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubType().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAction().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("actionReason")) {
            array = json.getAsJsonArray("actionReason");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getActionReason().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("decisionType")) {
            res.setDecisionType(this.parseCodeableConcept(json.getAsJsonObject("decisionType")));
        }
        if (json.has("contentDerivative")) {
            res.setContentDerivative(this.parseCodeableConcept(json.getAsJsonObject("contentDerivative")));
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAgent().add(this.parseContractAgentComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("signer")) {
            array = json.getAsJsonArray("signer");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSigner().add(this.parseContractSignatoryComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("term")) {
            array = json.getAsJsonArray("term");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTerm().add(this.parseContractTermComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if ((binding = this.parseType("binding", json)) != null) {
            res.setBinding(binding);
        }
        if (json.has("friendly")) {
            JsonArray array2 = json.getAsJsonArray("friendly");
            for (i = 0; i < array2.size(); ++i) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("legal")) {
            JsonArray array3 = json.getAsJsonArray("legal");
            for (i = 0; i < array3.size(); ++i) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("rule")) {
            JsonArray array4 = json.getAsJsonArray("rule");
            for (i = 0; i < array4.size(); ++i) {
                res.getRule().add(this.parseContractComputableLanguageComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Contract.AgentComponent parseContractAgentComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.AgentComponent res = new Contract.AgentComponent();
        this.parseContractAgentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractAgentComponentProperties(JsonObject json, Contract owner, Contract.AgentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseContractSignatoryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractSignatoryComponentProperties(JsonObject json, Contract owner, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
        if (json.has("signature")) {
            JsonArray array = json.getAsJsonArray("signature");
            for (int i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseContractValuedItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractValuedItemComponentProperties(JsonObject json, Contract owner, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
    }

    protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseContractTermComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractTermComponentProperties(JsonObject json, Contract owner, Contract.TermComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(json.getAsJsonObject("applies")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(json.getAsJsonObject("subType")));
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actionReason")) {
            array = json.getAsJsonArray("actionReason");
            for (i = 0; i < array.size(); ++i) {
                res.getActionReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseContractTermAgentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i = 0; i < array.size(); ++i) {
                res.getValuedItem().add(this.parseContractTermValuedItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Contract.TermAgentComponent parseContractTermAgentComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermAgentComponent res = new Contract.TermAgentComponent();
        this.parseContractTermAgentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractTermAgentComponentProperties(JsonObject json, Contract owner, Contract.TermAgentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
        this.parseContractTermValuedItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractTermValuedItemComponentProperties(JsonObject json, Contract owner, Contract.TermValuedItemComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseContractFriendlyLanguageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract owner, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseContractLegalLanguageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract owner, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseContractComputableLanguageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract owner, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseCoverageProperties(json, res);
        return res;
    }

    protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("policyHolder")) {
            res.setPolicyHolder(this.parseReference(json.getAsJsonObject("policyHolder")));
        }
        if (json.has("subscriber")) {
            res.setSubscriber(this.parseReference(json.getAsJsonObject("subscriber")));
        }
        if (json.has("subscriberId")) {
            res.setSubscriberIdElement(this.parseString(json.get("subscriberId").getAsString()));
        }
        if (json.has("_subscriberId")) {
            this.parseElementProperties(json.getAsJsonObject("_subscriberId"), res.getSubscriberIdElement());
        }
        if (json.has("beneficiary")) {
            res.setBeneficiary(this.parseReference(json.getAsJsonObject("beneficiary")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("payor")) {
            array = json.getAsJsonArray("payor");
            for (i = 0; i < array.size(); ++i) {
                res.getPayor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("grouping")) {
            res.setGrouping(this.parseCoverageGroupComponent(json.getAsJsonObject("grouping"), res));
        }
        if (json.has("dependent")) {
            res.setDependentElement(this.parseString(json.get("dependent").getAsString()));
        }
        if (json.has("_dependent")) {
            this.parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
        }
        if (json.has("sequence")) {
            res.setSequenceElement(this.parseString(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("order")) {
            res.setOrderElement(this.parsePositiveInt(json.get("order").getAsString()));
        }
        if (json.has("_order")) {
            this.parseElementProperties(json.getAsJsonObject("_order"), res.getOrderElement());
        }
        if (json.has("network")) {
            res.setNetworkElement(this.parseString(json.get("network").getAsString()));
        }
        if (json.has("_network")) {
            this.parseElementProperties(json.getAsJsonObject("_network"), res.getNetworkElement());
        }
        if (json.has("contract")) {
            array = json.getAsJsonArray("contract");
            for (i = 0; i < array.size(); ++i) {
                res.getContract().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Coverage.GroupComponent parseCoverageGroupComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
        Coverage.GroupComponent res = new Coverage.GroupComponent();
        this.parseCoverageGroupComponentProperties(json, owner, res);
        return res;
    }

    protected void parseCoverageGroupComponentProperties(JsonObject json, Coverage owner, Coverage.GroupComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("group")) {
            res.setGroupElement(this.parseString(json.get("group").getAsString()));
        }
        if (json.has("_group")) {
            this.parseElementProperties(json.getAsJsonObject("_group"), res.getGroupElement());
        }
        if (json.has("groupDisplay")) {
            res.setGroupDisplayElement(this.parseString(json.get("groupDisplay").getAsString()));
        }
        if (json.has("_groupDisplay")) {
            this.parseElementProperties(json.getAsJsonObject("_groupDisplay"), res.getGroupDisplayElement());
        }
        if (json.has("subGroup")) {
            res.setSubGroupElement(this.parseString(json.get("subGroup").getAsString()));
        }
        if (json.has("_subGroup")) {
            this.parseElementProperties(json.getAsJsonObject("_subGroup"), res.getSubGroupElement());
        }
        if (json.has("subGroupDisplay")) {
            res.setSubGroupDisplayElement(this.parseString(json.get("subGroupDisplay").getAsString()));
        }
        if (json.has("_subGroupDisplay")) {
            this.parseElementProperties(json.getAsJsonObject("_subGroupDisplay"), res.getSubGroupDisplayElement());
        }
        if (json.has("plan")) {
            res.setPlanElement(this.parseString(json.get("plan").getAsString()));
        }
        if (json.has("_plan")) {
            this.parseElementProperties(json.getAsJsonObject("_plan"), res.getPlanElement());
        }
        if (json.has("planDisplay")) {
            res.setPlanDisplayElement(this.parseString(json.get("planDisplay").getAsString()));
        }
        if (json.has("_planDisplay")) {
            this.parseElementProperties(json.getAsJsonObject("_planDisplay"), res.getPlanDisplayElement());
        }
        if (json.has("subPlan")) {
            res.setSubPlanElement(this.parseString(json.get("subPlan").getAsString()));
        }
        if (json.has("_subPlan")) {
            this.parseElementProperties(json.getAsJsonObject("_subPlan"), res.getSubPlanElement());
        }
        if (json.has("subPlanDisplay")) {
            res.setSubPlanDisplayElement(this.parseString(json.get("subPlanDisplay").getAsString()));
        }
        if (json.has("_subPlanDisplay")) {
            this.parseElementProperties(json.getAsJsonObject("_subPlanDisplay"), res.getSubPlanDisplayElement());
        }
        if (json.has("class")) {
            res.setClass_Element(this.parseString(json.get("class").getAsString()));
        }
        if (json.has("_class")) {
            this.parseElementProperties(json.getAsJsonObject("_class"), res.getClass_Element());
        }
        if (json.has("classDisplay")) {
            res.setClassDisplayElement(this.parseString(json.get("classDisplay").getAsString()));
        }
        if (json.has("_classDisplay")) {
            this.parseElementProperties(json.getAsJsonObject("_classDisplay"), res.getClassDisplayElement());
        }
        if (json.has("subClass")) {
            res.setSubClassElement(this.parseString(json.get("subClass").getAsString()));
        }
        if (json.has("_subClass")) {
            this.parseElementProperties(json.getAsJsonObject("_subClass"), res.getSubClassElement());
        }
        if (json.has("subClassDisplay")) {
            res.setSubClassDisplayElement(this.parseString(json.get("subClassDisplay").getAsString()));
        }
        if (json.has("_subClassDisplay")) {
            this.parseElementProperties(json.getAsJsonObject("_subClassDisplay"), res.getSubClassDisplayElement());
        }
    }

    protected DataElement parseDataElement(JsonObject json) throws IOException, FHIRFormatError {
        DataElement res = new DataElement();
        this.parseDataElementProperties(json, res);
        return res;
    }

    protected void parseDataElementProperties(JsonObject json, DataElement res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("stringency")) {
            res.setStringencyElement(this.parseEnumeration(json.get("stringency").getAsString(), DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
        }
        if (json.has("_stringency")) {
            this.parseElementProperties(json.getAsJsonObject("_stringency"), res.getStringencyElement());
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseDataElementDataElementMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("element")) {
            array = json.getAsJsonArray("element");
            for (i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(JsonObject json, DataElement owner) throws IOException, FHIRFormatError {
        DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
        this.parseDataElementDataElementMappingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDataElementDataElementMappingComponentProperties(JsonObject json, DataElement owner, DataElement.DataElementMappingComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
    }

    protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDetectedIssueProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("implicated")) {
            array = json.getAsJsonArray("implicated");
            for (i = 0; i < array.size(); ++i) {
                res.getImplicated().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            res.setDetailElement(this.parseString(json.get("detail").getAsString()));
        }
        if (json.has("_detail")) {
            this.parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("mitigation")) {
            array = json.getAsJsonArray("mitigation");
            for (i = 0; i < array.size(); ++i) {
                res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseDetectedIssueDetectedIssueMitigationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDetectedIssueDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(json.getAsJsonObject("action")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
    }

    protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDeviceProperties(json, res);
        return res;
    }

    protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("udi")) {
            res.setUdi(this.parseDeviceDeviceUdiComponent(json.getAsJsonObject("udi"), res));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturerElement(this.parseString(json.get("manufacturer").getAsString()));
        }
        if (json.has("_manufacturer")) {
            this.parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
        }
        if (json.has("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(json.get("manufactureDate").getAsString()));
        }
        if (json.has("_manufactureDate")) {
            this.parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("model")) {
            res.setModelElement(this.parseString(json.get("model").getAsString()));
        }
        if (json.has("_model")) {
            this.parseElementProperties(json.getAsJsonObject("_model"), res.getModelElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("safety")) {
            array = json.getAsJsonArray("safety");
            for (i = 0; i < array.size(); ++i) {
                res.getSafety().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Device.DeviceUdiComponent parseDeviceDeviceUdiComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
        Device.DeviceUdiComponent res = new Device.DeviceUdiComponent();
        this.parseDeviceDeviceUdiComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDeviceDeviceUdiComponentProperties(JsonObject json, Device owner, Device.DeviceUdiComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(json.get("deviceIdentifier").getAsString()));
        }
        if (json.has("_deviceIdentifier")) {
            this.parseElementProperties(json.getAsJsonObject("_deviceIdentifier"), res.getDeviceIdentifierElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(json.get("jurisdiction").getAsString()));
        }
        if (json.has("_jurisdiction")) {
            this.parseElementProperties(json.getAsJsonObject("_jurisdiction"), res.getJurisdictionElement());
        }
        if (json.has("carrierHRF")) {
            res.setCarrierHRFElement(this.parseString(json.get("carrierHRF").getAsString()));
        }
        if (json.has("_carrierHRF")) {
            this.parseElementProperties(json.getAsJsonObject("_carrierHRF"), res.getCarrierHRFElement());
        }
        if (json.has("carrierAIDC")) {
            res.setCarrierAIDCElement(this.parseBase64Binary(json.get("carrierAIDC").getAsString()));
        }
        if (json.has("_carrierAIDC")) {
            this.parseElementProperties(json.getAsJsonObject("_carrierAIDC"), res.getCarrierAIDCElement());
        }
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseUri(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(json.getAsJsonObject("_issuer"), res.getIssuerElement());
        }
        if (json.has("entryType")) {
            res.setEntryTypeElement(this.parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
        }
        if (json.has("_entryType")) {
            this.parseElementProperties(json.getAsJsonObject("_entryType"), res.getEntryTypeElement());
        }
    }

    protected DeviceComponent parseDeviceComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceComponent res = new DeviceComponent();
        this.parseDeviceComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceComponentProperties(JsonObject json, DeviceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("lastSystemChange")) {
            res.setLastSystemChangeElement(this.parseInstant(json.get("lastSystemChange").getAsString()));
        }
        if (json.has("_lastSystemChange")) {
            this.parseElementProperties(json.getAsJsonObject("_lastSystemChange"), res.getLastSystemChangeElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("operationalStatus")) {
            array = json.getAsJsonArray("operationalStatus");
            for (i = 0; i < array.size(); ++i) {
                res.getOperationalStatus().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parameterGroup")) {
            res.setParameterGroup(this.parseCodeableConcept(json.getAsJsonObject("parameterGroup")));
        }
        if (json.has("measurementPrinciple")) {
            res.setMeasurementPrincipleElement(this.parseEnumeration(json.get("measurementPrinciple").getAsString(), DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
        }
        if (json.has("_measurementPrinciple")) {
            this.parseElementProperties(json.getAsJsonObject("_measurementPrinciple"), res.getMeasurementPrincipleElement());
        }
        if (json.has("productionSpecification")) {
            array = json.getAsJsonArray("productionSpecification");
            for (i = 0; i < array.size(); ++i) {
                res.getProductionSpecification().add(this.parseDeviceComponentDeviceComponentProductionSpecificationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("languageCode")) {
            res.setLanguageCode(this.parseCodeableConcept(json.getAsJsonObject("languageCode")));
        }
    }

    protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(JsonObject json, DeviceComponent owner) throws IOException, FHIRFormatError {
        DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        this.parseDeviceComponentDeviceComponentProductionSpecificationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDeviceComponentDeviceComponentProductionSpecificationComponentProperties(JsonObject json, DeviceComponent owner, DeviceComponent.DeviceComponentProductionSpecificationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("specType")) {
            res.setSpecType(this.parseCodeableConcept(json.getAsJsonObject("specType")));
        }
        if (json.has("componentId")) {
            res.setComponentId(this.parseIdentifier(json.getAsJsonObject("componentId")));
        }
        if (json.has("productionSpec")) {
            res.setProductionSpecElement(this.parseString(json.get("productionSpec").getAsString()));
        }
        if (json.has("_productionSpec")) {
            this.parseElementProperties(json.getAsJsonObject("_productionSpec"), res.getProductionSpecElement());
        }
    }

    protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDeviceMetricProperties(json, res);
        return res;
    }

    protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(json.getAsJsonObject("unit")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        }
        if (json.has("_operationalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
        }
        if (json.has("color")) {
            res.setColorElement(this.parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(json.getAsJsonObject("measurementPeriod")));
        }
        if (json.has("calibration")) {
            JsonArray array = json.getAsJsonArray("calibration");
            for (int i = 0; i < array.size(); ++i) {
                res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseDeviceMetricDeviceMetricCalibrationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDeviceMetricDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseInstant(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
    }

    protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
        DeviceRequest res = new DeviceRequest();
        this.parseDeviceRequestProperties(json, res);
        return res;
    }

    protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type occurrence;
        Type code;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array2 = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array2 = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("priorRequest")) {
            array2 = json.getAsJsonArray("priorRequest");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getPriorRequest().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(json.getAsJsonObject("groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntent(this.parseCodeableConcept(json.getAsJsonObject("intent")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if ((code = this.parseType("code", json)) != null) {
            res.setCode(code);
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseDeviceRequestDeviceRequestRequesterComponent(json.getAsJsonObject("requester"), res));
        }
        if (json.has("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(json.getAsJsonObject("performerType")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relevantHistory")) {
            array = json.getAsJsonArray("relevantHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceRequest.DeviceRequestRequesterComponent parseDeviceRequestDeviceRequestRequesterComponent(JsonObject json, DeviceRequest owner) throws IOException, FHIRFormatError {
        DeviceRequest.DeviceRequestRequesterComponent res = new DeviceRequest.DeviceRequestRequesterComponent();
        this.parseDeviceRequestDeviceRequestRequesterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDeviceRequestDeviceRequestRequesterComponentProperties(JsonObject json, DeviceRequest owner, DeviceRequest.DeviceRequestRequesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("agent")) {
            res.setAgent(this.parseReference(json.getAsJsonObject("agent")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDeviceUseStatementProperties(json, res);
        return res;
    }

    protected void parseDeviceUseStatementProperties(JsonObject json, DeviceUseStatement res) throws IOException, FHIRFormatError {
        int i;
        Type timing;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("whenUsed")) {
            res.setWhenUsed(this.parsePeriod(json.getAsJsonObject("whenUsed")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(json.get("recordedOn").getAsString()));
        }
        if (json.has("_recordedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("indication")) {
            JsonArray array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDiagnosticReportProperties(json, res);
        return res;
    }

    protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
        int i;
        Type effective;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (i = 0; i < array2.size(); ++i) {
                res.getPerformer().add(this.parseDiagnosticReportDiagnosticReportPerformerComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("specimen")) {
            JsonArray array3 = json.getAsJsonArray("specimen");
            for (i = 0; i < array3.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("result")) {
            JsonArray array4 = json.getAsJsonArray("result");
            for (i = 0; i < array4.size(); ++i) {
                res.getResult().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("imagingStudy")) {
            JsonArray array5 = json.getAsJsonArray("imagingStudy");
            for (i = 0; i < array5.size(); ++i) {
                res.getImagingStudy().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("image")) {
            JsonArray array6 = json.getAsJsonArray("image");
            for (i = 0; i < array6.size(); ++i) {
                res.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(array6.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("conclusion")) {
            res.setConclusionElement(this.parseString(json.get("conclusion").getAsString()));
        }
        if (json.has("_conclusion")) {
            this.parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
        }
        if (json.has("codedDiagnosis")) {
            JsonArray array7 = json.getAsJsonArray("codedDiagnosis");
            for (i = 0; i < array7.size(); ++i) {
                res.getCodedDiagnosis().add(this.parseCodeableConcept(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("presentedForm")) {
            JsonArray array8 = json.getAsJsonArray("presentedForm");
            for (i = 0; i < array8.size(); ++i) {
                res.getPresentedForm().add(this.parseAttachment(array8.get(i).getAsJsonObject()));
            }
        }
    }

    protected DiagnosticReport.DiagnosticReportPerformerComponent parseDiagnosticReportDiagnosticReportPerformerComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportPerformerComponent res = new DiagnosticReport.DiagnosticReportPerformerComponent();
        this.parseDiagnosticReportDiagnosticReportPerformerComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDiagnosticReportDiagnosticReportPerformerComponentProperties(JsonObject json, DiagnosticReport owner, DiagnosticReport.DiagnosticReportPerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
    }

    protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseDiagnosticReportDiagnosticReportImageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDiagnosticReportDiagnosticReportImageComponentProperties(JsonObject json, DiagnosticReport owner, DiagnosticReport.DiagnosticReportImageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("link")) {
            res.setLink(this.parseReference(json.getAsJsonObject("link")));
        }
    }

    protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseDocumentManifestProperties(json, res);
        return res;
    }

    protected void parseDocumentManifestProperties(JsonObject json, DocumentManifest res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(json.getAsJsonObject("masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentManifestDocumentManifestContentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
        this.parseDocumentManifestDocumentManifestContentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDocumentManifestDocumentManifestContentComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestContentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type p = this.parseType("p", json);
        if (p != null) {
            res.setP(p);
        }
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseDocumentManifestDocumentManifestRelatedComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDocumentManifestDocumentManifestRelatedComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(json.getAsJsonObject("ref")));
        }
    }

    protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDocumentReferenceProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(json.getAsJsonObject("masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("docStatus")) {
            res.setDocStatusElement(this.parseEnumeration(json.get("docStatus").getAsString(), DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
        }
        if (json.has("_docStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_docStatus"), res.getDocStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(json.getAsJsonObject("class")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("indexed")) {
            res.setIndexedElement(this.parseInstant(json.get("indexed").getAsString()));
        }
        if (json.has("_indexed")) {
            this.parseElementProperties(json.getAsJsonObject("_indexed"), res.getIndexedElement());
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("authenticator")) {
            res.setAuthenticator(this.parseReference(json.getAsJsonObject("authenticator")));
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(json.getAsJsonObject("custodian")));
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(json.getAsJsonObject("context"), res));
        }
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseDocumentReferenceDocumentReferenceContentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDocumentReferenceDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("attachment")) {
            res.setAttachment(this.parseAttachment(json.getAsJsonObject("attachment")));
        }
        if (json.has("format")) {
            res.setFormat(this.parseCoding(json.getAsJsonObject("format")));
        }
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseDocumentReferenceDocumentReferenceContextComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDocumentReferenceDocumentReferenceContextComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(json.getAsJsonObject("facilityType")));
        }
        if (json.has("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
        }
        if (json.has("sourcePatientInfo")) {
            res.setSourcePatientInfo(this.parseReference(json.getAsJsonObject("sourcePatientInfo")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentReferenceDocumentReferenceContextRelatedComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.parseDocumentReferenceDocumentReferenceContextRelatedComponentProperties(json, owner, res);
        return res;
    }

    protected void parseDocumentReferenceDocumentReferenceContextRelatedComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContextRelatedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(json.getAsJsonObject("ref")));
        }
    }

    protected EligibilityRequest parseEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
        EligibilityRequest res = new EligibilityRequest();
        this.parseEligibilityRequestProperties(json, res);
        return res;
    }

    protected void parseEligibilityRequestProperties(JsonObject json, EligibilityRequest res) throws IOException, FHIRFormatError {
        Type serviced;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EligibilityRequest.EligibilityRequestStatus.NULL, new EligibilityRequest.EligibilityRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(json.getAsJsonObject("insurer")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(json.getAsJsonObject("facility")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("benefitCategory")) {
            res.setBenefitCategory(this.parseCodeableConcept(json.getAsJsonObject("benefitCategory")));
        }
        if (json.has("benefitSubCategory")) {
            res.setBenefitSubCategory(this.parseCodeableConcept(json.getAsJsonObject("benefitSubCategory")));
        }
    }

    protected EligibilityResponse parseEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
        EligibilityResponse res = new EligibilityResponse();
        this.parseEligibilityResponseProperties(json, res);
        return res;
    }

    protected void parseEligibilityResponseProperties(JsonObject json, EligibilityResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EligibilityResponse.EligibilityResponseStatus.NULL, new EligibilityResponse.EligibilityResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(json.getAsJsonObject("insurer")));
        }
        if (json.has("inforce")) {
            res.setInforceElement(this.parseBoolean(json.get("inforce").getAsBoolean()));
        }
        if (json.has("_inforce")) {
            this.parseElementProperties(json.getAsJsonObject("_inforce"), res.getInforceElement());
        }
        if (json.has("insurance")) {
            array = json.getAsJsonArray("insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseEligibilityResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected EligibilityResponse.InsuranceComponent parseEligibilityResponseInsuranceComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        EligibilityResponse.InsuranceComponent res = new EligibilityResponse.InsuranceComponent();
        this.parseEligibilityResponseInsuranceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEligibilityResponseInsuranceComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("contract")) {
            res.setContract(this.parseReference(json.getAsJsonObject("contract")));
        }
        if (json.has("benefitBalance")) {
            JsonArray array = json.getAsJsonArray("benefitBalance");
            for (int i = 0; i < array.size(); ++i) {
                res.getBenefitBalance().add(this.parseEligibilityResponseBenefitsComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
        this.parseEligibilityResponseBenefitsComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEligibilityResponseBenefitsComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.BenefitsComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("subCategory")) {
            res.setSubCategory(this.parseCodeableConcept(json.getAsJsonObject("subCategory")));
        }
        if (json.has("excluded")) {
            res.setExcludedElement(this.parseBoolean(json.get("excluded").getAsBoolean()));
        }
        if (json.has("_excluded")) {
            this.parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(json.getAsJsonObject("network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(json.getAsJsonObject("unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(json.getAsJsonObject("term")));
        }
        if (json.has("financial")) {
            JsonArray array = json.getAsJsonArray("financial");
            for (int i = 0; i < array.size(); ++i) {
                res.getFinancial().add(this.parseEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
        this.parseEligibilityResponseBenefitComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEligibilityResponseBenefitComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
        Type used;
        Type allowed;
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if ((allowed = this.parseType("allowed", json)) != null) {
            res.setAllowed(allowed);
        }
        if ((used = this.parseType("used", json)) != null) {
            res.setUsed(used);
        }
    }

    protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
        this.parseEligibilityResponseErrorsComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEligibilityResponseErrorsComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
    }

    protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseEncounterProperties(json, res);
        return res;
    }

    protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("class")) {
            res.setClass_(this.parseCoding(json.getAsJsonObject("class")));
        }
        if (json.has("classHistory")) {
            array = json.getAsJsonArray("classHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getClassHistory().add(this.parseEncounterClassHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("episodeOfCare")) {
            array = json.getAsJsonArray("episodeOfCare");
            for (i = 0; i < array.size(); ++i) {
                res.getEpisodeOfCare().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("incomingReferral")) {
            array = json.getAsJsonArray("incomingReferral");
            for (i = 0; i < array.size(); ++i) {
                res.getIncomingReferral().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(json.getAsJsonObject("appointment")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("length")) {
            res.setLength(this.parseDuration(json.getAsJsonObject("length")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseEncounterDiagnosisComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("account")) {
            array = json.getAsJsonArray("account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization"), res));
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("serviceProvider")) {
            res.setServiceProvider(this.parseReference(json.getAsJsonObject("serviceProvider")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
    }

    protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
        this.parseEncounterStatusHistoryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEncounterStatusHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.StatusHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
        this.parseEncounterClassHistoryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEncounterClassHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.ClassHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("class")) {
            res.setClass_(this.parseCoding(json.getAsJsonObject("class")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseEncounterEncounterParticipantComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEncounterEncounterParticipantComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("individual")) {
            res.setIndividual(this.parseReference(json.getAsJsonObject("individual")));
        }
    }

    protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
        this.parseEncounterDiagnosisComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter owner, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("condition")) {
            res.setCondition(this.parseReference(json.getAsJsonObject("condition")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
        }
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseEncounterEncounterHospitalizationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEncounterEncounterHospitalizationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
        }
        if (json.has("origin")) {
            res.setOrigin(this.parseReference(json.getAsJsonObject("origin")));
        }
        if (json.has("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(json.getAsJsonObject("admitSource")));
        }
        if (json.has("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(json.getAsJsonObject("reAdmission")));
        }
        if (json.has("dietPreference")) {
            array = json.getAsJsonArray("dietPreference");
            for (i = 0; i < array.size(); ++i) {
                res.getDietPreference().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialCourtesy")) {
            array = json.getAsJsonArray("specialCourtesy");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialArrangement")) {
            array = json.getAsJsonArray("specialArrangement");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
        }
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseEncounterEncounterLocationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEncounterEncounterLocationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
        Endpoint res = new Endpoint();
        this.parseEndpointProperties(json, res);
        return res;
    }

    protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("connectionType")) {
            res.setConnectionType(this.parseCoding(json.getAsJsonObject("connectionType")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("payloadType")) {
            array = json.getAsJsonArray("payloadType");
            for (i = 0; i < array.size(); ++i) {
                res.getPayloadType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payloadMimeType")) {
            array = json.getAsJsonArray("payloadMimeType");
            for (i = 0; i < array.size(); ++i) {
                res.getPayloadMimeType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_payloadMimeType")) {
            array = json.getAsJsonArray("_payloadMimeType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPayloadMimeType().size()) {
                    res.getPayloadMimeType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPayloadMimeType().get(i));
            }
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUri(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
        if (json.has("header")) {
            array = json.getAsJsonArray("header");
            for (i = 0; i < array.size(); ++i) {
                res.getHeader().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_header")) {
            array = json.getAsJsonArray("_header");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getHeader().size()) {
                    res.getHeader().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
            }
        }
    }

    protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseEnrollmentRequestProperties(json, res);
        return res;
    }

    protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(json.getAsJsonObject("insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
    }

    protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseEnrollmentResponseProperties(json, res);
        return res;
    }

    protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
    }

    protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseEpisodeOfCareProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseEpisodeOfCareDiagnosisComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("referralRequest")) {
            array = json.getAsJsonArray("referralRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careManager")) {
            res.setCareManager(this.parseReference(json.getAsJsonObject("careManager")));
        }
        if (json.has("team")) {
            array = json.getAsJsonArray("team");
            for (i = 0; i < array.size(); ++i) {
                res.getTeam().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("account")) {
            array = json.getAsJsonArray("account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
        EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
        this.parseEpisodeOfCareDiagnosisComponentProperties(json, owner, res);
        return res;
    }

    protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("condition")) {
            res.setCondition(this.parseReference(json.getAsJsonObject("condition")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
        }
    }

    protected ExpansionProfile parseExpansionProfile(JsonObject json) throws IOException, FHIRFormatError {
        ExpansionProfile res = new ExpansionProfile();
        this.parseExpansionProfileProperties(json, res);
        return res;
    }

    protected void parseExpansionProfileProperties(JsonObject json, ExpansionProfile res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fixedVersion")) {
            array = json.getAsJsonArray("fixedVersion");
            for (i = 0; i < array.size(); ++i) {
                res.getFixedVersion().add(this.parseExpansionProfileExpansionProfileFixedVersionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("excludedSystem")) {
            res.setExcludedSystem(this.parseExpansionProfileExpansionProfileExcludedSystemComponent(json.getAsJsonObject("excludedSystem"), res));
        }
        if (json.has("includeDesignations")) {
            res.setIncludeDesignationsElement(this.parseBoolean(json.get("includeDesignations").getAsBoolean()));
        }
        if (json.has("_includeDesignations")) {
            this.parseElementProperties(json.getAsJsonObject("_includeDesignations"), res.getIncludeDesignationsElement());
        }
        if (json.has("designation")) {
            res.setDesignation(this.parseExpansionProfileExpansionProfileDesignationComponent(json.getAsJsonObject("designation"), res));
        }
        if (json.has("includeDefinition")) {
            res.setIncludeDefinitionElement(this.parseBoolean(json.get("includeDefinition").getAsBoolean()));
        }
        if (json.has("_includeDefinition")) {
            this.parseElementProperties(json.getAsJsonObject("_includeDefinition"), res.getIncludeDefinitionElement());
        }
        if (json.has("activeOnly")) {
            res.setActiveOnlyElement(this.parseBoolean(json.get("activeOnly").getAsBoolean()));
        }
        if (json.has("_activeOnly")) {
            this.parseElementProperties(json.getAsJsonObject("_activeOnly"), res.getActiveOnlyElement());
        }
        if (json.has("excludeNested")) {
            res.setExcludeNestedElement(this.parseBoolean(json.get("excludeNested").getAsBoolean()));
        }
        if (json.has("_excludeNested")) {
            this.parseElementProperties(json.getAsJsonObject("_excludeNested"), res.getExcludeNestedElement());
        }
        if (json.has("excludeNotForUI")) {
            res.setExcludeNotForUIElement(this.parseBoolean(json.get("excludeNotForUI").getAsBoolean()));
        }
        if (json.has("_excludeNotForUI")) {
            this.parseElementProperties(json.getAsJsonObject("_excludeNotForUI"), res.getExcludeNotForUIElement());
        }
        if (json.has("excludePostCoordinated")) {
            res.setExcludePostCoordinatedElement(this.parseBoolean(json.get("excludePostCoordinated").getAsBoolean()));
        }
        if (json.has("_excludePostCoordinated")) {
            this.parseElementProperties(json.getAsJsonObject("_excludePostCoordinated"), res.getExcludePostCoordinatedElement());
        }
        if (json.has("displayLanguage")) {
            res.setDisplayLanguageElement(this.parseCode(json.get("displayLanguage").getAsString()));
        }
        if (json.has("_displayLanguage")) {
            this.parseElementProperties(json.getAsJsonObject("_displayLanguage"), res.getDisplayLanguageElement());
        }
        if (json.has("limitedExpansion")) {
            res.setLimitedExpansionElement(this.parseBoolean(json.get("limitedExpansion").getAsBoolean()));
        }
        if (json.has("_limitedExpansion")) {
            this.parseElementProperties(json.getAsJsonObject("_limitedExpansion"), res.getLimitedExpansionElement());
        }
    }

    protected ExpansionProfile.ExpansionProfileFixedVersionComponent parseExpansionProfileExpansionProfileFixedVersionComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileFixedVersionComponent res = new ExpansionProfile.ExpansionProfileFixedVersionComponent();
        this.parseExpansionProfileExpansionProfileFixedVersionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileExpansionProfileFixedVersionComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.ExpansionProfileFixedVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), ExpansionProfile.SystemVersionProcessingMode.NULL, new ExpansionProfile.SystemVersionProcessingModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
    }

    protected ExpansionProfile.ExpansionProfileExcludedSystemComponent parseExpansionProfileExpansionProfileExcludedSystemComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileExcludedSystemComponent res = new ExpansionProfile.ExpansionProfileExcludedSystemComponent();
        this.parseExpansionProfileExpansionProfileExcludedSystemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileExpansionProfileExcludedSystemComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.ExpansionProfileExcludedSystemComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
    }

    protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
        this.parseExpansionProfileExpansionProfileDesignationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileExpansionProfileDesignationComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.ExpansionProfileDesignationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("include")) {
            res.setInclude(this.parseExpansionProfileDesignationIncludeComponent(json.getAsJsonObject("include"), owner));
        }
        if (json.has("exclude")) {
            res.setExclude(this.parseExpansionProfileDesignationExcludeComponent(json.getAsJsonObject("exclude"), owner));
        }
    }

    protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
        this.parseExpansionProfileDesignationIncludeComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileDesignationIncludeComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationIncludeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("designation")) {
            JsonArray array = json.getAsJsonArray("designation");
            for (int i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseExpansionProfileDesignationIncludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
        this.parseExpansionProfileDesignationIncludeDesignationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileDesignationIncludeDesignationComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationIncludeDesignationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
    }

    protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
        this.parseExpansionProfileDesignationExcludeComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileDesignationExcludeComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationExcludeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("designation")) {
            JsonArray array = json.getAsJsonArray("designation");
            for (int i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseExpansionProfileDesignationExcludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
        this.parseExpansionProfileDesignationExcludeDesignationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExpansionProfileDesignationExcludeDesignationComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationExcludeDesignationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseExplanationOfBenefitProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            array = json.getAsJsonArray("subType");
            for (i = 0; i < array.size(); ++i) {
                res.getSubType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(json.getAsJsonObject("billablePeriod")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(json.getAsJsonObject("insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(json.getAsJsonObject("referral")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(json.getAsJsonObject("facility")));
        }
        if (json.has("claim")) {
            res.setClaim(this.parseReference(json.getAsJsonObject("claim")));
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(json.getAsJsonObject("prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(json.getAsJsonObject("originalPrescription")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(json.getAsJsonObject("payee"), res));
        }
        if (json.has("information")) {
            array = json.getAsJsonArray("information");
            for (i = 0; i < array.size(); ++i) {
                res.getInformation().add(this.parseExplanationOfBenefitSupportingInformationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseExplanationOfBenefitCareTeamComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(json.get("precedence").getAsString()));
        }
        if (json.has("_precedence")) {
            this.parseElementProperties(json.getAsJsonObject("_precedence"), res.getPrecedenceElement());
        }
        if (json.has("insurance")) {
            res.setInsurance(this.parseExplanationOfBenefitInsuranceComponent(json.getAsJsonObject("insurance"), res));
        }
        if (json.has("accident")) {
            res.setAccident(this.parseExplanationOfBenefitAccidentComponent(json.getAsJsonObject("accident"), res));
        }
        if (json.has("employmentImpacted")) {
            res.setEmploymentImpacted(this.parsePeriod(json.getAsJsonObject("employmentImpacted")));
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parsePeriod(json.getAsJsonObject("hospitalization")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseExplanationOfBenefitItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("totalCost")) {
            res.setTotalCost(this.parseMoney(json.getAsJsonObject("totalCost")));
        }
        if (json.has("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(json.getAsJsonObject("unallocDeductable")));
        }
        if (json.has("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(json.getAsJsonObject("totalBenefit")));
        }
        if (json.has("payment")) {
            res.setPayment(this.parseExplanationOfBenefitPaymentComponent(json.getAsJsonObject("payment"), res));
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("processNote")) {
            array = json.getAsJsonArray("processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseExplanationOfBenefitNoteComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("benefitBalance")) {
            array = json.getAsJsonArray("benefitBalance");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
        this.parseExplanationOfBenefitRelatedClaimComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("claim")) {
            res.setClaim(this.parseReference(json.getAsJsonObject("claim")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(json.getAsJsonObject("reference")));
        }
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseExplanationOfBenefitPayeeComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("resourceType")) {
            res.setResourceType(this.parseCodeableConcept(json.getAsJsonObject("resourceType")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
    }

    protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
        this.parseExplanationOfBenefitSupportingInformationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        Type value;
        Type timing;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
    }

    protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
        this.parseExplanationOfBenefitCareTeamComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseBoolean(json.get("responsible").getAsBoolean()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("qualification")) {
            res.setQualification(this.parseCodeableConcept(json.getAsJsonObject("qualification")));
        }
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseExplanationOfBenefitDiagnosisComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
        Type diagnosis;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if ((diagnosis = this.parseType("diagnosis", json)) != null) {
            res.setDiagnosis(diagnosis);
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(json.getAsJsonObject("packageCode")));
        }
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseExplanationOfBenefitProcedureComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
        Type procedure;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
    }

    protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
        this.parseExplanationOfBenefitInsuranceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
    }

    protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
        this.parseExplanationOfBenefitAccidentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
        Type location;
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
    }

    protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
        this.parseExplanationOfBenefitItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type location;
        Type serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("careTeamLinkId")) {
            array2 = json.getAsJsonArray("careTeamLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCareTeamLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_careTeamLinkId")) {
            array2 = json.getAsJsonArray("_careTeamLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getCareTeamLinkId().size()) {
                    res.getCareTeamLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getCareTeamLinkId().get(i2));
            }
        }
        if (json.has("diagnosisLinkId")) {
            array2 = json.getAsJsonArray("diagnosisLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisLinkId")) {
            array2 = json.getAsJsonArray("_diagnosisLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDiagnosisLinkId().size()) {
                    res.getDiagnosisLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getDiagnosisLinkId().get(i2));
            }
        }
        if (json.has("procedureLinkId")) {
            array2 = json.getAsJsonArray("procedureLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProcedureLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_procedureLinkId")) {
            array2 = json.getAsJsonArray("_procedureLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getProcedureLinkId().size()) {
                    res.getProcedureLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getProcedureLinkId().get(i2));
            }
        }
        if (json.has("informationLinkId")) {
            array2 = json.getAsJsonArray("informationLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getInformationLinkId().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_informationLinkId")) {
            array2 = json.getAsJsonArray("_informationLinkId");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInformationLinkId().size()) {
                    res.getInformationLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInformationLinkId().get(i2));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array2 = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array2 = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            array = json.getAsJsonArray("encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
        this.parseExplanationOfBenefitAdjudicationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseExplanationOfBenefitDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseExplanationOfBenefitSubDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseExplanationOfBenefitAddedItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            array = json.getAsJsonArray("sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getSequenceLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_sequenceLinkId")) {
            array = json.getAsJsonArray("_sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSequenceLinkId().size()) {
                    res.getSequenceLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemsDetailComponent parseExplanationOfBenefitAddedItemsDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemsDetailComponent res = new ExplanationOfBenefit.AddedItemsDetailComponent();
        this.parseExplanationOfBenefitAddedItemsDetailComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemsDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemsDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(json.getAsJsonObject("revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("service")) {
            res.setService(this.parseCodeableConcept(json.getAsJsonObject("service")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
        this.parseExplanationOfBenefitPaymentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("adjustment")) {
            res.setAdjustment(this.parseMoney(json.getAsJsonObject("adjustment")));
        }
        if (json.has("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
    }

    protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
        this.parseExplanationOfBenefitNoteComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(json.getAsJsonObject("language")));
        }
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseExplanationOfBenefitBenefitBalanceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("subCategory")) {
            res.setSubCategory(this.parseCodeableConcept(json.getAsJsonObject("subCategory")));
        }
        if (json.has("excluded")) {
            res.setExcludedElement(this.parseBoolean(json.get("excluded").getAsBoolean()));
        }
        if (json.has("_excluded")) {
            this.parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(json.getAsJsonObject("network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(json.getAsJsonObject("unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(json.getAsJsonObject("term")));
        }
        if (json.has("financial")) {
            JsonArray array = json.getAsJsonArray("financial");
            for (int i = 0; i < array.size(); ++i) {
                res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseExplanationOfBenefitBenefitComponentProperties(json, owner, res);
        return res;
    }

    protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
        Type used;
        Type allowed;
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if ((allowed = this.parseType("allowed", json)) != null) {
            res.setAllowed(allowed);
        }
        if ((used = this.parseType("used", json)) != null) {
            res.setUsed(used);
        }
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseFamilyMemberHistoryProperties(json, res);
        return res;
    }

    protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type deceased;
        Type age;
        Type born;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array2 = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("notDone")) {
            res.setNotDoneElement(this.parseBoolean(json.get("notDone").getAsBoolean()));
        }
        if (json.has("_notDone")) {
            this.parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
        }
        if (json.has("notDoneReason")) {
            res.setNotDoneReason(this.parseCodeableConcept(json.getAsJsonObject("notDoneReason")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if ((born = this.parseType("born", json)) != null) {
            res.setBorn(born);
        }
        if ((age = this.parseType("age", json)) != null) {
            res.setAge(age);
        }
        if (json.has("estimatedAge")) {
            res.setEstimatedAgeElement(this.parseBoolean(json.get("estimatedAge").getAsBoolean()));
        }
        if (json.has("_estimatedAge")) {
            this.parseElementProperties(json.getAsJsonObject("_estimatedAge"), res.getEstimatedAgeElement());
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
        Type onset;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseFlagProperties(json, res);
        return res;
    }

    protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
    }

    protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseGoalProperties(json, res);
        return res;
    }

    protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
        int i;
        Type start;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("description")) {
            res.setDescription(this.parseCodeableConcept(json.getAsJsonObject("description")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((start = this.parseType("start", json)) != null) {
            res.setStart(start);
        }
        if (json.has("target")) {
            res.setTarget(this.parseGoalGoalTargetComponent(json.getAsJsonObject("target"), res));
        }
        if (json.has("statusDate")) {
            res.setStatusDateElement(this.parseDate(json.get("statusDate").getAsString()));
        }
        if (json.has("_statusDate")) {
            this.parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReasonElement(this.parseString(json.get("statusReason").getAsString()));
        }
        if (json.has("_statusReason")) {
            this.parseElementProperties(json.getAsJsonObject("_statusReason"), res.getStatusReasonElement());
        }
        if (json.has("expressedBy")) {
            res.setExpressedBy(this.parseReference(json.getAsJsonObject("expressedBy")));
        }
        if (json.has("addresses")) {
            JsonArray array2 = json.getAsJsonArray("addresses");
            for (i = 0; i < array2.size(); ++i) {
                res.getAddresses().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array3 = json.getAsJsonArray("note");
            for (i = 0; i < array3.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcomeCode")) {
            JsonArray array4 = json.getAsJsonArray("outcomeCode");
            for (i = 0; i < array4.size(); ++i) {
                res.getOutcomeCode().add(this.parseCodeableConcept(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcomeReference")) {
            JsonArray array5 = json.getAsJsonArray("outcomeReference");
            for (i = 0; i < array5.size(); ++i) {
                res.getOutcomeReference().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
    }

    protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(JsonObject json, Goal owner) throws IOException, FHIRFormatError {
        Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
        this.parseGoalGoalTargetComponentProperties(json, owner, res);
        return res;
    }

    protected void parseGoalGoalTargetComponentProperties(JsonObject json, Goal owner, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
        Type due;
        Type detail;
        this.parseBackboneProperties(json, res);
        if (json.has("measure")) {
            res.setMeasure(this.parseCodeableConcept(json.getAsJsonObject("measure")));
        }
        if ((detail = this.parseType("detail", json)) != null) {
            res.setDetail(detail);
        }
        if ((due = this.parseType("due", json)) != null) {
            res.setDue(due);
        }
    }

    protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
        GraphDefinition res = new GraphDefinition();
        this.parseGraphDefinitionProperties(json, res);
        return res;
    }

    protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseCode(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseUri(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
        this.parseGraphDefinitionGraphDefinitionLinkComponentProperties(json, owner, res);
        return res;
    }

    protected void parseGraphDefinitionGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("sliceName")) {
            res.setSliceNameElement(this.parseString(json.get("sliceName").getAsString()));
        }
        if (json.has("_sliceName")) {
            this.parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("target")) {
            JsonArray array = json.getAsJsonArray("target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseGraphDefinitionGraphDefinitionLinkTargetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        this.parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(json, owner, res);
        return res;
    }

    protected void parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseUri(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                res.getCompartment().add(this.parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        this.parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("rule")) {
            res.setRuleElement(this.parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
        }
        if (json.has("_rule")) {
            this.parseElementProperties(json.getAsJsonObject("_rule"), res.getRuleElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
    }

    protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
        Group res = new Group();
        this.parseGroupProperties(json, res);
        return res;
    }

    protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(json.get("quantity").getAsString()));
        }
        if (json.has("_quantity")) {
            this.parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("member")) {
            array = json.getAsJsonArray("member");
            for (i = 0; i < array.size(); ++i) {
                res.getMember().add(this.parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseGroupGroupCharacteristicComponentProperties(json, owner, res);
        return res;
    }

    protected void parseGroupGroupCharacteristicComponentProperties(JsonObject json, Group owner, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
        Type value;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseGroupGroupMemberComponentProperties(json, owner, res);
        return res;
    }

    protected void parseGroupGroupMemberComponentProperties(JsonObject json, Group owner, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("entity")) {
            res.setEntity(this.parseReference(json.getAsJsonObject("entity")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("inactive")) {
            res.setInactiveElement(this.parseBoolean(json.get("inactive").getAsBoolean()));
        }
        if (json.has("_inactive")) {
            this.parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
        }
    }

    protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
        GuidanceResponse res = new GuidanceResponse();
        this.parseGuidanceResponseProperties(json, res);
        return res;
    }

    protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type reason;
        this.parseDomainResourceProperties(json, res);
        if (json.has("requestId")) {
            res.setRequestIdElement(this.parseId(json.get("requestId").getAsString()));
        }
        if (json.has("_requestId")) {
            this.parseElementProperties(json.getAsJsonObject("_requestId"), res.getRequestIdElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("module")) {
            res.setModule(this.parseReference(json.getAsJsonObject("module")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("occurrenceDateTime")) {
            res.setOccurrenceDateTimeElement(this.parseDateTime(json.get("occurrenceDateTime").getAsString()));
        }
        if (json.has("_occurrenceDateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("evaluationMessage")) {
            array = json.getAsJsonArray("evaluationMessage");
            for (i = 0; i < array.size(); ++i) {
                res.getEvaluationMessage().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outputParameters")) {
            res.setOutputParameters(this.parseReference(json.getAsJsonObject("outputParameters")));
        }
        if (json.has("result")) {
            res.setResult(this.parseReference(json.getAsJsonObject("result")));
        }
        if (json.has("dataRequirement")) {
            array = json.getAsJsonArray("dataRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getDataRequirement().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseHealthcareServiceProperties(json, res);
        return res;
    }

    protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("providedBy")) {
            res.setProvidedBy(this.parseReference(json.getAsJsonObject("providedBy")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("extraDetails")) {
            res.setExtraDetailsElement(this.parseString(json.get("extraDetails").getAsString()));
        }
        if (json.has("_extraDetails")) {
            this.parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(json.getAsJsonObject("photo")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("coverageArea")) {
            array = json.getAsJsonArray("coverageArea");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverageArea().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceProvisionCode")) {
            array = json.getAsJsonArray("serviceProvisionCode");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceProvisionCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("eligibility")) {
            res.setEligibility(this.parseCodeableConcept(json.getAsJsonObject("eligibility")));
        }
        if (json.has("eligibilityNote")) {
            res.setEligibilityNoteElement(this.parseString(json.get("eligibilityNote").getAsString()));
        }
        if (json.has("_eligibilityNote")) {
            this.parseElementProperties(json.getAsJsonObject("_eligibilityNote"), res.getEligibilityNoteElement());
        }
        if (json.has("programName")) {
            array = json.getAsJsonArray("programName");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramName().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_programName")) {
            array = json.getAsJsonArray("_programName");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProgramName().size()) {
                    res.getProgramName().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProgramName().get(i));
            }
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referralMethod")) {
            array = json.getAsJsonArray("referralMethod");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralMethod().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(json.get("appointmentRequired").getAsBoolean()));
        }
        if (json.has("_appointmentRequired")) {
            this.parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
        }
        if (json.has("availableTime")) {
            array = json.getAsJsonArray("availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("notAvailable")) {
            array = json.getAsJsonArray("notAvailable");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(json.get("availabilityExceptions").getAsString()));
        }
        if (json.has("_availabilityExceptions")) {
            this.parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(json, owner, res);
        return res;
    }

    protected void parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = json.getAsJsonArray("daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                res.getDaysOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = json.getAsJsonArray("_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
        }
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(json, owner, res);
        return res;
    }

    protected void parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(json.getAsJsonObject("during")));
        }
    }

    protected ImagingManifest parseImagingManifest(JsonObject json) throws IOException, FHIRFormatError {
        ImagingManifest res = new ImagingManifest();
        this.parseImagingManifestProperties(json, res);
        return res;
    }

    protected void parseImagingManifestProperties(JsonObject json, ImagingManifest res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("authoringTime")) {
            res.setAuthoringTimeElement(this.parseDateTime(json.get("authoringTime").getAsString()));
        }
        if (json.has("_authoringTime")) {
            this.parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("study")) {
            JsonArray array = json.getAsJsonArray("study");
            for (int i = 0; i < array.size(); ++i) {
                res.getStudy().add(this.parseImagingManifestStudyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ImagingManifest.StudyComponent parseImagingManifestStudyComponent(JsonObject json, ImagingManifest owner) throws IOException, FHIRFormatError {
        ImagingManifest.StudyComponent res = new ImagingManifest.StudyComponent();
        this.parseImagingManifestStudyComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImagingManifestStudyComponentProperties(JsonObject json, ImagingManifest owner, ImagingManifest.StudyComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("imagingStudy")) {
            res.setImagingStudy(this.parseReference(json.getAsJsonObject("imagingStudy")));
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("series")) {
            array = json.getAsJsonArray("series");
            for (i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingManifestSeriesComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ImagingManifest.SeriesComponent parseImagingManifestSeriesComponent(JsonObject json, ImagingManifest owner) throws IOException, FHIRFormatError {
        ImagingManifest.SeriesComponent res = new ImagingManifest.SeriesComponent();
        this.parseImagingManifestSeriesComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImagingManifestSeriesComponentProperties(JsonObject json, ImagingManifest owner, ImagingManifest.SeriesComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingManifestInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ImagingManifest.InstanceComponent parseImagingManifestInstanceComponent(JsonObject json, ImagingManifest owner) throws IOException, FHIRFormatError {
        ImagingManifest.InstanceComponent res = new ImagingManifest.InstanceComponent();
        this.parseImagingManifestInstanceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImagingManifestInstanceComponentProperties(JsonObject json, ImagingManifest owner, ImagingManifest.InstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
    }

    protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseImagingStudyProperties(json, res);
        return res;
    }

    protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("accession")) {
            res.setAccession(this.parseIdentifier(json.getAsJsonObject("accession")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (json.has("_availability")) {
            this.parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
        }
        if (json.has("modalityList")) {
            array = json.getAsJsonArray("modalityList");
            for (i = 0; i < array.size(); ++i) {
                res.getModalityList().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referrer")) {
            res.setReferrer(this.parseReference(json.getAsJsonObject("referrer")));
        }
        if (json.has("interpreter")) {
            array = json.getAsJsonArray("interpreter");
            for (i = 0; i < array.size(); ++i) {
                res.getInterpreter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(json.get("numberOfSeries").getAsString()));
        }
        if (json.has("_numberOfSeries")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("procedureReference")) {
            array = json.getAsJsonArray("procedureReference");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedureReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("procedureCode")) {
            array = json.getAsJsonArray("procedureCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedureCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("series")) {
            array = json.getAsJsonArray("series");
            for (i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseImagingStudyImagingStudySeriesComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImagingStudyImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("modality")) {
            res.setModality(this.parseCoding(json.getAsJsonObject("modality")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (json.has("_availability")) {
            this.parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(json.getAsJsonObject("bodySite")));
        }
        if (json.has("laterality")) {
            res.setLaterality(this.parseCoding(json.getAsJsonObject("laterality")));
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
        }
        if (json.has("performer")) {
            array = json.getAsJsonArray("performer");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseImagingStudyImagingStudySeriesInstanceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImagingStudyImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
    }

    protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseImmunizationProperties(json, res);
        return res;
    }

    protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("notGiven")) {
            res.setNotGivenElement(this.parseBoolean(json.get("notGiven").getAsBoolean()));
        }
        if (json.has("_notGiven")) {
            this.parseElementProperties(json.getAsJsonObject("_notGiven"), res.getNotGivenElement());
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("primarySource")) {
            res.setPrimarySourceElement(this.parseBoolean(json.get("primarySource").getAsBoolean()));
        }
        if (json.has("_primarySource")) {
            this.parseElementProperties(json.getAsJsonObject("_primarySource"), res.getPrimarySourceElement());
        }
        if (json.has("reportOrigin")) {
            res.setReportOrigin(this.parseCodeableConcept(json.getAsJsonObject("reportOrigin")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(json.getAsJsonObject("manufacturer")));
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(json.getAsJsonObject("site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("doseQuantity")) {
            res.setDoseQuantity(this.parseSimpleQuantity(json.getAsJsonObject("doseQuantity")));
        }
        if (json.has("practitioner")) {
            array = json.getAsJsonArray("practitioner");
            for (i = 0; i < array.size(); ++i) {
                res.getPractitioner().add(this.parseImmunizationImmunizationPractitionerComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("explanation")) {
            res.setExplanation(this.parseImmunizationImmunizationExplanationComponent(json.getAsJsonObject("explanation"), res));
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("vaccinationProtocol")) {
            array = json.getAsJsonArray("vaccinationProtocol");
            for (i = 0; i < array.size(); ++i) {
                res.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Immunization.ImmunizationPractitionerComponent parseImmunizationImmunizationPractitionerComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationPractitionerComponent res = new Immunization.ImmunizationPractitionerComponent();
        this.parseImmunizationImmunizationPractitionerComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationImmunizationPractitionerComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationPractitionerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
    }

    protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
        this.parseImmunizationImmunizationExplanationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationImmunizationExplanationComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationExplanationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonNotGiven")) {
            array = json.getAsJsonArray("reasonNotGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseImmunizationImmunizationReactionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationImmunizationReactionComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationReactionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("detail")) {
            res.setDetail(this.parseReference(json.getAsJsonObject("detail")));
        }
        if (json.has("reported")) {
            res.setReportedElement(this.parseBoolean(json.get("reported").getAsBoolean()));
        }
        if (json.has("_reported")) {
            this.parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
        }
    }

    protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseImmunizationImmunizationVaccinationProtocolComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationImmunizationVaccinationProtocolComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationVaccinationProtocolComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("doseSequence")) {
            res.setDoseSequenceElement(this.parsePositiveInt(json.get("doseSequence").getAsString()));
        }
        if (json.has("_doseSequence")) {
            this.parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(json.getAsJsonObject("authority")));
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
        }
        if (json.has("seriesDoses")) {
            res.setSeriesDosesElement(this.parsePositiveInt(json.get("seriesDoses").getAsString()));
        }
        if (json.has("_seriesDoses")) {
            this.parseElementProperties(json.getAsJsonObject("_seriesDoses"), res.getSeriesDosesElement());
        }
        if (json.has("targetDisease")) {
            JsonArray array = json.getAsJsonArray("targetDisease");
            for (int i = 0; i < array.size(); ++i) {
                res.getTargetDisease().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(json.getAsJsonObject("doseStatus")));
        }
        if (json.has("doseStatusReason")) {
            res.setDoseStatusReason(this.parseCodeableConcept(json.getAsJsonObject("doseStatusReason")));
        }
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseImmunizationRecommendationProperties(json, res);
        return res;
    }

    protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("recommendation")) {
            array = json.getAsJsonArray("recommendation");
            for (i = 0; i < array.size(); ++i) {
                res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
        }
        if (json.has("targetDisease")) {
            res.setTargetDisease(this.parseCodeableConcept(json.getAsJsonObject("targetDisease")));
        }
        if (json.has("doseNumber")) {
            res.setDoseNumberElement(this.parsePositiveInt(json.get("doseNumber").getAsString()));
        }
        if (json.has("_doseNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_doseNumber"), res.getDoseNumberElement());
        }
        if (json.has("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
        }
        if (json.has("dateCriterion")) {
            array = json.getAsJsonArray("dateCriterion");
            for (i = 0; i < array.size(); ++i) {
                res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("protocol")) {
            res.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(json.getAsJsonObject("protocol"), owner));
        }
        if (json.has("supportingImmunization")) {
            array = json.getAsJsonArray("supportingImmunization");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingImmunization().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingPatientInformation")) {
            array = json.getAsJsonArray("supportingPatientInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingPatientInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDateTime(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("doseSequence")) {
            res.setDoseSequenceElement(this.parsePositiveInt(json.get("doseSequence").getAsString()));
        }
        if (json.has("_doseSequence")) {
            this.parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(json.getAsJsonObject("authority")));
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
        }
    }

    protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseImplementationGuideProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("dependency")) {
            array = json.getAsJsonArray("dependency");
            for (i = 0; i < array.size(); ++i) {
                res.getDependency().add(this.parseImplementationGuideImplementationGuideDependencyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("package")) {
            array = json.getAsJsonArray("package");
            for (i = 0; i < array.size(); ++i) {
                res.getPackage().add(this.parseImplementationGuideImplementationGuidePackageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("global")) {
            array = json.getAsJsonArray("global");
            for (i = 0; i < array.size(); ++i) {
                res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("binary")) {
            array = json.getAsJsonArray("binary");
            for (i = 0; i < array.size(); ++i) {
                res.getBinary().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_binary")) {
            array = json.getAsJsonArray("_binary");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getBinary().size()) {
                    res.getBinary().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getBinary().get(i));
            }
        }
        if (json.has("page")) {
            res.setPage(this.parseImplementationGuideImplementationGuidePageComponent(json.getAsJsonObject("page"), res));
        }
    }

    protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.parseImplementationGuideImplementationGuideDependencyComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImplementationGuideImplementationGuideDependencyComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependencyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
    }

    protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.parseImplementationGuideImplementationGuidePackageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImplementationGuideImplementationGuidePackageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("resource")) {
            JsonArray array = json.getAsJsonArray("resource");
            for (int i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseImplementationGuideImplementationGuidePackageResourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.parseImplementationGuideImplementationGuidePackageResourceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImplementationGuideImplementationGuidePackageResourceComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageResourceComponent res) throws IOException, FHIRFormatError {
        Type source;
        this.parseBackboneProperties(json, res);
        if (json.has("example")) {
            res.setExampleElement(this.parseBoolean(json.get("example").getAsBoolean()));
        }
        if (json.has("_example")) {
            this.parseElementProperties(json.getAsJsonObject("_example"), res.getExampleElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("acronym")) {
            res.setAcronymElement(this.parseString(json.get("acronym").getAsString()));
        }
        if (json.has("_acronym")) {
            this.parseElementProperties(json.getAsJsonObject("_acronym"), res.getAcronymElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if (json.has("exampleFor")) {
            res.setExampleFor(this.parseReference(json.getAsJsonObject("exampleFor")));
        }
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseImplementationGuideImplementationGuideGlobalComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImplementationGuideImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
    }

    protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
        this.parseImplementationGuideImplementationGuidePageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseImplementationGuideImplementationGuidePageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePageComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_type")) {
            array = json.getAsJsonArray("_type");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getType().size()) {
                    res.getType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
            }
        }
        if (json.has("package")) {
            array = json.getAsJsonArray("package");
            for (i = 0; i < array.size(); ++i) {
                res.getPackage().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_package")) {
            array = json.getAsJsonArray("_package");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPackage().size()) {
                    res.getPackage().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPackage().get(i));
            }
        }
        if (json.has("format")) {
            res.setFormatElement(this.parseCode(json.get("format").getAsString()));
        }
        if (json.has("_format")) {
            this.parseElementProperties(json.getAsJsonObject("_format"), res.getFormatElement());
        }
        if (json.has("page")) {
            array = json.getAsJsonArray("page");
            for (i = 0; i < array.size(); ++i) {
                res.getPage().add(this.parseImplementationGuideImplementationGuidePageComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
        Library res = new Library();
        this.parseLibraryProperties(json, res);
        return res;
    }

    protected void parseLibraryProperties(JsonObject json, Library res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(json.getAsJsonObject("effectivePeriod")));
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contributor")) {
            array = json.getAsJsonArray("contributor");
            for (i = 0; i < array.size(); ++i) {
                res.getContributor().add(this.parseContributor(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseParameterDefinition(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dataRequirement")) {
            array = json.getAsJsonArray("dataRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getDataRequirement().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
        Linkage res = new Linkage();
        this.parseLinkageProperties(json, res);
        return res;
    }

    protected void parseLinkageProperties(JsonObject json, Linkage res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseLinkageLinkageItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(JsonObject json, Linkage owner) throws IOException, FHIRFormatError {
        Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
        this.parseLinkageLinkageItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseLinkageLinkageItemComponentProperties(JsonObject json, Linkage owner, Linkage.LinkageItemComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
    }

    protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
        ListResource res = new ListResource();
        this.parseListResourceProperties(json, res);
        return res;
    }

    protected void parseListResourceProperties(JsonObject json, ListResource res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(json.getAsJsonObject("orderedBy")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseListResourceListEntryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(json.getAsJsonObject("emptyReason")));
        }
    }

    protected ListResource.ListEntryComponent parseListResourceListEntryComponent(JsonObject json, ListResource owner) throws IOException, FHIRFormatError {
        ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
        this.parseListResourceListEntryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseListResourceListEntryComponentProperties(JsonObject json, ListResource owner, ListResource.ListEntryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("flag")) {
            res.setFlag(this.parseCodeableConcept(json.getAsJsonObject("flag")));
        }
        if (json.has("deleted")) {
            res.setDeletedElement(this.parseBoolean(json.get("deleted").getAsBoolean()));
        }
        if (json.has("_deleted")) {
            this.parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("item")) {
            res.setItem(this.parseReference(json.getAsJsonObject("item")));
        }
    }

    protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
        Location res = new Location();
        this.parseLocationProperties(json, res);
        return res;
    }

    protected void parseLocationProperties(JsonObject json, Location res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatus(this.parseCoding(json.getAsJsonObject("operationalStatus")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("alias")) {
            array = json.getAsJsonArray("alias");
            for (i = 0; i < array.size(); ++i) {
                res.getAlias().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array = json.getAsJsonArray("_alias");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        if (json.has("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(json.getAsJsonObject("physicalType")));
        }
        if (json.has("position")) {
            res.setPosition(this.parseLocationLocationPositionComponent(json.getAsJsonObject("position"), res));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseLocationLocationPositionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseLocationLocationPositionComponentProperties(JsonObject json, Location owner, Location.LocationPositionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("longitude")) {
            res.setLongitudeElement(this.parseDecimal(json.get("longitude").getAsBigDecimal()));
        }
        if (json.has("_longitude")) {
            this.parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
        }
        if (json.has("latitude")) {
            res.setLatitudeElement(this.parseDecimal(json.get("latitude").getAsBigDecimal()));
        }
        if (json.has("_latitude")) {
            this.parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
        }
        if (json.has("altitude")) {
            res.setAltitudeElement(this.parseDecimal(json.get("altitude").getAsBigDecimal()));
        }
        if (json.has("_altitude")) {
            this.parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
        }
    }

    protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
        Measure res = new Measure();
        this.parseMeasureProperties(json, res);
        return res;
    }

    protected void parseMeasureProperties(JsonObject json, Measure res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(json.getAsJsonObject("effectivePeriod")));
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contributor")) {
            array = json.getAsJsonArray("contributor");
            for (i = 0; i < array.size(); ++i) {
                res.getContributor().add(this.parseContributor(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("disclaimer")) {
            res.setDisclaimerElement(this.parseMarkdown(json.get("disclaimer").getAsString()));
        }
        if (json.has("_disclaimer")) {
            this.parseElementProperties(json.getAsJsonObject("_disclaimer"), res.getDisclaimerElement());
        }
        if (json.has("scoring")) {
            res.setScoring(this.parseCodeableConcept(json.getAsJsonObject("scoring")));
        }
        if (json.has("compositeScoring")) {
            res.setCompositeScoring(this.parseCodeableConcept(json.getAsJsonObject("compositeScoring")));
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("riskAdjustment")) {
            res.setRiskAdjustmentElement(this.parseString(json.get("riskAdjustment").getAsString()));
        }
        if (json.has("_riskAdjustment")) {
            this.parseElementProperties(json.getAsJsonObject("_riskAdjustment"), res.getRiskAdjustmentElement());
        }
        if (json.has("rateAggregation")) {
            res.setRateAggregationElement(this.parseString(json.get("rateAggregation").getAsString()));
        }
        if (json.has("_rateAggregation")) {
            this.parseElementProperties(json.getAsJsonObject("_rateAggregation"), res.getRateAggregationElement());
        }
        if (json.has("rationale")) {
            res.setRationaleElement(this.parseMarkdown(json.get("rationale").getAsString()));
        }
        if (json.has("_rationale")) {
            this.parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
        }
        if (json.has("clinicalRecommendationStatement")) {
            res.setClinicalRecommendationStatementElement(this.parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
        }
        if (json.has("_clinicalRecommendationStatement")) {
            this.parseElementProperties(json.getAsJsonObject("_clinicalRecommendationStatement"), res.getClinicalRecommendationStatementElement());
        }
        if (json.has("improvementNotation")) {
            res.setImprovementNotationElement(this.parseString(json.get("improvementNotation").getAsString()));
        }
        if (json.has("_improvementNotation")) {
            this.parseElementProperties(json.getAsJsonObject("_improvementNotation"), res.getImprovementNotationElement());
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i = 0; i < array.size(); ++i) {
                res.getDefinition().add(this.parseMarkdown(array.get(i).getAsString()));
            }
        }
        if (json.has("_definition")) {
            array = json.getAsJsonArray("_definition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDefinition().size()) {
                    res.getDefinition().add(this.parseMarkdown(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
            }
        }
        if (json.has("guidance")) {
            res.setGuidanceElement(this.parseMarkdown(json.get("guidance").getAsString()));
        }
        if (json.has("_guidance")) {
            this.parseElementProperties(json.getAsJsonObject("_guidance"), res.getGuidanceElement());
        }
        if (json.has("set")) {
            res.setSetElement(this.parseString(json.get("set").getAsString()));
        }
        if (json.has("_set")) {
            this.parseElementProperties(json.getAsJsonObject("_set"), res.getSetElement());
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseMeasureMeasureGroupComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("supplementalData")) {
            array = json.getAsJsonArray("supplementalData");
            for (i = 0; i < array.size(); ++i) {
                res.getSupplementalData().add(this.parseMeasureMeasureSupplementalDataComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
        this.parseMeasureMeasureGroupComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureMeasureGroupComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("population")) {
            array = json.getAsJsonArray("population");
            for (i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseMeasureMeasureGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("stratifier")) {
            array = json.getAsJsonArray("stratifier");
            for (i = 0; i < array.size(); ++i) {
                res.getStratifier().add(this.parseMeasureMeasureGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
        this.parseMeasureMeasureGroupPopulationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureMeasureGroupPopulationComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupPopulationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
    }

    protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
        this.parseMeasureMeasureGroupStratifierComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureMeasureGroupStratifierComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupStratifierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
    }

    protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
        this.parseMeasureMeasureSupplementalDataComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureMeasureSupplementalDataComponentProperties(JsonObject json, Measure owner, Measure.MeasureSupplementalDataComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("usage")) {
            JsonArray array = json.getAsJsonArray("usage");
            for (int i = 0; i < array.size(); ++i) {
                res.getUsage().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
    }

    protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
        MeasureReport res = new MeasureReport();
        this.parseMeasureReportProperties(json, res);
        return res;
    }

    protected void parseMeasureReportProperties(JsonObject json, MeasureReport res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("measure")) {
            res.setMeasure(this.parseReference(json.getAsJsonObject("measure")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("reportingOrganization")) {
            res.setReportingOrganization(this.parseReference(json.getAsJsonObject("reportingOrganization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("group")) {
            JsonArray array = json.getAsJsonArray("group");
            for (int i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("evaluatedResources")) {
            res.setEvaluatedResources(this.parseReference(json.getAsJsonObject("evaluatedResources")));
        }
    }

    protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
        this.parseMeasureReportMeasureReportGroupComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureReportMeasureReportGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("population")) {
            array = json.getAsJsonArray("population");
            for (i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseMeasureReportMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("measureScore")) {
            res.setMeasureScoreElement(this.parseDecimal(json.get("measureScore").getAsBigDecimal()));
        }
        if (json.has("_measureScore")) {
            this.parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
        }
        if (json.has("stratifier")) {
            array = json.getAsJsonArray("stratifier");
            for (i = 0; i < array.size(); ++i) {
                res.getStratifier().add(this.parseMeasureReportMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
        this.parseMeasureReportMeasureReportGroupPopulationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureReportMeasureReportGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("patients")) {
            res.setPatients(this.parseReference(json.getAsJsonObject("patients")));
        }
    }

    protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
        this.parseMeasureReportMeasureReportGroupStratifierComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureReportMeasureReportGroupStratifierComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("stratum")) {
            JsonArray array = json.getAsJsonArray("stratum");
            for (int i = 0; i < array.size(); ++i) {
                res.getStratum().add(this.parseMeasureReportStratifierGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
        this.parseMeasureReportStratifierGroupComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureReportStratifierGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("population")) {
            JsonArray array = json.getAsJsonArray("population");
            for (int i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseMeasureReportStratifierGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("measureScore")) {
            res.setMeasureScoreElement(this.parseDecimal(json.get("measureScore").getAsBigDecimal()));
        }
        if (json.has("_measureScore")) {
            this.parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
        }
    }

    protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
        this.parseMeasureReportStratifierGroupPopulationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMeasureReportStratifierGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("patients")) {
            res.setPatients(this.parseReference(json.getAsJsonObject("patients")));
        }
    }

    protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
        Media res = new Media();
        this.parseMediaProperties(json, res);
        return res;
    }

    protected void parseMediaProperties(JsonObject json, Media res) throws IOException, FHIRFormatError {
        int i;
        Type occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("subtype")) {
            res.setSubtype(this.parseCodeableConcept(json.getAsJsonObject("subtype")));
        }
        if (json.has("view")) {
            res.setView(this.parseCodeableConcept(json.getAsJsonObject("view")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("operator")) {
            res.setOperator(this.parseReference(json.getAsJsonObject("operator")));
        }
        if (json.has("reasonCode")) {
            JsonArray array2 = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array2.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("height")) {
            res.setHeightElement(this.parsePositiveInt(json.get("height").getAsString()));
        }
        if (json.has("_height")) {
            this.parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
        }
        if (json.has("width")) {
            res.setWidthElement(this.parsePositiveInt(json.get("width").getAsString()));
        }
        if (json.has("_width")) {
            this.parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
        }
        if (json.has("frames")) {
            res.setFramesElement(this.parsePositiveInt(json.get("frames").getAsString()));
        }
        if (json.has("_frames")) {
            this.parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseUnsignedInt(json.get("duration").getAsString()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("content")) {
            res.setContent(this.parseAttachment(json.getAsJsonObject("content")));
        }
        if (json.has("note")) {
            JsonArray array3 = json.getAsJsonArray("note");
            for (i = 0; i < array3.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array3.get(i).getAsJsonObject()));
            }
        }
    }

    protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseMedicationProperties(json, res);
        return res;
    }

    protected void parseMedicationProperties(JsonObject json, Medication res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("isBrand")) {
            res.setIsBrandElement(this.parseBoolean(json.get("isBrand").getAsBoolean()));
        }
        if (json.has("_isBrand")) {
            this.parseElementProperties(json.getAsJsonObject("_isBrand"), res.getIsBrandElement());
        }
        if (json.has("isOverTheCounter")) {
            res.setIsOverTheCounterElement(this.parseBoolean(json.get("isOverTheCounter").getAsBoolean()));
        }
        if (json.has("_isOverTheCounter")) {
            this.parseElementProperties(json.getAsJsonObject("_isOverTheCounter"), res.getIsOverTheCounterElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(json.getAsJsonObject("manufacturer")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("ingredient")) {
            array = json.getAsJsonArray("ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseMedicationMedicationIngredientComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("package")) {
            res.setPackage(this.parseMedicationMedicationPackageComponent(json.getAsJsonObject("package"), res));
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
        this.parseMedicationMedicationIngredientComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationMedicationIngredientComponentProperties(JsonObject json, Medication owner, Medication.MedicationIngredientComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
        if (json.has("isActive")) {
            res.setIsActiveElement(this.parseBoolean(json.get("isActive").getAsBoolean()));
        }
        if (json.has("_isActive")) {
            this.parseElementProperties(json.getAsJsonObject("_isActive"), res.getIsActiveElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseRatio(json.getAsJsonObject("amount")));
        }
    }

    protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
        this.parseMedicationMedicationPackageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationMedicationPackageComponentProperties(JsonObject json, Medication owner, Medication.MedicationPackageComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("container")) {
            res.setContainer(this.parseCodeableConcept(json.getAsJsonObject("container")));
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseMedicationMedicationPackageContentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("batch")) {
            array = json.getAsJsonArray("batch");
            for (i = 0; i < array.size(); ++i) {
                res.getBatch().add(this.parseMedicationMedicationPackageBatchComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
        this.parseMedicationMedicationPackageContentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationMedicationPackageContentComponentProperties(JsonObject json, Medication owner, Medication.MedicationPackageContentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
        if (json.has("amount")) {
            res.setAmount(this.parseSimpleQuantity(json.getAsJsonObject("amount")));
        }
    }

    protected Medication.MedicationPackageBatchComponent parseMedicationMedicationPackageBatchComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageBatchComponent res = new Medication.MedicationPackageBatchComponent();
        this.parseMedicationMedicationPackageBatchComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationMedicationPackageBatchComponentProperties(JsonObject json, Medication owner, Medication.MedicationPackageBatchComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
    }

    protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
        MedicationAdministration res = new MedicationAdministration();
        this.parseMedicationAdministrationProperties(json, res);
        return res;
    }

    protected void parseMedicationAdministrationProperties(JsonObject json, MedicationAdministration res) throws IOException, FHIRFormatError {
        int i;
        Type effective;
        Type medication;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPartOf().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("supportingInformation")) {
            JsonArray array2 = json.getAsJsonArray("supportingInformation");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getSupportingInformation().add(this.parseReference(array2.get(i3).getAsJsonObject()));
            }
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("performer")) {
            JsonArray array3 = json.getAsJsonArray("performer");
            for (i = 0; i < array3.size(); ++i) {
                res.getPerformer().add(this.parseMedicationAdministrationMedicationAdministrationPerformerComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("notGiven")) {
            res.setNotGivenElement(this.parseBoolean(json.get("notGiven").getAsBoolean()));
        }
        if (json.has("_notGiven")) {
            this.parseElementProperties(json.getAsJsonObject("_notGiven"), res.getNotGivenElement());
        }
        if (json.has("reasonNotGiven")) {
            JsonArray array4 = json.getAsJsonArray("reasonNotGiven");
            for (i = 0; i < array4.size(); ++i) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonCode")) {
            JsonArray array5 = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array5.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            JsonArray array6 = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array6.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(json.getAsJsonObject("prescription")));
        }
        if (json.has("device")) {
            JsonArray array7 = json.getAsJsonArray("device");
            for (i = 0; i < array7.size(); ++i) {
                res.getDevice().add(this.parseReference(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array8 = json.getAsJsonArray("note");
            for (i = 0; i < array8.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosage")) {
            res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage"), res));
        }
        if (json.has("eventHistory")) {
            JsonArray array9 = json.getAsJsonArray("eventHistory");
            for (i = 0; i < array9.size(); ++i) {
                res.getEventHistory().add(this.parseReference(array9.get(i).getAsJsonObject()));
            }
        }
    }

    protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        this.parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws IOException, FHIRFormatError {
        Type rate;
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(json.getAsJsonObject("site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("dose")) {
            res.setDose(this.parseSimpleQuantity(json.getAsJsonObject("dose")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
    }

    protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
        MedicationDispense res = new MedicationDispense();
        this.parseMedicationDispenseProperties(json, res);
        return res;
    }

    protected void parseMedicationDispenseProperties(JsonObject json, MedicationDispense res) throws IOException, FHIRFormatError {
        Type notDoneReason;
        int i;
        Type medication;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPartOf().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("supportingInformation")) {
            JsonArray array2 = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array2.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("performer")) {
            JsonArray array3 = json.getAsJsonArray("performer");
            for (i = 0; i < array3.size(); ++i) {
                res.getPerformer().add(this.parseMedicationDispenseMedicationDispensePerformerComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("authorizingPrescription")) {
            JsonArray array4 = json.getAsJsonArray("authorizingPrescription");
            for (i = 0; i < array4.size(); ++i) {
                res.getAuthorizingPrescription().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("daysSupply")) {
            res.setDaysSupply(this.parseSimpleQuantity(json.getAsJsonObject("daysSupply")));
        }
        if (json.has("whenPrepared")) {
            res.setWhenPreparedElement(this.parseDateTime(json.get("whenPrepared").getAsString()));
        }
        if (json.has("_whenPrepared")) {
            this.parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
        }
        if (json.has("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(json.get("whenHandedOver").getAsString()));
        }
        if (json.has("_whenHandedOver")) {
            this.parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("receiver")) {
            JsonArray array5 = json.getAsJsonArray("receiver");
            for (i = 0; i < array5.size(); ++i) {
                res.getReceiver().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array6 = json.getAsJsonArray("note");
            for (i = 0; i < array6.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosageInstruction")) {
            JsonArray array7 = json.getAsJsonArray("dosageInstruction");
            for (i = 0; i < array7.size(); ++i) {
                res.getDosageInstruction().add(this.parseDosage(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("substitution")) {
            res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution"), res));
        }
        if (json.has("detectedIssue")) {
            JsonArray array8 = json.getAsJsonArray("detectedIssue");
            for (i = 0; i < array8.size(); ++i) {
                res.getDetectedIssue().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notDone")) {
            res.setNotDoneElement(this.parseBoolean(json.get("notDone").getAsBoolean()));
        }
        if (json.has("_notDone")) {
            this.parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
        }
        if ((notDoneReason = this.parseType("notDoneReason", json)) != null) {
            res.setNotDoneReason(notDoneReason);
        }
        if (json.has("eventHistory")) {
            JsonArray array9 = json.getAsJsonArray("eventHistory");
            for (int i3 = 0; i3 < array9.size(); ++i3) {
                res.getEventHistory().add(this.parseReference(array9.get(i3).getAsJsonObject()));
            }
        }
    }

    protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
        MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
        this.parseMedicationDispenseMedicationDispensePerformerComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationDispenseMedicationDispensePerformerComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("wasSubstituted")) {
            res.setWasSubstitutedElement(this.parseBoolean(json.get("wasSubstituted").getAsBoolean()));
        }
        if (json.has("_wasSubstituted")) {
            this.parseElementProperties(json.getAsJsonObject("_wasSubstituted"), res.getWasSubstitutedElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("responsibleParty")) {
            array = json.getAsJsonArray("responsibleParty");
            for (i = 0; i < array.size(); ++i) {
                res.getResponsibleParty().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected MedicationRequest parseMedicationRequest(JsonObject json) throws IOException, FHIRFormatError {
        MedicationRequest res = new MedicationRequest();
        this.parseMedicationRequestProperties(json, res);
        return res;
    }

    protected void parseMedicationRequestProperties(JsonObject json, MedicationRequest res) throws IOException, FHIRFormatError {
        int i;
        Type medication;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(json.getAsJsonObject("groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("supportingInformation")) {
            JsonArray array2 = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array2.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseMedicationRequestMedicationRequestRequesterComponent(json.getAsJsonObject("requester"), res));
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(json.getAsJsonObject("recorder")));
        }
        if (json.has("reasonCode")) {
            JsonArray array3 = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array3.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            JsonArray array4 = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array4.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array5 = json.getAsJsonArray("note");
            for (i = 0; i < array5.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosageInstruction")) {
            JsonArray array6 = json.getAsJsonArray("dosageInstruction");
            for (i = 0; i < array6.size(); ++i) {
                res.getDosageInstruction().add(this.parseDosage(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dispenseRequest")) {
            res.setDispenseRequest(this.parseMedicationRequestMedicationRequestDispenseRequestComponent(json.getAsJsonObject("dispenseRequest"), res));
        }
        if (json.has("substitution")) {
            res.setSubstitution(this.parseMedicationRequestMedicationRequestSubstitutionComponent(json.getAsJsonObject("substitution"), res));
        }
        if (json.has("priorPrescription")) {
            res.setPriorPrescription(this.parseReference(json.getAsJsonObject("priorPrescription")));
        }
        if (json.has("detectedIssue")) {
            JsonArray array7 = json.getAsJsonArray("detectedIssue");
            for (i = 0; i < array7.size(); ++i) {
                res.getDetectedIssue().add(this.parseReference(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("eventHistory")) {
            JsonArray array8 = json.getAsJsonArray("eventHistory");
            for (i = 0; i < array8.size(); ++i) {
                res.getEventHistory().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
    }

    protected MedicationRequest.MedicationRequestRequesterComponent parseMedicationRequestMedicationRequestRequesterComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestRequesterComponent res = new MedicationRequest.MedicationRequestRequesterComponent();
        this.parseMedicationRequestMedicationRequestRequesterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationRequestMedicationRequestRequesterComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestRequesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("agent")) {
            res.setAgent(this.parseReference(json.getAsJsonObject("agent")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        this.parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(json.getAsJsonObject("validityPeriod")));
        }
        if (json.has("numberOfRepeatsAllowed")) {
            res.setNumberOfRepeatsAllowedElement(this.parsePositiveInt(json.get("numberOfRepeatsAllowed").getAsString()));
        }
        if (json.has("_numberOfRepeatsAllowed")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("expectedSupplyDuration")) {
            res.setExpectedSupplyDuration(this.parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
    }

    protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
        this.parseMedicationRequestMedicationRequestSubstitutionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMedicationRequestMedicationRequestSubstitutionComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("allowed")) {
            res.setAllowedElement(this.parseBoolean(json.get("allowed").getAsBoolean()));
        }
        if (json.has("_allowed")) {
            this.parseElementProperties(json.getAsJsonObject("_allowed"), res.getAllowedElement());
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
    }

    protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
        MedicationStatement res = new MedicationStatement();
        this.parseMedicationStatementProperties(json, res);
        return res;
    }

    protected void parseMedicationStatementProperties(JsonObject json, MedicationStatement res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type effective;
        Type medication;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array2 = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array2 = json.getAsJsonArray("partOf");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getPartOf().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(json.get("dateAsserted").getAsString()));
        }
        if (json.has("_dateAsserted")) {
            this.parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
        }
        if (json.has("informationSource")) {
            res.setInformationSource(this.parseReference(json.getAsJsonObject("informationSource")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("derivedFrom")) {
            array = json.getAsJsonArray("derivedFrom");
            for (i = 0; i < array.size(); ++i) {
                res.getDerivedFrom().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("taken")) {
            res.setTakenElement(this.parseEnumeration(json.get("taken").getAsString(), MedicationStatement.MedicationStatementTaken.NULL, new MedicationStatement.MedicationStatementTakenEnumFactory()));
        }
        if (json.has("_taken")) {
            this.parseElementProperties(json.getAsJsonObject("_taken"), res.getTakenElement());
        }
        if (json.has("reasonNotTaken")) {
            array = json.getAsJsonArray("reasonNotTaken");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotTaken().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosage")) {
            array = json.getAsJsonArray("dosage");
            for (i = 0; i < array.size(); ++i) {
                res.getDosage().add(this.parseDosage(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected MessageDefinition parseMessageDefinition(JsonObject json) throws IOException, FHIRFormatError {
        MessageDefinition res = new MessageDefinition();
        this.parseMessageDefinitionProperties(json, res);
        return res;
    }

    protected void parseMessageDefinitionProperties(JsonObject json, MessageDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseReference(json.getAsJsonObject("base")));
        }
        if (json.has("parent")) {
            array = json.getAsJsonArray("parent");
            for (i = 0; i < array.size(); ++i) {
                res.getParent().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i = 0; i < array.size(); ++i) {
                res.getReplaces().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("event")) {
            res.setEvent(this.parseCoding(json.getAsJsonObject("event")));
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("focus")) {
            array = json.getAsJsonArray("focus");
            for (i = 0; i < array.size(); ++i) {
                res.getFocus().add(this.parseMessageDefinitionMessageDefinitionFocusComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("responseRequired")) {
            res.setResponseRequiredElement(this.parseBoolean(json.get("responseRequired").getAsBoolean()));
        }
        if (json.has("_responseRequired")) {
            this.parseElementProperties(json.getAsJsonObject("_responseRequired"), res.getResponseRequiredElement());
        }
        if (json.has("allowedResponse")) {
            array = json.getAsJsonArray("allowedResponse");
            for (i = 0; i < array.size(); ++i) {
                res.getAllowedResponse().add(this.parseMessageDefinitionMessageDefinitionAllowedResponseComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
        MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
        this.parseMessageDefinitionMessageDefinitionFocusComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMessageDefinitionMessageDefinitionFocusComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
    }

    protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
        MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        this.parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("message")) {
            res.setMessage(this.parseReference(json.getAsJsonObject("message")));
        }
        if (json.has("situation")) {
            res.setSituationElement(this.parseMarkdown(json.get("situation").getAsString()));
        }
        if (json.has("_situation")) {
            this.parseElementProperties(json.getAsJsonObject("_situation"), res.getSituationElement());
        }
    }

    protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
        MessageHeader res = new MessageHeader();
        this.parseMessageHeaderProperties(json, res);
        return res;
    }

    protected void parseMessageHeaderProperties(JsonObject json, MessageHeader res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("event")) {
            res.setEvent(this.parseCoding(json.getAsJsonObject("event")));
        }
        if (json.has("destination")) {
            array = json.getAsJsonArray("destination");
            for (i = 0; i < array.size(); ++i) {
                res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("receiver")) {
            res.setReceiver(this.parseReference(json.getAsJsonObject("receiver")));
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseInstant(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("source")) {
            res.setSource(this.parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source"), res));
        }
        if (json.has("responsible")) {
            res.setResponsible(this.parseReference(json.getAsJsonObject("responsible")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(json.getAsJsonObject("response"), res));
        }
        if (json.has("focus")) {
            array = json.getAsJsonArray("focus");
            for (i = 0; i < array.size(); ++i) {
                res.getFocus().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseMessageHeaderMessageDestinationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMessageHeaderMessageDestinationComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseMessageHeaderMessageSourceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMessageHeaderMessageSourceComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("software")) {
            res.setSoftwareElement(this.parseString(json.get("software").getAsString()));
        }
        if (json.has("_software")) {
            this.parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("contact")) {
            res.setContact(this.parseContactPoint(json.getAsJsonObject("contact")));
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseMessageHeaderMessageHeaderResponseComponentProperties(json, owner, res);
        return res;
    }

    protected void parseMessageHeaderMessageHeaderResponseComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseId(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("details")) {
            res.setDetails(this.parseReference(json.getAsJsonObject("details")));
        }
    }

    protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
        NamingSystem res = new NamingSystem();
        this.parseNamingSystemProperties(json, res);
        return res;
    }

    protected void parseNamingSystemProperties(JsonObject json, NamingSystem res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseString(json.get("responsible").getAsString()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("uniqueId")) {
            array = json.getAsJsonArray("uniqueId");
            for (i = 0; i < array.size(); ++i) {
                res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("replacedBy")) {
            res.setReplacedBy(this.parseReference(json.getAsJsonObject("replacedBy")));
        }
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseNamingSystemNamingSystemUniqueIdComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNamingSystemNamingSystemUniqueIdComponentProperties(JsonObject json, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("preferred")) {
            res.setPreferredElement(this.parseBoolean(json.get("preferred").getAsBoolean()));
        }
        if (json.has("_preferred")) {
            this.parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
        NutritionOrder res = new NutritionOrder();
        this.parseNutritionOrderProperties(json, res);
        return res;
    }

    protected void parseNutritionOrderProperties(JsonObject json, NutritionOrder res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("allergyIntolerance")) {
            array = json.getAsJsonArray("allergyIntolerance");
            for (i = 0; i < array.size(); ++i) {
                res.getAllergyIntolerance().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("foodPreferenceModifier")) {
            array = json.getAsJsonArray("foodPreferenceModifier");
            for (i = 0; i < array.size(); ++i) {
                res.getFoodPreferenceModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("excludeFoodModifier")) {
            array = json.getAsJsonArray("excludeFoodModifier");
            for (i = 0; i < array.size(); ++i) {
                res.getExcludeFoodModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("oralDiet")) {
            res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet"), res));
        }
        if (json.has("supplement")) {
            array = json.getAsJsonArray("supplement");
            for (i = 0; i < array.size(); ++i) {
                res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("enteralFormula")) {
            res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula"), res));
        }
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseNutritionOrderNutritionOrderOralDietComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNutritionOrderNutritionOrderOralDietComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("schedule")) {
            array = json.getAsJsonArray("schedule");
            for (i = 0; i < array.size(); ++i) {
                res.getSchedule().add(this.parseTiming(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("nutrient")) {
            array = json.getAsJsonArray("nutrient");
            for (i = 0; i < array.size(); ++i) {
                res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("texture")) {
            array = json.getAsJsonArray("texture");
            for (i = 0; i < array.size(); ++i) {
                res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("fluidConsistencyType")) {
            array = json.getAsJsonArray("fluidConsistencyType");
            for (i = 0; i < array.size(); ++i) {
                res.getFluidConsistencyType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instruction")) {
            res.setInstructionElement(this.parseString(json.get("instruction").getAsString()));
        }
        if (json.has("_instruction")) {
            this.parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
        }
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("modifier")) {
            res.setModifier(this.parseCodeableConcept(json.getAsJsonObject("modifier")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseSimpleQuantity(json.getAsJsonObject("amount")));
        }
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("modifier")) {
            res.setModifier(this.parseCodeableConcept(json.getAsJsonObject("modifier")));
        }
        if (json.has("foodType")) {
            res.setFoodType(this.parseCodeableConcept(json.getAsJsonObject("foodType")));
        }
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseNutritionOrderNutritionOrderSupplementComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNutritionOrderNutritionOrderSupplementComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("productName")) {
            res.setProductNameElement(this.parseString(json.get("productName").getAsString()));
        }
        if (json.has("_productName")) {
            this.parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
        }
        if (json.has("schedule")) {
            JsonArray array = json.getAsJsonArray("schedule");
            for (int i = 0; i < array.size(); ++i) {
                res.getSchedule().add(this.parseTiming(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("instruction")) {
            res.setInstructionElement(this.parseString(json.get("instruction").getAsString()));
        }
        if (json.has("_instruction")) {
            this.parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
        }
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("baseFormulaType")) {
            res.setBaseFormulaType(this.parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
        }
        if (json.has("baseFormulaProductName")) {
            res.setBaseFormulaProductNameElement(this.parseString(json.get("baseFormulaProductName").getAsString()));
        }
        if (json.has("_baseFormulaProductName")) {
            this.parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
        }
        if (json.has("additiveType")) {
            res.setAdditiveType(this.parseCodeableConcept(json.getAsJsonObject("additiveType")));
        }
        if (json.has("additiveProductName")) {
            res.setAdditiveProductNameElement(this.parseString(json.get("additiveProductName").getAsString()));
        }
        if (json.has("_additiveProductName")) {
            this.parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
        }
        if (json.has("caloricDensity")) {
            res.setCaloricDensity(this.parseSimpleQuantity(json.getAsJsonObject("caloricDensity")));
        }
        if (json.has("routeofAdministration")) {
            res.setRouteofAdministration(this.parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
        }
        if (json.has("administration")) {
            JsonArray array = json.getAsJsonArray("administration");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("maxVolumeToDeliver")) {
            res.setMaxVolumeToDeliver(this.parseSimpleQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
        }
        if (json.has("administrationInstruction")) {
            res.setAdministrationInstructionElement(this.parseString(json.get("administrationInstruction").getAsString()));
        }
        if (json.has("_administrationInstruction")) {
            this.parseElementProperties(json.getAsJsonObject("_administrationInstruction"), res.getAdministrationInstructionElement());
        }
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(json, owner, res);
        return res;
    }

    protected void parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws IOException, FHIRFormatError {
        Type rate;
        this.parseBackboneProperties(json, res);
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
    }

    protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
        Observation res = new Observation();
        this.parseObservationProperties(json, res);
        return res;
    }

    protected void parseObservationProperties(JsonObject json, Observation res) throws IOException, FHIRFormatError {
        int i;
        Type value;
        Type effective;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getPerformer().add(this.parseReference(array2.get(i3).getAsJsonObject()));
            }
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
        }
        if (json.has("interpretation")) {
            res.setInterpretation(this.parseCodeableConcept(json.getAsJsonObject("interpretation")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("specimen")) {
            res.setSpecimen(this.parseReference(json.getAsJsonObject("specimen")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("referenceRange")) {
            JsonArray array3 = json.getAsJsonArray("referenceRange");
            for (i = 0; i < array3.size(); ++i) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("related")) {
            JsonArray array4 = json.getAsJsonArray("related");
            for (i = 0; i < array4.size(); ++i) {
                res.getRelated().add(this.parseObservationObservationRelatedComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("component")) {
            JsonArray array5 = json.getAsJsonArray("component");
            for (i = 0; i < array5.size(); ++i) {
                res.getComponent().add(this.parseObservationObservationComponentComponent(array5.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
        this.parseObservationObservationReferenceRangeComponentProperties(json, owner, res);
        return res;
    }

    protected void parseObservationObservationReferenceRangeComponentProperties(JsonObject json, Observation owner, Observation.ObservationReferenceRangeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseSimpleQuantity(json.getAsJsonObject("low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseSimpleQuantity(json.getAsJsonObject("high")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("appliesTo")) {
            JsonArray array = json.getAsJsonArray("appliesTo");
            for (int i = 0; i < array.size(); ++i) {
                res.getAppliesTo().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("age")) {
            res.setAge(this.parseRange(json.getAsJsonObject("age")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
    }

    protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
        this.parseObservationObservationRelatedComponentProperties(json, owner, res);
        return res;
    }

    protected void parseObservationObservationRelatedComponentProperties(JsonObject json, Observation owner, Observation.ObservationRelatedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
    }

    protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
        this.parseObservationObservationComponentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseObservationObservationComponentComponentProperties(JsonObject json, Observation owner, Observation.ObservationComponentComponent res) throws IOException, FHIRFormatError {
        Type value;
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
        }
        if (json.has("interpretation")) {
            res.setInterpretation(this.parseCodeableConcept(json.getAsJsonObject("interpretation")));
        }
        if (json.has("referenceRange")) {
            JsonArray array = json.getAsJsonArray("referenceRange");
            for (int i = 0; i < array.size(); ++i) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected OperationDefinition parseOperationDefinition(JsonObject json) throws IOException, FHIRFormatError {
        OperationDefinition res = new OperationDefinition();
        this.parseOperationDefinitionProperties(json, res);
        return res;
    }

    protected void parseOperationDefinitionProperties(JsonObject json, OperationDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("idempotent")) {
            res.setIdempotentElement(this.parseBoolean(json.get("idempotent").getAsBoolean()));
        }
        if (json.has("_idempotent")) {
            this.parseElementProperties(json.getAsJsonObject("_idempotent"), res.getIdempotentElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseReference(json.getAsJsonObject("base")));
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_resource")) {
            array = json.getAsJsonArray("_resource");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getResource().size()) {
                    res.getResource().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getResource().get(i));
            }
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseBoolean(json.get("system").getAsBoolean()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseBoolean(json.get("type").getAsBoolean()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("instance")) {
            res.setInstanceElement(this.parseBoolean(json.get("instance").getAsBoolean()));
        }
        if (json.has("_instance")) {
            this.parseElementProperties(json.getAsJsonObject("_instance"), res.getInstanceElement());
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("overload")) {
            array = json.getAsJsonArray("overload");
            for (i = 0; i < array.size(); ++i) {
                res.getOverload().add(this.parseOperationDefinitionOperationDefinitionOverloadComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
        this.parseOperationDefinitionOperationDefinitionParameterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseOperationDefinitionOperationDefinitionParameterComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("searchType")) {
            res.setSearchTypeElement(this.parseEnumeration(json.get("searchType").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_searchType")) {
            this.parseElementProperties(json.getAsJsonObject("_searchType"), res.getSearchTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("binding")) {
            res.setBinding(this.parseOperationDefinitionOperationDefinitionParameterBindingComponent(json.getAsJsonObject("binding"), owner));
        }
        if (json.has("part")) {
            JsonArray array = json.getAsJsonArray("part");
            for (int i = 0; i < array.size(); ++i) {
                res.getPart().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.parseOperationDefinitionOperationDefinitionParameterBindingComponentProperties(json, owner, res);
        return res;
    }

    protected void parseOperationDefinitionOperationDefinitionParameterBindingComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterBindingComponent res) throws IOException, FHIRFormatError {
        Type valueSet;
        this.parseBackboneProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
    }

    protected OperationDefinition.OperationDefinitionOverloadComponent parseOperationDefinitionOperationDefinitionOverloadComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionOverloadComponent res = new OperationDefinition.OperationDefinitionOverloadComponent();
        this.parseOperationDefinitionOperationDefinitionOverloadComponentProperties(json, owner, res);
        return res;
    }

    protected void parseOperationDefinitionOperationDefinitionOverloadComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionOverloadComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("parameterName")) {
            array = json.getAsJsonArray("parameterName");
            for (i = 0; i < array.size(); ++i) {
                res.getParameterName().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_parameterName")) {
            array = json.getAsJsonArray("_parameterName");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getParameterName().size()) {
                    res.getParameterName().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getParameterName().get(i));
            }
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
    }

    protected OperationOutcome parseOperationOutcome(JsonObject json) throws IOException, FHIRFormatError {
        OperationOutcome res = new OperationOutcome();
        this.parseOperationOutcomeProperties(json, res);
        return res;
    }

    protected void parseOperationOutcomeProperties(JsonObject json, OperationOutcome res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("issue")) {
            JsonArray array = json.getAsJsonArray("issue");
            for (int i = 0; i < array.size(); ++i) {
                res.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(JsonObject json, OperationOutcome owner) throws IOException, FHIRFormatError {
        OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseOperationOutcomeOperationOutcomeIssueComponentProperties(json, owner, res);
        return res;
    }

    protected void parseOperationOutcomeOperationOutcomeIssueComponentProperties(JsonObject json, OperationOutcome owner, OperationOutcome.OperationOutcomeIssueComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("details")) {
            res.setDetails(this.parseCodeableConcept(json.getAsJsonObject("details")));
        }
        if (json.has("diagnostics")) {
            res.setDiagnosticsElement(this.parseString(json.get("diagnostics").getAsString()));
        }
        if (json.has("_diagnostics")) {
            this.parseElementProperties(json.getAsJsonObject("_diagnostics"), res.getDiagnosticsElement());
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_location")) {
            array = json.getAsJsonArray("_location");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLocation().size()) {
                    res.getLocation().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLocation().get(i));
            }
        }
        if (json.has("expression")) {
            array = json.getAsJsonArray("expression");
            for (i = 0; i < array.size(); ++i) {
                res.getExpression().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_expression")) {
            array = json.getAsJsonArray("_expression");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExpression().size()) {
                    res.getExpression().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getExpression().get(i));
            }
        }
    }

    protected Organization parseOrganization(JsonObject json) throws IOException, FHIRFormatError {
        Organization res = new Organization();
        this.parseOrganizationProperties(json, res);
        return res;
    }

    protected void parseOrganizationProperties(JsonObject json, Organization res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("alias")) {
            array = json.getAsJsonArray("alias");
            for (i = 0; i < array.size(); ++i) {
                res.getAlias().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array = json.getAsJsonArray("_alias");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseOrganizationOrganizationContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject json, Organization owner) throws IOException, FHIRFormatError {
        Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
        this.parseOrganizationOrganizationContactComponentProperties(json, owner, res);
        return res;
    }

    protected void parseOrganizationOrganizationContactComponentProperties(JsonObject json, Organization owner, Organization.OrganizationContactComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("purpose")) {
            res.setPurpose(this.parseCodeableConcept(json.getAsJsonObject("purpose")));
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
    }

    protected Patient parsePatient(JsonObject json) throws IOException, FHIRFormatError {
        Patient res = new Patient();
        this.parsePatientProperties(json, res);
        return res;
    }

    protected void parsePatientProperties(JsonObject json, Patient res) throws IOException, FHIRFormatError {
        int i;
        Type multipleBirth;
        Type deceased;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getName().add(this.parseHumanName(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTelecom().add(this.parseContactPoint(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("address")) {
            JsonArray array2 = json.getAsJsonArray("address");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getAddress().add(this.parseAddress(array2.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("maritalStatus")) {
            res.setMaritalStatus(this.parseCodeableConcept(json.getAsJsonObject("maritalStatus")));
        }
        if ((multipleBirth = this.parseType("multipleBirth", json)) != null) {
            res.setMultipleBirth(multipleBirth);
        }
        if (json.has("photo")) {
            JsonArray array3 = json.getAsJsonArray("photo");
            for (i = 0; i < array3.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            JsonArray array4 = json.getAsJsonArray("contact");
            for (i = 0; i < array4.size(); ++i) {
                res.getContact().add(this.parsePatientContactComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("animal")) {
            res.setAnimal(this.parsePatientAnimalComponent(json.getAsJsonObject("animal"), res));
        }
        if (json.has("communication")) {
            JsonArray array5 = json.getAsJsonArray("communication");
            for (i = 0; i < array5.size(); ++i) {
                res.getCommunication().add(this.parsePatientPatientCommunicationComponent(array5.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("generalPractitioner")) {
            JsonArray array6 = json.getAsJsonArray("generalPractitioner");
            for (i = 0; i < array6.size(); ++i) {
                res.getGeneralPractitioner().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("link")) {
            JsonArray array7 = json.getAsJsonArray("link");
            for (i = 0; i < array7.size(); ++i) {
                res.getLink().add(this.parsePatientPatientLinkComponent(array7.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Patient.ContactComponent parsePatientContactComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.ContactComponent res = new Patient.ContactComponent();
        this.parsePatientContactComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePatientContactComponentProperties(JsonObject json, Patient owner, Patient.ContactComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("relationship")) {
            array = json.getAsJsonArray("relationship");
            for (i = 0; i < array.size(); ++i) {
                res.getRelationship().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected Patient.AnimalComponent parsePatientAnimalComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.AnimalComponent res = new Patient.AnimalComponent();
        this.parsePatientAnimalComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePatientAnimalComponentProperties(JsonObject json, Patient owner, Patient.AnimalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("species")) {
            res.setSpecies(this.parseCodeableConcept(json.getAsJsonObject("species")));
        }
        if (json.has("breed")) {
            res.setBreed(this.parseCodeableConcept(json.getAsJsonObject("breed")));
        }
        if (json.has("genderStatus")) {
            res.setGenderStatus(this.parseCodeableConcept(json.getAsJsonObject("genderStatus")));
        }
    }

    protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
        this.parsePatientPatientCommunicationComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePatientPatientCommunicationComponentProperties(JsonObject json, Patient owner, Patient.PatientCommunicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(json.getAsJsonObject("language")));
        }
        if (json.has("preferred")) {
            res.setPreferredElement(this.parseBoolean(json.get("preferred").getAsBoolean()));
        }
        if (json.has("_preferred")) {
            this.parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
        }
    }

    protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
        this.parsePatientPatientLinkComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePatientPatientLinkComponentProperties(JsonObject json, Patient owner, Patient.PatientLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("other")) {
            res.setOther(this.parseReference(json.getAsJsonObject("other")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
    }

    protected PaymentNotice parsePaymentNotice(JsonObject json) throws IOException, FHIRFormatError {
        PaymentNotice res = new PaymentNotice();
        this.parsePaymentNoticeProperties(json, res);
        return res;
    }

    protected void parsePaymentNoticeProperties(JsonObject json, PaymentNotice res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), PaymentNotice.PaymentNoticeStatus.NULL, new PaymentNotice.PaymentNoticeStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("statusDate")) {
            res.setStatusDateElement(this.parseDate(json.get("statusDate").getAsString()));
        }
        if (json.has("_statusDate")) {
            this.parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("paymentStatus")) {
            res.setPaymentStatus(this.parseCodeableConcept(json.getAsJsonObject("paymentStatus")));
        }
    }

    protected PaymentReconciliation parsePaymentReconciliation(JsonObject json) throws IOException, FHIRFormatError {
        PaymentReconciliation res = new PaymentReconciliation();
        this.parsePaymentReconciliationProperties(json, res);
        return res;
    }

    protected void parsePaymentReconciliationProperties(JsonObject json, PaymentReconciliation res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), PaymentReconciliation.PaymentReconciliationStatus.NULL, new PaymentReconciliation.PaymentReconciliationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parsePaymentReconciliationDetailsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(json.getAsJsonObject("total")));
        }
        if (json.has("processNote")) {
            array = json.getAsJsonArray("processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parsePaymentReconciliationNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
        PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
        this.parsePaymentReconciliationDetailsComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePaymentReconciliationDetailsComponentProperties(JsonObject json, PaymentReconciliation owner, PaymentReconciliation.DetailsComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("submitter")) {
            res.setSubmitter(this.parseReference(json.getAsJsonObject("submitter")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseReference(json.getAsJsonObject("payee")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
    }

    protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
        PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
        this.parsePaymentReconciliationNotesComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePaymentReconciliationNotesComponentProperties(JsonObject json, PaymentReconciliation owner, PaymentReconciliation.NotesComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
    }

    protected Person parsePerson(JsonObject json) throws IOException, FHIRFormatError {
        Person res = new Person();
        this.parsePersonProperties(json, res);
        return res;
    }

    protected void parsePersonProperties(JsonObject json, Person res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(json.getAsJsonObject("photo")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parsePersonPersonLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Person.PersonLinkComponent parsePersonPersonLinkComponent(JsonObject json, Person owner) throws IOException, FHIRFormatError {
        Person.PersonLinkComponent res = new Person.PersonLinkComponent();
        this.parsePersonPersonLinkComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePersonPersonLinkComponentProperties(JsonObject json, Person owner, Person.PersonLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("assurance")) {
            res.setAssuranceElement(this.parseEnumeration(json.get("assurance").getAsString(), Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
        }
        if (json.has("_assurance")) {
            this.parseElementProperties(json.getAsJsonObject("_assurance"), res.getAssuranceElement());
        }
    }

    protected PlanDefinition parsePlanDefinition(JsonObject json) throws IOException, FHIRFormatError {
        PlanDefinition res = new PlanDefinition();
        this.parsePlanDefinitionProperties(json, res);
        return res;
    }

    protected void parsePlanDefinitionProperties(JsonObject json, PlanDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(json.getAsJsonObject("effectivePeriod")));
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contributor")) {
            array = json.getAsJsonArray("contributor");
            for (i = 0; i < array.size(); ++i) {
                res.getContributor().add(this.parseContributor(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parsePlanDefinitionPlanDefinitionGoalComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parsePlanDefinitionPlanDefinitionActionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected PlanDefinition.PlanDefinitionGoalComponent parsePlanDefinitionPlanDefinitionGoalComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionGoalComponent res = new PlanDefinition.PlanDefinitionGoalComponent();
        this.parsePlanDefinitionPlanDefinitionGoalComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionGoalComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("description")) {
            res.setDescription(this.parseCodeableConcept(json.getAsJsonObject("description")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("start")) {
            res.setStart(this.parseCodeableConcept(json.getAsJsonObject("start")));
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("documentation")) {
            array = json.getAsJsonArray("documentation");
            for (i = 0; i < array.size(); ++i) {
                res.getDocumentation().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parsePlanDefinitionPlanDefinitionGoalTargetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected PlanDefinition.PlanDefinitionGoalTargetComponent parsePlanDefinitionPlanDefinitionGoalTargetComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionGoalTargetComponent res = new PlanDefinition.PlanDefinitionGoalTargetComponent();
        this.parsePlanDefinitionPlanDefinitionGoalTargetComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionGoalTargetComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalTargetComponent res) throws IOException, FHIRFormatError {
        Type detail;
        this.parseBackboneProperties(json, res);
        if (json.has("measure")) {
            res.setMeasure(this.parseCodeableConcept(json.getAsJsonObject("measure")));
        }
        if ((detail = this.parseType("detail", json)) != null) {
            res.setDetail(detail);
        }
        if (json.has("due")) {
            res.setDue(this.parseDuration(json.getAsJsonObject("due")));
        }
    }

    protected PlanDefinition.PlanDefinitionActionComponent parsePlanDefinitionPlanDefinitionActionComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionComponent res = new PlanDefinition.PlanDefinitionActionComponent();
        this.parsePlanDefinitionPlanDefinitionActionComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionActionComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionComponent res) throws IOException, FHIRFormatError {
        int i;
        Type timing;
        int i2;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("textEquivalent")) {
            res.setTextEquivalentElement(this.parseString(json.get("textEquivalent").getAsString()));
        }
        if (json.has("_textEquivalent")) {
            this.parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCode().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReason().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("documentation")) {
            array = json.getAsJsonArray("documentation");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDocumentation().add(this.parseRelatedArtifact(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("goalId")) {
            array = json.getAsJsonArray("goalId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getGoalId().add(this.parseId(array.get(i2).getAsString()));
            }
        }
        if (json.has("_goalId")) {
            array = json.getAsJsonArray("_goalId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getGoalId().size()) {
                    res.getGoalId().add(this.parseId(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getGoalId().get(i2));
            }
        }
        if (json.has("triggerDefinition")) {
            array = json.getAsJsonArray("triggerDefinition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTriggerDefinition().add(this.parseTriggerDefinition(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCondition().add(this.parsePlanDefinitionPlanDefinitionActionConditionComponent(array.get(i2).getAsJsonObject(), owner));
            }
        }
        if (json.has("input")) {
            array = json.getAsJsonArray("input");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getInput().add(this.parseDataRequirement(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("output")) {
            array = json.getAsJsonArray("output");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getOutput().add(this.parseDataRequirement(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("relatedAction")) {
            array = json.getAsJsonArray("relatedAction");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRelatedAction().add(this.parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(array.get(i2).getAsJsonObject(), owner));
            }
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("participant")) {
            JsonArray array2 = json.getAsJsonArray("participant");
            for (i = 0; i < array2.size(); ++i) {
                res.getParticipant().add(this.parsePlanDefinitionPlanDefinitionActionParticipantComponent(array2.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("groupingBehavior")) {
            res.setGroupingBehaviorElement(this.parseEnumeration(json.get("groupingBehavior").getAsString(), PlanDefinition.ActionGroupingBehavior.NULL, new PlanDefinition.ActionGroupingBehaviorEnumFactory()));
        }
        if (json.has("_groupingBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_groupingBehavior"), res.getGroupingBehaviorElement());
        }
        if (json.has("selectionBehavior")) {
            res.setSelectionBehaviorElement(this.parseEnumeration(json.get("selectionBehavior").getAsString(), PlanDefinition.ActionSelectionBehavior.NULL, new PlanDefinition.ActionSelectionBehaviorEnumFactory()));
        }
        if (json.has("_selectionBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_selectionBehavior"), res.getSelectionBehaviorElement());
        }
        if (json.has("requiredBehavior")) {
            res.setRequiredBehaviorElement(this.parseEnumeration(json.get("requiredBehavior").getAsString(), PlanDefinition.ActionRequiredBehavior.NULL, new PlanDefinition.ActionRequiredBehaviorEnumFactory()));
        }
        if (json.has("_requiredBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_requiredBehavior"), res.getRequiredBehaviorElement());
        }
        if (json.has("precheckBehavior")) {
            res.setPrecheckBehaviorElement(this.parseEnumeration(json.get("precheckBehavior").getAsString(), PlanDefinition.ActionPrecheckBehavior.NULL, new PlanDefinition.ActionPrecheckBehaviorEnumFactory()));
        }
        if (json.has("_precheckBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_precheckBehavior"), res.getPrecheckBehaviorElement());
        }
        if (json.has("cardinalityBehavior")) {
            res.setCardinalityBehaviorElement(this.parseEnumeration(json.get("cardinalityBehavior").getAsString(), PlanDefinition.ActionCardinalityBehavior.NULL, new PlanDefinition.ActionCardinalityBehaviorEnumFactory()));
        }
        if (json.has("_cardinalityBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_cardinalityBehavior"), res.getCardinalityBehaviorElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
        if (json.has("transform")) {
            res.setTransform(this.parseReference(json.getAsJsonObject("transform")));
        }
        if (json.has("dynamicValue")) {
            JsonArray array3 = json.getAsJsonArray("dynamicValue");
            for (i = 0; i < array3.size(); ++i) {
                res.getDynamicValue().add(this.parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(array3.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("action")) {
            JsonArray array4 = json.getAsJsonArray("action");
            for (i = 0; i < array4.size(); ++i) {
                res.getAction().add(this.parsePlanDefinitionPlanDefinitionActionComponent(array4.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected PlanDefinition.PlanDefinitionActionConditionComponent parsePlanDefinitionPlanDefinitionActionConditionComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionConditionComponent res = new PlanDefinition.PlanDefinitionActionConditionComponent();
        this.parsePlanDefinitionPlanDefinitionActionConditionComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionActionConditionComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionConditionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), PlanDefinition.ActionConditionKind.NULL, new PlanDefinition.ActionConditionKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseString(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
    }

    protected PlanDefinition.PlanDefinitionActionRelatedActionComponent parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionRelatedActionComponent res = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
        this.parsePlanDefinitionPlanDefinitionActionRelatedActionComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionActionRelatedActionComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionRelatedActionComponent res) throws IOException, FHIRFormatError {
        Type offset;
        this.parseBackboneProperties(json, res);
        if (json.has("actionId")) {
            res.setActionIdElement(this.parseId(json.get("actionId").getAsString()));
        }
        if (json.has("_actionId")) {
            this.parseElementProperties(json.getAsJsonObject("_actionId"), res.getActionIdElement());
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), PlanDefinition.ActionRelationshipType.NULL, new PlanDefinition.ActionRelationshipTypeEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
        }
        if ((offset = this.parseType("offset", json)) != null) {
            res.setOffset(offset);
        }
    }

    protected PlanDefinition.PlanDefinitionActionParticipantComponent parsePlanDefinitionPlanDefinitionActionParticipantComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionParticipantComponent res = new PlanDefinition.PlanDefinitionActionParticipantComponent();
        this.parsePlanDefinitionPlanDefinitionActionParticipantComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionActionParticipantComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), PlanDefinition.ActionParticipantType.NULL, new PlanDefinition.ActionParticipantTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
    }

    protected PlanDefinition.PlanDefinitionActionDynamicValueComponent parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
        PlanDefinition.PlanDefinitionActionDynamicValueComponent res = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
        this.parsePlanDefinitionPlanDefinitionActionDynamicValueComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePlanDefinitionPlanDefinitionActionDynamicValueComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionDynamicValueComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseString(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
    }

    protected Practitioner parsePractitioner(JsonObject json) throws IOException, FHIRFormatError {
        Practitioner res = new Practitioner();
        this.parsePractitionerProperties(json, res);
        return res;
    }

    protected void parsePractitionerProperties(JsonObject json, Practitioner res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("photo")) {
            array = json.getAsJsonArray("photo");
            for (i = 0; i < array.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("qualification")) {
            array = json.getAsJsonArray("qualification");
            for (i = 0; i < array.size(); ++i) {
                res.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("communication")) {
            array = json.getAsJsonArray("communication");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
        Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
        this.parsePractitionerPractitionerQualificationComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePractitionerPractitionerQualificationComponentProperties(JsonObject json, Practitioner owner, Practitioner.PractitionerQualificationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("issuer")) {
            res.setIssuer(this.parseReference(json.getAsJsonObject("issuer")));
        }
    }

    protected PractitionerRole parsePractitionerRole(JsonObject json) throws IOException, FHIRFormatError {
        PractitionerRole res = new PractitionerRole();
        this.parsePractitionerRoleProperties(json, res);
        return res;
    }

    protected void parsePractitionerRoleProperties(JsonObject json, PractitionerRole res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("practitioner")) {
            res.setPractitioner(this.parseReference(json.getAsJsonObject("practitioner")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("healthcareService")) {
            array = json.getAsJsonArray("healthcareService");
            for (i = 0; i < array.size(); ++i) {
                res.getHealthcareService().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("availableTime")) {
            array = json.getAsJsonArray("availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parsePractitionerRolePractitionerRoleAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("notAvailable")) {
            array = json.getAsJsonArray("notAvailable");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailable().add(this.parsePractitionerRolePractitionerRoleNotAvailableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(json.get("availabilityExceptions").getAsString()));
        }
        if (json.has("_availabilityExceptions")) {
            this.parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        this.parsePractitionerRolePractitionerRoleAvailableTimeComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePractitionerRolePractitionerRoleAvailableTimeComponentProperties(JsonObject json, PractitionerRole owner, PractitionerRole.PractitionerRoleAvailableTimeComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = json.getAsJsonArray("daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                res.getDaysOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), PractitionerRole.DaysOfWeek.NULL, new PractitionerRole.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = json.getAsJsonArray("_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseEnumeration(null, PractitionerRole.DaysOfWeek.NULL, new PractitionerRole.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
        }
    }

    protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        this.parsePractitionerRolePractitionerRoleNotAvailableComponentProperties(json, owner, res);
        return res;
    }

    protected void parsePractitionerRolePractitionerRoleNotAvailableComponentProperties(JsonObject json, PractitionerRole owner, PractitionerRole.PractitionerRoleNotAvailableComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(json.getAsJsonObject("during")));
        }
    }

    protected Procedure parseProcedure(JsonObject json) throws IOException, FHIRFormatError {
        Procedure res = new Procedure();
        this.parseProcedureProperties(json, res);
        return res;
    }

    protected void parseProcedureProperties(JsonObject json, Procedure res) throws IOException, FHIRFormatError {
        int i;
        Type performed;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPartOf().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("notDone")) {
            res.setNotDoneElement(this.parseBoolean(json.get("notDone").getAsBoolean()));
        }
        if (json.has("_notDone")) {
            this.parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
        }
        if (json.has("notDoneReason")) {
            res.setNotDoneReason(this.parseCodeableConcept(json.getAsJsonObject("notDoneReason")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((performed = this.parseType("performed", json)) != null) {
            res.setPerformed(performed);
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (i = 0; i < array2.size(); ++i) {
                res.getPerformer().add(this.parseProcedureProcedurePerformerComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("reasonCode")) {
            JsonArray array3 = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array3.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            JsonArray array4 = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array4.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            JsonArray array5 = json.getAsJsonArray("bodySite");
            for (i = 0; i < array5.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("report")) {
            JsonArray array6 = json.getAsJsonArray("report");
            for (i = 0; i < array6.size(); ++i) {
                res.getReport().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("complication")) {
            JsonArray array7 = json.getAsJsonArray("complication");
            for (i = 0; i < array7.size(); ++i) {
                res.getComplication().add(this.parseCodeableConcept(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("complicationDetail")) {
            JsonArray array8 = json.getAsJsonArray("complicationDetail");
            for (i = 0; i < array8.size(); ++i) {
                res.getComplicationDetail().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("followUp")) {
            JsonArray array9 = json.getAsJsonArray("followUp");
            for (i = 0; i < array9.size(); ++i) {
                res.getFollowUp().add(this.parseCodeableConcept(array9.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array10 = json.getAsJsonArray("note");
            for (i = 0; i < array10.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array10.get(i).getAsJsonObject()));
            }
        }
        if (json.has("focalDevice")) {
            JsonArray array11 = json.getAsJsonArray("focalDevice");
            for (i = 0; i < array11.size(); ++i) {
                res.getFocalDevice().add(this.parseProcedureProcedureFocalDeviceComponent(array11.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("usedReference")) {
            JsonArray array12 = json.getAsJsonArray("usedReference");
            for (i = 0; i < array12.size(); ++i) {
                res.getUsedReference().add(this.parseReference(array12.get(i).getAsJsonObject()));
            }
        }
        if (json.has("usedCode")) {
            JsonArray array13 = json.getAsJsonArray("usedCode");
            for (i = 0; i < array13.size(); ++i) {
                res.getUsedCode().add(this.parseCodeableConcept(array13.get(i).getAsJsonObject()));
            }
        }
    }

    protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
        Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
        this.parseProcedureProcedurePerformerComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProcedureProcedurePerformerComponentProperties(JsonObject json, Procedure owner, Procedure.ProcedurePerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
        Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
        this.parseProcedureProcedureFocalDeviceComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProcedureProcedureFocalDeviceComponentProperties(JsonObject json, Procedure owner, Procedure.ProcedureFocalDeviceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(json.getAsJsonObject("action")));
        }
        if (json.has("manipulated")) {
            res.setManipulated(this.parseReference(json.getAsJsonObject("manipulated")));
        }
    }

    protected ProcedureRequest parseProcedureRequest(JsonObject json) throws IOException, FHIRFormatError {
        ProcedureRequest res = new ProcedureRequest();
        this.parseProcedureRequestProperties(json, res);
        return res;
    }

    protected void parseProcedureRequestProperties(JsonObject json, ProcedureRequest res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type asNeeded;
        Type occurrence;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array2 = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array2 = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array2 = json.getAsJsonArray("replaces");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getReplaces().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("requisition")) {
            res.setRequisition(this.parseIdentifier(json.getAsJsonObject("requisition")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), ProcedureRequest.ProcedureRequestIntent.NULL, new ProcedureRequest.ProcedureRequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
        }
        if (json.has("category")) {
            array2 = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseProcedureRequestProcedureRequestRequesterComponent(json.getAsJsonObject("requester"), res));
        }
        if (json.has("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(json.getAsJsonObject("performerType")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimen")) {
            array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relevantHistory")) {
            array = json.getAsJsonArray("relevantHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ProcedureRequest.ProcedureRequestRequesterComponent parseProcedureRequestProcedureRequestRequesterComponent(JsonObject json, ProcedureRequest owner) throws IOException, FHIRFormatError {
        ProcedureRequest.ProcedureRequestRequesterComponent res = new ProcedureRequest.ProcedureRequestRequesterComponent();
        this.parseProcedureRequestProcedureRequestRequesterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProcedureRequestProcedureRequestRequesterComponentProperties(JsonObject json, ProcedureRequest owner, ProcedureRequest.ProcedureRequestRequesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("agent")) {
            res.setAgent(this.parseReference(json.getAsJsonObject("agent")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected ProcessRequest parseProcessRequest(JsonObject json) throws IOException, FHIRFormatError {
        ProcessRequest res = new ProcessRequest();
        this.parseProcessRequestProperties(json, res);
        return res;
    }

    protected void parseProcessRequestProperties(JsonObject json, ProcessRequest res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ProcessRequest.ProcessRequestStatus.NULL, new ProcessRequest.ProcessRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("nullify")) {
            res.setNullifyElement(this.parseBoolean(json.get("nullify").getAsBoolean()));
        }
        if (json.has("_nullify")) {
            this.parseElementProperties(json.getAsJsonObject("_nullify"), res.getNullifyElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseProcessRequestItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("include")) {
            array = json.getAsJsonArray("include");
            for (i = 0; i < array.size(); ++i) {
                res.getInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_include")) {
            array = json.getAsJsonArray("_include");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInclude().size()) {
                    res.getInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInclude().get(i));
            }
        }
        if (json.has("exclude")) {
            array = json.getAsJsonArray("exclude");
            for (i = 0; i < array.size(); ++i) {
                res.getExclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_exclude")) {
            array = json.getAsJsonArray("_exclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExclude().size()) {
                    res.getExclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getExclude().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(JsonObject json, ProcessRequest owner) throws IOException, FHIRFormatError {
        ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
        this.parseProcessRequestItemsComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProcessRequestItemsComponentProperties(JsonObject json, ProcessRequest owner, ProcessRequest.ItemsComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parseInteger(json.get("sequenceLinkId").getAsLong()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
    }

    protected ProcessResponse parseProcessResponse(JsonObject json) throws IOException, FHIRFormatError {
        ProcessResponse res = new ProcessResponse();
        this.parseProcessResponseProperties(json, res);
        return res;
    }

    protected void parseProcessResponseProperties(JsonObject json, ProcessResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ProcessResponse.ProcessResponseStatus.NULL, new ProcessResponse.ProcessResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("processNote")) {
            array = json.getAsJsonArray("processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseProcessResponseProcessResponseProcessNoteComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("communicationRequest")) {
            array = json.getAsJsonArray("communicationRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunicationRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ProcessResponse.ProcessResponseProcessNoteComponent parseProcessResponseProcessResponseProcessNoteComponent(JsonObject json, ProcessResponse owner) throws IOException, FHIRFormatError {
        ProcessResponse.ProcessResponseProcessNoteComponent res = new ProcessResponse.ProcessResponseProcessNoteComponent();
        this.parseProcessResponseProcessResponseProcessNoteComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProcessResponseProcessResponseProcessNoteComponentProperties(JsonObject json, ProcessResponse owner, ProcessResponse.ProcessResponseProcessNoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
    }

    protected Provenance parseProvenance(JsonObject json) throws IOException, FHIRFormatError {
        Provenance res = new Provenance();
        this.parseProvenanceProperties(json, res);
        return res;
    }

    protected void parseProvenanceProperties(JsonObject json, Provenance res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            res.setActivity(this.parseCoding(json.getAsJsonObject("activity")));
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("entity")) {
            array = json.getAsJsonArray("entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseProvenanceProvenanceEntityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("signature")) {
            array = json.getAsJsonArray("signature");
            for (i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
        this.parseProvenanceProvenanceAgentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProvenanceProvenanceAgentComponentProperties(JsonObject json, Provenance owner, Provenance.ProvenanceAgentComponent res) throws IOException, FHIRFormatError {
        Type onBehalfOf;
        Type who;
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if ((who = this.parseType("who", json)) != null) {
            res.setWho(who);
        }
        if ((onBehalfOf = this.parseType("onBehalfOf", json)) != null) {
            res.setOnBehalfOf(onBehalfOf);
        }
        if (json.has("relatedAgentType")) {
            res.setRelatedAgentType(this.parseCodeableConcept(json.getAsJsonObject("relatedAgentType")));
        }
    }

    protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
        this.parseProvenanceProvenanceEntityComponentProperties(json, owner, res);
        return res;
    }

    protected void parseProvenanceProvenanceEntityComponentProperties(JsonObject json, Provenance owner, Provenance.ProvenanceEntityComponent res) throws IOException, FHIRFormatError {
        Type what;
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRoleElement(this.parseEnumeration(json.get("role").getAsString(), Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
        }
        if (json.has("_role")) {
            this.parseElementProperties(json.getAsJsonObject("_role"), res.getRoleElement());
        }
        if ((what = this.parseType("what", json)) != null) {
            res.setWhat(what);
        }
        if (json.has("agent")) {
            JsonArray array = json.getAsJsonArray("agent");
            for (int i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected Questionnaire parseQuestionnaire(JsonObject json) throws IOException, FHIRFormatError {
        Questionnaire res = new Questionnaire();
        this.parseQuestionnaireProperties(json, res);
        return res;
    }

    protected void parseQuestionnaireProperties(JsonObject json, Questionnaire res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(json.getAsJsonObject("effectivePeriod")));
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subjectType")) {
            array = json.getAsJsonArray("subjectType");
            for (i = 0; i < array.size(); ++i) {
                res.getSubjectType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_subjectType")) {
            array = json.getAsJsonArray("_subjectType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSubjectType().size()) {
                    res.getSubjectType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSubjectType().get(i));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
        this.parseQuestionnaireQuestionnaireItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseQuestionnaireQuestionnaireItemComponentProperties(JsonObject json, Questionnaire owner, Questionnaire.QuestionnaireItemComponent res) throws IOException, FHIRFormatError {
        Type initial;
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseUri(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prefix")) {
            res.setPrefixElement(this.parseString(json.get("prefix").getAsString()));
        }
        if (json.has("_prefix")) {
            this.parseElementProperties(json.getAsJsonObject("_prefix"), res.getPrefixElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Questionnaire.QuestionnaireItemType.NULL, new Questionnaire.QuestionnaireItemTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("enableWhen")) {
            array = json.getAsJsonArray("enableWhen");
            for (i = 0; i < array.size(); ++i) {
                res.getEnableWhen().add(this.parseQuestionnaireQuestionnaireItemEnableWhenComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("repeats")) {
            res.setRepeatsElement(this.parseBoolean(json.get("repeats").getAsBoolean()));
        }
        if (json.has("_repeats")) {
            this.parseElementProperties(json.getAsJsonObject("_repeats"), res.getRepeatsElement());
        }
        if (json.has("readOnly")) {
            res.setReadOnlyElement(this.parseBoolean(json.get("readOnly").getAsBoolean()));
        }
        if (json.has("_readOnly")) {
            this.parseElementProperties(json.getAsJsonObject("_readOnly"), res.getReadOnlyElement());
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("options")) {
            res.setOptions(this.parseReference(json.getAsJsonObject("options")));
        }
        if (json.has("option")) {
            array = json.getAsJsonArray("option");
            for (i = 0; i < array.size(); ++i) {
                res.getOption().add(this.parseQuestionnaireQuestionnaireItemOptionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if ((initial = this.parseType("initial", json)) != null) {
            res.setInitial(initial);
        }
        if (json.has("item")) {
            JsonArray array2 = json.getAsJsonArray("item");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(array2.get(i2).getAsJsonObject(), owner));
            }
        }
    }

    protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        this.parseQuestionnaireQuestionnaireItemEnableWhenComponentProperties(json, owner, res);
        return res;
    }

    protected void parseQuestionnaireQuestionnaireItemEnableWhenComponentProperties(JsonObject json, Questionnaire owner, Questionnaire.QuestionnaireItemEnableWhenComponent res) throws IOException, FHIRFormatError {
        Type answer;
        this.parseBackboneProperties(json, res);
        if (json.has("question")) {
            res.setQuestionElement(this.parseString(json.get("question").getAsString()));
        }
        if (json.has("_question")) {
            this.parseElementProperties(json.getAsJsonObject("_question"), res.getQuestionElement());
        }
        if (json.has("hasAnswer")) {
            res.setHasAnswerElement(this.parseBoolean(json.get("hasAnswer").getAsBoolean()));
        }
        if (json.has("_hasAnswer")) {
            this.parseElementProperties(json.getAsJsonObject("_hasAnswer"), res.getHasAnswerElement());
        }
        if ((answer = this.parseType("answer", json)) != null) {
            res.setAnswer(answer);
        }
    }

    protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
        this.parseQuestionnaireQuestionnaireItemOptionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseQuestionnaireQuestionnaireItemOptionComponentProperties(JsonObject json, Questionnaire owner, Questionnaire.QuestionnaireItemOptionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
    }

    protected QuestionnaireResponse parseQuestionnaireResponse(JsonObject json) throws IOException, FHIRFormatError {
        QuestionnaireResponse res = new QuestionnaireResponse();
        this.parseQuestionnaireResponseProperties(json, res);
        return res;
    }

    protected void parseQuestionnaireResponseProperties(JsonObject json, QuestionnaireResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parent")) {
            array = json.getAsJsonArray("parent");
            for (i = 0; i < array.size(); ++i) {
                res.getParent().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("questionnaire")) {
            res.setQuestionnaire(this.parseReference(json.getAsJsonObject("questionnaire")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("authored")) {
            res.setAuthoredElement(this.parseDateTime(json.get("authored").getAsString()));
        }
        if (json.has("_authored")) {
            this.parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        this.parseQuestionnaireResponseQuestionnaireResponseItemComponentProperties(json, owner, res);
        return res;
    }

    protected void parseQuestionnaireResponseQuestionnaireResponseItemComponentProperties(JsonObject json, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseUri(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("answer")) {
            array = json.getAsJsonArray("answer");
            for (i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        this.parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentProperties(json, owner, res);
        return res;
    }

    protected void parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentProperties(JsonObject json, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        Type value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected ReferralRequest parseReferralRequest(JsonObject json) throws IOException, FHIRFormatError {
        ReferralRequest res = new ReferralRequest();
        this.parseReferralRequestProperties(json, res);
        return res;
    }

    protected void parseReferralRequestProperties(JsonObject json, ReferralRequest res) throws IOException, FHIRFormatError {
        int i;
        Type occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReplaces().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(json.getAsJsonObject("groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ReferralRequest.ReferralRequestStatus.NULL, new ReferralRequest.ReferralRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), ReferralRequest.ReferralCategory.NULL, new ReferralRequest.ReferralCategoryEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), ReferralRequest.ReferralPriority.NULL, new ReferralRequest.ReferralPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("serviceRequested")) {
            array = json.getAsJsonArray("serviceRequested");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getServiceRequested().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReferralRequestReferralRequestRequesterComponent(json.getAsJsonObject("requester"), res));
        }
        if (json.has("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(json.getAsJsonObject("specialty")));
        }
        if (json.has("recipient")) {
            JsonArray array2 = json.getAsJsonArray("recipient");
            for (i = 0; i < array2.size(); ++i) {
                res.getRecipient().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonCode")) {
            JsonArray array3 = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array3.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            JsonArray array4 = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array4.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("supportingInfo")) {
            JsonArray array5 = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array5.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array6 = json.getAsJsonArray("note");
            for (i = 0; i < array6.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relevantHistory")) {
            JsonArray array7 = json.getAsJsonArray("relevantHistory");
            for (i = 0; i < array7.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(array7.get(i).getAsJsonObject()));
            }
        }
    }

    protected ReferralRequest.ReferralRequestRequesterComponent parseReferralRequestReferralRequestRequesterComponent(JsonObject json, ReferralRequest owner) throws IOException, FHIRFormatError {
        ReferralRequest.ReferralRequestRequesterComponent res = new ReferralRequest.ReferralRequestRequesterComponent();
        this.parseReferralRequestReferralRequestRequesterComponentProperties(json, owner, res);
        return res;
    }

    protected void parseReferralRequestReferralRequestRequesterComponentProperties(JsonObject json, ReferralRequest owner, ReferralRequest.ReferralRequestRequesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("agent")) {
            res.setAgent(this.parseReference(json.getAsJsonObject("agent")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(json.getAsJsonObject("onBehalfOf")));
        }
    }

    protected RelatedPerson parseRelatedPerson(JsonObject json) throws IOException, FHIRFormatError {
        RelatedPerson res = new RelatedPerson();
        this.parseRelatedPersonProperties(json, res);
        return res;
    }

    protected void parseRelatedPersonProperties(JsonObject json, RelatedPerson res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("photo")) {
            array = json.getAsJsonArray("photo");
            for (i = 0; i < array.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
    }

    protected RequestGroup parseRequestGroup(JsonObject json) throws IOException, FHIRFormatError {
        RequestGroup res = new RequestGroup();
        this.parseRequestGroupProperties(json, res);
        return res;
    }

    protected void parseRequestGroupProperties(JsonObject json, RequestGroup res) throws IOException, FHIRFormatError {
        int i;
        Type reason;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDefinition().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReplaces().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(json.getAsJsonObject("groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), RequestGroup.RequestStatus.NULL, new RequestGroup.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), RequestGroup.RequestIntent.NULL, new RequestGroup.RequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), RequestGroup.RequestPriority.NULL, new RequestGroup.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("note")) {
            JsonArray array2 = json.getAsJsonArray("note");
            for (i = 0; i < array2.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            JsonArray array3 = json.getAsJsonArray("action");
            for (i = 0; i < array3.size(); ++i) {
                res.getAction().add(this.parseRequestGroupRequestGroupActionComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected RequestGroup.RequestGroupActionComponent parseRequestGroupRequestGroupActionComponent(JsonObject json, RequestGroup owner) throws IOException, FHIRFormatError {
        RequestGroup.RequestGroupActionComponent res = new RequestGroup.RequestGroupActionComponent();
        this.parseRequestGroupRequestGroupActionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseRequestGroupRequestGroupActionComponentProperties(JsonObject json, RequestGroup owner, RequestGroup.RequestGroupActionComponent res) throws IOException, FHIRFormatError {
        int i;
        Type timing;
        int i2;
        JsonArray array;
        this.parseBackboneProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("textEquivalent")) {
            res.setTextEquivalentElement(this.parseString(json.get("textEquivalent").getAsString()));
        }
        if (json.has("_textEquivalent")) {
            this.parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCode().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("documentation")) {
            array = json.getAsJsonArray("documentation");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDocumentation().add(this.parseRelatedArtifact(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCondition().add(this.parseRequestGroupRequestGroupActionConditionComponent(array.get(i2).getAsJsonObject(), owner));
            }
        }
        if (json.has("relatedAction")) {
            array = json.getAsJsonArray("relatedAction");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRelatedAction().add(this.parseRequestGroupRequestGroupActionRelatedActionComponent(array.get(i2).getAsJsonObject(), owner));
            }
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("participant")) {
            JsonArray array2 = json.getAsJsonArray("participant");
            for (i = 0; i < array2.size(); ++i) {
                res.getParticipant().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("groupingBehavior")) {
            res.setGroupingBehaviorElement(this.parseEnumeration(json.get("groupingBehavior").getAsString(), RequestGroup.ActionGroupingBehavior.NULL, new RequestGroup.ActionGroupingBehaviorEnumFactory()));
        }
        if (json.has("_groupingBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_groupingBehavior"), res.getGroupingBehaviorElement());
        }
        if (json.has("selectionBehavior")) {
            res.setSelectionBehaviorElement(this.parseEnumeration(json.get("selectionBehavior").getAsString(), RequestGroup.ActionSelectionBehavior.NULL, new RequestGroup.ActionSelectionBehaviorEnumFactory()));
        }
        if (json.has("_selectionBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_selectionBehavior"), res.getSelectionBehaviorElement());
        }
        if (json.has("requiredBehavior")) {
            res.setRequiredBehaviorElement(this.parseEnumeration(json.get("requiredBehavior").getAsString(), RequestGroup.ActionRequiredBehavior.NULL, new RequestGroup.ActionRequiredBehaviorEnumFactory()));
        }
        if (json.has("_requiredBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_requiredBehavior"), res.getRequiredBehaviorElement());
        }
        if (json.has("precheckBehavior")) {
            res.setPrecheckBehaviorElement(this.parseEnumeration(json.get("precheckBehavior").getAsString(), RequestGroup.ActionPrecheckBehavior.NULL, new RequestGroup.ActionPrecheckBehaviorEnumFactory()));
        }
        if (json.has("_precheckBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_precheckBehavior"), res.getPrecheckBehaviorElement());
        }
        if (json.has("cardinalityBehavior")) {
            res.setCardinalityBehaviorElement(this.parseEnumeration(json.get("cardinalityBehavior").getAsString(), RequestGroup.ActionCardinalityBehavior.NULL, new RequestGroup.ActionCardinalityBehaviorEnumFactory()));
        }
        if (json.has("_cardinalityBehavior")) {
            this.parseElementProperties(json.getAsJsonObject("_cardinalityBehavior"), res.getCardinalityBehaviorElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        if (json.has("action")) {
            JsonArray array3 = json.getAsJsonArray("action");
            for (i = 0; i < array3.size(); ++i) {
                res.getAction().add(this.parseRequestGroupRequestGroupActionComponent(array3.get(i).getAsJsonObject(), owner));
            }
        }
    }

    protected RequestGroup.RequestGroupActionConditionComponent parseRequestGroupRequestGroupActionConditionComponent(JsonObject json, RequestGroup owner) throws IOException, FHIRFormatError {
        RequestGroup.RequestGroupActionConditionComponent res = new RequestGroup.RequestGroupActionConditionComponent();
        this.parseRequestGroupRequestGroupActionConditionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseRequestGroupRequestGroupActionConditionComponentProperties(JsonObject json, RequestGroup owner, RequestGroup.RequestGroupActionConditionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), RequestGroup.ActionConditionKind.NULL, new RequestGroup.ActionConditionKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseString(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
    }

    protected RequestGroup.RequestGroupActionRelatedActionComponent parseRequestGroupRequestGroupActionRelatedActionComponent(JsonObject json, RequestGroup owner) throws IOException, FHIRFormatError {
        RequestGroup.RequestGroupActionRelatedActionComponent res = new RequestGroup.RequestGroupActionRelatedActionComponent();
        this.parseRequestGroupRequestGroupActionRelatedActionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseRequestGroupRequestGroupActionRelatedActionComponentProperties(JsonObject json, RequestGroup owner, RequestGroup.RequestGroupActionRelatedActionComponent res) throws IOException, FHIRFormatError {
        Type offset;
        this.parseBackboneProperties(json, res);
        if (json.has("actionId")) {
            res.setActionIdElement(this.parseId(json.get("actionId").getAsString()));
        }
        if (json.has("_actionId")) {
            this.parseElementProperties(json.getAsJsonObject("_actionId"), res.getActionIdElement());
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), RequestGroup.ActionRelationshipType.NULL, new RequestGroup.ActionRelationshipTypeEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
        }
        if ((offset = this.parseType("offset", json)) != null) {
            res.setOffset(offset);
        }
    }

    protected ResearchStudy parseResearchStudy(JsonObject json) throws IOException, FHIRFormatError {
        ResearchStudy res = new ResearchStudy();
        this.parseResearchStudyProperties(json, res);
        return res;
    }

    protected void parseResearchStudyProperties(JsonObject json, ResearchStudy res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("protocol")) {
            array = json.getAsJsonArray("protocol");
            for (i = 0; i < array.size(); ++i) {
                res.getProtocol().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ResearchStudy.ResearchStudyStatus.NULL, new ResearchStudy.ResearchStudyStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("focus")) {
            array = json.getAsJsonArray("focus");
            for (i = 0; i < array.size(); ++i) {
                res.getFocus().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("keyword")) {
            array = json.getAsJsonArray("keyword");
            for (i = 0; i < array.size(); ++i) {
                res.getKeyword().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("enrollment")) {
            array = json.getAsJsonArray("enrollment");
            for (i = 0; i < array.size(); ++i) {
                res.getEnrollment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("sponsor")) {
            res.setSponsor(this.parseReference(json.getAsJsonObject("sponsor")));
        }
        if (json.has("principalInvestigator")) {
            res.setPrincipalInvestigator(this.parseReference(json.getAsJsonObject("principalInvestigator")));
        }
        if (json.has("site")) {
            array = json.getAsJsonArray("site");
            for (i = 0; i < array.size(); ++i) {
                res.getSite().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonStopped")) {
            res.setReasonStopped(this.parseCodeableConcept(json.getAsJsonObject("reasonStopped")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("arm")) {
            array = json.getAsJsonArray("arm");
            for (i = 0; i < array.size(); ++i) {
                res.getArm().add(this.parseResearchStudyResearchStudyArmComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected ResearchStudy.ResearchStudyArmComponent parseResearchStudyResearchStudyArmComponent(JsonObject json, ResearchStudy owner) throws IOException, FHIRFormatError {
        ResearchStudy.ResearchStudyArmComponent res = new ResearchStudy.ResearchStudyArmComponent();
        this.parseResearchStudyResearchStudyArmComponentProperties(json, owner, res);
        return res;
    }

    protected void parseResearchStudyResearchStudyArmComponentProperties(JsonObject json, ResearchStudy owner, ResearchStudy.ResearchStudyArmComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
    }

    protected ResearchSubject parseResearchSubject(JsonObject json) throws IOException, FHIRFormatError {
        ResearchSubject res = new ResearchSubject();
        this.parseResearchSubjectProperties(json, res);
        return res;
    }

    protected void parseResearchSubjectProperties(JsonObject json, ResearchSubject res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ResearchSubject.ResearchSubjectStatus.NULL, new ResearchSubject.ResearchSubjectStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("study")) {
            res.setStudy(this.parseReference(json.getAsJsonObject("study")));
        }
        if (json.has("individual")) {
            res.setIndividual(this.parseReference(json.getAsJsonObject("individual")));
        }
        if (json.has("assignedArm")) {
            res.setAssignedArmElement(this.parseString(json.get("assignedArm").getAsString()));
        }
        if (json.has("_assignedArm")) {
            this.parseElementProperties(json.getAsJsonObject("_assignedArm"), res.getAssignedArmElement());
        }
        if (json.has("actualArm")) {
            res.setActualArmElement(this.parseString(json.get("actualArm").getAsString()));
        }
        if (json.has("_actualArm")) {
            this.parseElementProperties(json.getAsJsonObject("_actualArm"), res.getActualArmElement());
        }
        if (json.has("consent")) {
            res.setConsent(this.parseReference(json.getAsJsonObject("consent")));
        }
    }

    protected RiskAssessment parseRiskAssessment(JsonObject json) throws IOException, FHIRFormatError {
        RiskAssessment res = new RiskAssessment();
        this.parseRiskAssessmentProperties(json, res);
        return res;
    }

    protected void parseRiskAssessmentProperties(JsonObject json, RiskAssessment res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type reason;
        Type occurrence;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("basedOn")) {
            res.setBasedOn(this.parseReference(json.getAsJsonObject("basedOn")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), RiskAssessment.RiskAssessmentStatus.NULL, new RiskAssessment.RiskAssessmentStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("condition")) {
            res.setCondition(this.parseReference(json.getAsJsonObject("condition")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("basis")) {
            array = json.getAsJsonArray("basis");
            for (i = 0; i < array.size(); ++i) {
                res.getBasis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prediction")) {
            array = json.getAsJsonArray("prediction");
            for (i = 0; i < array.size(); ++i) {
                res.getPrediction().add(this.parseRiskAssessmentRiskAssessmentPredictionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("mitigation")) {
            res.setMitigationElement(this.parseString(json.get("mitigation").getAsString()));
        }
        if (json.has("_mitigation")) {
            this.parseElementProperties(json.getAsJsonObject("_mitigation"), res.getMitigationElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
    }

    protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(JsonObject json, RiskAssessment owner) throws IOException, FHIRFormatError {
        RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.parseRiskAssessmentRiskAssessmentPredictionComponentProperties(json, owner, res);
        return res;
    }

    protected void parseRiskAssessmentRiskAssessmentPredictionComponentProperties(JsonObject json, RiskAssessment owner, RiskAssessment.RiskAssessmentPredictionComponent res) throws IOException, FHIRFormatError {
        Type when;
        Type probability;
        this.parseBackboneProperties(json, res);
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if ((probability = this.parseType("probability", json)) != null) {
            res.setProbability(probability);
        }
        if (json.has("qualitativeRisk")) {
            res.setQualitativeRisk(this.parseCodeableConcept(json.getAsJsonObject("qualitativeRisk")));
        }
        if (json.has("relativeRisk")) {
            res.setRelativeRiskElement(this.parseDecimal(json.get("relativeRisk").getAsBigDecimal()));
        }
        if (json.has("_relativeRisk")) {
            this.parseElementProperties(json.getAsJsonObject("_relativeRisk"), res.getRelativeRiskElement());
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
        if (json.has("rationale")) {
            res.setRationaleElement(this.parseString(json.get("rationale").getAsString()));
        }
        if (json.has("_rationale")) {
            this.parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
        }
    }

    protected Schedule parseSchedule(JsonObject json) throws IOException, FHIRFormatError {
        Schedule res = new Schedule();
        this.parseScheduleProperties(json, res);
        return res;
    }

    protected void parseScheduleProperties(JsonObject json, Schedule res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("planningHorizon")) {
            res.setPlanningHorizon(this.parsePeriod(json.getAsJsonObject("planningHorizon")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
    }

    protected SearchParameter parseSearchParameter(JsonObject json) throws IOException, FHIRFormatError {
        SearchParameter res = new SearchParameter();
        this.parseSearchParameterProperties(json, res);
        return res;
    }

    protected void parseSearchParameterProperties(JsonObject json, SearchParameter res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("base")) {
            array = json.getAsJsonArray("base");
            for (i = 0; i < array.size(); ++i) {
                res.getBase().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_base")) {
            array = json.getAsJsonArray("_base");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getBase().size()) {
                    res.getBase().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getBase().get(i));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("derivedFrom")) {
            res.setDerivedFromElement(this.parseUri(json.get("derivedFrom").getAsString()));
        }
        if (json.has("_derivedFrom")) {
            this.parseElementProperties(json.getAsJsonObject("_derivedFrom"), res.getDerivedFromElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
        }
        if (json.has("xpathUsage")) {
            res.setXpathUsageElement(this.parseEnumeration(json.get("xpathUsage").getAsString(), SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
        }
        if (json.has("_xpathUsage")) {
            this.parseElementProperties(json.getAsJsonObject("_xpathUsage"), res.getXpathUsageElement());
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_target")) {
            array = json.getAsJsonArray("_target");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTarget().size()) {
                    res.getTarget().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
            }
        }
        if (json.has("comparator")) {
            array = json.getAsJsonArray("comparator");
            for (i = 0; i < array.size(); ++i) {
                res.getComparator().add(this.parseEnumeration(array.get(i).getAsString(), SearchParameter.SearchComparator.NULL, new SearchParameter.SearchComparatorEnumFactory()));
            }
        }
        if (json.has("_comparator")) {
            array = json.getAsJsonArray("_comparator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getComparator().size()) {
                    res.getComparator().add(this.parseEnumeration(null, SearchParameter.SearchComparator.NULL, new SearchParameter.SearchComparatorEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getComparator().get(i));
            }
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseEnumeration(array.get(i).getAsString(), SearchParameter.SearchModifierCode.NULL, new SearchParameter.SearchModifierCodeEnumFactory()));
            }
        }
        if (json.has("_modifier")) {
            array = json.getAsJsonArray("_modifier");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getModifier().size()) {
                    res.getModifier().add(this.parseEnumeration(null, SearchParameter.SearchModifierCode.NULL, new SearchParameter.SearchModifierCodeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getModifier().get(i));
            }
        }
        if (json.has("chain")) {
            array = json.getAsJsonArray("chain");
            for (i = 0; i < array.size(); ++i) {
                res.getChain().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_chain")) {
            array = json.getAsJsonArray("_chain");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getChain().size()) {
                    res.getChain().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getChain().get(i));
            }
        }
        if (json.has("component")) {
            array = json.getAsJsonArray("component");
            for (i = 0; i < array.size(); ++i) {
                res.getComponent().add(this.parseSearchParameterSearchParameterComponentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
    }

    protected SearchParameter.SearchParameterComponentComponent parseSearchParameterSearchParameterComponentComponent(JsonObject json, SearchParameter owner) throws IOException, FHIRFormatError {
        SearchParameter.SearchParameterComponentComponent res = new SearchParameter.SearchParameterComponentComponent();
        this.parseSearchParameterSearchParameterComponentComponentProperties(json, owner, res);
        return res;
    }

    protected void parseSearchParameterSearchParameterComponentComponentProperties(JsonObject json, SearchParameter owner, SearchParameter.SearchParameterComponentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
    }

    protected Sequence parseSequence(JsonObject json) throws IOException, FHIRFormatError {
        Sequence res = new Sequence();
        this.parseSequenceProperties(json, res);
        return res;
    }

    protected void parseSequenceProperties(JsonObject json, Sequence res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Sequence.SequenceType.NULL, new Sequence.SequenceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("coordinateSystem")) {
            res.setCoordinateSystemElement(this.parseInteger(json.get("coordinateSystem").getAsLong()));
        }
        if (json.has("_coordinateSystem")) {
            this.parseElementProperties(json.getAsJsonObject("_coordinateSystem"), res.getCoordinateSystemElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("specimen")) {
            res.setSpecimen(this.parseReference(json.getAsJsonObject("specimen")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("referenceSeq")) {
            res.setReferenceSeq(this.parseSequenceSequenceReferenceSeqComponent(json.getAsJsonObject("referenceSeq"), res));
        }
        if (json.has("variant")) {
            array = json.getAsJsonArray("variant");
            for (i = 0; i < array.size(); ++i) {
                res.getVariant().add(this.parseSequenceSequenceVariantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("observedSeq")) {
            res.setObservedSeqElement(this.parseString(json.get("observedSeq").getAsString()));
        }
        if (json.has("_observedSeq")) {
            this.parseElementProperties(json.getAsJsonObject("_observedSeq"), res.getObservedSeqElement());
        }
        if (json.has("quality")) {
            array = json.getAsJsonArray("quality");
            for (i = 0; i < array.size(); ++i) {
                res.getQuality().add(this.parseSequenceSequenceQualityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("readCoverage")) {
            res.setReadCoverageElement(this.parseInteger(json.get("readCoverage").getAsLong()));
        }
        if (json.has("_readCoverage")) {
            this.parseElementProperties(json.getAsJsonObject("_readCoverage"), res.getReadCoverageElement());
        }
        if (json.has("repository")) {
            array = json.getAsJsonArray("repository");
            for (i = 0; i < array.size(); ++i) {
                res.getRepository().add(this.parseSequenceSequenceRepositoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("pointer")) {
            array = json.getAsJsonArray("pointer");
            for (i = 0; i < array.size(); ++i) {
                res.getPointer().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
        this.parseSequenceSequenceReferenceSeqComponentProperties(json, owner, res);
        return res;
    }

    protected void parseSequenceSequenceReferenceSeqComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceReferenceSeqComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("chromosome")) {
            res.setChromosome(this.parseCodeableConcept(json.getAsJsonObject("chromosome")));
        }
        if (json.has("genomeBuild")) {
            res.setGenomeBuildElement(this.parseString(json.get("genomeBuild").getAsString()));
        }
        if (json.has("_genomeBuild")) {
            this.parseElementProperties(json.getAsJsonObject("_genomeBuild"), res.getGenomeBuildElement());
        }
        if (json.has("referenceSeqId")) {
            res.setReferenceSeqId(this.parseCodeableConcept(json.getAsJsonObject("referenceSeqId")));
        }
        if (json.has("referenceSeqPointer")) {
            res.setReferenceSeqPointer(this.parseReference(json.getAsJsonObject("referenceSeqPointer")));
        }
        if (json.has("referenceSeqString")) {
            res.setReferenceSeqStringElement(this.parseString(json.get("referenceSeqString").getAsString()));
        }
        if (json.has("_referenceSeqString")) {
            this.parseElementProperties(json.getAsJsonObject("_referenceSeqString"), res.getReferenceSeqStringElement());
        }
        if (json.has("strand")) {
            res.setStrandElement(this.parseInteger(json.get("strand").getAsLong()));
        }
        if (json.has("_strand")) {
            this.parseElementProperties(json.getAsJsonObject("_strand"), res.getStrandElement());
        }
        if (json.has("windowStart")) {
            res.setWindowStartElement(this.parseInteger(json.get("windowStart").getAsLong()));
        }
        if (json.has("_windowStart")) {
            this.parseElementProperties(json.getAsJsonObject("_windowStart"), res.getWindowStartElement());
        }
        if (json.has("windowEnd")) {
            res.setWindowEndElement(this.parseInteger(json.get("windowEnd").getAsLong()));
        }
        if (json.has("_windowEnd")) {
            this.parseElementProperties(json.getAsJsonObject("_windowEnd"), res.getWindowEndElement());
        }
    }

    protected Sequence.SequenceVariantComponent parseSequenceSequenceVariantComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceVariantComponent res = new Sequence.SequenceVariantComponent();
        this.parseSequenceSequenceVariantComponentProperties(json, owner, res);
        return res;
    }

    protected void parseSequenceSequenceVariantComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceVariantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseInteger(json.get("start").getAsLong()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInteger(json.get("end").getAsLong()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("observedAllele")) {
            res.setObservedAlleleElement(this.parseString(json.get("observedAllele").getAsString()));
        }
        if (json.has("_observedAllele")) {
            this.parseElementProperties(json.getAsJsonObject("_observedAllele"), res.getObservedAlleleElement());
        }
        if (json.has("referenceAllele")) {
            res.setReferenceAlleleElement(this.parseString(json.get("referenceAllele").getAsString()));
        }
        if (json.has("_referenceAllele")) {
            this.parseElementProperties(json.getAsJsonObject("_referenceAllele"), res.getReferenceAlleleElement());
        }
        if (json.has("cigar")) {
            res.setCigarElement(this.parseString(json.get("cigar").getAsString()));
        }
        if (json.has("_cigar")) {
            this.parseElementProperties(json.getAsJsonObject("_cigar"), res.getCigarElement());
        }
        if (json.has("variantPointer")) {
            res.setVariantPointer(this.parseReference(json.getAsJsonObject("variantPointer")));
        }
    }

    protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
        this.parseSequenceSequenceQualityComponentProperties(json, owner, res);
        return res;
    }

    protected void parseSequenceSequenceQualityComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceQualityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Sequence.QualityType.NULL, new Sequence.QualityTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("standardSequence")) {
            res.setStandardSequence(this.parseCodeableConcept(json.getAsJsonObject("standardSequence")));
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInteger(json.get("start").getAsLong()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInteger(json.get("end").getAsLong()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("score")) {
            res.setScore(this.parseQuantity(json.getAsJsonObject("score")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("truthTP")) {
            res.setTruthTPElement(this.parseDecimal(json.get("truthTP").getAsBigDecimal()));
        }
        if (json.has("_truthTP")) {
            this.parseElementProperties(json.getAsJsonObject("_truthTP"), res.getTruthTPElement());
        }
        if (json.has("queryTP")) {
            res.setQueryTPElement(this.parseDecimal(json.get("queryTP").getAsBigDecimal()));
        }
        if (json.has("_queryTP")) {
            this.parseElementProperties(json.getAsJsonObject("_queryTP"), res.getQueryTPElement());
        }
        if (json.has("truthFN")) {
            res.setTruthFNElement(this.parseDecimal(json.get("truthFN").getAsBigDecimal()));
        }
        if (json.has("_truthFN")) {
            this.parseElementProperties(json.getAsJsonObject("_truthFN"), res.getTruthFNElement());
        }
        if (json.has("queryFP")) {
            res.setQueryFPElement(this.parseDecimal(json.get("queryFP").getAsBigDecimal()));
        }
        if (json.has("_queryFP")) {
            this.parseElementProperties(json.getAsJsonObject("_queryFP"), res.getQueryFPElement());
        }
        if (json.has("gtFP")) {
            res.setGtFPElement(this.parseDecimal(json.get("gtFP").getAsBigDecimal()));
        }
        if (json.has("_gtFP")) {
            this.parseElementProperties(json.getAsJsonObject("_gtFP"), res.getGtFPElement());
        }
        if (json.has("precision")) {
            res.setPrecisionElement(this.parseDecimal(json.get("precision").getAsBigDecimal()));
        }
        if (json.has("_precision")) {
            this.parseElementProperties(json.getAsJsonObject("_precision"), res.getPrecisionElement());
        }
        if (json.has("recall")) {
            res.setRecallElement(this.parseDecimal(json.get("recall").getAsBigDecimal()));
        }
        if (json.has("_recall")) {
            this.parseElementProperties(json.getAsJsonObject("_recall"), res.getRecallElement());
        }
        if (json.has("fScore")) {
            res.setFScoreElement(this.parseDecimal(json.get("fScore").getAsBigDecimal()));
        }
        if (json.has("_fScore")) {
            this.parseElementProperties(json.getAsJsonObject("_fScore"), res.getFScoreElement());
        }
    }

    protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
        this.parseSequenceSequenceRepositoryComponentProperties(json, owner, res);
        return res;
    }

    protected void parseSequenceSequenceRepositoryComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceRepositoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Sequence.RepositoryType.NULL, new Sequence.RepositoryTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("datasetId")) {
            res.setDatasetIdElement(this.parseString(json.get("datasetId").getAsString()));
        }
        if (json.has("_datasetId")) {
            this.parseElementProperti