/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Contract", profile="http://hl7.org/fhir/Profile/Contract")
public class Contract
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Contract number", formalDefinition="Unique identifier for this Contract.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="amended | appended | cancelled | disputed | entered-in-error | executable | executed | negotiable | offered | policy | rejected | renewed | revoked | resolved | terminated", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-status")
    protected Enumeration<ContractStatus> status;
    @Child(name="issued", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this Contract was issued", formalDefinition="When this  Contract was issued.")
    protected DateTimeType issued;
    @Child(name="applies", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Effective time", formalDefinition="Relevant time or time-period when this Contract is applicable.")
    protected Period applies;
    @Child(name="subject", type={Reference.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contract Target Entity", formalDefinition="The target entity impacted by or of interest to parties to the agreement.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="topic", type={Reference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Context of the Contract", formalDefinition="The matter of concern in the context of this agreement.")
    protected List<Reference> topic;
    protected List<Resource> topicTarget;
    @Child(name="authority", type={Organization.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Authority under which this Contract has standing", formalDefinition="A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.")
    protected List<Reference> authority;
    protected List<Organization> authorityTarget;
    @Child(name="domain", type={Location.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Domain in which this Contract applies", formalDefinition="Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.")
    protected List<Reference> domain;
    protected List<Location> domainTarget;
    @Child(name="type", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type or form", formalDefinition="Type of Contract such as an insurance policy, real estate contract, a will, power of attorny, Privacy or Security policy , trust framework agreement, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Subtype within the context of type", formalDefinition="More specific type or specialization of an overarching or more general contract such as auto insurance, home owner  insurance, prenupial agreement, Advanced-Directive, or privacy consent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-subtype")
    protected List<CodeableConcept> subType;
    @Child(name="action", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Action stipulated by this Contract", formalDefinition="Action stipulated by this Contract.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-action")
    protected List<CodeableConcept> action;
    @Child(name="actionReason", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Rationale for the stiplulated action", formalDefinition="Reason for action stipulated by this Contract.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-PurposeOfUse")
    protected List<CodeableConcept> actionReason;
    @Child(name="decisionType", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Decision by Grantor", formalDefinition="The type of decision made by a grantor with respect to an offer made by a grantee.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActConsentDirective")
    protected CodeableConcept decisionType;
    @Child(name="contentDerivative", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Content derived from the basal information", formalDefinition="The minimal content derived from the basal information source at a specific stage in its lifecycle.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-content-derivative")
    protected CodeableConcept contentDerivative;
    @Child(name="securityLabel", type={Coding.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Security Labels that define affected resources", formalDefinition="A set of security labels that define which resources are controlled by this consent. If more than one label is specified, all resources must have all the specified labels.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    protected List<Coding> securityLabel;
    @Child(name="agent", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entity being ascribed responsibility", formalDefinition="An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.")
    protected List<AgentComponent> agent;
    @Child(name="signer", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Signatory", formalDefinition="Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.")
    protected List<SignatoryComponent> signer;
    @Child(name="valuedItem", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Valued Item List", formalDefinition="Contract Valued Item List.")
    protected List<ValuedItemComponent> valuedItem;
    @Child(name="term", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Term List", formalDefinition="One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.")
    protected List<TermComponent> term;
    @Child(name="binding", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Binding Contract", formalDefinition="Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.")
    protected Type binding;
    @Child(name="friendly", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Friendly Language", formalDefinition="The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.")
    protected List<FriendlyLanguageComponent> friendly;
    @Child(name="legal", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Legal Language", formalDefinition="List of Legal expressions or representations of this Contract.")
    protected List<LegalLanguageComponent> legal;
    @Child(name="rule", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Computable Contract Language", formalDefinition="List of Computable Policy Rule Language Representations of this Contract.")
    protected List<ComputableLanguageComponent> rule;
    private static final long serialVersionUID = -254555038L;
    @SearchParamDefinition(name="identifier", path="Contract.identifier", description="The identity of the contract", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="agent", path="Contract.agent.actor", description="Agent to the Contact", type="reference", target={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class})
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("Contract:agent").toLocked();
    @SearchParamDefinition(name="patient", path="Contract.subject", description="The identity of the subject of the contract (if a patient)", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Contract:patient").toLocked();
    @SearchParamDefinition(name="subject", path="Contract.subject", description="The identity of the subject of the contract", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Contract:subject").toLocked();
    @SearchParamDefinition(name="authority", path="Contract.authority", description="The authority of the contract", type="reference", target={Organization.class})
    public static final String SP_AUTHORITY = "authority";
    public static final ReferenceClientParam AUTHORITY = new ReferenceClientParam("authority");
    public static final Include INCLUDE_AUTHORITY = new Include("Contract:authority").toLocked();
    @SearchParamDefinition(name="domain", path="Contract.domain", description="The domain of the contract", type="reference", target={Location.class})
    public static final String SP_DOMAIN = "domain";
    public static final ReferenceClientParam DOMAIN = new ReferenceClientParam("domain");
    public static final Include INCLUDE_DOMAIN = new Include("Contract:domain").toLocked();
    @SearchParamDefinition(name="term-topic", path="Contract.term.topic", description="The identity of the topic of the contract terms", type="reference")
    public static final String SP_TERM_TOPIC = "term-topic";
    public static final ReferenceClientParam TERM_TOPIC = new ReferenceClientParam("term-topic");
    public static final Include INCLUDE_TERM_TOPIC = new Include("Contract:term-topic").toLocked();
    @SearchParamDefinition(name="issued", path="Contract.issued", description="The date/time the contract was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="signer", path="Contract.signer.party", description="Contract Signatory Party", type="reference", target={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_SIGNER = "signer";
    public static final ReferenceClientParam SIGNER = new ReferenceClientParam("signer");
    public static final Include INCLUDE_SIGNER = new Include("Contract:signer").toLocked();

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Contract setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<ContractStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ContractStatus>(new ContractStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Contract setStatusElement(Enumeration<ContractStatus> value) {
        this.status = value;
        return this;
    }

    public ContractStatus getStatus() {
        return this.status == null ? null : (ContractStatus)((Object)this.status.getValue());
    }

    public Contract setStatus(ContractStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ContractStatus>(new ContractStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public DateTimeType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new DateTimeType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Contract setIssuedElement(DateTimeType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Contract setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new DateTimeType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public Period getApplies() {
        if (this.applies == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.applies");
            }
            if (Configuration.doAutoCreate()) {
                this.applies = new Period();
            }
        }
        return this.applies;
    }

    public boolean hasApplies() {
        return this.applies != null && !this.applies.isEmpty();
    }

    public Contract setApplies(Period value) {
        this.applies = value;
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public Contract setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public Contract addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public List<Reference> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        return this.topic;
    }

    public Contract setTopic(List<Reference> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (Reference item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTopic() {
        Reference t = new Reference();
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        this.topic.add(t);
        return t;
    }

    public Contract addTopic(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        this.topic.add(t);
        return this;
    }

    public Reference getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    @Deprecated
    public List<Resource> getTopicTarget() {
        if (this.topicTarget == null) {
            this.topicTarget = new ArrayList<Resource>();
        }
        return this.topicTarget;
    }

    public List<Reference> getAuthority() {
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        return this.authority;
    }

    public Contract setAuthority(List<Reference> theAuthority) {
        this.authority = theAuthority;
        return this;
    }

    public boolean hasAuthority() {
        if (this.authority == null) {
            return false;
        }
        for (Reference item : this.authority) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthority() {
        Reference t = new Reference();
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        this.authority.add(t);
        return t;
    }

    public Contract addAuthority(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        this.authority.add(t);
        return this;
    }

    public Reference getAuthorityFirstRep() {
        if (this.getAuthority().isEmpty()) {
            this.addAuthority();
        }
        return this.getAuthority().get(0);
    }

    @Deprecated
    public List<Organization> getAuthorityTarget() {
        if (this.authorityTarget == null) {
            this.authorityTarget = new ArrayList<Organization>();
        }
        return this.authorityTarget;
    }

    @Deprecated
    public Organization addAuthorityTarget() {
        Organization r = new Organization();
        if (this.authorityTarget == null) {
            this.authorityTarget = new ArrayList<Organization>();
        }
        this.authorityTarget.add(r);
        return r;
    }

    public List<Reference> getDomain() {
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        return this.domain;
    }

    public Contract setDomain(List<Reference> theDomain) {
        this.domain = theDomain;
        return this;
    }

    public boolean hasDomain() {
        if (this.domain == null) {
            return false;
        }
        for (Reference item : this.domain) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDomain() {
        Reference t = new Reference();
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        this.domain.add(t);
        return t;
    }

    public Contract addDomain(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        this.domain.add(t);
        return this;
    }

    public Reference getDomainFirstRep() {
        if (this.getDomain().isEmpty()) {
            this.addDomain();
        }
        return this.getDomain().get(0);
    }

    @Deprecated
    public List<Location> getDomainTarget() {
        if (this.domainTarget == null) {
            this.domainTarget = new ArrayList<Location>();
        }
        return this.domainTarget;
    }

    @Deprecated
    public Location addDomainTarget() {
        Location r = new Location();
        if (this.domainTarget == null) {
            this.domainTarget = new ArrayList<Location>();
        }
        this.domainTarget.add(r);
        return r;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Contract setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getSubType() {
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        return this.subType;
    }

    public Contract setSubType(List<CodeableConcept> theSubType) {
        this.subType = theSubType;
        return this;
    }

    public boolean hasSubType() {
        if (this.subType == null) {
            return false;
        }
        for (CodeableConcept item : this.subType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubType() {
        CodeableConcept t = new CodeableConcept();
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return t;
    }

    public Contract addSubType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return this;
    }

    public CodeableConcept getSubTypeFirstRep() {
        if (this.getSubType().isEmpty()) {
            this.addSubType();
        }
        return this.getSubType().get(0);
    }

    public List<CodeableConcept> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        return this.action;
    }

    public Contract setAction(List<CodeableConcept> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (CodeableConcept item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAction() {
        CodeableConcept t = new CodeableConcept();
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        this.action.add(t);
        return t;
    }

    public Contract addAction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        this.action.add(t);
        return this;
    }

    public CodeableConcept getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    public List<CodeableConcept> getActionReason() {
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        return this.actionReason;
    }

    public Contract setActionReason(List<CodeableConcept> theActionReason) {
        this.actionReason = theActionReason;
        return this;
    }

    public boolean hasActionReason() {
        if (this.actionReason == null) {
            return false;
        }
        for (CodeableConcept item : this.actionReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addActionReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        this.actionReason.add(t);
        return t;
    }

    public Contract addActionReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        this.actionReason.add(t);
        return this;
    }

    public CodeableConcept getActionReasonFirstRep() {
        if (this.getActionReason().isEmpty()) {
            this.addActionReason();
        }
        return this.getActionReason().get(0);
    }

    public CodeableConcept getDecisionType() {
        if (this.decisionType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.decisionType");
            }
            if (Configuration.doAutoCreate()) {
                this.decisionType = new CodeableConcept();
            }
        }
        return this.decisionType;
    }

    public boolean hasDecisionType() {
        return this.decisionType != null && !this.decisionType.isEmpty();
    }

    public Contract setDecisionType(CodeableConcept value) {
        this.decisionType = value;
        return this;
    }

    public CodeableConcept getContentDerivative() {
        if (this.contentDerivative == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.contentDerivative");
            }
            if (Configuration.doAutoCreate()) {
                this.contentDerivative = new CodeableConcept();
            }
        }
        return this.contentDerivative;
    }

    public boolean hasContentDerivative() {
        return this.contentDerivative != null && !this.contentDerivative.isEmpty();
    }

    public Contract setContentDerivative(CodeableConcept value) {
        this.contentDerivative = value;
        return this;
    }

    public List<Coding> getSecurityLabel() {
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<Coding>();
        }
        return this.securityLabel;
    }

    public Contract setSecurityLabel(List<Coding> theSecurityLabel) {
        this.securityLabel = theSecurityLabel;
        return this;
    }

    public boolean hasSecurityLabel() {
        if (this.securityLabel == null) {
            return false;
        }
        for (Coding item : this.securityLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSecurityLabel() {
        Coding t = new Coding();
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<Coding>();
        }
        this.securityLabel.add(t);
        return t;
    }

    public Contract addSecurityLabel(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<Coding>();
        }
        this.securityLabel.add(t);
        return this;
    }

    public Coding getSecurityLabelFirstRep() {
        if (this.getSecurityLabel().isEmpty()) {
            this.addSecurityLabel();
        }
        return this.getSecurityLabel().get(0);
    }

    public List<AgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<AgentComponent>();
        }
        return this.agent;
    }

    public Contract setAgent(List<AgentComponent> theAgent) {
        this.agent = theAgent;
        return this;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (AgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AgentComponent addAgent() {
        AgentComponent t = new AgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<AgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public Contract addAgent(AgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<AgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public AgentComponent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public List<SignatoryComponent> getSigner() {
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        return this.signer;
    }

    public Contract setSigner(List<SignatoryComponent> theSigner) {
        this.signer = theSigner;
        return this;
    }

    public boolean hasSigner() {
        if (this.signer == null) {
            return false;
        }
        for (SignatoryComponent item : this.signer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SignatoryComponent addSigner() {
        SignatoryComponent t = new SignatoryComponent();
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        this.signer.add(t);
        return t;
    }

    public Contract addSigner(SignatoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        this.signer.add(t);
        return this;
    }

    public SignatoryComponent getSignerFirstRep() {
        if (this.getSigner().isEmpty()) {
            this.addSigner();
        }
        return this.getSigner().get(0);
    }

    public List<ValuedItemComponent> getValuedItem() {
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ValuedItemComponent>();
        }
        return this.valuedItem;
    }

    public Contract setValuedItem(List<ValuedItemComponent> theValuedItem) {
        this.valuedItem = theValuedItem;
        return this;
    }

    public boolean hasValuedItem() {
        if (this.valuedItem == null) {
            return false;
        }
        for (ValuedItemComponent item : this.valuedItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ValuedItemComponent addValuedItem() {
        ValuedItemComponent t = new ValuedItemComponent();
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ValuedItemComponent>();
        }
        this.valuedItem.add(t);
        return t;
    }

    public Contract addValuedItem(ValuedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ValuedItemComponent>();
        }
        this.valuedItem.add(t);
        return this;
    }

    public ValuedItemComponent getValuedItemFirstRep() {
        if (this.getValuedItem().isEmpty()) {
            this.addValuedItem();
        }
        return this.getValuedItem().get(0);
    }

    public List<TermComponent> getTerm() {
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        return this.term;
    }

    public Contract setTerm(List<TermComponent> theTerm) {
        this.term = theTerm;
        return this;
    }

    public boolean hasTerm() {
        if (this.term == null) {
            return false;
        }
        for (TermComponent item : this.term) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TermComponent addTerm() {
        TermComponent t = new TermComponent();
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        this.term.add(t);
        return t;
    }

    public Contract addTerm(TermComponent t) {
        if (t == null) {
            return this;
        }
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        this.term.add(t);
        return this;
    }

    public TermComponent getTermFirstRep() {
        if (this.getTerm().isEmpty()) {
            this.addTerm();
        }
        return this.getTerm().get(0);
    }

    public Type getBinding() {
        return this.binding;
    }

    public Attachment getBindingAttachment() throws FHIRException {
        if (this.binding == null) {
            return null;
        }
        if (!(this.binding instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.binding.getClass().getName() + " was encountered");
        }
        return (Attachment)this.binding;
    }

    public boolean hasBindingAttachment() {
        return this != null && this.binding instanceof Attachment;
    }

    public Reference getBindingReference() throws FHIRException {
        if (this.binding == null) {
            return null;
        }
        if (!(this.binding instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.binding.getClass().getName() + " was encountered");
        }
        return (Reference)this.binding;
    }

    public boolean hasBindingReference() {
        return this != null && this.binding instanceof Reference;
    }

    public boolean hasBinding() {
        return this.binding != null && !this.binding.isEmpty();
    }

    public Contract setBinding(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for Contract.binding[x]: " + value.fhirType());
        }
        this.binding = value;
        return this;
    }

    public List<FriendlyLanguageComponent> getFriendly() {
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        return this.friendly;
    }

    public Contract setFriendly(List<FriendlyLanguageComponent> theFriendly) {
        this.friendly = theFriendly;
        return this;
    }

    public boolean hasFriendly() {
        if (this.friendly == null) {
            return false;
        }
        for (FriendlyLanguageComponent item : this.friendly) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FriendlyLanguageComponent addFriendly() {
        FriendlyLanguageComponent t = new FriendlyLanguageComponent();
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        this.friendly.add(t);
        return t;
    }

    public Contract addFriendly(FriendlyLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        this.friendly.add(t);
        return this;
    }

    public FriendlyLanguageComponent getFriendlyFirstRep() {
        if (this.getFriendly().isEmpty()) {
            this.addFriendly();
        }
        return this.getFriendly().get(0);
    }

    public List<LegalLanguageComponent> getLegal() {
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        return this.legal;
    }

    public Contract setLegal(List<LegalLanguageComponent> theLegal) {
        this.legal = theLegal;
        return this;
    }

    public boolean hasLegal() {
        if (this.legal == null) {
            return false;
        }
        for (LegalLanguageComponent item : this.legal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LegalLanguageComponent addLegal() {
        LegalLanguageComponent t = new LegalLanguageComponent();
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        this.legal.add(t);
        return t;
    }

    public Contract addLegal(LegalLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        this.legal.add(t);
        return this;
    }

    public LegalLanguageComponent getLegalFirstRep() {
        if (this.getLegal().isEmpty()) {
            this.addLegal();
        }
        return this.getLegal().get(0);
    }

    public List<ComputableLanguageComponent> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        return this.rule;
    }

    public Contract setRule(List<ComputableLanguageComponent> theRule) {
        this.rule = theRule;
        return this;
    }

    public boolean hasRule() {
        if (this.rule == null) {
            return false;
        }
        for (ComputableLanguageComponent item : this.rule) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ComputableLanguageComponent addRule() {
        ComputableLanguageComponent t = new ComputableLanguageComponent();
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        this.rule.add(t);
        return t;
    }

    public Contract addRule(ComputableLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        this.rule.add(t);
        return this;
    }

    public ComputableLanguageComponent getRuleFirstRep() {
        if (this.getRule().isEmpty()) {
            this.addRule();
        }
        return this.getRule().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this Contract.", 0, 1, this.identifier));
        children.add(new Property("status", "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_ISSUED, "dateTime", "When this  Contract was issued.", 0, 1, this.issued));
        children.add(new Property("applies", "Period", "Relevant time or time-period when this Contract is applicable.", 0, 1, this.applies));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "The target entity impacted by or of interest to parties to the agreement.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("topic", "Reference(Any)", "The matter of concern in the context of this agreement.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property(SP_AUTHORITY, "Reference(Organization)", "A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.", 0, Integer.MAX_VALUE, this.authority));
        children.add(new Property(SP_DOMAIN, "Reference(Location)", "Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.", 0, Integer.MAX_VALUE, this.domain));
        children.add(new Property("type", "CodeableConcept", "Type of Contract such as an insurance policy, real estate contract, a will, power of attorny, Privacy or Security policy , trust framework agreement, etc.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "More specific type or specialization of an overarching or more general contract such as auto insurance, home owner  insurance, prenupial agreement, Advanced-Directive, or privacy consent.", 0, Integer.MAX_VALUE, this.subType));
        children.add(new Property("action", "CodeableConcept", "Action stipulated by this Contract.", 0, Integer.MAX_VALUE, this.action));
        children.add(new Property("actionReason", "CodeableConcept", "Reason for action stipulated by this Contract.", 0, Integer.MAX_VALUE, this.actionReason));
        children.add(new Property("decisionType", "CodeableConcept", "The type of decision made by a grantor with respect to an offer made by a grantee.", 0, 1, this.decisionType));
        children.add(new Property("contentDerivative", "CodeableConcept", "The minimal content derived from the basal information source at a specific stage in its lifecycle.", 0, 1, this.contentDerivative));
        children.add(new Property("securityLabel", "Coding", "A set of security labels that define which resources are controlled by this consent. If more than one label is specified, all resources must have all the specified labels.", 0, Integer.MAX_VALUE, this.securityLabel));
        children.add(new Property(SP_AGENT, "", "An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent));
        children.add(new Property(SP_SIGNER, "", "Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.", 0, Integer.MAX_VALUE, this.signer));
        children.add(new Property("valuedItem", "", "Contract Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem));
        children.add(new Property("term", "", "One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.", 0, Integer.MAX_VALUE, this.term));
        children.add(new Property("binding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.binding));
        children.add(new Property("friendly", "", "The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.", 0, Integer.MAX_VALUE, this.friendly));
        children.add(new Property("legal", "", "List of Legal expressions or representations of this Contract.", 0, Integer.MAX_VALUE, this.legal));
        children.add(new Property("rule", "", "List of Computable Policy Rule Language Representations of this Contract.", 0, Integer.MAX_VALUE, this.rule));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this Contract.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "dateTime", "When this  Contract was issued.", 0, 1, this.issued);
            }
            case -793235316: {
                return new Property("applies", "Period", "Relevant time or time-period when this Contract is applicable.", 0, 1, this.applies);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "The target entity impacted by or of interest to parties to the agreement.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 110546223: {
                return new Property("topic", "Reference(Any)", "The matter of concern in the context of this agreement.", 0, Integer.MAX_VALUE, this.topic);
            }
            case 1475610435: {
                return new Property(SP_AUTHORITY, "Reference(Organization)", "A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.", 0, Integer.MAX_VALUE, this.authority);
            }
            case -1326197564: {
                return new Property(SP_DOMAIN, "Reference(Location)", "Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.", 0, Integer.MAX_VALUE, this.domain);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Type of Contract such as an insurance policy, real estate contract, a will, power of attorny, Privacy or Security policy , trust framework agreement, etc.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "More specific type or specialization of an overarching or more general contract such as auto insurance, home owner  insurance, prenupial agreement, Advanced-Directive, or privacy consent.", 0, Integer.MAX_VALUE, this.subType);
            }
            case -1422950858: {
                return new Property("action", "CodeableConcept", "Action stipulated by this Contract.", 0, Integer.MAX_VALUE, this.action);
            }
            case 1465121818: {
                return new Property("actionReason", "CodeableConcept", "Reason for action stipulated by this Contract.", 0, Integer.MAX_VALUE, this.actionReason);
            }
            case 676128054: {
                return new Property("decisionType", "CodeableConcept", "The type of decision made by a grantor with respect to an offer made by a grantee.", 0, 1, this.decisionType);
            }
            case -92412192: {
                return new Property("contentDerivative", "CodeableConcept", "The minimal content derived from the basal information source at a specific stage in its lifecycle.", 0, 1, this.contentDerivative);
            }
            case -722296940: {
                return new Property("securityLabel", "Coding", "A set of security labels that define which resources are controlled by this consent. If more than one label is specified, all resources must have all the specified labels.", 0, Integer.MAX_VALUE, this.securityLabel);
            }
            case 92750597: {
                return new Property(SP_AGENT, "", "An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent);
            }
            case -902467798: {
                return new Property(SP_SIGNER, "", "Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.", 0, Integer.MAX_VALUE, this.signer);
            }
            case 2046675654: {
                return new Property("valuedItem", "", "Contract Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem);
            }
            case 3556460: {
                return new Property("term", "", "One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.", 0, Integer.MAX_VALUE, this.term);
            }
            case 1514826715: {
                return new Property("binding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.binding);
            }
            case -108220795: {
                return new Property("binding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.binding);
            }
            case 1218789768: {
                return new Property("binding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.binding);
            }
            case 424425030: {
                return new Property("binding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, 1, this.binding);
            }
            case -1423054677: {
                return new Property("friendly", "", "The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.", 0, Integer.MAX_VALUE, this.friendly);
            }
            case 102851257: {
                return new Property("legal", "", "List of Legal expressions or representations of this Contract.", 0, Integer.MAX_VALUE, this.legal);
            }
            case 3512060: {
                return new Property("rule", "", "List of Computable Policy Rule Language Representations of this Contract.", 0, Integer.MAX_VALUE, this.rule);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.issued;
                }
                return baseArray;
            }
            case -793235316: {
                Base[] baseArray;
                if (this.applies == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.applies;
                }
                return baseArray;
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case 1475610435: {
                return this.authority == null ? new Base[]{} : this.authority.toArray(new Base[this.authority.size()]);
            }
            case -1326197564: {
                return this.domain == null ? new Base[]{} : this.domain.toArray(new Base[this.domain.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                return this.subType == null ? new Base[]{} : this.subType.toArray(new Base[this.subType.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
            case 1465121818: {
                return this.actionReason == null ? new Base[]{} : this.actionReason.toArray(new Base[this.actionReason.size()]);
            }
            case 676128054: {
                Base[] baseArray;
                if (this.decisionType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.decisionType;
                }
                return baseArray;
            }
            case -92412192: {
                Base[] baseArray;
                if (this.contentDerivative == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.contentDerivative;
                }
                return baseArray;
            }
            case -722296940: {
                return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case -902467798: {
                return this.signer == null ? new Base[]{} : this.signer.toArray(new Base[this.signer.size()]);
            }
            case 2046675654: {
                return this.valuedItem == null ? new Base[]{} : this.valuedItem.toArray(new Base[this.valuedItem.size()]);
            }
            case 3556460: {
                return this.term == null ? new Base[]{} : this.term.toArray(new Base[this.term.size()]);
            }
            case -108220795: {
                Base[] baseArray;
                if (this.binding == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.binding;
                }
                return baseArray;
            }
            case -1423054677: {
                return this.friendly == null ? new Base[]{} : this.friendly.toArray(new Base[this.friendly.size()]);
            }
            case 102851257: {
                return this.legal == null ? new Base[]{} : this.legal.toArray(new Base[this.legal.size()]);
            }
            case 3512060: {
                return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new ContractStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1179159893: {
                this.issued = this.castToDateTime(value);
                return value;
            }
            case -793235316: {
                this.applies = this.castToPeriod(value);
                return value;
            }
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToReference(value));
                return value;
            }
            case 1475610435: {
                this.getAuthority().add(this.castToReference(value));
                return value;
            }
            case -1326197564: {
                this.getDomain().add(this.castToReference(value));
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.getSubType().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1422950858: {
                this.getAction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1465121818: {
                this.getActionReason().add(this.castToCodeableConcept(value));
                return value;
            }
            case 676128054: {
                this.decisionType = this.castToCodeableConcept(value);
                return value;
            }
            case -92412192: {
                this.contentDerivative = this.castToCodeableConcept(value);
                return value;
            }
            case -722296940: {
                this.getSecurityLabel().add(this.castToCoding(value));
                return value;
            }
            case 92750597: {
                this.getAgent().add((AgentComponent)((Object)value));
                return value;
            }
            case -902467798: {
                this.getSigner().add((SignatoryComponent)((Object)value));
                return value;
            }
            case 2046675654: {
                this.getValuedItem().add((ValuedItemComponent)((Object)value));
                return value;
            }
            case 3556460: {
                this.getTerm().add((TermComponent)((Object)value));
                return value;
            }
            case -108220795: {
                this.binding = this.castToType(value);
                return value;
            }
            case -1423054677: {
                this.getFriendly().add((FriendlyLanguageComponent)((Object)value));
                return value;
            }
            case 102851257: {
                this.getLegal().add((LegalLanguageComponent)((Object)value));
                return value;
            }
            case 3512060: {
                this.getRule().add((ComputableLanguageComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("status")) {
            value = new ContractStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_ISSUED)) {
            this.issued = this.castToDateTime(value);
        } else if (name.equals("applies")) {
            this.applies = this.castToPeriod(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("topic")) {
            this.getTopic().add(this.castToReference(value));
        } else if (name.equals(SP_AUTHORITY)) {
            this.getAuthority().add(this.castToReference(value));
        } else if (name.equals(SP_DOMAIN)) {
            this.getDomain().add(this.castToReference(value));
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.getSubType().add(this.castToCodeableConcept(value));
        } else if (name.equals("action")) {
            this.getAction().add(this.castToCodeableConcept(value));
        } else if (name.equals("actionReason")) {
            this.getActionReason().add(this.castToCodeableConcept(value));
        } else if (name.equals("decisionType")) {
            this.decisionType = this.castToCodeableConcept(value);
        } else if (name.equals("contentDerivative")) {
            this.contentDerivative = this.castToCodeableConcept(value);
        } else if (name.equals("securityLabel")) {
            this.getSecurityLabel().add(this.castToCoding(value));
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((AgentComponent)((Object)value));
        } else if (name.equals(SP_SIGNER)) {
            this.getSigner().add((SignatoryComponent)((Object)value));
        } else if (name.equals("valuedItem")) {
            this.getValuedItem().add((ValuedItemComponent)((Object)value));
        } else if (name.equals("term")) {
            this.getTerm().add((TermComponent)((Object)value));
        } else if (name.equals("binding[x]")) {
            this.binding = this.castToType(value);
        } else if (name.equals("friendly")) {
            this.getFriendly().add((FriendlyLanguageComponent)((Object)value));
        } else if (name.equals("legal")) {
            this.getLegal().add((LegalLanguageComponent)((Object)value));
        } else if (name.equals("rule")) {
            this.getRule().add((ComputableLanguageComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case -793235316: {
                return this.getApplies();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 110546223: {
                return this.addTopic();
            }
            case 1475610435: {
                return this.addAuthority();
            }
            case -1326197564: {
                return this.addDomain();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.addSubType();
            }
            case -1422950858: {
                return this.addAction();
            }
            case 1465121818: {
                return this.addActionReason();
            }
            case 676128054: {
                return this.getDecisionType();
            }
            case -92412192: {
                return this.getContentDerivative();
            }
            case -722296940: {
                return this.addSecurityLabel();
            }
            case 92750597: {
                return this.addAgent();
            }
            case -902467798: {
                return this.addSigner();
            }
            case 2046675654: {
                return this.addValuedItem();
            }
            case 3556460: {
                return this.addTerm();
            }
            case 1514826715: {
                return this.getBinding();
            }
            case -108220795: {
                return this.getBinding();
            }
            case -1423054677: {
                return this.addFriendly();
            }
            case 102851257: {
                return this.addLegal();
            }
            case 3512060: {
                return this.addRule();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1179159893: {
                return new String[]{"dateTime"};
            }
            case -793235316: {
                return new String[]{"Period"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 110546223: {
                return new String[]{"Reference"};
            }
            case 1475610435: {
                return new String[]{"Reference"};
            }
            case -1326197564: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case -1422950858: {
                return new String[]{"CodeableConcept"};
            }
            case 1465121818: {
                return new String[]{"CodeableConcept"};
            }
            case 676128054: {
                return new String[]{"CodeableConcept"};
            }
            case -92412192: {
                return new String[]{"CodeableConcept"};
            }
            case -722296940: {
                return new String[]{"Coding"};
            }
            case 92750597: {
                return new String[0];
            }
            case -902467798: {
                return new String[0];
            }
            case 2046675654: {
                return new String[0];
            }
            case 3556460: {
                return new String[0];
            }
            case -108220795: {
                return new String[]{"Attachment", "Reference"};
            }
            case -1423054677: {
                return new String[0];
            }
            case 102851257: {
                return new String[0];
            }
            case 3512060: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.status");
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Contract.issued");
        }
        if (name.equals("applies")) {
            this.applies = new Period();
            return this.applies;
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("topic")) {
            return this.addTopic();
        }
        if (name.equals(SP_AUTHORITY)) {
            return this.addAuthority();
        }
        if (name.equals(SP_DOMAIN)) {
            return this.addDomain();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            return this.addSubType();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        if (name.equals("actionReason")) {
            return this.addActionReason();
        }
        if (name.equals("decisionType")) {
            this.decisionType = new CodeableConcept();
            return this.decisionType;
        }
        if (name.equals("contentDerivative")) {
            this.contentDerivative = new CodeableConcept();
            return this.contentDerivative;
        }
        if (name.equals("securityLabel")) {
            return this.addSecurityLabel();
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_SIGNER)) {
            return this.addSigner();
        }
        if (name.equals("valuedItem")) {
            return this.addValuedItem();
        }
        if (name.equals("term")) {
            return this.addTerm();
        }
        if (name.equals("bindingAttachment")) {
            this.binding = new Attachment();
            return this.binding;
        }
        if (name.equals("bindingReference")) {
            this.binding = new Reference();
            return this.binding;
        }
        if (name.equals("friendly")) {
            return this.addFriendly();
        }
        if (name.equals("legal")) {
            return this.addLegal();
        }
        if (name.equals("rule")) {
            return this.addRule();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Contract";
    }

    @Override
    public Contract copy() {
        Contract dst = new Contract();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.issued = this.issued == null ? null : this.issued.copy();
        Period period = dst.applies = this.applies == null ? null : this.applies.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        if (this.topic != null) {
            dst.topic = new ArrayList<Reference>();
            for (Reference reference : this.topic) {
                dst.topic.add(reference.copy());
            }
        }
        if (this.authority != null) {
            dst.authority = new ArrayList<Reference>();
            for (Reference reference : this.authority) {
                dst.authority.add(reference.copy());
            }
        }
        if (this.domain != null) {
            dst.domain = new ArrayList<Reference>();
            for (Reference reference : this.domain) {
                dst.domain.add(reference.copy());
            }
        }
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.subType != null) {
            dst.subType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.subType) {
                dst.subType.add(codeableConcept2.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.action) {
                dst.action.add(codeableConcept3.copy());
            }
        }
        if (this.actionReason != null) {
            dst.actionReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.actionReason) {
                dst.actionReason.add(codeableConcept4.copy());
            }
        }
        dst.decisionType = this.decisionType == null ? null : this.decisionType.copy();
        CodeableConcept codeableConcept5 = dst.contentDerivative = this.contentDerivative == null ? null : this.contentDerivative.copy();
        if (this.securityLabel != null) {
            dst.securityLabel = new ArrayList<Coding>();
            for (Coding coding : this.securityLabel) {
                dst.securityLabel.add(coding.copy());
            }
        }
        if (this.agent != null) {
            dst.agent = new ArrayList<AgentComponent>();
            for (AgentComponent agentComponent : this.agent) {
                dst.agent.add(agentComponent.copy());
            }
        }
        if (this.signer != null) {
            dst.signer = new ArrayList<SignatoryComponent>();
            for (SignatoryComponent signatoryComponent : this.signer) {
                dst.signer.add(signatoryComponent.copy());
            }
        }
        if (this.valuedItem != null) {
            dst.valuedItem = new ArrayList<ValuedItemComponent>();
            for (ValuedItemComponent valuedItemComponent : this.valuedItem) {
                dst.valuedItem.add(valuedItemComponent.copy());
            }
        }
        if (this.term != null) {
            dst.term = new ArrayList<TermComponent>();
            for (TermComponent termComponent : this.term) {
                dst.term.add(termComponent.copy());
            }
        }
        Type type = dst.binding = this.binding == null ? null : this.binding.copy();
        if (this.friendly != null) {
            dst.friendly = new ArrayList<FriendlyLanguageComponent>();
            for (FriendlyLanguageComponent friendlyLanguageComponent : this.friendly) {
                dst.friendly.add(friendlyLanguageComponent.copy());
            }
        }
        if (this.legal != null) {
            dst.legal = new ArrayList<LegalLanguageComponent>();
            for (LegalLanguageComponent legalLanguageComponent : this.legal) {
                dst.legal.add(legalLanguageComponent.copy());
            }
        }
        if (this.rule != null) {
            dst.rule = new ArrayList<ComputableLanguageComponent>();
            for (ComputableLanguageComponent computableLanguageComponent : this.rule) {
                dst.rule.add(computableLanguageComponent.copy());
            }
        }
        return dst;
    }

    protected Contract typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Contract)) {
            return false;
        }
        Contract o = (Contract)other_;
        return Contract.compareDeep(this.identifier, o.identifier, true) && Contract.compareDeep(this.status, o.status, true) && Contract.compareDeep(this.issued, o.issued, true) && Contract.compareDeep(this.applies, o.applies, true) && Contract.compareDeep(this.subject, o.subject, true) && Contract.compareDeep(this.topic, o.topic, true) && Contract.compareDeep(this.authority, o.authority, true) && Contract.compareDeep(this.domain, o.domain, true) && Contract.compareDeep(this.type, o.type, true) && Contract.compareDeep(this.subType, o.subType, true) && Contract.compareDeep(this.action, o.action, true) && Contract.compareDeep(this.actionReason, o.actionReason, true) && Contract.compareDeep(this.decisionType, o.decisionType, true) && Contract.compareDeep(this.contentDerivative, o.contentDerivative, true) && Contract.compareDeep(this.securityLabel, o.securityLabel, true) && Contract.compareDeep(this.agent, o.agent, true) && Contract.compareDeep(this.signer, o.signer, true) && Contract.compareDeep(this.valuedItem, o.valuedItem, true) && Contract.compareDeep(this.term, o.term, true) && Contract.compareDeep(this.binding, o.binding, true) && Contract.compareDeep(this.friendly, o.friendly, true) && Contract.compareDeep(this.legal, o.legal, true) && Contract.compareDeep(this.rule, o.rule, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Contract)) {
            return false;
        }
        Contract o = (Contract)other_;
        return Contract.compareValues(this.status, o.status, true) && Contract.compareValues(this.issued, o.issued, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.issued, this.applies, this.subject, this.topic, this.authority, this.domain, this.type, this.subType, this.action, this.actionReason, this.decisionType, this.contentDerivative, this.securityLabel, this.agent, this.signer, this.valuedItem, this.term, this.binding, this.friendly, this.legal, this.rule});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Contract;
    }

    @Block
    public static class ComputableLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, DocumentReference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Computable Contract Rules", formalDefinition="Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public ComputableLanguageComponent() {
        }

        public ComputableLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public ComputableLanguageComponent setContent(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Contract.rule.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public ComputableLanguageComponent copy() {
            ComputableLanguageComponent dst = new ComputableLanguageComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ComputableLanguageComponent)) {
                return false;
            }
            ComputableLanguageComponent o = (ComputableLanguageComponent)other_;
            return ComputableLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ComputableLanguageComponent)) {
                return false;
            }
            ComputableLanguageComponent o = (ComputableLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.content});
        }

        @Override
        public String fhirType() {
            return "Contract.rule";
        }
    }

    @Block
    public static class LegalLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Legal Text", formalDefinition="Contract legal text in human renderable form.")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public LegalLanguageComponent() {
        }

        public LegalLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public LegalLanguageComponent setContent(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Contract.legal.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public LegalLanguageComponent copy() {
            LegalLanguageComponent dst = new LegalLanguageComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof LegalLanguageComponent)) {
                return false;
            }
            LegalLanguageComponent o = (LegalLanguageComponent)other_;
            return LegalLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof LegalLanguageComponent)) {
                return false;
            }
            LegalLanguageComponent o = (LegalLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.content});
        }

        @Override
        public String fhirType() {
            return "Contract.legal";
        }
    }

    @Block
    public static class FriendlyLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Easily comprehended representation of this Contract", formalDefinition="Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public FriendlyLanguageComponent() {
        }

        public FriendlyLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public FriendlyLanguageComponent setContent(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Attachment) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Contract.friendly.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public FriendlyLanguageComponent copy() {
            FriendlyLanguageComponent dst = new FriendlyLanguageComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof FriendlyLanguageComponent)) {
                return false;
            }
            FriendlyLanguageComponent o = (FriendlyLanguageComponent)other_;
            return FriendlyLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof FriendlyLanguageComponent)) {
                return false;
            }
            FriendlyLanguageComponent o = (FriendlyLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.content});
        }

        @Override
        public String fhirType() {
            return "Contract.friendly";
        }
    }

    @Block
    public static class TermValuedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={CodeableConcept.class, Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Type", formalDefinition="Specific type of Contract Provision Valued Item that may be priced.")
        protected Type entity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Number", formalDefinition="Identifies a Contract Provision Valued Item instance.")
        protected Identifier identifier;
        @Child(name="effectiveTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Effective Tiem", formalDefinition="Indicates the time during which this Contract Term ValuedItem information is effective.")
        protected DateTimeType effectiveTime;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Count", formalDefinition="Specifies the units by which the Contract Provision Valued Item is measured or counted, and quantifies the countable or measurable Contract Term Valued Item instances.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item fee, charge, or cost", formalDefinition="A Contract Provision Valued Item unit valuation measure.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Price Scaling Factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Provision Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Difficulty Scaling Factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Provision Valued Item delivered. The concept of Points allows for assignment of point values for a Contract ProvisionValued Item, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total Contract Term Valued Item Value", formalDefinition="Expresses the product of the Contract Provision Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        private static final long serialVersionUID = 1782449516L;

        public Type getEntity() {
            return this.entity;
        }

        public CodeableConcept getEntityCodeableConcept() throws FHIRException {
            if (this.entity == null) {
                return null;
            }
            if (!(this.entity instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.entity;
        }

        public boolean hasEntityCodeableConcept() {
            return this != null && this.entity instanceof CodeableConcept;
        }

        public Reference getEntityReference() throws FHIRException {
            if (this.entity == null) {
                return null;
            }
            if (!(this.entity instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (Reference)this.entity;
        }

        public boolean hasEntityReference() {
            return this != null && this.entity instanceof Reference;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public TermValuedItemComponent setEntity(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Contract.term.valuedItem.entity[x]: " + value.fhirType());
            }
            this.entity = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public TermValuedItemComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getEffectiveTimeElement() {
            if (this.effectiveTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.effectiveTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveTime = new DateTimeType();
                }
            }
            return this.effectiveTime;
        }

        public boolean hasEffectiveTimeElement() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public boolean hasEffectiveTime() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public TermValuedItemComponent setEffectiveTimeElement(DateTimeType value) {
            this.effectiveTime = value;
            return this;
        }

        public Date getEffectiveTime() {
            return this.effectiveTime == null ? null : (Date)this.effectiveTime.getValue();
        }

        public TermValuedItemComponent setEffectiveTime(Date value) {
            if (value == null) {
                this.effectiveTime = null;
            } else {
                if (this.effectiveTime == null) {
                    this.effectiveTime = new DateTimeType();
                }
                this.effectiveTime.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public TermValuedItemComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public TermValuedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public TermValuedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public TermValuedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public TermValuedItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public TermValuedItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public TermValuedItemComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public TermValuedItemComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public TermValuedItemComponent setPoints(long value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public TermValuedItemComponent setPoints(double value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public TermValuedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Provision Valued Item that may be priced.", 0, 1, this.entity));
            children.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Provision Valued Item instance.", 0, 1, this.identifier));
            children.add(new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract Term ValuedItem information is effective.", 0, 1, this.effectiveTime));
            children.add(new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Provision Valued Item is measured or counted, and quantifies the countable or measurable Contract Term Valued Item instances.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "A Contract Provision Valued Item unit valuation measure.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Provision Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Provision Valued Item delivered. The concept of Points allows for assignment of point values for a Contract ProvisionValued Item, such that a monetary amount can be assigned to each point.", 0, 1, this.points));
            children.add(new Property("net", "Money", "Expresses the product of the Contract Provision Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -740568643: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Provision Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -1298275357: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Provision Valued Item that may be priced.", 0, 1, this.entity);
                }
                case 924197182: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Provision Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -356635992: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Provision Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -1618432855: {
                    return new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Provision Valued Item instance.", 0, 1, this.identifier);
                }
                case -929905388: {
                    return new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract Term ValuedItem information is effective.", 0, 1, this.effectiveTime);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Provision Valued Item is measured or counted, and quantifies the countable or measurable Contract Term Valued Item instances.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "A Contract Provision Valued Item unit valuation measure.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Provision Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case -982754077: {
                    return new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Provision Valued Item delivered. The concept of Points allows for assignment of point values for a Contract ProvisionValued Item, such that a monetary amount can be assigned to each point.", 0, 1, this.points);
                }
                case 108957: {
                    return new Property("net", "Money", "Expresses the product of the Contract Provision Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    Base[] baseArray;
                    if (this.entity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.entity;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -929905388: {
                    Base[] baseArray;
                    if (this.effectiveTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.effectiveTime;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case -982754077: {
                    Base[] baseArray;
                    if (this.points == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.points;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    this.entity = this.castToType(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -929905388: {
                    this.effectiveTime = this.castToDateTime(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case -982754077: {
                    this.points = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity[x]")) {
                this.entity = this.castToType(value);
            } else if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("effectiveTime")) {
                this.effectiveTime = this.castToDateTime(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -740568643: {
                    return this.getEntity();
                }
                case -1298275357: {
                    return this.getEntity();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -929905388: {
                    return this.getEffectiveTimeElement();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case -982754077: {
                    return this.getPointsElement();
                }
                case 108957: {
                    return this.getNet();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -929905388: {
                    return new String[]{"dateTime"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case -982754077: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entityCodeableConcept")) {
                this.entity = new CodeableConcept();
                return this.entity;
            }
            if (name.equals("entityReference")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("effectiveTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.effectiveTime");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            return super.addChild(name);
        }

        @Override
        public TermValuedItemComponent copy() {
            TermValuedItemComponent dst = new TermValuedItemComponent();
            this.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.effectiveTime = this.effectiveTime == null ? null : this.effectiveTime.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TermValuedItemComponent)) {
                return false;
            }
            TermValuedItemComponent o = (TermValuedItemComponent)other_;
            return TermValuedItemComponent.compareDeep(this.entity, o.entity, true) && TermValuedItemComponent.compareDeep(this.identifier, o.identifier, true) && TermValuedItemComponent.compareDeep(this.effectiveTime, o.effectiveTime, true) && TermValuedItemComponent.compareDeep(this.quantity, o.quantity, true) && TermValuedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && TermValuedItemComponent.compareDeep(this.factor, o.factor, true) && TermValuedItemComponent.compareDeep(this.points, o.points, true) && TermValuedItemComponent.compareDeep(this.net, o.net, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TermValuedItemComponent)) {
                return false;
            }
            TermValuedItemComponent o = (TermValuedItemComponent)other_;
            return TermValuedItemComponent.compareValues(this.effectiveTime, o.effectiveTime, true) && TermValuedItemComponent.compareValues(this.factor, o.factor, true) && TermValuedItemComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.entity, this.identifier, this.effectiveTime, this.quantity, this.unitPrice, this.factor, this.points, this.net});
        }

        @Override
        public String fhirType() {
            return "Contract.term.valuedItem";
        }
    }

    @Block
    public static class TermAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actor", type={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Agent Subject", formalDefinition="The agent assigned a role in this Contract Provision.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Type of the Contract Term Agent", formalDefinition="Role played by the agent assigned this role in the execution of this Contract Provision.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-actorrole")
        protected List<CodeableConcept> role;
        private static final long serialVersionUID = -454551165L;

        public TermAgentComponent() {
        }

        public TermAgentComponent(Reference actor) {
            this.actor = actor;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermAgentComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public TermAgentComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public TermAgentComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public TermAgentComponent setRole(List<CodeableConcept> theRole) {
            this.role = theRole;
            return this;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public TermAgentComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public CodeableConcept getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                this.addRole();
            }
            return this.getRole().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actor", "Reference(Contract|Device|Group|Location|Organization|Patient|Practitioner|RelatedPerson|Substance)", "The agent assigned a role in this Contract Provision.", 0, 1, this.actor));
            children.add(new Property("role", "CodeableConcept", "Role played by the agent assigned this role in the execution of this Contract Provision.", 0, Integer.MAX_VALUE, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92645877: {
                    return new Property("actor", "Reference(Contract|Device|Group|Location|Organization|Patient|Practitioner|RelatedPerson|Substance)", "The agent assigned a role in this Contract Provision.", 0, 1, this.actor);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role played by the agent assigned this role in the execution of this Contract Provision.", 0, Integer.MAX_VALUE, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actor;
                    }
                    return baseArray;
                }
                case 3506294: {
                    return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.getRole().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.getActor();
                }
                case 3506294: {
                    return this.addRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            return super.addChild(name);
        }

        @Override
        public TermAgentComponent copy() {
            TermAgentComponent dst = new TermAgentComponent();
            this.copyValues(dst);
            Reference reference = dst.actor = this.actor == null ? null : this.actor.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.role) {
                    dst.role.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TermAgentComponent)) {
                return false;
            }
            TermAgentComponent o = (TermAgentComponent)other_;
            return TermAgentComponent.compareDeep(this.actor, o.actor, true) && TermAgentComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TermAgentComponent)) {
                return false;
            }
            TermAgentComponent o = (TermAgentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.actor, this.role});
        }

        @Override
        public String fhirType() {
            return "Contract.term.agent";
        }
    }

    @Block
    public static class TermComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Number", formalDefinition="Unique identifier for this particular Contract Provision.")
        protected Identifier identifier;
        @Child(name="issued", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Issue Date Time", formalDefinition="When this Contract Provision was issued.")
        protected DateTimeType issued;
        @Child(name="applies", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Effective Time", formalDefinition="Relevant time or time-period when this Contract Provision is applicable.")
        protected Period applies;
        @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Type or Form", formalDefinition="Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-term-type")
        protected CodeableConcept type;
        @Child(name="subType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Type specific classification", formalDefinition="Subtype of this Contract Provision, e.g. life time maximum payment for a contract term for specific valued item, e.g. disability payment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-term-subtype")
        protected CodeableConcept subType;
        @Child(name="topic", type={Reference.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Context of the Contract term", formalDefinition="The matter of concern in the context of this provision of the agrement.")
        protected List<Reference> topic;
        protected List<Resource> topicTarget;
        @Child(name="action", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Activity", formalDefinition="Action stipulated by this Contract Provision.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-action")
        protected List<CodeableConcept> action;
        @Child(name="actionReason", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Purpose for the Contract Term Action", formalDefinition="Reason or purpose for the action stipulated by this Contract Provision.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-PurposeOfUse")
        protected List<CodeableConcept> actionReason;
        @Child(name="securityLabel", type={Coding.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Security Labels that define affected terms", formalDefinition="A set of security labels that define which terms are controlled by this condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        protected List<Coding> securityLabel;
        @Child(name="agent", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Agent List", formalDefinition="An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.")
        protected List<TermAgentComponent> agent;
        @Child(name="text", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable Contract term text", formalDefinition="Human readable form of this Contract Provision.")
        protected StringType text;
        @Child(name="valuedItem", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item List", formalDefinition="Contract Provision Valued Item List.")
        protected List<TermValuedItemComponent> valuedItem;
        @Child(name="group", type={TermComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Contract Term Group", formalDefinition="Nested group of Contract Provisions.")
        protected List<TermComponent> group;
        private static final long serialVersionUID = 812661371L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public TermComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getIssuedElement() {
            if (this.issued == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.issued");
                }
                if (Configuration.doAutoCreate()) {
                    this.issued = new DateTimeType();
                }
            }
            return this.issued;
        }

        public boolean hasIssuedElement() {
            return this.issued != null && !this.issued.isEmpty();
        }

        public boolean hasIssued() {
            return this.issued != null && !this.issued.isEmpty();
        }

        public TermComponent setIssuedElement(DateTimeType value) {
            this.issued = value;
            return this;
        }

        public Date getIssued() {
            return this.issued == null ? null : (Date)this.issued.getValue();
        }

        public TermComponent setIssued(Date value) {
            if (value == null) {
                this.issued = null;
            } else {
                if (this.issued == null) {
                    this.issued = new DateTimeType();
                }
                this.issued.setValue(value);
            }
            return this;
        }

        public Period getApplies() {
            if (this.applies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.applies");
                }
                if (Configuration.doAutoCreate()) {
                    this.applies = new Period();
                }
            }
            return this.applies;
        }

        public boolean hasApplies() {
            return this.applies != null && !this.applies.isEmpty();
        }

        public TermComponent setApplies(Period value) {
            this.applies = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TermComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getSubType() {
            if (this.subType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.subType");
                }
                if (Configuration.doAutoCreate()) {
                    this.subType = new CodeableConcept();
                }
            }
            return this.subType;
        }

        public boolean hasSubType() {
            return this.subType != null && !this.subType.isEmpty();
        }

        public TermComponent setSubType(CodeableConcept value) {
            this.subType = value;
            return this;
        }

        public List<Reference> getTopic() {
            if (this.topic == null) {
                this.topic = new ArrayList<Reference>();
            }
            return this.topic;
        }

        public TermComponent setTopic(List<Reference> theTopic) {
            this.topic = theTopic;
            return this;
        }

        public boolean hasTopic() {
            if (this.topic == null) {
                return false;
            }
            for (Reference item : this.topic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addTopic() {
            Reference t = new Reference();
            if (this.topic == null) {
                this.topic = new ArrayList<Reference>();
            }
            this.topic.add(t);
            return t;
        }

        public TermComponent addTopic(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.topic == null) {
                this.topic = new ArrayList<Reference>();
            }
            this.topic.add(t);
            return this;
        }

        public Reference getTopicFirstRep() {
            if (this.getTopic().isEmpty()) {
                this.addTopic();
            }
            return this.getTopic().get(0);
        }

        @Deprecated
        public List<Resource> getTopicTarget() {
            if (this.topicTarget == null) {
                this.topicTarget = new ArrayList<Resource>();
            }
            return this.topicTarget;
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public TermComponent setAction(List<CodeableConcept> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public TermComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public CodeableConcept getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<CodeableConcept> getActionReason() {
            if (this.actionReason == null) {
                this.actionReason = new ArrayList<CodeableConcept>();
            }
            return this.actionReason;
        }

        public TermComponent setActionReason(List<CodeableConcept> theActionReason) {
            this.actionReason = theActionReason;
            return this;
        }

        public boolean hasActionReason() {
            if (this.actionReason == null) {
                return false;
            }
            for (CodeableConcept item : this.actionReason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addActionReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.actionReason == null) {
                this.actionReason = new ArrayList<CodeableConcept>();
            }
            this.actionReason.add(t);
            return t;
        }

        public TermComponent addActionReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.actionReason == null) {
                this.actionReason = new ArrayList<CodeableConcept>();
            }
            this.actionReason.add(t);
            return this;
        }

        public CodeableConcept getActionReasonFirstRep() {
            if (this.getActionReason().isEmpty()) {
                this.addActionReason();
            }
            return this.getActionReason().get(0);
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public TermComponent setSecurityLabel(List<Coding> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public TermComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public Coding getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public List<TermAgentComponent> getAgent() {
            if (this.agent == null) {
                this.agent = new ArrayList<TermAgentComponent>();
            }
            return this.agent;
        }

        public TermComponent setAgent(List<TermAgentComponent> theAgent) {
            this.agent = theAgent;
            return this;
        }

        public boolean hasAgent() {
            if (this.agent == null) {
                return false;
            }
            for (TermAgentComponent item : this.agent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermAgentComponent addAgent() {
            TermAgentComponent t = new TermAgentComponent();
            if (this.agent == null) {
                this.agent = new ArrayList<TermAgentComponent>();
            }
            this.agent.add(t);
            return t;
        }

        public TermComponent addAgent(TermAgentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.agent == null) {
                this.agent = new ArrayList<TermAgentComponent>();
            }
            this.agent.add(t);
            return this;
        }

        public TermAgentComponent getAgentFirstRep() {
            if (this.getAgent().isEmpty()) {
                this.addAgent();
            }
            return this.getAgent().get(0);
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public TermComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public TermComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<TermValuedItemComponent> getValuedItem() {
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<TermValuedItemComponent>();
            }
            return this.valuedItem;
        }

        public TermComponent setValuedItem(List<TermValuedItemComponent> theValuedItem) {
            this.valuedItem = theValuedItem;
            return this;
        }

        public boolean hasValuedItem() {
            if (this.valuedItem == null) {
                return false;
            }
            for (TermValuedItemComponent item : this.valuedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermValuedItemComponent addValuedItem() {
            TermValuedItemComponent t = new TermValuedItemComponent();
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<TermValuedItemComponent>();
            }
            this.valuedItem.add(t);
            return t;
        }

        public TermComponent addValuedItem(TermValuedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<TermValuedItemComponent>();
            }
            this.valuedItem.add(t);
            return this;
        }

        public TermValuedItemComponent getValuedItemFirstRep() {
            if (this.getValuedItem().isEmpty()) {
                this.addValuedItem();
            }
            return this.getValuedItem().get(0);
        }

        public List<TermComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            return this.group;
        }

        public TermComponent setGroup(List<TermComponent> theGroup) {
            this.group = theGroup;
            return this;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (TermComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermComponent addGroup() {
            TermComponent t = new TermComponent();
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            this.group.add(t);
            return t;
        }

        public TermComponent addGroup(TermComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            this.group.add(t);
            return this;
        }

        public TermComponent getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                this.addGroup();
            }
            return this.getGroup().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, 1, this.identifier));
            children.add(new Property(Contract.SP_ISSUED, "dateTime", "When this Contract Provision was issued.", 0, 1, this.issued));
            children.add(new Property("applies", "Period", "Relevant time or time-period when this Contract Provision is applicable.", 0, 1, this.applies));
            children.add(new Property("type", "CodeableConcept", "Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.", 0, 1, this.type));
            children.add(new Property("subType", "CodeableConcept", "Subtype of this Contract Provision, e.g. life time maximum payment for a contract term for specific valued item, e.g. disability payment.", 0, 1, this.subType));
            children.add(new Property("topic", "Reference(Any)", "The matter of concern in the context of this provision of the agrement.", 0, Integer.MAX_VALUE, this.topic));
            children.add(new Property("action", "CodeableConcept", "Action stipulated by this Contract Provision.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("actionReason", "CodeableConcept", "Reason or purpose for the action stipulated by this Contract Provision.", 0, Integer.MAX_VALUE, this.actionReason));
            children.add(new Property("securityLabel", "Coding", "A set of security labels that define which terms are controlled by this condition.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property(Contract.SP_AGENT, "", "An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent));
            children.add(new Property("text", "string", "Human readable form of this Contract Provision.", 0, 1, this.text));
            children.add(new Property("valuedItem", "", "Contract Provision Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem));
            children.add(new Property("group", "@Contract.term", "Nested group of Contract Provisions.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, 1, this.identifier);
                }
                case -1179159893: {
                    return new Property(Contract.SP_ISSUED, "dateTime", "When this Contract Provision was issued.", 0, 1, this.issued);
                }
                case -793235316: {
                    return new Property("applies", "Period", "Relevant time or time-period when this Contract Provision is applicable.", 0, 1, this.applies);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.", 0, 1, this.type);
                }
                case -1868521062: {
                    return new Property("subType", "CodeableConcept", "Subtype of this Contract Provision, e.g. life time maximum payment for a contract term for specific valued item, e.g. disability payment.", 0, 1, this.subType);
                }
                case 110546223: {
                    return new Property("topic", "Reference(Any)", "The matter of concern in the context of this provision of the agrement.", 0, Integer.MAX_VALUE, this.topic);
                }
                case -1422950858: {
                    return new Property("action", "CodeableConcept", "Action stipulated by this Contract Provision.", 0, Integer.MAX_VALUE, this.action);
                }
                case 1465121818: {
                    return new Property("actionReason", "CodeableConcept", "Reason or purpose for the action stipulated by this Contract Provision.", 0, Integer.MAX_VALUE, this.actionReason);
                }
                case -722296940: {
                    return new Property("securityLabel", "Coding", "A set of security labels that define which terms are controlled by this condition.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case 92750597: {
                    return new Property(Contract.SP_AGENT, "", "An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent);
                }
                case 3556653: {
                    return new Property("text", "string", "Human readable form of this Contract Provision.", 0, 1, this.text);
                }
                case 2046675654: {
                    return new Property("valuedItem", "", "Contract Provision Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem);
                }
                case 98629247: {
                    return new Property("group", "@Contract.term", "Nested group of Contract Provisions.", 0, Integer.MAX_VALUE, this.group);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -1179159893: {
                    Base[] baseArray;
                    if (this.issued == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.issued;
                    }
                    return baseArray;
                }
                case -793235316: {
                    Base[] baseArray;
                    if (this.applies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.applies;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
                case -1868521062: {
                    Base[] baseArray;
                    if (this.subType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.subType;
                    }
                    return baseArray;
                }
                case 110546223: {
                    return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case 1465121818: {
                    return this.actionReason == null ? new Base[]{} : this.actionReason.toArray(new Base[this.actionReason.size()]);
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case 92750597: {
                    return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.text;
                    }
                    return baseArray;
                }
                case 2046675654: {
                    return this.valuedItem == null ? new Base[]{} : this.valuedItem.toArray(new Base[this.valuedItem.size()]);
                }
                case 98629247: {
                    return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -1179159893: {
                    this.issued = this.castToDateTime(value);
                    return value;
                }
                case -793235316: {
                    this.applies = this.castToPeriod(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868521062: {
                    this.subType = this.castToCodeableConcept(value);
                    return value;
                }
                case 110546223: {
                    this.getTopic().add(this.castToReference(value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1465121818: {
                    this.getActionReason().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(this.castToCoding(value));
                    return value;
                }
                case 92750597: {
                    this.getAgent().add((TermAgentComponent)value);
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case 2046675654: {
                    this.getValuedItem().add((TermValuedItemComponent)value);
                    return value;
                }
                case 98629247: {
                    this.getGroup().add((TermComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(Contract.SP_ISSUED)) {
                this.issued = this.castToDateTime(value);
            } else if (name.equals("applies")) {
                this.applies = this.castToPeriod(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("subType")) {
                this.subType = this.castToCodeableConcept(value);
            } else if (name.equals("topic")) {
                this.getTopic().add(this.castToReference(value));
            } else if (name.equals("action")) {
                this.getAction().add(this.castToCodeableConcept(value));
            } else if (name.equals("actionReason")) {
                this.getActionReason().add(this.castToCodeableConcept(value));
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(this.castToCoding(value));
            } else if (name.equals(Contract.SP_AGENT)) {
                this.getAgent().add((TermAgentComponent)value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("valuedItem")) {
                this.getValuedItem().add((TermValuedItemComponent)value);
            } else if (name.equals("group")) {
                this.getGroup().add((TermComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -1179159893: {
                    return this.getIssuedElement();
                }
                case -793235316: {
                    return this.getApplies();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1868521062: {
                    return this.getSubType();
                }
                case 110546223: {
                    return this.addTopic();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case 1465121818: {
                    return this.addActionReason();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case 92750597: {
                    return this.addAgent();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case 2046675654: {
                    return this.addValuedItem();
                }
                case 98629247: {
                    return this.addGroup();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1179159893: {
                    return new String[]{"dateTime"};
                }
                case -793235316: {
                    return new String[]{"Period"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868521062: {
                    return new String[]{"CodeableConcept"};
                }
                case 110546223: {
                    return new String[]{"Reference"};
                }
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case 1465121818: {
                    return new String[]{"CodeableConcept"};
                }
                case -722296940: {
                    return new String[]{"Coding"};
                }
                case 92750597: {
                    return new String[0];
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case 2046675654: {
                    return new String[0];
                }
                case 98629247: {
                    return new String[]{"@Contract.term"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(Contract.SP_ISSUED)) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.issued");
            }
            if (name.equals("applies")) {
                this.applies = new Period();
                return this.applies;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("subType")) {
                this.subType = new CodeableConcept();
                return this.subType;
            }
            if (name.equals("topic")) {
                return this.addTopic();
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            if (name.equals("actionReason")) {
                return this.addActionReason();
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals(Contract.SP_AGENT)) {
                return this.addAgent();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.text");
            }
            if (name.equals("valuedItem")) {
                return this.addValuedItem();
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public TermComponent copy() {
            TermComponent dst = new TermComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.issued = this.issued == null ? null : this.issued.copy();
            dst.applies = this.applies == null ? null : this.applies.copy();
            dst.type = this.type == null ? null : this.type.copy();
            CodeableConcept codeableConcept = dst.subType = this.subType == null ? null : this.subType.copy();
            if (this.topic != null) {
                dst.topic = new ArrayList<Reference>();
                for (Reference reference : this.topic) {
                    dst.topic.add(reference.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.action) {
                    dst.action.add(codeableConcept2.copy());
                }
            }
            if (this.actionReason != null) {
                dst.actionReason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.actionReason) {
                    dst.actionReason.add(codeableConcept3.copy());
                }
            }
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding : this.securityLabel) {
                    dst.securityLabel.add(coding.copy());
                }
            }
            if (this.agent != null) {
                dst.agent = new ArrayList<TermAgentComponent>();
                for (TermAgentComponent termAgentComponent : this.agent) {
                    dst.agent.add(termAgentComponent.copy());
                }
            }
            StringType stringType = dst.text = this.text == null ? null : this.text.copy();
            if (this.valuedItem != null) {
                dst.valuedItem = new ArrayList<TermValuedItemComponent>();
                for (TermValuedItemComponent termValuedItemComponent : this.valuedItem) {
                    dst.valuedItem.add(termValuedItemComponent.copy());
                }
            }
            if (this.group != null) {
                dst.group = new ArrayList<TermComponent>();
                for (TermComponent termComponent : this.group) {
                    dst.group.add(termComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TermComponent)) {
                return false;
            }
            TermComponent o = (TermComponent)other_;
            return TermComponent.compareDeep(this.identifier, o.identifier, true) && TermComponent.compareDeep(this.issued, o.issued, true) && TermComponent.compareDeep(this.applies, o.applies, true) && TermComponent.compareDeep(this.type, o.type, true) && TermComponent.compareDeep(this.subType, o.subType, true) && TermComponent.compareDeep(this.topic, o.topic, true) && TermComponent.compareDeep(this.action, o.action, true) && TermComponent.compareDeep(this.actionReason, o.actionReason, true) && TermComponent.compareDeep(this.securityLabel, o.securityLabel, true) && TermComponent.compareDeep(this.agent, o.agent, true) && TermComponent.compareDeep(this.text, o.text, true) && TermComponent.compareDeep(this.valuedItem, o.valuedItem, true) && TermComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TermComponent)) {
                return false;
            }
            TermComponent o = (TermComponent)other_;
            return TermComponent.compareValues(this.issued, o.issued, true) && TermComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.issued, this.applies, this.type, this.subType, this.topic, this.action, this.actionReason, this.securityLabel, this.agent, this.text, this.valuedItem, this.group});
        }

        @Override
        public String fhirType() {
            return "Contract.term";
        }
    }

    @Block
    public static class ValuedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={CodeableConcept.class, Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Type", formalDefinition="Specific type of Contract Valued Item that may be priced.")
        protected Type entity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Number", formalDefinition="Identifies a Contract Valued Item instance.")
        protected Identifier identifier;
        @Child(name="effectiveTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Effective Tiem", formalDefinition="Indicates the time during which this Contract ValuedItem information is effective.")
        protected DateTimeType effectiveTime;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Contract Valued Items", formalDefinition="Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item fee, charge, or cost", formalDefinition="A Contract Valued Item unit valuation measure.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Price Scaling Factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Difficulty Scaling Factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total Contract Valued Item Value", formalDefinition="Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        private static final long serialVersionUID = 1782449516L;

        public Type getEntity() {
            return this.entity;
        }

        public CodeableConcept getEntityCodeableConcept() throws FHIRException {
            if (this.entity == null) {
                return null;
            }
            if (!(this.entity instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.entity;
        }

        public boolean hasEntityCodeableConcept() {
            return this != null && this.entity instanceof CodeableConcept;
        }

        public Reference getEntityReference() throws FHIRException {
            if (this.entity == null) {
                return null;
            }
            if (!(this.entity instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (Reference)this.entity;
        }

        public boolean hasEntityReference() {
            return this != null && this.entity instanceof Reference;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public ValuedItemComponent setEntity(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Contract.valuedItem.entity[x]: " + value.fhirType());
            }
            this.entity = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ValuedItemComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getEffectiveTimeElement() {
            if (this.effectiveTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.effectiveTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveTime = new DateTimeType();
                }
            }
            return this.effectiveTime;
        }

        public boolean hasEffectiveTimeElement() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public boolean hasEffectiveTime() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public ValuedItemComponent setEffectiveTimeElement(DateTimeType value) {
            this.effectiveTime = value;
            return this;
        }

        public Date getEffectiveTime() {
            return this.effectiveTime == null ? null : (Date)this.effectiveTime.getValue();
        }

        public ValuedItemComponent setEffectiveTime(Date value) {
            if (value == null) {
                this.effectiveTime = null;
            } else {
                if (this.effectiveTime == null) {
                    this.effectiveTime = new DateTimeType();
                }
                this.effectiveTime.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ValuedItemComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ValuedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ValuedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ValuedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ValuedItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ValuedItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public ValuedItemComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public ValuedItemComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public ValuedItemComponent setPoints(long value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public ValuedItemComponent setPoints(double value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ValuedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity));
            children.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Valued Item instance.", 0, 1, this.identifier));
            children.add(new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract ValuedItem information is effective.", 0, 1, this.effectiveTime));
            children.add(new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "A Contract Valued Item unit valuation measure.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.", 0, 1, this.points));
            children.add(new Property("net", "Money", "Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -740568643: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -1298275357: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case 924197182: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -356635992: {
                    return new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, 1, this.entity);
                }
                case -1618432855: {
                    return new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Valued Item instance.", 0, 1, this.identifier);
                }
                case -929905388: {
                    return new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract ValuedItem information is effective.", 0, 1, this.effectiveTime);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "A Contract Valued Item unit valuation measure.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case -982754077: {
                    return new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.", 0, 1, this.points);
                }
                case 108957: {
                    return new Property("net", "Money", "Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    Base[] baseArray;
                    if (this.entity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.entity;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -929905388: {
                    Base[] baseArray;
                    if (this.effectiveTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.effectiveTime;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case -982754077: {
                    Base[] baseArray;
                    if (this.points == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.points;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    this.entity = this.castToType(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -929905388: {
                    this.effectiveTime = this.castToDateTime(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case -982754077: {
                    this.points = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity[x]")) {
                this.entity = this.castToType(value);
            } else if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("effectiveTime")) {
                this.effectiveTime = this.castToDateTime(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -740568643: {
                    return this.getEntity();
                }
                case -1298275357: {
                    return this.getEntity();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -929905388: {
                    return this.getEffectiveTimeElement();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case -982754077: {
                    return this.getPointsElement();
                }
                case 108957: {
                    return this.getNet();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -929905388: {
                    return new String[]{"dateTime"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case -982754077: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entityCodeableConcept")) {
                this.entity = new CodeableConcept();
                return this.entity;
            }
            if (name.equals("entityReference")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("effectiveTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.effectiveTime");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a primitive type Contract.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            return super.addChild(name);
        }

        @Override
        public ValuedItemComponent copy() {
            ValuedItemComponent dst = new ValuedItemComponent();
            this.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.effectiveTime = this.effectiveTime == null ? null : this.effectiveTime.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValuedItemComponent)) {
                return false;
            }
            ValuedItemComponent o = (ValuedItemComponent)other_;
            return ValuedItemComponent.compareDeep(this.entity, o.entity, true) && ValuedItemComponent.compareDeep(this.identifier, o.identifier, true) && ValuedItemComponent.compareDeep(this.effectiveTime, o.effectiveTime, true) && ValuedItemComponent.compareDeep(this.quantity, o.quantity, true) && ValuedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ValuedItemComponent.compareDeep(this.factor, o.factor, true) && ValuedItemComponent.compareDeep(this.points, o.points, true) && ValuedItemComponent.compareDeep(this.net, o.net, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValuedItemComponent)) {
                return false;
            }
            ValuedItemComponent o = (ValuedItemComponent)other_;
            return ValuedItemComponent.compareValues(this.effectiveTime, o.effectiveTime, true) && ValuedItemComponent.compareValues(this.factor, o.factor, true) && ValuedItemComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.entity, this.identifier, this.effectiveTime, this.quantity, this.unitPrice, this.factor, this.points, this.net});
        }

        @Override
        public String fhirType() {
            return "Contract.valuedItem";
        }
    }

    @Block
    public static class SignatoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Signatory Role", formalDefinition="Role of this Contract signer, e.g. notary, grantee.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-signer-type")
        protected Coding type;
        @Child(name="party", type={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Signatory Party", formalDefinition="Party which is a signator to this Contract.")
        protected Reference party;
        protected Resource partyTarget;
        @Child(name="signature", type={Signature.class}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Documentation Signature", formalDefinition="Legally binding Contract DSIG signature contents in Base64.")
        protected List<Signature> signature;
        private static final long serialVersionUID = 1948139228L;

        public SignatoryComponent() {
        }

        public SignatoryComponent(Coding type, Reference party) {
            this.type = type;
            this.party = party;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SignatoryComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public SignatoryComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public SignatoryComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        public List<Signature> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<Signature>();
            }
            return this.signature;
        }

        public SignatoryComponent setSignature(List<Signature> theSignature) {
            this.signature = theSignature;
            return this;
        }

        public boolean hasSignature() {
            if (this.signature == null) {
                return false;
            }
            for (Signature item : this.signature) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Signature addSignature() {
            Signature t = new Signature();
            if (this.signature == null) {
                this.signature = new ArrayList<Signature>();
            }
            this.signature.add(t);
            return t;
        }

        public SignatoryComponent addSignature(Signature t) {
            if (t == null) {
                return this;
            }
            if (this.signature == null) {
                this.signature = new ArrayList<Signature>();
            }
            this.signature.add(t);
            return this;
        }

        public Signature getSignatureFirstRep() {
            if (this.getSignature().isEmpty()) {
                this.addSignature();
            }
            return this.getSignature().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "Coding", "Role of this Contract signer, e.g. notary, grantee.", 0, 1, this.type));
            children.add(new Property("party", "Reference(Organization|Patient|Practitioner|RelatedPerson)", "Party which is a signator to this Contract.", 0, 1, this.party));
            children.add(new Property("signature", "Signature", "Legally binding Contract DSIG signature contents in Base64.", 0, Integer.MAX_VALUE, this.signature));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "Coding", "Role of this Contract signer, e.g. notary, grantee.", 0, 1, this.type);
                }
                case 106437350: {
                    return new Property("party", "Reference(Organization|Patient|Practitioner|RelatedPerson)", "Party which is a signator to this Contract.", 0, 1, this.party);
                }
                case 1073584312: {
                    return new Property("signature", "Signature", "Legally binding Contract DSIG signature contents in Base64.", 0, Integer.MAX_VALUE, this.signature);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.party;
                    }
                    return baseArray;
                }
                case 1073584312: {
                    return this.signature == null ? new Base[]{} : this.signature.toArray(new Base[this.signature.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    return value;
                }
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
                case 1073584312: {
                    this.getSignature().add(this.castToSignature(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else if (name.equals("signature")) {
                this.getSignature().add(this.castToSignature(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 106437350: {
                    return this.getParty();
                }
                case 1073584312: {
                    return this.addSignature();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
                case 1073584312: {
                    return new String[]{"Signature"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            if (name.equals("signature")) {
                return this.addSignature();
            }
            return super.addChild(name);
        }

        @Override
        public SignatoryComponent copy() {
            SignatoryComponent dst = new SignatoryComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Reference reference = dst.party = this.party == null ? null : this.party.copy();
            if (this.signature != null) {
                dst.signature = new ArrayList<Signature>();
                for (Signature i : this.signature) {
                    dst.signature.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SignatoryComponent)) {
                return false;
            }
            SignatoryComponent o = (SignatoryComponent)other_;
            return SignatoryComponent.compareDeep(this.type, o.type, true) && SignatoryComponent.compareDeep(this.party, o.party, true) && SignatoryComponent.compareDeep(this.signature, o.signature, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SignatoryComponent)) {
                return false;
            }
            SignatoryComponent o = (SignatoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.party, this.signature});
        }

        @Override
        public String fhirType() {
            return "Contract.signer";
        }
    }

    @Block
    public static class AgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actor", type={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Agent Type", formalDefinition="Who or what parties are assigned roles in this Contract.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Role type of the agent", formalDefinition="Role type of agent assigned roles in this Contract.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contract-actorrole")
        protected List<CodeableConcept> role;
        private static final long serialVersionUID = -454551165L;

        public AgentComponent() {
        }

        public AgentComponent(Reference actor) {
            this.actor = actor;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AgentComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public AgentComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public AgentComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public AgentComponent setRole(List<CodeableConcept> theRole) {
            this.role = theRole;
            return this;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public AgentComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public CodeableConcept getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                this.addRole();
            }
            return this.getRole().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actor", "Reference(Contract|Device|Group|Location|Organization|Patient|Practitioner|RelatedPerson|Substance)", "Who or what parties are assigned roles in this Contract.", 0, 1, this.actor));
            children.add(new Property("role", "CodeableConcept", "Role type of agent assigned roles in this Contract.", 0, Integer.MAX_VALUE, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92645877: {
                    return new Property("actor", "Reference(Contract|Device|Group|Location|Organization|Patient|Practitioner|RelatedPerson|Substance)", "Who or what parties are assigned roles in this Contract.", 0, 1, this.actor);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role type of agent assigned roles in this Contract.", 0, Integer.MAX_VALUE, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actor;
                    }
                    return baseArray;
                }
                case 3506294: {
                    return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.getRole().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.getActor();
                }
                case 3506294: {
                    return this.addRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            return super.addChild(name);
        }

        @Override
        public AgentComponent copy() {
            AgentComponent dst = new AgentComponent();
            this.copyValues(dst);
            Reference reference = dst.actor = this.actor == null ? null : this.actor.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.role) {
                    dst.role.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AgentComponent)) {
                return false;
            }
            AgentComponent o = (AgentComponent)other_;
            return AgentComponent.compareDeep(this.actor, o.actor, true) && AgentComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AgentComponent)) {
                return false;
            }
            AgentComponent o = (AgentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.actor, this.role});
        }

        @Override
        public String fhirType() {
            return "Contract.agent";
        }
    }

    public static class ContractStatusEnumFactory
    implements EnumFactory<ContractStatus> {
        @Override
        public ContractStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return ContractStatus.AMENDED;
            }
            if ("appended".equals(codeString)) {
                return ContractStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return ContractStatus.CANCELLED;
            }
            if ("disputed".equals(codeString)) {
                return ContractStatus.DISPUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ContractStatus.ENTEREDINERROR;
            }
            if ("executable".equals(codeString)) {
                return ContractStatus.EXECUTABLE;
            }
            if ("executed".equals(codeString)) {
                return ContractStatus.EXECUTED;
            }
            if ("negotiable".equals(codeString)) {
                return ContractStatus.NEGOTIABLE;
            }
            if ("offered".equals(codeString)) {
                return ContractStatus.OFFERED;
            }
            if ("policy".equals(codeString)) {
                return ContractStatus.POLICY;
            }
            if ("rejected".equals(codeString)) {
                return ContractStatus.REJECTED;
            }
            if ("renewed".equals(codeString)) {
                return ContractStatus.RENEWED;
            }
            if ("revoked".equals(codeString)) {
                return ContractStatus.REVOKED;
            }
            if ("resolved".equals(codeString)) {
                return ContractStatus.RESOLVED;
            }
            if ("terminated".equals(codeString)) {
                return ContractStatus.TERMINATED;
            }
            throw new IllegalArgumentException("Unknown ContractStatus code '" + codeString + "'");
        }

        public Enumeration<ContractStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ContractStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.AMENDED);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.APPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.CANCELLED);
            }
            if ("disputed".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.DISPUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.ENTEREDINERROR);
            }
            if ("executable".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.EXECUTABLE);
            }
            if ("executed".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.EXECUTED);
            }
            if ("negotiable".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.NEGOTIABLE);
            }
            if ("offered".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.OFFERED);
            }
            if ("policy".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.POLICY);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.REJECTED);
            }
            if ("renewed".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.RENEWED);
            }
            if ("revoked".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.REVOKED);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.RESOLVED);
            }
            if ("terminated".equals(codeString)) {
                return new Enumeration<ContractStatus>(this, ContractStatus.TERMINATED);
            }
            throw new FHIRException("Unknown ContractStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ContractStatus code) {
            if (code == ContractStatus.AMENDED) {
                return "amended";
            }
            if (code == ContractStatus.APPENDED) {
                return "appended";
            }
            if (code == ContractStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ContractStatus.DISPUTED) {
                return "disputed";
            }
            if (code == ContractStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ContractStatus.EXECUTABLE) {
                return "executable";
            }
            if (code == ContractStatus.EXECUTED) {
                return "executed";
            }
            if (code == ContractStatus.NEGOTIABLE) {
                return "negotiable";
            }
            if (code == ContractStatus.OFFERED) {
                return "offered";
            }
            if (code == ContractStatus.POLICY) {
                return "policy";
            }
            if (code == ContractStatus.REJECTED) {
                return "rejected";
            }
            if (code == ContractStatus.RENEWED) {
                return "renewed";
            }
            if (code == ContractStatus.REVOKED) {
                return "revoked";
            }
            if (code == ContractStatus.RESOLVED) {
                return "resolved";
            }
            if (code == ContractStatus.TERMINATED) {
                return "terminated";
            }
            return "?";
        }

        @Override
        public String toSystem(ContractStatus code) {
            return code.getSystem();
        }
    }

    public static enum ContractStatus {
        AMENDED,
        APPENDED,
        CANCELLED,
        DISPUTED,
        ENTEREDINERROR,
        EXECUTABLE,
        EXECUTED,
        NEGOTIABLE,
        OFFERED,
        POLICY,
        REJECTED,
        RENEWED,
        REVOKED,
        RESOLVED,
        TERMINATED,
        NULL;


        public static ContractStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("disputed".equals(codeString)) {
                return DISPUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("executable".equals(codeString)) {
                return EXECUTABLE;
            }
            if ("executed".equals(codeString)) {
                return EXECUTED;
            }
            if ("negotiable".equals(codeString)) {
                return NEGOTIABLE;
            }
            if ("offered".equals(codeString)) {
                return OFFERED;
            }
            if ("policy".equals(codeString)) {
                return POLICY;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("renewed".equals(codeString)) {
                return RENEWED;
            }
            if ("revoked".equals(codeString)) {
                return REVOKED;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if ("terminated".equals(codeString)) {
                return TERMINATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ContractStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AMENDED: {
                    return "amended";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DISPUTED: {
                    return "disputed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case EXECUTABLE: {
                    return "executable";
                }
                case EXECUTED: {
                    return "executed";
                }
                case NEGOTIABLE: {
                    return "negotiable";
                }
                case OFFERED: {
                    return "offered";
                }
                case POLICY: {
                    return "policy";
                }
                case REJECTED: {
                    return "rejected";
                }
                case RENEWED: {
                    return "renewed";
                }
                case REVOKED: {
                    return "revoked";
                }
                case RESOLVED: {
                    return "resolved";
                }
                case TERMINATED: {
                    return "terminated";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AMENDED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case DISPUTED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case EXECUTABLE: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case EXECUTED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case NEGOTIABLE: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case OFFERED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case POLICY: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case RENEWED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case REVOKED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/contract-status";
                }
                case TERMINATED: {
                    return "http://hl7.org/fhir/contract-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AMENDED: {
                    return "Contract is augmented with additional information to correct errors in a predecessor or to updated values in a predecessor. Usage: Contract altered within effective time. Precedence Order = 9. Comparable FHIR and v.3 status codes: revised; replaced.";
                }
                case APPENDED: {
                    return "Contract is augmented with additional information that was missing from a predecessor Contract. Usage: Contract altered within effective time. Precedence Order = 9. Comparable FHIR and v.3 status codes: updated, replaced.";
                }
                case CANCELLED: {
                    return "Contract is terminated due to failure of the Grantor and/or the Grantee to fulfil one or more contract provisions. Usage: Abnormal contract termination. Precedence Order = 10. Comparable FHIR and v.3 status codes: stopped; failed; aborted.";
                }
                case DISPUTED: {
                    return "Contract is pended to rectify failure of the Grantor or the Grantee to fulfil contract provision(s). E.g., Grantee complaint about Grantor's failure to comply with contract provisions. Usage: Contract pended. Precedence Order = 7.Comparable FHIR and v.3 status codes: on hold; pended; suspended.";
                }
                case ENTEREDINERROR: {
                    return "Contract was created in error. No Precedence Order.  Status may be applied to a Contract with any status.";
                }
                case EXECUTABLE: {
                    return "Contract execution pending; may be executed when either the Grantor or the Grantee accepts the contract provisions by signing. I.e., where either the Grantor or the Grantee has signed, but not both. E.g., when an insurance applicant signs the insurers application, which references the policy.\u00a0Usage: Optional first step of contract execution activity.  May be skipped and contracting activity moves directly to executed state. Precedence Order = 3. Comparable FHIR and v.3 status codes: draft; preliminary; planned; intended; active.";
                }
                case EXECUTED: {
                    return "Contract is activated for period stipulated when both the Grantor and Grantee have signed it. Usage: Required state for normal completion of contracting activity.  Precedence Order = 6. Comparable FHIR and v.3 status codes: accepted; completed.";
                }
                case NEGOTIABLE: {
                    return "Contract execution is suspended while either or both the Grantor and Grantee propose and consider new or revised contract provisions. I.e., where the party which has not signed proposes changes to the terms.  E .g., a life insurer declines to agree to the signed application because the life insurer has evidence that the applicant, who asserted to being younger or a non-smoker to get a lower premium rate - but offers instead to agree to a higher premium based on the applicants actual age or smoking status. Usage: Optional contract activity between executable and executed state. Precedence Order = 4. Comparable FHIR and v.3 status codes: in progress; review; held.";
                }
                case OFFERED: {
                    return "Contract is a proposal by either the Grantor or the Grantee. Aka - A Contract hard copy or electronic 'template','form' or 'application'. E.g., health insurance application; consent directive form. Usage: Beginning of contract negotiation, which may have been completed as a precondition because used for 0..* contracts. Precedence Order = 2. Comparable FHIR and v.3 status codes: requested; new.";
                }
                case POLICY: {
                    return "Contract template is available as the basis for an application or offer by the Grantor or Grantee. E.g., health insurance policy; consent directive policy.  Usage: Required initial contract activity, which may have been completed as a precondition because used for 0..* contracts. Precedence Order = 1. Comparable FHIR and v.3 status codes: proposed; intended.";
                }
                case REJECTED: {
                    return " Execution of the Contract is not completed because either or both the Grantor and Grantee decline to accept some or all of the contract provisions. Usage: Optional contract activity between executable and abnormal termination. Precedence Order = 5. Comparable FHIR and v.3 status codes:  stopped; cancelled.";
                }
                case RENEWED: {
                    return "Beginning of a successor Contract at the termination of predecessor Contract lifecycle. Usage: Follows termination of a preceding Contract that has reached its expiry date. Precedence Order = 13. Comparable FHIR and v.3 status codes: superseded.";
                }
                case REVOKED: {
                    return "A Contract that is rescinded.  May be required prior to replacing with an updated Contract. Comparable FHIR and v.3 status codes: nullified.";
                }
                case RESOLVED: {
                    return "Contract is reactivated after being pended because of faulty execution. *E.g., competency of the signer(s), or where the policy is substantially different from and did not accompany the application/form so that the applicant could not compare them. Aka - ''reactivated''. Usage: Optional stage where a pended contract is reactivated. Precedence Order = 8. Comparable FHIR and v.3 status codes: reactivated.";
                }
                case TERMINATED: {
                    return "Contract reaches its expiry date.\u00a0It may or may not be renewed or renegotiated. Usage: Normal end of contract period. Precedence Order = 12. Comparable FHIR and v.3 status codes: Obsoleted.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AMENDED: {
                    return "Amended";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DISPUTED: {
                    return "Disputed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case EXECUTABLE: {
                    return "Executable";
                }
                case EXECUTED: {
                    return "Executed";
                }
                case NEGOTIABLE: {
                    return "Negotiable";
                }
                case OFFERED: {
                    return "Offered";
                }
                case POLICY: {
                    return "Policy";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case RENEWED: {
                    return "Renewed";
                }
                case REVOKED: {
                    return "Revoked";
                }
                case RESOLVED: {
                    return "Resolved";
                }
                case TERMINATED: {
                    return "Terminated";
                }
            }
            return "?";
        }
    }
}

