/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CodesystemHierarchyMeaning {
    GROUPEDBY,
    ISA,
    PARTOF,
    CLASSIFIEDWITH,
    NULL;


    public static CodesystemHierarchyMeaning fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("grouped-by".equals(codeString)) {
            return GROUPEDBY;
        }
        if ("is-a".equals(codeString)) {
            return ISA;
        }
        if ("part-of".equals(codeString)) {
            return PARTOF;
        }
        if ("classified-with".equals(codeString)) {
            return CLASSIFIEDWITH;
        }
        throw new FHIRException("Unknown CodesystemHierarchyMeaning code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GROUPEDBY: {
                return "grouped-by";
            }
            case ISA: {
                return "is-a";
            }
            case PARTOF: {
                return "part-of";
            }
            case CLASSIFIEDWITH: {
                return "classified-with";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/codesystem-hierarchy-meaning";
    }

    public String getDefinition() {
        switch (this) {
            case GROUPEDBY: {
                return "No particular relationship between the concepts can be assumed, except what can be determined by inspection of the definitions of the elements (possible reasons to use this: importing from a source where this is not defined, or where various parts of the hierarchy have different meanings)";
            }
            case ISA: {
                return "A hierarchy where the child concepts have an IS-A relationship with the parents - that is, all the properties of the parent are also true for its child concepts";
            }
            case PARTOF: {
                return "Child elements list the individual parts of a composite whole (e.g. body site)";
            }
            case CLASSIFIEDWITH: {
                return "Child concepts in the hierarchy may have only one parent, and there is a presumption that the code system is a \"closed world\" meaning all things must be in the hierarchy. This results in concepts such as \"not otherwise classified.\"";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GROUPEDBY: {
                return "Grouped By";
            }
            case ISA: {
                return "Is-A";
            }
            case PARTOF: {
                return "Part Of";
            }
            case CLASSIFIEDWITH: {
                return "Classified With";
            }
        }
        return "?";
    }
}

