/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QuestionnaireAnswersStatus {
    INPROGRESS,
    COMPLETED,
    AMENDED,
    ENTEREDINERROR,
    STOPPED,
    NULL;


    public static QuestionnaireAnswersStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("amended".equals(codeString)) {
            return AMENDED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        throw new FHIRException("Unknown QuestionnaireAnswersStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPROGRESS: {
                return "in-progress";
            }
            case COMPLETED: {
                return "completed";
            }
            case AMENDED: {
                return "amended";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case STOPPED: {
                return "stopped";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/questionnaire-answers-status";
    }

    public String getDefinition() {
        switch (this) {
            case INPROGRESS: {
                return "This QuestionnaireResponse has been partially filled out with answers, but changes or additions are still expected to be made to it.";
            }
            case COMPLETED: {
                return "This QuestionnaireResponse has been filled out with answers, and the current content is regarded as definitive.";
            }
            case AMENDED: {
                return "This QuestionnaireResponse has been filled out with answers, then marked as complete, yet changes or additions have been made to it afterwards.";
            }
            case ENTEREDINERROR: {
                return "This QuestionnaireResponse was entered in error and voided.";
            }
            case STOPPED: {
                return "This QuestionnaireResponse has been partially filled out with answers, but has been abandoned. It is unknown whether changes or additions are expected to be made to it.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPROGRESS: {
                return "In Progress";
            }
            case COMPLETED: {
                return "Completed";
            }
            case AMENDED: {
                return "Amended";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case STOPPED: {
                return "Stopped";
            }
        }
        return "?";
    }
}

