/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.rest.server;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Initialize;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestulfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCapabilityStatementProvider
implements IServerConformanceProvider<CapabilityStatement> {
    private static final Logger ourLog = LoggerFactory.getLogger(ServerCapabilityStatementProvider.class);
    private boolean myCache = true;
    private volatile CapabilityStatement myCapabilityStatement;
    private IdentityHashMap<SearchMethodBinding, String> myNamedSearchMethodBindingToName;
    private HashMap<String, List<SearchMethodBinding>> mySearchNameToBindings;
    private IdentityHashMap<OperationMethodBinding, String> myOperationBindingToName;
    private HashMap<String, List<OperationMethodBinding>> myOperationNameToBindings;
    private String myPublisher = "Not provided";
    private Callable<RestulfulServerConfiguration> myServerConfiguration;

    public ServerCapabilityStatementProvider() {
    }

    public ServerCapabilityStatementProvider(RestfulServer theRestfulServer) {
        this.myServerConfiguration = () -> ((RestfulServer)theRestfulServer).createConfiguration();
    }

    public ServerCapabilityStatementProvider(RestulfulServerConfiguration theServerConfiguration) {
        this.myServerConfiguration = () -> theServerConfiguration;
    }

    private void checkBindingForSystemOps(CapabilityStatement.CapabilityStatementRestComponent rest, Set<CapabilityStatement.SystemRestfulInteraction> systemOps, BaseMethodBinding<?> nextMethodBinding) {
        String sysOpCode;
        if (nextMethodBinding.getRestOperationType() != null && (sysOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
            CapabilityStatement.SystemRestfulInteraction sysOp;
            try {
                sysOp = CapabilityStatement.SystemRestfulInteraction.fromCode(sysOpCode);
            }
            catch (FHIRException e) {
                return;
            }
            if (sysOp == null) {
                return;
            }
            if (!systemOps.contains((Object)sysOp)) {
                systemOps.add(sysOp);
                rest.addInteraction().setCode(sysOp);
            }
        }
    }

    private Map<String, List<BaseMethodBinding<?>>> collectMethodBindings() {
        String resourceName;
        TreeMap resourceToMethods = new TreeMap();
        for (ResourceBinding next : this.getServerConfiguration().getResourceBindings()) {
            resourceName = next.getResourceName();
            for (BaseMethodBinding nextMethodBinding : next.getMethodBindings()) {
                if (!resourceToMethods.containsKey(resourceName)) {
                    resourceToMethods.put(resourceName, new ArrayList());
                }
                ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
            }
        }
        for (BaseMethodBinding nextMethodBinding : this.getServerConfiguration().getServerBindings()) {
            resourceName = "";
            if (!resourceToMethods.containsKey(resourceName)) {
                resourceToMethods.put(resourceName, new ArrayList());
            }
            ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
        }
        return resourceToMethods;
    }

    private DateTimeType conformanceDate() {
        IPrimitiveType buildDate = this.getServerConfiguration().getConformanceDate();
        if (buildDate != null && buildDate.getValue() != null) {
            try {
                return new DateTimeType(buildDate.getValueAsString());
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return DateTimeType.now();
    }

    private String createNamedQueryName(SearchMethodBinding searchMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (searchMethodBinding.getResourceName() != null) {
            retVal.append(searchMethodBinding.getResourceName());
        }
        retVal.append("-query-");
        retVal.append(searchMethodBinding.getQueryName());
        return retVal.toString();
    }

    private String createOperationName(OperationMethodBinding theMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (theMethodBinding.getResourceName() != null) {
            retVal.append(theMethodBinding.getResourceName());
        }
        retVal.append('-');
        if (theMethodBinding.isCanOperateAtInstanceLevel()) {
            retVal.append('i');
        }
        if (theMethodBinding.isCanOperateAtServerLevel()) {
            retVal.append('s');
        }
        retVal.append('-');
        retVal.append(theMethodBinding.getName(), 1, theMethodBinding.getName().length());
        return retVal.toString();
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    RestulfulServerConfiguration getServerConfiguration() {
        try {
            return this.myServerConfiguration.call();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Metadata
    public CapabilityStatement getServerConformance(HttpServletRequest theRequest) {
        if (this.myCapabilityStatement != null && this.myCache) {
            return this.myCapabilityStatement;
        }
        CapabilityStatement retVal = new CapabilityStatement();
        retVal.setPublisher(this.myPublisher);
        retVal.setDateElement(this.conformanceDate());
        retVal.setFhirVersion(FhirVersionEnum.DSTU3.getFhirVersionString());
        retVal.setAcceptUnknown(CapabilityStatement.UnknownContentCode.EXTENSIONS);
        ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
        String serverBase = this.getServerConfiguration().getServerAddressStrategy().determineServerBase(servletContext, theRequest);
        retVal.getImplementation().setUrl(serverBase).setDescription(this.getServerConfiguration().getImplementationDescription());
        retVal.setKind(CapabilityStatement.CapabilityStatementKind.INSTANCE);
        retVal.getSoftware().setName(this.getServerConfiguration().getServerName());
        retVal.getSoftware().setVersion(this.getServerConfiguration().getServerVersion());
        retVal.addFormat("application/fhir+xml");
        retVal.addFormat("application/fhir+json");
        retVal.setStatus(Enumerations.PublicationStatus.ACTIVE);
        CapabilityStatement.CapabilityStatementRestComponent rest = retVal.addRest();
        rest.setMode(CapabilityStatement.RestfulCapabilityMode.SERVER);
        HashSet<CapabilityStatement.SystemRestfulInteraction> systemOps = new HashSet<CapabilityStatement.SystemRestfulInteraction>();
        HashSet<String> operationNames = new HashSet<String>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings();
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            if (!nextEntry.getKey().isEmpty()) {
                HashSet<CapabilityStatement.TypeRestfulInteraction> resourceOps = new HashSet<CapabilityStatement.TypeRestfulInteraction>();
                CapabilityStatement.CapabilityStatementRestResourceComponent resource = rest.addResource();
                String resourceName = nextEntry.getKey();
                RuntimeResourceDefinition def = this.getServerConfiguration().getFhirContext().getResourceDefinition(resourceName);
                resource.getTypeElement().setValue(def.getName());
                resource.getProfile().setReference(def.getResourceProfile(serverBase));
                TreeSet<String> includes = new TreeSet<String>();
                for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                    String opName;
                    SearchMethodBinding methodBinding;
                    String resOpCode;
                    if (nextMethodBinding.getRestOperationType() != null && (resOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
                        CapabilityStatement.TypeRestfulInteraction resOp;
                        try {
                            resOp = CapabilityStatement.TypeRestfulInteraction.fromCode(resOpCode);
                        }
                        catch (Exception e) {
                            resOp = null;
                        }
                        if (resOp != null) {
                            if (!resourceOps.contains((Object)resOp)) {
                                resourceOps.add(resOp);
                                resource.addInteraction().setCode(resOp);
                            }
                            if ("vread".equals(resOpCode) && !resourceOps.contains((Object)(resOp = CapabilityStatement.TypeRestfulInteraction.READ))) {
                                resourceOps.add(resOp);
                                resource.addInteraction().setCode(resOp);
                            }
                            if (nextMethodBinding.isSupportsConditional()) {
                                switch (resOp) {
                                    case CREATE: {
                                        resource.setConditionalCreate(true);
                                        break;
                                    }
                                    case DELETE: {
                                        if (nextMethodBinding.isSupportsConditionalMultiple()) {
                                            resource.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                                            break;
                                        }
                                        resource.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                                        break;
                                    }
                                    case UPDATE: {
                                        resource.setConditionalUpdate(true);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                    if (nextMethodBinding instanceof SearchMethodBinding) {
                        methodBinding = (SearchMethodBinding)nextMethodBinding;
                        if (methodBinding.getQueryName() != null) {
                            String queryName = this.myNamedSearchMethodBindingToName.get(methodBinding);
                            if (operationNames.add(queryName)) {
                                rest.addOperation().setName(methodBinding.getQueryName()).setDefinition(new Reference("OperationDefinition/" + queryName));
                            }
                        } else {
                            this.handleNamelessSearchMethodBinding(rest, resource, resourceName, def, includes, (SearchMethodBinding)nextMethodBinding);
                        }
                    } else if (nextMethodBinding instanceof OperationMethodBinding && operationNames.add(opName = this.myOperationBindingToName.get(methodBinding = (OperationMethodBinding)nextMethodBinding))) {
                        rest.addOperation().setName(methodBinding.getName().substring(1)).setDefinition(new Reference("OperationDefinition/" + opName));
                    }
                    resource.getInteraction().sort(new Comparator<CapabilityStatement.ResourceInteractionComponent>(){

                        @Override
                        public int compare(CapabilityStatement.ResourceInteractionComponent theO1, CapabilityStatement.ResourceInteractionComponent theO2) {
                            CapabilityStatement.TypeRestfulInteraction o1 = theO1.getCode();
                            CapabilityStatement.TypeRestfulInteraction o2 = theO2.getCode();
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            if (o2 == null) {
                                return -1;
                            }
                            return o1.ordinal() - o2.ordinal();
                        }
                    });
                }
                for (String nextInclude : includes) {
                    resource.addSearchInclude(nextInclude);
                }
                continue;
            }
            for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                OperationMethodBinding methodBinding;
                String opName;
                this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                if (!(nextMethodBinding instanceof OperationMethodBinding) || !operationNames.add(opName = this.myOperationBindingToName.get(methodBinding = (OperationMethodBinding)nextMethodBinding))) continue;
                ourLog.debug("Found bound operation: {}", (Object)opName);
                rest.addOperation().setName(methodBinding.getName().substring(1)).setDefinition(new Reference("OperationDefinition/" + opName));
            }
        }
        this.myCapabilityStatement = retVal;
        return retVal;
    }

    private void handleNamelessSearchMethodBinding(CapabilityStatement.CapabilityStatementRestComponent rest, CapabilityStatement.CapabilityStatementRestResourceComponent resource, String resourceName, RuntimeResourceDefinition def, TreeSet<String> includes, SearchMethodBinding searchMethodBinding) {
        includes.addAll(searchMethodBinding.getIncludes());
        List params = searchMethodBinding.getParameters();
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (IParameter iParameter : params) {
            if (!(iParameter instanceof SearchParameter)) continue;
            searchParameters.add((SearchParameter)iParameter);
        }
        this.sortSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            for (SearchParameter searchParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName = searchParameter.getName();
                String chain = null;
                String nextParamUnchainedName = nextParamName;
                if (nextParamName.contains(".")) {
                    chain = nextParamName.substring(nextParamName.indexOf(46) + 1);
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = searchParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent param = resource.addSearchParam();
                param.setName(nextParamUnchainedName);
                param.setDocumentation(nextParamDescription);
                if (searchParameter.getParamType() != null) {
                    param.getTypeElement().setValueAsString(searchParameter.getParamType().getCode());
                }
                for (Class nextTarget : searchParameter.getDeclaredTypes()) {
                    RuntimeResourceDefinition targetDef = this.getServerConfiguration().getFhirContext().getResourceDefinition(nextTarget);
                    if (targetDef == null) continue;
                    try {
                        ResourceType code = ResourceType.fromCode(targetDef.getName());
                    }
                    catch (FHIRException e) {
                        Object var19_21 = null;
                    }
                }
            }
        }
    }

    @Initialize
    public void initializeOperations() {
        this.myNamedSearchMethodBindingToName = new IdentityHashMap();
        this.mySearchNameToBindings = new HashMap();
        this.myOperationBindingToName = new IdentityHashMap();
        this.myOperationNameToBindings = new HashMap();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings();
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            List<BaseMethodBinding<?>> nextMethodBindings = nextEntry.getValue();
            for (BaseMethodBinding<?> nextMethodBinding : nextMethodBindings) {
                String name;
                OperationMethodBinding methodBinding;
                if (nextMethodBinding instanceof OperationMethodBinding) {
                    methodBinding = (OperationMethodBinding)nextMethodBinding;
                    if (this.myOperationBindingToName.containsKey(methodBinding)) continue;
                    name = this.createOperationName(methodBinding);
                    ourLog.debug("Detected operation: {}", (Object)name);
                    this.myOperationBindingToName.put(methodBinding, name);
                    if (!this.myOperationNameToBindings.containsKey(name)) {
                        this.myOperationNameToBindings.put(name, new ArrayList());
                    }
                    this.myOperationNameToBindings.get(name).add(methodBinding);
                    continue;
                }
                if (!(nextMethodBinding instanceof SearchMethodBinding) || this.myNamedSearchMethodBindingToName.containsKey(methodBinding = (SearchMethodBinding)nextMethodBinding)) continue;
                name = this.createNamedQueryName((SearchMethodBinding)methodBinding);
                ourLog.debug("Detected named query: {}", (Object)name);
                this.myNamedSearchMethodBindingToName.put((SearchMethodBinding)methodBinding, name);
                if (!this.mySearchNameToBindings.containsKey(name)) {
                    this.mySearchNameToBindings.put(name, new ArrayList());
                }
                this.mySearchNameToBindings.get(name).add((SearchMethodBinding)methodBinding);
            }
        }
    }

    @Read(type=OperationDefinition.class)
    public OperationDefinition readOperationDefinition(@IdParam IdType theId) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException((IIdType)theId);
        }
        List<OperationMethodBinding> operationBindings = this.myOperationNameToBindings.get(theId.getIdPart());
        if (operationBindings != null && !operationBindings.isEmpty()) {
            return this.readOperationDefinitionForOperation(operationBindings);
        }
        List<SearchMethodBinding> searchBindings = this.mySearchNameToBindings.get(theId.getIdPart());
        if (searchBindings != null && !searchBindings.isEmpty()) {
            return this.readOperationDefinitionForNamedSearch(searchBindings);
        }
        throw new ResourceNotFoundException((IIdType)theId);
    }

    private OperationDefinition readOperationDefinitionForNamedSearch(List<SearchMethodBinding> bindings) {
        OperationDefinition op = new OperationDefinition();
        op.setStatus(Enumerations.PublicationStatus.ACTIVE);
        op.setKind(OperationDefinition.OperationKind.QUERY);
        op.setIdempotent(true);
        op.setSystem(false);
        op.setType(false);
        op.setInstance(false);
        HashSet<String> inParams = new HashSet<String>();
        for (SearchMethodBinding binding : bindings) {
            if (StringUtils.isNotBlank((CharSequence)binding.getDescription())) {
                op.setDescription(binding.getDescription());
            }
            if (StringUtils.isBlank((CharSequence)binding.getResourceProviderResourceName())) {
                op.setSystem(true);
            } else {
                op.setType(true);
                op.addResourceElement().setValue(binding.getResourceProviderResourceName());
            }
            op.setCode(binding.getQueryName());
            for (IParameter nextParamUntyped : binding.getParameters()) {
                SearchParameter nextParam;
                if (!(nextParamUntyped instanceof SearchParameter) || !inParams.add((nextParam = (SearchParameter)nextParamUntyped).getName())) continue;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                param.setUse(OperationDefinition.OperationParameterUse.IN);
                param.setType("string");
                param.getSearchTypeElement().setValueAsString(nextParam.getParamType().getCode());
                param.setMin(nextParam.isRequired() ? 1 : 0);
                param.setMax("1");
                param.setName(nextParam.getName());
            }
            if (!StringUtils.isBlank((CharSequence)op.getName())) continue;
            if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                op.setName(op.getDescription());
                continue;
            }
            op.setName(op.getCode());
        }
        return op;
    }

    private OperationDefinition readOperationDefinitionForOperation(List<OperationMethodBinding> bindings) {
        OperationDefinition op = new OperationDefinition();
        op.setStatus(Enumerations.PublicationStatus.ACTIVE);
        op.setKind(OperationDefinition.OperationKind.OPERATION);
        op.setIdempotent(true);
        op.setSystem(false);
        op.setType(false);
        op.setInstance(false);
        HashSet<String> inParams = new HashSet<String>();
        HashSet<String> outParams = new HashSet<String>();
        for (OperationMethodBinding sharedDescription : bindings) {
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getDescription())) {
                op.setDescription(sharedDescription.getDescription());
            }
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(true);
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(true);
            }
            if (sharedDescription.isCanOperateAtTypeLevel()) {
                op.setType(true);
            }
            if (!sharedDescription.isIdempotent()) {
                op.setIdempotent(sharedDescription.isIdempotent());
            }
            op.setCode(sharedDescription.getName().substring(1));
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(sharedDescription.isCanOperateAtInstanceLevel());
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(sharedDescription.isCanOperateAtServerLevel());
            }
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getResourceName())) {
                op.addResourceElement().setValue(sharedDescription.getResourceName());
            }
            for (IParameter nextParamUntyped : sharedDescription.getParameters()) {
                if (!(nextParamUntyped instanceof OperationParameter)) continue;
                OperationParameter nextParam = (OperationParameter)nextParamUntyped;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                if (!inParams.add(nextParam.getName())) continue;
                param.setUse(OperationDefinition.OperationParameterUse.IN);
                if (nextParam.getParamType() != null) {
                    param.setType(nextParam.getParamType());
                }
                if (nextParam.getSearchParamType() != null) {
                    param.getSearchTypeElement().setValueAsString(nextParam.getSearchParamType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
            for (OperationMethodBinding.ReturnType nextParam : sharedDescription.getReturnParams()) {
                if (!outParams.add(nextParam.getName())) continue;
                OperationDefinition.OperationDefinitionParameterComponent param = op.addParameter();
                param.setUse(OperationDefinition.OperationParameterUse.OUT);
                if (nextParam.getType() != null) {
                    param.setType(nextParam.getType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
        }
        if (StringUtils.isBlank((CharSequence)op.getName())) {
            if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                op.setName(op.getDescription());
            } else {
                op.setName(op.getCode());
            }
        }
        if (!op.hasSystem()) {
            op.setSystem(false);
        }
        if (!op.hasInstance()) {
            op.setInstance(false);
        }
        return op;
    }

    public ServerCapabilityStatementProvider setCache(boolean theCache) {
        this.myCache = theCache;
        return this;
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
        this.myServerConfiguration = () -> ((RestfulServer)theRestfulServer).createConfiguration();
    }

    private void sortRuntimeSearchParameters(List<RuntimeSearchParam> searchParameters) {
        Collections.sort(searchParameters, new Comparator<RuntimeSearchParam>(){

            @Override
            public int compare(RuntimeSearchParam theO1, RuntimeSearchParam theO2) {
                return theO1.getName().compareTo(theO2.getName());
            }
        });
    }

    private void sortSearchParameters(List<SearchParameter> searchParameters) {
        Collections.sort(searchParameters, new Comparator<SearchParameter>(){

            @Override
            public int compare(SearchParameter theO1, SearchParameter theO2) {
                if (theO1.isRequired() == theO2.isRequired()) {
                    return theO1.getName().compareTo(theO2.getName());
                }
                if (theO1.isRequired()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

