/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Composition", profile="http://hl7.org/fhir/StructureDefinition/Composition")
public class Composition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier of composition (version-independent)", formalDefinition="Logical identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preliminary | final | amended | entered-in-error", formalDefinition="The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-status")
    protected Enumeration<CompositionStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of composition (LOINC if possible)", formalDefinition="Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/doc-typecodes")
    protected CodeableConcept type;
    @Child(name="class", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Categorization of Composition", formalDefinition="A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/doc-classcodes")
    protected CodeableConcept class_;
    @Child(name="subject", type={Reference.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what the composition is about", formalDefinition="Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Context of the Composition", formalDefinition="Describes the clinical encounter or type of care this documentation is associated with.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="date", type={DateTimeType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composition editing time", formalDefinition="The composition editing time, when the composition was last logically changed by the author.")
    protected DateTimeType date;
    @Child(name="author", type={Practitioner.class, Device.class, Patient.class, RelatedPerson.class}, order=7, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what authored the composition", formalDefinition="Identifies who is responsible for the information in the composition, not necessarily who typed it in.")
    protected List<Reference> author;
    protected List<Resource> authorTarget;
    @Child(name="title", type={StringType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human Readable name/title", formalDefinition="Official human-readable label for the composition.")
    protected StringType title;
    @Child(name="confidentiality", type={CodeType.class}, order=9, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="As defined by affinity domain", formalDefinition="The code specifying the level of confidentiality of the Composition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ConfidentialityClassification")
    protected Enumeration<DocumentConfidentiality> confidentiality;
    @Child(name="attester", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Attests to accuracy of composition", formalDefinition="A participant who has attested to the accuracy of the composition/document.")
    protected List<CompositionAttesterComponent> attester;
    @Child(name="custodian", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization which maintains the composition", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.")
    protected Reference custodian;
    protected Organization custodianTarget;
    @Child(name="relatesTo", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Relationships to other compositions/documents", formalDefinition="Relationships that this composition has with other compositions or documents that already exist.")
    protected List<CompositionRelatesToComponent> relatesTo;
    @Child(name="event", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The clinical service(s) being documented", formalDefinition="The clinical service, such as a colonoscopy or an appendectomy, being documented.")
    protected List<CompositionEventComponent> event;
    @Child(name="section", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Composition is broken into sections", formalDefinition="The root of the sections that make up the composition.")
    protected List<SectionComponent> section;
    private static final long serialVersionUID = -1422555114L;
    @SearchParamDefinition(name="date", path="Composition.date", description="Composition editing time", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Composition.identifier", description="Logical identifier of composition (version-independent)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="period", path="Composition.event.period", description="The period covered by the documentation", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="related-id", path="Composition.relatesTo.target.as(Identifier)", description="Target of the relationship", type="token")
    public static final String SP_RELATED_ID = "related-id";
    public static final TokenClientParam RELATED_ID = new TokenClientParam("related-id");
    @SearchParamDefinition(name="subject", path="Composition.subject", description="Who and/or what the composition is about", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Composition:subject").toLocked();
    @SearchParamDefinition(name="author", path="Composition.author", description="Who and/or what authored the composition", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Composition:author").toLocked();
    @SearchParamDefinition(name="confidentiality", path="Composition.confidentiality", description="As defined by affinity domain", type="token")
    public static final String SP_CONFIDENTIALITY = "confidentiality";
    public static final TokenClientParam CONFIDENTIALITY = new TokenClientParam("confidentiality");
    @SearchParamDefinition(name="section", path="Composition.section.code", description="Classification of section (recommended)", type="token")
    public static final String SP_SECTION = "section";
    public static final TokenClientParam SECTION = new TokenClientParam("section");
    @SearchParamDefinition(name="encounter", path="Composition.encounter", description="Context of the Composition", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Composition:encounter").toLocked();
    @SearchParamDefinition(name="type", path="Composition.type", description="Kind of composition (LOINC if possible)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="title", path="Composition.title", description="Human Readable name/title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="attester", path="Composition.attester.party", description="Who attested the composition", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Organization.class, Patient.class, Practitioner.class})
    public static final String SP_ATTESTER = "attester";
    public static final ReferenceClientParam ATTESTER = new ReferenceClientParam("attester");
    public static final Include INCLUDE_ATTESTER = new Include("Composition:attester").toLocked();
    @SearchParamDefinition(name="entry", path="Composition.section.entry", description="A reference to data that supports this section", type="reference")
    public static final String SP_ENTRY = "entry";
    public static final ReferenceClientParam ENTRY = new ReferenceClientParam("entry");
    public static final Include INCLUDE_ENTRY = new Include("Composition:entry").toLocked();
    @SearchParamDefinition(name="related-ref", path="Composition.relatesTo.target.as(Reference)", description="Target of the relationship", type="reference", target={Composition.class})
    public static final String SP_RELATED_REF = "related-ref";
    public static final ReferenceClientParam RELATED_REF = new ReferenceClientParam("related-ref");
    public static final Include INCLUDE_RELATED_REF = new Include("Composition:related-ref").toLocked();
    @SearchParamDefinition(name="patient", path="Composition.subject", description="Who and/or what the composition is about", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Composition:patient").toLocked();
    @SearchParamDefinition(name="context", path="Composition.event.code", description="Code(s) that apply to the event being documented", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="class", path="Composition.class", description="Categorization of Composition", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="status", path="Composition.status", description="preliminary | final | amended | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Composition() {
    }

    public Composition(Enumeration<CompositionStatus> status, CodeableConcept type, Reference subject, DateTimeType date, StringType title) {
        this.status = status;
        this.type = type;
        this.subject = subject;
        this.date = date;
        this.title = title;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Composition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<CompositionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CompositionStatus>(new CompositionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Composition setStatusElement(Enumeration<CompositionStatus> value) {
        this.status = value;
        return this;
    }

    public CompositionStatus getStatus() {
        return this.status == null ? null : (CompositionStatus)((Object)this.status.getValue());
    }

    public Composition setStatus(CompositionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<CompositionStatus>(new CompositionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Composition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new CodeableConcept();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public Composition setClass_(CodeableConcept value) {
        this.class_ = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Composition setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Composition setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Composition setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Composition setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Composition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Composition setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public Composition setAuthor(List<Reference> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public Composition addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public Reference getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Deprecated
    public List<Resource> getAuthorTarget() {
        if (this.authorTarget == null) {
            this.authorTarget = new ArrayList<Resource>();
        }
        return this.authorTarget;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Composition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Composition setTitle(String value) {
        if (this.title == null) {
            this.title = new StringType();
        }
        this.title.setValue(value);
        return this;
    }

    public Enumeration<DocumentConfidentiality> getConfidentialityElement() {
        if (this.confidentiality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.confidentiality");
            }
            if (Configuration.doAutoCreate()) {
                this.confidentiality = new Enumeration<DocumentConfidentiality>(new DocumentConfidentialityEnumFactory());
            }
        }
        return this.confidentiality;
    }

    public boolean hasConfidentialityElement() {
        return this.confidentiality != null && !this.confidentiality.isEmpty();
    }

    public boolean hasConfidentiality() {
        return this.confidentiality != null && !this.confidentiality.isEmpty();
    }

    public Composition setConfidentialityElement(Enumeration<DocumentConfidentiality> value) {
        this.confidentiality = value;
        return this;
    }

    public DocumentConfidentiality getConfidentiality() {
        return this.confidentiality == null ? null : (DocumentConfidentiality)((Object)this.confidentiality.getValue());
    }

    public Composition setConfidentiality(DocumentConfidentiality value) {
        if (value == null) {
            this.confidentiality = null;
        } else {
            if (this.confidentiality == null) {
                this.confidentiality = new Enumeration<DocumentConfidentiality>(new DocumentConfidentialityEnumFactory());
            }
            this.confidentiality.setValue((Object)value);
        }
        return this;
    }

    public List<CompositionAttesterComponent> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        return this.attester;
    }

    public Composition setAttester(List<CompositionAttesterComponent> theAttester) {
        this.attester = theAttester;
        return this;
    }

    public boolean hasAttester() {
        if (this.attester == null) {
            return false;
        }
        for (CompositionAttesterComponent item : this.attester) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionAttesterComponent addAttester() {
        CompositionAttesterComponent t = new CompositionAttesterComponent();
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        this.attester.add(t);
        return t;
    }

    public Composition addAttester(CompositionAttesterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        this.attester.add(t);
        return this;
    }

    public CompositionAttesterComponent getAttesterFirstRep() {
        if (this.getAttester().isEmpty()) {
            this.addAttester();
        }
        return this.getAttester().get(0);
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public Composition setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public Organization getCustodianTarget() {
        if (this.custodianTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodianTarget = new Organization();
            }
        }
        return this.custodianTarget;
    }

    public Composition setCustodianTarget(Organization value) {
        this.custodianTarget = value;
        return this;
    }

    public List<CompositionRelatesToComponent> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<CompositionRelatesToComponent>();
        }
        return this.relatesTo;
    }

    public Composition setRelatesTo(List<CompositionRelatesToComponent> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (CompositionRelatesToComponent item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionRelatesToComponent addRelatesTo() {
        CompositionRelatesToComponent t = new CompositionRelatesToComponent();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<CompositionRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public Composition addRelatesTo(CompositionRelatesToComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<CompositionRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public CompositionRelatesToComponent getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public List<CompositionEventComponent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        return this.event;
    }

    public Composition setEvent(List<CompositionEventComponent> theEvent) {
        this.event = theEvent;
        return this;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (CompositionEventComponent item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionEventComponent addEvent() {
        CompositionEventComponent t = new CompositionEventComponent();
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        this.event.add(t);
        return t;
    }

    public Composition addEvent(CompositionEventComponent t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        this.event.add(t);
        return this;
    }

    public CompositionEventComponent getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public List<SectionComponent> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        return this.section;
    }

    public Composition setSection(List<SectionComponent> theSection) {
        this.section = theSection;
        return this;
    }

    public boolean hasSection() {
        if (this.section == null) {
            return false;
        }
        for (SectionComponent item : this.section) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SectionComponent addSection() {
        SectionComponent t = new SectionComponent();
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return t;
    }

    public Composition addSection(SectionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return this;
    }

    public SectionComponent getSectionFirstRep() {
        if (this.getSection().isEmpty()) {
            this.addSection();
        }
        return this.getSection().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Logical identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time.", 0, 1, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.", 0, 1, this.type));
        children.add(new Property(SP_CLASS, "CodeableConcept", "A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.", 0, 1, this.class_));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care this documentation is associated with.", 0, 1, this.encounter));
        children.add(new Property(SP_DATE, "dateTime", "The composition editing time, when the composition was last logically changed by the author.", 0, 1, this.date));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device|Patient|RelatedPerson)", "Identifies who is responsible for the information in the composition, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property(SP_TITLE, "string", "Official human-readable label for the composition.", 0, 1, this.title));
        children.add(new Property(SP_CONFIDENTIALITY, "code", "The code specifying the level of confidentiality of the Composition.", 0, 1, this.confidentiality));
        children.add(new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester));
        children.add(new Property("custodian", "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.", 0, 1, this.custodian));
        children.add(new Property("relatesTo", "", "Relationships that this composition has with other compositions or documents that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property("event", "", "The clinical service, such as a colonoscopy or an appendectomy, being documented.", 0, Integer.MAX_VALUE, this.event));
        children.add(new Property(SP_SECTION, "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Logical identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.", 0, 1, this.type);
            }
            case 94742904: {
                return new Property(SP_CLASS, "CodeableConcept", "A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.", 0, 1, this.class_);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care this documentation is associated with.", 0, 1, this.encounter);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The composition editing time, when the composition was last logically changed by the author.", 0, 1, this.date);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|Device|Patient|RelatedPerson)", "Identifies who is responsible for the information in the composition, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "Official human-readable label for the composition.", 0, 1, this.title);
            }
            case -1923018202: {
                return new Property(SP_CONFIDENTIALITY, "code", "The code specifying the level of confidentiality of the Composition.", 0, 1, this.confidentiality);
            }
            case 542920370: {
                return new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester);
            }
            case 1611297262: {
                return new Property("custodian", "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.", 0, 1, this.custodian);
            }
            case -7765931: {
                return new Property("relatesTo", "", "Relationships that this composition has with other compositions or documents that already exist.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case 96891546: {
                return new Property("event", "", "The clinical service, such as a colonoscopy or an appendectomy, being documented.", 0, Integer.MAX_VALUE, this.event);
            }
            case 1970241253: {
                return new Property(SP_SECTION, "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.class_;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.title;
                }
                return baseArray;
            }
            case -1923018202: {
                Base[] baseArray;
                if (this.confidentiality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.confidentiality;
                }
                return baseArray;
            }
            case 542920370: {
                return this.attester == null ? new Base[]{} : this.attester.toArray(new Base[this.attester.size()]);
            }
            case 1611297262: {
                Base[] baseArray;
                if (this.custodian == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.custodian;
                }
                return baseArray;
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case 1970241253: {
                return this.section == null ? new Base[]{} : this.section.toArray(new Base[this.section.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new CompositionStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 94742904: {
                this.class_ = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToReference(value));
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -1923018202: {
                value = new DocumentConfidentialityEnumFactory().fromType(this.castToCode(value));
                this.confidentiality = value;
                return value;
            }
            case 542920370: {
                this.getAttester().add((CompositionAttesterComponent)((Object)value));
                return value;
            }
            case 1611297262: {
                this.custodian = this.castToReference(value);
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add((CompositionRelatesToComponent)((Object)value));
                return value;
            }
            case 96891546: {
                this.getEvent().add((CompositionEventComponent)((Object)value));
                return value;
            }
            case 1970241253: {
                this.getSection().add((SectionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new CompositionStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CLASS)) {
            this.class_ = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().add(this.castToReference(value));
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_CONFIDENTIALITY)) {
            value = new DocumentConfidentialityEnumFactory().fromType(this.castToCode(value));
            this.confidentiality = value;
        } else if (name.equals(SP_ATTESTER)) {
            this.getAttester().add((CompositionAttesterComponent)((Object)value));
        } else if (name.equals("custodian")) {
            this.custodian = this.castToReference(value);
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add((CompositionRelatesToComponent)((Object)value));
        } else if (name.equals("event")) {
            this.getEvent().add((CompositionEventComponent)((Object)value));
        } else if (name.equals(SP_SECTION)) {
            this.getSection().add((SectionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 94742904: {
                return this.getClass_();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1923018202: {
                return this.getConfidentialityElement();
            }
            case 542920370: {
                return this.addAttester();
            }
            case 1611297262: {
                return this.getCustodian();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case 96891546: {
                return this.addEvent();
            }
            case 1970241253: {
                return this.addSection();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 94742904: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1923018202: {
                return new String[]{"code"};
            }
            case 542920370: {
                return new String[0];
            }
            case 1611297262: {
                return new String[]{"Reference"};
            }
            case -7765931: {
                return new String[0];
            }
            case 96891546: {
                return new String[0];
            }
            case 1970241253: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CLASS)) {
            this.class_ = new CodeableConcept();
            return this.class_;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.date");
        }
        if (name.equals(SP_AUTHOR)) {
            return this.addAuthor();
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.title");
        }
        if (name.equals(SP_CONFIDENTIALITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.confidentiality");
        }
        if (name.equals(SP_ATTESTER)) {
            return this.addAttester();
        }
        if (name.equals("custodian")) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals("event")) {
            return this.addEvent();
        }
        if (name.equals(SP_SECTION)) {
            return this.addSection();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Composition";
    }

    @Override
    public Composition copy() {
        Composition dst = new Composition();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.class_ = this.class_ == null ? null : this.class_.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference : this.author) {
                dst.author.add(reference.copy());
            }
        }
        dst.title = this.title == null ? null : this.title.copy();
        Enumeration<DocumentConfidentiality> enumeration = dst.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
        if (this.attester != null) {
            dst.attester = new ArrayList<CompositionAttesterComponent>();
            for (CompositionAttesterComponent compositionAttesterComponent : this.attester) {
                dst.attester.add(compositionAttesterComponent.copy());
            }
        }
        Reference reference = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<CompositionRelatesToComponent>();
            for (CompositionRelatesToComponent compositionRelatesToComponent : this.relatesTo) {
                dst.relatesTo.add(compositionRelatesToComponent.copy());
            }
        }
        if (this.event != null) {
            dst.event = new ArrayList<CompositionEventComponent>();
            for (CompositionEventComponent compositionEventComponent : this.event) {
                dst.event.add(compositionEventComponent.copy());
            }
        }
        if (this.section != null) {
            dst.section = new ArrayList<SectionComponent>();
            for (SectionComponent sectionComponent : this.section) {
                dst.section.add(sectionComponent.copy());
            }
        }
        return dst;
    }

    protected Composition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Composition)) {
            return false;
        }
        Composition o = (Composition)other_;
        return Composition.compareDeep(this.identifier, o.identifier, true) && Composition.compareDeep(this.status, o.status, true) && Composition.compareDeep(this.type, o.type, true) && Composition.compareDeep(this.class_, o.class_, true) && Composition.compareDeep(this.subject, o.subject, true) && Composition.compareDeep(this.encounter, o.encounter, true) && Composition.compareDeep(this.date, o.date, true) && Composition.compareDeep(this.author, o.author, true) && Composition.compareDeep(this.title, o.title, true) && Composition.compareDeep(this.confidentiality, o.confidentiality, true) && Composition.compareDeep(this.attester, o.attester, true) && Composition.compareDeep(this.custodian, o.custodian, true) && Composition.compareDeep(this.relatesTo, o.relatesTo, true) && Composition.compareDeep(this.event, o.event, true) && Composition.compareDeep(this.section, o.section, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Composition)) {
            return false;
        }
        Composition o = (Composition)other_;
        return Composition.compareValues(this.status, o.status, true) && Composition.compareValues(this.date, o.date, true) && Composition.compareValues(this.title, o.title, true) && Composition.compareValues(this.confidentiality, o.confidentiality, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.class_, this.subject, this.encounter, this.date, this.author, this.title, this.confidentiality, this.attester, this.custodian, this.relatesTo, this.event, this.section});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Composition;
    }

    @Block
    public static class SectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for section (e.g. for ToC)", formalDefinition="The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.")
        protected StringType title;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of section (recommended)", formalDefinition="A code identifying the kind of content contained within the section. This must be consistent with the section title.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/doc-section-codes")
        protected CodeableConcept code;
        @Child(name="text", type={Narrative.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text summary of the section, for human interpretation", formalDefinition="A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.")
        protected Narrative text;
        @Child(name="mode", type={CodeType.class}, order=4, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="working | snapshot | changes", formalDefinition="How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
        protected Enumeration<SectionMode> mode;
        @Child(name="orderedBy", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Order of section entries", formalDefinition="Specifies the order applied to the items in the section entries.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-order")
        protected CodeableConcept orderedBy;
        @Child(name="entry", type={Reference.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A reference to data that supports this section", formalDefinition="A reference to the actual resource from which the narrative in the section is derived.")
        protected List<Reference> entry;
        protected List<Resource> entryTarget;
        @Child(name="emptyReason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the section is empty", formalDefinition="If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
        protected CodeableConcept emptyReason;
        @Child(name="section", type={SectionComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Section", formalDefinition="A nested sub-section within this section.")
        protected List<SectionComponent> section;
        private static final long serialVersionUID = -128426142L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public SectionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public SectionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SectionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Narrative getText() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new Narrative();
                }
            }
            return this.text;
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public SectionComponent setText(Narrative value) {
            this.text = value;
            return this;
        }

        public Enumeration<SectionMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<SectionMode>(new SectionModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public SectionComponent setModeElement(Enumeration<SectionMode> value) {
            this.mode = value;
            return this;
        }

        public SectionMode getMode() {
            return this.mode == null ? null : (SectionMode)((Object)this.mode.getValue());
        }

        public SectionComponent setMode(SectionMode value) {
            if (value == null) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new Enumeration<SectionMode>(new SectionModeEnumFactory());
                }
                this.mode.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getOrderedBy() {
            if (this.orderedBy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.orderedBy");
                }
                if (Configuration.doAutoCreate()) {
                    this.orderedBy = new CodeableConcept();
                }
            }
            return this.orderedBy;
        }

        public boolean hasOrderedBy() {
            return this.orderedBy != null && !this.orderedBy.isEmpty();
        }

        public SectionComponent setOrderedBy(CodeableConcept value) {
            this.orderedBy = value;
            return this;
        }

        public List<Reference> getEntry() {
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            return this.entry;
        }

        public SectionComponent setEntry(List<Reference> theEntry) {
            this.entry = theEntry;
            return this;
        }

        public boolean hasEntry() {
            if (this.entry == null) {
                return false;
            }
            for (Reference item : this.entry) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEntry() {
            Reference t = new Reference();
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            this.entry.add(t);
            return t;
        }

        public SectionComponent addEntry(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            this.entry.add(t);
            return this;
        }

        public Reference getEntryFirstRep() {
            if (this.getEntry().isEmpty()) {
                this.addEntry();
            }
            return this.getEntry().get(0);
        }

        @Deprecated
        public List<Resource> getEntryTarget() {
            if (this.entryTarget == null) {
                this.entryTarget = new ArrayList<Resource>();
            }
            return this.entryTarget;
        }

        public CodeableConcept getEmptyReason() {
            if (this.emptyReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.emptyReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.emptyReason = new CodeableConcept();
                }
            }
            return this.emptyReason;
        }

        public boolean hasEmptyReason() {
            return this.emptyReason != null && !this.emptyReason.isEmpty();
        }

        public SectionComponent setEmptyReason(CodeableConcept value) {
            this.emptyReason = value;
            return this;
        }

        public List<SectionComponent> getSection() {
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            return this.section;
        }

        public SectionComponent setSection(List<SectionComponent> theSection) {
            this.section = theSection;
            return this;
        }

        public boolean hasSection() {
            if (this.section == null) {
                return false;
            }
            for (SectionComponent item : this.section) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SectionComponent addSection() {
            SectionComponent t = new SectionComponent();
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return t;
        }

        public SectionComponent addSection(SectionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return this;
        }

        public SectionComponent getSectionFirstRep() {
            if (this.getSection().isEmpty()) {
                this.addSection();
            }
            return this.getSection().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Composition.SP_TITLE, "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, 1, this.title));
            children.add(new Property("code", "CodeableConcept", "A code identifying the kind of content contained within the section. This must be consistent with the section title.", 0, 1, this.code));
            children.add(new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.", 0, 1, this.text));
            children.add(new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode));
            children.add(new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, 1, this.orderedBy));
            children.add(new Property(Composition.SP_ENTRY, "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entry));
            children.add(new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, 1, this.emptyReason));
            children.add(new Property(Composition.SP_SECTION, "@Composition.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property(Composition.SP_TITLE, "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, 1, this.title);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code identifying the kind of content contained within the section. This must be consistent with the section title.", 0, 1, this.code);
                }
                case 3556653: {
                    return new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.", 0, 1, this.text);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode);
                }
                case -391079516: {
                    return new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, 1, this.orderedBy);
                }
                case 96667762: {
                    return new Property(Composition.SP_ENTRY, "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entry);
                }
                case 1140135409: {
                    return new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, 1, this.emptyReason);
                }
                case 1970241253: {
                    return new Property(Composition.SP_SECTION, "@Composition.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.mode;
                    }
                    return baseArray;
                }
                case -391079516: {
                    Base[] baseArray;
                    if (this.orderedBy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.orderedBy;
                    }
                    return baseArray;
                }
                case 96667762: {
                    return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
                }
                case 1140135409: {
                    Base[] baseArray;
                    if (this.emptyReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.emptyReason;
                    }
                    return baseArray;
                }
                case 1970241253: {
                    return this.section == null ? new Base[]{} : this.section.toArray(new Base[this.section.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = this.castToNarrative(value);
                    return value;
                }
                case 0x3339A3: {
                    value = new SectionModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case -391079516: {
                    this.orderedBy = this.castToCodeableConcept(value);
                    return value;
                }
                case 96667762: {
                    this.getEntry().add(this.castToReference(value));
                    return value;
                }
                case 1140135409: {
                    this.emptyReason = this.castToCodeableConcept(value);
                    return value;
                }
                case 1970241253: {
                    this.getSection().add((SectionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Composition.SP_TITLE)) {
                this.title = this.castToString(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = this.castToNarrative(value);
            } else if (name.equals("mode")) {
                value = new SectionModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else if (name.equals("orderedBy")) {
                this.orderedBy = this.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_ENTRY)) {
                this.getEntry().add(this.castToReference(value));
            } else if (name.equals("emptyReason")) {
                this.emptyReason = this.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_SECTION)) {
                this.getSection().add((SectionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 3556653: {
                    return this.getText();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case -391079516: {
                    return this.getOrderedBy();
                }
                case 96667762: {
                    return this.addEntry();
                }
                case 1140135409: {
                    return this.getEmptyReason();
                }
                case 1970241253: {
                    return this.addSection();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"Narrative"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case -391079516: {
                    return new String[]{"CodeableConcept"};
                }
                case 96667762: {
                    return new String[]{"Reference"};
                }
                case 1140135409: {
                    return new String[]{"CodeableConcept"};
                }
                case 1970241253: {
                    return new String[]{"@Composition.section"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Composition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.title");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("text")) {
                this.text = new Narrative();
                return this.text;
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.mode");
            }
            if (name.equals("orderedBy")) {
                this.orderedBy = new CodeableConcept();
                return this.orderedBy;
            }
            if (name.equals(Composition.SP_ENTRY)) {
                return this.addEntry();
            }
            if (name.equals("emptyReason")) {
                this.emptyReason = new CodeableConcept();
                return this.emptyReason;
            }
            if (name.equals(Composition.SP_SECTION)) {
                return this.addSection();
            }
            return super.addChild(name);
        }

        @Override
        public SectionComponent copy() {
            SectionComponent dst = new SectionComponent();
            this.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            CodeableConcept codeableConcept = dst.orderedBy = this.orderedBy == null ? null : this.orderedBy.copy();
            if (this.entry != null) {
                dst.entry = new ArrayList<Reference>();
                for (Reference reference : this.entry) {
                    dst.entry.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept2 = dst.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
            if (this.section != null) {
                dst.section = new ArrayList<SectionComponent>();
                for (SectionComponent sectionComponent : this.section) {
                    dst.section.add(sectionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other_;
            return SectionComponent.compareDeep(this.title, o.title, true) && SectionComponent.compareDeep(this.code, o.code, true) && SectionComponent.compareDeep(this.text, o.text, true) && SectionComponent.compareDeep(this.mode, o.mode, true) && SectionComponent.compareDeep(this.orderedBy, o.orderedBy, true) && SectionComponent.compareDeep(this.entry, o.entry, true) && SectionComponent.compareDeep(this.emptyReason, o.emptyReason, true) && SectionComponent.compareDeep(this.section, o.section, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other_;
            return SectionComponent.compareValues(this.title, o.title, true) && SectionComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.code, this.text, this.mode, this.orderedBy, this.entry, this.emptyReason, this.section});
        }

        @Override
        public String fhirType() {
            return "Composition.section";
        }
    }

    @Block
    public static class CompositionEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Code(s) that apply to the event being documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActCode")
        protected List<CodeableConcept> code;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The period covered by the documentation", formalDefinition="The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.")
        protected Period period;
        @Child(name="detail", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The event(s) being documented", formalDefinition="The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.")
        protected List<Reference> detail;
        protected List<Resource> detailTarget;
        private static final long serialVersionUID = -1581379774L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public CompositionEventComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public CompositionEventComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionEventComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CompositionEventComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public CompositionEventComponent setDetail(List<Reference> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public CompositionEventComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public Reference getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Deprecated
        public List<Resource> getDetailTarget() {
            if (this.detailTarget == null) {
                this.detailTarget = new ArrayList<Resource>();
            }
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property(Composition.SP_PERIOD, "Period", "The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.", 0, 1, this.period));
            children.add(new Property("detail", "Reference(Any)", "The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.code);
                }
                case -991726143: {
                    return new Property(Composition.SP_PERIOD, "Period", "The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.", 0, 1, this.period);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Any)", "The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals(Composition.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("detail")) {
                this.getDetail().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.addCode();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals(Composition.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public CompositionEventComponent copy() {
            CompositionEventComponent dst = new CompositionEventComponent();
            this.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference : this.detail) {
                    dst.detail.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionEventComponent)) {
                return false;
            }
            CompositionEventComponent o = (CompositionEventComponent)other_;
            return CompositionEventComponent.compareDeep(this.code, o.code, true) && CompositionEventComponent.compareDeep(this.period, o.period, true) && CompositionEventComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionEventComponent)) {
                return false;
            }
            CompositionEventComponent o = (CompositionEventComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.period, this.detail});
        }

        @Override
        public String fhirType() {
            return "Composition.event";
        }
    }

    @Block
    public static class CompositionRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="replaces | transforms | signs | appends", formalDefinition="The type of relationship that this composition has with anther composition or document.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-relationship-type")
        protected Enumeration<DocumentRelationshipType> code;
        @Child(name="target", type={Identifier.class, Composition.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Target of the relationship", formalDefinition="The target composition/document of this relationship.")
        protected Type target;
        private static final long serialVersionUID = 1536930280L;

        public CompositionRelatesToComponent() {
        }

        public CompositionRelatesToComponent(Enumeration<DocumentRelationshipType> code, Type target) {
            this.code = code;
            this.target = target;
        }

        public Enumeration<DocumentRelationshipType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionRelatesToComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<DocumentRelationshipType>(new DocumentRelationshipTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CompositionRelatesToComponent setCodeElement(Enumeration<DocumentRelationshipType> value) {
            this.code = value;
            return this;
        }

        public DocumentRelationshipType getCode() {
            return this.code == null ? null : (DocumentRelationshipType)((Object)this.code.getValue());
        }

        public CompositionRelatesToComponent setCode(DocumentRelationshipType value) {
            if (this.code == null) {
                this.code = new Enumeration<DocumentRelationshipType>(new DocumentRelationshipTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Type getTarget() {
            return this.target;
        }

        public Identifier getTargetIdentifier() throws FHIRException {
            if (this.target == null) {
                return null;
            }
            if (!(this.target instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Identifier)this.target;
        }

        public boolean hasTargetIdentifier() {
            return this != null && this.target instanceof Identifier;
        }

        public Reference getTargetReference() throws FHIRException {
            if (this.target == null) {
                return null;
            }
            if (!(this.target instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Reference)this.target;
        }

        public boolean hasTargetReference() {
            return this != null && this.target instanceof Reference;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public CompositionRelatesToComponent setTarget(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Identifier) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Composition.relatesTo.target[x]: " + value.fhirType());
            }
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "The type of relationship that this composition has with anther composition or document.", 0, 1, this.code));
            children.add(new Property("target[x]", "Identifier|Reference(Composition)", "The target composition/document of this relationship.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "The type of relationship that this composition has with anther composition or document.", 0, 1, this.code);
                }
                case -815579825: {
                    return new Property("target[x]", "Identifier|Reference(Composition)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
                case -880905839: {
                    return new Property("target[x]", "Identifier|Reference(Composition)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
                case 1690892570: {
                    return new Property("target[x]", "Identifier|Reference(Composition)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
                case 1259806906: {
                    return new Property("target[x]", "Identifier|Reference(Composition)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new DocumentRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case -880905839: {
                    this.target = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new DocumentRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("target[x]")) {
                this.target = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -815579825: {
                    return this.getTarget();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -880905839: {
                    return new String[]{"Identifier", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.code");
            }
            if (name.equals("targetIdentifier")) {
                this.target = new Identifier();
                return this.target;
            }
            if (name.equals("targetReference")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public CompositionRelatesToComponent copy() {
            CompositionRelatesToComponent dst = new CompositionRelatesToComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.target = this.target == null ? null : this.target.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionRelatesToComponent)) {
                return false;
            }
            CompositionRelatesToComponent o = (CompositionRelatesToComponent)other_;
            return CompositionRelatesToComponent.compareDeep(this.code, o.code, true) && CompositionRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionRelatesToComponent)) {
                return false;
            }
            CompositionRelatesToComponent o = (CompositionRelatesToComponent)other_;
            return CompositionRelatesToComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.target});
        }

        @Override
        public String fhirType() {
            return "Composition.relatesTo";
        }
    }

    @Block
    public static class CompositionAttesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="personal | professional | legal | official", formalDefinition="The type of attestation the authenticator offers.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-attestation-mode")
        protected List<Enumeration<CompositionAttestationMode>> mode;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the composition was attested", formalDefinition="When the composition was attested by the party.")
        protected DateTimeType time;
        @Child(name="party", type={Patient.class, Practitioner.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who attested the composition", formalDefinition="Who attested the composition in the specified way.")
        protected Reference party;
        protected Resource partyTarget;
        private static final long serialVersionUID = -436604745L;

        public List<Enumeration<CompositionAttestationMode>> getMode() {
            if (this.mode == null) {
                this.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            }
            return this.mode;
        }

        public CompositionAttesterComponent setMode(List<Enumeration<CompositionAttestationMode>> theMode) {
            this.mode = theMode;
            return this;
        }

        public boolean hasMode() {
            if (this.mode == null) {
                return false;
            }
            for (Enumeration<CompositionAttestationMode> item : this.mode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<CompositionAttestationMode> addModeElement() {
            Enumeration<CompositionAttestationMode> t = new Enumeration<CompositionAttestationMode>(new CompositionAttestationModeEnumFactory());
            if (this.mode == null) {
                this.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            }
            this.mode.add(t);
            return t;
        }

        public CompositionAttesterComponent addMode(CompositionAttestationMode value) {
            Enumeration<CompositionAttestationMode> t = new Enumeration<CompositionAttestationMode>(new CompositionAttestationModeEnumFactory());
            t.setValue((Object)value);
            if (this.mode == null) {
                this.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            }
            this.mode.add(t);
            return this;
        }

        public boolean hasMode(CompositionAttestationMode value) {
            if (this.mode == null) {
                return false;
            }
            for (Enumeration<CompositionAttestationMode> v : this.mode) {
                if (!((CompositionAttestationMode)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public CompositionAttesterComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public CompositionAttesterComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public CompositionAttesterComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public CompositionAttesterComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "The type of attestation the authenticator offers.", 0, Integer.MAX_VALUE, this.mode));
            children.add(new Property("time", "dateTime", "When the composition was attested by the party.", 0, 1, this.time));
            children.add(new Property("party", "Reference(Patient|Practitioner|Organization)", "Who attested the composition in the specified way.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "The type of attestation the authenticator offers.", 0, Integer.MAX_VALUE, this.mode);
                }
                case 3560141: {
                    return new Property("time", "dateTime", "When the composition was attested by the party.", 0, 1, this.time);
                }
                case 106437350: {
                    return new Property("party", "Reference(Patient|Practitioner|Organization)", "Who attested the composition in the specified way.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.mode == null ? new Base[]{} : this.mode.toArray(new Base[this.mode.size()]);
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.time;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new CompositionAttestationModeEnumFactory().fromType(this.castToCode(value));
                    this.getMode().add(value);
                    return value;
                }
                case 3560141: {
                    this.time = this.castToDateTime(value);
                    return value;
                }
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new CompositionAttestationModeEnumFactory().fromType(this.castToCode(value));
                this.getMode().add(value);
            } else if (name.equals("time")) {
                this.time = this.castToDateTime(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.addModeElement();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 3560141: {
                    return new String[]{"dateTime"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.mode");
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.time");
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public CompositionAttesterComponent copy() {
            CompositionAttesterComponent dst = new CompositionAttesterComponent();
            this.copyValues(dst);
            if (this.mode != null) {
                dst.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
                for (Enumeration<CompositionAttestationMode> i : this.mode) {
                    dst.mode.add((Enumeration<CompositionAttestationMode>)i.copy());
                }
            }
            dst.time = this.time == null ? null : this.time.copy();
            dst.party = this.party == null ? null : this.party.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionAttesterComponent)) {
                return false;
            }
            CompositionAttesterComponent o = (CompositionAttesterComponent)other_;
            return CompositionAttesterComponent.compareDeep(this.mode, o.mode, true) && CompositionAttesterComponent.compareDeep(this.time, o.time, true) && CompositionAttesterComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionAttesterComponent)) {
                return false;
            }
            CompositionAttesterComponent o = (CompositionAttesterComponent)other_;
            return CompositionAttesterComponent.compareValues(this.mode, o.mode, true) && CompositionAttesterComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mode, this.time, this.party});
        }

        @Override
        public String fhirType() {
            return "Composition.attester";
        }
    }

    public static class SectionModeEnumFactory
    implements EnumFactory<SectionMode> {
        @Override
        public SectionMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("working".equals(codeString)) {
                return SectionMode.WORKING;
            }
            if ("snapshot".equals(codeString)) {
                return SectionMode.SNAPSHOT;
            }
            if ("changes".equals(codeString)) {
                return SectionMode.CHANGES;
            }
            throw new IllegalArgumentException("Unknown SectionMode code '" + codeString + "'");
        }

        public Enumeration<SectionMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SectionMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("working".equals(codeString)) {
                return new Enumeration<SectionMode>(this, SectionMode.WORKING);
            }
            if ("snapshot".equals(codeString)) {
                return new Enumeration<SectionMode>(this, SectionMode.SNAPSHOT);
            }
            if ("changes".equals(codeString)) {
                return new Enumeration<SectionMode>(this, SectionMode.CHANGES);
            }
            throw new FHIRException("Unknown SectionMode code '" + codeString + "'");
        }

        @Override
        public String toCode(SectionMode code) {
            if (code == SectionMode.WORKING) {
                return "working";
            }
            if (code == SectionMode.SNAPSHOT) {
                return "snapshot";
            }
            if (code == SectionMode.CHANGES) {
                return "changes";
            }
            return "?";
        }

        @Override
        public String toSystem(SectionMode code) {
            return code.getSystem();
        }
    }

    public static enum SectionMode {
        WORKING,
        SNAPSHOT,
        CHANGES,
        NULL;


        public static SectionMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("working".equals(codeString)) {
                return WORKING;
            }
            if ("snapshot".equals(codeString)) {
                return SNAPSHOT;
            }
            if ("changes".equals(codeString)) {
                return CHANGES;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SectionMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case WORKING: {
                    return "working";
                }
                case SNAPSHOT: {
                    return "snapshot";
                }
                case CHANGES: {
                    return "changes";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case WORKING: {
                    return "http://hl7.org/fhir/list-mode";
                }
                case SNAPSHOT: {
                    return "http://hl7.org/fhir/list-mode";
                }
                case CHANGES: {
                    return "http://hl7.org/fhir/list-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case WORKING: {
                    return "This list is the master list, maintained in an ongoing fashion with regular updates as the real world list it is tracking changes";
                }
                case SNAPSHOT: {
                    return "This list was prepared as a snapshot. It should not be assumed to be current";
                }
                case CHANGES: {
                    return "A list that indicates where changes have been made or recommended";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case WORKING: {
                    return "Working List";
                }
                case SNAPSHOT: {
                    return "Snapshot List";
                }
                case CHANGES: {
                    return "Change List";
                }
            }
            return "?";
        }
    }

    public static class DocumentRelationshipTypeEnumFactory
    implements EnumFactory<DocumentRelationshipType> {
        @Override
        public DocumentRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return DocumentRelationshipType.REPLACES;
            }
            if ("transforms".equals(codeString)) {
                return DocumentRelationshipType.TRANSFORMS;
            }
            if ("signs".equals(codeString)) {
                return DocumentRelationshipType.SIGNS;
            }
            if ("appends".equals(codeString)) {
                return DocumentRelationshipType.APPENDS;
            }
            throw new IllegalArgumentException("Unknown DocumentRelationshipType code '" + codeString + "'");
        }

        public Enumeration<DocumentRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DocumentRelationshipType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.REPLACES);
            }
            if ("transforms".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.TRANSFORMS);
            }
            if ("signs".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.SIGNS);
            }
            if ("appends".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.APPENDS);
            }
            throw new FHIRException("Unknown DocumentRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentRelationshipType code) {
            if (code == DocumentRelationshipType.REPLACES) {
                return "replaces";
            }
            if (code == DocumentRelationshipType.TRANSFORMS) {
                return "transforms";
            }
            if (code == DocumentRelationshipType.SIGNS) {
                return "signs";
            }
            if (code == DocumentRelationshipType.APPENDS) {
                return "appends";
            }
            return "?";
        }

        @Override
        public String toSystem(DocumentRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum DocumentRelationshipType {
        REPLACES,
        TRANSFORMS,
        SIGNS,
        APPENDS,
        NULL;


        public static DocumentRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("transforms".equals(codeString)) {
                return TRANSFORMS;
            }
            if ("signs".equals(codeString)) {
                return SIGNS;
            }
            if ("appends".equals(codeString)) {
                return APPENDS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DocumentRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REPLACES: {
                    return "replaces";
                }
                case TRANSFORMS: {
                    return "transforms";
                }
                case SIGNS: {
                    return "signs";
                }
                case APPENDS: {
                    return "appends";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REPLACES: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
                case TRANSFORMS: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
                case SIGNS: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
                case APPENDS: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REPLACES: {
                    return "This document logically replaces or supersedes the target document.";
                }
                case TRANSFORMS: {
                    return "This document was generated by transforming the target document (e.g. format or language conversion).";
                }
                case SIGNS: {
                    return "This document is a signature of the target document.";
                }
                case APPENDS: {
                    return "This document adds additional information to the target document.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REPLACES: {
                    return "Replaces";
                }
                case TRANSFORMS: {
                    return "Transforms";
                }
                case SIGNS: {
                    return "Signs";
                }
                case APPENDS: {
                    return "Appends";
                }
            }
            return "?";
        }
    }

    public static class CompositionAttestationModeEnumFactory
    implements EnumFactory<CompositionAttestationMode> {
        @Override
        public CompositionAttestationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return CompositionAttestationMode.PERSONAL;
            }
            if ("professional".equals(codeString)) {
                return CompositionAttestationMode.PROFESSIONAL;
            }
            if ("legal".equals(codeString)) {
                return CompositionAttestationMode.LEGAL;
            }
            if ("official".equals(codeString)) {
                return CompositionAttestationMode.OFFICIAL;
            }
            throw new IllegalArgumentException("Unknown CompositionAttestationMode code '" + codeString + "'");
        }

        public Enumeration<CompositionAttestationMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CompositionAttestationMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.PERSONAL);
            }
            if ("professional".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.PROFESSIONAL);
            }
            if ("legal".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.LEGAL);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.OFFICIAL);
            }
            throw new FHIRException("Unknown CompositionAttestationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(CompositionAttestationMode code) {
            if (code == CompositionAttestationMode.PERSONAL) {
                return "personal";
            }
            if (code == CompositionAttestationMode.PROFESSIONAL) {
                return "professional";
            }
            if (code == CompositionAttestationMode.LEGAL) {
                return "legal";
            }
            if (code == CompositionAttestationMode.OFFICIAL) {
                return "official";
            }
            return "?";
        }

        @Override
        public String toSystem(CompositionAttestationMode code) {
            return code.getSystem();
        }
    }

    public static enum CompositionAttestationMode {
        PERSONAL,
        PROFESSIONAL,
        LEGAL,
        OFFICIAL,
        NULL;


        public static CompositionAttestationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return PERSONAL;
            }
            if ("professional".equals(codeString)) {
                return PROFESSIONAL;
            }
            if ("legal".equals(codeString)) {
                return LEGAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CompositionAttestationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSONAL: {
                    return "personal";
                }
                case PROFESSIONAL: {
                    return "professional";
                }
                case LEGAL: {
                    return "legal";
                }
                case OFFICIAL: {
                    return "official";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSONAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
                case PROFESSIONAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
                case LEGAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSONAL: {
                    return "The person authenticated the content in their personal capacity.";
                }
                case PROFESSIONAL: {
                    return "The person authenticated the content in their professional capacity.";
                }
                case LEGAL: {
                    return "The person authenticated the content and accepted legal responsibility for its content.";
                }
                case OFFICIAL: {
                    return "The organization authenticated the content as consistent with their policies and procedures.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSONAL: {
                    return "Personal";
                }
                case PROFESSIONAL: {
                    return "Professional";
                }
                case LEGAL: {
                    return "Legal";
                }
                case OFFICIAL: {
                    return "Official";
                }
            }
            return "?";
        }
    }

    public static class DocumentConfidentialityEnumFactory
    implements EnumFactory<DocumentConfidentiality> {
        @Override
        public DocumentConfidentiality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("U".equals(codeString)) {
                return DocumentConfidentiality.U;
            }
            if ("L".equals(codeString)) {
                return DocumentConfidentiality.L;
            }
            if ("M".equals(codeString)) {
                return DocumentConfidentiality.M;
            }
            if ("N".equals(codeString)) {
                return DocumentConfidentiality.N;
            }
            if ("R".equals(codeString)) {
                return DocumentConfidentiality.R;
            }
            if ("V".equals(codeString)) {
                return DocumentConfidentiality.V;
            }
            throw new IllegalArgumentException("Unknown DocumentConfidentiality code '" + codeString + "'");
        }

        public Enumeration<DocumentConfidentiality> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DocumentConfidentiality>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("U".equals(codeString)) {
                return new Enumeration<DocumentConfidentiality>(this, DocumentConfidentiality.U);
            }
            if ("L".equals(codeString)) {
                return new Enumeration<DocumentConfidentiality>(this, DocumentConfidentiality.L);
            }
            if ("M".equals(codeString)) {
                return new Enumeration<DocumentConfidentiality>(this, DocumentConfidentiality.M);
            }
            if ("N".equals(codeString)) {
                return new Enumeration<DocumentConfidentiality>(this, DocumentConfidentiality.N);
            }
            if ("R".equals(codeString)) {
                return new Enumeration<DocumentConfidentiality>(this, DocumentConfidentiality.R);
            }
            if ("V".equals(codeString)) {
                return new Enumeration<DocumentConfidentiality>(this, DocumentConfidentiality.V);
            }
            throw new FHIRException("Unknown DocumentConfidentiality code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentConfidentiality code) {
            if (code == DocumentConfidentiality.U) {
                return "U";
            }
            if (code == DocumentConfidentiality.L) {
                return "L";
            }
            if (code == DocumentConfidentiality.M) {
                return "M";
            }
            if (code == DocumentConfidentiality.N) {
                return "N";
            }
            if (code == DocumentConfidentiality.R) {
                return "R";
            }
            if (code == DocumentConfidentiality.V) {
                return "V";
            }
            return "?";
        }

        @Override
        public String toSystem(DocumentConfidentiality code) {
            return code.getSystem();
        }
    }

    public static enum DocumentConfidentiality {
        U,
        L,
        M,
        N,
        R,
        V,
        NULL;


        public static DocumentConfidentiality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("U".equals(codeString)) {
                return U;
            }
            if ("L".equals(codeString)) {
                return L;
            }
            if ("M".equals(codeString)) {
                return M;
            }
            if ("N".equals(codeString)) {
                return N;
            }
            if ("R".equals(codeString)) {
                return R;
            }
            if ("V".equals(codeString)) {
                return V;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DocumentConfidentiality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case U: {
                    return "U";
                }
                case L: {
                    return "L";
                }
                case M: {
                    return "M";
                }
                case N: {
                    return "N";
                }
                case R: {
                    return "R";
                }
                case V: {
                    return "V";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case U: {
                    return "http://hl7.org/fhir/v3/Confidentiality";
                }
                case L: {
                    return "http://hl7.org/fhir/v3/Confidentiality";
                }
                case M: {
                    return "http://hl7.org/fhir/v3/Confidentiality";
                }
                case N: {
                    return "http://hl7.org/fhir/v3/Confidentiality";
                }
                case R: {
                    return "http://hl7.org/fhir/v3/Confidentiality";
                }
                case V: {
                    return "http://hl7.org/fhir/v3/Confidentiality";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case U: {
                    return "";
                }
                case L: {
                    return "";
                }
                case M: {
                    return "";
                }
                case N: {
                    return "";
                }
                case R: {
                    return "";
                }
                case V: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case U: {
                    return "U";
                }
                case L: {
                    return "L";
                }
                case M: {
                    return "M";
                }
                case N: {
                    return "N";
                }
                case R: {
                    return "R";
                }
                case V: {
                    return "V";
                }
            }
            return "?";
        }
    }

    public static class CompositionStatusEnumFactory
    implements EnumFactory<CompositionStatus> {
        @Override
        public CompositionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return CompositionStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return CompositionStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return CompositionStatus.AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return CompositionStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown CompositionStatus code '" + codeString + "'");
        }

        public Enumeration<CompositionStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CompositionStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.AMENDED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown CompositionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CompositionStatus code) {
            if (code == CompositionStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == CompositionStatus.FINAL) {
                return "final";
            }
            if (code == CompositionStatus.AMENDED) {
                return "amended";
            }
            if (code == CompositionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(CompositionStatus code) {
            return code.getSystem();
        }
    }

    public static enum CompositionStatus {
        PRELIMINARY,
        FINAL,
        AMENDED,
        ENTEREDINERROR,
        NULL;


        public static CompositionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CompositionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/composition-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRELIMINARY: {
                    return "This is a preliminary composition or document (also known as initial or interim). The content may be incomplete or unverified.";
                }
                case FINAL: {
                    return "This version of the composition is complete and verified by an appropriate person and no further work is planned. Any subsequent updates would be on a new version of the composition.";
                }
                case AMENDED: {
                    return "The composition content or the referenced resources have been modified (edited or added to) subsequent to being released as \"final\" and the composition is complete and verified by an authorized person.";
                }
                case ENTEREDINERROR: {
                    return "The composition or document was originally created/issued in error, and this is an amendment that marks that the entire series should not be considered as valid.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

