/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Organization", profile="http://hl7.org/fhir/StructureDefinition/Organization")
public class Organization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies this organization  across multiple systems", formalDefinition="Identifier for the organization that is used to identify the organization across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether the organization's record is still in active use", formalDefinition="Whether the organization's record is still in active use.")
    protected BooleanType active;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of organization", formalDefinition="The kind(s) of organization that this is.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/organization-type")
    protected List<CodeableConcept> type;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name used for the organization", formalDefinition="A name associated with the organization.")
    protected StringType name;
    @Child(name="alias", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of\u00a0alternate names that the organization is known as, or was known as in the past", formalDefinition="A list of\u00a0alternate names that the organization is known as, or was known as in the past.")
    protected List<StringType> alias;
    @Child(name="telecom", type={ContactPoint.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A contact detail for the organization", formalDefinition="A contact detail for the organization.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An address for the organization", formalDefinition="An address for the organization.")
    protected List<Address> address;
    @Child(name="partOf", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The organization of which this organization forms a part", formalDefinition="The organization of which this organization forms a part.")
    protected Reference partOf;
    protected Organization partOfTarget;
    @Child(name="contact", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact for the organization for a certain purpose", formalDefinition="Contact for the organization for a certain purpose.")
    protected List<OrganizationContactComponent> contact;
    @Child(name="endpoint", type={Endpoint.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for the organization", formalDefinition="Technical endpoints providing access to services operated for the organization.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    private static final long serialVersionUID = -2113244111L;
    @SearchParamDefinition(name="identifier", path="Organization.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="partof", path="Organization.partOf", description="An organization of which this organization forms a part", type="reference", target={Organization.class})
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("Organization:partof").toLocked();
    @SearchParamDefinition(name="address", path="Organization.address", description="A (part of the) address of the organization", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-state", path="Organization.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="active", path="Organization.active", description="A server defined search that may match any of the string fields in the Address, including line, city, state, country, postalCode, and/or text", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="type", path="Organization.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="address-postalcode", path="Organization.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Organization.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="endpoint", path="Organization.endpoint", description="Technical endpoints providing access to services operated for the organization", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("Organization:endpoint").toLocked();
    @SearchParamDefinition(name="phonetic", path="Organization.name", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="name", path="Organization.name | Organization.alias", description="A portion of the organization's name or alias", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address-use", path="Organization.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="address-city", path="Organization.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Organization setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Organization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Organization setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Organization setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Organization setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Organization addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Organization setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Organization setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public Organization setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public Organization addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Organization setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Organization addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public Organization setAddress(List<Address> theAddress) {
        this.address = theAddress;
        return this;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Organization addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Address getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Organization setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Organization getPartOfTarget() {
        if (this.partOfTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOfTarget = new Organization();
            }
        }
        return this.partOfTarget;
    }

    public Organization setPartOfTarget(Organization value) {
        this.partOfTarget = value;
        return this;
    }

    public List<OrganizationContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContactComponent>();
        }
        return this.contact;
    }

    public Organization setContact(List<OrganizationContactComponent> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (OrganizationContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrganizationContactComponent addContact() {
        OrganizationContactComponent t = new OrganizationContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public Organization addContact(OrganizationContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public OrganizationContactComponent getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public Organization setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public Organization addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the organization across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether the organization's record is still in active use.", 0, 1, this.active));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind(s) of organization that this is.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_NAME, "string", "A name associated with the organization.", 0, 1, this.name));
        children.add(new Property("alias", "string", "A list of\u00a0alternate names that the organization is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("telecom", "ContactPoint", "A contact detail for the organization.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property(SP_ADDRESS, "Address", "An address for the organization.", 0, Integer.MAX_VALUE, this.address));
        children.add(new Property("partOf", "Reference(Organization)", "The organization of which this organization forms a part.", 0, 1, this.partOf));
        children.add(new Property("contact", "", "Contact for the organization for a certain purpose.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the organization.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the organization across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether the organization's record is still in active use.", 0, 1, this.active);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind(s) of organization that this is.", 0, Integer.MAX_VALUE, this.type);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A name associated with the organization.", 0, 1, this.name);
            }
            case 92902992: {
                return new Property("alias", "string", "A list of\u00a0alternate names that the organization is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias);
            }
            case -1429363305: {
                return new Property("telecom", "ContactPoint", "A contact detail for the organization.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case -1147692044: {
                return new Property(SP_ADDRESS, "Address", "An address for the organization.", 0, Integer.MAX_VALUE, this.address);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Organization)", "The organization of which this organization forms a part.", 0, 1, this.partOf);
            }
            case 951526432: {
                return new Property("contact", "", "Contact for the organization for a certain purpose.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the organization.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1147692044: {
                return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.partOf;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(this.castToString(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
            case -1147692044: {
                this.getAddress().add(this.castToAddress(value));
                return value;
            }
            case -995410646: {
                this.partOf = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add((OrganizationContactComponent)value);
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add((OrganizationContactComponent)value);
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 3575610: {
                return this.addType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1147692044: {
                return this.addAddress();
            }
            case -995410646: {
                return this.getPartOf();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1147692044: {
                return new String[]{"Address"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[0];
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.active");
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.name");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.alias");
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Organization";
    }

    @Override
    public Organization copy() {
        Organization dst = new Organization();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType2 : this.alias) {
                dst.alias.add(stringType2.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        Reference reference = dst.partOf = this.partOf == null ? null : this.partOf.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<OrganizationContactComponent>();
            for (OrganizationContactComponent organizationContactComponent : this.contact) {
                dst.contact.add(organizationContactComponent.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference2 : this.endpoint) {
                dst.endpoint.add(reference2.copy());
            }
        }
        return dst;
    }

    protected Organization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)other_;
        return Organization.compareDeep(this.identifier, o.identifier, true) && Organization.compareDeep(this.active, o.active, true) && Organization.compareDeep(this.type, o.type, true) && Organization.compareDeep(this.name, o.name, true) && Organization.compareDeep(this.alias, o.alias, true) && Organization.compareDeep(this.telecom, o.telecom, true) && Organization.compareDeep(this.address, o.address, true) && Organization.compareDeep(this.partOf, o.partOf, true) && Organization.compareDeep(this.contact, o.contact, true) && Organization.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)other_;
        return Organization.compareValues(this.active, o.active, true) && Organization.compareValues(this.name, o.name, true) && Organization.compareValues(this.alias, o.alias, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.type, this.name, this.alias, this.telecom, this.address, this.partOf, this.contact, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Organization;
    }

    @Block
    public static class OrganizationContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="purpose", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of contact", formalDefinition="Indicates a purpose for which the contact can be reached.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contactentity-type")
        protected CodeableConcept purpose;
        @Child(name="name", type={HumanName.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the contact", formalDefinition="A name associated with the contact.")
        protected HumanName name;
        @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details (telephone, email, etc.)  for a contact", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
        protected List<ContactPoint> telecom;
        @Child(name="address", type={Address.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Visiting or postal addresses for the contact", formalDefinition="Visiting or postal addresses for the contact.")
        protected Address address;
        private static final long serialVersionUID = 1831121305L;

        public CodeableConcept getPurpose() {
            if (this.purpose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationContactComponent.purpose");
                }
                if (Configuration.doAutoCreate()) {
                    this.purpose = new CodeableConcept();
                }
            }
            return this.purpose;
        }

        public boolean hasPurpose() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public OrganizationContactComponent setPurpose(CodeableConcept value) {
            this.purpose = value;
            return this;
        }

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public OrganizationContactComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public OrganizationContactComponent setTelecom(List<ContactPoint> theTelecom) {
            this.telecom = theTelecom;
            return this;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public OrganizationContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public ContactPoint getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public Address getAddress() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationContactComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new Address();
                }
            }
            return this.address;
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public OrganizationContactComponent setAddress(Address value) {
            this.address = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, 1, this.purpose));
            children.add(new Property(Organization.SP_NAME, "HumanName", "A name associated with the contact.", 0, 1, this.name));
            children.add(new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
            children.add(new Property(Organization.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, 1, this.address));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -220463842: {
                    return new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, 1, this.purpose);
                }
                case 3373707: {
                    return new Property(Organization.SP_NAME, "HumanName", "A name associated with the contact.", 0, 1, this.name);
                }
                case -1429363305: {
                    return new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom);
                }
                case -1147692044: {
                    return new Property(Organization.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, 1, this.address);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    Base[] baseArray;
                    if (this.purpose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.purpose;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case -1147692044: {
                    Base[] baseArray;
                    if (this.address == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.address;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    this.purpose = this.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToHumanName(value);
                    return value;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    return value;
                }
                case -1147692044: {
                    this.address = this.castToAddress(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = this.castToCodeableConcept(value);
            } else if (name.equals(Organization.SP_NAME)) {
                this.name = this.castToHumanName(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals(Organization.SP_ADDRESS)) {
                this.address = this.castToAddress(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return this.getPurpose();
                }
                case 3373707: {
                    return this.getName();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case -1147692044: {
                    return this.getAddress();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"HumanName"};
                }
                case -1429363305: {
                    return new String[]{"ContactPoint"};
                }
                case -1147692044: {
                    return new String[]{"Address"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = new CodeableConcept();
                return this.purpose;
            }
            if (name.equals(Organization.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            if (name.equals(Organization.SP_ADDRESS)) {
                this.address = new Address();
                return this.address;
            }
            return super.addChild(name);
        }

        @Override
        public OrganizationContactComponent copy() {
            OrganizationContactComponent dst = new OrganizationContactComponent();
            this.copyValues(dst);
            dst.purpose = this.purpose == null ? null : this.purpose.copy();
            HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            dst.address = this.address == null ? null : this.address.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationContactComponent)) {
                return false;
            }
            OrganizationContactComponent o = (OrganizationContactComponent)other_;
            return OrganizationContactComponent.compareDeep(this.purpose, o.purpose, true) && OrganizationContactComponent.compareDeep(this.name, o.name, true) && OrganizationContactComponent.compareDeep(this.telecom, o.telecom, true) && OrganizationContactComponent.compareDeep(this.address, o.address, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationContactComponent)) {
                return false;
            }
            OrganizationContactComponent o = (OrganizationContactComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.purpose, this.name, this.telecom, this.address});
        }

        @Override
        public String fhirType() {
            return "Organization.contact";
        }
    }
}

