/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Procedure", profile="http://hl7.org/fhir/StructureDefinition/Procedure")
public class Procedure
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Identifiers for this procedure", formalDefinition="This records identifiers associated with this procedure that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="definition", type={PlanDefinition.class, ActivityDefinition.class, HealthcareService.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="A protocol, guideline, orderset or other definition that was adhered to in whole or in part by this procedure.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={CarePlan.class, ProcedureRequest.class, ReferralRequest.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A request for this procedure", formalDefinition="A reference to a resource that contains details of the request for this procedure.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="partOf", type={Procedure.class, Observation.class, MedicationAdministration.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular procedure is a component or step.")
    protected List<Reference> partOf;
    protected List<Resource> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | suspended | aborted | completed | entered-in-error | unknown", formalDefinition="A code specifying the state of the procedure. Generally this will be in-progress or completed state.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<ProcedureStatus> status;
    @Child(name="notDone", type={BooleanType.class}, order=5, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if procedure was not performed as scheduled", formalDefinition="Set this to true if the record is saying that the procedure was NOT performed.")
    protected BooleanType notDone;
    @Child(name="notDoneReason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason procedure was not performed", formalDefinition="A code indicating why the procedure was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-not-performed-reason")
    protected CodeableConcept notDoneReason;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the procedure", formalDefinition="A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-category")
    protected CodeableConcept category;
    @Child(name="code", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the procedure", formalDefinition="The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the procedure was performed on", formalDefinition="The person, animal or group on which the procedure was performed.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter or episode associated with the procedure", formalDefinition="The encounter during which the procedure was performed.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="performed", type={DateTimeType.class, Period.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Period the procedure was performed", formalDefinition="The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.")
    protected Type performed;
    @Child(name="performer", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The people who performed the procedure", formalDefinition="Limited to 'real' people rather than equipment.")
    protected List<ProcedurePerformerComponent> performer;
    @Child(name="location", type={Location.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the procedure happened", formalDefinition="The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Coded reason procedure performed", formalDefinition="The coded reason why the procedure was performed. This may be coded entity of some type, or may simply be present as text.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition that is the reason the procedure performed", formalDefinition="The condition that is the reason why the procedure was performed.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="bodySite", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Target body sites", formalDefinition="Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="outcome", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The result of procedure", formalDefinition="The outcome of the procedure - did it resolve reasons for the procedure being performed?")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-outcome")
    protected CodeableConcept outcome;
    @Child(name="report", type={DiagnosticReport.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Any report resulting from the procedure", formalDefinition="This could be a histology result, pathology report, surgical report, etc..")
    protected List<Reference> report;
    protected List<DiagnosticReport> reportTarget;
    @Child(name="complication", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Complication following the procedure", formalDefinition="Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableConcept> complication;
    @Child(name="complicationDetail", type={Condition.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A condition that\u00a0is a result of the procedure", formalDefinition="Any complications that occurred during the procedure, or in the immediate post-performance period.")
    protected List<Reference> complicationDetail;
    protected List<Condition> complicationDetailTarget;
    @Child(name="followUp", type={CodeableConcept.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instructions for follow up", formalDefinition="If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or could potentially be more complex in which case the CarePlan resource can be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-followup")
    protected List<CodeableConcept> followUp;
    @Child(name="note", type={Annotation.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about the procedure", formalDefinition="Any other notes about the procedure.  E.g. the operative notes.")
    protected List<Annotation> note;
    @Child(name="focalDevice", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device changed in procedure", formalDefinition="A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.")
    protected List<ProcedureFocalDeviceComponent> focalDevice;
    @Child(name="usedReference", type={Device.class, Medication.class, Substance.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Items used during procedure", formalDefinition="Identifies medications, devices and any other substance used as part of the procedure.")
    protected List<Reference> usedReference;
    protected List<Resource> usedReferenceTarget;
    @Child(name="usedCode", type={CodeableConcept.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Coded items used during the procedure", formalDefinition="Identifies coded items that were used as part of the procedure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    protected List<CodeableConcept> usedCode;
    private static final long serialVersionUID = 7729906L;
    @SearchParamDefinition(name="date", path="Procedure.performed", description="Date/Period the procedure was performed", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Procedure.identifier", description="A unique identifier for a procedure", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="Procedure.code", description="A code to identify a  procedure", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="performer", path="Procedure.performer.actor", description="The reference to the practitioner", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Procedure:performer").toLocked();
    @SearchParamDefinition(name="subject", path="Procedure.subject", description="Search by subject", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Procedure:subject").toLocked();
    @SearchParamDefinition(name="part-of", path="Procedure.partOf", description="Part of referenced event", type="reference", target={MedicationAdministration.class, Observation.class, Procedure.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Procedure:part-of").toLocked();
    @SearchParamDefinition(name="encounter", path="Procedure.context", description="Search by encounter", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Procedure:encounter").toLocked();
    @SearchParamDefinition(name="based-on", path="Procedure.basedOn", description="A request for this procedure", type="reference", target={CarePlan.class, ProcedureRequest.class, ReferralRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Procedure:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="Procedure.subject", description="Search by subject - a patient", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Procedure:patient").toLocked();
    @SearchParamDefinition(name="context", path="Procedure.context", description="Encounter or episode associated with the procedure", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("Procedure:context").toLocked();
    @SearchParamDefinition(name="location", path="Procedure.location", description="Where the procedure happened", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Procedure:location").toLocked();
    @SearchParamDefinition(name="definition", path="Procedure.definition", description="Instantiates protocol or definition", type="reference", target={ActivityDefinition.class, HealthcareService.class, PlanDefinition.class})
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("Procedure:definition").toLocked();
    @SearchParamDefinition(name="category", path="Procedure.category", description="Classification of the procedure", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="Procedure.status", description="preparation | in-progress | suspended | aborted | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Procedure() {
    }

    public Procedure(Enumeration<ProcedureStatus> status, Reference subject) {
        this.status = status;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Procedure setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Procedure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public Procedure setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public Procedure addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Procedure setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Procedure addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Procedure setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Procedure addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Resource> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Resource>();
        }
        return this.partOfTarget;
    }

    public Enumeration<ProcedureStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ProcedureStatus>(new ProcedureStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Procedure setStatusElement(Enumeration<ProcedureStatus> value) {
        this.status = value;
        return this;
    }

    public ProcedureStatus getStatus() {
        return this.status == null ? null : (ProcedureStatus)((Object)this.status.getValue());
    }

    public Procedure setStatus(ProcedureStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ProcedureStatus>(new ProcedureStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getNotDoneElement() {
        if (this.notDone == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.notDone");
            }
            if (Configuration.doAutoCreate()) {
                this.notDone = new BooleanType();
            }
        }
        return this.notDone;
    }

    public boolean hasNotDoneElement() {
        return this.notDone != null && !this.notDone.isEmpty();
    }

    public boolean hasNotDone() {
        return this.notDone != null && !this.notDone.isEmpty();
    }

    public Procedure setNotDoneElement(BooleanType value) {
        this.notDone = value;
        return this;
    }

    public boolean getNotDone() {
        return this.notDone == null || this.notDone.isEmpty() ? false : (Boolean)this.notDone.getValue();
    }

    public Procedure setNotDone(boolean value) {
        if (this.notDone == null) {
            this.notDone = new BooleanType();
        }
        this.notDone.setValue((Object)value);
        return this;
    }

    public CodeableConcept getNotDoneReason() {
        if (this.notDoneReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.notDoneReason");
            }
            if (Configuration.doAutoCreate()) {
                this.notDoneReason = new CodeableConcept();
            }
        }
        return this.notDoneReason;
    }

    public boolean hasNotDoneReason() {
        return this.notDoneReason != null && !this.notDoneReason.isEmpty();
    }

    public Procedure setNotDoneReason(CodeableConcept value) {
        this.notDoneReason = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Procedure setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Procedure setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Procedure setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Procedure setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public Procedure setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public Procedure setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getPerformed() {
        return this.performed;
    }

    public DateTimeType getPerformedDateTimeType() throws FHIRException {
        if (this.performed == null) {
            return null;
        }
        if (!(this.performed instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.performed.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.performed;
    }

    public boolean hasPerformedDateTimeType() {
        return this != null && this.performed instanceof DateTimeType;
    }

    public Period getPerformedPeriod() throws FHIRException {
        if (this.performed == null) {
            return null;
        }
        if (!(this.performed instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.performed.getClass().getName() + " was encountered");
        }
        return (Period)this.performed;
    }

    public boolean hasPerformedPeriod() {
        return this != null && this.performed instanceof Period;
    }

    public boolean hasPerformed() {
        return this.performed != null && !this.performed.isEmpty();
    }

    public Procedure setPerformed(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRFormatError("Not the right type for Procedure.performed[x]: " + value.fhirType());
        }
        this.performed = value;
        return this;
    }

    public List<ProcedurePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        return this.performer;
    }

    public Procedure setPerformer(List<ProcedurePerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ProcedurePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedurePerformerComponent addPerformer() {
        ProcedurePerformerComponent t = new ProcedurePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public Procedure addPerformer(ProcedurePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public ProcedurePerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Procedure setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Procedure setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public Procedure setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public Procedure addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public Procedure setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public Procedure addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public Procedure setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public Procedure addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Procedure.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public Procedure setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public List<Reference> getReport() {
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        return this.report;
    }

    public Procedure setReport(List<Reference> theReport) {
        this.report = theReport;
        return this;
    }

    public boolean hasReport() {
        if (this.report == null) {
            return false;
        }
        for (Reference item : this.report) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReport() {
        Reference t = new Reference();
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        this.report.add(t);
        return t;
    }

    public Procedure addReport(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        this.report.add(t);
        return this;
    }

    public Reference getReportFirstRep() {
        if (this.getReport().isEmpty()) {
            this.addReport();
        }
        return this.getReport().get(0);
    }

    @Deprecated
    public List<DiagnosticReport> getReportTarget() {
        if (this.reportTarget == null) {
            this.reportTarget = new ArrayList<DiagnosticReport>();
        }
        return this.reportTarget;
    }

    @Deprecated
    public DiagnosticReport addReportTarget() {
        DiagnosticReport r = new DiagnosticReport();
        if (this.reportTarget == null) {
            this.reportTarget = new ArrayList<DiagnosticReport>();
        }
        this.reportTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getComplication() {
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        return this.complication;
    }

    public Procedure setComplication(List<CodeableConcept> theComplication) {
        this.complication = theComplication;
        return this;
    }

    public boolean hasComplication() {
        if (this.complication == null) {
            return false;
        }
        for (CodeableConcept item : this.complication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addComplication() {
        CodeableConcept t = new CodeableConcept();
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        this.complication.add(t);
        return t;
    }

    public Procedure addComplication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        this.complication.add(t);
        return this;
    }

    public CodeableConcept getComplicationFirstRep() {
        if (this.getComplication().isEmpty()) {
            this.addComplication();
        }
        return this.getComplication().get(0);
    }

    public List<Reference> getComplicationDetail() {
        if (this.complicationDetail == null) {
            this.complicationDetail = new ArrayList<Reference>();
        }
        return this.complicationDetail;
    }

    public Procedure setComplicationDetail(List<Reference> theComplicationDetail) {
        this.complicationDetail = theComplicationDetail;
        return this;
    }

    public boolean hasComplicationDetail() {
        if (this.complicationDetail == null) {
            return false;
        }
        for (Reference item : this.complicationDetail) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addComplicationDetail() {
        Reference t = new Reference();
        if (this.complicationDetail == null) {
            this.complicationDetail = new ArrayList<Reference>();
        }
        this.complicationDetail.add(t);
        return t;
    }

    public Procedure addComplicationDetail(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.complicationDetail == null) {
            this.complicationDetail = new ArrayList<Reference>();
        }
        this.complicationDetail.add(t);
        return this;
    }

    public Reference getComplicationDetailFirstRep() {
        if (this.getComplicationDetail().isEmpty()) {
            this.addComplicationDetail();
        }
        return this.getComplicationDetail().get(0);
    }

    @Deprecated
    public List<Condition> getComplicationDetailTarget() {
        if (this.complicationDetailTarget == null) {
            this.complicationDetailTarget = new ArrayList<Condition>();
        }
        return this.complicationDetailTarget;
    }

    @Deprecated
    public Condition addComplicationDetailTarget() {
        Condition r = new Condition();
        if (this.complicationDetailTarget == null) {
            this.complicationDetailTarget = new ArrayList<Condition>();
        }
        this.complicationDetailTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getFollowUp() {
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        return this.followUp;
    }

    public Procedure setFollowUp(List<CodeableConcept> theFollowUp) {
        this.followUp = theFollowUp;
        return this;
    }

    public boolean hasFollowUp() {
        if (this.followUp == null) {
            return false;
        }
        for (CodeableConcept item : this.followUp) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFollowUp() {
        CodeableConcept t = new CodeableConcept();
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        this.followUp.add(t);
        return t;
    }

    public Procedure addFollowUp(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        this.followUp.add(t);
        return this;
    }

    public CodeableConcept getFollowUpFirstRep() {
        if (this.getFollowUp().isEmpty()) {
            this.addFollowUp();
        }
        return this.getFollowUp().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Procedure setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Procedure addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<ProcedureFocalDeviceComponent> getFocalDevice() {
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        return this.focalDevice;
    }

    public Procedure setFocalDevice(List<ProcedureFocalDeviceComponent> theFocalDevice) {
        this.focalDevice = theFocalDevice;
        return this;
    }

    public boolean hasFocalDevice() {
        if (this.focalDevice == null) {
            return false;
        }
        for (ProcedureFocalDeviceComponent item : this.focalDevice) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureFocalDeviceComponent addFocalDevice() {
        ProcedureFocalDeviceComponent t = new ProcedureFocalDeviceComponent();
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        this.focalDevice.add(t);
        return t;
    }

    public Procedure addFocalDevice(ProcedureFocalDeviceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
        }
        this.focalDevice.add(t);
        return this;
    }

    public ProcedureFocalDeviceComponent getFocalDeviceFirstRep() {
        if (this.getFocalDevice().isEmpty()) {
            this.addFocalDevice();
        }
        return this.getFocalDevice().get(0);
    }

    public List<Reference> getUsedReference() {
        if (this.usedReference == null) {
            this.usedReference = new ArrayList<Reference>();
        }
        return this.usedReference;
    }

    public Procedure setUsedReference(List<Reference> theUsedReference) {
        this.usedReference = theUsedReference;
        return this;
    }

    public boolean hasUsedReference() {
        if (this.usedReference == null) {
            return false;
        }
        for (Reference item : this.usedReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addUsedReference() {
        Reference t = new Reference();
        if (this.usedReference == null) {
            this.usedReference = new ArrayList<Reference>();
        }
        this.usedReference.add(t);
        return t;
    }

    public Procedure addUsedReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.usedReference == null) {
            this.usedReference = new ArrayList<Reference>();
        }
        this.usedReference.add(t);
        return this;
    }

    public Reference getUsedReferenceFirstRep() {
        if (this.getUsedReference().isEmpty()) {
            this.addUsedReference();
        }
        return this.getUsedReference().get(0);
    }

    @Deprecated
    public List<Resource> getUsedReferenceTarget() {
        if (this.usedReferenceTarget == null) {
            this.usedReferenceTarget = new ArrayList<Resource>();
        }
        return this.usedReferenceTarget;
    }

    public List<CodeableConcept> getUsedCode() {
        if (this.usedCode == null) {
            this.usedCode = new ArrayList<CodeableConcept>();
        }
        return this.usedCode;
    }

    public Procedure setUsedCode(List<CodeableConcept> theUsedCode) {
        this.usedCode = theUsedCode;
        return this;
    }

    public boolean hasUsedCode() {
        if (this.usedCode == null) {
            return false;
        }
        for (CodeableConcept item : this.usedCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUsedCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.usedCode == null) {
            this.usedCode = new ArrayList<CodeableConcept>();
        }
        this.usedCode.add(t);
        return t;
    }

    public Procedure addUsedCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.usedCode == null) {
            this.usedCode = new ArrayList<CodeableConcept>();
        }
        this.usedCode.add(t);
        return this;
    }

    public CodeableConcept getUsedCodeFirstRep() {
        if (this.getUsedCode().isEmpty()) {
            this.addUsedCode();
        }
        return this.getUsedCode().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this procedure that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_DEFINITION, "Reference(PlanDefinition|ActivityDefinition|HealthcareService)", "A protocol, guideline, orderset or other definition that was adhered to in whole or in part by this procedure.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("basedOn", "Reference(CarePlan|ProcedureRequest|ReferralRequest)", "A reference to a resource that contains details of the request for this procedure.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(Procedure|Observation|MedicationAdministration)", "A larger event of which this particular procedure is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the state of the procedure. Generally this will be in-progress or completed state.", 0, 1, this.status));
        children.add(new Property("notDone", "boolean", "Set this to true if the record is saying that the procedure was NOT performed.", 0, 1, this.notDone));
        children.add(new Property("notDoneReason", "CodeableConcept", "A code indicating why the procedure was not performed.", 0, 1, this.notDoneReason));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, 1, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group on which the procedure was performed.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter during which the procedure was performed.", 0, 1, this.context));
        children.add(new Property("performed[x]", "dateTime|Period", "The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed));
        children.add(new Property(SP_PERFORMER, "", "Limited to 'real' people rather than equipment.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.", 0, 1, this.location));
        children.add(new Property("reasonCode", "CodeableConcept", "The coded reason why the procedure was performed. This may be coded entity of some type, or may simply be present as text.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation)", "The condition that is the reason why the procedure was performed.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("bodySite", "CodeableConcept", "Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property("outcome", "CodeableConcept", "The outcome of the procedure - did it resolve reasons for the procedure being performed?", 0, 1, this.outcome));
        children.add(new Property("report", "Reference(DiagnosticReport)", "This could be a histology result, pathology report, surgical report, etc..", 0, Integer.MAX_VALUE, this.report));
        children.add(new Property("complication", "CodeableConcept", "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.", 0, Integer.MAX_VALUE, this.complication));
        children.add(new Property("complicationDetail", "Reference(Condition)", "Any complications that occurred during the procedure, or in the immediate post-performance period.", 0, Integer.MAX_VALUE, this.complicationDetail));
        children.add(new Property("followUp", "CodeableConcept", "If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or could potentially be more complex in which case the CarePlan resource can be used.", 0, Integer.MAX_VALUE, this.followUp));
        children.add(new Property("note", "Annotation", "Any other notes about the procedure.  E.g. the operative notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("focalDevice", "", "A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.", 0, Integer.MAX_VALUE, this.focalDevice));
        children.add(new Property("usedReference", "Reference(Device|Medication|Substance)", "Identifies medications, devices and any other substance used as part of the procedure.", 0, Integer.MAX_VALUE, this.usedReference));
        children.add(new Property("usedCode", "CodeableConcept", "Identifies coded items that were used as part of the procedure.", 0, Integer.MAX_VALUE, this.usedCode));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this procedure that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property(SP_DEFINITION, "Reference(PlanDefinition|ActivityDefinition|HealthcareService)", "A protocol, guideline, orderset or other definition that was adhered to in whole or in part by this procedure.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ProcedureRequest|ReferralRequest)", "A reference to a resource that contains details of the request for this procedure.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Procedure|Observation|MedicationAdministration)", "A larger event of which this particular procedure is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the state of the procedure. Generally this will be in-progress or completed state.", 0, 1, this.status);
            }
            case 2128257269: {
                return new Property("notDone", "boolean", "Set this to true if the record is saying that the procedure was NOT performed.", 0, 1, this.notDone);
            }
            case -1973169255: {
                return new Property("notDoneReason", "CodeableConcept", "A code indicating why the procedure was not performed.", 0, 1, this.notDoneReason);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, 1, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\").", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group on which the procedure was performed.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter during which the procedure was performed.", 0, 1, this.context);
            }
            case 1355984064: {
                return new Property("performed[x]", "dateTime|Period", "The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
            }
            case 481140672: {
                return new Property("performed[x]", "dateTime|Period", "The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
            }
            case 1118270331: {
                return new Property("performed[x]", "dateTime|Period", "The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
            }
            case 1622094241: {
                return new Property("performed[x]", "dateTime|Period", "The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Limited to 'real' people rather than equipment.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant.", 0, 1, this.location);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "The coded reason why the procedure was performed. This may be coded entity of some type, or may simply be present as text.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation)", "The condition that is the reason why the procedure was performed.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case -1106507950: {
                return new Property("outcome", "CodeableConcept", "The outcome of the procedure - did it resolve reasons for the procedure being performed?", 0, 1, this.outcome);
            }
            case -934521548: {
                return new Property("report", "Reference(DiagnosticReport)", "This could be a histology result, pathology report, surgical report, etc..", 0, Integer.MAX_VALUE, this.report);
            }
            case -1644401602: {
                return new Property("complication", "CodeableConcept", "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.", 0, Integer.MAX_VALUE, this.complication);
            }
            case -1685272017: {
                return new Property("complicationDetail", "Reference(Condition)", "Any complications that occurred during the procedure, or in the immediate post-performance period.", 0, Integer.MAX_VALUE, this.complicationDetail);
            }
            case 301801004: {
                return new Property("followUp", "CodeableConcept", "If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or could potentially be more complex in which case the CarePlan resource can be used.", 0, Integer.MAX_VALUE, this.followUp);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Any other notes about the procedure.  E.g. the operative notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1129235173: {
                return new Property("focalDevice", "", "A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.", 0, Integer.MAX_VALUE, this.focalDevice);
            }
            case -504932338: {
                return new Property("usedReference", "Reference(Device|Medication|Substance)", "Identifies medications, devices and any other substance used as part of the procedure.", 0, Integer.MAX_VALUE, this.usedReference);
            }
            case -279910582: {
                return new Property("usedCode", "CodeableConcept", "Identifies coded items that were used as part of the procedure.", 0, Integer.MAX_VALUE, this.usedCode);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2128257269: {
                Base[] baseArray;
                if (this.notDone == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.notDone;
                }
                return baseArray;
            }
            case -1973169255: {
                Base[] baseArray;
                if (this.notDoneReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.notDoneReason;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.category;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.context;
                }
                return baseArray;
            }
            case 481140672: {
                Base[] baseArray;
                if (this.performed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.performed;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.location;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.outcome;
                }
                return baseArray;
            }
            case -934521548: {
                return this.report == null ? new Base[]{} : this.report.toArray(new Base[this.report.size()]);
            }
            case -1644401602: {
                return this.complication == null ? new Base[]{} : this.complication.toArray(new Base[this.complication.size()]);
            }
            case -1685272017: {
                return this.complicationDetail == null ? new Base[]{} : this.complicationDetail.toArray(new Base[this.complicationDetail.size()]);
            }
            case 301801004: {
                return this.followUp == null ? new Base[]{} : this.followUp.toArray(new Base[this.followUp.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1129235173: {
                return this.focalDevice == null ? new Base[]{} : this.focalDevice.toArray(new Base[this.focalDevice.size()]);
            }
            case -504932338: {
                return this.usedReference == null ? new Base[]{} : this.usedReference.toArray(new Base[this.usedReference.size()]);
            }
            case -279910582: {
                return this.usedCode == null ? new Base[]{} : this.usedCode.toArray(new Base[this.usedCode.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new ProcedureStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2128257269: {
                this.notDone = this.castToBoolean(value);
                return value;
            }
            case -1973169255: {
                this.notDoneReason = this.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 481140672: {
                this.performed = this.castToType(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((ProcedurePerformerComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToCodeableConcept(value);
                return value;
            }
            case -934521548: {
                this.getReport().add(this.castToReference(value));
                return value;
            }
            case -1644401602: {
                this.getComplication().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1685272017: {
                this.getComplicationDetail().add(this.castToReference(value));
                return value;
            }
            case 301801004: {
                this.getFollowUp().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1129235173: {
                this.getFocalDevice().add((ProcedureFocalDeviceComponent)((Object)value));
                return value;
            }
            case -504932338: {
                this.getUsedReference().add(this.castToReference(value));
                return value;
            }
            case -279910582: {
                this.getUsedCode().add(this.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DEFINITION)) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ProcedureStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("notDone")) {
            this.notDone = this.castToBoolean(value);
        } else if (name.equals("notDoneReason")) {
            this.notDoneReason = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("performed[x]")) {
            this.performed = this.castToType(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((ProcedurePerformerComponent)((Object)value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("outcome")) {
            this.outcome = this.castToCodeableConcept(value);
        } else if (name.equals("report")) {
            this.getReport().add(this.castToReference(value));
        } else if (name.equals("complication")) {
            this.getComplication().add(this.castToCodeableConcept(value));
        } else if (name.equals("complicationDetail")) {
            this.getComplicationDetail().add(this.castToReference(value));
        } else if (name.equals("followUp")) {
            this.getFollowUp().add(this.castToCodeableConcept(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("focalDevice")) {
            this.getFocalDevice().add((ProcedureFocalDeviceComponent)((Object)value));
        } else if (name.equals("usedReference")) {
            this.getUsedReference().add(this.castToReference(value));
        } else if (name.equals("usedCode")) {
            this.getUsedCode().add(this.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2128257269: {
                return this.getNotDoneElement();
            }
            case -1973169255: {
                return this.getNotDoneReason();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case 1355984064: {
                return this.getPerformed();
            }
            case 481140672: {
                return this.getPerformed();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case -934521548: {
                return this.addReport();
            }
            case -1644401602: {
                return this.addComplication();
            }
            case -1685272017: {
                return this.addComplicationDetail();
            }
            case 301801004: {
                return this.addFollowUp();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1129235173: {
                return this.addFocalDevice();
            }
            case -504932338: {
                return this.addUsedReference();
            }
            case -279910582: {
                return this.addUsedCode();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2128257269: {
                return new String[]{"boolean"};
            }
            case -1973169255: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 481140672: {
                return new String[]{"dateTime", "Period"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case -934521548: {
                return new String[]{"Reference"};
            }
            case -1644401602: {
                return new String[]{"CodeableConcept"};
            }
            case -1685272017: {
                return new String[]{"Reference"};
            }
            case 301801004: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1129235173: {
                return new String[0];
            }
            case -504932338: {
                return new String[]{"Reference"};
            }
            case -279910582: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEFINITION)) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Procedure.status");
        }
        if (name.equals("notDone")) {
            throw new FHIRException("Cannot call addChild on a primitive type Procedure.notDone");
        }
        if (name.equals("notDoneReason")) {
            this.notDoneReason = new CodeableConcept();
            return this.notDoneReason;
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("performedDateTime")) {
            this.performed = new DateTimeType();
            return this.performed;
        }
        if (name.equals("performedPeriod")) {
            this.performed = new Period();
            return this.performed;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("outcome")) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals("report")) {
            return this.addReport();
        }
        if (name.equals("complication")) {
            return this.addComplication();
        }
        if (name.equals("complicationDetail")) {
            return this.addComplicationDetail();
        }
        if (name.equals("followUp")) {
            return this.addFollowUp();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("focalDevice")) {
            return this.addFocalDevice();
        }
        if (name.equals("usedReference")) {
            return this.addUsedReference();
        }
        if (name.equals("usedCode")) {
            return this.addUsedCode();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Procedure";
    }

    @Override
    public Procedure copy() {
        Procedure dst = new Procedure();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.notDone = this.notDone == null ? null : this.notDone.copy();
        dst.notDoneReason = this.notDoneReason == null ? null : this.notDoneReason.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        Type type = dst.performed = this.performed == null ? null : this.performed.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ProcedurePerformerComponent>();
            for (ProcedurePerformerComponent procedurePerformerComponent : this.performer) {
                dst.performer.add(procedurePerformerComponent.copy());
            }
        }
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference2 : this.reasonReference) {
                dst.reasonReference.add(reference2.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodySite) {
                dst.bodySite.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.outcome = this.outcome == null ? null : this.outcome.copy();
        if (this.report != null) {
            dst.report = new ArrayList<Reference>();
            for (Reference reference3 : this.report) {
                dst.report.add(reference3.copy());
            }
        }
        if (this.complication != null) {
            dst.complication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.complication) {
                dst.complication.add(codeableConcept2.copy());
            }
        }
        if (this.complicationDetail != null) {
            dst.complicationDetail = new ArrayList<Reference>();
            for (Reference reference4 : this.complicationDetail) {
                dst.complicationDetail.add(reference4.copy());
            }
        }
        if (this.followUp != null) {
            dst.followUp = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.followUp) {
                dst.followUp.add(codeableConcept3.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.focalDevice != null) {
            dst.focalDevice = new ArrayList<ProcedureFocalDeviceComponent>();
            for (ProcedureFocalDeviceComponent procedureFocalDeviceComponent : this.focalDevice) {
                dst.focalDevice.add(procedureFocalDeviceComponent.copy());
            }
        }
        if (this.usedReference != null) {
            dst.usedReference = new ArrayList<Reference>();
            for (Reference reference5 : this.usedReference) {
                dst.usedReference.add(reference5.copy());
            }
        }
        if (this.usedCode != null) {
            dst.usedCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.usedCode) {
                dst.usedCode.add(codeableConcept4.copy());
            }
        }
        return dst;
    }

    protected Procedure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Procedure)) {
            return false;
        }
        Procedure o = (Procedure)other_;
        return Procedure.compareDeep(this.identifier, o.identifier, true) && Procedure.compareDeep(this.definition, o.definition, true) && Procedure.compareDeep(this.basedOn, o.basedOn, true) && Procedure.compareDeep(this.partOf, o.partOf, true) && Procedure.compareDeep(this.status, o.status, true) && Procedure.compareDeep(this.notDone, o.notDone, true) && Procedure.compareDeep(this.notDoneReason, o.notDoneReason, true) && Procedure.compareDeep(this.category, o.category, true) && Procedure.compareDeep(this.code, o.code, true) && Procedure.compareDeep(this.subject, o.subject, true) && Procedure.compareDeep(this.context, o.context, true) && Procedure.compareDeep(this.performed, o.performed, true) && Procedure.compareDeep(this.performer, o.performer, true) && Procedure.compareDeep(this.location, o.location, true) && Procedure.compareDeep(this.reasonCode, o.reasonCode, true) && Procedure.compareDeep(this.reasonReference, o.reasonReference, true) && Procedure.compareDeep(this.bodySite, o.bodySite, true) && Procedure.compareDeep(this.outcome, o.outcome, true) && Procedure.compareDeep(this.report, o.report, true) && Procedure.compareDeep(this.complication, o.complication, true) && Procedure.compareDeep(this.complicationDetail, o.complicationDetail, true) && Procedure.compareDeep(this.followUp, o.followUp, true) && Procedure.compareDeep(this.note, o.note, true) && Procedure.compareDeep(this.focalDevice, o.focalDevice, true) && Procedure.compareDeep(this.usedReference, o.usedReference, true) && Procedure.compareDeep(this.usedCode, o.usedCode, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Procedure)) {
            return false;
        }
        Procedure o = (Procedure)other_;
        return Procedure.compareValues(this.status, o.status, true) && Procedure.compareValues(this.notDone, o.notDone, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.basedOn, this.partOf, this.status, this.notDone, this.notDoneReason, this.category, this.code, this.subject, this.context, this.performed, this.performer, this.location, this.reasonCode, this.reasonReference, this.bodySite, this.outcome, this.report, this.complication, this.complicationDetail, this.followUp, this.note, this.focalDevice, this.usedReference, this.usedCode});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Procedure;
    }

    @Block
    public static class ProcedureFocalDeviceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of change to device", formalDefinition="The kind of change that happened to the device during the procedure.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-action")
        protected CodeableConcept action;
        @Child(name="manipulated", type={Device.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device that was changed", formalDefinition="The device that was manipulated (changed) during the procedure.")
        protected Reference manipulated;
        protected Device manipulatedTarget;
        private static final long serialVersionUID = 1779937807L;

        public ProcedureFocalDeviceComponent() {
        }

        public ProcedureFocalDeviceComponent(Reference manipulated) {
            this.manipulated = manipulated;
        }

        public CodeableConcept getAction() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new CodeableConcept();
                }
            }
            return this.action;
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public ProcedureFocalDeviceComponent setAction(CodeableConcept value) {
            this.action = value;
            return this;
        }

        public Reference getManipulated() {
            if (this.manipulated == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.manipulated");
                }
                if (Configuration.doAutoCreate()) {
                    this.manipulated = new Reference();
                }
            }
            return this.manipulated;
        }

        public boolean hasManipulated() {
            return this.manipulated != null && !this.manipulated.isEmpty();
        }

        public ProcedureFocalDeviceComponent setManipulated(Reference value) {
            this.manipulated = value;
            return this;
        }

        public Device getManipulatedTarget() {
            if (this.manipulatedTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureFocalDeviceComponent.manipulated");
                }
                if (Configuration.doAutoCreate()) {
                    this.manipulatedTarget = new Device();
                }
            }
            return this.manipulatedTarget;
        }

        public ProcedureFocalDeviceComponent setManipulatedTarget(Device value) {
            this.manipulatedTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "CodeableConcept", "The kind of change that happened to the device during the procedure.", 0, 1, this.action));
            children.add(new Property("manipulated", "Reference(Device)", "The device that was manipulated (changed) during the procedure.", 0, 1, this.manipulated));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "CodeableConcept", "The kind of change that happened to the device during the procedure.", 0, 1, this.action);
                }
                case 947372650: {
                    return new Property("manipulated", "Reference(Device)", "The device that was manipulated (changed) during the procedure.", 0, 1, this.manipulated);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    Base[] baseArray;
                    if (this.action == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.action;
                    }
                    return baseArray;
                }
                case 947372650: {
                    Base[] baseArray;
                    if (this.manipulated == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.manipulated;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.action = this.castToCodeableConcept(value);
                    return value;
                }
                case 947372650: {
                    this.manipulated = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = this.castToCodeableConcept(value);
            } else if (name.equals("manipulated")) {
                this.manipulated = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.getAction();
                }
                case 947372650: {
                    return this.getManipulated();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case 947372650: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                this.action = new CodeableConcept();
                return this.action;
            }
            if (name.equals("manipulated")) {
                this.manipulated = new Reference();
                return this.manipulated;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureFocalDeviceComponent copy() {
            ProcedureFocalDeviceComponent dst = new ProcedureFocalDeviceComponent();
            this.copyValues(dst);
            dst.action = this.action == null ? null : this.action.copy();
            dst.manipulated = this.manipulated == null ? null : this.manipulated.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureFocalDeviceComponent)) {
                return false;
            }
            ProcedureFocalDeviceComponent o = (ProcedureFocalDeviceComponent)other_;
            return ProcedureFocalDeviceComponent.compareDeep(this.action, o.action, true) && ProcedureFocalDeviceComponent.compareDeep(this.manipulated, o.manipulated, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureFocalDeviceComponent)) {
                return false;
            }
            ProcedureFocalDeviceComponent o = (ProcedureFocalDeviceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.action, this.manipulated});
        }

        @Override
        public String fhirType() {
            return "Procedure.focalDevice";
        }
    }

    @Block
    public static class ProcedurePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The role the actor was in", formalDefinition="For example: surgeon, anaethetist, endoscopist.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        protected CodeableConcept role;
        @Child(name="actor", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The reference to the practitioner", formalDefinition="The practitioner who was involved in the procedure.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization the device or practitioner was acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = 213950062L;

        public ProcedurePerformerComponent() {
        }

        public ProcedurePerformerComponent(Reference actor) {
            this.actor = actor;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProcedurePerformerComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ProcedurePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public ProcedurePerformerComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public ProcedurePerformerComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedurePerformerComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public ProcedurePerformerComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "For example: surgeon, anaethetist, endoscopist.", 0, 1, this.role));
            children.add(new Property("actor", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The practitioner who was involved in the procedure.", 0, 1, this.actor));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "For example: surgeon, anaethetist, endoscopist.", 0, 1, this.role);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The practitioner who was involved in the procedure.", 0, 1, this.actor);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 92645877: {
                    return this.getActor();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedurePerformerComponent copy() {
            ProcedurePerformerComponent dst = new ProcedurePerformerComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedurePerformerComponent)) {
                return false;
            }
            ProcedurePerformerComponent o = (ProcedurePerformerComponent)other_;
            return ProcedurePerformerComponent.compareDeep(this.role, o.role, true) && ProcedurePerformerComponent.compareDeep(this.actor, o.actor, true) && ProcedurePerformerComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedurePerformerComponent)) {
                return false;
            }
            ProcedurePerformerComponent o = (ProcedurePerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.actor, this.onBehalfOf});
        }

        @Override
        public String fhirType() {
            return "Procedure.performer";
        }
    }

    public static class ProcedureStatusEnumFactory
    implements EnumFactory<ProcedureStatus> {
        @Override
        public ProcedureStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return ProcedureStatus.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return ProcedureStatus.INPROGRESS;
            }
            if ("suspended".equals(codeString)) {
                return ProcedureStatus.SUSPENDED;
            }
            if ("aborted".equals(codeString)) {
                return ProcedureStatus.ABORTED;
            }
            if ("completed".equals(codeString)) {
                return ProcedureStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ProcedureStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ProcedureStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ProcedureStatus code '" + codeString + "'");
        }

        public Enumeration<ProcedureStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProcedureStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.PREPARATION);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.INPROGRESS);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.SUSPENDED);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.ABORTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ProcedureStatus>(this, ProcedureStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ProcedureStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureStatus code) {
            if (code == ProcedureStatus.PREPARATION) {
                return "preparation";
            }
            if (code == ProcedureStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == ProcedureStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == ProcedureStatus.ABORTED) {
                return "aborted";
            }
            if (code == ProcedureStatus.COMPLETED) {
                return "completed";
            }
            if (code == ProcedureStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ProcedureStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureStatus code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureStatus {
        PREPARATION,
        INPROGRESS,
        SUSPENDED,
        ABORTED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ProcedureStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProcedureStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case ABORTED: {
                    return "aborted";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/event-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/event-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
                }
                case INPROGRESS: {
                    return "The event is currently occurring";
                }
                case SUSPENDED: {
                    return "The event has been temporarily stopped but is expected to resume in the future";
                }
                case ABORTED: {
                    return "The event was  prior to the full completion of the intended actions";
                }
                case COMPLETED: {
                    return "The event has now concluded";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

