/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCausalityAssess {
    ASSESS1,
    ASSESS2,
    NULL;


    public static AdverseEventCausalityAssess fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("assess1".equals(codeString)) {
            return ASSESS1;
        }
        if ("assess2".equals(codeString)) {
            return ASSESS2;
        }
        throw new FHIRException("Unknown AdverseEventCausalityAssess code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ASSESS1: {
                return "assess1";
            }
            case ASSESS2: {
                return "assess2";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-causality-assess";
    }

    public String getDefinition() {
        switch (this) {
            case ASSESS1: {
                return "";
            }
            case ASSESS2: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ASSESS1: {
                return "assess1 placeholder";
            }
            case ASSESS2: {
                return "assess2 placeholder";
            }
        }
        return "?";
    }
}

