/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CompositionAttestationMode;

public class CompositionAttestationModeEnumFactory
implements EnumFactory<CompositionAttestationMode> {
    @Override
    public CompositionAttestationMode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("personal".equals(codeString)) {
            return CompositionAttestationMode.PERSONAL;
        }
        if ("professional".equals(codeString)) {
            return CompositionAttestationMode.PROFESSIONAL;
        }
        if ("legal".equals(codeString)) {
            return CompositionAttestationMode.LEGAL;
        }
        if ("official".equals(codeString)) {
            return CompositionAttestationMode.OFFICIAL;
        }
        throw new IllegalArgumentException("Unknown CompositionAttestationMode code '" + codeString + "'");
    }

    @Override
    public String toCode(CompositionAttestationMode code) {
        if (code == CompositionAttestationMode.PERSONAL) {
            return "personal";
        }
        if (code == CompositionAttestationMode.PROFESSIONAL) {
            return "professional";
        }
        if (code == CompositionAttestationMode.LEGAL) {
            return "legal";
        }
        if (code == CompositionAttestationMode.OFFICIAL) {
            return "official";
        }
        return "?";
    }

    @Override
    public String toSystem(CompositionAttestationMode code) {
        return code.getSystem();
    }
}

