/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.IssueSeverity;

public class IssueSeverityEnumFactory
implements EnumFactory<IssueSeverity> {
    @Override
    public IssueSeverity fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fatal".equals(codeString)) {
            return IssueSeverity.FATAL;
        }
        if ("error".equals(codeString)) {
            return IssueSeverity.ERROR;
        }
        if ("warning".equals(codeString)) {
            return IssueSeverity.WARNING;
        }
        if ("information".equals(codeString)) {
            return IssueSeverity.INFORMATION;
        }
        throw new IllegalArgumentException("Unknown IssueSeverity code '" + codeString + "'");
    }

    @Override
    public String toCode(IssueSeverity code) {
        if (code == IssueSeverity.FATAL) {
            return "fatal";
        }
        if (code == IssueSeverity.ERROR) {
            return "error";
        }
        if (code == IssueSeverity.WARNING) {
            return "warning";
        }
        if (code == IssueSeverity.INFORMATION) {
            return "information";
        }
        return "?";
    }

    @Override
    public String toSystem(IssueSeverity code) {
        return code.getSystem();
    }
}

