/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.rest.api.Constants;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileValidationSupport
implements IValidationSupport {
    private static final String URL_PREFIX_VALUE_SET = "http://hl7.org/fhir/ValueSet/";
    private static final String URL_PREFIX_STRUCTURE_DEFINITION = "http://hl7.org/fhir/StructureDefinition/";
    private static final String URL_PREFIX_STRUCTURE_DEFINITION_BASE = "http://hl7.org/fhir/";
    private static final Logger ourLog = LoggerFactory.getLogger(DefaultProfileValidationSupport.class);
    private Map<String, CodeSystem> myCodeSystems;
    private Map<String, StructureDefinition> myStructureDefinitions;
    private Map<String, ValueSet> myValueSets;

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        ValueSet.ValueSetExpansionComponent retVal = new ValueSet.ValueSetExpansionComponent();
        HashSet<String> wantCodes = new HashSet<String>();
        for (ValueSet.ConceptReferenceComponent next : theInclude.getConcept()) {
            wantCodes.add(next.getCode());
        }
        CodeSystem system = this.fetchCodeSystem(theContext, theInclude.getSystem());
        if (system != null) {
            List concepts = system.getConcept();
            this.addConcepts(theInclude, retVal, wantCodes, concepts);
        }
        for (UriType next : theInclude.getValueSet()) {
            ValueSet vs = this.myValueSets.get(StringUtils.defaultString((String)next.getValueAsString()));
            if (vs == null) continue;
            for (ValueSet.ConceptSetComponent nextInclude : vs.getCompose().getInclude()) {
                ValueSet.ValueSetExpansionComponent contents = this.expandValueSet(theContext, nextInclude);
                retVal.getContains().addAll(contents.getContains());
            }
        }
        return retVal;
    }

    private void addConcepts(ValueSet.ConceptSetComponent theInclude, ValueSet.ValueSetExpansionComponent theRetVal, Set<String> theWantCodes, List<CodeSystem.ConceptDefinitionComponent> theConcepts) {
        for (CodeSystem.ConceptDefinitionComponent next : theConcepts) {
            if (theWantCodes.isEmpty() || theWantCodes.contains(next.getCode())) {
                theRetVal.addContains().setSystem(theInclude.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
            }
            this.addConcepts(theInclude, theRetVal, theWantCodes, next.getConcept());
        }
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    @Override
    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return new ArrayList<StructureDefinition>(this.provideStructureDefinitionMap(theContext).values());
    }

    @Override
    public CodeSystem fetchCodeSystem(FhirContext theContext, String theSystem) {
        return (CodeSystem)this.fetchCodeSystemOrValueSet(theContext, theSystem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainResource fetchCodeSystemOrValueSet(FhirContext theContext, String theSystem, boolean codeSystem) {
        DefaultProfileValidationSupport defaultProfileValidationSupport = this;
        synchronized (defaultProfileValidationSupport) {
            Map<String, CodeSystem> codeSystems = this.myCodeSystems;
            Map<String, ValueSet> valueSets = this.myValueSets;
            if (codeSystems == null || valueSets == null) {
                codeSystems = new HashMap<String, CodeSystem>();
                valueSets = new HashMap<String, ValueSet>();
                this.loadCodeSystems(theContext, codeSystems, valueSets, "/org/hl7/fhir/dstu3/model/valueset/valuesets.xml");
                this.loadCodeSystems(theContext, codeSystems, valueSets, "/org/hl7/fhir/dstu3/model/valueset/v2-tables.xml");
                this.loadCodeSystems(theContext, codeSystems, valueSets, "/org/hl7/fhir/dstu3/model/valueset/v3-codesystems.xml");
                this.myCodeSystems = codeSystems;
                this.myValueSets = valueSets;
            }
            if (codeSystem) {
                return (DomainResource)codeSystems.get(theSystem);
            }
            return (DomainResource)valueSets.get(theSystem);
        }
    }

    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        Validate.notBlank((CharSequence)theUri, (String)"theUri must not be null or blank", (Object[])new Object[0]);
        if (theClass.equals(StructureDefinition.class)) {
            return (T)this.fetchStructureDefinition(theContext, theUri);
        }
        if (theClass.equals(ValueSet.class) || theUri.startsWith(URL_PREFIX_VALUE_SET)) {
            return (T)this.fetchValueSet(theContext, theUri);
        }
        return null;
    }

    @Override
    public StructureDefinition fetchStructureDefinition(FhirContext theContext, String theUrl) {
        Map<String, StructureDefinition> map;
        StructureDefinition retVal;
        String url = theUrl;
        if (!url.startsWith(URL_PREFIX_STRUCTURE_DEFINITION)) {
            if (url.indexOf(47) == -1) {
                url = URL_PREFIX_STRUCTURE_DEFINITION + url;
            } else if (StringUtils.countMatches((CharSequence)url, (char)'/') == 1) {
                url = URL_PREFIX_STRUCTURE_DEFINITION_BASE + url;
            }
        }
        if ((retVal = (map = this.provideStructureDefinitionMap(theContext)).get(url)) == null && url.startsWith(URL_PREFIX_STRUCTURE_DEFINITION)) {
            String tryUrl = URL_PREFIX_STRUCTURE_DEFINITION + StringUtils.capitalize((String)url.substring(URL_PREFIX_STRUCTURE_DEFINITION.length()));
            retVal = map.get(tryUrl);
        }
        return retVal;
    }

    @Override
    public ValueSet fetchValueSet(FhirContext theContext, String uri) {
        return (ValueSet)this.fetchCodeSystemOrValueSet(theContext, uri, false);
    }

    public void flush() {
        this.myCodeSystems = null;
        this.myStructureDefinitions = null;
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        CodeSystem cs = this.fetchCodeSystem(theContext, theSystem);
        return cs != null && cs.getContent() != CodeSystem.CodeSystemContentMode.NOTPRESENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCodeSystems(FhirContext theContext, Map<String, CodeSystem> theCodeSystems, Map<String, ValueSet> theValueSets, String theClasspath) {
        block5: {
            block4: {
                ourLog.info("Loading CodeSystem/ValueSet from classpath: {}", (Object)theClasspath);
                InputStream inputStream = DefaultProfileValidationSupport.class.getResourceAsStream(theClasspath);
                InputStreamReader reader = null;
                if (inputStream == null) break block4;
                try {
                    reader = new InputStreamReader(inputStream, Charsets.UTF_8);
                    Bundle bundle = (Bundle)theContext.newXmlParser().parseResource(Bundle.class, (Reader)reader);
                    for (Bundle.BundleEntryComponent next : bundle.getEntry()) {
                        String system;
                        CodeSystem nextValueSet;
                        if (next.getResource() instanceof CodeSystem) {
                            nextValueSet = (CodeSystem)next.getResource();
                            nextValueSet.getText().setDivAsString("");
                            system = nextValueSet.getUrl();
                            if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                            theCodeSystems.put(system, nextValueSet);
                            continue;
                        }
                        if (!(next.getResource() instanceof ValueSet)) continue;
                        nextValueSet = (ValueSet)next.getResource();
                        nextValueSet.getText().setDivAsString("");
                        system = nextValueSet.getUrl();
                        if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                        theValueSets.put(system, (ValueSet)nextValueSet);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((InputStream)inputStream);
                break block5;
            }
            ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
        }
    }

    private void loadStructureDefinitions(FhirContext theContext, Map<String, StructureDefinition> theCodeSystems, String theClasspath) {
        ourLog.info("Loading structure definitions from classpath: {}", (Object)theClasspath);
        InputStream valuesetText = DefaultProfileValidationSupport.class.getResourceAsStream(theClasspath);
        if (valuesetText != null) {
            InputStreamReader reader = new InputStreamReader(valuesetText, Charsets.UTF_8);
            Bundle bundle = (Bundle)theContext.newXmlParser().parseResource(Bundle.class, (Reader)reader);
            for (Bundle.BundleEntryComponent next : bundle.getEntry()) {
                if (!(next.getResource() instanceof StructureDefinition)) continue;
                StructureDefinition nextSd = (StructureDefinition)next.getResource();
                nextSd.getText().setDivAsString("");
                String system = nextSd.getUrl();
                if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                theCodeSystems.put(system, nextSd);
            }
        } else {
            ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
        }
    }

    private Map<String, StructureDefinition> provideStructureDefinitionMap(FhirContext theContext) {
        Map<String, StructureDefinition> structureDefinitions = this.myStructureDefinitions;
        if (structureDefinitions == null) {
            structureDefinitions = new HashMap<String, StructureDefinition>();
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu3/model/profile/profiles-resources.xml");
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu3/model/profile/profiles-types.xml");
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu3/model/profile/profiles-others.xml");
            this.loadStructureDefinitions(theContext, structureDefinitions, "/org/hl7/fhir/dstu3/model/extension/extension-definitions.xml");
            this.myStructureDefinitions = structureDefinitions;
        }
        return structureDefinitions;
    }

    private IContextValidationSupport.CodeValidationResult testIfConceptIsInList(CodeSystem theCodeSystem, String theCode, List<CodeSystem.ConceptDefinitionComponent> conceptList, boolean theCaseSensitive) {
        String code = theCode;
        if (!theCaseSensitive) {
            code = code.toUpperCase();
        }
        return this.testIfConceptIsInListInner(theCodeSystem, conceptList, theCaseSensitive, code);
    }

    private IContextValidationSupport.CodeValidationResult testIfConceptIsInListInner(CodeSystem theCodeSystem, List<CodeSystem.ConceptDefinitionComponent> conceptList, boolean theCaseSensitive, String code) {
        IContextValidationSupport.CodeValidationResult retVal = null;
        for (CodeSystem.ConceptDefinitionComponent next : conceptList) {
            String nextCandidate = next.getCode();
            if (!theCaseSensitive) {
                nextCandidate = nextCandidate.toUpperCase();
            }
            if (nextCandidate.equals(code)) {
                retVal = new IContextValidationSupport.CodeValidationResult(null, null, (IBase)next, next.getDisplay());
                break;
            }
            retVal = this.testIfConceptIsInList(theCodeSystem, code, next.getConcept(), theCaseSensitive);
            if (retVal == null) continue;
            break;
        }
        if (retVal != null) {
            retVal.setCodeSystemName(theCodeSystem.getName());
            retVal.setCodeSystemVersion(theCodeSystem.getVersion());
        }
        return retVal;
    }

    public IContextValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        CodeSystem cs;
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            HapiWorkerContext workerContext = new HapiWorkerContext(theContext, this);
            ValueSetExpanderSimple expander = new ValueSetExpanderSimple((IWorkerContext)workerContext, (ValueSetExpanderFactory)workerContext);
            try {
                ValueSetExpander.ValueSetExpansionOutcome expanded;
                Optional<ValueSet.ValueSetExpansionContainsComponent> haveMatch;
                ValueSet valueSet = this.fetchValueSet(theContext, theValueSetUrl);
                if (valueSet != null && (haveMatch = (expanded = expander.expand(valueSet, null)).getValueset().getExpansion().getContains().stream().filter(t -> (Constants.codeSystemNotNeeded((String)theCodeSystem) || t.getSystem().equals(theCodeSystem)) && t.getCode().equals(theCode)).findFirst()).isPresent()) {
                    return new IContextValidationSupport.CodeValidationResult((IBase)new CodeSystem.ConceptDefinitionComponent(new CodeType(theCode)));
                }
            }
            catch (Exception e) {
                return new IContextValidationSupport.CodeValidationResult((Enum)ValidationMessage.IssueSeverity.WARNING, e.getMessage());
            }
            return null;
        }
        if (theCodeSystem != null && (cs = this.fetchCodeSystem(theContext, theCodeSystem)) != null) {
            IContextValidationSupport.CodeValidationResult retVal;
            boolean caseSensitive = true;
            if (cs.hasCaseSensitive()) {
                caseSensitive = cs.getCaseSensitive();
            }
            if ((retVal = this.testIfConceptIsInList(cs, theCode, cs.getConcept(), caseSensitive)) != null) {
                return retVal;
            }
        }
        return new IContextValidationSupport.CodeValidationResult((Enum)ValidationMessage.IssueSeverity.WARNING, "Unknown code: " + theCodeSystem + " / " + theCode);
    }

    public IContextValidationSupport.LookupCodeResult lookupCode(FhirContext theContext, String theSystem, String theCode) {
        return this.validateCode(theContext, theSystem, theCode, null, null).asLookupCodeResult(theSystem, theCode);
    }

    @Override
    public StructureDefinition generateSnapshot(StructureDefinition theInput, String theUrl, String theName) {
        return null;
    }
}

