/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.CoverageIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.ParserType;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.dstu3.utils.INarrativeGenerator;
import org.hl7.fhir.dstu3.utils.IResourceValidator;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public final class HapiWorkerContext
implements IWorkerContext,
ValueSetExpander,
ValueSetExpanderFactory {
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private IValidationSupport myValidationSupport;
    private ExpansionProfile myExpansionProfile;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = 10000L;
        if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
            timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
        }
        this.myFetchedResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    @CoverageIgnore
    public List<MetadataResource> allConformanceResources() {
        throw new UnsupportedOperationException();
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions(this.myCtx);
    }

    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet theSource, ExpansionProfile theProfile) {
        ValueSetExpander.ValueSetExpansionOutcome vso;
        try {
            vso = this.getExpander().expand(theSource, theProfile);
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (TerminologyServiceException e) {
            throw new InvalidRequestException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        if (vso.getError() != null) {
            throw new InvalidRequestException(vso.getError());
        }
        return vso;
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHeiarchical) {
        throw new UnsupportedOperationException();
    }

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent theInc, boolean theHeiarchical) {
        return this.myValidationSupport.expandValueSet(this.myCtx, theInc);
    }

    public StructureDefinition fetchTypeDefinition(String theCode) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + theCode);
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return this.myValidationSupport.fetchCodeSystem(this.myCtx, theSystem);
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null) {
            return null;
        }
        Resource retVal = (Resource)this.myFetchedResourceCache.get((Object)theUri, t -> (Resource)this.myValidationSupport.fetchResource(this.myCtx, theClass, theUri));
        return (T)retVal;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass_, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass_, theUri);
        if (retVal == null) {
            throw new FHIRException("Unable to fetch " + theUri);
        }
        return retVal;
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException();
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander getExpander() {
        ValueSetExpanderSimple retVal = new ValueSetExpanderSimple((IWorkerContext)this, (ValueSetExpanderFactory)this);
        retVal.setMaxExpansionSize(Integer.MAX_VALUE);
        return retVal;
    }

    public ExpansionProfile getExpansionProfile() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(ExpansionProfile theExpProfile) {
        this.myExpansionProfile = theExpProfile;
    }

    public INarrativeGenerator getNarrativeGenerator(String thePrefix, String theBasePath) {
        throw new UnsupportedOperationException();
    }

    public IResourceValidator newValidator() throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException();
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public Set<String> getResourceNamesAsSet() {
        return new HashSet<String>(this.getResourceNames());
    }

    public List<String> getTypeNames() {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    @CoverageIgnore
    public boolean hasCache() {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException();
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException();
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException();
    }

    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException();
    }

    public void setLogger(IWorkerContext.ILoggingService theLogger) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(this.myCtx, theSystem);
    }

    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    public IWorkerContext.ValidationResult validateCode(Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(system, code, display, theVs);
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay) {
        IContextValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(this.myCtx, theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        return new IWorkerContext.ValidationResult((ValidationMessage.IssueSeverity)result.getSeverity(), result.getMessage(), (CodeSystem.ConceptDefinitionComponent)result.asConceptDefinition());
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet.ConceptSetComponent theVsi) {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        if ("http://hl7.org/fhir/ValueSet/languages".equals(theVs.getUrl())) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theSystem);
            definition.setDisplay(theCode);
            return new IWorkerContext.ValidationResult(definition);
        }
        if ("http://hl7.org/fhir/ValueSet/mimetypes".equals(theVs.getUrl())) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theSystem);
            definition.setDisplay(theCode);
            return new IWorkerContext.ValidationResult(definition);
        }
        IContextValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank((CharSequence)theVs.getUrl()) ? this.myValidationSupport.validateCode(this.myCtx, theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(this.myCtx, theSystem, theCode, theDisplay, (IBaseResource)theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new IWorkerContext.ValidationResult(definition);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]");
    }
}

