/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.ctx;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.fluentpath.IFluentPath;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.hapi.fluentpath.FluentPathDstu3;
import org.hl7.fhir.dstu3.hapi.rest.server.Dstu3BundleFactory;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirDstu3
implements IFhirVersion {
    private String myId;

    public IFluentPath createFluentPathExecutor(FhirContext theFhirContext) {
        return new FluentPathDstu3(theFhirContext);
    }

    public IContextValidationSupport<?, ?, ?, ?, ?, ?> createValidationSupport() {
        String className = "org.hl7.fhir.dstu3.hapi.ctx.DefaultProfileValidationSupport";
        try {
            return (IContextValidationSupport)Class.forName(className).newInstance();
        }
        catch (Exception theE) {
            throw new ConfigurationException(className + " is not on classpath. Make sure that hapi-fhir-validation-VERSION.jar is available.");
        }
    }

    public IBaseResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId((IIdType)new IdDt(this.myId));
        return retVal;
    }

    public Class<List> getContainedType() {
        return List.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        InputStream str = FhirDstu3.class.getResourceAsStream("/org/hl7/fhir/dstu3/model/fhirversion.properties");
        if (str == null) {
            str = FhirDstu3.class.getResourceAsStream("/org/hl7/fhir/dstu3/model/fhirversion.properties");
        }
        if (str == null) {
            throw new ConfigurationException("Can not find model property file on classpath: /ca/uhn/fhir/model/dstu3/fhirversion.properties");
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return ((Resource)theResource).getMeta().getLastUpdatedElement();
    }

    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/dstu3/model/schema";
    }

    public Class<? extends IBaseReference> getResourceReferenceType() {
        return Reference.class;
    }

    public Object getServerVersion() {
        return ReflectionUtil.newInstanceOfFhirServerType((String)"org.hl7.fhir.dstu3.hapi.ctx.FhirServerDstu3");
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.DSTU3;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new Dstu3BundleFactory(theContext);
    }

    public IBaseCoding newCodingDt() {
        return new Coding();
    }

    public IIdType newIdType() {
        return new IdType();
    }
}

