/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.fluentpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.fhirpath.IFhirPathEvaluationContext;
import ca.uhn.fhir.i18n.Msg;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.TypeDetails;
import org.hl7.fhir.dstu3.utils.FHIRPathEngine;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirPathDstu3
implements IFhirPath {
    private FHIRPathEngine myEngine;

    public FhirPathDstu3(FhirContext theCtx) {
        IValidationSupport validationSupport = theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(theCtx, validationSupport));
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        List result;
        try {
            result = this.myEngine.evaluate((Base)theInput, thePath);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(Msg.code((int)607) + e);
        }
        for (Base next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FhirPathExecutionException(Msg.code((int)608) + "FluentPath expression \"" + thePath + "\" returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
        return this.evaluate(theInput, thePath, theReturnType).stream().findFirst();
    }

    public void parse(String theExpression) {
        this.myEngine.parse(theExpression);
    }

    public void setEvaluationContext(final @Nonnull IFhirPathEvaluationContext theEvaluationContext) {
        this.myEngine.setHostServices(new FHIRPathEngine.IEvaluationContext(){

            public Base resolveConstant(Object appContext, String name) throws PathEngineException {
                return null;
            }

            public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
                return null;
            }

            public boolean log(String argument, List<Base> focus) {
                return false;
            }

            public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
                return null;
            }

            public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
                return null;
            }

            public List<Base> executeFunction(Object appContext, String functionName, List<List<Base>> parameters) {
                return null;
            }

            public Base resolveReference(Object appContext, String theUrl) throws FHIRException {
                return (Base)theEvaluationContext.resolveReference((IIdType)new IdType(theUrl), null);
            }
        });
    }
}

