/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider.dstu2hl7org;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.Bundle;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class Dstu2Hl7OrgBundleFactory
implements IVersionSpecificBundleFactory {
    private String myBase;
    private Bundle myBundle;
    private FhirContext myContext;

    public Dstu2Hl7OrgBundleFactory(FhirContext theContext) {
        this.myContext = theContext;
    }

    private void addResourcesForSearch(List<? extends IBaseResource> theResult) {
        ArrayList includedResources = new ArrayList();
        HashSet<IIdType> addedResourceIds = new HashSet<IIdType>();
        for (IBaseResource iBaseResource : theResult) {
            if (iBaseResource.getIdElement().isEmpty()) continue;
            addedResourceIds.add(iBaseResource.getIdElement());
        }
        for (IBaseResource iBaseResource : theResult) {
            IDomainResource next = (IDomainResource)iBaseResource;
            HashSet<String> containedIds = new HashSet<String>();
            for (IBaseResource nextContained : next.getContained()) {
                if (nextContained.getIdElement().isEmpty()) continue;
                containedIds.add(nextContained.getIdElement().getValue());
            }
            ArrayList references = this.myContext.newTerser().getAllPopulatedChildElementsOfType((IBaseResource)next, IBaseReference.class);
            do {
                ArrayList<IBaseResource> addedResourcesThisPass = new ArrayList<IBaseResource>();
                for (IBaseReference nextRef : references) {
                    IBaseResource nextRes = nextRef.getResource();
                    if (nextRes == null || !nextRes.getIdElement().hasIdPart() || containedIds.contains(nextRes.getIdElement().getValue())) continue;
                    IIdType id = nextRes.getIdElement();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition(nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                references = new ArrayList();
                for (IBaseResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllPopulatedChildElementsOfType(iResource, IBaseReference.class);
                    references.addAll(newReferences);
                }
                includedResources.addAll(addedResourcesThisPass);
            } while (!references.isEmpty());
            Bundle.BundleEntryComponent entry = this.myBundle.addEntry().setResource((Resource)next);
            this.populateBundleEntryFullUrl((IBaseResource)next, entry);
        }
        for (IBaseResource iBaseResource : includedResources) {
            Bundle.BundleEntryComponent entry = this.myBundle.addEntry();
            entry.setResource((Resource)iBaseResource).getSearch().setMode(Bundle.SearchEntryMode.INCLUDE);
            this.populateBundleEntryFullUrl(iBaseResource, entry);
        }
    }

    public void addResourcesToBundle(List<IBaseResource> theResult, BundleTypeEnum theBundleType, String theServerBase, BundleInclusionRule theBundleInclusionRule, Set<Include> theIncludes) {
        this.ensureBundle();
        ArrayList includedResources = new ArrayList();
        HashSet<IIdType> addedResourceIds = new HashSet<IIdType>();
        for (IBaseResource next : theResult) {
            if (next.getIdElement().isEmpty()) continue;
            addedResourceIds.add(next.getIdElement());
        }
        for (IBaseResource next : theResult) {
            List contained;
            if (next instanceof IDomainResource) {
                IDomainResource nextDomain = (IDomainResource)next;
                contained = nextDomain.getContained();
            } else {
                contained = Collections.emptyList();
            }
            HashSet<String> containedIds = new HashSet<String>();
            for (IAnyResource nextContained : contained) {
                if (nextContained.getId().isEmpty()) continue;
                containedIds.add(nextContained.getIdElement().getValue());
            }
            ArrayList references = this.myContext.newTerser().getAllResourceReferences(next);
            do {
                ArrayList<IBaseResource> addedResourcesThisPass = new ArrayList<IBaseResource>();
                for (ResourceReferenceInfo nextRefInfo : references) {
                    IBaseResource nextRes;
                    if (!theBundleInclusionRule.shouldIncludeReferencedResource(nextRefInfo, theIncludes) || (nextRes = nextRefInfo.getResourceReference().getResource()) == null || !nextRes.getIdElement().hasIdPart() || containedIds.contains(nextRes.getIdElement().getValue())) continue;
                    IdType id = (IdType)nextRes.getIdElement();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition(nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                includedResources.addAll(addedResourcesThisPass);
                references = new ArrayList();
                for (IBaseResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllResourceReferences(iResource);
                    references.addAll(newReferences);
                }
            } while (!references.isEmpty());
            Bundle.BundleEntryComponent entry = this.myBundle.addEntry().setResource((Resource)next);
            this.populateBundleEntryFullUrl(next, entry);
        }
        for (IBaseResource next : includedResources) {
            this.myBundle.addEntry().setResource((Resource)next).getSearch().setMode(Bundle.SearchEntryMode.INCLUDE);
        }
    }

    public void addRootPropertiesToBundle(String theId, String theServerBase, String theLinkSelf, String theLinkPrev, String theLinkNext, Integer theTotalResults, BundleTypeEnum theBundleType, IPrimitiveType<Date> theLastUpdated) {
        this.ensureBundle();
        if (this.myBundle.getIdElement().isEmpty()) {
            this.myBundle.setId(theId);
        }
        if (StringUtils.isBlank((CharSequence)this.myBundle.getId())) {
            this.myBundle.setId(UUID.randomUUID().toString());
        }
        if (this.myBundle.getMeta().getLastUpdated() == null) {
            InstantType instantType = new InstantType();
            instantType.setValueAsString(theLastUpdated.getValueAsString());
            this.myBundle.getMeta().setLastUpdatedElement(instantType);
        }
        if (!this.hasLink("self", this.myBundle) && StringUtils.isNotBlank((CharSequence)theLinkSelf)) {
            this.myBundle.addLink().setRelation("self").setUrl(theLinkSelf);
        }
        if (!this.hasLink("next", this.myBundle) && StringUtils.isNotBlank((CharSequence)theLinkNext)) {
            this.myBundle.addLink().setRelation("next").setUrl(theLinkNext);
        }
        if (!this.hasLink("self", this.myBundle) && StringUtils.isNotBlank((CharSequence)theLinkPrev)) {
            this.myBundle.addLink().setRelation("previous").setUrl(theLinkPrev);
        }
        this.myBase = theServerBase;
        if (this.myBundle.getTypeElement().isEmpty() && theBundleType != null) {
            this.myBundle.getTypeElement().setValueAsString(theBundleType.getCode());
        }
        if (this.myBundle.getTotalElement().isEmpty() && theTotalResults != null) {
            this.myBundle.getTotalElement().setValue(theTotalResults);
        }
    }

    private void ensureBundle() {
        if (this.myBundle == null) {
            this.myBundle = new Bundle();
        }
    }

    public IBaseResource getResourceBundle() {
        return this.myBundle;
    }

    private boolean hasLink(String theLinkType, Bundle theBundle) {
        for (Bundle.BundleLinkComponent next : theBundle.getLink()) {
            if (!theLinkType.equals(next.getRelation())) continue;
            return true;
        }
        return false;
    }

    public void initializeBundleFromResourceList(String theAuthor, List<? extends IBaseResource> theResources, String theServerBase, String theCompleteUrl, int theTotalResults, BundleTypeEnum theBundleType) {
        this.ensureBundle();
        this.myBundle.setId(UUID.randomUUID().toString());
        this.myBundle.getMeta().setLastUpdatedElement(InstantType.withCurrentTime());
        this.myBundle.addLink().setRelation("fhir-base").setUrl(theServerBase);
        this.myBundle.addLink().setRelation("self").setUrl(theCompleteUrl);
        this.myBundle.getTypeElement().setValueAsString(theBundleType.getCode());
        if (theBundleType.equals((Object)BundleTypeEnum.TRANSACTION)) {
            Iterator<? extends IBaseResource> iterator = theResources.iterator();
            while (iterator.hasNext()) {
                IBaseResource nextBaseRes;
                IBaseResource next = nextBaseRes = iterator.next();
                Bundle.BundleEntryComponent nextEntry = this.myBundle.addEntry();
                nextEntry.setResource((Resource)next);
                if (next.getIdElement().isEmpty()) {
                    nextEntry.getRequest().setMethod(Bundle.HTTPVerb.POST);
                    continue;
                }
                nextEntry.getRequest().setMethod(Bundle.HTTPVerb.PUT);
                if (next.getIdElement().isAbsolute()) {
                    nextEntry.getRequest().setUrl(next.getIdElement().getValue());
                    continue;
                }
                String resourceType = this.myContext.getResourceDefinition(next).getName();
                nextEntry.getRequest().setUrl(new IdType(theServerBase, resourceType, next.getIdElement().getIdPart(), next.getIdElement().getVersionIdPart()).getValue());
            }
        } else {
            this.addResourcesForSearch(theResources);
        }
        this.myBundle.getTotalElement().setValue((Object)theTotalResults);
    }

    public void initializeWithBundleResource(IBaseResource theBundle) {
        this.myBundle = (Bundle)theBundle;
    }

    private void populateBundleEntryFullUrl(IBaseResource next, Bundle.BundleEntryComponent entry) {
        if (next.getIdElement().hasBaseUrl()) {
            entry.setFullUrl(next.getIdElement().toVersionless().getValue());
        } else if (StringUtils.isNotBlank((CharSequence)this.myBase) && next.getIdElement().hasIdPart()) {
            IIdType id = next.getIdElement().toVersionless();
            id = id.withServerBase(this.myBase, this.myContext.getResourceDefinition(next).getName());
            entry.setFullUrl(id.getValue());
        }
    }

    public List<IBaseResource> toListOfResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (Bundle.BundleEntryComponent next : this.myBundle.getEntry()) {
            IdType id;
            String resourceType;
            if (next.getResource() != null) {
                retVal.add((IBaseResource)next.getResource());
                continue;
            }
            if (next.getResponse().getLocationElement().isEmpty() || !StringUtils.isNotBlank((CharSequence)(resourceType = (id = new IdType(next.getResponse().getLocation())).getResourceType()))) continue;
            IBaseResource res = (IBaseResource)this.myContext.getResourceDefinition(resourceType).newInstance();
            res.setId((IIdType)id);
            retVal.add(res);
        }
        return retVal;
    }
}

