/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Annotation;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.ElementDefinition;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.MarkdownType;
import org.hl7.fhir.instance.model.Meta;
import org.hl7.fhir.instance.model.Money;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.PositiveIntType;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Signature;
import org.hl7.fhir.instance.model.SimpleQuantity;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.TimeType;
import org.hl7.fhir.instance.model.Timing;
import org.hl7.fhir.instance.model.UnsignedIntType;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class Base
implements Serializable,
IBase {
    private Map<String, Object> userData;
    private List<String> formatCommentsPre;
    private List<String> formatCommentsPost;

    public Object getUserData(String name) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(name);
    }

    public void setUserData(String name, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public void setUserDataINN(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public boolean hasUserData(String name) {
        if (this.userData == null) {
            return false;
        }
        return this.userData.containsKey(name);
    }

    public String getUserString(String name) {
        return (String)this.getUserData(name);
    }

    public int getUserInt(String name) {
        if (!this.hasUserData(name)) {
            return 0;
        }
        return (Integer)this.getUserData(name);
    }

    public boolean hasFormatComment() {
        return this.formatCommentsPre != null && !this.formatCommentsPre.isEmpty() || this.formatCommentsPost != null && !this.formatCommentsPost.isEmpty();
    }

    public List<String> getFormatCommentsPre() {
        if (this.formatCommentsPre == null) {
            this.formatCommentsPre = new ArrayList<String>();
        }
        return this.formatCommentsPre;
    }

    public List<String> getFormatCommentsPost() {
        if (this.formatCommentsPost == null) {
            this.formatCommentsPost = new ArrayList<String>();
        }
        return this.formatCommentsPost;
    }

    public boolean isPrimitive() {
        return false;
    }

    public String primitiveValue() {
        return null;
    }

    public abstract String fhirType();

    public boolean hasType(String ... name) {
        String t = this.fhirType();
        for (String n : name) {
            if (!n.equals(t)) continue;
            return true;
        }
        return false;
    }

    protected abstract void listChildren(List<Property> var1);

    public void setProperty(String name, Base value) throws FHIRException {
        throw new FHIRException("Attempt to set unknown property " + name);
    }

    public Base addChild(String name) throws FHIRException {
        throw new FHIRException("Attempt to add child with unknown name " + name);
    }

    public List<Property> children() {
        ArrayList<Property> result = new ArrayList<Property>();
        this.listChildren(result);
        return result;
    }

    public Property getChildByName(String name) {
        ArrayList<Property> children = new ArrayList<Property>();
        this.listChildren(children);
        for (Property c : children) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public List<Base> listChildrenByName(String name) {
        ArrayList<Property> children = new ArrayList<Property>();
        this.listChildren(children);
        if (name.equals("*")) {
            ArrayList<Base> res = new ArrayList<Base>();
            for (Property p : children) {
                res.addAll(p.getValues());
            }
            return res;
        }
        for (Property c : children) {
            if (!c.getName().equals(name) && !c.getName().equals(name + "[x]")) continue;
            return c.getValues();
        }
        return new ArrayList<Base>();
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean equalsDeep(Base other) {
        return other != null;
    }

    public boolean equalsShallow(Base other) {
        return other != null;
    }

    public static boolean compareDeep(List<? extends Base> e1, List<? extends Base> e2, boolean allowNull) {
        if (Base.noList(e1) && Base.noList(e2) && allowNull) {
            return true;
        }
        if (Base.noList(e1) || Base.noList(e2)) {
            return false;
        }
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i = 0; i < e1.size(); ++i) {
            if (Base.compareDeep(e1.get(i), e2.get(i), allowNull)) continue;
            return false;
        }
        return true;
    }

    private static boolean noList(List<? extends Base> list) {
        return list == null || list.isEmpty();
    }

    public static boolean compareDeep(Base e1, Base e2, boolean allowNull) {
        if (e1 == null && e2 == null && allowNull) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e2.isMetadataBased() && !e1.isMetadataBased()) {
            return e2.equalsDeep(e1);
        }
        return e1.equalsDeep(e2);
    }

    public static boolean compareDeep(XhtmlNode div1, XhtmlNode div2, boolean allowNull) {
        if (div1 == null && div2 == null && allowNull) {
            return true;
        }
        if (div1 == null || div2 == null) {
            return false;
        }
        return div1.equalsDeep(div2);
    }

    public static boolean compareValues(List<? extends PrimitiveType> e1, List<? extends PrimitiveType> e2, boolean allowNull) {
        if (e1 == null && e2 == null && allowNull) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i = 0; i < e1.size(); ++i) {
            if (Base.compareValues(e1.get(i), e2.get(i), allowNull)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareValues(PrimitiveType e1, PrimitiveType e2, boolean allowNull) {
        if (e1 == null && e2 == null && allowNull) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.equalsShallow(e2);
    }

    public BooleanType castToBoolean(Base b) throws FHIRException {
        if (b instanceof BooleanType) {
            return (BooleanType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Boolean");
    }

    public IntegerType castToInteger(Base b) throws FHIRException {
        if (b instanceof IntegerType) {
            return (IntegerType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Integer");
    }

    public DecimalType castToDecimal(Base b) throws FHIRException {
        if (b instanceof DecimalType) {
            return (DecimalType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Decimal");
    }

    public Base64BinaryType castToBase64Binary(Base b) throws FHIRException {
        if (b instanceof Base64BinaryType) {
            return (Base64BinaryType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Base64Binary");
    }

    public InstantType castToInstant(Base b) throws FHIRException {
        if (b instanceof InstantType) {
            return (InstantType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Instant");
    }

    public StringType castToString(Base b) throws FHIRException {
        if (b instanceof StringType) {
            return (StringType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a String");
    }

    public UriType castToUri(Base b) throws FHIRException {
        if (b instanceof UriType) {
            return (UriType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public DateType castToDate(Base b) throws FHIRException {
        if (b instanceof DateType) {
            return (DateType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Date");
    }

    public DateTimeType castToDateTime(Base b) throws FHIRException {
        if (b instanceof DateTimeType) {
            return (DateTimeType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a DateTime");
    }

    public TimeType castToTime(Base b) throws FHIRException {
        if (b instanceof TimeType) {
            return (TimeType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Time");
    }

    public CodeType castToCode(Base b) throws FHIRException {
        if (b instanceof CodeType) {
            return (CodeType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Code");
    }

    public OidType castToOid(Base b) throws FHIRException {
        if (b instanceof OidType) {
            return (OidType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Oid");
    }

    public IdType castToId(Base b) throws FHIRException {
        if (b instanceof IdType) {
            return (IdType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Id");
    }

    public UnsignedIntType castToUnsignedInt(Base b) throws FHIRException {
        if (b instanceof UnsignedIntType) {
            return (UnsignedIntType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a UnsignedInt");
    }

    public PositiveIntType castToPositiveInt(Base b) throws FHIRException {
        if (b instanceof PositiveIntType) {
            return (PositiveIntType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a PositiveInt");
    }

    public MarkdownType castToMarkdown(Base b) throws FHIRException {
        if (b instanceof MarkdownType) {
            return (MarkdownType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Markdown");
    }

    public Annotation castToAnnotation(Base b) throws FHIRException {
        if (b instanceof Annotation) {
            return (Annotation)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Annotation");
    }

    public Attachment castToAttachment(Base b) throws FHIRException {
        if (b instanceof Attachment) {
            return (Attachment)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Attachment");
    }

    public Identifier castToIdentifier(Base b) throws FHIRException {
        if (b instanceof Identifier) {
            return (Identifier)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Identifier");
    }

    public CodeableConcept castToCodeableConcept(Base b) throws FHIRException {
        if (b instanceof CodeableConcept) {
            return (CodeableConcept)b;
        }
        if (b instanceof CodeType) {
            CodeableConcept cc = new CodeableConcept();
            cc.addCoding().setCode(((CodeType)b).asStringValue());
            return cc;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a CodeableConcept");
    }

    public Coding castToCoding(Base b) throws FHIRException {
        if (b instanceof Coding) {
            return (Coding)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Coding");
    }

    public Quantity castToQuantity(Base b) throws FHIRException {
        if (b instanceof Quantity) {
            return (Quantity)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Quantity");
    }

    public Money castToMoney(Base b) throws FHIRException {
        if (b instanceof Money) {
            return (Money)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Money");
    }

    public Duration castToDuration(Base b) throws FHIRException {
        if (b instanceof Duration) {
            return (Duration)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Duration");
    }

    public SimpleQuantity castToSimpleQuantity(Base b) throws FHIRException {
        if (b instanceof SimpleQuantity) {
            return (SimpleQuantity)b;
        }
        if (b instanceof Quantity) {
            Quantity q = (Quantity)b;
            SimpleQuantity sq = new SimpleQuantity();
            sq.setValueElement(q.getValueElement());
            sq.setComparatorElement(q.getComparatorElement());
            sq.setUnitElement(q.getUnitElement());
            sq.setSystemElement(q.getSystemElement());
            sq.setCodeElement(q.getCodeElement());
            return sq;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an SimpleQuantity");
    }

    public Range castToRange(Base b) throws FHIRException {
        if (b instanceof Range) {
            return (Range)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Range");
    }

    public Period castToPeriod(Base b) throws FHIRException {
        if (b instanceof Period) {
            return (Period)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Period");
    }

    public Ratio castToRatio(Base b) throws FHIRException {
        if (b instanceof Ratio) {
            return (Ratio)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Ratio");
    }

    public SampledData castToSampledData(Base b) throws FHIRException {
        if (b instanceof SampledData) {
            return (SampledData)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a SampledData");
    }

    public Signature castToSignature(Base b) throws FHIRException {
        if (b instanceof Signature) {
            return (Signature)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Signature");
    }

    public HumanName castToHumanName(Base b) throws FHIRException {
        if (b instanceof HumanName) {
            return (HumanName)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a HumanName");
    }

    public Address castToAddress(Base b) throws FHIRException {
        if (b instanceof Address) {
            return (Address)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Address");
    }

    public ContactPoint castToContactPoint(Base b) throws FHIRException {
        if (b instanceof ContactPoint) {
            return (ContactPoint)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ContactPoint");
    }

    public Timing castToTiming(Base b) throws FHIRException {
        if (b instanceof Timing) {
            return (Timing)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Timing");
    }

    public Reference castToReference(Base b) throws FHIRException {
        if (b instanceof Reference) {
            return (Reference)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Reference");
    }

    public Meta castToMeta(Base b) throws FHIRException {
        if (b instanceof Meta) {
            return (Meta)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Meta");
    }

    public Extension castToExtension(Base b) throws FHIRException {
        if (b instanceof Extension) {
            return (Extension)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Extension");
    }

    public Resource castToResource(Base b) throws FHIRException {
        if (b instanceof Resource) {
            return (Resource)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Resource");
    }

    public Narrative castToNarrative(Base b) throws FHIRException {
        if (b instanceof Narrative) {
            return (Narrative)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Narrative");
    }

    public ElementDefinition castToElementDefinition(Base b) throws FHIRException {
        if (b instanceof ElementDefinition) {
            return (ElementDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ElementDefinition");
    }

    protected boolean isMetadataBased() {
        return false;
    }

    public static boolean equals(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }
}

