/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;

@DatatypeDef(name="code", isSpecialization=true)
public class Enumeration<T extends Enum<?>>
extends PrimitiveType<T>
implements IBaseEnumeration<T> {
    private static final long serialVersionUID = 1L;
    private EnumFactory<T> myEnumFactory;

    public Enumeration(EnumFactory<T> theEnumFactory) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
    }

    public Enumeration(EnumFactory<T> theEnumFactory, T theValue) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
        this.setValue((Object)theValue);
    }

    public Enumeration(EnumFactory<T> theEnumFactory, String theValue) {
        if (theEnumFactory == null) {
            throw new IllegalArgumentException("An enumeration factory must be provided");
        }
        this.myEnumFactory = theEnumFactory;
        this.setValueAsString(theValue);
    }

    @Override
    protected T parse(String theValue) {
        if (this.myEnumFactory != null) {
            return this.myEnumFactory.fromCode(theValue);
        }
        return null;
    }

    @Override
    protected String encode(T theValue) {
        return this.myEnumFactory.toCode(theValue);
    }

    @Override
    public Enumeration<T> copy() {
        return new Enumeration<Enum>(this.myEnumFactory, (Enum)this.getValue());
    }

    @Override
    public String fhirType() {
        return "code";
    }
}

