/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.Type;

public class ExtensionHelper {
    public static boolean hasExtension(Element element, String name) {
        if (element != null && element instanceof BackboneElement) {
            return ExtensionHelper.hasExtension((BackboneElement)element, name);
        }
        if (name == null || element == null || !element.hasExtension()) {
            return false;
        }
        for (Extension e : element.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(BackboneElement element, String name) {
        if (name == null || element == null || !element.hasExtension() && !element.hasModifierExtension()) {
            return false;
        }
        for (Extension e : element.getModifierExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return true;
        }
        for (Extension e : element.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return true;
        }
        return false;
    }

    public static Extension getExtension(Element element, String name) {
        if (element != null && element instanceof BackboneElement) {
            return ExtensionHelper.getExtension((BackboneElement)element, name);
        }
        if (name == null || element == null || !element.hasExtension()) {
            return null;
        }
        for (Extension e : element.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static Extension getExtension(BackboneElement element, String name) {
        if (name == null || element == null || !element.hasExtension()) {
            return null;
        }
        for (Extension e : element.getModifierExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        for (Extension e : element.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static void setExtension(Element element, boolean modifier, String uri, Type value) throws FHIRException {
        if (value == null) {
            if (element instanceof BackboneElement) {
                for (Extension e : ((BackboneElement)element).getModifierExtension()) {
                    if (!uri.equals(e.getUrl())) continue;
                    ((BackboneElement)element).getModifierExtension().remove(e);
                }
            }
            for (Extension e : element.getExtension()) {
                if (!uri.equals(e.getUrl())) continue;
                element.getExtension().remove(e);
            }
        } else {
            boolean found = false;
            if (element instanceof BackboneElement) {
                for (Extension e : ((BackboneElement)element).getModifierExtension()) {
                    if (!uri.equals(e.getUrl())) continue;
                    if (!modifier) {
                        throw new FHIRException("Error adding extension \"" + uri + "\": found an existing modifier extension, and the extension is not marked as a modifier");
                    }
                    e.setValue(value);
                    found = true;
                }
            }
            for (Extension e : element.getExtension()) {
                if (!uri.equals(e.getUrl())) continue;
                if (modifier) {
                    throw new FHIRException("Error adding extension \"" + uri + "\": found an existing extension, and the extension is marked as a modifier");
                }
                e.setValue(value);
                found = true;
            }
            if (!found) {
                Extension ex = new Extension().setUrl(uri).setValue(value);
                if (modifier) {
                    if (!(element instanceof BackboneElement)) {
                        throw new FHIRException("Error adding extension \"" + uri + "\": extension is marked as a modifier, but element is not a backbone element");
                    }
                    ((BackboneElement)element).getModifierExtension().add(ex);
                } else {
                    element.getExtension().add(ex);
                }
            }
        }
    }

    public static boolean hasExtensions(Element element) {
        if (element instanceof BackboneElement) {
            return element.hasExtension() || ((BackboneElement)element).hasModifierExtension();
        }
        return element.hasExtension();
    }
}

