/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.TimeType;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="HealthcareService", profile="http://hl7.org/fhir/Profile/HealthcareService")
public class HealthcareService
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifiers for this item", formalDefinition="External identifiers for this item.")
    protected List<Identifier> identifier;
    @Child(name="providedBy", type={Organization.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that provides this service", formalDefinition="The organization that provides this healthcare service.")
    protected Reference providedBy;
    protected Organization providedByTarget;
    @Child(name="serviceCategory", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Broad category of service being performed or delivered", formalDefinition="Identifies the broad category of service being performed or delivered.")
    protected CodeableConcept serviceCategory;
    @Child(name="serviceType", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific service delivered or performed", formalDefinition="A specific type of service that may be delivered or performed.")
    protected List<ServiceTypeComponent> serviceType;
    @Child(name="location", type={Location.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Location where service may be provided", formalDefinition="The location where this healthcare service may be provided.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="serviceName", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of service as presented to a consumer while searching", formalDefinition="Further description of the service as it would be presented to a consumer while searching.")
    protected StringType serviceName;
    @Child(name="comment", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional description and/or any specific issues not covered elsewhere", formalDefinition="Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.")
    protected StringType comment;
    @Child(name="extraDetails", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Extra details about the service that can't be placed in the other fields", formalDefinition="Extra details about the service that can't be placed in the other fields.")
    protected StringType extraDetails;
    @Child(name="photo", type={Attachment.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Facilitates quick identification of the service", formalDefinition="If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.")
    protected Attachment photo;
    @Child(name="telecom", type={ContactPoint.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contacts related to the healthcare service", formalDefinition="List of contacts related to this specific healthcare service.")
    protected List<ContactPoint> telecom;
    @Child(name="coverageArea", type={Location.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Location(s) service is inteded for/available to", formalDefinition="The location(s) that this service is available to (not where the service is provided).")
    protected List<Reference> coverageArea;
    protected List<Location> coverageAreaTarget;
    @Child(name="serviceProvisionCode", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Conditions under which service is available/offered", formalDefinition="The code(s) that detail the conditions under which the healthcare service is available/offered.")
    protected List<CodeableConcept> serviceProvisionCode;
    @Child(name="eligibility", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Specific eligibility requirements required to use the service", formalDefinition="Does this service have specific eligibility requirements that need to be met in order to use the service?")
    protected CodeableConcept eligibility;
    @Child(name="eligibilityNote", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the eligibility conditions for the service", formalDefinition="Describes the eligibility conditions for the service.")
    protected StringType eligibilityNote;
    @Child(name="programName", type={StringType.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Program Names that categorize the service", formalDefinition="Program Names that can be used to categorize the service.")
    protected List<StringType> programName;
    @Child(name="characteristic", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Collection of characteristics (attributes)", formalDefinition="Collection of characteristics (attributes).")
    protected List<CodeableConcept> characteristic;
    @Child(name="referralMethod", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Ways that the service accepts referrals", formalDefinition="Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.")
    protected List<CodeableConcept> referralMethod;
    @Child(name="publicKey", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="PKI Public keys to support secure communications", formalDefinition="The public part of the 'keys' allocated to an Organization by an accredited body to support secure exchange of data over the internet. To be provided by the Organization, where available.")
    protected StringType publicKey;
    @Child(name="appointmentRequired", type={BooleanType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If an appointment is required for access to this service", formalDefinition="Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.")
    protected BooleanType appointmentRequired;
    @Child(name="availableTime", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Times the Service Site is available", formalDefinition="A collection of times that the Service Site is available.")
    protected List<HealthcareServiceAvailableTimeComponent> availableTime;
    @Child(name="notAvailable", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Not available during this time due to provided reason", formalDefinition="The HealthcareService is not available during this period of time due to the provided reason.")
    protected List<HealthcareServiceNotAvailableComponent> notAvailable;
    @Child(name="availabilityExceptions", type={StringType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of availability exceptions", formalDefinition="A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.")
    protected StringType availabilityExceptions;
    private static final long serialVersionUID = 683771126L;
    @SearchParamDefinition(name="identifier", path="HealthcareService.identifier", description="External identifiers for this item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="servicecategory", path="HealthcareService.serviceCategory", description="Service Category of the Healthcare Service", type="token")
    public static final String SP_SERVICECATEGORY = "servicecategory";
    @SearchParamDefinition(name="servicetype", path="HealthcareService.serviceType.type", description="The type of service provided by this healthcare service", type="token")
    public static final String SP_SERVICETYPE = "servicetype";
    @SearchParamDefinition(name="organization", path="HealthcareService.providedBy", description="The organization that provides this Healthcare Service", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    @SearchParamDefinition(name="name", path="HealthcareService.serviceName", description="A portion of the Healthcare service name", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="programname", path="HealthcareService.programName", description="One of the Program Names serviced by this HealthcareService", type="string")
    public static final String SP_PROGRAMNAME = "programname";
    @SearchParamDefinition(name="location", path="HealthcareService.location", description="The location of the Healthcare Service", type="reference")
    public static final String SP_LOCATION = "location";
    @SearchParamDefinition(name="characteristic", path="HealthcareService.characteristic", description="One of the HealthcareService's characteristics", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";

    public HealthcareService() {
    }

    public HealthcareService(Reference location) {
        this.location = location;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public HealthcareService addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getProvidedBy() {
        if (this.providedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.providedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.providedBy = new Reference();
            }
        }
        return this.providedBy;
    }

    public boolean hasProvidedBy() {
        return this.providedBy != null && !this.providedBy.isEmpty();
    }

    public HealthcareService setProvidedBy(Reference value) {
        this.providedBy = value;
        return this;
    }

    public Organization getProvidedByTarget() {
        if (this.providedByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.providedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.providedByTarget = new Organization();
            }
        }
        return this.providedByTarget;
    }

    public HealthcareService setProvidedByTarget(Organization value) {
        this.providedByTarget = value;
        return this;
    }

    public CodeableConcept getServiceCategory() {
        if (this.serviceCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.serviceCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceCategory = new CodeableConcept();
            }
        }
        return this.serviceCategory;
    }

    public boolean hasServiceCategory() {
        return this.serviceCategory != null && !this.serviceCategory.isEmpty();
    }

    public HealthcareService setServiceCategory(CodeableConcept value) {
        this.serviceCategory = value;
        return this;
    }

    public List<ServiceTypeComponent> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<ServiceTypeComponent>();
        }
        return this.serviceType;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (ServiceTypeComponent item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ServiceTypeComponent addServiceType() {
        ServiceTypeComponent t = new ServiceTypeComponent();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<ServiceTypeComponent>();
        }
        this.serviceType.add(t);
        return t;
    }

    public HealthcareService addServiceType(ServiceTypeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<ServiceTypeComponent>();
        }
        this.serviceType.add(t);
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public HealthcareService setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public HealthcareService setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public StringType getServiceNameElement() {
        if (this.serviceName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.serviceName");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceName = new StringType();
            }
        }
        return this.serviceName;
    }

    public boolean hasServiceNameElement() {
        return this.serviceName != null && !this.serviceName.isEmpty();
    }

    public boolean hasServiceName() {
        return this.serviceName != null && !this.serviceName.isEmpty();
    }

    public HealthcareService setServiceNameElement(StringType value) {
        this.serviceName = value;
        return this;
    }

    public String getServiceName() {
        return this.serviceName == null ? null : (String)this.serviceName.getValue();
    }

    public HealthcareService setServiceName(String value) {
        if (Utilities.noString((String)value)) {
            this.serviceName = null;
        } else {
            if (this.serviceName == null) {
                this.serviceName = new StringType();
            }
            this.serviceName.setValue(value);
        }
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public HealthcareService setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public HealthcareService setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public StringType getExtraDetailsElement() {
        if (this.extraDetails == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.extraDetails");
            }
            if (Configuration.doAutoCreate()) {
                this.extraDetails = new StringType();
            }
        }
        return this.extraDetails;
    }

    public boolean hasExtraDetailsElement() {
        return this.extraDetails != null && !this.extraDetails.isEmpty();
    }

    public boolean hasExtraDetails() {
        return this.extraDetails != null && !this.extraDetails.isEmpty();
    }

    public HealthcareService setExtraDetailsElement(StringType value) {
        this.extraDetails = value;
        return this;
    }

    public String getExtraDetails() {
        return this.extraDetails == null ? null : (String)this.extraDetails.getValue();
    }

    public HealthcareService setExtraDetails(String value) {
        if (Utilities.noString((String)value)) {
            this.extraDetails = null;
        } else {
            if (this.extraDetails == null) {
                this.extraDetails = new StringType();
            }
            this.extraDetails.setValue(value);
        }
        return this;
    }

    public Attachment getPhoto() {
        if (this.photo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.photo");
            }
            if (Configuration.doAutoCreate()) {
                this.photo = new Attachment();
            }
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    public HealthcareService setPhoto(Attachment value) {
        this.photo = value;
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public HealthcareService addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public List<Reference> getCoverageArea() {
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        return this.coverageArea;
    }

    public boolean hasCoverageArea() {
        if (this.coverageArea == null) {
            return false;
        }
        for (Reference item : this.coverageArea) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCoverageArea() {
        Reference t = new Reference();
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return t;
    }

    public HealthcareService addCoverageArea(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return this;
    }

    public List<Location> getCoverageAreaTarget() {
        if (this.coverageAreaTarget == null) {
            this.coverageAreaTarget = new ArrayList<Location>();
        }
        return this.coverageAreaTarget;
    }

    public Location addCoverageAreaTarget() {
        Location r = new Location();
        if (this.coverageAreaTarget == null) {
            this.coverageAreaTarget = new ArrayList<Location>();
        }
        this.coverageAreaTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getServiceProvisionCode() {
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        return this.serviceProvisionCode;
    }

    public boolean hasServiceProvisionCode() {
        if (this.serviceProvisionCode == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceProvisionCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceProvisionCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        this.serviceProvisionCode.add(t);
        return t;
    }

    public HealthcareService addServiceProvisionCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        this.serviceProvisionCode.add(t);
        return this;
    }

    public CodeableConcept getEligibility() {
        if (this.eligibility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.eligibility");
            }
            if (Configuration.doAutoCreate()) {
                this.eligibility = new CodeableConcept();
            }
        }
        return this.eligibility;
    }

    public boolean hasEligibility() {
        return this.eligibility != null && !this.eligibility.isEmpty();
    }

    public HealthcareService setEligibility(CodeableConcept value) {
        this.eligibility = value;
        return this;
    }

    public StringType getEligibilityNoteElement() {
        if (this.eligibilityNote == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.eligibilityNote");
            }
            if (Configuration.doAutoCreate()) {
                this.eligibilityNote = new StringType();
            }
        }
        return this.eligibilityNote;
    }

    public boolean hasEligibilityNoteElement() {
        return this.eligibilityNote != null && !this.eligibilityNote.isEmpty();
    }

    public boolean hasEligibilityNote() {
        return this.eligibilityNote != null && !this.eligibilityNote.isEmpty();
    }

    public HealthcareService setEligibilityNoteElement(StringType value) {
        this.eligibilityNote = value;
        return this;
    }

    public String getEligibilityNote() {
        return this.eligibilityNote == null ? null : (String)this.eligibilityNote.getValue();
    }

    public HealthcareService setEligibilityNote(String value) {
        if (Utilities.noString((String)value)) {
            this.eligibilityNote = null;
        } else {
            if (this.eligibilityNote == null) {
                this.eligibilityNote = new StringType();
            }
            this.eligibilityNote.setValue(value);
        }
        return this;
    }

    public List<StringType> getProgramName() {
        if (this.programName == null) {
            this.programName = new ArrayList<StringType>();
        }
        return this.programName;
    }

    public boolean hasProgramName() {
        if (this.programName == null) {
            return false;
        }
        for (StringType item : this.programName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addProgramNameElement() {
        StringType t = new StringType();
        if (this.programName == null) {
            this.programName = new ArrayList<StringType>();
        }
        this.programName.add(t);
        return t;
    }

    public HealthcareService addProgramName(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.programName == null) {
            this.programName = new ArrayList<StringType>();
        }
        this.programName.add(t);
        return this;
    }

    public boolean hasProgramName(String value) {
        if (this.programName == null) {
            return false;
        }
        for (StringType v : this.programName) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeableConcept> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        return this.characteristic;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return t;
    }

    public HealthcareService addCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return this;
    }

    public List<CodeableConcept> getReferralMethod() {
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        return this.referralMethod;
    }

    public boolean hasReferralMethod() {
        if (this.referralMethod == null) {
            return false;
        }
        for (CodeableConcept item : this.referralMethod) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReferralMethod() {
        CodeableConcept t = new CodeableConcept();
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        this.referralMethod.add(t);
        return t;
    }

    public HealthcareService addReferralMethod(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        this.referralMethod.add(t);
        return this;
    }

    public StringType getPublicKeyElement() {
        if (this.publicKey == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.publicKey");
            }
            if (Configuration.doAutoCreate()) {
                this.publicKey = new StringType();
            }
        }
        return this.publicKey;
    }

    public boolean hasPublicKeyElement() {
        return this.publicKey != null && !this.publicKey.isEmpty();
    }

    public boolean hasPublicKey() {
        return this.publicKey != null && !this.publicKey.isEmpty();
    }

    public HealthcareService setPublicKeyElement(StringType value) {
        this.publicKey = value;
        return this;
    }

    public String getPublicKey() {
        return this.publicKey == null ? null : (String)this.publicKey.getValue();
    }

    public HealthcareService setPublicKey(String value) {
        if (Utilities.noString((String)value)) {
            this.publicKey = null;
        } else {
            if (this.publicKey == null) {
                this.publicKey = new StringType();
            }
            this.publicKey.setValue(value);
        }
        return this;
    }

    public BooleanType getAppointmentRequiredElement() {
        if (this.appointmentRequired == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.appointmentRequired");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentRequired = new BooleanType();
            }
        }
        return this.appointmentRequired;
    }

    public boolean hasAppointmentRequiredElement() {
        return this.appointmentRequired != null && !this.appointmentRequired.isEmpty();
    }

    public boolean hasAppointmentRequired() {
        return this.appointmentRequired != null && !this.appointmentRequired.isEmpty();
    }

    public HealthcareService setAppointmentRequiredElement(BooleanType value) {
        this.appointmentRequired = value;
        return this;
    }

    public boolean getAppointmentRequired() {
        return this.appointmentRequired == null || this.appointmentRequired.isEmpty() ? false : (Boolean)this.appointmentRequired.getValue();
    }

    public HealthcareService setAppointmentRequired(boolean value) {
        if (this.appointmentRequired == null) {
            this.appointmentRequired = new BooleanType();
        }
        this.appointmentRequired.setValue((Object)value);
        return this;
    }

    public List<HealthcareServiceAvailableTimeComponent> getAvailableTime() {
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
        }
        return this.availableTime;
    }

    public boolean hasAvailableTime() {
        if (this.availableTime == null) {
            return false;
        }
        for (HealthcareServiceAvailableTimeComponent item : this.availableTime) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HealthcareServiceAvailableTimeComponent addAvailableTime() {
        HealthcareServiceAvailableTimeComponent t = new HealthcareServiceAvailableTimeComponent();
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return t;
    }

    public HealthcareService addAvailableTime(HealthcareServiceAvailableTimeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return this;
    }

    public List<HealthcareServiceNotAvailableComponent> getNotAvailable() {
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
        }
        return this.notAvailable;
    }

    public boolean hasNotAvailable() {
        if (this.notAvailable == null) {
            return false;
        }
        for (HealthcareServiceNotAvailableComponent item : this.notAvailable) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HealthcareServiceNotAvailableComponent addNotAvailable() {
        HealthcareServiceNotAvailableComponent t = new HealthcareServiceNotAvailableComponent();
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return t;
    }

    public HealthcareService addNotAvailable(HealthcareServiceNotAvailableComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return this;
    }

    public StringType getAvailabilityExceptionsElement() {
        if (this.availabilityExceptions == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.availabilityExceptions");
            }
            if (Configuration.doAutoCreate()) {
                this.availabilityExceptions = new StringType();
            }
        }
        return this.availabilityExceptions;
    }

    public boolean hasAvailabilityExceptionsElement() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public boolean hasAvailabilityExceptions() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public HealthcareService setAvailabilityExceptionsElement(StringType value) {
        this.availabilityExceptions = value;
        return this;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions == null ? null : (String)this.availabilityExceptions.getValue();
    }

    public HealthcareService setAvailabilityExceptions(String value) {
        if (Utilities.noString((String)value)) {
            this.availabilityExceptions = null;
        } else {
            if (this.availabilityExceptions == null) {
                this.availabilityExceptions = new StringType();
            }
            this.availabilityExceptions.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External identifiers for this item.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("providedBy", "Reference(Organization)", "The organization that provides this healthcare service.", 0, Integer.MAX_VALUE, this.providedBy));
        childrenList.add(new Property("serviceCategory", "CodeableConcept", "Identifies the broad category of service being performed or delivered.", 0, Integer.MAX_VALUE, this.serviceCategory));
        childrenList.add(new Property("serviceType", "", "A specific type of service that may be delivered or performed.", 0, Integer.MAX_VALUE, this.serviceType));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "The location where this healthcare service may be provided.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property("serviceName", "string", "Further description of the service as it would be presented to a consumer while searching.", 0, Integer.MAX_VALUE, this.serviceName));
        childrenList.add(new Property("comment", "string", "Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.", 0, Integer.MAX_VALUE, this.comment));
        childrenList.add(new Property("extraDetails", "string", "Extra details about the service that can't be placed in the other fields.", 0, Integer.MAX_VALUE, this.extraDetails));
        childrenList.add(new Property("photo", "Attachment", "If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.", 0, Integer.MAX_VALUE, this.photo));
        childrenList.add(new Property("telecom", "ContactPoint", "List of contacts related to this specific healthcare service.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property("coverageArea", "Reference(Location)", "The location(s) that this service is available to (not where the service is provided).", 0, Integer.MAX_VALUE, this.coverageArea));
        childrenList.add(new Property("serviceProvisionCode", "CodeableConcept", "The code(s) that detail the conditions under which the healthcare service is available/offered.", 0, Integer.MAX_VALUE, this.serviceProvisionCode));
        childrenList.add(new Property("eligibility", "CodeableConcept", "Does this service have specific eligibility requirements that need to be met in order to use the service?", 0, Integer.MAX_VALUE, this.eligibility));
        childrenList.add(new Property("eligibilityNote", "string", "Describes the eligibility conditions for the service.", 0, Integer.MAX_VALUE, this.eligibilityNote));
        childrenList.add(new Property("programName", "string", "Program Names that can be used to categorize the service.", 0, Integer.MAX_VALUE, this.programName));
        childrenList.add(new Property(SP_CHARACTERISTIC, "CodeableConcept", "Collection of characteristics (attributes).", 0, Integer.MAX_VALUE, this.characteristic));
        childrenList.add(new Property("referralMethod", "CodeableConcept", "Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.", 0, Integer.MAX_VALUE, this.referralMethod));
        childrenList.add(new Property("publicKey", "string", "The public part of the 'keys' allocated to an Organization by an accredited body to support secure exchange of data over the internet. To be provided by the Organization, where available.", 0, Integer.MAX_VALUE, this.publicKey));
        childrenList.add(new Property("appointmentRequired", "boolean", "Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.", 0, Integer.MAX_VALUE, this.appointmentRequired));
        childrenList.add(new Property("availableTime", "", "A collection of times that the Service Site is available.", 0, Integer.MAX_VALUE, this.availableTime));
        childrenList.add(new Property("notAvailable", "", "The HealthcareService is not available during this period of time due to the provided reason.", 0, Integer.MAX_VALUE, this.notAvailable));
        childrenList.add(new Property("availabilityExceptions", "string", "A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.", 0, Integer.MAX_VALUE, this.availabilityExceptions));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("providedBy")) {
            this.providedBy = this.castToReference(value);
        } else if (name.equals("serviceCategory")) {
            this.serviceCategory = this.castToCodeableConcept(value);
        } else if (name.equals("serviceType")) {
            this.getServiceType().add((ServiceTypeComponent)value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals("serviceName")) {
            this.serviceName = this.castToString(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("extraDetails")) {
            this.extraDetails = this.castToString(value);
        } else if (name.equals("photo")) {
            this.photo = this.castToAttachment(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals("coverageArea")) {
            this.getCoverageArea().add(this.castToReference(value));
        } else if (name.equals("serviceProvisionCode")) {
            this.getServiceProvisionCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("eligibility")) {
            this.eligibility = this.castToCodeableConcept(value);
        } else if (name.equals("eligibilityNote")) {
            this.eligibilityNote = this.castToString(value);
        } else if (name.equals("programName")) {
            this.getProgramName().add(this.castToString(value));
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add(this.castToCodeableConcept(value));
        } else if (name.equals("referralMethod")) {
            this.getReferralMethod().add(this.castToCodeableConcept(value));
        } else if (name.equals("publicKey")) {
            this.publicKey = this.castToString(value);
        } else if (name.equals("appointmentRequired")) {
            this.appointmentRequired = this.castToBoolean(value);
        } else if (name.equals("availableTime")) {
            this.getAvailableTime().add((HealthcareServiceAvailableTimeComponent)value);
        } else if (name.equals("notAvailable")) {
            this.getNotAvailable().add((HealthcareServiceNotAvailableComponent)value);
        } else if (name.equals("availabilityExceptions")) {
            this.availabilityExceptions = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("providedBy")) {
            this.providedBy = new Reference();
            return this.providedBy;
        }
        if (name.equals("serviceCategory")) {
            this.serviceCategory = new CodeableConcept();
            return this.serviceCategory;
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("serviceName")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.serviceName");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.comment");
        }
        if (name.equals("extraDetails")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.extraDetails");
        }
        if (name.equals("photo")) {
            this.photo = new Attachment();
            return this.photo;
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals("coverageArea")) {
            return this.addCoverageArea();
        }
        if (name.equals("serviceProvisionCode")) {
            return this.addServiceProvisionCode();
        }
        if (name.equals("eligibility")) {
            this.eligibility = new CodeableConcept();
            return this.eligibility;
        }
        if (name.equals("eligibilityNote")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.eligibilityNote");
        }
        if (name.equals("programName")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.programName");
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        if (name.equals("referralMethod")) {
            return this.addReferralMethod();
        }
        if (name.equals("publicKey")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.publicKey");
        }
        if (name.equals("appointmentRequired")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.appointmentRequired");
        }
        if (name.equals("availableTime")) {
            return this.addAvailableTime();
        }
        if (name.equals("notAvailable")) {
            return this.addNotAvailable();
        }
        if (name.equals("availabilityExceptions")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.availabilityExceptions");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "HealthcareService";
    }

    @Override
    public HealthcareService copy() {
        HealthcareService dst = new HealthcareService();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.providedBy = this.providedBy == null ? null : this.providedBy.copy();
        CodeableConcept codeableConcept = dst.serviceCategory = this.serviceCategory == null ? null : this.serviceCategory.copy();
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<ServiceTypeComponent>();
            for (ServiceTypeComponent serviceTypeComponent : this.serviceType) {
                dst.serviceType.add(serviceTypeComponent.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        dst.serviceName = this.serviceName == null ? null : this.serviceName.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.extraDetails = this.extraDetails == null ? null : this.extraDetails.copy();
        Attachment attachment = dst.photo = this.photo == null ? null : this.photo.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.coverageArea != null) {
            dst.coverageArea = new ArrayList<Reference>();
            for (Reference reference : this.coverageArea) {
                dst.coverageArea.add(reference.copy());
            }
        }
        if (this.serviceProvisionCode != null) {
            dst.serviceProvisionCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.serviceProvisionCode) {
                dst.serviceProvisionCode.add(codeableConcept2.copy());
            }
        }
        dst.eligibility = this.eligibility == null ? null : this.eligibility.copy();
        StringType stringType = dst.eligibilityNote = this.eligibilityNote == null ? null : this.eligibilityNote.copy();
        if (this.programName != null) {
            dst.programName = new ArrayList<StringType>();
            for (StringType stringType2 : this.programName) {
                dst.programName.add(stringType2.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.characteristic) {
                dst.characteristic.add(codeableConcept3.copy());
            }
        }
        if (this.referralMethod != null) {
            dst.referralMethod = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.referralMethod) {
                dst.referralMethod.add(codeableConcept4.copy());
            }
        }
        dst.publicKey = this.publicKey == null ? null : this.publicKey.copy();
        BooleanType booleanType = dst.appointmentRequired = this.appointmentRequired == null ? null : this.appointmentRequired.copy();
        if (this.availableTime != null) {
            dst.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
            for (HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : this.availableTime) {
                dst.availableTime.add(healthcareServiceAvailableTimeComponent.copy());
            }
        }
        if (this.notAvailable != null) {
            dst.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
            for (HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : this.notAvailable) {
                dst.notAvailable.add(healthcareServiceNotAvailableComponent.copy());
            }
        }
        dst.availabilityExceptions = this.availabilityExceptions == null ? null : this.availabilityExceptions.copy();
        return dst;
    }

    protected HealthcareService typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof HealthcareService)) {
            return false;
        }
        HealthcareService o = (HealthcareService)other;
        return HealthcareService.compareDeep(this.identifier, o.identifier, true) && HealthcareService.compareDeep(this.providedBy, o.providedBy, true) && HealthcareService.compareDeep(this.serviceCategory, o.serviceCategory, true) && HealthcareService.compareDeep(this.serviceType, o.serviceType, true) && HealthcareService.compareDeep(this.location, o.location, true) && HealthcareService.compareDeep(this.serviceName, o.serviceName, true) && HealthcareService.compareDeep(this.comment, o.comment, true) && HealthcareService.compareDeep(this.extraDetails, o.extraDetails, true) && HealthcareService.compareDeep(this.photo, o.photo, true) && HealthcareService.compareDeep(this.telecom, o.telecom, true) && HealthcareService.compareDeep(this.coverageArea, o.coverageArea, true) && HealthcareService.compareDeep(this.serviceProvisionCode, o.serviceProvisionCode, true) && HealthcareService.compareDeep(this.eligibility, o.eligibility, true) && HealthcareService.compareDeep(this.eligibilityNote, o.eligibilityNote, true) && HealthcareService.compareDeep(this.programName, o.programName, true) && HealthcareService.compareDeep(this.characteristic, o.characteristic, true) && HealthcareService.compareDeep(this.referralMethod, o.referralMethod, true) && HealthcareService.compareDeep(this.publicKey, o.publicKey, true) && HealthcareService.compareDeep(this.appointmentRequired, o.appointmentRequired, true) && HealthcareService.compareDeep(this.availableTime, o.availableTime, true) && HealthcareService.compareDeep(this.notAvailable, o.notAvailable, true) && HealthcareService.compareDeep(this.availabilityExceptions, o.availabilityExceptions, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof HealthcareService)) {
            return false;
        }
        HealthcareService o = (HealthcareService)other;
        return HealthcareService.compareValues(this.serviceName, o.serviceName, true) && HealthcareService.compareValues(this.comment, o.comment, true) && HealthcareService.compareValues(this.extraDetails, o.extraDetails, true) && HealthcareService.compareValues(this.eligibilityNote, o.eligibilityNote, true) && HealthcareService.compareValues(this.programName, o.programName, true) && HealthcareService.compareValues(this.publicKey, o.publicKey, true) && HealthcareService.compareValues(this.appointmentRequired, o.appointmentRequired, true) && HealthcareService.compareValues(this.availabilityExceptions, o.availabilityExceptions, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.providedBy != null && !this.providedBy.isEmpty() || this.serviceCategory != null && !this.serviceCategory.isEmpty() || this.serviceType != null && !this.serviceType.isEmpty() || this.location != null && !this.location.isEmpty() || this.serviceName != null && !this.serviceName.isEmpty() || this.comment != null && !this.comment.isEmpty() || this.extraDetails != null && !this.extraDetails.isEmpty() || this.photo != null && !this.photo.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.coverageArea != null && !this.coverageArea.isEmpty() || this.serviceProvisionCode != null && !this.serviceProvisionCode.isEmpty() || this.eligibility != null && !this.eligibility.isEmpty() || this.eligibilityNote != null && !this.eligibilityNote.isEmpty() || this.programName != null && !this.programName.isEmpty() || this.characteristic != null && !this.characteristic.isEmpty() || this.referralMethod != null && !this.referralMethod.isEmpty() || this.publicKey != null && !this.publicKey.isEmpty() || this.appointmentRequired != null && !this.appointmentRequired.isEmpty() || this.availableTime != null && !this.availableTime.isEmpty() || this.notAvailable != null && !this.notAvailable.isEmpty() || this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.HealthcareService;
    }

    @Block
    public static class HealthcareServiceNotAvailableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason presented to the user explaining why time not available", formalDefinition="The reason that can be presented to the user as to why this time is not available.")
        protected StringType description;
        @Child(name="during", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service not availablefrom this date", formalDefinition="Service is not available (seasonally or for a public holiday) from this date.")
        protected Period during;
        private static final long serialVersionUID = 310849929L;

        public HealthcareServiceNotAvailableComponent() {
        }

        public HealthcareServiceNotAvailableComponent(StringType description) {
            this.description = description;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceNotAvailableComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public HealthcareServiceNotAvailableComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public HealthcareServiceNotAvailableComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public Period getDuring() {
            if (this.during == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceNotAvailableComponent.during");
                }
                if (Configuration.doAutoCreate()) {
                    this.during = new Period();
                }
            }
            return this.during;
        }

        public boolean hasDuring() {
            return this.during != null && !this.during.isEmpty();
        }

        public HealthcareServiceNotAvailableComponent setDuring(Period value) {
            this.during = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("description", "string", "The reason that can be presented to the user as to why this time is not available.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("during", "Period", "Service is not available (seasonally or for a public holiday) from this date.", 0, Integer.MAX_VALUE, this.during));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("during")) {
                this.during = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.description");
            }
            if (name.equals("during")) {
                this.during = new Period();
                return this.during;
            }
            return super.addChild(name);
        }

        @Override
        public HealthcareServiceNotAvailableComponent copy() {
            HealthcareServiceNotAvailableComponent dst = new HealthcareServiceNotAvailableComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.during = this.during == null ? null : this.during.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof HealthcareServiceNotAvailableComponent)) {
                return false;
            }
            HealthcareServiceNotAvailableComponent o = (HealthcareServiceNotAvailableComponent)other;
            return HealthcareServiceNotAvailableComponent.compareDeep(this.description, o.description, true) && HealthcareServiceNotAvailableComponent.compareDeep(this.during, o.during, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof HealthcareServiceNotAvailableComponent)) {
                return false;
            }
            HealthcareServiceNotAvailableComponent o = (HealthcareServiceNotAvailableComponent)other;
            return HealthcareServiceNotAvailableComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.description != null && !this.description.isEmpty() || this.during != null && !this.during.isEmpty());
        }

        @Override
        public String fhirType() {
            return "HealthcareService.notAvailable";
        }
    }

    @Block
    public static class HealthcareServiceAvailableTimeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="daysOfWeek", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="mon | tue | wed | thu | fri | sat | sun", formalDefinition="Indicates which days of the week are available between the start and end Times.")
        protected List<Enumeration<DaysOfWeek>> daysOfWeek;
        @Child(name="allDay", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Always available? e.g. 24 hour service", formalDefinition="Is this always available? (hence times are irrelevant) e.g. 24 hour service.")
        protected BooleanType allDay;
        @Child(name="availableStartTime", type={TimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Opening time of day (ignored if allDay = true)", formalDefinition="The opening time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableStartTime;
        @Child(name="availableEndTime", type={TimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Closing time of day (ignored if allDay = true)", formalDefinition="The closing time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableEndTime;
        private static final long serialVersionUID = -2139510127L;

        public List<Enumeration<DaysOfWeek>> getDaysOfWeek() {
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            return this.daysOfWeek;
        }

        public boolean hasDaysOfWeek() {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<DaysOfWeek> item : this.daysOfWeek) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<DaysOfWeek> addDaysOfWeekElement() {
            Enumeration<DaysOfWeek> t = new Enumeration<DaysOfWeek>(new DaysOfWeekEnumFactory());
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return t;
        }

        public HealthcareServiceAvailableTimeComponent addDaysOfWeek(DaysOfWeek value) {
            Enumeration<DaysOfWeek> t = new Enumeration<DaysOfWeek>(new DaysOfWeekEnumFactory());
            t.setValue((Object)value);
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return this;
        }

        public boolean hasDaysOfWeek(DaysOfWeek value) {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<DaysOfWeek> v : this.daysOfWeek) {
                if (!v.equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public BooleanType getAllDayElement() {
            if (this.allDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceAvailableTimeComponent.allDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.allDay = new BooleanType();
                }
            }
            return this.allDay;
        }

        public boolean hasAllDayElement() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public boolean hasAllDay() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public HealthcareServiceAvailableTimeComponent setAllDayElement(BooleanType value) {
            this.allDay = value;
            return this;
        }

        public boolean getAllDay() {
            return this.allDay == null || this.allDay.isEmpty() ? false : (Boolean)this.allDay.getValue();
        }

        public HealthcareServiceAvailableTimeComponent setAllDay(boolean value) {
            if (this.allDay == null) {
                this.allDay = new BooleanType();
            }
            this.allDay.setValue((Object)value);
            return this;
        }

        public TimeType getAvailableStartTimeElement() {
            if (this.availableStartTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceAvailableTimeComponent.availableStartTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableStartTime = new TimeType();
                }
            }
            return this.availableStartTime;
        }

        public boolean hasAvailableStartTimeElement() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public boolean hasAvailableStartTime() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableStartTimeElement(TimeType value) {
            this.availableStartTime = value;
            return this;
        }

        public String getAvailableStartTime() {
            return this.availableStartTime == null ? null : (String)this.availableStartTime.getValue();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableStartTime(String value) {
            if (value == null) {
                this.availableStartTime = null;
            } else {
                if (this.availableStartTime == null) {
                    this.availableStartTime = new TimeType();
                }
                this.availableStartTime.setValue(value);
            }
            return this;
        }

        public TimeType getAvailableEndTimeElement() {
            if (this.availableEndTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceAvailableTimeComponent.availableEndTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableEndTime = new TimeType();
                }
            }
            return this.availableEndTime;
        }

        public boolean hasAvailableEndTimeElement() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public boolean hasAvailableEndTime() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableEndTimeElement(TimeType value) {
            this.availableEndTime = value;
            return this;
        }

        public String getAvailableEndTime() {
            return this.availableEndTime == null ? null : (String)this.availableEndTime.getValue();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableEndTime(String value) {
            if (value == null) {
                this.availableEndTime = null;
            } else {
                if (this.availableEndTime == null) {
                    this.availableEndTime = new TimeType();
                }
                this.availableEndTime.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("daysOfWeek", "code", "Indicates which days of the week are available between the start and end Times.", 0, Integer.MAX_VALUE, this.daysOfWeek));
            childrenList.add(new Property("allDay", "boolean", "Is this always available? (hence times are irrelevant) e.g. 24 hour service.", 0, Integer.MAX_VALUE, this.allDay));
            childrenList.add(new Property("availableStartTime", "time", "The opening time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, Integer.MAX_VALUE, this.availableStartTime));
            childrenList.add(new Property("availableEndTime", "time", "The closing time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, Integer.MAX_VALUE, this.availableEndTime));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                this.getDaysOfWeek().add(new DaysOfWeekEnumFactory().fromType(value));
            } else if (name.equals("allDay")) {
                this.allDay = this.castToBoolean(value);
            } else if (name.equals("availableStartTime")) {
                this.availableStartTime = this.castToTime(value);
            } else if (name.equals("availableEndTime")) {
                this.availableEndTime = this.castToTime(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.daysOfWeek");
            }
            if (name.equals("allDay")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.allDay");
            }
            if (name.equals("availableStartTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.availableStartTime");
            }
            if (name.equals("availableEndTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.availableEndTime");
            }
            return super.addChild(name);
        }

        @Override
        public HealthcareServiceAvailableTimeComponent copy() {
            HealthcareServiceAvailableTimeComponent dst = new HealthcareServiceAvailableTimeComponent();
            this.copyValues(dst);
            if (this.daysOfWeek != null) {
                dst.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
                for (Enumeration<DaysOfWeek> i : this.daysOfWeek) {
                    dst.daysOfWeek.add((Enumeration<DaysOfWeek>)i.copy());
                }
            }
            dst.allDay = this.allDay == null ? null : this.allDay.copy();
            dst.availableStartTime = this.availableStartTime == null ? null : this.availableStartTime.copy();
            dst.availableEndTime = this.availableEndTime == null ? null : this.availableEndTime.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof HealthcareServiceAvailableTimeComponent)) {
                return false;
            }
            HealthcareServiceAvailableTimeComponent o = (HealthcareServiceAvailableTimeComponent)other;
            return HealthcareServiceAvailableTimeComponent.compareDeep(this.daysOfWeek, o.daysOfWeek, true) && HealthcareServiceAvailableTimeComponent.compareDeep(this.allDay, o.allDay, true) && HealthcareServiceAvailableTimeComponent.compareDeep(this.availableStartTime, o.availableStartTime, true) && HealthcareServiceAvailableTimeComponent.compareDeep(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof HealthcareServiceAvailableTimeComponent)) {
                return false;
            }
            HealthcareServiceAvailableTimeComponent o = (HealthcareServiceAvailableTimeComponent)other;
            return HealthcareServiceAvailableTimeComponent.compareValues(this.daysOfWeek, o.daysOfWeek, true) && HealthcareServiceAvailableTimeComponent.compareValues(this.allDay, o.allDay, true) && HealthcareServiceAvailableTimeComponent.compareValues(this.availableStartTime, o.availableStartTime, true) && HealthcareServiceAvailableTimeComponent.compareValues(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.daysOfWeek != null && !this.daysOfWeek.isEmpty() || this.allDay != null && !this.allDay.isEmpty() || this.availableStartTime != null && !this.availableStartTime.isEmpty() || this.availableEndTime != null && !this.availableEndTime.isEmpty());
        }

        @Override
        public String fhirType() {
            return "HealthcareService.availableTime";
        }
    }

    @Block
    public static class ServiceTypeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of service delivered or performed", formalDefinition="The specific type of service being delivered or performed.")
        protected CodeableConcept type;
        @Child(name="specialty", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Specialties handled by the Service Site", formalDefinition="Collection of specialties handled by the service site. This is more of a medical term.")
        protected List<CodeableConcept> specialty;
        private static final long serialVersionUID = 1703986174L;

        public ServiceTypeComponent() {
        }

        public ServiceTypeComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ServiceTypeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ServiceTypeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getSpecialty() {
            if (this.specialty == null) {
                this.specialty = new ArrayList<CodeableConcept>();
            }
            return this.specialty;
        }

        public boolean hasSpecialty() {
            if (this.specialty == null) {
                return false;
            }
            for (CodeableConcept item : this.specialty) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialty() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialty == null) {
                this.specialty = new ArrayList<CodeableConcept>();
            }
            this.specialty.add(t);
            return t;
        }

        public ServiceTypeComponent addSpecialty(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialty == null) {
                this.specialty = new ArrayList<CodeableConcept>();
            }
            this.specialty.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "The specific type of service being delivered or performed.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("specialty", "CodeableConcept", "Collection of specialties handled by the service site. This is more of a medical term.", 0, Integer.MAX_VALUE, this.specialty));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("specialty")) {
                this.getSpecialty().add(this.castToCodeableConcept(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("specialty")) {
                return this.addSpecialty();
            }
            return super.addChild(name);
        }

        @Override
        public ServiceTypeComponent copy() {
            ServiceTypeComponent dst = new ServiceTypeComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.specialty != null) {
                dst.specialty = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.specialty) {
                    dst.specialty.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ServiceTypeComponent)) {
                return false;
            }
            ServiceTypeComponent o = (ServiceTypeComponent)other;
            return ServiceTypeComponent.compareDeep(this.type, o.type, true) && ServiceTypeComponent.compareDeep(this.specialty, o.specialty, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ServiceTypeComponent)) {
                return false;
            }
            ServiceTypeComponent o = (ServiceTypeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.specialty != null && !this.specialty.isEmpty());
        }

        @Override
        public String fhirType() {
            return "HealthcareService.serviceType";
        }
    }

    public static class DaysOfWeekEnumFactory
    implements EnumFactory<DaysOfWeek> {
        @Override
        public DaysOfWeek fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return DaysOfWeek.MON;
            }
            if ("tue".equals(codeString)) {
                return DaysOfWeek.TUE;
            }
            if ("wed".equals(codeString)) {
                return DaysOfWeek.WED;
            }
            if ("thu".equals(codeString)) {
                return DaysOfWeek.THU;
            }
            if ("fri".equals(codeString)) {
                return DaysOfWeek.FRI;
            }
            if ("sat".equals(codeString)) {
                return DaysOfWeek.SAT;
            }
            if ("sun".equals(codeString)) {
                return DaysOfWeek.SUN;
            }
            throw new IllegalArgumentException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        public Enumeration<DaysOfWeek> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.MON);
            }
            if ("tue".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.TUE);
            }
            if ("wed".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.WED);
            }
            if ("thu".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.THU);
            }
            if ("fri".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.FRI);
            }
            if ("sat".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.SAT);
            }
            if ("sun".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.SUN);
            }
            throw new FHIRException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        @Override
        public String toCode(DaysOfWeek code) {
            if (code == DaysOfWeek.MON) {
                return "mon";
            }
            if (code == DaysOfWeek.TUE) {
                return "tue";
            }
            if (code == DaysOfWeek.WED) {
                return "wed";
            }
            if (code == DaysOfWeek.THU) {
                return "thu";
            }
            if (code == DaysOfWeek.FRI) {
                return "fri";
            }
            if (code == DaysOfWeek.SAT) {
                return "sat";
            }
            if (code == DaysOfWeek.SUN) {
                return "sun";
            }
            return "?";
        }
    }

    public static enum DaysOfWeek {
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT,
        SUN,
        NULL;


        public static DaysOfWeek fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return MON;
            }
            if ("tue".equals(codeString)) {
                return TUE;
            }
            if ("wed".equals(codeString)) {
                return WED;
            }
            if ("thu".equals(codeString)) {
                return THU;
            }
            if ("fri".equals(codeString)) {
                return FRI;
            }
            if ("sat".equals(codeString)) {
                return SAT;
            }
            if ("sun".equals(codeString)) {
                return SUN;
            }
            throw new FHIRException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MON: {
                    return "mon";
                }
                case TUE: {
                    return "tue";
                }
                case WED: {
                    return "wed";
                }
                case THU: {
                    return "thu";
                }
                case FRI: {
                    return "fri";
                }
                case SAT: {
                    return "sat";
                }
                case SUN: {
                    return "sun";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MON: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case TUE: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case WED: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case THU: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case FRI: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SAT: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SUN: {
                    return "http://hl7.org/fhir/days-of-week";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }
    }
}

