/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Enumerations;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.RelatedPerson;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Person", profile="http://hl7.org/fhir/Profile/Person")
public class Person
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A human identifier for this person", formalDefinition="Identifier for a person within a particular scope.")
    protected List<Identifier> identifier;
    @Child(name="name", type={HumanName.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the person.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
    protected List<ContactPoint> telecom;
    @Child(name="gender", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender.")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date on which the person was born", formalDefinition="The birth date for the person.")
    protected DateType birthDate;
    @Child(name="address", type={Address.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="One or more addresses for the person", formalDefinition="One or more addresses for the person.")
    protected List<Address> address;
    @Child(name="photo", type={Attachment.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the person", formalDefinition="An image that can be displayed as a thumbnail of the person to enhance the identification of the individual.")
    protected Attachment photo;
    @Child(name="managingOrganization", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The organization that is the custodian of the person record", formalDefinition="The organization that is the custodian of the person record.")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="active", type={BooleanType.class}, order=8, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="This person's record is in active use", formalDefinition="Whether this person's record is in active use.")
    protected BooleanType active;
    @Child(name="link", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link to a resource that concerns the same actual person", formalDefinition="Link to a resource that concerns the same actual person.")
    protected List<PersonLinkComponent> link;
    private static final long serialVersionUID = -117464654L;
    @SearchParamDefinition(name="identifier", path="Person.identifier", description="A person Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="address", path="Person.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    @SearchParamDefinition(name="birthdate", path="Person.birthDate", description="The person's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    @SearchParamDefinition(name="address-state", path="Person.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESSSTATE = "address-state";
    @SearchParamDefinition(name="gender", path="Person.gender", description="The gender of the person", type="token")
    public static final String SP_GENDER = "gender";
    @SearchParamDefinition(name="practitioner", path="Person.link.target", description="The Person links to this Practitioner", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    @SearchParamDefinition(name="link", path="Person.link.target", description="Any link has this Patient, Person, RelatedPerson or Practitioner reference", type="reference")
    public static final String SP_LINK = "link";
    @SearchParamDefinition(name="relatedperson", path="Person.link.target", description="The Person links to this RelatedPerson", type="reference")
    public static final String SP_RELATEDPERSON = "relatedperson";
    @SearchParamDefinition(name="address-postalcode", path="Person.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESSPOSTALCODE = "address-postalcode";
    @SearchParamDefinition(name="address-country", path="Person.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESSCOUNTRY = "address-country";
    @SearchParamDefinition(name="phonetic", path="Person.name", description="A portion of name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    @SearchParamDefinition(name="phone", path="Person.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    @SearchParamDefinition(name="patient", path="Person.link.target", description="The Person links to this Patient", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="organization", path="Person.managingOrganization", description="The organization at which this person record is being managed", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    @SearchParamDefinition(name="name", path="Person.name", description="A portion of name in any name part", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="address-use", path="Person.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESSUSE = "address-use";
    @SearchParamDefinition(name="telecom", path="Person.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    @SearchParamDefinition(name="address-city", path="Person.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESSCITY = "address-city";
    @SearchParamDefinition(name="email", path="Person.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Person addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public Person addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Person addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Person.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public Person setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public Person setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Person.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public Person setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public Person setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Person addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Attachment getPhoto() {
        if (this.photo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Person.photo");
            }
            if (Configuration.doAutoCreate()) {
                this.photo = new Attachment();
            }
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    public Person setPhoto(Attachment value) {
        this.photo = value;
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Person.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Person setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Person.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public Person setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Person.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Person setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Person setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<PersonLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<PersonLinkComponent>();
        }
        return this.link;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (PersonLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PersonLinkComponent addLink() {
        PersonLinkComponent t = new PersonLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<PersonLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public Person addLink(PersonLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<PersonLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for a person within a particular scope.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_NAME, "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_GENDER, "code", "Administrative Gender.", 0, Integer.MAX_VALUE, this.gender));
        childrenList.add(new Property("birthDate", "date", "The birth date for the person.", 0, Integer.MAX_VALUE, this.birthDate));
        childrenList.add(new Property(SP_ADDRESS, "Address", "One or more addresses for the person.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property("photo", "Attachment", "An image that can be displayed as a thumbnail of the person to enhance the identification of the individual.", 0, Integer.MAX_VALUE, this.photo));
        childrenList.add(new Property("managingOrganization", "Reference(Organization)", "The organization that is the custodian of the person record.", 0, Integer.MAX_VALUE, this.managingOrganization));
        childrenList.add(new Property("active", "boolean", "Whether this person's record is in active use.", 0, Integer.MAX_VALUE, this.active));
        childrenList.add(new Property(SP_LINK, "", "Link to a resource that concerns the same actual person.", 0, Integer.MAX_VALUE, this.link));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.getName().add(this.castToHumanName(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_GENDER)) {
            this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
        } else if (name.equals("birthDate")) {
            this.birthDate = this.castToDate(value);
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals("photo")) {
            this.photo = this.castToAttachment(value);
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals("active")) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_LINK)) {
            this.getLink().add((PersonLinkComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Person.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Person.birthDate");
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("photo")) {
            this.photo = new Attachment();
            return this.photo;
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a primitive type Person.active");
        }
        if (name.equals(SP_LINK)) {
            return this.addLink();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Person";
    }

    @Override
    public Person copy() {
        Person dst = new Person();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        DateType dateType = dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        dst.photo = this.photo == null ? null : this.photo.copy();
        dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.link != null) {
            dst.link = new ArrayList<PersonLinkComponent>();
            for (PersonLinkComponent personLinkComponent : this.link) {
                dst.link.add(personLinkComponent.copy());
            }
        }
        return dst;
    }

    protected Person typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Person)) {
            return false;
        }
        Person o = (Person)other;
        return Person.compareDeep(this.identifier, o.identifier, true) && Person.compareDeep(this.name, o.name, true) && Person.compareDeep(this.telecom, o.telecom, true) && Person.compareDeep(this.gender, o.gender, true) && Person.compareDeep(this.birthDate, o.birthDate, true) && Person.compareDeep(this.address, o.address, true) && Person.compareDeep(this.photo, o.photo, true) && Person.compareDeep(this.managingOrganization, o.managingOrganization, true) && Person.compareDeep(this.active, o.active, true) && Person.compareDeep(this.link, o.link, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Person)) {
            return false;
        }
        Person o = (Person)other;
        return Person.compareValues(this.gender, o.gender, true) && Person.compareValues(this.birthDate, o.birthDate, true) && Person.compareValues(this.active, o.active, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.gender != null && !this.gender.isEmpty() || this.birthDate != null && !this.birthDate.isEmpty() || this.address != null && !this.address.isEmpty() || this.photo != null && !this.photo.isEmpty() || this.managingOrganization != null && !this.managingOrganization.isEmpty() || this.active != null && !this.active.isEmpty() || this.link != null && !this.link.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Person;
    }

    @Block
    public static class PersonLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="target", type={Patient.class, Practitioner.class, RelatedPerson.class, Person.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The resource to which this actual person is associated", formalDefinition="The resource to which this actual person is associated.")
        protected Reference target;
        protected Resource targetTarget;
        @Child(name="assurance", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="level1 | level2 | level3 | level4", formalDefinition="Level of assurance that this link is actually associated with the target resource.")
        protected Enumeration<IdentityAssuranceLevel> assurance;
        private static final long serialVersionUID = 508763647L;

        public PersonLinkComponent() {
        }

        public PersonLinkComponent(Reference target) {
            this.target = target;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PersonLinkComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public PersonLinkComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public Resource getTargetTarget() {
            return this.targetTarget;
        }

        public PersonLinkComponent setTargetTarget(Resource value) {
            this.targetTarget = value;
            return this;
        }

        public Enumeration<IdentityAssuranceLevel> getAssuranceElement() {
            if (this.assurance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PersonLinkComponent.assurance");
                }
                if (Configuration.doAutoCreate()) {
                    this.assurance = new Enumeration<IdentityAssuranceLevel>(new IdentityAssuranceLevelEnumFactory());
                }
            }
            return this.assurance;
        }

        public boolean hasAssuranceElement() {
            return this.assurance != null && !this.assurance.isEmpty();
        }

        public boolean hasAssurance() {
            return this.assurance != null && !this.assurance.isEmpty();
        }

        public PersonLinkComponent setAssuranceElement(Enumeration<IdentityAssuranceLevel> value) {
            this.assurance = value;
            return this;
        }

        public IdentityAssuranceLevel getAssurance() {
            return this.assurance == null ? null : (IdentityAssuranceLevel)((Object)this.assurance.getValue());
        }

        public PersonLinkComponent setAssurance(IdentityAssuranceLevel value) {
            if (value == null) {
                this.assurance = null;
            } else {
                if (this.assurance == null) {
                    this.assurance = new Enumeration<IdentityAssuranceLevel>(new IdentityAssuranceLevelEnumFactory());
                }
                this.assurance.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("target", "Reference(Patient|Practitioner|RelatedPerson|Person)", "The resource to which this actual person is associated.", 0, Integer.MAX_VALUE, this.target));
            childrenList.add(new Property("assurance", "code", "Level of assurance that this link is actually associated with the target resource.", 0, Integer.MAX_VALUE, this.assurance));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("target")) {
                this.target = this.castToReference(value);
            } else if (name.equals("assurance")) {
                this.assurance = new IdentityAssuranceLevelEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("assurance")) {
                throw new FHIRException("Cannot call addChild on a primitive type Person.assurance");
            }
            return super.addChild(name);
        }

        @Override
        public PersonLinkComponent copy() {
            PersonLinkComponent dst = new PersonLinkComponent();
            this.copyValues(dst);
            dst.target = this.target == null ? null : this.target.copy();
            dst.assurance = this.assurance == null ? null : this.assurance.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PersonLinkComponent)) {
                return false;
            }
            PersonLinkComponent o = (PersonLinkComponent)other;
            return PersonLinkComponent.compareDeep(this.target, o.target, true) && PersonLinkComponent.compareDeep(this.assurance, o.assurance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PersonLinkComponent)) {
                return false;
            }
            PersonLinkComponent o = (PersonLinkComponent)other;
            return PersonLinkComponent.compareValues(this.assurance, o.assurance, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.target != null && !this.target.isEmpty() || this.assurance != null && !this.assurance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Person.link";
        }
    }

    public static class IdentityAssuranceLevelEnumFactory
    implements EnumFactory<IdentityAssuranceLevel> {
        @Override
        public IdentityAssuranceLevel fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("level1".equals(codeString)) {
                return IdentityAssuranceLevel.LEVEL1;
            }
            if ("level2".equals(codeString)) {
                return IdentityAssuranceLevel.LEVEL2;
            }
            if ("level3".equals(codeString)) {
                return IdentityAssuranceLevel.LEVEL3;
            }
            if ("level4".equals(codeString)) {
                return IdentityAssuranceLevel.LEVEL4;
            }
            throw new IllegalArgumentException("Unknown IdentityAssuranceLevel code '" + codeString + "'");
        }

        public Enumeration<IdentityAssuranceLevel> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("level1".equals(codeString)) {
                return new Enumeration<IdentityAssuranceLevel>(this, IdentityAssuranceLevel.LEVEL1);
            }
            if ("level2".equals(codeString)) {
                return new Enumeration<IdentityAssuranceLevel>(this, IdentityAssuranceLevel.LEVEL2);
            }
            if ("level3".equals(codeString)) {
                return new Enumeration<IdentityAssuranceLevel>(this, IdentityAssuranceLevel.LEVEL3);
            }
            if ("level4".equals(codeString)) {
                return new Enumeration<IdentityAssuranceLevel>(this, IdentityAssuranceLevel.LEVEL4);
            }
            throw new FHIRException("Unknown IdentityAssuranceLevel code '" + codeString + "'");
        }

        @Override
        public String toCode(IdentityAssuranceLevel code) {
            if (code == IdentityAssuranceLevel.LEVEL1) {
                return "level1";
            }
            if (code == IdentityAssuranceLevel.LEVEL2) {
                return "level2";
            }
            if (code == IdentityAssuranceLevel.LEVEL3) {
                return "level3";
            }
            if (code == IdentityAssuranceLevel.LEVEL4) {
                return "level4";
            }
            return "?";
        }
    }

    public static enum IdentityAssuranceLevel {
        LEVEL1,
        LEVEL2,
        LEVEL3,
        LEVEL4,
        NULL;


        public static IdentityAssuranceLevel fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("level1".equals(codeString)) {
                return LEVEL1;
            }
            if ("level2".equals(codeString)) {
                return LEVEL2;
            }
            if ("level3".equals(codeString)) {
                return LEVEL3;
            }
            if ("level4".equals(codeString)) {
                return LEVEL4;
            }
            throw new FHIRException("Unknown IdentityAssuranceLevel code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LEVEL1: {
                    return "level1";
                }
                case LEVEL2: {
                    return "level2";
                }
                case LEVEL3: {
                    return "level3";
                }
                case LEVEL4: {
                    return "level4";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LEVEL1: {
                    return "http://hl7.org/fhir/identity-assuranceLevel";
                }
                case LEVEL2: {
                    return "http://hl7.org/fhir/identity-assuranceLevel";
                }
                case LEVEL3: {
                    return "http://hl7.org/fhir/identity-assuranceLevel";
                }
                case LEVEL4: {
                    return "http://hl7.org/fhir/identity-assuranceLevel";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LEVEL1: {
                    return "Little or no confidence in the asserted identity's accuracy.";
                }
                case LEVEL2: {
                    return "Some confidence in the asserted identity's accuracy.";
                }
                case LEVEL3: {
                    return "High confidence in the asserted identity's accuracy.";
                }
                case LEVEL4: {
                    return "Very high confidence in the asserted identity's accuracy.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LEVEL1: {
                    return "Level 1";
                }
                case LEVEL2: {
                    return "Level 2";
                }
                case LEVEL3: {
                    return "Level 3";
                }
                case LEVEL4: {
                    return "Level 4";
                }
            }
            return "?";
        }
    }
}

