/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Group;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.SimpleQuantity;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Specimen", profile="http://hl7.org/fhir/Profile/Specimen")
public class Specimen
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Identifier", formalDefinition="Id for specimen.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="available | unavailable | unsatisfactory | entered-in-error", formalDefinition="The availability of the specimen.")
    protected Enumeration<SpecimenStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of material that forms the specimen", formalDefinition="The kind of material that forms the specimen.")
    protected CodeableConcept type;
    @Child(name="parent", type={Specimen.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen from which this specimen originated", formalDefinition="Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.")
    protected List<Reference> parent;
    protected List<Specimen> parentTarget;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Substance.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the specimen came from. This may be from the patient(s) or from the environment or a device", formalDefinition="Where the specimen came from. This may be from the patient(s) or from the environment or a device.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="accessionIdentifier", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier assigned by the lab", formalDefinition="The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.")
    protected Identifier accessionIdentifier;
    @Child(name="receivedTime", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The time when specimen was received for processing", formalDefinition="Time when specimen was received for processing or testing.")
    protected DateTimeType receivedTime;
    @Child(name="collection", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Collection details", formalDefinition="Details concerning the specimen collection.")
    protected SpecimenCollectionComponent collection;
    @Child(name="treatment", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Treatment and processing step details", formalDefinition="Details concerning treatment and processing steps for the specimen.")
    protected List<SpecimenTreatmentComponent> treatment;
    @Child(name="container", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Direct container of specimen (tube/slide, etc.)", formalDefinition="The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.")
    protected List<SpecimenContainerComponent> container;
    private static final long serialVersionUID = 1025605602L;
    @SearchParamDefinition(name="container", path="Specimen.container.type", description="The kind of specimen container", type="token")
    public static final String SP_CONTAINER = "container";
    @SearchParamDefinition(name="identifier", path="Specimen.identifier", description="The unique identifier associated with the specimen", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="parent", path="Specimen.parent", description="The parent of the specimen", type="reference")
    public static final String SP_PARENT = "parent";
    @SearchParamDefinition(name="container-id", path="Specimen.container.identifier", description="The unique identifier associated with the specimen container", type="token")
    public static final String SP_CONTAINERID = "container-id";
    @SearchParamDefinition(name="bodysite", path="Specimen.collection.bodySite", description="The code for the body site from where the specimen originated", type="token")
    public static final String SP_BODYSITE = "bodysite";
    @SearchParamDefinition(name="subject", path="Specimen.subject", description="The subject of the specimen", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="patient", path="Specimen.subject", description="The patient the specimen comes from", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="collected", path="Specimen.collection.collected[x]", description="The date the specimen was collected", type="date")
    public static final String SP_COLLECTED = "collected";
    @SearchParamDefinition(name="accession", path="Specimen.accessionIdentifier", description="The accession number associated with the specimen", type="token")
    public static final String SP_ACCESSION = "accession";
    @SearchParamDefinition(name="type", path="Specimen.type", description="The specimen type", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="collector", path="Specimen.collection.collector", description="Who collected the specimen", type="reference")
    public static final String SP_COLLECTOR = "collector";

    public Specimen() {
    }

    public Specimen(Reference subject) {
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Specimen addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<SpecimenStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SpecimenStatus>(new SpecimenStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Specimen setStatusElement(Enumeration<SpecimenStatus> value) {
        this.status = value;
        return this;
    }

    public SpecimenStatus getStatus() {
        return this.status == null ? null : (SpecimenStatus)((Object)this.status.getValue());
    }

    public Specimen setStatus(SpecimenStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SpecimenStatus>(new SpecimenStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Specimen setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Reference> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        return this.parent;
    }

    public boolean hasParent() {
        if (this.parent == null) {
            return false;
        }
        for (Reference item : this.parent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addParent() {
        Reference t = new Reference();
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return t;
    }

    public Specimen addParent(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return this;
    }

    public List<Specimen> getParentTarget() {
        if (this.parentTarget == null) {
            this.parentTarget = new ArrayList<Specimen>();
        }
        return this.parentTarget;
    }

    public Specimen addParentTarget() {
        Specimen r = new Specimen();
        if (this.parentTarget == null) {
            this.parentTarget = new ArrayList<Specimen>();
        }
        this.parentTarget.add(r);
        return r;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Specimen setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Specimen setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Identifier getAccessionIdentifier() {
        if (this.accessionIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.accessionIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.accessionIdentifier = new Identifier();
            }
        }
        return this.accessionIdentifier;
    }

    public boolean hasAccessionIdentifier() {
        return this.accessionIdentifier != null && !this.accessionIdentifier.isEmpty();
    }

    public Specimen setAccessionIdentifier(Identifier value) {
        this.accessionIdentifier = value;
        return this;
    }

    public DateTimeType getReceivedTimeElement() {
        if (this.receivedTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.receivedTime");
            }
            if (Configuration.doAutoCreate()) {
                this.receivedTime = new DateTimeType();
            }
        }
        return this.receivedTime;
    }

    public boolean hasReceivedTimeElement() {
        return this.receivedTime != null && !this.receivedTime.isEmpty();
    }

    public boolean hasReceivedTime() {
        return this.receivedTime != null && !this.receivedTime.isEmpty();
    }

    public Specimen setReceivedTimeElement(DateTimeType value) {
        this.receivedTime = value;
        return this;
    }

    public Date getReceivedTime() {
        return this.receivedTime == null ? null : (Date)this.receivedTime.getValue();
    }

    public Specimen setReceivedTime(Date value) {
        if (value == null) {
            this.receivedTime = null;
        } else {
            if (this.receivedTime == null) {
                this.receivedTime = new DateTimeType();
            }
            this.receivedTime.setValue(value);
        }
        return this;
    }

    public SpecimenCollectionComponent getCollection() {
        if (this.collection == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.collection");
            }
            if (Configuration.doAutoCreate()) {
                this.collection = new SpecimenCollectionComponent();
            }
        }
        return this.collection;
    }

    public boolean hasCollection() {
        return this.collection != null && !this.collection.isEmpty();
    }

    public Specimen setCollection(SpecimenCollectionComponent value) {
        this.collection = value;
        return this;
    }

    public List<SpecimenTreatmentComponent> getTreatment() {
        if (this.treatment == null) {
            this.treatment = new ArrayList<SpecimenTreatmentComponent>();
        }
        return this.treatment;
    }

    public boolean hasTreatment() {
        if (this.treatment == null) {
            return false;
        }
        for (SpecimenTreatmentComponent item : this.treatment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenTreatmentComponent addTreatment() {
        SpecimenTreatmentComponent t = new SpecimenTreatmentComponent();
        if (this.treatment == null) {
            this.treatment = new ArrayList<SpecimenTreatmentComponent>();
        }
        this.treatment.add(t);
        return t;
    }

    public Specimen addTreatment(SpecimenTreatmentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.treatment == null) {
            this.treatment = new ArrayList<SpecimenTreatmentComponent>();
        }
        this.treatment.add(t);
        return this;
    }

    public List<SpecimenContainerComponent> getContainer() {
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        return this.container;
    }

    public boolean hasContainer() {
        if (this.container == null) {
            return false;
        }
        for (SpecimenContainerComponent item : this.container) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenContainerComponent addContainer() {
        SpecimenContainerComponent t = new SpecimenContainerComponent();
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        this.container.add(t);
        return t;
    }

    public Specimen addContainer(SpecimenContainerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        this.container.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Id for specimen.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("status", "code", "The availability of the specimen.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "The kind of material that forms the specimen.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_PARENT, "Reference(Specimen)", "Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.", 0, Integer.MAX_VALUE, this.parent));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Substance)", "Where the specimen came from. This may be from the patient(s) or from the environment or a device.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("accessionIdentifier", "Identifier", "The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.", 0, Integer.MAX_VALUE, this.accessionIdentifier));
        childrenList.add(new Property("receivedTime", "dateTime", "Time when specimen was received for processing or testing.", 0, Integer.MAX_VALUE, this.receivedTime));
        childrenList.add(new Property("collection", "", "Details concerning the specimen collection.", 0, Integer.MAX_VALUE, this.collection));
        childrenList.add(new Property("treatment", "", "Details concerning treatment and processing steps for the specimen.", 0, Integer.MAX_VALUE, this.treatment));
        childrenList.add(new Property(SP_CONTAINER, "", "The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.", 0, Integer.MAX_VALUE, this.container));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            this.status = new SpecimenStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PARENT)) {
            this.getParent().add(this.castToReference(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("accessionIdentifier")) {
            this.accessionIdentifier = this.castToIdentifier(value);
        } else if (name.equals("receivedTime")) {
            this.receivedTime = this.castToDateTime(value);
        } else if (name.equals("collection")) {
            this.collection = (SpecimenCollectionComponent)value;
        } else if (name.equals("treatment")) {
            this.getTreatment().add((SpecimenTreatmentComponent)value);
        } else if (name.equals(SP_CONTAINER)) {
            this.getContainer().add((SpecimenContainerComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_PARENT)) {
            return this.addParent();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("accessionIdentifier")) {
            this.accessionIdentifier = new Identifier();
            return this.accessionIdentifier;
        }
        if (name.equals("receivedTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.receivedTime");
        }
        if (name.equals("collection")) {
            this.collection = new SpecimenCollectionComponent();
            return this.collection;
        }
        if (name.equals("treatment")) {
            return this.addTreatment();
        }
        if (name.equals(SP_CONTAINER)) {
            return this.addContainer();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Specimen";
    }

    @Override
    public Specimen copy() {
        Specimen dst = new Specimen();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.parent != null) {
            dst.parent = new ArrayList<Reference>();
            for (Reference reference : this.parent) {
                dst.parent.add(reference.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.accessionIdentifier = this.accessionIdentifier == null ? null : this.accessionIdentifier.copy();
        dst.receivedTime = this.receivedTime == null ? null : this.receivedTime.copy();
        SpecimenCollectionComponent specimenCollectionComponent = dst.collection = this.collection == null ? null : this.collection.copy();
        if (this.treatment != null) {
            dst.treatment = new ArrayList<SpecimenTreatmentComponent>();
            for (SpecimenTreatmentComponent specimenTreatmentComponent : this.treatment) {
                dst.treatment.add(specimenTreatmentComponent.copy());
            }
        }
        if (this.container != null) {
            dst.container = new ArrayList<SpecimenContainerComponent>();
            for (SpecimenContainerComponent specimenContainerComponent : this.container) {
                dst.container.add(specimenContainerComponent.copy());
            }
        }
        return dst;
    }

    protected Specimen typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Specimen)) {
            return false;
        }
        Specimen o = (Specimen)other;
        return Specimen.compareDeep(this.identifier, o.identifier, true) && Specimen.compareDeep(this.status, o.status, true) && Specimen.compareDeep(this.type, o.type, true) && Specimen.compareDeep(this.parent, o.parent, true) && Specimen.compareDeep(this.subject, o.subject, true) && Specimen.compareDeep(this.accessionIdentifier, o.accessionIdentifier, true) && Specimen.compareDeep(this.receivedTime, o.receivedTime, true) && Specimen.compareDeep(this.collection, o.collection, true) && Specimen.compareDeep(this.treatment, o.treatment, true) && Specimen.compareDeep(this.container, o.container, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Specimen)) {
            return false;
        }
        Specimen o = (Specimen)other;
        return Specimen.compareValues(this.status, o.status, true) && Specimen.compareValues(this.receivedTime, o.receivedTime, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.type != null && !this.type.isEmpty() || this.parent != null && !this.parent.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.accessionIdentifier != null && !this.accessionIdentifier.isEmpty() || this.receivedTime != null && !this.receivedTime.isEmpty() || this.collection != null && !this.collection.isEmpty() || this.treatment != null && !this.treatment.isEmpty() || this.container != null && !this.container.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Specimen;
    }

    @Block
    public static class SpecimenContainerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Id for the container", formalDefinition="Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.")
        protected List<Identifier> identifier;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of the container", formalDefinition="Textual description of the container.")
        protected StringType description;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container directly associated with specimen", formalDefinition="The type of container associated with the specimen (e.g. slide, aliquot, etc.).")
        protected CodeableConcept type;
        @Child(name="capacity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container volume or size", formalDefinition="The capacity (volume or other measure) the container may contain.")
        protected SimpleQuantity capacity;
        @Child(name="specimenQuantity", type={SimpleQuantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of specimen within container", formalDefinition="The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.")
        protected SimpleQuantity specimenQuantity;
        @Child(name="additive", type={CodeableConcept.class, Substance.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        protected Type additive;
        private static final long serialVersionUID = 187274879L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public SpecimenContainerComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenContainerComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenContainerComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenContainerComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public SimpleQuantity getCapacity() {
            if (this.capacity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.capacity");
                }
                if (Configuration.doAutoCreate()) {
                    this.capacity = new SimpleQuantity();
                }
            }
            return this.capacity;
        }

        public boolean hasCapacity() {
            return this.capacity != null && !this.capacity.isEmpty();
        }

        public SpecimenContainerComponent setCapacity(SimpleQuantity value) {
            this.capacity = value;
            return this;
        }

        public SimpleQuantity getSpecimenQuantity() {
            if (this.specimenQuantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.specimenQuantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.specimenQuantity = new SimpleQuantity();
                }
            }
            return this.specimenQuantity;
        }

        public boolean hasSpecimenQuantity() {
            return this.specimenQuantity != null && !this.specimenQuantity.isEmpty();
        }

        public SpecimenContainerComponent setSpecimenQuantity(SimpleQuantity value) {
            this.specimenQuantity = value;
            return this;
        }

        public Type getAdditive() {
            return this.additive;
        }

        public CodeableConcept getAdditiveCodeableConcept() throws FHIRException {
            if (!(this.additive instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.additive;
        }

        public boolean hasAdditiveCodeableConcept() {
            return this.additive instanceof CodeableConcept;
        }

        public Reference getAdditiveReference() throws FHIRException {
            if (!(this.additive instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (Reference)this.additive;
        }

        public boolean hasAdditiveReference() {
            return this.additive instanceof Reference;
        }

        public boolean hasAdditive() {
            return this.additive != null && !this.additive.isEmpty();
        }

        public SpecimenContainerComponent setAdditive(Type value) {
            this.additive = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Specimen.SP_IDENTIFIER, "Identifier", "Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("description", "string", "Textual description of the container.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property(Specimen.SP_TYPE, "CodeableConcept", "The type of container associated with the specimen (e.g. slide, aliquot, etc.).", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("capacity", "SimpleQuantity", "The capacity (volume or other measure) the container may contain.", 0, Integer.MAX_VALUE, this.capacity));
            childrenList.add(new Property("specimenQuantity", "SimpleQuantity", "The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.", 0, Integer.MAX_VALUE, this.specimenQuantity));
            childrenList.add(new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.additive));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Specimen.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals(Specimen.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("capacity")) {
                this.capacity = this.castToSimpleQuantity(value);
            } else if (name.equals("specimenQuantity")) {
                this.specimenQuantity = this.castToSimpleQuantity(value);
            } else if (name.equals("additive[x]")) {
                this.additive = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Specimen.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.description");
            }
            if (name.equals(Specimen.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("capacity")) {
                this.capacity = new SimpleQuantity();
                return this.capacity;
            }
            if (name.equals("specimenQuantity")) {
                this.specimenQuantity = new SimpleQuantity();
                return this.specimenQuantity;
            }
            if (name.equals("additiveCodeableConcept")) {
                this.additive = new CodeableConcept();
                return this.additive;
            }
            if (name.equals("additiveReference")) {
                this.additive = new Reference();
                return this.additive;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenContainerComponent copy() {
            SpecimenContainerComponent dst = new SpecimenContainerComponent();
            this.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.capacity = this.capacity == null ? null : this.capacity.copy();
            dst.specimenQuantity = this.specimenQuantity == null ? null : this.specimenQuantity.copy();
            dst.additive = this.additive == null ? null : this.additive.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SpecimenContainerComponent)) {
                return false;
            }
            SpecimenContainerComponent o = (SpecimenContainerComponent)other;
            return SpecimenContainerComponent.compareDeep(this.identifier, o.identifier, true) && SpecimenContainerComponent.compareDeep(this.description, o.description, true) && SpecimenContainerComponent.compareDeep(this.type, o.type, true) && SpecimenContainerComponent.compareDeep(this.capacity, o.capacity, true) && SpecimenContainerComponent.compareDeep(this.specimenQuantity, o.specimenQuantity, true) && SpecimenContainerComponent.compareDeep(this.additive, o.additive, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SpecimenContainerComponent)) {
                return false;
            }
            SpecimenContainerComponent o = (SpecimenContainerComponent)other;
            return SpecimenContainerComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.description != null && !this.description.isEmpty() || this.type != null && !this.type.isEmpty() || this.capacity != null && !this.capacity.isEmpty() || this.specimenQuantity != null && !this.specimenQuantity.isEmpty() || this.additive != null && !this.additive.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Specimen.container";
        }
    }

    @Block
    public static class SpecimenTreatmentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of procedure", formalDefinition="Textual description of procedure.")
        protected StringType description;
        @Child(name="procedure", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the treatment or processing step  applied to the specimen", formalDefinition="A coded value specifying the procedure used to process the specimen.")
        protected CodeableConcept procedure;
        @Child(name="additive", type={Substance.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Material used in the processing step", formalDefinition="Material used in the processing step.")
        protected List<Reference> additive;
        protected List<Substance> additiveTarget;
        private static final long serialVersionUID = -373251521L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenTreatmentComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenTreatmentComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenTreatmentComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getProcedure() {
            if (this.procedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenTreatmentComponent.procedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.procedure = new CodeableConcept();
                }
            }
            return this.procedure;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public SpecimenTreatmentComponent setProcedure(CodeableConcept value) {
            this.procedure = value;
            return this;
        }

        public List<Reference> getAdditive() {
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            return this.additive;
        }

        public boolean hasAdditive() {
            if (this.additive == null) {
                return false;
            }
            for (Reference item : this.additive) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAdditive() {
            Reference t = new Reference();
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            this.additive.add(t);
            return t;
        }

        public SpecimenTreatmentComponent addAdditive(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            this.additive.add(t);
            return this;
        }

        public List<Substance> getAdditiveTarget() {
            if (this.additiveTarget == null) {
                this.additiveTarget = new ArrayList<Substance>();
            }
            return this.additiveTarget;
        }

        public Substance addAdditiveTarget() {
            Substance r = new Substance();
            if (this.additiveTarget == null) {
                this.additiveTarget = new ArrayList<Substance>();
            }
            this.additiveTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("description", "string", "Textual description of procedure.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("procedure", "CodeableConcept", "A coded value specifying the procedure used to process the specimen.", 0, Integer.MAX_VALUE, this.procedure));
            childrenList.add(new Property("additive", "Reference(Substance)", "Material used in the processing step.", 0, Integer.MAX_VALUE, this.additive));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("procedure")) {
                this.procedure = this.castToCodeableConcept(value);
            } else if (name.equals("additive")) {
                this.getAdditive().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.description");
            }
            if (name.equals("procedure")) {
                this.procedure = new CodeableConcept();
                return this.procedure;
            }
            if (name.equals("additive")) {
                return this.addAdditive();
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenTreatmentComponent copy() {
            SpecimenTreatmentComponent dst = new SpecimenTreatmentComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            CodeableConcept codeableConcept = dst.procedure = this.procedure == null ? null : this.procedure.copy();
            if (this.additive != null) {
                dst.additive = new ArrayList<Reference>();
                for (Reference i : this.additive) {
                    dst.additive.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SpecimenTreatmentComponent)) {
                return false;
            }
            SpecimenTreatmentComponent o = (SpecimenTreatmentComponent)other;
            return SpecimenTreatmentComponent.compareDeep(this.description, o.description, true) && SpecimenTreatmentComponent.compareDeep(this.procedure, o.procedure, true) && SpecimenTreatmentComponent.compareDeep(this.additive, o.additive, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SpecimenTreatmentComponent)) {
                return false;
            }
            SpecimenTreatmentComponent o = (SpecimenTreatmentComponent)other;
            return SpecimenTreatmentComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.description != null && !this.description.isEmpty() || this.procedure != null && !this.procedure.isEmpty() || this.additive != null && !this.additive.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Specimen.treatment";
        }
    }

    @Block
    public static class SpecimenCollectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="collector", type={Practitioner.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who collected the specimen", formalDefinition="Person who collected the specimen.")
        protected Reference collector;
        protected Practitioner collectorTarget;
        @Child(name="comment", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Collector comments", formalDefinition="To communicate any details or issues encountered during the specimen collection procedure.")
        protected List<StringType> comment;
        @Child(name="collected", type={DateTimeType.class, Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Collection time", formalDefinition="Time when specimen was collected from subject - the physiologically relevant time.")
        protected Type collected;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The quantity of specimen collected", formalDefinition="The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.")
        protected SimpleQuantity quantity;
        @Child(name="method", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Technique used to perform collection", formalDefinition="A coded value specifying the technique that is used to perform the procedure.")
        protected CodeableConcept method;
        @Child(name="bodySite", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anatomical collection site", formalDefinition="Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.")
        protected CodeableConcept bodySite;
        private static final long serialVersionUID = -1418734687L;

        public Reference getCollector() {
            if (this.collector == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.collector");
                }
                if (Configuration.doAutoCreate()) {
                    this.collector = new Reference();
                }
            }
            return this.collector;
        }

        public boolean hasCollector() {
            return this.collector != null && !this.collector.isEmpty();
        }

        public SpecimenCollectionComponent setCollector(Reference value) {
            this.collector = value;
            return this;
        }

        public Practitioner getCollectorTarget() {
            if (this.collectorTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.collector");
                }
                if (Configuration.doAutoCreate()) {
                    this.collectorTarget = new Practitioner();
                }
            }
            return this.collectorTarget;
        }

        public SpecimenCollectionComponent setCollectorTarget(Practitioner value) {
            this.collectorTarget = value;
            return this;
        }

        public List<StringType> getComment() {
            if (this.comment == null) {
                this.comment = new ArrayList<StringType>();
            }
            return this.comment;
        }

        public boolean hasComment() {
            if (this.comment == null) {
                return false;
            }
            for (StringType item : this.comment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addCommentElement() {
            StringType t = new StringType();
            if (this.comment == null) {
                this.comment = new ArrayList<StringType>();
            }
            this.comment.add(t);
            return t;
        }

        public SpecimenCollectionComponent addComment(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.comment == null) {
                this.comment = new ArrayList<StringType>();
            }
            this.comment.add(t);
            return this;
        }

        public boolean hasComment(String value) {
            if (this.comment == null) {
                return false;
            }
            for (StringType v : this.comment) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Type getCollected() {
            return this.collected;
        }

        public DateTimeType getCollectedDateTimeType() throws FHIRException {
            if (!(this.collected instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.collected;
        }

        public boolean hasCollectedDateTimeType() {
            return this.collected instanceof DateTimeType;
        }

        public Period getCollectedPeriod() throws FHIRException {
            if (!(this.collected instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (Period)this.collected;
        }

        public boolean hasCollectedPeriod() {
            return this.collected instanceof Period;
        }

        public boolean hasCollected() {
            return this.collected != null && !this.collected.isEmpty();
        }

        public SpecimenCollectionComponent setCollected(Type value) {
            this.collected = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SpecimenCollectionComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SpecimenCollectionComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public SpecimenCollectionComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Specimen.SP_COLLECTOR, "Reference(Practitioner)", "Person who collected the specimen.", 0, Integer.MAX_VALUE, this.collector));
            childrenList.add(new Property("comment", "string", "To communicate any details or issues encountered during the specimen collection procedure.", 0, Integer.MAX_VALUE, this.comment));
            childrenList.add(new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, Integer.MAX_VALUE, this.collected));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("method", "CodeableConcept", "A coded value specifying the technique that is used to perform the procedure.", 0, Integer.MAX_VALUE, this.method));
            childrenList.add(new Property("bodySite", "CodeableConcept", "Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.", 0, Integer.MAX_VALUE, this.bodySite));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Specimen.SP_COLLECTOR)) {
                this.collector = this.castToReference(value);
            } else if (name.equals("comment")) {
                this.getComment().add(this.castToString(value));
            } else if (name.equals("collected[x]")) {
                this.collected = (Type)value;
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Specimen.SP_COLLECTOR)) {
                this.collector = new Reference();
                return this.collector;
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.comment");
            }
            if (name.equals("collectedDateTime")) {
                this.collected = new DateTimeType();
                return this.collected;
            }
            if (name.equals("collectedPeriod")) {
                this.collected = new Period();
                return this.collected;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenCollectionComponent copy() {
            SpecimenCollectionComponent dst = new SpecimenCollectionComponent();
            this.copyValues(dst);
            Reference reference = dst.collector = this.collector == null ? null : this.collector.copy();
            if (this.comment != null) {
                dst.comment = new ArrayList<StringType>();
                for (StringType i : this.comment) {
                    dst.comment.add(i.copy());
                }
            }
            dst.collected = this.collected == null ? null : this.collected.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SpecimenCollectionComponent)) {
                return false;
            }
            SpecimenCollectionComponent o = (SpecimenCollectionComponent)other;
            return SpecimenCollectionComponent.compareDeep(this.collector, o.collector, true) && SpecimenCollectionComponent.compareDeep(this.comment, o.comment, true) && SpecimenCollectionComponent.compareDeep(this.collected, o.collected, true) && SpecimenCollectionComponent.compareDeep(this.quantity, o.quantity, true) && SpecimenCollectionComponent.compareDeep(this.method, o.method, true) && SpecimenCollectionComponent.compareDeep(this.bodySite, o.bodySite, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SpecimenCollectionComponent)) {
                return false;
            }
            SpecimenCollectionComponent o = (SpecimenCollectionComponent)other;
            return SpecimenCollectionComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.collector != null && !this.collector.isEmpty() || this.comment != null && !this.comment.isEmpty() || this.collected != null && !this.collected.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.method != null && !this.method.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Specimen.collection";
        }
    }

    public static class SpecimenStatusEnumFactory
    implements EnumFactory<SpecimenStatus> {
        @Override
        public SpecimenStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return SpecimenStatus.AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return SpecimenStatus.UNAVAILABLE;
            }
            if ("unsatisfactory".equals(codeString)) {
                return SpecimenStatus.UNSATISFACTORY;
            }
            if ("entered-in-error".equals(codeString)) {
                return SpecimenStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        public Enumeration<SpecimenStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.AVAILABLE);
            }
            if ("unavailable".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.UNAVAILABLE);
            }
            if ("unsatisfactory".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.UNSATISFACTORY);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenStatus code) {
            if (code == SpecimenStatus.AVAILABLE) {
                return "available";
            }
            if (code == SpecimenStatus.UNAVAILABLE) {
                return "unavailable";
            }
            if (code == SpecimenStatus.UNSATISFACTORY) {
                return "unsatisfactory";
            }
            if (code == SpecimenStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }
    }

    public static enum SpecimenStatus {
        AVAILABLE,
        UNAVAILABLE,
        UNSATISFACTORY,
        ENTEREDINERROR,
        NULL;


        public static SpecimenStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return UNAVAILABLE;
            }
            if ("unsatisfactory".equals(codeString)) {
                return UNSATISFACTORY;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case UNAVAILABLE: {
                    return "unavailable";
                }
                case UNSATISFACTORY: {
                    return "unsatisfactory";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case UNAVAILABLE: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case UNSATISFACTORY: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/specimen-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "The physical specimen is present and in good condition.";
                }
                case UNAVAILABLE: {
                    return "There is no physical specimen because it is either lost, destroyed or consumed.";
                }
                case UNSATISFACTORY: {
                    return "The specimen cannot be used because of a quality issue such as a broken container, contamination, or too old.";
                }
                case ENTEREDINERROR: {
                    return "The specimen was entered in error and therefore nullified.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case UNAVAILABLE: {
                    return "Unavailable";
                }
                case UNSATISFACTORY: {
                    return "Unsatisfactory";
                }
                case ENTEREDINERROR: {
                    return "Entered-in-error";
                }
            }
            return "?";
        }
    }
}

