/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum BindingConformance {
    REQUIRED,
    PREFERRED,
    EXAMPLE,
    NULL;


    public static BindingConformance fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("required".equals(codeString)) {
            return REQUIRED;
        }
        if ("preferred".equals(codeString)) {
            return PREFERRED;
        }
        if ("example".equals(codeString)) {
            return EXAMPLE;
        }
        throw new Exception("Unknown BindingConformance code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REQUIRED: {
                return "required";
            }
            case PREFERRED: {
                return "preferred";
            }
            case EXAMPLE: {
                return "example";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/binding-conformance";
    }

    public String getDefinition() {
        switch (this) {
            case REQUIRED: {
                return "Only codes in the specified set are allowed.  If the binding is extensible, other codes may be used for concepts not covered by the bound set of codes";
            }
            case PREFERRED: {
                return "For greater interoperability, implementers are strongly encouraged to use the bound set of codes, however alternate codes may be used in derived profiles and implementations if necessary without being considered non-conformant";
            }
            case EXAMPLE: {
                return "The codes in the set are an example to illustrate the meaning of the field. There is no particular preference for its use nor any assertion that the provided values are sufficient to meet implementation needs";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REQUIRED: {
                return "Required";
            }
            case PREFERRED: {
                return "Preferred";
            }
            case EXAMPLE: {
                return "Example";
            }
        }
        return "?";
    }
}

