/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ContractAction {
    ACTIONA,
    ACTIONB,
    NULL;


    public static ContractAction fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("action-a".equals(codeString)) {
            return ACTIONA;
        }
        if ("action-b".equals(codeString)) {
            return ACTIONB;
        }
        throw new Exception("Unknown ContractAction code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIONA: {
                return "action-a";
            }
            case ACTIONB: {
                return "action-b";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://www.hl7.org/fhir/contractaction";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIONA: {
                return "";
            }
            case ACTIONB: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIONA: {
                return "action-a";
            }
            case ACTIONB: {
                return "action-b";
            }
        }
        return "?";
    }
}

