/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ContractSubtype {
    DISCLOSURECA,
    DISCLOSUREUS,
    NULL;


    public static ContractSubtype fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("disclosure-CA".equals(codeString)) {
            return DISCLOSURECA;
        }
        if ("disclosure-US".equals(codeString)) {
            return DISCLOSUREUS;
        }
        throw new Exception("Unknown ContractSubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DISCLOSURECA: {
                return "disclosure-CA";
            }
            case DISCLOSUREUS: {
                return "disclosure-US";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contractsubtypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case DISCLOSURECA: {
                return "";
            }
            case DISCLOSUREUS: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DISCLOSURECA: {
                return "disclosure-CA";
            }
            case DISCLOSUREUS: {
                return "disclosure-US";
            }
        }
        return "?";
    }
}

