/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum GoalAcceptanceStatus {
    AGREE,
    DISAGREE,
    PENDING,
    NULL;


    public static GoalAcceptanceStatus fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("agree".equals(codeString)) {
            return AGREE;
        }
        if ("disagree".equals(codeString)) {
            return DISAGREE;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        throw new Exception("Unknown GoalAcceptanceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AGREE: {
                return "agree";
            }
            case DISAGREE: {
                return "disagree";
            }
            case PENDING: {
                return "pending";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/goal-acceptance-status";
    }

    public String getDefinition() {
        switch (this) {
            case AGREE: {
                return "Stakeholder supports pursuit of the goal";
            }
            case DISAGREE: {
                return "Stakeholder is not in support of the pursuit of the goal";
            }
            case PENDING: {
                return "Stakeholder has not yet made a decision on whether they support the goal";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AGREE: {
                return "Agree";
            }
            case DISAGREE: {
                return "Disagree";
            }
            case PENDING: {
                return "Pending";
            }
        }
        return "?";
    }
}

