/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum Icd10 {
    _123456,
    _123457,
    _987654,
    _123987,
    _112233,
    _997755,
    _321789,
    NULL;


    public static Icd10 fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("123456".equals(codeString)) {
            return _123456;
        }
        if ("123457".equals(codeString)) {
            return _123457;
        }
        if ("987654".equals(codeString)) {
            return _987654;
        }
        if ("123987".equals(codeString)) {
            return _123987;
        }
        if ("112233".equals(codeString)) {
            return _112233;
        }
        if ("997755".equals(codeString)) {
            return _997755;
        }
        if ("321789".equals(codeString)) {
            return _321789;
        }
        throw new Exception("Unknown Icd10 code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _123456: {
                return "123456";
            }
            case _123457: {
                return "123457";
            }
            case _987654: {
                return "987654";
            }
            case _123987: {
                return "123987";
            }
            case _112233: {
                return "112233";
            }
            case _997755: {
                return "997755";
            }
            case _321789: {
                return "321789";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/sid/icd-10";
    }

    public String getDefinition() {
        switch (this) {
            case _123456: {
                return "DIAG-1";
            }
            case _123457: {
                return "DIAG-1a";
            }
            case _987654: {
                return "DIAG-2";
            }
            case _123987: {
                return "DIAG-3";
            }
            case _112233: {
                return "DIAG-4";
            }
            case _997755: {
                return "DIAG-5";
            }
            case _321789: {
                return "DIAG-6";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _123456: {
                return "DIAG-1";
            }
            case _123457: {
                return "DIAG-1a";
            }
            case _987654: {
                return "DIAG-2";
            }
            case _123987: {
                return "DIAG-3";
            }
            case _112233: {
                return "DIAG-4";
            }
            case _997755: {
                return "DIAG-5";
            }
            case _321789: {
                return "DIAG-6";
            }
        }
        return "?";
    }
}

