/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum MaxOccurs {
    ASTERISK,
    NULL;


    public static MaxOccurs fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("*".equals(codeString)) {
            return ASTERISK;
        }
        throw new Exception("Unknown MaxOccurs code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ASTERISK: {
                return "*";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/max-occurs";
    }

    public String getDefinition() {
        switch (this) {
            case ASTERISK: {
                return "Element can repeat an unlimited number of times";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ASTERISK: {
                return " ";
            }
        }
        return "?";
    }
}

