/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum PaymentStatus {
    PAID,
    CLEARED,
    NULL;


    public static PaymentStatus fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("paid".equals(codeString)) {
            return PAID;
        }
        if ("cleared".equals(codeString)) {
            return CLEARED;
        }
        throw new Exception("Unknown PaymentStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PAID: {
                return "paid";
            }
            case CLEARED: {
                return "cleared";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/paymentstatus";
    }

    public String getDefinition() {
        switch (this) {
            case PAID: {
                return "";
            }
            case CLEARED: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PAID: {
                return "paid";
            }
            case CLEARED: {
                return "cleared";
            }
        }
        return "?";
    }
}

