/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum QuestionMaxOccurs {
    ASTERISK,
    NULL;


    public static QuestionMaxOccurs fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("*".equals(codeString)) {
            return ASTERISK;
        }
        throw new Exception("Unknown QuestionMaxOccurs code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ASTERISK: {
                return "*";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/question-max-occurs";
    }

    public String getDefinition() {
        switch (this) {
            case ASTERISK: {
                return "Element can repeat an unlimited number of times";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ASTERISK: {
                return "Repeating";
            }
        }
        return "?";
    }
}

