/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum QuestionnaireQuestionControl {
    AUTOCOMPLETE,
    DROPDOWN,
    CHECKBOX,
    LOOKUP,
    RADIOBUTTON,
    SLIDER,
    SPINNER,
    TEXTBOX,
    NULL;


    public static QuestionnaireQuestionControl fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("autocomplete".equals(codeString)) {
            return AUTOCOMPLETE;
        }
        if ("drop-down".equals(codeString)) {
            return DROPDOWN;
        }
        if ("check-box".equals(codeString)) {
            return CHECKBOX;
        }
        if ("lookup".equals(codeString)) {
            return LOOKUP;
        }
        if ("radio-button".equals(codeString)) {
            return RADIOBUTTON;
        }
        if ("slider".equals(codeString)) {
            return SLIDER;
        }
        if ("spinner".equals(codeString)) {
            return SPINNER;
        }
        if ("text-box".equals(codeString)) {
            return TEXTBOX;
        }
        throw new Exception("Unknown QuestionnaireQuestionControl code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AUTOCOMPLETE: {
                return "autocomplete";
            }
            case DROPDOWN: {
                return "drop-down";
            }
            case CHECKBOX: {
                return "check-box";
            }
            case LOOKUP: {
                return "lookup";
            }
            case RADIOBUTTON: {
                return "radio-button";
            }
            case SLIDER: {
                return "slider";
            }
            case SPINNER: {
                return "spinner";
            }
            case TEXTBOX: {
                return "text-box";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/questionnaire-question-control";
    }

    public String getDefinition() {
        switch (this) {
            case AUTOCOMPLETE: {
                return "A control which provides a list of potential matches based on text entered into a control.  Used for large choice sets where text-matching is an appropriate discovery mechanism.";
            }
            case DROPDOWN: {
                return "A control where an item (or multiple items) can be selected from a list that is only displayed when the user is editing the field.";
            }
            case CHECKBOX: {
                return "A control where choices are listed with a box beside them.  The box can be toggled to select or de-select a given choice.  Multiple selections may be possible.";
            }
            case LOOKUP: {
                return "A control where editing an item spawns a separate dialog box or screen permitting a user to navigate, filter or otherwise discover an appropriate match.  Useful for large choice sets where text matching is not an appropriate discovery mechanism.  Such screens must generally be tuned for the specific choice list structure.";
            }
            case RADIOBUTTON: {
                return "A control where choices are listed with a button beside them.  The button can be toggled to select or de-select a given choice.  Selecting one item deselects all others.";
            }
            case SLIDER: {
                return "A control where an axis is displayed between the high and low values and the control can be visually manipulated to select a value anywhere on the axis.";
            }
            case SPINNER: {
                return "A control where a list of numeric or other ordered values can be scrolled through via arrows.";
            }
            case TEXTBOX: {
                return "A control where a user can type in their answer freely.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AUTOCOMPLETE: {
                return "Auto-complete";
            }
            case DROPDOWN: {
                return "Drop down";
            }
            case CHECKBOX: {
                return "Check-box";
            }
            case LOOKUP: {
                return "Lookup";
            }
            case RADIOBUTTON: {
                return "Radio Button";
            }
            case SLIDER: {
                return "Slider";
            }
            case SPINNER: {
                return "Spinner";
            }
            case TEXTBOX: {
                return "Text Box";
            }
        }
        return "?";
    }
}

