/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum Ruleset {
    X124010,
    X125010,
    X127010,
    CDANETV2,
    CDANETV4,
    CPHA3,
    NULL;


    public static Ruleset fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("x12-4010".equals(codeString)) {
            return X124010;
        }
        if ("x12-5010".equals(codeString)) {
            return X125010;
        }
        if ("x12-7010".equals(codeString)) {
            return X127010;
        }
        if ("cdanet-v2".equals(codeString)) {
            return CDANETV2;
        }
        if ("cdanet-v4".equals(codeString)) {
            return CDANETV4;
        }
        if ("cpha-3".equals(codeString)) {
            return CPHA3;
        }
        throw new Exception("Unknown Ruleset code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case X124010: {
                return "x12-4010";
            }
            case X125010: {
                return "x12-5010";
            }
            case X127010: {
                return "x12-7010";
            }
            case CDANETV2: {
                return "cdanet-v2";
            }
            case CDANETV4: {
                return "cdanet-v4";
            }
            case CPHA3: {
                return "cpha-3";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ruleset";
    }

    public String getDefinition() {
        switch (this) {
            case X124010: {
                return "";
            }
            case X125010: {
                return "";
            }
            case X127010: {
                return "";
            }
            case CDANETV2: {
                return "";
            }
            case CDANETV4: {
                return "";
            }
            case CPHA3: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case X124010: {
                return "x12-4010";
            }
            case X125010: {
                return "x12-5010";
            }
            case X127010: {
                return "x12-7010";
            }
            case CDANETV2: {
                return "cdanet-v2";
            }
            case CDANETV4: {
                return "cdanet-v4";
            }
            case CPHA3: {
                return "cpha-3";
            }
        }
        return "?";
    }
}

