/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ServiceProduct {
    EXAM,
    FLUSHOT,
    NULL;


    public static ServiceProduct fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("exam".equals(codeString)) {
            return EXAM;
        }
        if ("flushot".equals(codeString)) {
            return FLUSHOT;
        }
        throw new Exception("Unknown ServiceProduct code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EXAM: {
                return "exam";
            }
            case FLUSHOT: {
                return "flushot";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-serviceproduct";
    }

    public String getDefinition() {
        switch (this) {
            case EXAM: {
                return "Exam";
            }
            case FLUSHOT: {
                return "Flu shot";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EXAM: {
                return "Exam";
            }
            case FLUSHOT: {
                return "Flu shot";
            }
        }
        return "?";
    }
}

