/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum SupplyItem {
    MEDICATION,
    DEVICE,
    NULL;


    public static SupplyItem fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medication".equals(codeString)) {
            return MEDICATION;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        throw new Exception("Unknown SupplyItem code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MEDICATION: {
                return "medication";
            }
            case DEVICE: {
                return "device";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supply-item-type";
    }

    public String getDefinition() {
        switch (this) {
            case MEDICATION: {
                return "Supply is a kind of medication.";
            }
            case DEVICE: {
                return "What is supplied (or requested) is a device";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MEDICATION: {
                return "Medication";
            }
            case DEVICE: {
                return "Device";
            }
        }
        return "?";
    }
}

