/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum SupplyrequestReason {
    PATIENTCARE,
    WARDSTOCK,
    NULL;


    public static SupplyrequestReason fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient-care".equals(codeString)) {
            return PATIENTCARE;
        }
        if ("ward-stock".equals(codeString)) {
            return WARDSTOCK;
        }
        throw new Exception("Unknown SupplyrequestReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENTCARE: {
                return "patient-care";
            }
            case WARDSTOCK: {
                return "ward-stock";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supplyrequest-reason";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENTCARE: {
                return "The supply has been requested for use in direct patient care.";
            }
            case WARDSTOCK: {
                return "The supply has been requested for for creating or replenishing ward stock.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENTCARE: {
                return "Patient Care";
            }
            case WARDSTOCK: {
                return "Ward Stock";
            }
        }
        return "?";
    }
}

