/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3AdministrativeGender {
    F,
    M,
    UN,
    NULL;


    public static V3AdministrativeGender fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("F".equals(codeString)) {
            return F;
        }
        if ("M".equals(codeString)) {
            return M;
        }
        if ("UN".equals(codeString)) {
            return UN;
        }
        throw new Exception("Unknown V3AdministrativeGender code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case F: {
                return "F";
            }
            case M: {
                return "M";
            }
            case UN: {
                return "UN";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/AdministrativeGender";
    }

    public String getDefinition() {
        switch (this) {
            case F: {
                return "Female";
            }
            case M: {
                return "Male";
            }
            case UN: {
                return "The gender of a person could not be uniquely defined as male or female, such as hermaphrodite.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case F: {
                return "Female";
            }
            case M: {
                return "Male";
            }
            case UN: {
                return "Undifferentiated";
            }
        }
        return "?";
    }
}

