/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3ContentProcessingMode {
    SEQL,
    UNOR,
    NULL;


    public static V3ContentProcessingMode fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("SEQL".equals(codeString)) {
            return SEQL;
        }
        if ("UNOR".equals(codeString)) {
            return UNOR;
        }
        throw new Exception("Unknown V3ContentProcessingMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SEQL: {
                return "SEQL";
            }
            case UNOR: {
                return "UNOR";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/ContentProcessingMode";
    }

    public String getDefinition() {
        switch (this) {
            case SEQL: {
                return "Description:The content should be processed in a sequential fashion.";
            }
            case UNOR: {
                return "Description:The content may be processed in any order.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SEQL: {
                return "Sequential";
            }
            case UNOR: {
                return "Unordered";
            }
        }
        return "?";
    }
}

