/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3EntityStatus {
    NORMAL,
    ACTIVE,
    INACTIVE,
    TERMINATED,
    NULLIFIED,
    NULL;


    public static V3EntityStatus fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("normal".equals(codeString)) {
            return NORMAL;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("terminated".equals(codeString)) {
            return TERMINATED;
        }
        if ("nullified".equals(codeString)) {
            return NULLIFIED;
        }
        throw new Exception("Unknown V3EntityStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NORMAL: {
                return "normal";
            }
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case TERMINATED: {
                return "terminated";
            }
            case NULLIFIED: {
                return "nullified";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/EntityStatus";
    }

    public String getDefinition() {
        switch (this) {
            case NORMAL: {
                return "The 'typical' state. Excludes \"nullified\" which represents the termination state of an Entity record instance that was created in error.";
            }
            case ACTIVE: {
                return "The state representing the fact that the Entity record is currently active.";
            }
            case INACTIVE: {
                return "Definition: The state representing the fact that the entity is inactive.";
            }
            case TERMINATED: {
                return "The state representing the normal termination of an Entity record.";
            }
            case NULLIFIED: {
                return "The state representing the termination of an Entity record instance that was created in error.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NORMAL: {
                return "normal";
            }
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case TERMINATED: {
                return "terminated";
            }
            case NULLIFIED: {
                return "nullified";
            }
        }
        return "?";
    }
}

