/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3EquipmentAlertLevel {
    C,
    N,
    S,
    W,
    NULL;


    public static V3EquipmentAlertLevel fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("C".equals(codeString)) {
            return C;
        }
        if ("N".equals(codeString)) {
            return N;
        }
        if ("S".equals(codeString)) {
            return S;
        }
        if ("W".equals(codeString)) {
            return W;
        }
        throw new Exception("Unknown V3EquipmentAlertLevel code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case C: {
                return "C";
            }
            case N: {
                return "N";
            }
            case S: {
                return "S";
            }
            case W: {
                return "W";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/EquipmentAlertLevel";
    }

    public String getDefinition() {
        switch (this) {
            case C: {
                return "Shut Down, Fix Problem and Re-init";
            }
            case N: {
                return "No Corrective Action Needed";
            }
            case S: {
                return "Corrective Action Required";
            }
            case W: {
                return "Corrective Action Anticipated";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case C: {
                return "Critical";
            }
            case N: {
                return "Normal";
            }
            case S: {
                return "Serious";
            }
            case W: {
                return "Warning";
            }
        }
        return "?";
    }
}

