/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3ModifyIndicator {
    M,
    N,
    NULL;


    public static V3ModifyIndicator fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("M".equals(codeString)) {
            return M;
        }
        if ("N".equals(codeString)) {
            return N;
        }
        throw new Exception("Unknown V3ModifyIndicator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case M: {
                return "M";
            }
            case N: {
                return "N";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/ModifyIndicator";
    }

    public String getDefinition() {
        switch (this) {
            case M: {
                return "Modified subscription to a query server.";
            }
            case N: {
                return "New subscription to a query server.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case M: {
                return "Modified subscription";
            }
            case N: {
                return "New subscription";
            }
        }
        return "?";
    }
}

