/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.terminologies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Factory;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.terminologies.ValueSetCheckerSimple;
import org.hl7.fhir.instance.terminologies.ValueSetExpander;
import org.hl7.fhir.instance.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.instance.utilities.Utilities;
import org.hl7.fhir.instance.utils.IWorkerContext;
import org.hl7.fhir.instance.utils.ToolingExtensions;

public class ValueSetExpanderSimple
implements ValueSetExpander {
    private IWorkerContext context;
    private List<ValueSet.ValueSetExpansionContainsComponent> codes = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private Map<String, ValueSet.ValueSetExpansionContainsComponent> map = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
    private ValueSet focus;
    private ValueSetExpanderFactory factory;

    public ValueSetExpanderSimple(IWorkerContext context, ValueSetExpanderFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source) {
        try {
            this.focus = source.copy();
            this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
            this.focus.getExpansion().setTimestampElement(DateTimeType.now());
            this.focus.getExpansion().setIdentifier(Factory.createUUID());
            this.handleDefine(source, this.focus.getExpansion().getParameter());
            if (source.hasCompose()) {
                this.handleCompose(source.getCompose(), this.focus.getExpansion().getParameter());
            }
            for (ValueSet.ValueSetExpansionContainsComponent c : this.codes) {
                if (!this.map.containsKey(this.key(c))) continue;
                this.focus.getExpansion().getContains().add(c);
            }
            return new ValueSetExpander.ValueSetExpansionOutcome(this.focus, null);
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(new ValueSetCheckerSimple(source, this.factory, this.context), e.getMessage());
        }
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, List<ValueSet.ValueSetExpansionParameterComponent> params) throws Exception {
        for (UriType imp : compose.getImport()) {
            this.importValueSet((String)imp.getValue(), params);
        }
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            this.includeCodes(inc, params);
        }
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(inc, params);
        }
    }

    private void importValueSet(String value, List<ValueSet.ValueSetExpansionParameterComponent> params) throws Exception {
        if (value == null) {
            throw new Exception("unable to find value set with no identity");
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, value);
        if (vs == null) {
            throw new Exception("Unable to find imported value set " + value);
        }
        ValueSetExpander.ValueSetExpansionOutcome vso = this.factory.getExpander().expand(vs);
        if (vso.getService() != null) {
            throw new Exception("Unable to expand imported value set " + value);
        }
        if (vs.hasVersion() && !this.existsInParams(params, "version", new UriType(vs.getUrl() + "?version=" + vs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "?version=" + vs.getVersion())));
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : vso.getValueset().getExpansion().getContains()) {
            this.addCode(c.getSystem(), c.getCode(), c.getDisplay());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, Type value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params) throws Exception {
        if (this.context.supportsSystem(inc.getSystem())) {
            this.addCodes(this.context.expandVS(inc), params);
            return;
        }
        ValueSet cs = this.context.fetchCodeSystem(inc.getSystem());
        if (cs == null) {
            throw new Exception("unable to find code system " + inc.getSystem().toString());
        }
        if (cs.hasVersion() && !this.existsInParams(params, "version", new UriType(cs.getUrl() + "?version=" + cs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(cs.getUrl() + "?version=" + cs.getVersion())));
        }
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            for (ValueSet.ConceptDefinitionComponent def : cs.getCodeSystem().getConcept()) {
                this.addCodeAndDescendents(inc.getSystem(), def);
            }
        }
        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
            this.addCode(inc.getSystem(), c.getCode(), Utilities.noString(c.getDisplay()) ? this.getCodeDisplay(cs, c.getCode()) : c.getDisplay());
        }
        if (inc.getFilter().size() > 1) {
            throw new Exception("Multiple filters not handled yet");
        }
        if (inc.getFilter().size() == 1) {
            ValueSet.ConceptSetFilterComponent fc = inc.getFilter().get(0);
            if ("concept".equals(fc.getProperty()) && fc.getOp() == ValueSet.FilterOperator.ISA) {
                ValueSet.ConceptDefinitionComponent def;
                def = this.getConceptForCode(cs.getCodeSystem().getConcept(), fc.getValue());
                if (def == null) {
                    throw new Exception("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                this.addCodeAndDescendents(inc.getSystem(), def);
            } else {
                throw new Exception("not done yet");
            }
        }
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params) throws Exception {
        if (expand.getContains().size() > 500) {
            throw new ValueSetExpander.ETooCostly("Too many codes to display (>" + Integer.toString(expand.getContains().size()) + ")");
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.addCode(c.getSystem(), c.getCode(), c.getDisplay());
        }
    }

    private void addCodeAndDescendents(String system, ValueSet.ConceptDefinitionComponent def) {
        if (!ToolingExtensions.hasDeprecated(def)) {
            if (!def.hasAbstractElement() || !def.getAbstract()) {
                this.addCode(system, def.getCode(), def.getDisplay());
            }
            for (ValueSet.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(system, c);
            }
        }
    }

    private void excludeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params) throws Exception {
        ValueSet cs = this.context.fetchCodeSystem(inc.getSystem().toString());
        if (cs == null) {
            throw new Exception("unable to find value set " + inc.getSystem().toString());
        }
        if (inc.getConcept().size() != 0 || inc.getFilter().size() == 0) {
            // empty if block
        }
        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
            this.map.remove(this.key(inc.getSystem(), c.getCode()));
        }
        if (inc.getFilter().size() > 0) {
            throw new Exception("not done yet");
        }
    }

    private String getCodeDisplay(ValueSet cs, String code) throws Exception {
        ValueSet.ConceptDefinitionComponent def = this.getConceptForCode(cs.getCodeSystem().getConcept(), code);
        if (def == null) {
            throw new Exception("Unable to find code '" + code + "' in code system " + cs.getCodeSystem().getSystem());
        }
        return def.getDisplay();
    }

    private ValueSet.ConceptDefinitionComponent getConceptForCode(List<ValueSet.ConceptDefinitionComponent> clist, String code) {
        for (ValueSet.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            ValueSet.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void handleDefine(ValueSet vs, List<ValueSet.ValueSetExpansionParameterComponent> list) {
        if (vs.hasVersion()) {
            list.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "?version=" + vs.getVersion())));
        }
        if (vs.hasCodeSystem()) {
            for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
                this.addDefinedCode(vs, vs.getCodeSystem().getSystem(), c);
            }
        }
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private void addDefinedCode(ValueSet vs, String system, ValueSet.ConceptDefinitionComponent c) {
        if (!ToolingExtensions.hasDeprecated(c)) {
            if (!c.hasAbstractElement() || !c.getAbstract()) {
                this.addCode(system, c.getCode(), c.getDisplay());
            }
            for (ValueSet.ConceptDefinitionComponent g : c.getConcept()) {
                this.addDefinedCode(vs, vs.getCodeSystem().getSystem(), g);
            }
        }
    }

    private void addCode(String system, String code, String display) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        n.setDisplay(display);
        String s = this.key(n);
        if (!this.map.containsKey(s)) {
            this.codes.add(n);
            this.map.put(s, n);
        }
    }
}

