/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.formats;

import org.hl7.fhir.r4.formats.RdfParserBase;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.AdverseEvent;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Count;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DeviceComponent;
import org.hl7.fhir.r4.model.DeviceMetric;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.EligibilityRequest;
import org.hl7.fhir.r4.model.EligibilityResponse;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.EnrollmentRequest;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.EntryDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.EventDefinition;
import org.hl7.fhir.r4.model.ExampleScenario;
import org.hl7.fhir.r4.model.ExpansionProfile;
import org.hl7.fhir.r4.model.ExplanationOfBenefit;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.GraphDefinition;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.GuidanceResponse;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImagingStudy;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImmunizationEvaluation;
import org.hl7.fhir.r4.model.ImmunizationRecommendation;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.ItemInstance;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Linkage;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationKnowledge;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.MedicinalProductAuthorization;
import org.hl7.fhir.r4.model.MedicinalProductClinicals;
import org.hl7.fhir.r4.model.MedicinalProductDeviceSpec;
import org.hl7.fhir.r4.model.MedicinalProductIngredient;
import org.hl7.fhir.r4.model.MedicinalProductPackaged;
import org.hl7.fhir.r4.model.MedicinalProductPharmaceutical;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.NutritionOrder;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.OccupationalData;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationRole;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.ProcessRequest;
import org.hl7.fhir.r4.model.ProcessResponse;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductPlan;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.ResearchSubject;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Schedule;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.Sequence;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.SpecimenDefinition;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.SubstanceMoiety;
import org.hl7.fhir.r4.model.SubstancePolymer;
import org.hl7.fhir.r4.model.SubstanceReferenceInformation;
import org.hl7.fhir.r4.model.SubstanceSpecification;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.TestReport;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UserSession;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.VerificationResult;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.r4.utils.formats.Turtle;
import org.hl7.fhir.utilities.Utilities;

public class RdfParser
extends RdfParserBase {
    public RdfParser() {
    }

    public RdfParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected void composeElement(Turtle.Complex t, String parentType, String name, Element element, int index) {
        if (element == null) {
            return;
        }
        if (index > -1) {
            t.predicate("fhir:index", Integer.toString(index));
        }
        if (element.hasIdElement()) {
            this.composeString(t, "Element", "id", element.getIdElement(), -1);
        }
        for (int i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "Element", "extension", element.getExtension().get(i), i);
        }
    }

    protected void composeBackboneElement(Turtle.Complex t, String tType, String name, BackboneElement element, int index) {
        this.composeElement(t, tType, name, element, index);
        for (int i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "Element", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    private void composeEnum(Turtle.Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeDate(Turtle.Complex parent, String parentType, String name, DateType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDateTime(Turtle.Complex parent, String parentType, String name, DateTimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCode(Turtle.Complex parent, String parentType, String name, CodeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeString(Turtle.Complex parent, String parentType, String name, StringType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger(Turtle.Complex parent, String parentType, String name, IntegerType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeOid(Turtle.Complex parent, String parentType, String name, OidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCanonical(Turtle.Complex parent, String parentType, String name, CanonicalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUri(Turtle.Complex parent, String parentType, String name, UriType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUuid(Turtle.Complex parent, String parentType, String name, UuidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUrl(Turtle.Complex parent, String parentType, String name, UrlType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInstant(Turtle.Complex parent, String parentType, String name, InstantType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBoolean(Turtle.Complex parent, String parentType, String name, BooleanType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBase64Binary(Turtle.Complex parent, String parentType, String name, Base64BinaryType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUnsignedInt(Turtle.Complex parent, String parentType, String name, UnsignedIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeMarkdown(Turtle.Complex parent, String parentType, String name, MarkdownType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeTime(Turtle.Complex parent, String parentType, String name, TimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeId(Turtle.Complex parent, String parentType, String name, IdType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composePositiveInt(Turtle.Complex parent, String parentType, String name, PositiveIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDecimal(Turtle.Complex parent, String parentType, String name, DecimalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeExtension(Turtle.Complex parent, String parentType, String name, Extension element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Extension", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Extension", "url", element.getUrlElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Extension", "value", element.getValue(), -1);
        }
    }

    protected void composeNarrative(Turtle.Complex parent, String parentType, String name, Narrative element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Narrative", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
        }
        if (element.hasDiv()) {
            this.composeXhtml(t, "Narrative", "div", element.getDiv(), -1);
        }
    }

    protected void composeMeta(Turtle.Complex parent, String parentType, String name, Meta element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Meta", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "Meta", "source", element.getSourceElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "Meta", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getSecurity().size(); ++i) {
            this.composeCoding(t, "Meta", "security", element.getSecurity().get(i), i);
        }
        for (i = 0; i < element.getTag().size(); ++i) {
            this.composeCoding(t, "Meta", "tag", element.getTag().get(i), i);
        }
    }

    protected void composeAddress(Turtle.Complex parent, String parentType, String name, Address element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Address", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Address", "use", element.getUseElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Address", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Address", "text", element.getTextElement(), -1);
        }
        for (int i = 0; i < element.getLine().size(); ++i) {
            this.composeString(t, "Address", "line", element.getLine().get(i), i);
        }
        if (element.hasCityElement()) {
            this.composeString(t, "Address", "city", element.getCityElement(), -1);
        }
        if (element.hasDistrictElement()) {
            this.composeString(t, "Address", "district", element.getDistrictElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeString(t, "Address", "state", element.getStateElement(), -1);
        }
        if (element.hasPostalCodeElement()) {
            this.composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
        }
        if (element.hasCountryElement()) {
            this.composeString(t, "Address", "country", element.getCountryElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Address", "period", element.getPeriod(), -1);
        }
    }

    protected void composeContributor(Turtle.Complex parent, String parentType, String name, Contributor element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Contributor", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Contributor", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contributor", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Contributor", "contact", element.getContact().get(i), i);
        }
    }

    protected void composeAttachment(Turtle.Complex parent, String parentType, String name, Attachment element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Attachment", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "Attachment", "url", element.getUrlElement(), -1);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedInt(t, "Attachment", "size", element.getSizeElement(), -1);
        }
        if (element.hasHashElement()) {
            this.composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Attachment", "title", element.getTitleElement(), -1);
        }
        if (element.hasCreationElement()) {
            this.composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
        }
    }

    protected void composeCount(Turtle.Complex parent, String parentType, String name, Count element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Count", name, element, index);
    }

    protected void composeDataRequirement(Turtle.Complex parent, String parentType, String name, DataRequirement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "DataRequirement", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "DataRequirement", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "DataRequirement", "profile", element.getProfile().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeType(t, "DataRequirement", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getMustSupport().size(); ++i) {
            this.composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i), i);
        }
        for (i = 0; i < element.getCodeFilter().size(); ++i) {
            this.composeDataRequirementDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i), i);
        }
        for (i = 0; i < element.getDateFilter().size(); ++i) {
            this.composeDataRequirementDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i), i);
        }
        if (element.hasLimitElement()) {
            this.composePositiveInt(t, "DataRequirement", "limit", element.getLimitElement(), -1);
        }
        for (i = 0; i < element.getSort().size(); ++i) {
            this.composeDataRequirementDataRequirementSortComponent(t, "DataRequirement", "sort", element.getSort().get(i), i);
        }
    }

    protected void composeDataRequirementDataRequirementCodeFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "codeFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "DataRequirement", "valueSet", element.getValueSet(), -1);
        }
        for (int i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "DataRequirement", "code", element.getCode().get(i), i);
        }
    }

    protected void composeDataRequirementDataRequirementDateFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "dateFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DataRequirement", "value", element.getValue(), -1);
        }
    }

    protected void composeDataRequirementDataRequirementSortComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementSortComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "sort", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasDirectionElement()) {
            this.composeEnum(t, "DataRequirement", "direction", element.getDirectionElement(), -1);
        }
    }

    protected void composeDosage(Turtle.Complex parent, String parentType, String name, Dosage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Dosage", name, element, index);
        if (element.hasSequenceElement()) {
            this.composeInteger(t, "Dosage", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Dosage", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getAdditionalInstruction().size(); ++i) {
            this.composeCodeableConcept(t, "Dosage", "additionalInstruction", element.getAdditionalInstruction().get(i), i);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Dosage", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "Dosage", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "Dosage", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Dosage", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Dosage", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Dosage", "method", element.getMethod(), -1);
        }
        for (i = 0; i < element.getDoseAndRate().size(); ++i) {
            this.composeDosageDosageDoseAndRateComponent(t, "Dosage", "doseAndRate", element.getDoseAndRate().get(i), i);
        }
        if (element.hasMaxDosePerPeriod()) {
            this.composeRatio(t, "Dosage", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
        }
        if (element.hasMaxDosePerAdministration()) {
            this.composeQuantity(t, "Dosage", "maxDosePerAdministration", element.getMaxDosePerAdministration(), -1);
        }
        if (element.hasMaxDosePerLifetime()) {
            this.composeQuantity(t, "Dosage", "maxDosePerLifetime", element.getMaxDosePerLifetime(), -1);
        }
    }

    protected void composeDosageDosageDoseAndRateComponent(Turtle.Complex parent, String parentType, String name, Dosage.DosageDoseAndRateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "doseAndRate", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Dosage", "type", element.getType(), -1);
        }
        if (element.hasDose()) {
            this.composeType(t, "Dosage", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "Dosage", "rate", element.getRate(), -1);
        }
    }

    protected void composeMoney(Turtle.Complex parent, String parentType, String name, Money element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Money", name, element, index);
    }

    protected void composeHumanName(Turtle.Complex parent, String parentType, String name, HumanName element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "HumanName", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "HumanName", "text", element.getTextElement(), -1);
        }
        if (element.hasFamilyElement()) {
            this.composeString(t, "HumanName", "family", element.getFamilyElement(), -1);
        }
        for (i = 0; i < element.getGiven().size(); ++i) {
            this.composeString(t, "HumanName", "given", element.getGiven().get(i), i);
        }
        for (i = 0; i < element.getPrefix().size(); ++i) {
            this.composeString(t, "HumanName", "prefix", element.getPrefix().get(i), i);
        }
        for (i = 0; i < element.getSuffix().size(); ++i) {
            this.composeString(t, "HumanName", "suffix", element.getSuffix().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
        }
    }

    protected void composeContactPoint(Turtle.Complex parent, String parentType, String name, ContactPoint element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "ContactPoint", name, element, index);
        if (element.hasSystemElement()) {
            this.composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
        }
    }

    protected void composeIdentifier(Turtle.Complex parent, String parentType, String name, Identifier element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Identifier", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Identifier", "value", element.getValueElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
        }
        if (element.hasAssigner()) {
            this.composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
        }
    }

    protected void composeCoding(Turtle.Complex parent, String parentType, String name, Coding element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Coding", name, element, index);
        this.decorateCoding(t, element);
        if (element.hasSystemElement()) {
            this.composeUri(t, "Coding", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Coding", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Coding", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Coding", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
        }
    }

    protected void composeSampledData(Turtle.Complex parent, String parentType, String name, SampledData element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "SampledData", name, element, index);
        if (element.hasOrigin()) {
            this.composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "SampledData", "period", element.getPeriodElement(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeString(t, "SampledData", "data", element.getDataElement(), -1);
        }
    }

    protected void composeRatio(Turtle.Complex parent, String parentType, String name, Ratio element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Ratio", name, element, index);
        if (element.hasNumerator()) {
            this.composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeDistance(Turtle.Complex parent, String parentType, String name, Distance element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Distance", name, element, index);
    }

    protected void composeAge(Turtle.Complex parent, String parentType, String name, Age element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Age", name, element, index);
    }

    protected void composeReference(Turtle.Complex parent, String parentType, String name, Reference element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Reference", name, element, index);
        if (element.hasReferenceElement()) {
            this.composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "Reference", "type", element.getTypeElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Reference", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Reference", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeTriggerDefinition(Turtle.Complex parent, String parentType, String name, TriggerDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "TriggerDefinition", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TriggerDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "TriggerDefinition", "timing", element.getTiming(), -1);
        }
        if (element.hasData()) {
            this.composeDataRequirement(t, "TriggerDefinition", "data", element.getData(), -1);
        }
        if (element.hasCondition()) {
            this.composeTriggerDefinitionTriggerDefinitionConditionComponent(t, "TriggerDefinition", "condition", element.getCondition(), -1);
        }
    }

    protected void composeTriggerDefinitionTriggerDefinitionConditionComponent(Turtle.Complex parent, String parentType, String name, TriggerDefinition.TriggerDefinitionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "condition", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TriggerDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeEnum(t, "TriggerDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "TriggerDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeQuantity(Turtle.Complex parent, String parentType, String name, Quantity element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Quantity", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
        }
        if (element.hasComparatorElement()) {
            this.composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
        }
        if (element.hasUnitElement()) {
            this.composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
        }
    }

    protected void composePeriod(Turtle.Complex parent, String parentType, String name, Period element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Period", name, element, index);
        if (element.hasStartElement()) {
            this.composeDateTime(t, "Period", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeDateTime(t, "Period", "end", element.getEndElement(), -1);
        }
    }

    protected void composeDuration(Turtle.Complex parent, String parentType, String name, Duration element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Duration", name, element, index);
    }

    protected void composeRange(Turtle.Complex parent, String parentType, String name, Range element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Range", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Range", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Range", "high", element.getHigh(), -1);
        }
    }

    protected void composeRelatedArtifact(Turtle.Complex parent, String parentType, String name, RelatedArtifact element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "RelatedArtifact", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "RelatedArtifact", "type", element.getTypeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "RelatedArtifact", "display", element.getDisplayElement(), -1);
        }
        if (element.hasCitationElement()) {
            this.composeString(t, "RelatedArtifact", "citation", element.getCitationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "RelatedArtifact", "url", element.getUrlElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "RelatedArtifact", "document", element.getDocument(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCanonical(t, "RelatedArtifact", "resource", element.getResourceElement(), -1);
        }
    }

    protected void composeAnnotation(Turtle.Complex parent, String parentType, String name, Annotation element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Annotation", name, element, index);
        if (element.hasAuthor()) {
            this.composeType(t, "Annotation", "author", element.getAuthor(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Annotation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeContactDetail(Turtle.Complex parent, String parentType, String name, ContactDetail element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "ContactDetail", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ContactDetail", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ContactDetail", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeUsageContext(Turtle.Complex parent, String parentType, String name, UsageContext element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "UsageContext", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "UsageContext", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "UsageContext", "value", element.getValue(), -1);
        }
    }

    protected void composeSignature(Turtle.Complex parent, String parentType, String name, Signature element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Signature", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "Signature", "type", element.getType().get(i), i);
        }
        if (element.hasWhenElement()) {
            this.composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
        }
        if (element.hasWho()) {
            this.composeType(t, "Signature", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeType(t, "Signature", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasTargetFormatElement()) {
            this.composeCode(t, "Signature", "targetFormat", element.getTargetFormatElement(), -1);
        }
        if (element.hasSigFormatElement()) {
            this.composeCode(t, "Signature", "sigFormat", element.getSigFormatElement(), -1);
        }
        if (element.hasBlobElement()) {
            this.composeBase64Binary(t, "Signature", "blob", element.getBlobElement(), -1);
        }
    }

    protected void composeTiming(Turtle.Complex parent, String parentType, String name, Timing element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "Timing", name, element, index);
        for (int i = 0; i < element.getEvent().size(); ++i) {
            this.composeDateTime(t, "Timing", "event", element.getEvent().get(i), i);
        }
        if (element.hasRepeat()) {
            this.composeTimingTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
        }
    }

    protected void composeTimingTimingRepeatComponent(Turtle.Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "repeat", name, element, index);
        if (element.hasBounds()) {
            this.composeType(t, "Timing", "bounds", element.getBounds(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "Timing", "count", element.getCountElement(), -1);
        }
        if (element.hasCountMaxElement()) {
            this.composeInteger(t, "Timing", "countMax", element.getCountMaxElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Timing", "duration", element.getDurationElement(), -1);
        }
        if (element.hasDurationMaxElement()) {
            this.composeDecimal(t, "Timing", "durationMax", element.getDurationMaxElement(), -1);
        }
        if (element.hasDurationUnitElement()) {
            this.composeEnum(t, "Timing", "durationUnit", element.getDurationUnitElement(), -1);
        }
        if (element.hasFrequencyElement()) {
            this.composeInteger(t, "Timing", "frequency", element.getFrequencyElement(), -1);
        }
        if (element.hasFrequencyMaxElement()) {
            this.composeInteger(t, "Timing", "frequencyMax", element.getFrequencyMaxElement(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "Timing", "period", element.getPeriodElement(), -1);
        }
        if (element.hasPeriodMaxElement()) {
            this.composeDecimal(t, "Timing", "periodMax", element.getPeriodMaxElement(), -1);
        }
        if (element.hasPeriodUnitElement()) {
            this.composeEnum(t, "Timing", "periodUnit", element.getPeriodUnitElement(), -1);
        }
        for (i = 0; i < element.getDayOfWeek().size(); ++i) {
            this.composeEnum(t, "Timing", "dayOfWeek", element.getDayOfWeek().get(i), i);
        }
        for (i = 0; i < element.getTimeOfDay().size(); ++i) {
            this.composeTime(t, "Timing", "timeOfDay", element.getTimeOfDay().get(i), i);
        }
        for (i = 0; i < element.getWhen().size(); ++i) {
            this.composeEnum(t, "Timing", "when", element.getWhen().get(i), i);
        }
        if (element.hasOffsetElement()) {
            this.composeUnsignedInt(t, "Timing", "offset", element.getOffsetElement(), -1);
        }
    }

    protected void composeCodeableConcept(Turtle.Complex parent, String parentType, String name, CodeableConcept element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "CodeableConcept", name, element, index);
        this.decorateCodeableConcept(t, element);
        for (int i = 0; i < element.getCoding().size(); ++i) {
            this.composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
        }
    }

    protected void composeParameterDefinition(Turtle.Complex parent, String parentType, String name, ParameterDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "ParameterDefinition", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ParameterDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ParameterDefinition", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeMarketingStatus(Turtle.Complex parent, String parentType, String name, MarketingStatus element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "MarketingStatus", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MarketingStatus", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MarketingStatus", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MarketingStatus", "status", element.getStatus(), -1);
        }
        if (element.hasDateRange()) {
            this.composePeriod(t, "MarketingStatus", "dateRange", element.getDateRange(), -1);
        }
        if (element.hasRestoreDateElement()) {
            this.composeDateTime(t, "MarketingStatus", "restoreDate", element.getRestoreDateElement(), -1);
        }
    }

    protected void composeSubstanceAmount(Turtle.Complex parent, String parentType, String name, SubstanceAmount element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "SubstanceAmount", name, element, index);
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceAmount", "amount", element.getAmount(), -1);
        }
        if (element.hasAmountType()) {
            this.composeCodeableConcept(t, "SubstanceAmount", "amountType", element.getAmountType(), -1);
        }
        if (element.hasAmountTextElement()) {
            this.composeString(t, "SubstanceAmount", "amountText", element.getAmountTextElement(), -1);
        }
        if (element.hasReferenceRange()) {
            this.composeSubstanceAmountSubstanceAmountReferenceRangeComponent(t, "SubstanceAmount", "referenceRange", element.getReferenceRange(), -1);
        }
    }

    protected void composeSubstanceAmountSubstanceAmountReferenceRangeComponent(Turtle.Complex parent, String parentType, String name, SubstanceAmount.SubstanceAmountReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "referenceRange", name, element, index);
        if (element.hasLowLimit()) {
            this.composeQuantity(t, "SubstanceAmount", "lowLimit", element.getLowLimit(), -1);
        }
        if (element.hasHighLimit()) {
            this.composeQuantity(t, "SubstanceAmount", "highLimit", element.getHighLimit(), -1);
        }
    }

    protected void composeElementDefinition(Turtle.Complex parent, String parentType, String name, ElementDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "ElementDefinition", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        for (i = 0; i < element.getRepresentation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i), i);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "ElementDefinition", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "ElementDefinition", "code", element.getCode().get(i), i);
        }
        if (element.hasSlicing()) {
            this.composeElementDefinitionElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
        }
        if (element.hasShortElement()) {
            this.composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "ElementDefinition", "alias", element.getAlias().get(i), i);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasBase()) {
            this.composeElementDefinitionElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
        }
        if (element.hasContentReferenceElement()) {
            this.composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i), i);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasMeaningWhenMissingElement()) {
            this.composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
        }
        if (element.hasOrderMeaningElement()) {
            this.composeString(t, "ElementDefinition", "orderMeaning", element.getOrderMeaningElement(), -1);
        }
        if (element.hasFixed()) {
            this.composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
        }
        if (element.hasPattern()) {
            this.composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
        }
        for (i = 0; i < element.getExample().size(); ++i) {
            this.composeElementDefinitionElementDefinitionExampleComponent(t, "ElementDefinition", "example", element.getExample().get(i), i);
        }
        if (element.hasMinValue()) {
            this.composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
        }
        if (element.hasMaxValue()) {
            this.composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeId(t, "ElementDefinition", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getConstraint().size(); ++i) {
            this.composeElementDefinitionElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i), i);
        }
        if (element.hasMustSupportElement()) {
            this.composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
        }
        if (element.hasIsModifierElement()) {
            this.composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
        }
        if (element.hasIsModifierReasonElement()) {
            this.composeString(t, "ElementDefinition", "isModifierReason", element.getIsModifierReasonElement(), -1);
        }
        if (element.hasIsSummaryElement()) {
            this.composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeElementDefinitionElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeElementDefinitionElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i), i);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "slicing", name, element, index);
        for (int i = 0; i < element.getDiscriminator().size(); ++i) {
            this.composeElementDefinitionElementDefinitionSlicingDiscriminatorComponent(t, "ElementDefinition", "discriminator", element.getDiscriminator().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOrderedElement()) {
            this.composeBoolean(t, "ElementDefinition", "ordered", element.getOrderedElement(), -1);
        }
        if (element.hasRulesElement()) {
            this.composeEnum(t, "ElementDefinition", "rules", element.getRulesElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingDiscriminatorComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "discriminator", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ElementDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "base", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "type", name, element, index);
        if (element.hasCodeElement()) {
            this.composeUri(t, "ElementDefinition", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "ElementDefinition", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getTargetProfile().size(); ++i) {
            this.composeCanonical(t, "ElementDefinition", "targetProfile", element.getTargetProfile().get(i), i);
        }
        for (i = 0; i < element.getAggregation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "aggregation", element.getAggregation().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "ElementDefinition", "versioning", element.getVersioningElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionExampleComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionExampleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "example", name, element, index);
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ElementDefinition", "value", element.getValue(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "constraint", name, element, index);
        if (element.hasKeyElement()) {
            this.composeId(t, "ElementDefinition", "key", element.getKeyElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "ElementDefinition", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasHumanElement()) {
            this.composeString(t, "ElementDefinition", "human", element.getHumanElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ElementDefinition", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "ElementDefinition", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeCanonical(t, "ElementDefinition", "source", element.getSourceElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "ElementDefinition", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "ElementDefinition", "valueSet", element.getValueSet(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "ElementDefinition", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ElementDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasMapElement()) {
            this.composeString(t, "ElementDefinition", "map", element.getMapElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSubstanceMoiety(Turtle.Complex parent, String parentType, String name, SubstanceMoiety element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "SubstanceMoiety", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "SubstanceMoiety", "role", element.getRole(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceMoiety", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SubstanceMoiety", "name", element.getNameElement(), -1);
        }
        if (element.hasStereochemistry()) {
            this.composeCodeableConcept(t, "SubstanceMoiety", "stereochemistry", element.getStereochemistry(), -1);
        }
        if (element.hasOpticalActivity()) {
            this.composeCodeableConcept(t, "SubstanceMoiety", "opticalActivity", element.getOpticalActivity(), -1);
        }
        if (element.hasMolecularFormulaElement()) {
            this.composeString(t, "SubstanceMoiety", "molecularFormula", element.getMolecularFormulaElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstanceMoiety", "amount", element.getAmount(), -1);
        }
    }

    protected void composeProductShelfLife(Turtle.Complex parent, String parentType, String name, ProductShelfLife element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "ProductShelfLife", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ProductShelfLife", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ProductShelfLife", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composeQuantity(t, "ProductShelfLife", "period", element.getPeriod(), -1);
        }
        for (int i = 0; i < element.getSpecialPrecautionsForStorage().size(); ++i) {
            this.composeCodeableConcept(t, "ProductShelfLife", "specialPrecautionsForStorage", element.getSpecialPrecautionsForStorage().get(i), i);
        }
    }

    protected void composeProdCharacteristic(Turtle.Complex parent, String parentType, String name, ProdCharacteristic element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeElement(t, "ProdCharacteristic", name, element, index);
        if (element.hasHeight()) {
            this.composeQuantity(t, "ProdCharacteristic", "height", element.getHeight(), -1);
        }
        if (element.hasWidth()) {
            this.composeQuantity(t, "ProdCharacteristic", "width", element.getWidth(), -1);
        }
        if (element.hasDepth()) {
            this.composeQuantity(t, "ProdCharacteristic", "depth", element.getDepth(), -1);
        }
        if (element.hasWeight()) {
            this.composeQuantity(t, "ProdCharacteristic", "weight", element.getWeight(), -1);
        }
        if (element.hasNominalVolume()) {
            this.composeQuantity(t, "ProdCharacteristic", "nominalVolume", element.getNominalVolume(), -1);
        }
        if (element.hasExternalDiameter()) {
            this.composeQuantity(t, "ProdCharacteristic", "externalDiameter", element.getExternalDiameter(), -1);
        }
        if (element.hasShapeElement()) {
            this.composeString(t, "ProdCharacteristic", "shape", element.getShapeElement(), -1);
        }
        for (i = 0; i < element.getColor().size(); ++i) {
            this.composeString(t, "ProdCharacteristic", "color", element.getColor().get(i), i);
        }
        for (i = 0; i < element.getImprint().size(); ++i) {
            this.composeString(t, "ProdCharacteristic", "imprint", element.getImprint().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "ProdCharacteristic", "image", element.getImage().get(i), i);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "ProdCharacteristic", "scoring", element.getScoring(), -1);
        }
    }

    protected void composeDomainResource(Turtle.Complex t, String parentType, String name, DomainResource element, int index) {
        int i;
        this.composeResource(t, parentType, name, element, index);
        if (element.hasText()) {
            this.composeNarrative(t, "DomainResource", "text", element.getText(), -1);
        }
        for (i = 0; i < element.getContained().size(); ++i) {
            this.composeResource(t, "DomainResource", "contained", element.getContained().get(i), i);
        }
        for (i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "extension", element.getExtension().get(i), i);
        }
        for (i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    protected void composeParameters(Turtle.Complex parent, String parentType, String name, Parameters element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeResource(t, "Parameters", name, element, index);
        for (int i = 0; i < element.getParameter().size(); ++i) {
            this.composeParametersParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeParametersParametersParameterComponent(Turtle.Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Parameters", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Parameters", "value", element.getValue(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "Parameters", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getPart().size(); ++i) {
            this.composeParametersParametersParameterComponent(t, "Parameters", "part", element.getPart().get(i), i);
        }
    }

    protected void composeResource(Turtle.Complex t, String parentType, String name, Resource element, int index) {
        if (element.hasIdElement()) {
            this.composeId(t, "Resource", "id", element.getIdElement(), -1);
        }
        if (element.hasMeta()) {
            this.composeMeta(t, "Resource", "meta", element.getMeta(), -1);
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
        }
    }

    protected void composeAccount(Turtle.Complex parent, String parentType, String name, Account element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Account", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Account", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Account", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Account", "name", element.getNameElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Account", "subject", element.getSubject(), -1);
        }
        if (element.hasServicePeriod()) {
            this.composePeriod(t, "Account", "servicePeriod", element.getServicePeriod(), -1);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeAccountCoverageComponent(t, "Account", "coverage", element.getCoverage().get(i), i);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Account", "owner", element.getOwner(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Account", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getGuarantor().size(); ++i) {
            this.composeAccountGuarantorComponent(t, "Account", "guarantor", element.getGuarantor().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Account", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeAccountCoverageComponent(Turtle.Complex parent, String parentType, String name, Account.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "Account", "coverage", element.getCoverage(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composePositiveInt(t, "Account", "priority", element.getPriorityElement(), -1);
        }
    }

    protected void composeAccountGuarantorComponent(Turtle.Complex parent, String parentType, String name, Account.GuarantorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "guarantor", name, element, index);
        if (element.hasParty()) {
            this.composeReference(t, "Account", "party", element.getParty(), -1);
        }
        if (element.hasOnHoldElement()) {
            this.composeBoolean(t, "Account", "onHold", element.getOnHoldElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Account", "period", element.getPeriod(), -1);
        }
    }

    protected void composeActivityDefinition(Turtle.Complex parent, String parentType, String name, ActivityDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ActivityDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ActivityDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ActivityDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ActivityDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ActivityDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ActivityDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ActivityDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ActivityDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ActivityDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ActivityDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ActivityDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ActivityDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ActivityDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ActivityDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ActivityDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ActivityDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ActivityDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeContributor(t, "ActivityDefinition", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ActivityDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ActivityDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "ActivityDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ActivityDefinition", "code", element.getCode(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ActivityDefinition", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "ActivityDefinition", "timing", element.getTiming(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ActivityDefinition", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeActivityDefinitionActivityDefinitionParticipantComponent(t, "ActivityDefinition", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "ActivityDefinition", "product", element.getProduct(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ActivityDefinition", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "ActivityDefinition", "dosage", element.getDosage().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "bodySite", element.getBodySite().get(i), i);
        }
        for (i = 0; i < element.getSpecimenRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "specimenRequirement", element.getSpecimenRequirement().get(i), i);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "ActivityDefinition", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getDynamicValue().size(); ++i) {
            this.composeActivityDefinitionActivityDefinitionDynamicValueComponent(t, "ActivityDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
        }
    }

    protected void composeActivityDefinitionActivityDefinitionParticipantComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ActivityDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ActivityDefinition", "role", element.getRole(), -1);
        }
    }

    protected void composeActivityDefinitionActivityDefinitionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "ActivityDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeString(t, "ActivityDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ActivityDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeAdverseEvent(Turtle.Complex parent, String parentType, String name, AdverseEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "AdverseEvent", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AdverseEvent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasActualityElement()) {
            this.composeEnum(t, "AdverseEvent", "actuality", element.getActualityElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "AdverseEvent", "category", element.getCategory().get(i), i);
        }
        if (element.hasEvent()) {
            this.composeCodeableConcept(t, "AdverseEvent", "event", element.getEvent(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "AdverseEvent", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "AdverseEvent", "context", element.getContext(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "AdverseEvent", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getResultingCondition().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "resultingCondition", element.getResultingCondition().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AdverseEvent", "location", element.getLocation(), -1);
        }
        if (element.hasSeriousness()) {
            this.composeCodeableConcept(t, "AdverseEvent", "seriousness", element.getSeriousness(), -1);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "AdverseEvent", "severity", element.getSeverity(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "AdverseEvent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AdverseEvent", "recorder", element.getRecorder(), -1);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getSuspectEntity().size(); ++i) {
            this.composeAdverseEventAdverseEventSuspectEntityComponent(t, "AdverseEvent", "suspectEntity", element.getSuspectEntity().get(i), i);
        }
        for (i = 0; i < element.getSubjectMedicalHistory().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "subjectMedicalHistory", element.getSubjectMedicalHistory().get(i), i);
        }
        for (i = 0; i < element.getReferenceDocument().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "referenceDocument", element.getReferenceDocument().get(i), i);
        }
        for (i = 0; i < element.getStudy().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "study", element.getStudy().get(i), i);
        }
    }

    protected void composeAdverseEventAdverseEventSuspectEntityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "suspectEntity", name, element, index);
        if (element.hasInstance()) {
            this.composeReference(t, "AdverseEvent", "instance", element.getInstance(), -1);
        }
        for (int i = 0; i < element.getCausality().size(); ++i) {
            this.composeAdverseEventAdverseEventSuspectEntityCausalityComponent(t, "AdverseEvent", "causality", element.getCausality().get(i), i);
        }
    }

    protected void composeAdverseEventAdverseEventSuspectEntityCausalityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityCausalityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "causality", name, element, index);
        if (element.hasAssessment()) {
            this.composeCodeableConcept(t, "AdverseEvent", "assessment", element.getAssessment(), -1);
        }
        if (element.hasProductRelatednessElement()) {
            this.composeString(t, "AdverseEvent", "productRelatedness", element.getProductRelatednessElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "AdverseEvent", "author", element.getAuthor(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "AdverseEvent", "method", element.getMethod(), -1);
        }
    }

    protected void composeAllergyIntolerance(Turtle.Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "AllergyIntolerance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClinicalStatusElement()) {
            this.composeEnum(t, "AllergyIntolerance", "clinicalStatus", element.getClinicalStatusElement(), -1);
        }
        if (element.hasVerificationStatusElement()) {
            this.composeEnum(t, "AllergyIntolerance", "verificationStatus", element.getVerificationStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AllergyIntolerance", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeEnum(t, "AllergyIntolerance", "category", element.getCategory().get(i), i);
        }
        if (element.hasCriticalityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "code", element.getCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AllergyIntolerance", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "AllergyIntolerance", "onset", element.getOnset(), -1);
        }
        if (element.hasAssertedDateElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "assertedDate", element.getAssertedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AllergyIntolerance", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "AllergyIntolerance", "asserter", element.getAsserter(), -1);
        }
        if (element.hasLastOccurrenceElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "lastOccurrence", element.getLastOccurrenceElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeAllergyIntoleranceAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i), i);
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(Turtle.Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "substance", element.getSubstance(), -1);
        }
        for (i = 0; i < element.getManifestation().size(); ++i) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "manifestation", element.getManifestation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AllergyIntolerance", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "onset", element.getOnsetElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasExposureRoute()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "exposureRoute", element.getExposureRoute(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
    }

    protected void composeAppointment(Turtle.Complex parent, String parentType, String name, Appointment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Appointment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getIndication().size(); ++i) {
            this.composeReference(t, "Appointment", "indication", element.getIndication().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeUnsignedInt(t, "Appointment", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "Appointment", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
        }
        if (element.hasMinutesDurationElement()) {
            this.composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
        }
        for (i = 0; i < element.getSlot().size(); ++i) {
            this.composeReference(t, "Appointment", "slot", element.getSlot().get(i), i);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Appointment", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Appointment", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Appointment", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeAppointmentAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getRequestedPeriod().size(); ++i) {
            this.composePeriod(t, "Appointment", "requestedPeriod", element.getRequestedPeriod().get(i), i);
        }
    }

    protected void composeAppointmentAppointmentParticipantComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "type", element.getType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Appointment", "actor", element.getActor(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeEnum(t, "Appointment", "required", element.getRequiredElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Appointment", "period", element.getPeriod(), -1);
        }
    }

    protected void composeAppointmentResponse(Turtle.Complex parent, String parentType, String name, AppointmentResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "AppointmentResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
        }
        for (i = 0; i < element.getParticipantType().size(); ++i) {
            this.composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
        }
        if (element.hasParticipantStatusElement()) {
            this.composeEnum(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeAuditEvent(Turtle.Complex parent, String parentType, String name, AuditEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "AuditEvent", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "subtype", element.getSubtype().get(i), i);
        }
        if (element.hasActionElement()) {
            this.composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "AuditEvent", "period", element.getPeriod(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "AuditEvent", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasOutcomeDescElement()) {
            this.composeString(t, "AuditEvent", "outcomeDesc", element.getOutcomeDescElement(), -1);
        }
        for (i = 0; i < element.getPurposeOfEvent().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "purposeOfEvent", element.getPurposeOfEvent().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeAuditEventAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i), i);
        }
        if (element.hasSource()) {
            this.composeAuditEventAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeAuditEventAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventAgentComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AuditEvent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "role", element.getRole().get(i), i);
        }
        if (element.hasReference()) {
            this.composeReference(t, "AuditEvent", "reference", element.getReference(), -1);
        }
        if (element.hasUserId()) {
            this.composeIdentifier(t, "AuditEvent", "userId", element.getUserId(), -1);
        }
        if (element.hasAltIdElement()) {
            this.composeString(t, "AuditEvent", "altId", element.getAltIdElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEvent", "name", element.getNameElement(), -1);
        }
        if (element.hasRequestorElement()) {
            this.composeBoolean(t, "AuditEvent", "requestor", element.getRequestorElement(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AuditEvent", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "AuditEvent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasMedia()) {
            this.composeCoding(t, "AuditEvent", "media", element.getMedia(), -1);
        }
        if (element.hasNetwork()) {
            this.composeAuditEventAuditEventAgentNetworkComponent(t, "AuditEvent", "network", element.getNetwork(), -1);
        }
        for (i = 0; i < element.getPurposeOfUse().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "purposeOfUse", element.getPurposeOfUse().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventAgentNetworkComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentNetworkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "network", name, element, index);
        if (element.hasAddressElement()) {
            this.composeString(t, "AuditEvent", "address", element.getAddressElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AuditEvent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeAuditEventAuditEventSourceComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasSiteElement()) {
            this.composeString(t, "AuditEvent", "site", element.getSiteElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AuditEvent", "identifier", element.getIdentifier(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "type", element.getType().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventEntityComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AuditEvent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "AuditEvent", "reference", element.getReference(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        if (element.hasRole()) {
            this.composeCoding(t, "AuditEvent", "role", element.getRole(), -1);
        }
        if (element.hasLifecycle()) {
            this.composeCoding(t, "AuditEvent", "lifecycle", element.getLifecycle(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEvent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AuditEvent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasQueryElement()) {
            this.composeBase64Binary(t, "AuditEvent", "query", element.getQueryElement(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeAuditEventAuditEventEntityDetailComponent(t, "AuditEvent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventEntityDetailComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasTypeElement()) {
            this.composeString(t, "AuditEvent", "type", element.getTypeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "AuditEvent", "value", element.getValue(), -1);
        }
    }

    protected void composeBasic(Turtle.Complex parent, String parentType, String name, Basic element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Basic", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Basic", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDate(t, "Basic", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Basic", "author", element.getAuthor(), -1);
        }
    }

    protected void composeBinary(Turtle.Complex parent, String parentType, String name, Binary element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeResource(t, "Binary", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasSecurityContext()) {
            this.composeReference(t, "Binary", "securityContext", element.getSecurityContext(), -1);
        }
        if (element.hasContentElement()) {
            this.composeBase64Binary(t, "Binary", "content", element.getContentElement(), -1);
        }
    }

    protected void composeBiologicallyDerivedProduct(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "BiologicallyDerivedProduct", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BiologicallyDerivedProduct", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasProductCategoryElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "productCategory", element.getProductCategoryElement(), -1);
        }
        if (element.hasProductCode()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProduct", "productCode", element.getProductCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "BiologicallyDerivedProduct", "request", element.getRequest().get(i), i);
        }
        if (element.hasQuantityElement()) {
            this.composeInteger(t, "BiologicallyDerivedProduct", "quantity", element.getQuantityElement(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "parent", element.getParent(), -1);
        }
        if (element.hasCollection()) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(t, "BiologicallyDerivedProduct", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getProcessing().size(); ++i) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(t, "BiologicallyDerivedProduct", "processing", element.getProcessing().get(i), i);
        }
        if (element.hasManipulation()) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(t, "BiologicallyDerivedProduct", "manipulation", element.getManipulation(), -1);
        }
        for (i = 0; i < element.getStorage().size(); ++i) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(t, "BiologicallyDerivedProduct", "storage", element.getStorage().get(i), i);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "collector", element.getCollector(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "source", element.getSource(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "BiologicallyDerivedProduct", "collected", element.getCollected(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "processing", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProduct", "procedure", element.getProcedure(), -1);
        }
        if (element.hasAdditive()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "additive", element.getAdditive(), -1);
        }
        if (element.hasTime()) {
            this.composeType(t, "BiologicallyDerivedProduct", "time", element.getTime(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "manipulation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTime()) {
            this.composeType(t, "BiologicallyDerivedProduct", "time", element.getTime(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "storage", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTemperatureElement()) {
            this.composeDecimal(t, "BiologicallyDerivedProduct", "temperature", element.getTemperatureElement(), -1);
        }
        if (element.hasScaleElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "scale", element.getScaleElement(), -1);
        }
        if (element.hasDuration()) {
            this.composePeriod(t, "BiologicallyDerivedProduct", "duration", element.getDuration(), -1);
        }
    }

    protected void composeBodyStructure(Turtle.Complex parent, String parentType, String name, BodyStructure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "BodyStructure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BodyStructure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "BodyStructure", "active", element.getActiveElement(), -1);
        }
        if (element.hasMorphology()) {
            this.composeCodeableConcept(t, "BodyStructure", "morphology", element.getMorphology(), -1);
        }
        if (element.hasLocation()) {
            this.composeCodeableConcept(t, "BodyStructure", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getLocationQualifier().size(); ++i) {
            this.composeCodeableConcept(t, "BodyStructure", "locationQualifier", element.getLocationQualifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BodyStructure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "BodyStructure", "image", element.getImage().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "BodyStructure", "patient", element.getPatient(), -1);
        }
    }

    protected void composeBundle(Turtle.Complex parent, String parentType, String name, Bundle element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeResource(t, "Bundle", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Bundle", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
        }
        if (element.hasTimestampElement()) {
            this.composeInstant(t, "Bundle", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeBundleBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i), i);
        }
        if (element.hasSignature()) {
            this.composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
        }
    }

    protected void composeBundleBundleLinkComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasRelationElement()) {
            this.composeString(t, "Bundle", "relation", element.getRelationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Bundle", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeBundleBundleEntryComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        for (int i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        if (element.hasFullUrlElement()) {
            this.composeUri(t, "Bundle", "fullUrl", element.getFullUrlElement(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "Bundle", "resource", element.getResource(), -1);
        }
        if (element.hasSearch()) {
            this.composeBundleBundleEntrySearchComponent(t, "Bundle", "search", element.getSearch(), -1);
        }
        if (element.hasRequest()) {
            this.composeBundleBundleEntryRequestComponent(t, "Bundle", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeBundleBundleEntryResponseComponent(t, "Bundle", "response", element.getResponse(), -1);
        }
    }

    protected void composeBundleBundleEntrySearchComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "search", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Bundle", "mode", element.getModeElement(), -1);
        }
        if (element.hasScoreElement()) {
            this.composeDecimal(t, "Bundle", "score", element.getScoreElement(), -1);
        }
    }

    protected void composeBundleBundleEntryRequestComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "request", name, element, index);
        if (element.hasMethodElement()) {
            this.composeEnum(t, "Bundle", "method", element.getMethodElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Bundle", "url", element.getUrlElement(), -1);
        }
        if (element.hasIfNoneMatchElement()) {
            this.composeString(t, "Bundle", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
        }
        if (element.hasIfModifiedSinceElement()) {
            this.composeInstant(t, "Bundle", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
        }
        if (element.hasIfMatchElement()) {
            this.composeString(t, "Bundle", "ifMatch", element.getIfMatchElement(), -1);
        }
        if (element.hasIfNoneExistElement()) {
            this.composeString(t, "Bundle", "ifNoneExist", element.getIfNoneExistElement(), -1);
        }
    }

    protected void composeBundleBundleEntryResponseComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasStatusElement()) {
            this.composeString(t, "Bundle", "status", element.getStatusElement(), -1);
        }
        if (element.hasLocationElement()) {
            this.composeUri(t, "Bundle", "location", element.getLocationElement(), -1);
        }
        if (element.hasEtagElement()) {
            this.composeString(t, "Bundle", "etag", element.getEtagElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeInstant(t, "Bundle", "lastModified", element.getLastModifiedElement(), -1);
        }
        if (element.hasOutcome()) {
            this.composeResource(t, "Bundle", "outcome", element.getOutcome(), -1);
        }
    }

    protected void composeCapabilityStatement(Turtle.Complex parent, String parentType, String name, CapabilityStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "CapabilityStatement", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CapabilityStatement", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CapabilityStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CapabilityStatement", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CapabilityStatement", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CapabilityStatement", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CapabilityStatement", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CapabilityStatement", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CapabilityStatement", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "CapabilityStatement", "kind", element.getKindElement(), -1);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "instantiates", element.getInstantiates().get(i), i);
        }
        if (element.hasSoftware()) {
            this.composeCapabilityStatementCapabilityStatementSoftwareComponent(t, "CapabilityStatement", "software", element.getSoftware(), -1);
        }
        if (element.hasImplementation()) {
            this.composeCapabilityStatementCapabilityStatementImplementationComponent(t, "CapabilityStatement", "implementation", element.getImplementation(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeId(t, "CapabilityStatement", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getFormat().size(); ++i) {
            this.composeCode(t, "CapabilityStatement", "format", element.getFormat().get(i), i);
        }
        for (i = 0; i < element.getPatchFormat().size(); ++i) {
            this.composeCode(t, "CapabilityStatement", "patchFormat", element.getPatchFormat().get(i), i);
        }
        for (i = 0; i < element.getImplementationGuide().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "implementationGuide", element.getImplementationGuide().get(i), i);
        }
        for (i = 0; i < element.getRest().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestComponent(t, "CapabilityStatement", "rest", element.getRest().get(i), i);
        }
        for (i = 0; i < element.getMessaging().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementMessagingComponent(t, "CapabilityStatement", "messaging", element.getMessaging().get(i), i);
        }
        for (i = 0; i < element.getDocument().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementDocumentComponent(t, "CapabilityStatement", "document", element.getDocument().get(i), i);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementSoftwareComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementSoftwareComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "software", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
        }
        if (element.hasReleaseDateElement()) {
            this.composeDateTime(t, "CapabilityStatement", "releaseDate", element.getReleaseDateElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementImplementationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementImplementationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "implementation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rest", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatement", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasSecurity()) {
            this.composeCapabilityStatementCapabilityStatementRestSecurityComponent(t, "CapabilityStatement", "security", element.getSecurity(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceComponent(t, "CapabilityStatement", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeCapabilityStatementSystemInteractionComponent(t, "CapabilityStatement", "interaction", element.getInteraction().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatement", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatement", "operation", element.getOperation().get(i), i);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "compartment", element.getCompartment().get(i), i);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestSecurityComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestSecurityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "security", name, element, index);
        if (element.hasCorsElement()) {
            this.composeBoolean(t, "CapabilityStatement", "cors", element.getCorsElement(), -1);
        }
        for (int i = 0; i < element.getService().size(); ++i) {
            this.composeCodeableConcept(t, "CapabilityStatement", "service", element.getService().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestResourceComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "CapabilityStatement", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatement", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getSupportedProfile().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "supportedProfile", element.getSupportedProfile().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeCapabilityStatementResourceInteractionComponent(t, "CapabilityStatement", "interaction", element.getInteraction().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "CapabilityStatement", "versioning", element.getVersioningElement(), -1);
        }
        if (element.hasReadHistoryElement()) {
            this.composeBoolean(t, "CapabilityStatement", "readHistory", element.getReadHistoryElement(), -1);
        }
        if (element.hasUpdateCreateElement()) {
            this.composeBoolean(t, "CapabilityStatement", "updateCreate", element.getUpdateCreateElement(), -1);
        }
        if (element.hasConditionalCreateElement()) {
            this.composeBoolean(t, "CapabilityStatement", "conditionalCreate", element.getConditionalCreateElement(), -1);
        }
        if (element.hasConditionalReadElement()) {
            this.composeEnum(t, "CapabilityStatement", "conditionalRead", element.getConditionalReadElement(), -1);
        }
        if (element.hasConditionalUpdateElement()) {
            this.composeBoolean(t, "CapabilityStatement", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
        }
        if (element.hasConditionalDeleteElement()) {
            this.composeEnum(t, "CapabilityStatement", "conditionalDelete", element.getConditionalDeleteElement(), -1);
        }
        for (i = 0; i < element.getReferencePolicy().size(); ++i) {
            this.composeEnum(t, "CapabilityStatement", "referencePolicy", element.getReferencePolicy().get(i), i);
        }
        for (i = 0; i < element.getSearchInclude().size(); ++i) {
            this.composeString(t, "CapabilityStatement", "searchInclude", element.getSearchInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchRevInclude().size(); ++i) {
            this.composeString(t, "CapabilityStatement", "searchRevInclude", element.getSearchRevInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatement", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatement", "operation", element.getOperation().get(i), i);
        }
    }

    protected void composeCapabilityStatementResourceInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.ResourceInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CapabilityStatement", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "searchParam", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatement", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CapabilityStatement", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestResourceOperationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatement", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementSystemInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.SystemInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CapabilityStatement", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementMessagingComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "messaging", name, element, index);
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementMessagingEndpointComponent(t, "CapabilityStatement", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasReliableCacheElement()) {
            this.composeUnsignedInt(t, "CapabilityStatement", "reliableCache", element.getReliableCacheElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getSupportedMessage().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(t, "CapabilityStatement", "supportedMessage", element.getSupportedMessage().get(i), i);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementMessagingEndpointComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingEndpointComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "endpoint", name, element, index);
        if (element.hasProtocol()) {
            this.composeCoding(t, "CapabilityStatement", "protocol", element.getProtocol(), -1);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "CapabilityStatement", "address", element.getAddressElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "supportedMessage", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatement", "mode", element.getModeElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatement", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementDocumentComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementDocumentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "document", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatement", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatement", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeCarePlan(Turtle.Complex parent, String parentType, String name, CarePlan element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "CarePlan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "CarePlan", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "CarePlan", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "CarePlan", "replaces", element.getReplaces().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "CarePlan", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "CarePlan", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CarePlan", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "CarePlan", "context", element.getContext(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "CarePlan", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeReference(t, "CarePlan", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "CarePlan", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "CarePlan", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getActivity().size(); ++i) {
            this.composeCarePlanCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CarePlan", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCarePlanCarePlanActivityComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "activity", name, element, index);
        for (i = 0; i < element.getOutcomeCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "outcomeCodeableConcept", element.getOutcomeCodeableConcept().get(i), i);
        }
        for (i = 0; i < element.getOutcomeReference().size(); ++i) {
            this.composeReference(t, "CarePlan", "outcomeReference", element.getOutcomeReference().get(i), i);
        }
        for (i = 0; i < element.getProgress().size(); ++i) {
            this.composeAnnotation(t, "CarePlan", "progress", element.getProgress().get(i), i);
        }
        if (element.hasReference()) {
            this.composeReference(t, "CarePlan", "reference", element.getReference(), -1);
        }
        if (element.hasDetail()) {
            this.composeCarePlanCarePlanActivityDetailComponent(t, "CarePlan", "detail", element.getDetail(), -1);
        }
    }

    protected void composeCarePlanCarePlanActivityDetailComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "CarePlan", "kind", element.getKindElement(), -1);
        }
        if (element.hasInstantiatesElement()) {
            this.composeUri(t, "CarePlan", "instantiates", element.getInstantiatesElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CarePlan", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CarePlan", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReasonElement()) {
            this.composeString(t, "CarePlan", "statusReason", element.getStatusReasonElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CarePlan", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "CarePlan", "scheduled", element.getScheduled(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "CarePlan", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "CarePlan", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "CarePlan", "product", element.getProduct(), -1);
        }
        if (element.hasDailyAmount()) {
            this.composeQuantity(t, "CarePlan", "dailyAmount", element.getDailyAmount(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "CarePlan", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCareTeam(Turtle.Complex parent, String parentType, String name, CareTeam element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "CareTeam", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CareTeam", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "category", element.getCategory().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CareTeam", "name", element.getNameElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "CareTeam", "context", element.getContext(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeCareTeamCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CareTeam", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getManagingOrganization().size(); ++i) {
            this.composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "CareTeam", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CareTeam", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCareTeamCareTeamParticipantComponent(Turtle.Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeam", "role", element.getRole(), -1);
        }
        if (element.hasMember()) {
            this.composeReference(t, "CareTeam", "member", element.getMember(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "CareTeam", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
    }

    protected void composeChargeItem(Turtle.Complex parent, String parentType, String name, ChargeItem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ChargeItem", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ChargeItem", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getDefinition().size(); ++i) {
            this.composeUri(t, "ChargeItem", "definition", element.getDefinition().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItem", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "ChargeItem", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItem", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ChargeItem", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ChargeItem", "context", element.getContext(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ChargeItem", "occurrence", element.getOccurrence(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeChargeItemChargeItemParticipantComponent(t, "ChargeItem", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasPerformingOrganization()) {
            this.composeReference(t, "ChargeItem", "performingOrganization", element.getPerformingOrganization(), -1);
        }
        if (element.hasRequestingOrganization()) {
            this.composeReference(t, "ChargeItem", "requestingOrganization", element.getRequestingOrganization(), -1);
        }
        if (element.hasCostCenter()) {
            this.composeReference(t, "ChargeItem", "costCenter", element.getCostCenter(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ChargeItem", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getBodysite().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItem", "bodysite", element.getBodysite().get(i), i);
        }
        if (element.hasFactorOverrideElement()) {
            this.composeDecimal(t, "ChargeItem", "factorOverride", element.getFactorOverrideElement(), -1);
        }
        if (element.hasPriceOverride()) {
            this.composeMoney(t, "ChargeItem", "priceOverride", element.getPriceOverride(), -1);
        }
        if (element.hasOverrideReasonElement()) {
            this.composeString(t, "ChargeItem", "overrideReason", element.getOverrideReasonElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ChargeItem", "enterer", element.getEnterer(), -1);
        }
        if (element.hasEnteredDateElement()) {
            this.composeDateTime(t, "ChargeItem", "enteredDate", element.getEnteredDateElement(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItem", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getService().size(); ++i) {
            this.composeReference(t, "ChargeItem", "service", element.getService().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "ChargeItem", "account", element.getAccount().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ChargeItem", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "ChargeItem", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
    }

    protected void composeChargeItemChargeItemParticipantComponent(Turtle.Complex parent, String parentType, String name, ChargeItem.ChargeItemParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ChargeItem", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ChargeItem", "actor", element.getActor(), -1);
        }
    }

    protected void composeClaim(Turtle.Complex parent, String parentType, String name, Claim element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Claim", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Claim", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "subType", element.getSubType().get(i), i);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "Claim", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Claim", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "Claim", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "Claim", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Claim", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeClaimRelatedClaimComponent(t, "Claim", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "Claim", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "Claim", "referral", element.getReferral(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "Claim", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeClaimCareTeamComponent(t, "Claim", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getInformation().size(); ++i) {
            this.composeClaimSpecialConditionComponent(t, "Claim", "information", element.getInformation().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeClaimInsuranceComponent(t, "Claim", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasAccident()) {
            this.composeClaimAccidentComponent(t, "Claim", "accident", element.getAccident(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimItemComponent(t, "Claim", "item", element.getItem().get(i), i);
        }
        if (element.hasTotal()) {
            this.composeMoney(t, "Claim", "total", element.getTotal(), -1);
        }
    }

    protected void composeClaimRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, Claim.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "Claim", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "Claim", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "Claim", "reference", element.getReference(), -1);
        }
    }

    protected void composeClaimPayeeComponent(Turtle.Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasResource()) {
            this.composeCoding(t, "Claim", "resource", element.getResource(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Claim", "party", element.getParty(), -1);
        }
    }

    protected void composeClaimCareTeamComponent(Turtle.Complex parent, String parentType, String name, Claim.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "Claim", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Claim", "role", element.getRole(), -1);
        }
        if (element.hasQualification()) {
            this.composeCodeableConcept(t, "Claim", "qualification", element.getQualification(), -1);
        }
    }

    protected void composeClaimSpecialConditionComponent(Turtle.Complex parent, String parentType, String name, Claim.SpecialConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "information", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Claim", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "Claim", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Claim", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "Claim", "reason", element.getReason(), -1);
        }
    }

    protected void composeClaimDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "Claim", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType().get(i), i);
        }
        if (element.hasPackageCode()) {
            this.composeCodeableConcept(t, "Claim", "packageCode", element.getPackageCode(), -1);
        }
    }

    protected void composeClaimProcedureComponent(Turtle.Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Claim", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "Claim", "procedure", element.getProcedure(), -1);
        }
    }

    protected void composeClaimInsuranceComponent(Turtle.Complex parent, String parentType, String name, Claim.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "Claim", "focal", element.getFocalElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "Claim", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "Claim", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "Claim", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "Claim", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimAccidentComponent(Turtle.Complex parent, String parentType, String name, Claim.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "Claim", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "Claim", "location", element.getLocation(), -1);
        }
    }

    protected void composeClaimItemComponent(Turtle.Complex parent, String parentType, String name, Claim.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getCareTeamSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "careTeamSequence", element.getCareTeamSequence().get(i), i);
        }
        for (i = 0; i < element.getDiagnosisSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
        }
        for (i = 0; i < element.getProcedureSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "procedureSequence", element.getProcedureSequence().get(i), i);
        }
        for (i = 0; i < element.getInformationSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "informationSequence", element.getInformationSequence().get(i), i);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "Claim", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "Claim", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "Claim", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "Claim", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Claim", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "Claim", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimDetailComponent(t, "Claim", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "Claim", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "Claim", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimSubDetailComponent(t, "Claim", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimSubDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "Claim", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "Claim", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeClaimResponse(Turtle.Complex parent, String parentType, String name, ClaimResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ClaimResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClaimResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "subType", element.getSubType().get(i), i);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ClaimResponse", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ClaimResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ClaimResponse", "insurer", element.getInsurer(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "ClaimResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "ClaimResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPayeeType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimResponseItemComponent(t, "ClaimResponse", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeClaimResponseErrorComponent(t, "ClaimResponse", "error", element.getError().get(i), i);
        }
        for (i = 0; i < element.getTotal().size(); ++i) {
            this.composeClaimResponseTotalComponent(t, "ClaimResponse", "total", element.getTotal().get(i), i);
        }
        if (element.hasPayment()) {
            this.composeClaimResponsePaymentComponent(t, "ClaimResponse", "payment", element.getPayment(), -1);
        }
        if (element.hasReserved()) {
            this.composeCoding(t, "ClaimResponse", "reserved", element.getReserved(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "ClaimResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeClaimResponseNoteComponent(t, "ClaimResponse", "processNote", element.getProcessNote().get(i), i);
        }
        for (i = 0; i < element.getCommunicationRequest().size(); ++i) {
            this.composeReference(t, "ClaimResponse", "communicationRequest", element.getCommunicationRequest().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeClaimResponseInsuranceComponent(t, "ClaimResponse", "insurance", element.getInsurance().get(i), i);
        }
    }

    protected void composeClaimResponseItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "itemSequence", element.getItemSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseItemDetailComponent(t, "ClaimResponse", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimResponseSubDetailComponent(t, "ClaimResponse", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimResponseSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getItemSequence().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "itemSequence", element.getItemSequence().get(i), i);
        }
        for (i = 0; i < element.getDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequence", element.getDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getSubdetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "subdetailSequence", element.getSubdetailSequence().get(i), i);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "ClaimResponse", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasFee()) {
            this.composeMoney(t, "ClaimResponse", "fee", element.getFee(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseErrorComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ErrorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "itemSequence", element.getItemSequenceElement(), -1);
        }
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClaimResponse", "code", element.getCode(), -1);
        }
    }

    protected void composeClaimResponseTotalComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
    }

    protected void composeClaimResponsePaymentComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "ClaimResponse", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "ClaimResponse", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "ClaimResponse", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeClaimResponseNoteComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "ClaimResponse", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ClaimResponse", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ClaimResponse", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "ClaimResponse", "language", element.getLanguage(), -1);
        }
    }

    protected void composeClaimResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "ClaimResponse", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "ClaimResponse", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "ClaimResponse", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ClaimResponse", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClinicalImpression(Turtle.Complex parent, String parentType, String name, ClinicalImpression element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ClinicalImpression", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClinicalImpression", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ClinicalImpression", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ClinicalImpression", "context", element.getContext(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "ClinicalImpression", "effective", element.getEffective(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
        }
        if (element.hasAssessor()) {
            this.composeReference(t, "ClinicalImpression", "assessor", element.getAssessor(), -1);
        }
        if (element.hasPrevious()) {
            this.composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
        }
        for (i = 0; i < element.getProblem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i), i);
        }
        for (i = 0; i < element.getInvestigation().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionInvestigationComponent(t, "ClinicalImpression", "investigation", element.getInvestigation().get(i), i);
        }
        for (i = 0; i < element.getProtocol().size(); ++i) {
            this.composeUri(t, "ClinicalImpression", "protocol", element.getProtocol().get(i), i);
        }
        if (element.hasSummaryElement()) {
            this.composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
        }
        for (i = 0; i < element.getFinding().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i), i);
        }
        for (i = 0; i < element.getPrognosisCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "ClinicalImpression", "prognosisCodeableConcept", element.getPrognosisCodeableConcept().get(i), i);
        }
        for (i = 0; i < element.getPrognosisReference().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "prognosisReference", element.getPrognosisReference().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ClinicalImpression", "note", element.getNote().get(i), i);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionInvestigationComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionInvestigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "investigation", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "item", element.getItem().get(i), i);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionFindingComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "finding", name, element, index);
        if (element.hasItemCodeableConcept()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "itemCodeableConcept", element.getItemCodeableConcept(), -1);
        }
        if (element.hasItemReference()) {
            this.composeReference(t, "ClinicalImpression", "itemReference", element.getItemReference(), -1);
        }
        if (element.hasBasisElement()) {
            this.composeString(t, "ClinicalImpression", "basis", element.getBasisElement(), -1);
        }
    }

    protected void composeCodeSystem(Turtle.Complex parent, String parentType, String name, CodeSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "CodeSystem", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CodeSystem", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CodeSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CodeSystem", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CodeSystem", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CodeSystem", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCaseSensitiveElement()) {
            this.composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasHierarchyMeaningElement()) {
            this.composeEnum(t, "CodeSystem", "hierarchyMeaning", element.getHierarchyMeaningElement(), -1);
        }
        if (element.hasCompositionalElement()) {
            this.composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
        }
        if (element.hasVersionNeededElement()) {
            this.composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
        }
        if (element.hasContentElement()) {
            this.composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
        }
        if (element.hasSupplementsElement()) {
            this.composeCanonical(t, "CodeSystem", "supplements", element.getSupplementsElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeCodeSystemCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemCodeSystemFilterComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getOperator().size(); ++i) {
            this.composeEnum(t, "CodeSystem", "operator", element.getOperator().get(i), i);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystem", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.PropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "CodeSystem", "uri", element.getUriElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CodeSystem", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeCodeSystemConceptDefinitionComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "CodeSystem", "display", element.getDisplayElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeString(t, "CodeSystem", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getDesignation().size(); ++i) {
            this.composeCodeSystemConceptDefinitionDesignationComponent(t, "CodeSystem", "designation", element.getDesignation().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemConceptPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemConceptDefinitionDesignationComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "CodeSystem", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "CodeSystem", "use", element.getUse(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystem", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemConceptPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "CodeSystem", "value", element.getValue(), -1);
        }
    }

    protected void composeCommunication(Turtle.Complex parent, String parentType, String name, Communication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Communication", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "Communication", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Communication", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Communication", "partOf", element.getPartOf().get(i), i);
        }
        for (i = 0; i < element.getInResponseTo().size(); ++i) {
            this.composeReference(t, "Communication", "inResponseTo", element.getInResponseTo().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Communication", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "Communication", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Communication", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "Communication", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasTopic()) {
            this.composeCodeableConcept(t, "Communication", "topic", element.getTopic(), -1);
        }
        for (i = 0; i < element.getAbout().size(); ++i) {
            this.composeReference(t, "Communication", "about", element.getAbout().get(i), i);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Communication", "context", element.getContext(), -1);
        }
        if (element.hasSentElement()) {
            this.composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
        }
        if (element.hasReceivedElement()) {
            this.composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
        }
        if (element.hasSender()) {
            this.composeReference(t, "Communication", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Communication", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Communication", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCommunicationCommunicationPayloadComponent(Turtle.Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Communication", "content", element.getContent(), -1);
        }
    }

    protected void composeCommunicationRequest(Turtle.Complex parent, String parentType, String name, CommunicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "CommunicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "CommunicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "CommunicationRequest", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i), i);
        }
        for (i = 0; i < element.getAbout().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "about", element.getAbout().get(i), i);
        }
        if (element.hasContext()) {
            this.composeReference(t, "CommunicationRequest", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationRequestCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i), i);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "CommunicationRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "CommunicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasSender()) {
            this.composeReference(t, "CommunicationRequest", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CommunicationRequest", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCommunicationRequestCommunicationRequestPayloadComponent(Turtle.Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationRequest", "content", element.getContent(), -1);
        }
    }

    protected void composeCompartmentDefinition(Turtle.Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "CompartmentDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CompartmentDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CompartmentDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CompartmentDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CompartmentDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasSearchElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCompartmentDefinitionCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i), i);
        }
    }

    protected void composeCompartmentDefinitionCompartmentDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeString(t, "CompartmentDefinition", "param", element.getParam().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CompartmentDefinition", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeComposition(Turtle.Complex parent, String parentType, String name, Composition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Composition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Composition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
        }
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "Composition", "class", element.getClass_(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Composition", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasConfidentialityElement()) {
            this.composeEnum(t, "Composition", "confidentiality", element.getConfidentialityElement(), -1);
        }
        for (i = 0; i < element.getAttester().size(); ++i) {
            this.composeCompositionCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i), i);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeCompositionCompositionRelatesToComponent(t, "Composition", "relatesTo", element.getRelatesTo().get(i), i);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCompositionCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i), i);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeCompositionCompositionAttesterComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "attester", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Composition", "mode", element.getModeElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Composition", "time", element.getTimeElement(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Composition", "party", element.getParty(), -1);
        }
    }

    protected void composeCompositionCompositionRelatesToComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "Composition", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "Composition", "target", element.getTarget(), -1);
        }
    }

    protected void composeCompositionCompositionEventComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "event", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Composition", "code", element.getCode().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Composition", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Composition", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeCompositionSectionComponent(Turtle.Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Composition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "Composition", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Composition", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "Composition", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeReference(t, "Composition", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "Composition", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeConceptMap(Turtle.Complex parent, String parentType, String name, ConceptMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ConceptMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ConceptMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ConceptMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ConceptMap", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ConceptMap", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ConceptMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasSource()) {
            this.composeType(t, "ConceptMap", "source", element.getSource(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "ConceptMap", "target", element.getTarget(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeConceptMapConceptMapGroupComponent(t, "ConceptMap", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeConceptMapConceptMapGroupComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasSourceElement()) {
            this.composeUri(t, "ConceptMap", "source", element.getSourceElement(), -1);
        }
        if (element.hasSourceVersionElement()) {
            this.composeString(t, "ConceptMap", "sourceVersion", element.getSourceVersionElement(), -1);
        }
        if (element.hasTargetElement()) {
            this.composeUri(t, "ConceptMap", "target", element.getTargetElement(), -1);
        }
        if (element.hasTargetVersionElement()) {
            this.composeString(t, "ConceptMap", "targetVersion", element.getTargetVersionElement(), -1);
        }
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeConceptMapSourceElementComponent(t, "ConceptMap", "element", element.getElement().get(i), i);
        }
        if (element.hasUnmapped()) {
            this.composeConceptMapConceptMapGroupUnmappedComponent(t, "ConceptMap", "unmapped", element.getUnmapped(), -1);
        }
    }

    protected void composeConceptMapSourceElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "element", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeConceptMapTargetElementComponent(t, "ConceptMap", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeConceptMapTargetElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
        if (element.hasEquivalenceElement()) {
            this.composeEnum(t, "ConceptMap", "equivalence", element.getEquivalenceElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "ConceptMap", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "ConceptMap", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getProduct().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "ConceptMap", "product", element.getProduct().get(i), i);
        }
    }

    protected void composeConceptMapOtherElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasPropertyElement()) {
            this.composeUri(t, "ConceptMap", "property", element.getPropertyElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeCanonical(t, "ConceptMap", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ConceptMap", "value", element.getValueElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeConceptMapConceptMapGroupUnmappedComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupUnmappedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "unmapped", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "ConceptMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeCanonical(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeCondition(Turtle.Complex parent, String parentType, String name, Condition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Condition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClinicalStatusElement()) {
            this.composeEnum(t, "Condition", "clinicalStatus", element.getClinicalStatusElement(), -1);
        }
        if (element.hasVerificationStatusElement()) {
            this.composeEnum(t, "Condition", "verificationStatus", element.getVerificationStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "category", element.getCategory().get(i), i);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Condition", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Condition", "context", element.getContext(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "Condition", "onset", element.getOnset(), -1);
        }
        if (element.hasAbatement()) {
            this.composeType(t, "Condition", "abatement", element.getAbatement(), -1);
        }
        if (element.hasAssertedDateElement()) {
            this.composeDateTime(t, "Condition", "assertedDate", element.getAssertedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "Condition", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Condition", "asserter", element.getAsserter(), -1);
        }
        for (i = 0; i < element.getStage().size(); ++i) {
            this.composeConditionConditionStageComponent(t, "Condition", "stage", element.getStage().get(i), i);
        }
        for (i = 0; i < element.getEvidence().size(); ++i) {
            this.composeConditionConditionEvidenceComponent(t, "Condition", "evidence", element.getEvidence().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Condition", "note", element.getNote().get(i), i);
        }
    }

    protected void composeConditionConditionStageComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "stage", name, element, index);
        if (element.hasSummary()) {
            this.composeCodeableConcept(t, "Condition", "summary", element.getSummary(), -1);
        }
        for (int i = 0; i < element.getAssessment().size(); ++i) {
            this.composeReference(t, "Condition", "assessment", element.getAssessment().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Condition", "type", element.getType(), -1);
        }
    }

    protected void composeConditionConditionEvidenceComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionEvidenceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Condition", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeConsent(Turtle.Complex parent, String parentType, String name, Consent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Consent", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Consent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Consent", "status", element.getStatusElement(), -1);
        }
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Consent", "scope", element.getScope(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "category", element.getCategory().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Consent", "patient", element.getPatient(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "Consent", "dateTime", element.getDateTimeElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Consent", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getOrganization().size(); ++i) {
            this.composeReference(t, "Consent", "organization", element.getOrganization().get(i), i);
        }
        if (element.hasSource()) {
            this.composeType(t, "Consent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeConsentConsentPolicyComponent(t, "Consent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasPolicyRule()) {
            this.composeCodeableConcept(t, "Consent", "policyRule", element.getPolicyRule(), -1);
        }
        for (i = 0; i < element.getVerification().size(); ++i) {
            this.composeConsentConsentVerificationComponent(t, "Consent", "verification", element.getVerification().get(i), i);
        }
        if (element.hasProvision()) {
            this.composeConsentprovisionComponent(t, "Consent", "provision", element.getProvision(), -1);
        }
    }

    protected void composeConsentConsentPolicyComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentPolicyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "policy", name, element, index);
        if (element.hasAuthorityElement()) {
            this.composeUri(t, "Consent", "authority", element.getAuthorityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "Consent", "uri", element.getUriElement(), -1);
        }
    }

    protected void composeConsentConsentVerificationComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentVerificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "verification", name, element, index);
        if (element.hasVerifiedElement()) {
            this.composeBoolean(t, "Consent", "verified", element.getVerifiedElement(), -1);
        }
        if (element.hasVerifiedWith()) {
            this.composeReference(t, "Consent", "verifiedWith", element.getVerifiedWith(), -1);
        }
        if (element.hasVerificationDateElement()) {
            this.composeDateTime(t, "Consent", "verificationDate", element.getVerificationDateElement(), -1);
        }
    }

    protected void composeConsentprovisionComponent(Turtle.Complex parent, String parentType, String name, Consent.provisionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "provision", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Consent", "type", element.getTypeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Consent", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeConsentprovisionActorComponent(t, "Consent", "actor", element.getActor().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "Consent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeCoding(t, "Consent", "purpose", element.getPurpose().get(i), i);
        }
        for (i = 0; i < element.getClass_().size(); ++i) {
            this.composeCoding(t, "Consent", "class", element.getClass_().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "code", element.getCode().get(i), i);
        }
        if (element.hasDataPeriod()) {
            this.composePeriod(t, "Consent", "dataPeriod", element.getDataPeriod(), -1);
        }
        for (i = 0; i < element.getData().size(); ++i) {
            this.composeConsentprovisionDataComponent(t, "Consent", "data", element.getData().get(i), i);
        }
        for (i = 0; i < element.getProvision().size(); ++i) {
            this.composeConsentprovisionComponent(t, "Consent", "provision", element.getProvision().get(i), i);
        }
    }

    protected void composeConsentprovisionActorComponent(Turtle.Complex parent, String parentType, String name, Consent.provisionActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Consent", "role", element.getRole(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "Consent", "reference", element.getReference(), -1);
        }
    }

    protected void composeConsentprovisionDataComponent(Turtle.Complex parent, String parentType, String name, Consent.provisionDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "data", name, element, index);
        if (element.hasMeaningElement()) {
            this.composeEnum(t, "Consent", "meaning", element.getMeaningElement(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "Consent", "reference", element.getReference(), -1);
        }
    }

    protected void composeContract(Turtle.Complex parent, String parentType, String name, Contract element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Contract", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Contract", "status", element.getStatusElement(), -1);
        }
        if (element.hasContentDerivative()) {
            this.composeCodeableConcept(t, "Contract", "contentDerivative", element.getContentDerivative(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "Contract", "subject", element.getSubject().get(i), i);
        }
        for (i = 0; i < element.getAuthority().size(); ++i) {
            this.composeReference(t, "Contract", "authority", element.getAuthority().get(i), i);
        }
        for (i = 0; i < element.getDomain().size(); ++i) {
            this.composeReference(t, "Contract", "domain", element.getDomain().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i), i);
        }
        for (i = 0; i < element.getTerm().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i), i);
        }
        for (i = 0; i < element.getSigner().size(); ++i) {
            this.composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i), i);
        }
        for (i = 0; i < element.getFriendly().size(); ++i) {
            this.composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i), i);
        }
        for (i = 0; i < element.getLegal().size(); ++i) {
            this.composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i), i);
        }
        if (element.hasRule()) {
            this.composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule(), -1);
        }
        if (element.hasLegallyBinding()) {
            this.composeType(t, "Contract", "legallyBinding", element.getLegallyBinding(), -1);
        }
    }

    protected void composeContractTermComponent(Turtle.Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "term", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType(), -1);
        }
        if (element.hasOffer()) {
            this.composeContractContractOfferComponent(t, "Contract", "offer", element.getOffer(), -1);
        }
        for (i = 0; i < element.getAsset().size(); ++i) {
            this.composeContractContractAssetComponent(t, "Contract", "asset", element.getAsset().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeContractAgentComponent(t, "Contract", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getActionReason().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "actionReason", element.getActionReason().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeContractContractOfferComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractOfferComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "offer", name, element, index);
        if (element.hasTopic()) {
            this.composeReference(t, "Contract", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "Contract", "decision", element.getDecision(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Contract", "text", element.getTextElement(), -1);
        }
        if (element.hasLinkIdElement()) {
            this.composeString(t, "Contract", "linkId", element.getLinkIdElement(), -1);
        }
    }

    protected void composeContractContractAssetComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractAssetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "asset", name, element, index);
        if (element.hasClass_()) {
            this.composeCoding(t, "Contract", "class", element.getClass_(), -1);
        }
        if (element.hasCode()) {
            this.composeCoding(t, "Contract", "code", element.getCode(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Contract", "period", element.getPeriod(), -1);
        }
        if (element.hasDataPeriod()) {
            this.composePeriod(t, "Contract", "dataPeriod", element.getDataPeriod(), -1);
        }
        for (i = 0; i < element.getData().size(); ++i) {
            this.composeContractAssetDataComponent(t, "Contract", "data", element.getData().get(i), i);
        }
        for (i = 0; i < element.getValuedItem().size(); ++i) {
            this.composeContractValuedItemComponent(t, "Contract", "valuedItem", element.getValuedItem().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "Contract", "securityLabel", element.getSecurityLabel().get(i), i);
        }
    }

    protected void composeContractAssetDataComponent(Turtle.Complex parent, String parentType, String name, Contract.AssetDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "data", name, element, index);
        if (element.hasMeaningElement()) {
            this.composeEnum(t, "Contract", "meaning", element.getMeaningElement(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "Contract", "reference", element.getReference(), -1);
        }
    }

    protected void composeContractValuedItemComponent(Turtle.Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "valuedItem", name, element, index);
        if (element.hasEntity()) {
            this.composeType(t, "Contract", "entity", element.getEntity(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTime(t, "Contract", "effectiveTime", element.getEffectiveTimeElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Contract", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Contract", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Contract", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Contract", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Contract", "net", element.getNet(), -1);
        }
    }

    protected void composeContractAgentComponent(Turtle.Complex parent, String parentType, String name, Contract.AgentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasActor()) {
            this.composeReference(t, "Contract", "actor", element.getActor(), -1);
        }
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "role", element.getRole().get(i), i);
        }
    }

    protected void composeContractSignatoryComponent(Turtle.Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "signer", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Contract", "party", element.getParty(), -1);
        }
        for (int i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Contract", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeContractFriendlyLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "friendly", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeContractLegalLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "legal", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeContractComputableLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeCoverage(Turtle.Complex parent, String parentType, String name, Coverage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Coverage", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Coverage", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasPolicyHolder()) {
            this.composeReference(t, "Coverage", "policyHolder", element.getPolicyHolder(), -1);
        }
        if (element.hasSubscriber()) {
            this.composeReference(t, "Coverage", "subscriber", element.getSubscriber(), -1);
        }
        if (element.hasSubscriberIdElement()) {
            this.composeString(t, "Coverage", "subscriberId", element.getSubscriberIdElement(), -1);
        }
        if (element.hasBeneficiary()) {
            this.composeReference(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
        }
        if (element.hasDependentElement()) {
            this.composeString(t, "Coverage", "dependent", element.getDependentElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "Coverage", "relationship", element.getRelationship(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getPayor().size(); ++i) {
            this.composeReference(t, "Coverage", "payor", element.getPayor().get(i), i);
        }
        for (i = 0; i < element.getClass_().size(); ++i) {
            this.composeCoverageClassComponent(t, "Coverage", "class", element.getClass_().get(i), i);
        }
        if (element.hasOrderElement()) {
            this.composePositiveInt(t, "Coverage", "order", element.getOrderElement(), -1);
        }
        if (element.hasNetworkElement()) {
            this.composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
        }
        for (i = 0; i < element.getCopay().size(); ++i) {
            this.composeCoverageCoPayComponent(t, "Coverage", "copay", element.getCopay().get(i), i);
        }
        for (i = 0; i < element.getContract().size(); ++i) {
            this.composeReference(t, "Coverage", "contract", element.getContract().get(i), i);
        }
    }

    protected void composeCoverageClassComponent(Turtle.Complex parent, String parentType, String name, Coverage.ClassComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "class", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Coverage", "value", element.getValueElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Coverage", "name", element.getNameElement(), -1);
        }
    }

    protected void composeCoverageCoPayComponent(Turtle.Complex parent, String parentType, String name, Coverage.CoPayComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "copay", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "Coverage", "value", element.getValue(), -1);
        }
    }

    protected void composeDetectedIssue(Turtle.Complex parent, String parentType, String name, DetectedIssue element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DetectedIssue", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DetectedIssue", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetectedIssue", "category", element.getCategory(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "DetectedIssue", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssue", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getImplicated().size(); ++i) {
            this.composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i), i);
        }
        if (element.hasDetailElement()) {
            this.composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
        }
        for (i = 0; i < element.getMitigation().size(); ++i) {
            this.composeDetectedIssueDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i), i);
        }
    }

    protected void composeDetectedIssueDetectedIssueMitigationComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "mitigation", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "DetectedIssue", "action", element.getAction(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssue", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
    }

    protected void composeDevice(Turtle.Complex parent, String parentType, String name, Device element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Device", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasUdi()) {
            this.composeDeviceDeviceUdiComponent(t, "Device", "udi", element.getUdi(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Device", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Device", "type", element.getType(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasManufacturerElement()) {
            this.composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasModelElement()) {
            this.composeString(t, "Device", "model", element.getModelElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Device", "version", element.getVersionElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Device", "patient", element.getPatient(), -1);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Device", "owner", element.getOwner(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Device", "contact", element.getContact().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Device", "location", element.getLocation(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Device", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Device", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSafety().size(); ++i) {
            this.composeCodeableConcept(t, "Device", "safety", element.getSafety().get(i), i);
        }
    }

    protected void composeDeviceDeviceUdiComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceUdiComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "udi", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "Device", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Device", "name", element.getNameElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "Device", "jurisdiction", element.getJurisdictionElement(), -1);
        }
        if (element.hasCarrierHRFElement()) {
            this.composeString(t, "Device", "carrierHRF", element.getCarrierHRFElement(), -1);
        }
        if (element.hasCarrierAIDCElement()) {
            this.composeBase64Binary(t, "Device", "carrierAIDC", element.getCarrierAIDCElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "Device", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasEntryTypeElement()) {
            this.composeEnum(t, "Device", "entryType", element.getEntryTypeElement(), -1);
        }
    }

    protected void composeDeviceComponent(Turtle.Complex parent, String parentType, String name, DeviceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DeviceComponent", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceComponent", "type", element.getType(), -1);
        }
        if (element.hasLastSystemChangeElement()) {
            this.composeInstant(t, "DeviceComponent", "lastSystemChange", element.getLastSystemChangeElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceComponent", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceComponent", "parent", element.getParent(), -1);
        }
        for (i = 0; i < element.getOperationalStatus().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceComponent", "operationalStatus", element.getOperationalStatus().get(i), i);
        }
        if (element.hasParameterGroup()) {
            this.composeCodeableConcept(t, "DeviceComponent", "parameterGroup", element.getParameterGroup(), -1);
        }
        if (element.hasMeasurementPrincipleElement()) {
            this.composeEnum(t, "DeviceComponent", "measurementPrinciple", element.getMeasurementPrincipleElement(), -1);
        }
        for (i = 0; i < element.getProductionSpecification().size(); ++i) {
            this.composeDeviceComponentDeviceComponentProductionSpecificationComponent(t, "DeviceComponent", "productionSpecification", element.getProductionSpecification().get(i), i);
        }
        if (element.hasLanguageCode()) {
            this.composeCodeableConcept(t, "DeviceComponent", "languageCode", element.getLanguageCode(), -1);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeDeviceComponentDeviceComponentPropertyComponent(t, "DeviceComponent", "property", element.getProperty().get(i), i);
        }
    }

    protected void composeDeviceComponentDeviceComponentProductionSpecificationComponent(Turtle.Complex parent, String parentType, String name, DeviceComponent.DeviceComponentProductionSpecificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "productionSpecification", name, element, index);
        if (element.hasSpecType()) {
            this.composeCodeableConcept(t, "DeviceComponent", "specType", element.getSpecType(), -1);
        }
        if (element.hasComponentId()) {
            this.composeIdentifier(t, "DeviceComponent", "componentId", element.getComponentId(), -1);
        }
        if (element.hasProductionSpecElement()) {
            this.composeString(t, "DeviceComponent", "productionSpec", element.getProductionSpecElement(), -1);
        }
    }

    protected void composeDeviceComponentDeviceComponentPropertyComponent(Turtle.Complex parent, String parentType, String name, DeviceComponent.DeviceComponentPropertyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getValueQuantity().size(); ++i) {
            this.composeQuantity(t, "DeviceComponent", "valueQuantity", element.getValueQuantity().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceComponent", "valueCode", element.getValueCode().get(i), i);
        }
    }

    protected void composeDeviceMetric(Turtle.Complex parent, String parentType, String name, DeviceMetric element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DeviceMetric", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
        }
        if (element.hasOperationalStatusElement()) {
            this.composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
        }
        if (element.hasColorElement()) {
            this.composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
        }
        if (element.hasMeasurementPeriod()) {
            this.composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
        }
        for (i = 0; i < element.getCalibration().size(); ++i) {
            this.composeDeviceMetricDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i), i);
        }
    }

    protected void composeDeviceMetricDeviceMetricCalibrationComponent(Turtle.Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "calibration", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceMetric", "type", element.getTypeElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeEnum(t, "DeviceMetric", "state", element.getStateElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeInstant(t, "DeviceMetric", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeDeviceRequest(Turtle.Complex parent, String parentType, String name, DeviceRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DeviceRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "DeviceRequest", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPriorRequest().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "priorRequest", element.getPriorRequest().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "DeviceRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntent()) {
            this.composeCodeableConcept(t, "DeviceRequest", "intent", element.getIntent(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "DeviceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeType(t, "DeviceRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeDeviceRequestDeviceRequestParameterComponent(t, "DeviceRequest", "parameter", element.getParameter().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "DeviceRequest", "context", element.getContext(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "DeviceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "DeviceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "DeviceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "DeviceRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "DeviceRequest", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceRequest", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
    }

    protected void composeDeviceRequestDeviceRequestParameterComponent(Turtle.Complex parent, String parentType, String name, DeviceRequest.DeviceRequestParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DeviceRequest", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DeviceRequest", "value", element.getValue(), -1);
        }
    }

    protected void composeDeviceUseStatement(Turtle.Complex parent, String parentType, String name, DeviceUseStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DeviceUseStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceUseStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceUseStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceUseStatement", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "DeviceUseStatement", "timing", element.getTiming(), -1);
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTime(t, "DeviceUseStatement", "recordedOn", element.getRecordedOnElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceUseStatement", "source", element.getSource(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "DeviceUseStatement", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceUseStatement", "note", element.getNote().get(i), i);
        }
    }

    protected void composeDiagnosticReport(Turtle.Complex parent, String parentType, String name, DiagnosticReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DiagnosticReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "DiagnosticReport", "context", element.getContext(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getResultsInterpreter().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "resultsInterpreter", element.getResultsInterpreter().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getResult().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "result", element.getResult().get(i), i);
        }
        for (i = 0; i < element.getImagingStudy().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "imagingStudy", element.getImagingStudy().get(i), i);
        }
        for (i = 0; i < element.getMedia().size(); ++i) {
            this.composeDiagnosticReportDiagnosticReportMediaComponent(t, "DiagnosticReport", "media", element.getMedia().get(i), i);
        }
        if (element.hasConclusionElement()) {
            this.composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
        }
        for (i = 0; i < element.getCodedDiagnosis().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticReport", "codedDiagnosis", element.getCodedDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getPresentedForm().size(); ++i) {
            this.composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i), i);
        }
    }

    protected void composeDiagnosticReportDiagnosticReportMediaComponent(Turtle.Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportMediaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "media", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "DiagnosticReport", "comment", element.getCommentElement(), -1);
        }
        if (element.hasLink()) {
            this.composeReference(t, "DiagnosticReport", "link", element.getLink(), -1);
        }
    }

    protected void composeDocumentManifest(Turtle.Complex parent, String parentType, String name, DocumentManifest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DocumentManifest", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeDocumentManifestDocumentManifestAgentComponent(t, "DocumentManifest", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "content", element.getContent().get(i), i);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeDocumentManifestDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeDocumentManifestDocumentManifestAgentComponent(Turtle.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
        }
        if (element.hasWho()) {
            this.composeReference(t, "DocumentManifest", "who", element.getWho(), -1);
        }
    }

    protected void composeDocumentManifestDocumentManifestRelatedComponent(Turtle.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentManifest", "ref", element.getRef(), -1);
        }
    }

    protected void composeDocumentReference(Turtle.Complex parent, String parentType, String name, DocumentReference element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "DocumentReference", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentReference", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
        }
        if (element.hasDocStatusElement()) {
            this.composeEnum(t, "DocumentReference", "docStatus", element.getDocStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
        }
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "DocumentReference", "class", element.getClass_(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentReference", "created", element.getCreatedElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeInstant(t, "DocumentReference", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceAgentComponent(t, "DocumentReference", "agent", element.getAgent().get(i), i);
        }
        if (element.hasAuthenticator()) {
            this.composeReference(t, "DocumentReference", "authenticator", element.getAuthenticator(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i), i);
        }
        if (element.hasContext()) {
            this.composeDocumentReferenceDocumentReferenceContextComponent(t, "DocumentReference", "context", element.getContext(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceAgentComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
        }
        if (element.hasWho()) {
            this.composeReference(t, "DocumentReference", "who", element.getWho(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceRelatesToComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "DocumentReference", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "DocumentReference", "target", element.getTarget(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContentComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasAttachment()) {
            this.composeAttachment(t, "DocumentReference", "attachment", element.getAttachment(), -1);
        }
        if (element.hasFormat()) {
            this.composeCoding(t, "DocumentReference", "format", element.getFormat(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasEncounter()) {
            this.composeReference(t, "DocumentReference", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "event", element.getEvent().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "DocumentReference", "period", element.getPeriod(), -1);
        }
        if (element.hasFacilityType()) {
            this.composeCodeableConcept(t, "DocumentReference", "facilityType", element.getFacilityType(), -1);
        }
        if (element.hasPracticeSetting()) {
            this.composeCodeableConcept(t, "DocumentReference", "practiceSetting", element.getPracticeSetting(), -1);
        }
        if (element.hasSourcePatientInfo()) {
            this.composeReference(t, "DocumentReference", "sourcePatientInfo", element.getSourcePatientInfo(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceContextRelatedComponent(t, "DocumentReference", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextRelatedComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentReference", "ref", element.getRef(), -1);
        }
    }

    protected void composeEligibilityRequest(Turtle.Complex parent, String parentType, String name, EligibilityRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EligibilityRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EligibilityRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EligibilityRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "EligibilityRequest", "priority", element.getPriority(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "EligibilityRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "EligibilityRequest", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EligibilityRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "EligibilityRequest", "enterer", element.getEnterer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "EligibilityRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "EligibilityRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "EligibilityRequest", "facility", element.getFacility(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "EligibilityRequest", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "EligibilityRequest", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        if (element.hasBenefitCategory()) {
            this.composeCodeableConcept(t, "EligibilityRequest", "benefitCategory", element.getBenefitCategory(), -1);
        }
        if (element.hasBenefitSubCategory()) {
            this.composeCodeableConcept(t, "EligibilityRequest", "benefitSubCategory", element.getBenefitSubCategory(), -1);
        }
        for (i = 0; i < element.getAuthorization().size(); ++i) {
            this.composeEligibilityRequestAuthorizationComponent(t, "EligibilityRequest", "authorization", element.getAuthorization().get(i), i);
        }
    }

    protected void composeEligibilityRequestAuthorizationComponent(Turtle.Complex parent, String parentType, String name, EligibilityRequest.AuthorizationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "authorization", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "EligibilityRequest", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "EligibilityRequest", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "EligibilityRequest", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EligibilityRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "EligibilityRequest", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "EligibilityRequest", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEligibilityRequestDiagnosisComponent(t, "EligibilityRequest", "diagnosis", element.getDiagnosis().get(i), i);
        }
    }

    protected void composeEligibilityRequestDiagnosisComponent(Turtle.Complex parent, String parentType, String name, EligibilityRequest.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasDiagnosis()) {
            this.composeType(t, "EligibilityRequest", "diagnosis", element.getDiagnosis(), -1);
        }
    }

    protected void composeEligibilityResponse(Turtle.Complex parent, String parentType, String name, EligibilityResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EligibilityResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EligibilityResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EligibilityResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EligibilityResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "EligibilityResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "EligibilityResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EligibilityResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EligibilityResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "EligibilityResponse", "insurer", element.getInsurer(), -1);
        }
        if (element.hasInforceElement()) {
            this.composeBoolean(t, "EligibilityResponse", "inforce", element.getInforceElement(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeEligibilityResponseInsuranceComponent(t, "EligibilityResponse", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "EligibilityResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        for (i = 0; i < element.getAuthorization().size(); ++i) {
            this.composeEligibilityResponseAuthorizationComponent(t, "EligibilityResponse", "authorization", element.getAuthorization().get(i), i);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeEligibilityResponseErrorsComponent(t, "EligibilityResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeEligibilityResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, EligibilityResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "EligibilityResponse", "coverage", element.getCoverage(), -1);
        }
        if (element.hasContract()) {
            this.composeReference(t, "EligibilityResponse", "contract", element.getContract(), -1);
        }
        for (int i = 0; i < element.getBenefitBalance().size(); ++i) {
            this.composeEligibilityResponseBenefitsComponent(t, "EligibilityResponse", "benefitBalance", element.getBenefitBalance().get(i), i);
        }
    }

    protected void composeEligibilityResponseBenefitsComponent(Turtle.Complex parent, String parentType, String name, EligibilityResponse.BenefitsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "category", element.getCategory(), -1);
        }
        if (element.hasSubCategory()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "subCategory", element.getSubCategory(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "EligibilityResponse", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EligibilityResponse", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EligibilityResponse", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "term", element.getTerm(), -1);
        }
        for (int i = 0; i < element.getFinancial().size(); ++i) {
            this.composeEligibilityResponseBenefitComponent(t, "EligibilityResponse", "financial", element.getFinancial().get(i), i);
        }
    }

    protected void composeEligibilityResponseBenefitComponent(Turtle.Complex parent, String parentType, String name, EligibilityResponse.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "EligibilityResponse", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "EligibilityResponse", "used", element.getUsed(), -1);
        }
    }

    protected void composeEligibilityResponseAuthorizationComponent(Turtle.Complex parent, String parentType, String name, EligibilityResponse.AuthorizationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "authorization", name, element, index);
        if (element.hasAuthorizationSequenceElement()) {
            this.composePositiveInt(t, "EligibilityResponse", "authorizationSequence", element.getAuthorizationSequenceElement(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "EligibilityResponse", "required", element.getRequiredElement(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EligibilityResponse", "note", element.getNote().get(i), i);
        }
    }

    protected void composeEligibilityResponseErrorsComponent(Turtle.Complex parent, String parentType, String name, EligibilityResponse.ErrorsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "EligibilityResponse", "code", element.getCode(), -1);
        }
    }

    protected void composeEncounter(Turtle.Complex parent, String parentType, String name, Encounter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Encounter", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i), i);
        }
        if (element.hasClass_()) {
            this.composeCoding(t, "Encounter", "class", element.getClass_(), -1);
        }
        for (i = 0; i < element.getClassHistory().size(); ++i) {
            this.composeEncounterClassHistoryComponent(t, "Encounter", "classHistory", element.getClassHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasServiceType()) {
            this.composeCodeableConcept(t, "Encounter", "serviceType", element.getServiceType(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Encounter", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getEpisodeOfCare().size(); ++i) {
            this.composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Encounter", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeEncounterEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "Encounter", "appointment", element.getAppointment(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasLength()) {
            this.composeDuration(t, "Encounter", "length", element.getLength(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEncounterDiagnosisComponent(t, "Encounter", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "Encounter", "account", element.getAccount().get(i), i);
        }
        if (element.hasHospitalization()) {
            this.composeEncounterEncounterHospitalizationComponent(t, "Encounter", "hospitalization", element.getHospitalization(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeEncounterEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i), i);
        }
        if (element.hasServiceProvider()) {
            this.composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeEncounterStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.StatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterClassHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.ClassHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "classHistory", name, element, index);
        if (element.hasClass_()) {
            this.composeCoding(t, "Encounter", "class", element.getClass_(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterEncounterParticipantComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "Encounter", "individual", element.getIndividual(), -1);
        }
    }

    protected void composeEncounterDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Encounter.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "Encounter", "condition", element.getCondition(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Encounter", "role", element.getRole(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "Encounter", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEncounterEncounterHospitalizationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterHospitalizationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "hospitalization", name, element, index);
        if (element.hasPreAdmissionIdentifier()) {
            this.composeIdentifier(t, "Encounter", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
        }
        if (element.hasOrigin()) {
            this.composeReference(t, "Encounter", "origin", element.getOrigin(), -1);
        }
        if (element.hasAdmitSource()) {
            this.composeCodeableConcept(t, "Encounter", "admitSource", element.getAdmitSource(), -1);
        }
        if (element.hasReAdmission()) {
            this.composeCodeableConcept(t, "Encounter", "reAdmission", element.getReAdmission(), -1);
        }
        for (i = 0; i < element.getDietPreference().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "dietPreference", element.getDietPreference().get(i), i);
        }
        for (i = 0; i < element.getSpecialCourtesy().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "specialCourtesy", element.getSpecialCourtesy().get(i), i);
        }
        for (i = 0; i < element.getSpecialArrangement().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "specialArrangement", element.getSpecialArrangement().get(i), i);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "Encounter", "destination", element.getDestination(), -1);
        }
        if (element.hasDischargeDisposition()) {
            this.composeCodeableConcept(t, "Encounter", "dischargeDisposition", element.getDischargeDisposition(), -1);
        }
    }

    protected void composeEncounterEncounterLocationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "location", name, element, index);
        if (element.hasLocation()) {
            this.composeReference(t, "Encounter", "location", element.getLocation(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEndpoint(Turtle.Complex parent, String parentType, String name, Endpoint element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Endpoint", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Endpoint", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Endpoint", "status", element.getStatusElement(), -1);
        }
        if (element.hasConnectionType()) {
            this.composeCoding(t, "Endpoint", "connectionType", element.getConnectionType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Endpoint", "name", element.getNameElement(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Endpoint", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Endpoint", "contact", element.getContact().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Endpoint", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getPayloadType().size(); ++i) {
            this.composeCodeableConcept(t, "Endpoint", "payloadType", element.getPayloadType().get(i), i);
        }
        for (i = 0; i < element.getPayloadMimeType().size(); ++i) {
            this.composeCode(t, "Endpoint", "payloadMimeType", element.getPayloadMimeType().get(i), i);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "Endpoint", "address", element.getAddressElement(), -1);
        }
        for (i = 0; i < element.getHeader().size(); ++i) {
            this.composeString(t, "Endpoint", "header", element.getHeader().get(i), i);
        }
    }

    protected void composeEnrollmentRequest(Turtle.Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EnrollmentRequest", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "EnrollmentRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasCandidate()) {
            this.composeReference(t, "EnrollmentRequest", "candidate", element.getCandidate(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
        }
    }

    protected void composeEnrollmentResponse(Turtle.Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EnrollmentResponse", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
        }
    }

    protected void composeEntryDefinition(Turtle.Complex parent, String parentType, String name, EntryDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EntryDefinition", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EntryDefinition", "type", element.getType(), -1);
        }
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "EntryDefinition", "purpose", element.getPurpose(), -1);
        }
        if (element.hasReferencedItem()) {
            this.composeReference(t, "EntryDefinition", "referencedItem", element.getReferencedItem(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "EntryDefinition", "identifier", element.getIdentifier(), -1);
        }
        for (i = 0; i < element.getAdditionalIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EntryDefinition", "additionalIdentifier", element.getAdditionalIdentifier().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeCodeableConcept(t, "EntryDefinition", "classification", element.getClassification().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "EntryDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "EntryDefinition", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeDateTime(t, "EntryDefinition", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        for (i = 0; i < element.getAdditionalCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "EntryDefinition", "additionalCharacteristic", element.getAdditionalCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getAdditionalClassification().size(); ++i) {
            this.composeCodeableConcept(t, "EntryDefinition", "additionalClassification", element.getAdditionalClassification().get(i), i);
        }
        for (i = 0; i < element.getRelatedEntry().size(); ++i) {
            this.composeEntryDefinitionEntryDefinitionRelatedEntryComponent(t, "EntryDefinition", "relatedEntry", element.getRelatedEntry().get(i), i);
        }
    }

    protected void composeEntryDefinitionEntryDefinitionRelatedEntryComponent(Turtle.Complex parent, String parentType, String name, EntryDefinition.EntryDefinitionRelatedEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "relatedEntry", name, element, index);
        if (element.hasRelationtype()) {
            this.composeCodeableConcept(t, "EntryDefinition", "relationtype", element.getRelationtype(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "EntryDefinition", "item", element.getItem(), -1);
        }
    }

    protected void composeEpisodeOfCare(Turtle.Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EpisodeOfCare", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEpisodeOfCareDiagnosisComponent(t, "EpisodeOfCare", "diagnosis", element.getDiagnosis().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getReferralRequest().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i), i);
        }
        if (element.hasCareManager()) {
            this.composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
        }
        for (i = 0; i < element.getTeam().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "team", element.getTeam().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "account", element.getAccount().get(i), i);
        }
    }

    protected void composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEpisodeOfCareDiagnosisComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "EpisodeOfCare", "condition", element.getCondition(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "role", element.getRole(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "EpisodeOfCare", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEventDefinition(Turtle.Complex parent, String parentType, String name, EventDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "EventDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EventDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EventDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EventDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EventDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EventDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EventDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EventDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "EventDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "EventDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EventDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EventDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EventDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EventDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "EventDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "EventDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "EventDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EventDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EventDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EventDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EventDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "EventDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeContributor(t, "EventDefinition", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EventDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasTrigger()) {
            this.composeTriggerDefinition(t, "EventDefinition", "trigger", element.getTrigger(), -1);
        }
    }

    protected void composeExampleScenario(Turtle.Complex parent, String parentType, String name, ExampleScenario element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ExampleScenario", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ExampleScenario", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExampleScenario", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExampleScenario", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExampleScenario", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ExampleScenario", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExampleScenario", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ExampleScenario", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ExampleScenario", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ExampleScenario", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ExampleScenario", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ExampleScenario", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ExampleScenario", "purpose", element.getPurposeElement(), -1);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeExampleScenarioExampleScenarioActorComponent(t, "ExampleScenario", "actor", element.getActor().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeExampleScenarioExampleScenarioInstanceComponent(t, "ExampleScenario", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getProcess().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
        }
        for (i = 0; i < element.getWorkflow().size(); ++i) {
            this.composeCanonical(t, "ExampleScenario", "workflow", element.getWorkflow().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioActorComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasActorIdElement()) {
            this.composeString(t, "ExampleScenario", "actorId", element.getActorIdElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ExampleScenario", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasResourceIdElement()) {
            this.composeString(t, "ExampleScenario", "resourceId", element.getResourceIdElement(), -1);
        }
        if (element.hasResourceTypeElement()) {
            this.composeEnum(t, "ExampleScenario", "resourceType", element.getResourceTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeExampleScenarioExampleScenarioInstanceVersionComponent(t, "ExampleScenario", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getContainedInstance().size(); ++i) {
            this.composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenario", "containedInstance", element.getContainedInstance().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioInstanceVersionComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeString(t, "ExampleScenario", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "containedInstance", name, element, index);
        if (element.hasResourceIdElement()) {
            this.composeString(t, "ExampleScenario", "resourceId", element.getResourceIdElement(), -1);
        }
        if (element.hasVersionIdElement()) {
            this.composeString(t, "ExampleScenario", "versionId", element.getVersionIdElement(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "process", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenario", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPreConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenario", "preConditions", element.getPreConditionsElement(), -1);
        }
        if (element.hasPostConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenario", "postConditions", element.getPostConditionsElement(), -1);
        }
        for (int i = 0; i < element.getStep().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessStepComponent(t, "ExampleScenario", "step", element.getStep().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "step", name, element, index);
        for (int i = 0; i < element.getProcess().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
        }
        if (element.hasPauseElement()) {
            this.composeBoolean(t, "ExampleScenario", "pause", element.getPauseElement(), -1);
        }
        if (element.hasOperation()) {
            this.composeExampleScenarioExampleScenarioProcessStepOperationComponent(t, "ExampleScenario", "operation", element.getOperation(), -1);
        }
        if (element.hasAlternative()) {
            this.composeExampleScenarioExampleScenarioProcessStepAlternativeComponent(t, "ExampleScenario", "alternative", element.getAlternative(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepOperationComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNumberElement()) {
            this.composeString(t, "ExampleScenario", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "ExampleScenario", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasInitiatorElement()) {
            this.composeString(t, "ExampleScenario", "initiator", element.getInitiatorElement(), -1);
        }
        if (element.hasReceiverElement()) {
            this.composeString(t, "ExampleScenario", "receiver", element.getReceiverElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasInitiatorActiveElement()) {
            this.composeBoolean(t, "ExampleScenario", "initiatorActive", element.getInitiatorActiveElement(), -1);
        }
        if (element.hasReceiverActiveElement()) {
            this.composeBoolean(t, "ExampleScenario", "receiverActive", element.getReceiverActiveElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenario", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenario", "response", element.getResponse(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepAlternativeComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "alternative", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getOption().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessStepAlternativeOptionComponent(t, "ExampleScenario", "option", element.getOption().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepAlternativeOptionComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "option", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getStep().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessStepComponent(t, "ExampleScenario", "step", element.getStep().get(i), i);
        }
        for (i = 0; i < element.getPause().size(); ++i) {
            this.composeBoolean(t, "ExampleScenario", "pause", element.getPause().get(i), i);
        }
    }

    protected void composeExpansionProfile(Turtle.Complex parent, String parentType, String name, ExpansionProfile element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ExpansionProfile", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ExpansionProfile", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ExpansionProfile", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExpansionProfile", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExpansionProfile", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExpansionProfile", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ExpansionProfile", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExpansionProfile", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ExpansionProfile", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ExpansionProfile", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExpansionProfile", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ExpansionProfile", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ExpansionProfile", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        for (i = 0; i < element.getFixedVersion().size(); ++i) {
            this.composeExpansionProfileExpansionProfileFixedVersionComponent(t, "ExpansionProfile", "fixedVersion", element.getFixedVersion().get(i), i);
        }
        if (element.hasExcludedSystem()) {
            this.composeExpansionProfileExpansionProfileExcludedSystemComponent(t, "ExpansionProfile", "excludedSystem", element.getExcludedSystem(), -1);
        }
        if (element.hasIncludeDesignationsElement()) {
            this.composeBoolean(t, "ExpansionProfile", "includeDesignations", element.getIncludeDesignationsElement(), -1);
        }
        if (element.hasDesignation()) {
            this.composeExpansionProfileExpansionProfileDesignationComponent(t, "ExpansionProfile", "designation", element.getDesignation(), -1);
        }
        if (element.hasIncludeDefinitionElement()) {
            this.composeBoolean(t, "ExpansionProfile", "includeDefinition", element.getIncludeDefinitionElement(), -1);
        }
        if (element.hasActiveOnlyElement()) {
            this.composeBoolean(t, "ExpansionProfile", "activeOnly", element.getActiveOnlyElement(), -1);
        }
        if (element.hasExcludeNestedElement()) {
            this.composeBoolean(t, "ExpansionProfile", "excludeNested", element.getExcludeNestedElement(), -1);
        }
        if (element.hasExcludeNotForUIElement()) {
            this.composeBoolean(t, "ExpansionProfile", "excludeNotForUI", element.getExcludeNotForUIElement(), -1);
        }
        if (element.hasExcludePostCoordinatedElement()) {
            this.composeBoolean(t, "ExpansionProfile", "excludePostCoordinated", element.getExcludePostCoordinatedElement(), -1);
        }
        if (element.hasDisplayLanguageElement()) {
            this.composeCode(t, "ExpansionProfile", "displayLanguage", element.getDisplayLanguageElement(), -1);
        }
        if (element.hasLimitedExpansionElement()) {
            this.composeBoolean(t, "ExpansionProfile", "limitedExpansion", element.getLimitedExpansionElement(), -1);
        }
    }

    protected void composeExpansionProfileExpansionProfileFixedVersionComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.ExpansionProfileFixedVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "fixedVersion", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ExpansionProfile", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExpansionProfile", "version", element.getVersionElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "ExpansionProfile", "mode", element.getModeElement(), -1);
        }
    }

    protected void composeExpansionProfileExpansionProfileExcludedSystemComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.ExpansionProfileExcludedSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "excludedSystem", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ExpansionProfile", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExpansionProfile", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeExpansionProfileExpansionProfileDesignationComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.ExpansionProfileDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasInclude()) {
            this.composeExpansionProfileDesignationIncludeComponent(t, "ExpansionProfile", "include", element.getInclude(), -1);
        }
        if (element.hasExclude()) {
            this.composeExpansionProfileDesignationExcludeComponent(t, "ExpansionProfile", "exclude", element.getExclude(), -1);
        }
    }

    protected void composeExpansionProfileDesignationIncludeComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.DesignationIncludeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "include", name, element, index);
        for (int i = 0; i < element.getDesignation().size(); ++i) {
            this.composeExpansionProfileDesignationIncludeDesignationComponent(t, "ExpansionProfile", "designation", element.getDesignation().get(i), i);
        }
    }

    protected void composeExpansionProfileDesignationIncludeDesignationComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.DesignationIncludeDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ExpansionProfile", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ExpansionProfile", "use", element.getUse(), -1);
        }
    }

    protected void composeExpansionProfileDesignationExcludeComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.DesignationExcludeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "exclude", name, element, index);
        for (int i = 0; i < element.getDesignation().size(); ++i) {
            this.composeExpansionProfileDesignationExcludeDesignationComponent(t, "ExpansionProfile", "designation", element.getDesignation().get(i), i);
        }
    }

    protected void composeExpansionProfileDesignationExcludeDesignationComponent(Turtle.Complex parent, String parentType, String name, ExpansionProfile.DesignationExcludeDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ExpansionProfile", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ExpansionProfile", "use", element.getUse(), -1);
        }
    }

    protected void composeExplanationOfBenefit(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subType", element.getSubType().get(i), i);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ExplanationOfBenefit", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ExplanationOfBenefit", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
        }
        if (element.hasClaim()) {
            this.composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeExplanationOfBenefitRelatedClaimComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
        }
        for (i = 0; i < element.getInformation().size(); ++i) {
            this.composeExplanationOfBenefitSupportingInformationComponent(t, "ExplanationOfBenefit", "information", element.getInformation().get(i), i);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeExplanationOfBenefitCareTeamComponent(t, "ExplanationOfBenefit", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i), i);
        }
        if (element.hasPrecedenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
        }
        if (element.hasInsurance()) {
            this.composeExplanationOfBenefitInsuranceComponent(t, "ExplanationOfBenefit", "insurance", element.getInsurance(), -1);
        }
        if (element.hasAccident()) {
            this.composeExplanationOfBenefitAccidentComponent(t, "ExplanationOfBenefit", "accident", element.getAccident(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeExplanationOfBenefitItemComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getTotal().size(); ++i) {
            this.composeExplanationOfBenefitTotalComponent(t, "ExplanationOfBenefit", "total", element.getTotal().get(i), i);
        }
        if (element.hasPayment()) {
            this.composeExplanationOfBenefitPaymentComponent(t, "ExplanationOfBenefit", "payment", element.getPayment(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeExplanationOfBenefitNoteComponent(t, "ExplanationOfBenefit", "processNote", element.getProcessNote().get(i), i);
        }
        for (i = 0; i < element.getBenefitBalance().size(); ++i) {
            this.composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "reference", element.getReference(), -1);
        }
    }

    protected void composeExplanationOfBenefitPayeeComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasResource()) {
            this.composeCoding(t, "ExplanationOfBenefit", "resource", element.getResource(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "ExplanationOfBenefit", "party", element.getParty(), -1);
        }
    }

    protected void composeExplanationOfBenefitSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "information", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "ExplanationOfBenefit", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ExplanationOfBenefit", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
    }

    protected void composeExplanationOfBenefitCareTeamComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "ExplanationOfBenefit", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "role", element.getRole(), -1);
        }
        if (element.hasQualification()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "qualification", element.getQualification(), -1);
        }
    }

    protected void composeExplanationOfBenefitDiagnosisComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType().get(i), i);
        }
        if (element.hasPackageCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "packageCode", element.getPackageCode(), -1);
        }
    }

    protected void composeExplanationOfBenefitProcedureComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ExplanationOfBenefit", "procedure", element.getProcedure(), -1);
        }
    }

    protected void composeExplanationOfBenefitInsuranceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "ExplanationOfBenefit", "coverage", element.getCoverage(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAccidentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ExplanationOfBenefit", "location", element.getLocation(), -1);
        }
    }

    protected void composeExplanationOfBenefitItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getCareTeamSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "careTeamSequence", element.getCareTeamSequence().get(i), i);
        }
        for (i = 0; i < element.getDiagnosisSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
        }
        for (i = 0; i < element.getProcedureSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "procedureSequence", element.getProcedureSequence().get(i), i);
        }
        for (i = 0; i < element.getInformationSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "informationSequence", element.getInformationSequence().get(i), i);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ExplanationOfBenefit", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ExplanationOfBenefit", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitDetailComponent(t, "ExplanationOfBenefit", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeExplanationOfBenefitSubDetailComponent(t, "ExplanationOfBenefit", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getItemSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "itemSequence", element.getItemSequence().get(i), i);
        }
        for (i = 0; i < element.getDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "detailSequence", element.getDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getSubDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "subDetailSequence", element.getSubDetailSequence().get(i), i);
        }
        if (element.hasService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasFee()) {
            this.composeMoney(t, "ExplanationOfBenefit", "fee", element.getFee(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitTotalComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
    }

    protected void composeExplanationOfBenefitPaymentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "ExplanationOfBenefit", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeExplanationOfBenefitNoteComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ExplanationOfBenefit", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "language", element.getLanguage(), -1);
        }
    }

    protected void composeExplanationOfBenefitBenefitBalanceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasSubCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subCategory", element.getSubCategory(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "ExplanationOfBenefit", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExplanationOfBenefit", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "term", element.getTerm(), -1);
        }
        for (int i = 0; i < element.getFinancial().size(); ++i) {
            this.composeExplanationOfBenefitBenefitComponent(t, "ExplanationOfBenefit", "financial", element.getFinancial().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitBenefitComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "ExplanationOfBenefit", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "ExplanationOfBenefit", "used", element.getUsed(), -1);
        }
    }

    protected void composeFamilyMemberHistory(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "FamilyMemberHistory", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "FamilyMemberHistory", "instantiates", element.getInstantiates().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBorn()) {
            this.composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
        }
        if (element.hasAge()) {
            this.composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
        }
        if (element.hasEstimatedAgeElement()) {
            this.composeBoolean(t, "FamilyMemberHistory", "estimatedAge", element.getEstimatedAgeElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "FamilyMemberHistory", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i), i);
        }
    }

    protected void composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "code", element.getCode(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "outcome", element.getOutcome(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "FamilyMemberHistory", "onset", element.getOnset(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
        }
    }

    protected void composeFlag(Turtle.Complex parent, String parentType, String name, Flag element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Flag", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Flag", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Flag", "subject", element.getSubject(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Flag", "period", element.getPeriod(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Flag", "author", element.getAuthor(), -1);
        }
    }

    protected void composeGoal(Turtle.Complex parent, String parentType, String name, Goal element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Goal", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Goal", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "Goal", "description", element.getDescription(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Goal", "subject", element.getSubject(), -1);
        }
        if (element.hasStart()) {
            this.composeType(t, "Goal", "start", element.getStart(), -1);
        }
        if (element.hasTarget()) {
            this.composeGoalGoalTargetComponent(t, "Goal", "target", element.getTarget(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasStatusReasonElement()) {
            this.composeString(t, "Goal", "statusReason", element.getStatusReasonElement(), -1);
        }
        if (element.hasExpressedBy()) {
            this.composeReference(t, "Goal", "expressedBy", element.getExpressedBy(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "Goal", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Goal", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getOutcomeCode().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "outcomeCode", element.getOutcomeCode().get(i), i);
        }
        for (i = 0; i < element.getOutcomeReference().size(); ++i) {
            this.composeReference(t, "Goal", "outcomeReference", element.getOutcomeReference().get(i), i);
        }
    }

    protected void composeGoalGoalTargetComponent(Turtle.Complex parent, String parentType, String name, Goal.GoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "Goal", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "Goal", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeType(t, "Goal", "due", element.getDue(), -1);
        }
    }

    protected void composeGraphDefinition(Turtle.Complex parent, String parentType, String name, GraphDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "GraphDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "GraphDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "GraphDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "GraphDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GraphDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "GraphDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "GraphDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "GraphDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "GraphDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "GraphDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "GraphDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "GraphDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeCode(t, "GraphDefinition", "start", element.getStartElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinition", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
        }
    }

    protected void composeGraphDefinitionGraphDefinitionLinkComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "GraphDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "GraphDefinition", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "GraphDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "GraphDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkTargetComponent(t, "GraphDefinition", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeGraphDefinitionGraphDefinitionLinkTargetComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "GraphDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasParamsElement()) {
            this.composeString(t, "GraphDefinition", "params", element.getParamsElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinition", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(t, "GraphDefinition", "compartment", element.getCompartment().get(i), i);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
        }
    }

    protected void composeGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "compartment", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "GraphDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "GraphDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasRuleElement()) {
            this.composeEnum(t, "GraphDefinition", "rule", element.getRuleElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "GraphDefinition", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeGroup(Turtle.Complex parent, String parentType, String name, Group element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Group", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Group", "type", element.getTypeElement(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "Group", "actual", element.getActualElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Group", "name", element.getNameElement(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeGroupGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getMember().size(); ++i) {
            this.composeGroupGroupMemberComponent(t, "Group", "member", element.getMember().get(i), i);
        }
    }

    protected void composeGroupGroupCharacteristicComponent(Turtle.Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Group", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "Group", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Group", "period", element.getPeriod(), -1);
        }
    }

    protected void composeGroupGroupMemberComponent(Turtle.Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "member", name, element, index);
        if (element.hasEntity()) {
            this.composeReference(t, "Group", "entity", element.getEntity(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Group", "period", element.getPeriod(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "Group", "inactive", element.getInactiveElement(), -1);
        }
    }

    protected void composeGuidanceResponse(Turtle.Complex parent, String parentType, String name, GuidanceResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "GuidanceResponse", name, element, index);
        if (element.hasRequestIdElement()) {
            this.composeId(t, "GuidanceResponse", "requestId", element.getRequestIdElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "GuidanceResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasModule()) {
            this.composeType(t, "GuidanceResponse", "module", element.getModule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "GuidanceResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "GuidanceResponse", "context", element.getContext(), -1);
        }
        if (element.hasOccurrenceDateTimeElement()) {
            this.composeDateTime(t, "GuidanceResponse", "occurrenceDateTime", element.getOccurrenceDateTimeElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "GuidanceResponse", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "GuidanceResponse", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "GuidanceResponse", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEvaluationMessage().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i), i);
        }
        if (element.hasOutputParameters()) {
            this.composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
        }
        if (element.hasResult()) {
            this.composeReference(t, "GuidanceResponse", "result", element.getResult(), -1);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i), i);
        }
    }

    protected void composeHealthcareService(Turtle.Complex parent, String parentType, String name, HealthcareService element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "HealthcareService", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "HealthcareService", "active", element.getActiveElement(), -1);
        }
        if (element.hasProvidedBy()) {
            this.composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "HealthcareService", "location", element.getLocation().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "HealthcareService", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
        }
        if (element.hasExtraDetailsElement()) {
            this.composeString(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "HealthcareService", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getServiceProvisionCode().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i), i);
        }
        if (element.hasEligibility()) {
            this.composeCodeableConcept(t, "HealthcareService", "eligibility", element.getEligibility(), -1);
        }
        if (element.hasEligibilityNoteElement()) {
            this.composeString(t, "HealthcareService", "eligibilityNote", element.getEligibilityNoteElement(), -1);
        }
        for (i = 0; i < element.getProgramName().size(); ++i) {
            this.composeString(t, "HealthcareService", "programName", element.getProgramName().get(i), i);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getReferralMethod().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i), i);
        }
        if (element.hasAppointmentRequiredElement()) {
            this.composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceAvailableTimeComponent(t, "HealthcareService", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceNotAvailableComponent(t, "HealthcareService", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "HealthcareService", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "HealthcareService", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "HealthcareService", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "HealthcareService", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "HealthcareService", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "HealthcareService", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceNotAvailableComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "HealthcareService", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "HealthcareService", "during", element.getDuring(), -1);
        }
    }

    protected void composeImagingStudy(Turtle.Complex parent, String parentType, String name, ImagingStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ImagingStudy", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImagingStudy", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getModality().size(); ++i) {
            this.composeCoding(t, "ImagingStudy", "modality", element.getModality().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ImagingStudy", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ImagingStudy", "context", element.getContext(), -1);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasReferrer()) {
            this.composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
        }
        for (i = 0; i < element.getInterpreter().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasNumberOfSeriesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        if (element.hasProcedureReference()) {
            this.composeReference(t, "ImagingStudy", "procedureReference", element.getProcedureReference(), -1);
        }
        for (i = 0; i < element.getProcedureCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImagingStudy", "procedureCode", element.getProcedureCode().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ImagingStudy", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImagingStudy", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ImagingStudy", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSeries().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i), i);
        }
    }

    protected void composeImagingStudyImagingStudySeriesComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "number", element.getNumberElement(), -1);
        }
        if (element.hasModality()) {
            this.composeCoding(t, "ImagingStudy", "modality", element.getModality(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCoding(t, "ImagingStudy", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCoding(t, "ImagingStudy", "laterality", element.getLaterality(), -1);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "specimen", element.getSpecimen().get(i), i);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesPerformerComponent(t, "ImagingStudy", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesInstanceComponent(t, "ImagingStudy", "instance", element.getInstance().get(i), i);
        }
    }

    protected void composeImagingStudyImagingStudySeriesPerformerComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImagingStudy", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImagingStudy", "actor", element.getActor(), -1);
        }
    }

    protected void composeImagingStudyImagingStudySeriesInstanceComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "number", element.getNumberElement(), -1);
        }
        if (element.hasSopClass()) {
            this.composeCoding(t, "ImagingStudy", "sopClass", element.getSopClass(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImagingStudy", "title", element.getTitleElement(), -1);
        }
    }

    protected void composeImmunization(Turtle.Complex parent, String parentType, String name, Immunization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Immunization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Immunization", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Immunization", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasVaccineCode()) {
            this.composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Immunization", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Immunization", "date", element.getDateElement(), -1);
        }
        if (element.hasPrimarySourceElement()) {
            this.composeBoolean(t, "Immunization", "primarySource", element.getPrimarySourceElement(), -1);
        }
        if (element.hasReportOrigin()) {
            this.composeCodeableConcept(t, "Immunization", "reportOrigin", element.getReportOrigin(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Immunization", "location", element.getLocation(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
        }
        if (element.hasDoseQuantity()) {
            this.composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeImmunizationImmunizationPerformerComponent(t, "Immunization", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Immunization", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Immunization", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasIsPotentElement()) {
            this.composeBoolean(t, "Immunization", "isPotent", element.getIsPotentElement(), -1);
        }
        for (i = 0; i < element.getSubpotentReason().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "subpotentReason", element.getSubpotentReason().get(i), i);
        }
        for (i = 0; i < element.getEducation().size(); ++i) {
            this.composeImmunizationImmunizationEducationComponent(t, "Immunization", "education", element.getEducation().get(i), i);
        }
        for (i = 0; i < element.getProgramEligibility().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "programEligibility", element.getProgramEligibility().get(i), i);
        }
        if (element.hasFundingSource()) {
            this.composeCodeableConcept(t, "Immunization", "fundingSource", element.getFundingSource(), -1);
        }
    }

    protected void composeImmunizationImmunizationPerformerComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "Immunization", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Immunization", "actor", element.getActor(), -1);
        }
    }

    protected void composeImmunizationImmunizationEducationComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationEducationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "education", name, element, index);
        if (element.hasDocumentTypeElement()) {
            this.composeString(t, "Immunization", "documentType", element.getDocumentTypeElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Immunization", "reference", element.getReferenceElement(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDateTime(t, "Immunization", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasPresentationDateElement()) {
            this.composeDateTime(t, "Immunization", "presentationDate", element.getPresentationDateElement(), -1);
        }
    }

    protected void composeImmunizationEvaluation(Turtle.Complex parent, String parentType, String name, ImmunizationEvaluation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ImmunizationEvaluation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationEvaluation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImmunizationEvaluation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationEvaluation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationEvaluation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationEvaluation", "authority", element.getAuthority(), -1);
        }
        for (i = 0; i < element.getTargetDisease().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "targetDisease", element.getTargetDisease().get(i), i);
        }
        if (element.hasImmunizationEvent()) {
            this.composeReference(t, "ImmunizationEvaluation", "immunizationEvent", element.getImmunizationEvent(), -1);
        }
        if (element.hasDoseStatus()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatus", element.getDoseStatus(), -1);
        }
        for (i = 0; i < element.getDoseStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatusReason", element.getDoseStatusReason().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationEvaluation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationEvaluation", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationEvaluation", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationEvaluation", "seriesDoses", element.getSeriesDoses(), -1);
        }
    }

    protected void composeImmunizationRecommendation(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
        }
        for (i = 0; i < element.getRecommendation().size(); ++i) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "recommendation", name, element, index);
        for (i = 0; i < element.getVaccineCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "vaccineCode", element.getVaccineCode().get(i), i);
        }
        if (element.hasTargetDisease()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "targetDisease", element.getTargetDisease(), -1);
        }
        for (i = 0; i < element.getContraindicatedVaccineCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "contraindicatedVaccineCode", element.getContraindicatedVaccineCode().get(i), i);
        }
        if (element.hasForecastStatus()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "forecastStatus", element.getForecastStatus(), -1);
        }
        for (i = 0; i < element.getForecastReason().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "forecastReason", element.getForecastReason().get(i), i);
        }
        for (i = 0; i < element.getDateCriterion().size(); ++i) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendation", "dateCriterion", element.getDateCriterion().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationRecommendation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationRecommendation", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationRecommendation", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationRecommendation", "seriesDoses", element.getSeriesDoses(), -1);
        }
        for (i = 0; i < element.getSupportingImmunization().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendation", "supportingImmunization", element.getSupportingImmunization().get(i), i);
        }
        for (i = 0; i < element.getSupportingPatientInformation().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendation", "supportingPatientInformation", element.getSupportingPatientInformation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dateCriterion", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "code", element.getCode(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuide(Turtle.Complex parent, String parentType, String name, ImplementationGuide element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ImplementationGuide", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ImplementationGuide", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ImplementationGuide", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ImplementationGuide", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeId(t, "ImplementationGuide", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDependsOnComponent(t, "ImplementationGuide", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getGlobal().size(); ++i) {
            this.composeImplementationGuideImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i), i);
        }
        if (element.hasDefinition()) {
            this.composeImplementationGuideImplementationGuideDefinitionComponent(t, "ImplementationGuide", "definition", element.getDefinition(), -1);
        }
        if (element.hasManifest()) {
            this.composeImplementationGuideImplementationGuideManifestComponent(t, "ImplementationGuide", "manifest", element.getManifest(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDependsOnComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependsOnComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasUriElement()) {
            this.composeCanonical(t, "ImplementationGuide", "uri", element.getUriElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideGlobalComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "global", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "ImplementationGuide", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ImplementationGuide", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "definition", name, element, index);
        for (i = 0; i < element.getPackage().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionPackageComponent(t, "ImplementationGuide", "package", element.getPackage().get(i), i);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionResourceComponent(t, "ImplementationGuide", "resource", element.getResource().get(i), i);
        }
        if (element.hasPage()) {
            this.composeImplementationGuideImplementationGuideDefinitionPageComponent(t, "ImplementationGuide", "page", element.getPage(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionParameterComponent(t, "ImplementationGuide", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getTemplate().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionTemplateComponent(t, "ImplementationGuide", "template", element.getTemplate().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionPackageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPackageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "package", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ImplementationGuide", "reference", element.getReference(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ImplementationGuide", "example", element.getExample(), -1);
        }
        if (element.hasPackageElement()) {
            this.composeId(t, "ImplementationGuide", "package", element.getPackageElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasName()) {
            this.composeType(t, "ImplementationGuide", "name", element.getName(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        if (element.hasGenerationElement()) {
            this.composeEnum(t, "ImplementationGuide", "generation", element.getGenerationElement(), -1);
        }
        for (int i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionPageComponent(t, "ImplementationGuide", "page", element.getPage().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "ImplementationGuide", "code", element.getCodeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ImplementationGuide", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionTemplateComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "template", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ImplementationGuide", "code", element.getCodeElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "ImplementationGuide", "source", element.getSourceElement(), -1);
        }
        if (element.hasScopeElement()) {
            this.composeString(t, "ImplementationGuide", "scope", element.getScopeElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideManifestComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "manifest", name, element, index);
        if (element.hasRenderingElement()) {
            this.composeUrl(t, "ImplementationGuide", "rendering", element.getRenderingElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideImplementationGuideManifestResourceComponent(t, "ImplementationGuide", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideImplementationGuideManifestPageComponent(t, "ImplementationGuide", "page", element.getPage().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "image", element.getImage().get(i), i);
        }
        for (i = 0; i < element.getOther().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "other", element.getOther().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuideManifestResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ImplementationGuide", "reference", element.getReference(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ImplementationGuide", "example", element.getExample(), -1);
        }
        if (element.hasRelativePathElement()) {
            this.composeUrl(t, "ImplementationGuide", "relativePath", element.getRelativePathElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideManifestPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        for (int i = 0; i < element.getAnchor().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "anchor", element.getAnchor().get(i), i);
        }
    }

    protected void composeInvoice(Turtle.Complex parent, String parentType, String name, Invoice element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Invoice", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Invoice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Invoice", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancelledReasonElement()) {
            this.composeString(t, "Invoice", "cancelledReason", element.getCancelledReasonElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Invoice", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Invoice", "subject", element.getSubject(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "Invoice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Invoice", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeInvoiceInvoiceParticipantComponent(t, "Invoice", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Invoice", "issuer", element.getIssuer(), -1);
        }
        if (element.hasAccount()) {
            this.composeReference(t, "Invoice", "account", element.getAccount(), -1);
        }
        for (i = 0; i < element.getLineItem().size(); ++i) {
            this.composeInvoiceInvoiceLineItemComponent(t, "Invoice", "lineItem", element.getLineItem().get(i), i);
        }
        for (i = 0; i < element.getTotalPriceComponent().size(); ++i) {
            this.composeInvoiceInvoiceLineItemPriceComponentComponent(t, "Invoice", "totalPriceComponent", element.getTotalPriceComponent().get(i), i);
        }
        if (element.hasTotalNet()) {
            this.composeMoney(t, "Invoice", "totalNet", element.getTotalNet(), -1);
        }
        if (element.hasTotalGross()) {
            this.composeMoney(t, "Invoice", "totalGross", element.getTotalGross(), -1);
        }
        if (element.hasPaymentTermsElement()) {
            this.composeMarkdown(t, "Invoice", "paymentTerms", element.getPaymentTermsElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Invoice", "note", element.getNote().get(i), i);
        }
    }

    protected void composeInvoiceInvoiceParticipantComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Invoice", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Invoice", "actor", element.getActor(), -1);
        }
    }

    protected void composeInvoiceInvoiceLineItemComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "lineItem", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Invoice", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasChargeItem()) {
            this.composeReference(t, "Invoice", "chargeItem", element.getChargeItem(), -1);
        }
        for (int i = 0; i < element.getPriceComponent().size(); ++i) {
            this.composeInvoiceInvoiceLineItemPriceComponentComponent(t, "Invoice", "priceComponent", element.getPriceComponent().get(i), i);
        }
    }

    protected void composeInvoiceInvoiceLineItemPriceComponentComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemPriceComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "priceComponent", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Invoice", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Invoice", "code", element.getCode(), -1);
        }
        if (element.hasFactor()) {
            this.composeMoney(t, "Invoice", "factor", element.getFactor(), -1);
        }
        if (element.hasAmountElement()) {
            this.composeDecimal(t, "Invoice", "amount", element.getAmountElement(), -1);
        }
    }

    protected void composeItemInstance(Turtle.Complex parent, String parentType, String name, ItemInstance element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ItemInstance", name, element, index);
        if (element.hasCountElement()) {
            this.composeInteger(t, "ItemInstance", "count", element.getCountElement(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ItemInstance", "location", element.getLocation(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ItemInstance", "subject", element.getSubject(), -1);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTime(t, "ItemInstance", "manufactureDate", element.getManufactureDateElement(), -1);
        }
        if (element.hasExpiryDateElement()) {
            this.composeDateTime(t, "ItemInstance", "expiryDate", element.getExpiryDateElement(), -1);
        }
        if (element.hasCurrentSWVersionElement()) {
            this.composeString(t, "ItemInstance", "currentSWVersion", element.getCurrentSWVersionElement(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "ItemInstance", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasSerialNumberElement()) {
            this.composeString(t, "ItemInstance", "serialNumber", element.getSerialNumberElement(), -1);
        }
        if (element.hasCarrierAIDCElement()) {
            this.composeString(t, "ItemInstance", "carrierAIDC", element.getCarrierAIDCElement(), -1);
        }
        if (element.hasCarrierHRFElement()) {
            this.composeString(t, "ItemInstance", "carrierHRF", element.getCarrierHRFElement(), -1);
        }
    }

    protected void composeLibrary(Turtle.Complex parent, String parentType, String name, Library element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Library", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Library", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Library", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Library", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Library", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Library", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Library", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Library", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Library", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Library", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Library", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Library", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Library", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Library", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Library", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Library", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Library", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Library", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Library", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Library", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Library", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Library", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeContributor(t, "Library", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Library", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeAttachment(t, "Library", "content", element.getContent().get(i), i);
        }
    }

    protected void composeLinkage(Turtle.Complex parent, String parentType, String name, Linkage element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Linkage", name, element, index);
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Linkage", "active", element.getActiveElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Linkage", "author", element.getAuthor(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeLinkageLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i), i);
        }
    }

    protected void composeLinkageLinkageItemComponent(Turtle.Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Linkage", "type", element.getTypeElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "Linkage", "resource", element.getResource(), -1);
        }
    }

    protected void composeListResource(Turtle.Complex parent, String parentType, String name, ListResource element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "List", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "List", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "List", "status", element.getStatusElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "List", "mode", element.getModeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "List", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "List", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "List", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "List", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "List", "date", element.getDateElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "List", "source", element.getSource(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "List", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "List", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeListResourceListEntryComponent(t, "List", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "List", "emptyReason", element.getEmptyReason(), -1);
        }
    }

    protected void composeListResourceListEntryComponent(Turtle.Complex parent, String parentType, String name, ListResource.ListEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasFlag()) {
            this.composeCodeableConcept(t, "List", "flag", element.getFlag(), -1);
        }
        if (element.hasDeletedElement()) {
            this.composeBoolean(t, "List", "deleted", element.getDeletedElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "List", "date", element.getDateElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "List", "item", element.getItem(), -1);
        }
    }

    protected void composeLocation(Turtle.Complex parent, String parentType, String name, Location element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Location", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Location", "status", element.getStatusElement(), -1);
        }
        if (element.hasOperationalStatus()) {
            this.composeCoding(t, "Location", "operationalStatus", element.getOperationalStatus(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Location", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Location", "alias", element.getAlias().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Location", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Location", "mode", element.getModeElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Location", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Location", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Location", "address", element.getAddress(), -1);
        }
        if (element.hasPhysicalType()) {
            this.composeCodeableConcept(t, "Location", "physicalType", element.getPhysicalType(), -1);
        }
        if (element.hasPosition()) {
            this.composeLocationLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Location", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getHoursOfOperation().size(); ++i) {
            this.composeLocationLocationHoursOfOperationComponent(t, "Location", "hoursOfOperation", element.getHoursOfOperation().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "Location", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "Location", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeLocationLocationPositionComponent(Turtle.Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "position", name, element, index);
        if (element.hasLongitudeElement()) {
            this.composeDecimal(t, "Location", "longitude", element.getLongitudeElement(), -1);
        }
        if (element.hasLatitudeElement()) {
            this.composeDecimal(t, "Location", "latitude", element.getLatitudeElement(), -1);
        }
        if (element.hasAltitudeElement()) {
            this.composeDecimal(t, "Location", "altitude", element.getAltitudeElement(), -1);
        }
    }

    protected void composeLocationLocationHoursOfOperationComponent(Turtle.Complex parent, String parentType, String name, Location.LocationHoursOfOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "hoursOfOperation", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "Location", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "Location", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasOpeningTimeElement()) {
            this.composeTime(t, "Location", "openingTime", element.getOpeningTimeElement(), -1);
        }
        if (element.hasClosingTimeElement()) {
            this.composeTime(t, "Location", "closingTime", element.getClosingTimeElement(), -1);
        }
    }

    protected void composeMeasure(Turtle.Complex parent, String parentType, String name, Measure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Measure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Measure", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Measure", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Measure", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Measure", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Measure", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Measure", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Measure", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Measure", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Measure", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Measure", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Measure", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Measure", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Measure", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Measure", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Measure", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Measure", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Measure", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Measure", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeContributor(t, "Measure", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Measure", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "Measure", "library", element.getLibrary().get(i), i);
        }
        if (element.hasDisclaimerElement()) {
            this.composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "Measure", "scoring", element.getScoring(), -1);
        }
        if (element.hasCompositeScoring()) {
            this.composeCodeableConcept(t, "Measure", "compositeScoring", element.getCompositeScoring(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "type", element.getType().get(i), i);
        }
        if (element.hasRiskAdjustmentElement()) {
            this.composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
        }
        if (element.hasRateAggregationElement()) {
            this.composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
        }
        if (element.hasClinicalRecommendationStatementElement()) {
            this.composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
        }
        if (element.hasImprovementNotationElement()) {
            this.composeString(t, "Measure", "improvementNotation", element.getImprovementNotationElement(), -1);
        }
        for (i = 0; i < element.getDefinition().size(); ++i) {
            this.composeMarkdown(t, "Measure", "definition", element.getDefinition().get(i), i);
        }
        if (element.hasGuidanceElement()) {
            this.composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
        }
        if (element.hasSetElement()) {
            this.composeString(t, "Measure", "set", element.getSetElement(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i), i);
        }
        for (i = 0; i < element.getSupplementalData().size(); ++i) {
            this.composeMeasureMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureMeasureGroupPopulationComponent(t, "Measure", "population", element.getPopulation().get(i), i);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureMeasureGroupStratifierComponent(t, "Measure", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Measure", "criteria", element.getCriteriaElement(), -1);
        }
    }

    protected void composeMeasureMeasureGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Measure", "criteria", element.getCriteriaElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "Measure", "path", element.getPathElement(), -1);
        }
    }

    protected void composeMeasureMeasureSupplementalDataComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "supplementalData", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getUsage().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "usage", element.getUsage().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Measure", "criteria", element.getCriteriaElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "Measure", "path", element.getPathElement(), -1);
        }
    }

    protected void composeMeasureReport(Turtle.Complex parent, String parentType, String name, MeasureReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MeasureReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasMeasureElement()) {
            this.composeCanonical(t, "MeasureReport", "measure", element.getMeasureElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MeasureReport", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
        }
        if (element.hasReporter()) {
            this.composeReference(t, "MeasureReport", "reporter", element.getReporter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
        }
        if (element.hasEvaluatedResources()) {
            this.composeReference(t, "MeasureReport", "evaluatedResources", element.getEvaluatedResources(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupPopulationComponent(t, "MeasureReport", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScore()) {
            this.composeQuantity(t, "MeasureReport", "measureScore", element.getMeasureScore(), -1);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupStratifierComponent(t, "MeasureReport", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureReportMeasureReportGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjects()) {
            this.composeReference(t, "MeasureReport", "subjects", element.getSubjects(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getStratum().size(); ++i) {
            this.composeMeasureReportStratifierGroupComponent(t, "MeasureReport", "stratum", element.getStratum().get(i), i);
        }
    }

    protected void composeMeasureReportStratifierGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "stratum", name, element, index);
        if (element.hasValue()) {
            this.composeCodeableConcept(t, "MeasureReport", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportStratifierGroupPopulationComponent(t, "MeasureReport", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScore()) {
            this.composeQuantity(t, "MeasureReport", "measureScore", element.getMeasureScore(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjects()) {
            this.composeReference(t, "MeasureReport", "subjects", element.getSubjects(), -1);
        }
    }

    protected void composeMedia(Turtle.Complex parent, String parentType, String name, Media element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Media", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Media", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Media", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Media", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Media", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Media", "type", element.getType(), -1);
        }
        if (element.hasModality()) {
            this.composeCodeableConcept(t, "Media", "modality", element.getModality(), -1);
        }
        if (element.hasView()) {
            this.composeCodeableConcept(t, "Media", "view", element.getView(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Media", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Media", "context", element.getContext(), -1);
        }
        if (element.hasCreated()) {
            this.composeType(t, "Media", "created", element.getCreated(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Media", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasOperator()) {
            this.composeReference(t, "Media", "operator", element.getOperator(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Media", "reasonCode", element.getReasonCode().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Media", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasDeviceNameElement()) {
            this.composeString(t, "Media", "deviceName", element.getDeviceNameElement(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Media", "device", element.getDevice(), -1);
        }
        if (element.hasHeightElement()) {
            this.composePositiveInt(t, "Media", "height", element.getHeightElement(), -1);
        }
        if (element.hasWidthElement()) {
            this.composePositiveInt(t, "Media", "width", element.getWidthElement(), -1);
        }
        if (element.hasFramesElement()) {
            this.composePositiveInt(t, "Media", "frames", element.getFramesElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Media", "duration", element.getDurationElement(), -1);
        }
        if (element.hasContent()) {
            this.composeAttachment(t, "Media", "content", element.getContent(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Media", "note", element.getNote().get(i), i);
        }
    }

    protected void composeMedication(Turtle.Complex parent, String parentType, String name, Medication element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Medication", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Medication", "status", element.getStatusElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Medication", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "Medication", "form", element.getForm(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "Medication", "amount", element.getAmount(), -1);
        }
        for (int i = 0; i < element.getIngredient().size(); ++i) {
            this.composeMedicationMedicationIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasBatch()) {
            this.composeMedicationMedicationBatchComponent(t, "Medication", "batch", element.getBatch(), -1);
        }
    }

    protected void composeMedicationMedicationIngredientComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "Medication", "item", element.getItem(), -1);
        }
        if (element.hasIsActiveElement()) {
            this.composeBoolean(t, "Medication", "isActive", element.getIsActiveElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeRatio(t, "Medication", "amount", element.getAmount(), -1);
        }
    }

    protected void composeMedicationMedicationBatchComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationBatchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "batch", name, element, index);
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Medication", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Medication", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasSerialNumberElement()) {
            this.composeString(t, "Medication", "serialNumber", element.getSerialNumberElement(), -1);
        }
    }

    protected void composeMedicationAdministration(Turtle.Complex parent, String parentType, String name, MedicationAdministration element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicationAdministration", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "MedicationAdministration", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationAdministration", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationAdministration", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationAdministration", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationAdministration", "effective", element.getEffective(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeMedicationAdministrationMedicationAdministrationPerformerComponent(t, "MedicationAdministration", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "statusReason", element.getStatusReason().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "MedicationAdministration", "request", element.getRequest(), -1);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i), i);
        }
        if (element.hasDosage()) {
            this.composeMedicationAdministrationMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationAdministrationMedicationAdministrationPerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationAdministration", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationAdministrationMedicationAdministrationDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationAdministration", "text", element.getTextElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "method", element.getMethod(), -1);
        }
        if (element.hasDose()) {
            this.composeQuantity(t, "MedicationAdministration", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationAdministration", "rate", element.getRate(), -1);
        }
    }

    protected void composeMedicationDispense(Turtle.Complex parent, String parentType, String name, MedicationDispense element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicationDispense", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationDispense", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationDispense", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationDispense", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationDispense", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeMedicationDispenseMedicationDispensePerformerComponent(t, "MedicationDispense", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "MedicationDispense", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getAuthorizingPrescription().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDaysSupply()) {
            this.composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
        }
        if (element.hasWhenPreparedElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
        }
        if (element.hasWhenHandedOverElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
        }
        for (i = 0; i < element.getReceiver().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeDosage(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationDispenseMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
        }
        for (i = 0; i < element.getDetectedIssue().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "detectedIssue", element.getDetectedIssue().get(i), i);
        }
        if (element.hasStatusReason()) {
            this.composeType(t, "MedicationDispense", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationDispenseMedicationDispensePerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispensePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationDispense", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationDispense", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationDispenseMedicationDispenseSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasWasSubstitutedElement()) {
            this.composeBoolean(t, "MedicationDispense", "wasSubstituted", element.getWasSubstitutedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationDispense", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getResponsibleParty().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "responsibleParty", element.getResponsibleParty().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "monitoringProgram", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MedicationKnowledge", "name", element.getNameElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgePackagingComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgePackagingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "packaging", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationKnowledge", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeMedicationRequest(Turtle.Complex parent, String parentType, String name, MedicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "MedicationRequest", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "MedicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationRequest", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationRequest", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "MedicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "MedicationRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MedicationRequest", "performer", element.getPerformer(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "MedicationRequest", "recorder", element.getRecorder(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "MedicationRequest", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "MedicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "MedicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationRequest", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeDosage(t, "MedicationRequest", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasDispenseRequest()) {
            this.composeMedicationRequestMedicationRequestDispenseRequestComponent(t, "MedicationRequest", "dispenseRequest", element.getDispenseRequest(), -1);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationRequestMedicationRequestSubstitutionComponent(t, "MedicationRequest", "substitution", element.getSubstitution(), -1);
        }
        if (element.hasPriorPrescription()) {
            this.composeReference(t, "MedicationRequest", "priorPrescription", element.getPriorPrescription(), -1);
        }
        for (i = 0; i < element.getDetectedIssue().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "detectedIssue", element.getDetectedIssue().get(i), i);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationRequestMedicationRequestDispenseRequestComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dispenseRequest", name, element, index);
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicationRequest", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasNumberOfRepeatsAllowedElement()) {
            this.composeUnsignedInt(t, "MedicationRequest", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasExpectedSupplyDuration()) {
            this.composeDuration(t, "MedicationRequest", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MedicationRequest", "performer", element.getPerformer(), -1);
        }
    }

    protected void composeMedicationRequestMedicationRequestSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestSubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasAllowedElement()) {
            this.composeBoolean(t, "MedicationRequest", "allowed", element.getAllowedElement(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MedicationRequest", "reason", element.getReason(), -1);
        }
    }

    protected void composeMedicationStatement(Turtle.Complex parent, String parentType, String name, MedicationStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicationStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationStatement", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationStatement", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationStatement", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationStatement", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationStatement", "context", element.getContext(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationStatement", "effective", element.getEffective(), -1);
        }
        if (element.hasDateAssertedElement()) {
            this.composeDateTime(t, "MedicationStatement", "dateAsserted", element.getDateAssertedElement(), -1);
        }
        if (element.hasInformationSource()) {
            this.composeReference(t, "MedicationStatement", "informationSource", element.getInformationSource(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationStatement", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "MedicationStatement", "dosage", element.getDosage().get(i), i);
        }
    }

    protected void composeMedicinalProduct(Turtle.Complex parent, String parentType, String name, MedicinalProduct element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProduct", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProduct", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "type", element.getType(), -1);
        }
        if (element.hasCombinedPharmaceuticalDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "combinedPharmaceuticalDoseForm", element.getCombinedPharmaceuticalDoseForm(), -1);
        }
        if (element.hasAdditionalMonitoringIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "additionalMonitoringIndicator", element.getAdditionalMonitoringIndicator(), -1);
        }
        for (i = 0; i < element.getSpecialMeasures().size(); ++i) {
            this.composeString(t, "MedicinalProduct", "specialMeasures", element.getSpecialMeasures().get(i), i);
        }
        if (element.hasPaediatricUseIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "paediatricUseIndicator", element.getPaediatricUseIndicator(), -1);
        }
        if (element.hasOrphanDesignationStatus()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "orphanDesignationStatus", element.getOrphanDesignationStatus(), -1);
        }
        for (i = 0; i < element.getProductClassification().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProduct", "productClassification", element.getProductClassification().get(i), i);
        }
        if (element.hasMarketingAuthorization()) {
            this.composeReference(t, "MedicinalProduct", "marketingAuthorization", element.getMarketingAuthorization(), -1);
        }
        for (i = 0; i < element.getPackagedMedicinalProduct().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "packagedMedicinalProduct", element.getPackagedMedicinalProduct().get(i), i);
        }
        for (i = 0; i < element.getPharmaceuticalProduct().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "pharmaceuticalProduct", element.getPharmaceuticalProduct().get(i), i);
        }
        for (i = 0; i < element.getClinicalParticulars().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "clinicalParticulars", element.getClinicalParticulars().get(i), i);
        }
        for (i = 0; i < element.getAttachedDocument().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "attachedDocument", element.getAttachedDocument().get(i), i);
        }
        for (i = 0; i < element.getMasterFile().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "masterFile", element.getMasterFile().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeMedicinalProductMedicinalProductNameComponent(t, "MedicinalProduct", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getCrossReference().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProduct", "crossReference", element.getCrossReference().get(i), i);
        }
        for (i = 0; i < element.getManufacturingBusinessOperation().size(); ++i) {
            this.composeMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(t, "MedicinalProduct", "manufacturingBusinessOperation", element.getManufacturingBusinessOperation().get(i), i);
        }
    }

    protected void composeMedicinalProductMedicinalProductNameComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductNameComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "name", name, element, index);
        if (element.hasFullNameElement()) {
            this.composeString(t, "MedicinalProduct", "fullName", element.getFullNameElement(), -1);
        }
        for (i = 0; i < element.getNamePart().size(); ++i) {
            this.composeMedicinalProductMedicinalProductNameNamePartComponent(t, "MedicinalProduct", "namePart", element.getNamePart().get(i), i);
        }
        for (i = 0; i < element.getCountryLanguage().size(); ++i) {
            this.composeMedicinalProductMedicinalProductNameCountryLanguageComponent(t, "MedicinalProduct", "countryLanguage", element.getCountryLanguage().get(i), i);
        }
    }

    protected void composeMedicinalProductMedicinalProductNameNamePartComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductNameNamePartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "namePart", name, element, index);
        if (element.hasPartElement()) {
            this.composeString(t, "MedicinalProduct", "part", element.getPartElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "MedicinalProduct", "type", element.getType(), -1);
        }
    }

    protected void composeMedicinalProductMedicinalProductNameCountryLanguageComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductNameCountryLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "countryLanguage", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "language", element.getLanguage(), -1);
        }
    }

    protected void composeMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "manufacturingBusinessOperation", name, element, index);
        if (element.hasOperationType()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "operationType", element.getOperationType(), -1);
        }
        if (element.hasAuthorisationReferenceNumber()) {
            this.composeIdentifier(t, "MedicinalProduct", "authorisationReferenceNumber", element.getAuthorisationReferenceNumber(), -1);
        }
        if (element.hasEffectiveDateElement()) {
            this.composeDateTime(t, "MedicinalProduct", "effectiveDate", element.getEffectiveDateElement(), -1);
        }
        if (element.hasConfidentialityIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "confidentialityIndicator", element.getConfidentialityIndicator(), -1);
        }
        for (int i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "manufacturer", element.getManufacturer().get(i), i);
        }
        if (element.hasRegulator()) {
            this.composeReference(t, "MedicinalProduct", "regulator", element.getRegulator(), -1);
        }
    }

    protected void composeMedicinalProductAuthorization(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProductAuthorization", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "identifier", element.getIdentifier(), -1);
        }
        for (i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "country", element.getCountry().get(i), i);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasRestoreDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "restoreDate", element.getRestoreDateElement(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicinalProductAuthorization", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasDataExclusivityPeriod()) {
            this.composePeriod(t, "MedicinalProductAuthorization", "dataExclusivityPeriod", element.getDataExclusivityPeriod(), -1);
        }
        if (element.hasDateOfFirstAuthorizationElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "dateOfFirstAuthorization", element.getDateOfFirstAuthorizationElement(), -1);
        }
        if (element.hasInternationalBirthDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "internationalBirthDate", element.getInternationalBirthDateElement(), -1);
        }
        for (i = 0; i < element.getJurisdictionalAuthorization().size(); ++i) {
            this.composeMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(t, "MedicinalProductAuthorization", "jurisdictionalAuthorization", element.getJurisdictionalAuthorization().get(i), i);
        }
        if (element.hasHolder()) {
            this.composeReference(t, "MedicinalProductAuthorization", "holder", element.getHolder(), -1);
        }
        if (element.hasRegulator()) {
            this.composeReference(t, "MedicinalProductAuthorization", "regulator", element.getRegulator(), -1);
        }
        if (element.hasProcedure()) {
            this.composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(t, "MedicinalProductAuthorization", "procedure", element.getProcedure(), -1);
        }
        for (i = 0; i < element.getMarketingStatus().size(); ++i) {
            this.composeMarketingStatus(t, "MedicinalProductAuthorization", "marketingStatus", element.getMarketingStatus().get(i), i);
        }
    }

    protected void composeMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "jurisdictionalAuthorization", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasNumber()) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "number", element.getNumber(), -1);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
    }

    protected void composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasNumber()) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "number", element.getNumber(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "type", element.getType(), -1);
        }
        if (element.hasDate()) {
            this.composePeriod(t, "MedicinalProductAuthorization", "date", element.getDate(), -1);
        }
        for (int i = 0; i < element.getApplication().size(); ++i) {
            this.composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureApplicationComponent(t, "MedicinalProductAuthorization", "application", element.getApplication().get(i), i);
        }
    }

    protected void composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureApplicationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureApplicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "application", name, element, index);
        if (element.hasNumber()) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "number", element.getNumber(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "type", element.getType(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "date", element.getDateElement(), -1);
        }
    }

    protected void composeMedicinalProductClinicals(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProductClinicals", name, element, index);
        for (i = 0; i < element.getUndesirableEffects().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponent(t, "MedicinalProductClinicals", "undesirableEffects", element.getUndesirableEffects().get(i), i);
        }
        for (i = 0; i < element.getTherapeuticIndication().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponent(t, "MedicinalProductClinicals", "therapeuticIndication", element.getTherapeuticIndication().get(i), i);
        }
        for (i = 0; i < element.getContraindication().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsContraindicationComponent(t, "MedicinalProductClinicals", "contraindication", element.getContraindication().get(i), i);
        }
        for (i = 0; i < element.getInteractions().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsInteractionsComponent(t, "MedicinalProductClinicals", "interactions", element.getInteractions().get(i), i);
        }
    }

    protected void composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "undesirableEffects", name, element, index);
        if (element.hasSymptomConditionEffect()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "symptomConditionEffect", element.getSymptomConditionEffect(), -1);
        }
        if (element.hasClassification()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "classification", element.getClassification(), -1);
        }
        if (element.hasFrequencyOfOccurrence()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "frequencyOfOccurrence", element.getFrequencyOfOccurrence(), -1);
        }
        for (int i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(t, "MedicinalProductClinicals", "population", element.getPopulation().get(i), i);
        }
    }

    protected void composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasAge()) {
            this.composeType(t, "MedicinalProductClinicals", "age", element.getAge(), -1);
        }
        if (element.hasGender()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "gender", element.getGender(), -1);
        }
        if (element.hasRace()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "race", element.getRace(), -1);
        }
        if (element.hasPhysiologicalCondition()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "physiologicalCondition", element.getPhysiologicalCondition(), -1);
        }
    }

    protected void composeMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "therapeuticIndication", name, element, index);
        if (element.hasDiseaseSymptomProcedure()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i = 0; i < element.getComorbidity().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "comorbidity", element.getComorbidity().get(i), i);
        }
        if (element.hasIntendedEffect()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "intendedEffect", element.getIntendedEffect(), -1);
        }
        if (element.hasDuration()) {
            this.composeQuantity(t, "MedicinalProductClinicals", "duration", element.getDuration(), -1);
        }
        for (i = 0; i < element.getUndesirableEffects().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponent(t, "MedicinalProductClinicals", "undesirableEffects", element.getUndesirableEffects().get(i), i);
        }
        for (i = 0; i < element.getOtherTherapy().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(t, "MedicinalProductClinicals", "otherTherapy", element.getOtherTherapy().get(i), i);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(t, "MedicinalProductClinicals", "population", element.getPopulation().get(i), i);
        }
    }

    protected void composeMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "otherTherapy", name, element, index);
        if (element.hasTherapyRelationshipType()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "therapyRelationshipType", element.getTherapyRelationshipType(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicinalProductClinicals", "medication", element.getMedication(), -1);
        }
    }

    protected void composeMedicinalProductClinicalsMedicinalProductClinicalsContraindicationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals.MedicinalProductClinicalsContraindicationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "contraindication", name, element, index);
        if (element.hasDisease()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "disease", element.getDisease(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i = 0; i < element.getComorbidity().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "comorbidity", element.getComorbidity().get(i), i);
        }
        for (i = 0; i < element.getTherapeuticIndication().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponent(t, "MedicinalProductClinicals", "therapeuticIndication", element.getTherapeuticIndication().get(i), i);
        }
        for (i = 0; i < element.getOtherTherapy().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(t, "MedicinalProductClinicals", "otherTherapy", element.getOtherTherapy().get(i), i);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(t, "MedicinalProductClinicals", "population", element.getPopulation().get(i), i);
        }
    }

    protected void composeMedicinalProductClinicalsMedicinalProductClinicalsInteractionsComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductClinicals.MedicinalProductClinicalsInteractionsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "interactions", name, element, index);
        for (int i = 0; i < element.getInteractant().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "interactant", element.getInteractant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "type", element.getType(), -1);
        }
        if (element.hasEffect()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "effect", element.getEffect(), -1);
        }
        if (element.hasIncidence()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "incidence", element.getIncidence(), -1);
        }
        if (element.hasManagement()) {
            this.composeCodeableConcept(t, "MedicinalProductClinicals", "management", element.getManagement(), -1);
        }
    }

    protected void composeMedicinalProductDeviceSpec(Turtle.Complex parent, String parentType, String name, MedicinalProductDeviceSpec element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProductDeviceSpec", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProductDeviceSpec", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "type", element.getType(), -1);
        }
        if (element.hasTradeNameElement()) {
            this.composeString(t, "MedicinalProductDeviceSpec", "tradeName", element.getTradeNameElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicinalProductDeviceSpec", "quantity", element.getQuantity(), -1);
        }
        if (element.hasListingNumberElement()) {
            this.composeString(t, "MedicinalProductDeviceSpec", "listingNumber", element.getListingNumberElement(), -1);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "MedicinalProductDeviceSpec", "modelNumber", element.getModelNumberElement(), -1);
        }
        if (element.hasSterilityIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "sterilityIndicator", element.getSterilityIndicator(), -1);
        }
        if (element.hasSterilisationRequirement()) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "sterilisationRequirement", element.getSterilisationRequirement(), -1);
        }
        if (element.hasUsage()) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "usage", element.getUsage(), -1);
        }
        for (i = 0; i < element.getNomenclature().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "nomenclature", element.getNomenclature().get(i), i);
        }
        for (i = 0; i < element.getShelfLife().size(); ++i) {
            this.composeProductShelfLife(t, "MedicinalProductDeviceSpec", "shelfLife", element.getShelfLife().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "MedicinalProductDeviceSpec", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
        for (i = 0; i < element.getOtherCharacteristics().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "otherCharacteristics", element.getOtherCharacteristics().get(i), i);
        }
        for (i = 0; i < element.getBatchIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductDeviceSpec", "batchIdentifier", element.getBatchIdentifier().get(i), i);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductDeviceSpec", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getMaterial().size(); ++i) {
            this.composeMedicinalProductDeviceSpecMedicinalProductDeviceSpecMaterialComponent(t, "MedicinalProductDeviceSpec", "material", element.getMaterial().get(i), i);
        }
    }

    protected void composeMedicinalProductDeviceSpecMedicinalProductDeviceSpecMaterialComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDeviceSpec.MedicinalProductDeviceSpecMaterialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "material", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "MedicinalProductDeviceSpec", "substance", element.getSubstance(), -1);
        }
        if (element.hasAlternateElement()) {
            this.composeBoolean(t, "MedicinalProductDeviceSpec", "alternate", element.getAlternateElement(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "MedicinalProductDeviceSpec", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
    }

    protected void composeMedicinalProductIngredient(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProductIngredient", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProductIngredient", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "role", element.getRole(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "MedicinalProductIngredient", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductIngredient", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getSpecifiedSubstance().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(t, "MedicinalProductIngredient", "specifiedSubstance", element.getSpecifiedSubstance().get(i), i);
        }
        if (element.hasSubstance()) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(t, "MedicinalProductIngredient", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "specifiedSubstance", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "code", element.getCode(), -1);
        }
        if (element.hasGroup()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "group", element.getGroup(), -1);
        }
        if (element.hasConfidentiality()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "confidentiality", element.getConfidentiality(), -1);
        }
        for (int i = 0; i < element.getStrength().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(t, "MedicinalProductIngredient", "strength", element.getStrength().get(i), i);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "strength", name, element, index);
        if (element.hasPresentation()) {
            this.composeRatio(t, "MedicinalProductIngredient", "presentation", element.getPresentation(), -1);
        }
        if (element.hasConcentration()) {
            this.composeRatio(t, "MedicinalProductIngredient", "concentration", element.getConcentration(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "MedicinalProductIngredient", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "country", element.getCountry().get(i), i);
        }
        for (i = 0; i < element.getReferenceStrength().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(t, "MedicinalProductIngredient", "referenceStrength", element.getReferenceStrength().get(i), i);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "referenceStrength", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "substance", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getStrength().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(t, "MedicinalProductIngredient", "strength", element.getStrength().get(i), i);
        }
    }

    protected void composeMedicinalProductPackaged(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProductPackaged", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MedicinalProductPackaged", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getMarketingStatus().size(); ++i) {
            this.composeMarketingStatus(t, "MedicinalProductPackaged", "marketingStatus", element.getMarketingStatus().get(i), i);
        }
        for (i = 0; i < element.getBatchIdentifier().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(t, "MedicinalProductPackaged", "batchIdentifier", element.getBatchIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPackageItem().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(t, "MedicinalProductPackaged", "packageItem", element.getPackageItem().get(i), i);
        }
    }

    protected void composeMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "batchIdentifier", name, element, index);
        if (element.hasOuterPackaging()) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "outerPackaging", element.getOuterPackaging(), -1);
        }
        if (element.hasImmediatePackaging()) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "immediatePackaging", element.getImmediatePackaging(), -1);
        }
    }

    protected void composeMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "packageItem", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicinalProductPackaged", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getMaterial().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "material", element.getMaterial().get(i), i);
        }
        for (i = 0; i < element.getAlternateMaterial().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "alternateMaterial", element.getAlternateMaterial().get(i), i);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getManufacturedItem().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedPackageItemManufacturedItemComponent(t, "MedicinalProductPackaged", "manufacturedItem", element.getManufacturedItem().get(i), i);
        }
        for (i = 0; i < element.getOtherCharacteristics().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "otherCharacteristics", element.getOtherCharacteristics().get(i), i);
        }
        for (i = 0; i < element.getPackageItem().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(t, "MedicinalProductPackaged", "packageItem", element.getPackageItem().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "MedicinalProductPackaged", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
        for (i = 0; i < element.getShelfLifeStorage().size(); ++i) {
            this.composeProductShelfLife(t, "MedicinalProductPackaged", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
        }
    }

    protected void composeMedicinalProductPackagedMedicinalProductPackagedPackageItemManufacturedItemComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged.MedicinalProductPackagedPackageItemManufacturedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "manufacturedItem", name, element, index);
        if (element.hasManufacturedDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "manufacturedDoseForm", element.getManufacturedDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicinalProductPackaged", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getXManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "xManufacturer", element.getXManufacturer().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "MedicinalProductPackaged", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
    }

    protected void composeMedicinalProductPharmaceutical(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MedicinalProductPharmaceutical", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductPharmaceutical", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAdministrableDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "administrableDoseForm", element.getAdministrableDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        for (i = 0; i < element.getRouteOfAdministration().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "routeOfAdministration", element.getRouteOfAdministration().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeReference(t, "MedicinalProductPharmaceutical", "ingredient", element.getIngredient().get(i), i);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeString(t, "MedicinalProductPharmaceutical", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getCharacteristics().size(); ++i) {
            this.composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(t, "MedicinalProductPharmaceutical", "characteristics", element.getCharacteristics().get(i), i);
        }
    }

    protected void composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "characteristics", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "code", element.getCode(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "status", element.getStatus(), -1);
        }
    }

    protected void composeMessageDefinition(Turtle.Complex parent, String parentType, String name, MessageDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MessageDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "MessageDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MessageDefinition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MessageDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "MessageDefinition", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MessageDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "MessageDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MessageDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "MessageDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "MessageDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "MessageDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "MessageDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "MessageDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "MessageDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "MessageDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "MessageDefinition", "base", element.getBaseElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "parent", element.getParent().get(i), i);
        }
        if (element.hasEvent()) {
            this.composeType(t, "MessageDefinition", "event", element.getEvent(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "MessageDefinition", "category", element.getCategoryElement(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeMessageDefinitionMessageDefinitionFocusComponent(t, "MessageDefinition", "focus", element.getFocus().get(i), i);
        }
        if (element.hasResponseRequiredElement()) {
            this.composeEnum(t, "MessageDefinition", "responseRequired", element.getResponseRequiredElement(), -1);
        }
        for (i = 0; i < element.getAllowedResponse().size(); ++i) {
            this.composeMessageDefinitionMessageDefinitionAllowedResponseComponent(t, "MessageDefinition", "allowedResponse", element.getAllowedResponse().get(i), i);
        }
    }

    protected void composeMessageDefinitionMessageDefinitionFocusComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionFocusComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "focus", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "MessageDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "MessageDefinition", "profile", element.getProfileElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "MessageDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "MessageDefinition", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeMessageDefinitionMessageDefinitionAllowedResponseComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionAllowedResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "allowedResponse", name, element, index);
        if (element.hasMessageElement()) {
            this.composeCanonical(t, "MessageDefinition", "message", element.getMessageElement(), -1);
        }
        if (element.hasSituationElement()) {
            this.composeMarkdown(t, "MessageDefinition", "situation", element.getSituationElement(), -1);
        }
    }

    protected void composeMessageHeader(Turtle.Complex parent, String parentType, String name, MessageHeader element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "MessageHeader", name, element, index);
        if (element.hasEvent()) {
            this.composeType(t, "MessageHeader", "event", element.getEvent(), -1);
        }
        for (i = 0; i < element.getDestination().size(); ++i) {
            this.composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "MessageHeader", "sender", element.getSender(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
        }
        if (element.hasResponse()) {
            this.composeMessageHeaderMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeReference(t, "MessageHeader", "focus", element.getFocus().get(i), i);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "MessageHeader", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageDestinationComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageHeader", "name", element.getNameElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "MessageHeader", "target", element.getTarget(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageHeader", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasReceiver()) {
            this.composeReference(t, "MessageHeader", "receiver", element.getReceiver(), -1);
        }
    }

    protected void composeMessageHeaderMessageSourceComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageHeader", "name", element.getNameElement(), -1);
        }
        if (element.hasSoftwareElement()) {
            this.composeString(t, "MessageHeader", "software", element.getSoftwareElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageHeader", "version", element.getVersionElement(), -1);
        }
        if (element.hasContact()) {
            this.composeContactPoint(t, "MessageHeader", "contact", element.getContact(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageHeader", "endpoint", element.getEndpointElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageHeaderResponseComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasIdentifierElement()) {
            this.composeId(t, "MessageHeader", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "MessageHeader", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeReference(t, "MessageHeader", "details", element.getDetails(), -1);
        }
    }

    protected void composeNamingSystem(Turtle.Complex parent, String parentType, String name, NamingSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "NamingSystem", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "NamingSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasResponsibleElement()) {
            this.composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "NamingSystem", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "NamingSystem", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
        }
        for (i = 0; i < element.getUniqueId().size(); ++i) {
            this.composeNamingSystemNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i), i);
        }
    }

    protected void composeNamingSystemNamingSystemUniqueIdComponent(Turtle.Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "uniqueId", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NamingSystem", "type", element.getTypeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "NamingSystem", "value", element.getValueElement(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "NamingSystem", "preferred", element.getPreferredElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "NamingSystem", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "NamingSystem", "period", element.getPeriod(), -1);
        }
    }

    protected void composeNutritionOrder(Turtle.Complex parent, String parentType, String name, NutritionOrder element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "NutritionOrder", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "NutritionOrder", "instantiates", element.getInstantiates().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "NutritionOrder", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "NutritionOrder", "patient", element.getPatient(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "NutritionOrder", "context", element.getContext(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
        }
        for (i = 0; i < element.getAllergyIntolerance().size(); ++i) {
            this.composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i), i);
        }
        for (i = 0; i < element.getFoodPreferenceModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i), i);
        }
        for (i = 0; i < element.getExcludeFoodModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i), i);
        }
        if (element.hasOralDiet()) {
            this.composeNutritionOrderNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
        }
        for (i = 0; i < element.getSupplement().size(); ++i) {
            this.composeNutritionOrderNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i), i);
        }
        if (element.hasEnteralFormula()) {
            this.composeNutritionOrderNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "NutritionOrder", "note", element.getNote().get(i), i);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "oralDiet", name, element, index);
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule().get(i), i);
        }
        for (i = 0; i < element.getNutrient().size(); ++i) {
            this.composeNutritionOrderNutritionOrderOralDietNutrientComponent(t, "NutritionOrder", "nutrient", element.getNutrient().get(i), i);
        }
        for (i = 0; i < element.getTexture().size(); ++i) {
            this.composeNutritionOrderNutritionOrderOralDietTextureComponent(t, "NutritionOrder", "texture", element.getTexture().get(i), i);
        }
        for (i = 0; i < element.getFluidConsistencyType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "fluidConsistencyType", element.getFluidConsistencyType().get(i), i);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrder", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietNutrientComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrder", "modifier", element.getModifier(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionOrder", "amount", element.getAmount(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietTextureComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "texture", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrder", "modifier", element.getModifier(), -1);
        }
        if (element.hasFoodType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodType", element.getFoodType(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderSupplementComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "supplement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "type", element.getType(), -1);
        }
        if (element.hasProductNameElement()) {
            this.composeString(t, "NutritionOrder", "productName", element.getProductNameElement(), -1);
        }
        for (int i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrder", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderEnteralFormulaComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "enteralFormula", name, element, index);
        if (element.hasBaseFormulaType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "baseFormulaType", element.getBaseFormulaType(), -1);
        }
        if (element.hasBaseFormulaProductNameElement()) {
            this.composeString(t, "NutritionOrder", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
        }
        if (element.hasAdditiveType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "additiveType", element.getAdditiveType(), -1);
        }
        if (element.hasAdditiveProductNameElement()) {
            this.composeString(t, "NutritionOrder", "additiveProductName", element.getAdditiveProductNameElement(), -1);
        }
        if (element.hasCaloricDensity()) {
            this.composeQuantity(t, "NutritionOrder", "caloricDensity", element.getCaloricDensity(), -1);
        }
        if (element.hasRouteofAdministration()) {
            this.composeCodeableConcept(t, "NutritionOrder", "routeofAdministration", element.getRouteofAdministration(), -1);
        }
        for (int i = 0; i < element.getAdministration().size(); ++i) {
            this.composeNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrder", "administration", element.getAdministration().get(i), i);
        }
        if (element.hasMaxVolumeToDeliver()) {
            this.composeQuantity(t, "NutritionOrder", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
        }
        if (element.hasAdministrationInstructionElement()) {
            this.composeString(t, "NutritionOrder", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "administration", name, element, index);
        if (element.hasSchedule()) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "NutritionOrder", "rate", element.getRate(), -1);
        }
    }

    protected void composeObservation(Turtle.Complex parent, String parentType, String name, Observation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Observation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Observation", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Observation", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Observation", "subject", element.getSubject(), -1);
        }
        if (element.hasFocus()) {
            this.composeReference(t, "Observation", "focus", element.getFocus(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Observation", "context", element.getContext(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "Observation", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Observation", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasInterpretation()) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Observation", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Observation", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
        for (i = 0; i < element.getHasMember().size(); ++i) {
            this.composeReference(t, "Observation", "hasMember", element.getHasMember().get(i), i);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "Observation", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeObservationObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeObservationObservationReferenceRangeComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "referenceRange", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Observation", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Observation", "high", element.getHigh(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Observation", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getAppliesTo().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "appliesTo", element.getAppliesTo().get(i), i);
        }
        if (element.hasAge()) {
            this.composeRange(t, "Observation", "age", element.getAge(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Observation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeObservationObservationComponentComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasInterpretation()) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation(), -1);
        }
        for (int i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
    }

    protected void composeObservationDefinition(Turtle.Complex parent, String parentType, String name, ObservationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ObservationDefinition", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ObservationDefinition", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCoding(t, "ObservationDefinition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getPermittedDataType().size(); ++i) {
            this.composeCoding(t, "ObservationDefinition", "permittedDataType", element.getPermittedDataType().get(i), i);
        }
        if (element.hasMultipleResultsAllowedElement()) {
            this.composeBoolean(t, "ObservationDefinition", "multipleResultsAllowed", element.getMultipleResultsAllowedElement(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "method", element.getMethod(), -1);
        }
        if (element.hasPreferredReportNameElement()) {
            this.composeString(t, "ObservationDefinition", "preferredReportName", element.getPreferredReportNameElement(), -1);
        }
        if (element.hasQuantitativeDetails()) {
            this.composeObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinition", "quantitativeDetails", element.getQuantitativeDetails(), -1);
        }
        for (i = 0; i < element.getQualifiedInterval().size(); ++i) {
            this.composeObservationDefinitionObservationDefinitionQualifiedIntervalComponent(t, "ObservationDefinition", "qualifiedInterval", element.getQualifiedInterval().get(i), i);
        }
        if (element.hasValidCodedValueSetElement()) {
            this.composeUri(t, "ObservationDefinition", "validCodedValueSet", element.getValidCodedValueSetElement(), -1);
        }
        if (element.hasNormalCodedValueSetElement()) {
            this.composeUri(t, "ObservationDefinition", "normalCodedValueSet", element.getNormalCodedValueSetElement(), -1);
        }
        if (element.hasAbnormalCodedValueSetElement()) {
            this.composeUri(t, "ObservationDefinition", "abnormalCodedValueSet", element.getAbnormalCodedValueSetElement(), -1);
        }
        if (element.hasCriticalCodedValueSetElement()) {
            this.composeUri(t, "ObservationDefinition", "criticalCodedValueSet", element.getCriticalCodedValueSetElement(), -1);
        }
    }

    protected void composeObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "quantitativeDetails", name, element, index);
        if (element.hasCustomaryUnit()) {
            this.composeCoding(t, "ObservationDefinition", "customaryUnit", element.getCustomaryUnit(), -1);
        }
        if (element.hasUnit()) {
            this.composeCoding(t, "ObservationDefinition", "unit", element.getUnit(), -1);
        }
        if (element.hasConversionFactorElement()) {
            this.composeDecimal(t, "ObservationDefinition", "conversionFactor", element.getConversionFactorElement(), -1);
        }
        if (element.hasDecimalPrecisionElement()) {
            this.composeInteger(t, "ObservationDefinition", "decimalPrecision", element.getDecimalPrecisionElement(), -1);
        }
    }

    protected void composeObservationDefinitionObservationDefinitionQualifiedIntervalComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "qualifiedInterval", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "category", element.getCategory(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "ObservationDefinition", "range", element.getRange(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getAppliesTo().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationDefinition", "appliesTo", element.getAppliesTo().get(i), i);
        }
        if (element.hasAge()) {
            this.composeRange(t, "ObservationDefinition", "age", element.getAge(), -1);
        }
        if (element.hasGestationalAge()) {
            this.composeRange(t, "ObservationDefinition", "gestationalAge", element.getGestationalAge(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "ObservationDefinition", "condition", element.getConditionElement(), -1);
        }
    }

    protected void composeOccupationalData(Turtle.Complex parent, String parentType, String name, OccupationalData element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "OccupationalData", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "OccupationalData", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "OccupationalData", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "OccupationalData", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OccupationalData", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getRecorder().size(); ++i) {
            this.composeReference(t, "OccupationalData", "recorder", element.getRecorder().get(i), i);
        }
        for (i = 0; i < element.getInformant().size(); ++i) {
            this.composeReference(t, "OccupationalData", "informant", element.getInformant().get(i), i);
        }
        for (i = 0; i < element.getEmploymentStatus().size(); ++i) {
            this.composeOccupationalDataOccupationalDataEmploymentStatusComponent(t, "OccupationalData", "employmentStatus", element.getEmploymentStatus().get(i), i);
        }
        for (i = 0; i < element.getRetirementDate().size(); ++i) {
            this.composeDateTime(t, "OccupationalData", "retirementDate", element.getRetirementDate().get(i), i);
        }
        for (i = 0; i < element.getCombatZonePeriod().size(); ++i) {
            this.composePeriod(t, "OccupationalData", "combatZonePeriod", element.getCombatZonePeriod().get(i), i);
        }
        if (element.hasUsualWork()) {
            this.composeOccupationalDataOccupationalDataUsualWorkComponent(t, "OccupationalData", "usualWork", element.getUsualWork(), -1);
        }
        for (i = 0; i < element.getPastOrPresentJob().size(); ++i) {
            this.composeOccupationalDataOccupationalDataPastOrPresentJobComponent(t, "OccupationalData", "pastOrPresentJob", element.getPastOrPresentJob().get(i), i);
        }
    }

    protected void composeOccupationalDataOccupationalDataEmploymentStatusComponent(Turtle.Complex parent, String parentType, String name, OccupationalData.OccupationalDataEmploymentStatusComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "employmentStatus", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "OccupationalData", "code", element.getCode(), -1);
        }
        if (element.hasEffective()) {
            this.composePeriod(t, "OccupationalData", "effective", element.getEffective(), -1);
        }
    }

    protected void composeOccupationalDataOccupationalDataUsualWorkComponent(Turtle.Complex parent, String parentType, String name, OccupationalData.OccupationalDataUsualWorkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "usualWork", name, element, index);
        if (element.hasOccupation()) {
            this.composeCodeableConcept(t, "OccupationalData", "occupation", element.getOccupation(), -1);
        }
        if (element.hasIndustry()) {
            this.composeCodeableConcept(t, "OccupationalData", "industry", element.getIndustry(), -1);
        }
        if (element.hasStartElement()) {
            this.composeDateTime(t, "OccupationalData", "start", element.getStartElement(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "OccupationalData", "duration", element.getDuration(), -1);
        }
    }

    protected void composeOccupationalDataOccupationalDataPastOrPresentJobComponent(Turtle.Complex parent, String parentType, String name, OccupationalData.OccupationalDataPastOrPresentJobComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "pastOrPresentJob", name, element, index);
        if (element.hasOccupation()) {
            this.composeCodeableConcept(t, "OccupationalData", "occupation", element.getOccupation(), -1);
        }
        if (element.hasIndustry()) {
            this.composeCodeableConcept(t, "OccupationalData", "industry", element.getIndustry(), -1);
        }
        if (element.hasEffective()) {
            this.composePeriod(t, "OccupationalData", "effective", element.getEffective(), -1);
        }
        if (element.hasEmployer()) {
            this.composeReference(t, "OccupationalData", "employer", element.getEmployer(), -1);
        }
        if (element.hasWorkClassification()) {
            this.composeCodeableConcept(t, "OccupationalData", "workClassification", element.getWorkClassification(), -1);
        }
        if (element.hasSupervisoryLevel()) {
            this.composeCodeableConcept(t, "OccupationalData", "supervisoryLevel", element.getSupervisoryLevel(), -1);
        }
        for (i = 0; i < element.getJobDuty().size(); ++i) {
            this.composeString(t, "OccupationalData", "jobDuty", element.getJobDuty().get(i), i);
        }
        for (i = 0; i < element.getOccupationalHazard().size(); ++i) {
            this.composeString(t, "OccupationalData", "occupationalHazard", element.getOccupationalHazard().get(i), i);
        }
        if (element.hasWorkSchedule()) {
            this.composeOccupationalDataOccupationalDataPastOrPresentJobWorkScheduleComponent(t, "OccupationalData", "workSchedule", element.getWorkSchedule(), -1);
        }
    }

    protected void composeOccupationalDataOccupationalDataPastOrPresentJobWorkScheduleComponent(Turtle.Complex parent, String parentType, String name, OccupationalData.OccupationalDataPastOrPresentJobWorkScheduleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "workSchedule", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "OccupationalData", "code", element.getCode(), -1);
        }
        if (element.hasWeeklyWorkDaysElement()) {
            this.composeDecimal(t, "OccupationalData", "weeklyWorkDays", element.getWeeklyWorkDaysElement(), -1);
        }
        if (element.hasDailyWorkHoursElement()) {
            this.composeDecimal(t, "OccupationalData", "dailyWorkHours", element.getDailyWorkHoursElement(), -1);
        }
    }

    protected void composeOperationDefinition(Turtle.Complex parent, String parentType, String name, OperationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "OperationDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "OperationDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "OperationDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "OperationDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "OperationDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasAffectsStateElement()) {
            this.composeBoolean(t, "OperationDefinition", "affectsState", element.getAffectsStateElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "OperationDefinition", "base", element.getBaseElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCode(t, "OperationDefinition", "resource", element.getResource().get(i), i);
        }
        if (element.hasSystemElement()) {
            this.composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeBoolean(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasInstanceElement()) {
            this.composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
        }
        if (element.hasInputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "inputProfile", element.getInputProfileElement(), -1);
        }
        if (element.hasOutputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "outputProfile", element.getOutputProfileElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getOverload().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionOverloadComponent(t, "OperationDefinition", "overload", element.getOverload().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "OperationDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "OperationDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "OperationDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "OperationDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getTargetProfile().size(); ++i) {
            this.composeCanonical(t, "OperationDefinition", "targetProfile", element.getTargetProfile().get(i), i);
        }
        if (element.hasSearchTypeElement()) {
            this.composeEnum(t, "OperationDefinition", "searchType", element.getSearchTypeElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeOperationDefinitionOperationDefinitionParameterBindingComponent(t, "OperationDefinition", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getPart().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterComponent(t, "OperationDefinition", "part", element.getPart().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterBindingComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "OperationDefinition", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "OperationDefinition", "valueSet", element.getValueSet(), -1);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionOverloadComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionOverloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "overload", name, element, index);
        for (int i = 0; i < element.getParameterName().size(); ++i) {
            this.composeString(t, "OperationDefinition", "parameterName", element.getParameterName().get(i), i);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeOperationOutcome(Turtle.Complex parent, String parentType, String name, OperationOutcome element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "OperationOutcome", name, element, index);
        for (int i = 0; i < element.getIssue().size(); ++i) {
            this.composeOperationOutcomeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i), i);
        }
    }

    protected void composeOperationOutcomeOperationOutcomeIssueComponent(Turtle.Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "issue", name, element, index);
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "OperationOutcome", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "OperationOutcome", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeCodeableConcept(t, "OperationOutcome", "details", element.getDetails(), -1);
        }
        if (element.hasDiagnosticsElement()) {
            this.composeString(t, "OperationOutcome", "diagnostics", element.getDiagnosticsElement(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeString(t, "OperationOutcome", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getExpression().size(); ++i) {
            this.composeString(t, "OperationOutcome", "expression", element.getExpression().get(i), i);
        }
    }

    protected void composeOrganization(Turtle.Complex parent, String parentType, String name, Organization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Organization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Organization", "type", element.getType().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Organization", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Organization", "alias", element.getAlias().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Organization", "address", element.getAddress().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeOrganizationOrganizationContactComponent(t, "Organization", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "Organization", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeOrganizationOrganizationContactComponent(Turtle.Complex parent, String parentType, String name, Organization.OrganizationContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "Organization", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "Organization", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Organization", "address", element.getAddress(), -1);
        }
    }

    protected void composeOrganizationRole(Turtle.Complex parent, String parentType, String name, OrganizationRole element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "OrganizationRole", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "OrganizationRole", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "OrganizationRole", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "OrganizationRole", "period", element.getPeriod(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "OrganizationRole", "organization", element.getOrganization(), -1);
        }
        if (element.hasParticipatingOrganization()) {
            this.composeReference(t, "OrganizationRole", "participatingOrganization", element.getParticipatingOrganization(), -1);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "OrganizationRole", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "OrganizationRole", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "OrganizationRole", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "OrganizationRole", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "OrganizationRole", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "OrganizationRole", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composeOrganizationRoleOrganizationRoleAvailableTimeComponent(t, "OrganizationRole", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composeOrganizationRoleOrganizationRoleNotAvailableComponent(t, "OrganizationRole", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "OrganizationRole", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "OrganizationRole", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeOrganizationRoleOrganizationRoleAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, OrganizationRole.OrganizationRoleAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "OrganizationRole", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "OrganizationRole", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "OrganizationRole", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "OrganizationRole", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composeOrganizationRoleOrganizationRoleNotAvailableComponent(Turtle.Complex parent, String parentType, String name, OrganizationRole.OrganizationRoleNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "OrganizationRole", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "OrganizationRole", "during", element.getDuring(), -1);
        }
    }

    protected void composePatient(Turtle.Complex parent, String parentType, String name, Patient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Patient", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Patient", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "Patient", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Patient", "address", element.getAddress().get(i), i);
        }
        if (element.hasMaritalStatus()) {
            this.composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
        }
        if (element.hasMultipleBirth()) {
            this.composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Patient", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composePatientPatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i), i);
        }
        for (i = 0; i < element.getGeneralPractitioner().size(); ++i) {
            this.composeReference(t, "Patient", "generalPractitioner", element.getGeneralPractitioner().get(i), i);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePatientPatientLinkComponent(t, "Patient", "link", element.getLink().get(i), i);
        }
    }

    protected void composePatientContactComponent(Turtle.Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "Patient", "relationship", element.getRelationship().get(i), i);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "Patient", "name", element.getName(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Patient", "address", element.getAddress(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "Patient", "organization", element.getOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Patient", "period", element.getPeriod(), -1);
        }
    }

    protected void composePatientPatientCommunicationComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "Patient", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "Patient", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composePatientPatientLinkComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasOther()) {
            this.composeReference(t, "Patient", "other", element.getOther(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Patient", "type", element.getTypeElement(), -1);
        }
    }

    protected void composePaymentNotice(Turtle.Complex parent, String parentType, String name, PaymentNotice element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "PaymentNotice", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentNotice", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentNotice", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "PaymentNotice", "response", element.getResponse(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "PaymentNotice", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "PaymentNotice", "target", element.getTarget(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "PaymentNotice", "provider", element.getProvider(), -1);
        }
        if (element.hasPaymentStatus()) {
            this.composeCodeableConcept(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
        }
    }

    protected void composePaymentReconciliation(Turtle.Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "PaymentReconciliation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentReconciliation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PaymentReconciliation", "period", element.getPeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentReconciliation", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "PaymentReconciliation", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "PaymentReconciliation", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "PaymentReconciliation", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "PaymentReconciliation", "requestProvider", element.getRequestProvider(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composePaymentReconciliationDetailsComponent(t, "PaymentReconciliation", "detail", element.getDetail().get(i), i);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "form", element.getForm(), -1);
        }
        if (element.hasTotal()) {
            this.composeMoney(t, "PaymentReconciliation", "total", element.getTotal(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composePaymentReconciliationNotesComponent(t, "PaymentReconciliation", "processNote", element.getProcessNote().get(i), i);
        }
    }

    protected void composePaymentReconciliationDetailsComponent(Turtle.Complex parent, String parentType, String name, PaymentReconciliation.DetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "type", element.getType(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "PaymentReconciliation", "response", element.getResponse(), -1);
        }
        if (element.hasSubmitter()) {
            this.composeReference(t, "PaymentReconciliation", "submitter", element.getSubmitter(), -1);
        }
        if (element.hasPayee()) {
            this.composeReference(t, "PaymentReconciliation", "payee", element.getPayee(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentReconciliation", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentReconciliation", "amount", element.getAmount(), -1);
        }
    }

    protected void composePaymentReconciliationNotesComponent(Turtle.Complex parent, String parentType, String name, PaymentReconciliation.NotesComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PaymentReconciliation", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "PaymentReconciliation", "text", element.getTextElement(), -1);
        }
    }

    protected void composePerson(Turtle.Complex parent, String parentType, String name, Person element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Person", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Person", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Person", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Person", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Person", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Person", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Person", "address", element.getAddress().get(i), i);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "Person", "photo", element.getPhoto(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Person", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Person", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePersonPersonLinkComponent(t, "Person", "link", element.getLink().get(i), i);
        }
    }

    protected void composePersonPersonLinkComponent(Turtle.Complex parent, String parentType, String name, Person.PersonLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasTarget()) {
            this.composeReference(t, "Person", "target", element.getTarget(), -1);
        }
        if (element.hasAssuranceElement()) {
            this.composeEnum(t, "Person", "assurance", element.getAssuranceElement(), -1);
        }
    }

    protected void composePlanDefinition(Turtle.Complex parent, String parentType, String name, PlanDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "PlanDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "PlanDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PlanDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "PlanDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "PlanDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "PlanDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PlanDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "PlanDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "PlanDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "PlanDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "PlanDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "PlanDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "PlanDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "PlanDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "PlanDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "PlanDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "PlanDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "PlanDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeContributor(t, "PlanDefinition", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "PlanDefinition", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionGoalComponent(t, "PlanDefinition", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
        }
    }

    protected void composePlanDefinitionPlanDefinitionGoalComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "goal", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "PlanDefinition", "category", element.getCategory(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "PlanDefinition", "description", element.getDescription(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "PlanDefinition", "priority", element.getPriority(), -1);
        }
        if (element.hasStart()) {
            this.composeCodeableConcept(t, "PlanDefinition", "start", element.getStart(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionGoalTargetComponent(t, "PlanDefinition", "target", element.getTarget().get(i), i);
        }
    }

    protected void composePlanDefinitionPlanDefinitionGoalTargetComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "PlanDefinition", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "PlanDefinition", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeDuration(t, "PlanDefinition", "due", element.getDue(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasPrefixElement()) {
            this.composeString(t, "PlanDefinition", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "PlanDefinition", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getGoalId().size(); ++i) {
            this.composeId(t, "PlanDefinition", "goalId", element.getGoalId().get(i), i);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "PlanDefinition", "trigger", element.getTrigger().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionConditionComponent(t, "PlanDefinition", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeDataRequirement(t, "PlanDefinition", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getOutput().size(); ++i) {
            this.composeDataRequirement(t, "PlanDefinition", "output", element.getOutput().get(i), i);
        }
        for (i = 0; i < element.getRelatedAction().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionRelatedActionComponent(t, "PlanDefinition", "relatedAction", element.getRelatedAction().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "PlanDefinition", "timing", element.getTiming(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionParticipantComponent(t, "PlanDefinition", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
        }
        if (element.hasGroupingBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
        }
        if (element.hasRequiredBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
        }
        if (element.hasPrecheckBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
        }
        if (element.hasCardinalityBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "PlanDefinition", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "PlanDefinition", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getDynamicValue().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionDynamicValueComponent(t, "PlanDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionConditionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "PlanDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeString(t, "PlanDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "PlanDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionRelatedActionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdElement()) {
            this.composeId(t, "PlanDefinition", "actionId", element.getActionIdElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "PlanDefinition", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "PlanDefinition", "offset", element.getOffset(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionParticipantComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PlanDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "PlanDefinition", "role", element.getRole(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "PlanDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeString(t, "PlanDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "PlanDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composePractitioner(Turtle.Complex parent, String parentType, String name, Practitioner element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Practitioner", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Practitioner", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Practitioner", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Practitioner", "address", element.getAddress().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Practitioner", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Practitioner", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Practitioner", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getQualification().size(); ++i) {
            this.composePractitionerPractitionerQualificationComponent(t, "Practitioner", "qualification", element.getQualification().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeCodeableConcept(t, "Practitioner", "communication", element.getCommunication().get(i), i);
        }
    }

    protected void composePractitionerPractitionerQualificationComponent(Turtle.Complex parent, String parentType, String name, Practitioner.PractitionerQualificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "qualification", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Practitioner", "code", element.getCode(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Practitioner", "period", element.getPeriod(), -1);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Practitioner", "issuer", element.getIssuer(), -1);
        }
    }

    protected void composePractitionerRole(Turtle.Complex parent, String parentType, String name, PractitionerRole element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "PractitionerRole", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PractitionerRole", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "PractitionerRole", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PractitionerRole", "period", element.getPeriod(), -1);
        }
        if (element.hasPractitioner()) {
            this.composeReference(t, "PractitionerRole", "practitioner", element.getPractitioner(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "PractitionerRole", "organization", element.getOrganization(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "PractitionerRole", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composePractitionerRolePractitionerRoleAvailableTimeComponent(t, "PractitionerRole", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composePractitionerRolePractitionerRoleNotAvailableComponent(t, "PractitionerRole", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "PractitionerRole", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composePractitionerRolePractitionerRoleAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "PractitionerRole", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "PractitionerRole", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "PractitionerRole", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "PractitionerRole", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composePractitionerRolePractitionerRoleNotAvailableComponent(Turtle.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PractitionerRole", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "PractitionerRole", "during", element.getDuring(), -1);
        }
    }

    protected void composeProcedure(Turtle.Complex parent, String parentType, String name, Procedure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Procedure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Procedure", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "Procedure", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Procedure", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Procedure", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Procedure", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Procedure", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Procedure", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Procedure", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Procedure", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Procedure", "context", element.getContext(), -1);
        }
        if (element.hasPerformed()) {
            this.composeType(t, "Procedure", "performed", element.getPerformed(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "Procedure", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Procedure", "asserter", element.getAsserter(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeProcedureProcedurePerformerComponent(t, "Procedure", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Procedure", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Procedure", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "Procedure", "outcome", element.getOutcome(), -1);
        }
        for (i = 0; i < element.getReport().size(); ++i) {
            this.composeReference(t, "Procedure", "report", element.getReport().get(i), i);
        }
        for (i = 0; i < element.getComplication().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "complication", element.getComplication().get(i), i);
        }
        for (i = 0; i < element.getComplicationDetail().size(); ++i) {
            this.composeReference(t, "Procedure", "complicationDetail", element.getComplicationDetail().get(i), i);
        }
        for (i = 0; i < element.getFollowUp().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "followUp", element.getFollowUp().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Procedure", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getFocalDevice().size(); ++i) {
            this.composeProcedureProcedureFocalDeviceComponent(t, "Procedure", "focalDevice", element.getFocalDevice().get(i), i);
        }
        for (i = 0; i < element.getUsedReference().size(); ++i) {
            this.composeReference(t, "Procedure", "usedReference", element.getUsedReference().get(i), i);
        }
        for (i = 0; i < element.getUsedCode().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "usedCode", element.getUsedCode().get(i), i);
        }
    }

    protected void composeProcedureProcedurePerformerComponent(Turtle.Complex parent, String parentType, String name, Procedure.ProcedurePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Procedure", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Procedure", "actor", element.getActor(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "Procedure", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
    }

    protected void composeProcedureProcedureFocalDeviceComponent(Turtle.Complex parent, String parentType, String name, Procedure.ProcedureFocalDeviceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "focalDevice", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "Procedure", "action", element.getAction(), -1);
        }
        if (element.hasManipulated()) {
            this.composeReference(t, "Procedure", "manipulated", element.getManipulated(), -1);
        }
    }

    protected void composeProcessRequest(Turtle.Complex parent, String parentType, String name, ProcessRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ProcessRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ProcessRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ProcessRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasActionElement()) {
            this.composeEnum(t, "ProcessRequest", "action", element.getActionElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "ProcessRequest", "target", element.getTarget(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ProcessRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ProcessRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "ProcessRequest", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "ProcessRequest", "response", element.getResponse(), -1);
        }
        if (element.hasNullifyElement()) {
            this.composeBoolean(t, "ProcessRequest", "nullify", element.getNullifyElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeString(t, "ProcessRequest", "reference", element.getReferenceElement(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeProcessRequestItemsComponent(t, "ProcessRequest", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getInclude().size(); ++i) {
            this.composeString(t, "ProcessRequest", "include", element.getInclude().get(i), i);
        }
        for (i = 0; i < element.getExclude().size(); ++i) {
            this.composeString(t, "ProcessRequest", "exclude", element.getExclude().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ProcessRequest", "period", element.getPeriod(), -1);
        }
    }

    protected void composeProcessRequestItemsComponent(Turtle.Complex parent, String parentType, String name, ProcessRequest.ItemsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceLinkIdElement()) {
            this.composeInteger(t, "ProcessRequest", "sequenceLinkId", element.getSequenceLinkIdElement(), -1);
        }
    }

    protected void composeProcessResponse(Turtle.Complex parent, String parentType, String name, ProcessResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ProcessResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ProcessResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ProcessResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ProcessResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "ProcessResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "ProcessResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ProcessResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ProcessResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "ProcessResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "ProcessResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeProcessResponseProcessResponseProcessNoteComponent(t, "ProcessResponse", "processNote", element.getProcessNote().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeCodeableConcept(t, "ProcessResponse", "error", element.getError().get(i), i);
        }
        for (i = 0; i < element.getCommunicationRequest().size(); ++i) {
            this.composeReference(t, "ProcessResponse", "communicationRequest", element.getCommunicationRequest().get(i), i);
        }
    }

    protected void composeProcessResponseProcessResponseProcessNoteComponent(Turtle.Complex parent, String parentType, String name, ProcessResponse.ProcessResponseProcessNoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ProcessResponse", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ProcessResponse", "text", element.getTextElement(), -1);
        }
    }

    protected void composeProductPlanProductPlanContactComponent(Turtle.Complex parent, String parentType, String name, ProductPlan.ProductPlanContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "ProductPlan", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "ProductPlan", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ProductPlan", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "ProductPlan", "address", element.getAddress(), -1);
        }
    }

    protected void composeProvenance(Turtle.Complex parent, String parentType, String name, Provenance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Provenance", name, element, index);
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeReference(t, "Provenance", "target", element.getTarget().get(i), i);
        }
        if (element.hasOccurred()) {
            this.composeType(t, "Provenance", "occurred", element.getOccurred(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "Provenance", "recorded", element.getRecordedElement(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "Provenance", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Provenance", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Provenance", "reason", element.getReason().get(i), i);
        }
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "Provenance", "activity", element.getActivity(), -1);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeProvenanceProvenanceEntityComponent(t, "Provenance", "entity", element.getEntity().get(i), i);
        }
        for (i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Provenance", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeProvenanceProvenanceAgentComponent(Turtle.Complex parent, String parentType, String name, Provenance.ProvenanceAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Provenance", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "Provenance", "role", element.getRole().get(i), i);
        }
        if (element.hasWho()) {
            this.composeType(t, "Provenance", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeType(t, "Provenance", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
    }

    protected void composeProvenanceProvenanceEntityComponent(Turtle.Complex parent, String parentType, String name, Provenance.ProvenanceEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasRoleElement()) {
            this.composeEnum(t, "Provenance", "role", element.getRoleElement(), -1);
        }
        if (element.hasWhat()) {
            this.composeType(t, "Provenance", "what", element.getWhat(), -1);
        }
        for (int i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
        }
    }

    protected void composeQuestionnaire(Turtle.Complex parent, String parentType, String name, Questionnaire element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Questionnaire", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Questionnaire", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Questionnaire", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Questionnaire", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Questionnaire", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Questionnaire", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeCanonical(t, "Questionnaire", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Questionnaire", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Questionnaire", "experimental", element.getExperimentalElement(), -1);
        }
        for (i = 0; i < element.getSubjectType().size(); ++i) {
            this.composeCode(t, "Questionnaire", "subjectType", element.getSubjectType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Questionnaire", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Questionnaire", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Questionnaire", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Questionnaire", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Questionnaire", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Questionnaire", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Questionnaire", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Questionnaire", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Questionnaire", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Questionnaire", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Questionnaire", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "Questionnaire", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "Questionnaire", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
        }
        if (element.hasPrefixElement()) {
            this.composeString(t, "Questionnaire", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Questionnaire", "text", element.getTextElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Questionnaire", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getEnableWhen().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemEnableWhenComponent(t, "Questionnaire", "enableWhen", element.getEnableWhen().get(i), i);
        }
        if (element.hasEnableBehaviorElement()) {
            this.composeEnum(t, "Questionnaire", "enableBehavior", element.getEnableBehaviorElement(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "Questionnaire", "required", element.getRequiredElement(), -1);
        }
        if (element.hasRepeatsElement()) {
            this.composeBoolean(t, "Questionnaire", "repeats", element.getRepeatsElement(), -1);
        }
        if (element.hasReadOnlyElement()) {
            this.composeBoolean(t, "Questionnaire", "readOnly", element.getReadOnlyElement(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "Questionnaire", "maxLength", element.getMaxLengthElement(), -1);
        }
        if (element.hasOptionsElement()) {
            this.composeCanonical(t, "Questionnaire", "options", element.getOptionsElement(), -1);
        }
        for (i = 0; i < element.getOption().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemOptionComponent(t, "Questionnaire", "option", element.getOption().get(i), i);
        }
        for (i = 0; i < element.getInitial().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemInitialComponent(t, "Questionnaire", "initial", element.getInitial().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemEnableWhenComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemEnableWhenComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "enableWhen", name, element, index);
        if (element.hasQuestionElement()) {
            this.composeString(t, "Questionnaire", "question", element.getQuestionElement(), -1);
        }
        if (element.hasOperatorElement()) {
            this.composeEnum(t, "Questionnaire", "operator", element.getOperatorElement(), -1);
        }
        if (element.hasAnswer()) {
            this.composeType(t, "Questionnaire", "answer", element.getAnswer(), -1);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemOptionComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemOptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "option", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "Questionnaire", "value", element.getValue(), -1);
        }
        if (element.hasInitialSelectedElement()) {
            this.composeBoolean(t, "Questionnaire", "initialSelected", element.getInitialSelectedElement(), -1);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemInitialComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemInitialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "initial", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "Questionnaire", "value", element.getValue(), -1);
        }
    }

    protected void composeQuestionnaireResponse(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "QuestionnaireResponse", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "QuestionnaireResponse", "identifier", element.getIdentifier(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "QuestionnaireResponse", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "QuestionnaireResponse", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasQuestionnaireElement()) {
            this.composeCanonical(t, "QuestionnaireResponse", "questionnaire", element.getQuestionnaireElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "QuestionnaireResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "QuestionnaireResponse", "context", element.getContext(), -1);
        }
        if (element.hasAuthoredElement()) {
            this.composeDateTime(t, "QuestionnaireResponse", "authored", element.getAuthoredElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "QuestionnaireResponse", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "QuestionnaireResponse", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseQuestionnaireResponseItemComponent(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "QuestionnaireResponse", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "QuestionnaireResponse", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "QuestionnaireResponse", "text", element.getTextElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(t, "QuestionnaireResponse", "answer", element.getAnswer().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "QuestionnaireResponse", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeRelatedPerson(Turtle.Complex parent, String parentType, String name, RelatedPerson element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "RelatedPerson", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RelatedPerson", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "RelatedPerson", "active", element.getActiveElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "RelatedPerson", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "RelatedPerson", "relationship", element.getRelationship().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "RelatedPerson", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "RelatedPerson", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "RelatedPerson", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "RelatedPerson", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "RelatedPerson", "address", element.getAddress().get(i), i);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "RelatedPerson", "photo", element.getPhoto().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "RelatedPerson", "period", element.getPeriod(), -1);
        }
    }

    protected void composeRequestGroup(Turtle.Complex parent, String parentType, String name, RequestGroup element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "RequestGroup", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RequestGroup", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "RequestGroup", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "RequestGroup", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "RequestGroup", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "RequestGroup", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "RequestGroup", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RequestGroup", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "RequestGroup", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "RequestGroup", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "RequestGroup", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "RequestGroup", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "RequestGroup", "context", element.getContext(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "RequestGroup", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "RequestGroup", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "RequestGroup", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "RequestGroup", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RequestGroup", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeRequestGroupRequestGroupActionComponent(t, "RequestGroup", "action", element.getAction().get(i), i);
        }
    }

    protected void composeRequestGroupRequestGroupActionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasPrefixElement()) {
            this.composeString(t, "RequestGroup", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "RequestGroup", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "RequestGroup", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "RequestGroup", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "RequestGroup", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "RequestGroup", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeRequestGroupRequestGroupActionConditionComponent(t, "RequestGroup", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getRelatedAction().size(); ++i) {
            this.composeRequestGroupRequestGroupActionRelatedActionComponent(t, "RequestGroup", "relatedAction", element.getRelatedAction().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "RequestGroup", "timing", element.getTiming(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeReference(t, "RequestGroup", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RequestGroup", "type", element.getType(), -1);
        }
        if (element.hasGroupingBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
        }
        if (element.hasRequiredBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
        }
        if (element.hasPrecheckBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
        }
        if (element.hasCardinalityBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "RequestGroup", "resource", element.getResource(), -1);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeRequestGroupRequestGroupActionComponent(t, "RequestGroup", "action", element.getAction().get(i), i);
        }
    }

    protected void composeRequestGroupRequestGroupActionConditionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "RequestGroup", "kind", element.getKindElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "RequestGroup", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeString(t, "RequestGroup", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "RequestGroup", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeRequestGroupRequestGroupActionRelatedActionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdElement()) {
            this.composeId(t, "RequestGroup", "actionId", element.getActionIdElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "RequestGroup", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "RequestGroup", "offset", element.getOffset(), -1);
        }
    }

    protected void composeResearchStudy(Turtle.Complex parent, String parentType, String name, ResearchStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ResearchStudy", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchStudy", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getProtocol().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "protocol", element.getProtocol().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchStudy", "status", element.getStatusElement(), -1);
        }
        if (element.hasPrimaryPurposeType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "primaryPurposeType", element.getPrimaryPurposeType(), -1);
        }
        if (element.hasPhase()) {
            this.composeCodeableConcept(t, "ResearchStudy", "phase", element.getPhase(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "focus", element.getFocus().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchStudy", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchStudy", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getKeyword().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "keyword", element.getKeyword().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "location", element.getLocation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getEnrollment().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "enrollment", element.getEnrollment().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ResearchStudy", "period", element.getPeriod(), -1);
        }
        if (element.hasSponsor()) {
            this.composeReference(t, "ResearchStudy", "sponsor", element.getSponsor(), -1);
        }
        if (element.hasPrincipalInvestigator()) {
            this.composeReference(t, "ResearchStudy", "principalInvestigator", element.getPrincipalInvestigator(), -1);
        }
        for (i = 0; i < element.getSite().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "site", element.getSite().get(i), i);
        }
        if (element.hasReasonStopped()) {
            this.composeCodeableConcept(t, "ResearchStudy", "reasonStopped", element.getReasonStopped(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ResearchStudy", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getArm().size(); ++i) {
            this.composeResearchStudyResearchStudyArmComponent(t, "ResearchStudy", "arm", element.getArm().get(i), i);
        }
        for (i = 0; i < element.getObjective().size(); ++i) {
            this.composeResearchStudyResearchStudyObjectiveComponent(t, "ResearchStudy", "objective", element.getObjective().get(i), i);
        }
    }

    protected void composeResearchStudyResearchStudyArmComponent(Turtle.Complex parent, String parentType, String name, ResearchStudy.ResearchStudyArmComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "arm", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchStudy", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeResearchStudyResearchStudyObjectiveComponent(Turtle.Complex parent, String parentType, String name, ResearchStudy.ResearchStudyObjectiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "objective", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchStudy", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "type", element.getType(), -1);
        }
    }

    protected void composeResearchSubject(Turtle.Complex parent, String parentType, String name, ResearchSubject element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ResearchSubject", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchSubject", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchSubject", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ResearchSubject", "period", element.getPeriod(), -1);
        }
        if (element.hasStudy()) {
            this.composeReference(t, "ResearchSubject", "study", element.getStudy(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "ResearchSubject", "individual", element.getIndividual(), -1);
        }
        if (element.hasAssignedArmElement()) {
            this.composeString(t, "ResearchSubject", "assignedArm", element.getAssignedArmElement(), -1);
        }
        if (element.hasActualArmElement()) {
            this.composeString(t, "ResearchSubject", "actualArm", element.getActualArmElement(), -1);
        }
        if (element.hasConsent()) {
            this.composeReference(t, "ResearchSubject", "consent", element.getConsent(), -1);
        }
    }

    protected void composeRiskAssessment(Turtle.Complex parent, String parentType, String name, RiskAssessment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "RiskAssessment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RiskAssessment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasBasedOn()) {
            this.composeReference(t, "RiskAssessment", "basedOn", element.getBasedOn(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "RiskAssessment", "parent", element.getParent(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RiskAssessment", "status", element.getStatusElement(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "RiskAssessment", "method", element.getMethod(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "RiskAssessment", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "RiskAssessment", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "RiskAssessment", "context", element.getContext(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "RiskAssessment", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasCondition()) {
            this.composeReference(t, "RiskAssessment", "condition", element.getCondition(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "RiskAssessment", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "RiskAssessment", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getBasis().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "basis", element.getBasis().get(i), i);
        }
        for (i = 0; i < element.getPrediction().size(); ++i) {
            this.composeRiskAssessmentRiskAssessmentPredictionComponent(t, "RiskAssessment", "prediction", element.getPrediction().get(i), i);
        }
        if (element.hasMitigationElement()) {
            this.composeString(t, "RiskAssessment", "mitigation", element.getMitigationElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RiskAssessment", "note", element.getNote().get(i), i);
        }
    }

    protected void composeRiskAssessmentRiskAssessmentPredictionComponent(Turtle.Complex parent, String parentType, String name, RiskAssessment.RiskAssessmentPredictionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "prediction", name, element, index);
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "RiskAssessment", "outcome", element.getOutcome(), -1);
        }
        if (element.hasProbability()) {
            this.composeType(t, "RiskAssessment", "probability", element.getProbability(), -1);
        }
        if (element.hasQualitativeRisk()) {
            this.composeCodeableConcept(t, "RiskAssessment", "qualitativeRisk", element.getQualitativeRisk(), -1);
        }
        if (element.hasRelativeRiskElement()) {
            this.composeDecimal(t, "RiskAssessment", "relativeRisk", element.getRelativeRiskElement(), -1);
        }
        if (element.hasWhen()) {
            this.composeType(t, "RiskAssessment", "when", element.getWhen(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeString(t, "RiskAssessment", "rationale", element.getRationaleElement(), -1);
        }
    }

    protected void composeSchedule(Turtle.Complex parent, String parentType, String name, Schedule element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Schedule", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Schedule", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Schedule", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeReference(t, "Schedule", "actor", element.getActor().get(i), i);
        }
        if (element.hasPlanningHorizon()) {
            this.composePeriod(t, "Schedule", "planningHorizon", element.getPlanningHorizon(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Schedule", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSearchParameter(Turtle.Complex parent, String parentType, String name, SearchParameter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SearchParameter", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "SearchParameter", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "SearchParameter", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SearchParameter", "name", element.getNameElement(), -1);
        }
        if (element.hasDerivedFromElement()) {
            this.composeCanonical(t, "SearchParameter", "derivedFrom", element.getDerivedFromElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SearchParameter", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "SearchParameter", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "SearchParameter", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "SearchParameter", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "SearchParameter", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "SearchParameter", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "SearchParameter", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "SearchParameter", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "SearchParameter", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "SearchParameter", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getBase().size(); ++i) {
            this.composeCode(t, "SearchParameter", "base", element.getBase().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "SearchParameter", "type", element.getTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "SearchParameter", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasXpathUsageElement()) {
            this.composeEnum(t, "SearchParameter", "xpathUsage", element.getXpathUsageElement(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeCode(t, "SearchParameter", "target", element.getTarget().get(i), i);
        }
        if (element.hasMultipleOrElement()) {
            this.composeBoolean(t, "SearchParameter", "multipleOr", element.getMultipleOrElement(), -1);
        }
        if (element.hasMultipleAndElement()) {
            this.composeBoolean(t, "SearchParameter", "multipleAnd", element.getMultipleAndElement(), -1);
        }
        for (i = 0; i < element.getComparator().size(); ++i) {
            this.composeEnum(t, "SearchParameter", "comparator", element.getComparator().get(i), i);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeEnum(t, "SearchParameter", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getChain().size(); ++i) {
            this.composeString(t, "SearchParameter", "chain", element.getChain().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeSearchParameterSearchParameterComponentComponent(t, "SearchParameter", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeSearchParameterSearchParameterComponentComponent(Turtle.Complex parent, String parentType, String name, SearchParameter.SearchParameterComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "SearchParameter", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeSequence(Turtle.Complex parent, String parentType, String name, Sequence element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Sequence", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Sequence", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Sequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasCoordinateSystemElement()) {
            this.composeInteger(t, "Sequence", "coordinateSystem", element.getCoordinateSystemElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Sequence", "patient", element.getPatient(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Sequence", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Sequence", "device", element.getDevice(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "Sequence", "performer", element.getPerformer(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Sequence", "quantity", element.getQuantity(), -1);
        }
        if (element.hasReferenceSeq()) {
            this.composeSequenceSequenceReferenceSeqComponent(t, "Sequence", "referenceSeq", element.getReferenceSeq(), -1);
        }
        for (i = 0; i < element.getVariant().size(); ++i) {
            this.composeSequenceSequenceVariantComponent(t, "Sequence", "variant", element.getVariant().get(i), i);
        }
        if (element.hasObservedSeqElement()) {
            this.composeString(t, "Sequence", "observedSeq", element.getObservedSeqElement(), -1);
        }
        for (i = 0; i < element.getQuality().size(); ++i) {
            this.composeSequenceSequenceQualityComponent(t, "Sequence", "quality", element.getQuality().get(i), i);
        }
        if (element.hasReadCoverageElement()) {
            this.composeInteger(t, "Sequence", "readCoverage", element.getReadCoverageElement(), -1);
        }
        for (i = 0; i < element.getRepository().size(); ++i) {
            this.composeSequenceSequenceRepositoryComponent(t, "Sequence", "repository", element.getRepository().get(i), i);
        }
        for (i = 0; i < element.getPointer().size(); ++i) {
            this.composeReference(t, "Sequence", "pointer", element.getPointer().get(i), i);
        }
        for (i = 0; i < element.getStructureVariant().size(); ++i) {
            this.composeSequenceSequenceStructureVariantComponent(t, "Sequence", "structureVariant", element.getStructureVariant().get(i), i);
        }
    }

    protected void composeSequenceSequenceReferenceSeqComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceReferenceSeqComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "referenceSeq", name, element, index);
        if (element.hasChromosome()) {
            this.composeCodeableConcept(t, "Sequence", "chromosome", element.getChromosome(), -1);
        }
        if (element.hasGenomeBuildElement()) {
            this.composeString(t, "Sequence", "genomeBuild", element.getGenomeBuildElement(), -1);
        }
        if (element.hasOrientationElement()) {
            this.composeEnum(t, "Sequence", "orientation", element.getOrientationElement(), -1);
        }
        if (element.hasReferenceSeqId()) {
            this.composeCodeableConcept(t, "Sequence", "referenceSeqId", element.getReferenceSeqId(), -1);
        }
        if (element.hasReferenceSeqPointer()) {
            this.composeReference(t, "Sequence", "referenceSeqPointer", element.getReferenceSeqPointer(), -1);
        }
        if (element.hasReferenceSeqStringElement()) {
            this.composeString(t, "Sequence", "referenceSeqString", element.getReferenceSeqStringElement(), -1);
        }
        if (element.hasStrandElement()) {
            this.composeEnum(t, "Sequence", "strand", element.getStrandElement(), -1);
        }
        if (element.hasWindowStartElement()) {
            this.composeInteger(t, "Sequence", "windowStart", element.getWindowStartElement(), -1);
        }
        if (element.hasWindowEndElement()) {
            this.composeInteger(t, "Sequence", "windowEnd", element.getWindowEndElement(), -1);
        }
    }

    protected void composeSequenceSequenceVariantComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceVariantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "variant", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
        if (element.hasObservedAlleleElement()) {
            this.composeString(t, "Sequence", "observedAllele", element.getObservedAlleleElement(), -1);
        }
        if (element.hasReferenceAlleleElement()) {
            this.composeString(t, "Sequence", "referenceAllele", element.getReferenceAlleleElement(), -1);
        }
        if (element.hasCigarElement()) {
            this.composeString(t, "Sequence", "cigar", element.getCigarElement(), -1);
        }
        if (element.hasVariantPointer()) {
            this.composeReference(t, "Sequence", "variantPointer", element.getVariantPointer(), -1);
        }
    }

    protected void composeSequenceSequenceQualityComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceQualityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "quality", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Sequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasStandardSequence()) {
            this.composeCodeableConcept(t, "Sequence", "standardSequence", element.getStandardSequence(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
        if (element.hasScore()) {
            this.composeQuantity(t, "Sequence", "score", element.getScore(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Sequence", "method", element.getMethod(), -1);
        }
        if (element.hasTruthTPElement()) {
            this.composeDecimal(t, "Sequence", "truthTP", element.getTruthTPElement(), -1);
        }
        if (element.hasQueryTPElement()) {
            this.composeDecimal(t, "Sequence", "queryTP", element.getQueryTPElement(), -1);
        }
        if (element.hasTruthFNElement()) {
            this.composeDecimal(t, "Sequence", "truthFN", element.getTruthFNElement(), -1);
        }
        if (element.hasQueryFPElement()) {
            this.composeDecimal(t, "Sequence", "queryFP", element.getQueryFPElement(), -1);
        }
        if (element.hasGtFPElement()) {
            this.composeDecimal(t, "Sequence", "gtFP", element.getGtFPElement(), -1);
        }
        if (element.hasPrecisionElement()) {
            this.composeDecimal(t, "Sequence", "precision", element.getPrecisionElement(), -1);
        }
        if (element.hasRecallElement()) {
            this.composeDecimal(t, "Sequence", "recall", element.getRecallElement(), -1);
        }
        if (element.hasFScoreElement()) {
            this.composeDecimal(t, "Sequence", "fScore", element.getFScoreElement(), -1);
        }
        if (element.hasRoc()) {
            this.composeSequenceSequenceQualityRocComponent(t, "Sequence", "roc", element.getRoc(), -1);
        }
    }

    protected void composeSequenceSequenceQualityRocComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceQualityRocComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "roc", name, element, index);
        for (i = 0; i < element.getScore().size(); ++i) {
            this.composeInteger(t, "Sequence", "score", element.getScore().get(i), i);
        }
        for (i = 0; i < element.getNumTP().size(); ++i) {
            this.composeInteger(t, "Sequence", "numTP", element.getNumTP().get(i), i);
        }
        for (i = 0; i < element.getNumFP().size(); ++i) {
            this.composeInteger(t, "Sequence", "numFP", element.getNumFP().get(i), i);
        }
        for (i = 0; i < element.getNumFN().size(); ++i) {
            this.composeInteger(t, "Sequence", "numFN", element.getNumFN().get(i), i);
        }
        for (i = 0; i < element.getPrecision().size(); ++i) {
            this.composeDecimal(t, "Sequence", "precision", element.getPrecision().get(i), i);
        }
        for (i = 0; i < element.getSensitivity().size(); ++i) {
            this.composeDecimal(t, "Sequence", "sensitivity", element.getSensitivity().get(i), i);
        }
        for (i = 0; i < element.getFMeasure().size(); ++i) {
            this.composeDecimal(t, "Sequence", "fMeasure", element.getFMeasure().get(i), i);
        }
    }

    protected void composeSequenceSequenceRepositoryComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceRepositoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "repository", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Sequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Sequence", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Sequence", "name", element.getNameElement(), -1);
        }
        if (element.hasDatasetIdElement()) {
            this.composeString(t, "Sequence", "datasetId", element.getDatasetIdElement(), -1);
        }
        if (element.hasVariantsetIdElement()) {
            this.composeString(t, "Sequence", "variantsetId", element.getVariantsetIdElement(), -1);
        }
        if (element.hasReadsetIdElement()) {
            this.composeString(t, "Sequence", "readsetId", element.getReadsetIdElement(), -1);
        }
    }

    protected void composeSequenceSequenceStructureVariantComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceStructureVariantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "structureVariant", name, element, index);
        if (element.hasPrecisionElement()) {
            this.composeString(t, "Sequence", "precision", element.getPrecisionElement(), -1);
        }
        if (element.hasReportedaCGHRatioElement()) {
            this.composeDecimal(t, "Sequence", "reportedaCGHRatio", element.getReportedaCGHRatioElement(), -1);
        }
        if (element.hasLengthElement()) {
            this.composeInteger(t, "Sequence", "length", element.getLengthElement(), -1);
        }
        if (element.hasOuter()) {
            this.composeSequenceSequenceStructureVariantOuterComponent(t, "Sequence", "outer", element.getOuter(), -1);
        }
        if (element.hasInner()) {
            this.composeSequenceSequenceStructureVariantInnerComponent(t, "Sequence", "inner", element.getInner(), -1);
        }
    }

    protected void composeSequenceSequenceStructureVariantOuterComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceStructureVariantOuterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "outer", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
    }

    protected void composeSequenceSequenceStructureVariantInnerComponent(Turtle.Complex parent, String parentType, String name, Sequence.SequenceStructureVariantInnerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "inner", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
    }

    protected void composeServiceRequest(Turtle.Complex parent, String parentType, String name, ServiceRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ServiceRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ServiceRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "ServiceRequest", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasRequisition()) {
            this.composeIdentifier(t, "ServiceRequest", "requisition", element.getRequisition(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ServiceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "ServiceRequest", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ServiceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ServiceRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ServiceRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getOrderDetail().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "orderDetail", element.getOrderDetail().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ServiceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ServiceRequest", "context", element.getContext(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ServiceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "ServiceRequest", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "ServiceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "ServiceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "ServiceRequest", "performerType", element.getPerformerType(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "bodySite", element.getBodySite().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ServiceRequest", "note", element.getNote().get(i), i);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "ServiceRequest", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
    }

    protected void composeSlot(Turtle.Complex parent, String parentType, String name, Slot element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Slot", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Slot", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Slot", "appointmentType", element.getAppointmentType(), -1);
        }
        if (element.hasSchedule()) {
            this.composeReference(t, "Slot", "schedule", element.getSchedule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Slot", "status", element.getStatusElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Slot", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Slot", "end", element.getEndElement(), -1);
        }
        if (element.hasOverbookedElement()) {
            this.composeBoolean(t, "Slot", "overbooked", element.getOverbookedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Slot", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSpecimen(Turtle.Complex parent, String parentType, String name, Specimen element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Specimen", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAccessionIdentifier()) {
            this.composeIdentifier(t, "Specimen", "accessionIdentifier", element.getAccessionIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Specimen", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Specimen", "subject", element.getSubject(), -1);
        }
        if (element.hasReceivedTimeElement()) {
            this.composeDateTime(t, "Specimen", "receivedTime", element.getReceivedTimeElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeReference(t, "Specimen", "parent", element.getParent().get(i), i);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "Specimen", "request", element.getRequest().get(i), i);
        }
        if (element.hasCollection()) {
            this.composeSpecimenSpecimenCollectionComponent(t, "Specimen", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getProcessing().size(); ++i) {
            this.composeSpecimenSpecimenProcessingComponent(t, "Specimen", "processing", element.getProcessing().get(i), i);
        }
        for (i = 0; i < element.getContainer().size(); ++i) {
            this.composeSpecimenSpecimenContainerComponent(t, "Specimen", "container", element.getContainer().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Specimen", "note", element.getNote().get(i), i);
        }
    }

    protected void composeSpecimenSpecimenCollectionComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "Specimen", "collector", element.getCollector(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "Specimen", "collected", element.getCollected(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Specimen", "quantity", element.getQuantity(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Specimen", "method", element.getMethod(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Specimen", "bodySite", element.getBodySite(), -1);
        }
    }

    protected void composeSpecimenSpecimenProcessingComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenProcessingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "processing", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Specimen", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "Specimen", "procedure", element.getProcedure(), -1);
        }
        for (int i = 0; i < element.getAdditive().size(); ++i) {
            this.composeReference(t, "Specimen", "additive", element.getAdditive().get(i), i);
        }
        if (element.hasTime()) {
            this.composeType(t, "Specimen", "time", element.getTime(), -1);
        }
    }

    protected void composeSpecimenSpecimenContainerComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenContainerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "container", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Specimen", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasCapacity()) {
            this.composeQuantity(t, "Specimen", "capacity", element.getCapacity(), -1);
        }
        if (element.hasSpecimenQuantity()) {
            this.composeQuantity(t, "Specimen", "specimenQuantity", element.getSpecimenQuantity(), -1);
        }
        if (element.hasAdditive()) {
            this.composeType(t, "Specimen", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeSpecimenDefinition(Turtle.Complex parent, String parentType, String name, SpecimenDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SpecimenDefinition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SpecimenDefinition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeCollected()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "typeCollected", element.getTypeCollected(), -1);
        }
        if (element.hasPatientPreparationElement()) {
            this.composeString(t, "SpecimenDefinition", "patientPreparation", element.getPatientPreparationElement(), -1);
        }
        if (element.hasTimeAspectElement()) {
            this.composeString(t, "SpecimenDefinition", "timeAspect", element.getTimeAspectElement(), -1);
        }
        for (i = 0; i < element.getCollection().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "collection", element.getCollection().get(i), i);
        }
        for (i = 0; i < element.getSpecimenToLab().size(); ++i) {
            this.composeSpecimenDefinitionSpecimenDefinitionSpecimenToLabComponent(t, "SpecimenDefinition", "specimenToLab", element.getSpecimenToLab().get(i), i);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionSpecimenToLabComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionSpecimenToLabComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "specimenToLab", name, element, index);
        if (element.hasIsDerivedElement()) {
            this.composeBoolean(t, "SpecimenDefinition", "isDerived", element.getIsDerivedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "type", element.getType(), -1);
        }
        if (element.hasPreferenceElement()) {
            this.composeEnum(t, "SpecimenDefinition", "preference", element.getPreferenceElement(), -1);
        }
        if (element.hasContainerMaterial()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "containerMaterial", element.getContainerMaterial(), -1);
        }
        if (element.hasContainerType()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "containerType", element.getContainerType(), -1);
        }
        if (element.hasContainerCap()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "containerCap", element.getContainerCap(), -1);
        }
        if (element.hasContainerDescriptionElement()) {
            this.composeString(t, "SpecimenDefinition", "containerDescription", element.getContainerDescriptionElement(), -1);
        }
        if (element.hasContainerCapacity()) {
            this.composeQuantity(t, "SpecimenDefinition", "containerCapacity", element.getContainerCapacity(), -1);
        }
        if (element.hasContainerMinimumVolume()) {
            this.composeQuantity(t, "SpecimenDefinition", "containerMinimumVolume", element.getContainerMinimumVolume(), -1);
        }
        for (i = 0; i < element.getContainerAdditive().size(); ++i) {
            this.composeSpecimenDefinitionSpecimenDefinitionSpecimenToLabContainerAdditiveComponent(t, "SpecimenDefinition", "containerAdditive", element.getContainerAdditive().get(i), i);
        }
        if (element.hasContainerPreparationElement()) {
            this.composeString(t, "SpecimenDefinition", "containerPreparation", element.getContainerPreparationElement(), -1);
        }
        if (element.hasRequirementElement()) {
            this.composeString(t, "SpecimenDefinition", "requirement", element.getRequirementElement(), -1);
        }
        if (element.hasRetentionTime()) {
            this.composeDuration(t, "SpecimenDefinition", "retentionTime", element.getRetentionTime(), -1);
        }
        for (i = 0; i < element.getRejectionCriterion().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "rejectionCriterion", element.getRejectionCriterion().get(i), i);
        }
        for (i = 0; i < element.getHandling().size(); ++i) {
            this.composeSpecimenDefinitionSpecimenDefinitionSpecimenToLabHandlingComponent(t, "SpecimenDefinition", "handling", element.getHandling().get(i), i);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionSpecimenToLabContainerAdditiveComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionSpecimenToLabContainerAdditiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "containerAdditive", name, element, index);
        if (element.hasAdditive()) {
            this.composeType(t, "SpecimenDefinition", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionSpecimenToLabHandlingComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionSpecimenToLabHandlingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "handling", name, element, index);
        if (element.hasConditionSet()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "conditionSet", element.getConditionSet(), -1);
        }
        if (element.hasTempRange()) {
            this.composeRange(t, "SpecimenDefinition", "tempRange", element.getTempRange(), -1);
        }
        if (element.hasMaxDuration()) {
            this.composeDuration(t, "SpecimenDefinition", "maxDuration", element.getMaxDuration(), -1);
        }
        if (element.hasLightExposureElement()) {
            this.composeString(t, "SpecimenDefinition", "lightExposure", element.getLightExposureElement(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "SpecimenDefinition", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeStructureDefinition(Turtle.Complex parent, String parentType, String name, StructureDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "StructureDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "StructureDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "StructureDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "StructureDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "StructureDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "StructureDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "StructureDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "StructureDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getKeyword().size(); ++i) {
            this.composeCoding(t, "StructureDefinition", "keyword", element.getKeyword().get(i), i);
        }
        if (element.hasFhirVersionElement()) {
            this.composeId(t, "StructureDefinition", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeStructureDefinitionStructureDefinitionMappingComponent(t, "StructureDefinition", "mapping", element.getMapping().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "StructureDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasAbstractElement()) {
            this.composeBoolean(t, "StructureDefinition", "abstract", element.getAbstractElement(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeStructureDefinitionStructureDefinitionContextComponent(t, "StructureDefinition", "context", element.getContext().get(i), i);
        }
        for (i = 0; i < element.getContextInvariant().size(); ++i) {
            this.composeString(t, "StructureDefinition", "contextInvariant", element.getContextInvariant().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "StructureDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasBaseDefinitionElement()) {
            this.composeCanonical(t, "StructureDefinition", "baseDefinition", element.getBaseDefinitionElement(), -1);
        }
        if (element.hasDerivationElement()) {
            this.composeEnum(t, "StructureDefinition", "derivation", element.getDerivationElement(), -1);
        }
        if (element.hasSnapshot()) {
            this.composeStructureDefinitionStructureDefinitionSnapshotComponent(t, "StructureDefinition", "snapshot", element.getSnapshot(), -1);
        }
        if (element.hasDifferential()) {
            this.composeStructureDefinitionStructureDefinitionDifferentialComponent(t, "StructureDefinition", "differential", element.getDifferential(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "StructureDefinition", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "StructureDefinition", "uri", element.getUriElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "StructureDefinition", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionContextComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "StructureDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "StructureDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionSnapshotComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionSnapshotComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "snapshot", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinition", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionDifferentialComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionDifferentialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "differential", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinition", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureMap(Turtle.Complex parent, String parentType, String name, StructureMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "StructureMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureMap", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "StructureMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "StructureMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "StructureMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "StructureMap", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "StructureMap", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "StructureMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "StructureMap", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getStructure().size(); ++i) {
            this.composeStructureMapStructureMapStructureComponent(t, "StructureMap", "structure", element.getStructure().get(i), i);
        }
        for (i = 0; i < element.getImport().size(); ++i) {
            this.composeCanonical(t, "StructureMap", "import", element.getImport().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeStructureMapStructureMapGroupComponent(t, "StructureMap", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapStructureComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapStructureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "structure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeCanonical(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "StructureMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasAliasElement()) {
            this.composeString(t, "StructureMap", "alias", element.getAliasElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasExtendsElement()) {
            this.composeId(t, "StructureMap", "extends", element.getExtendsElement(), -1);
        }
        if (element.hasTypeModeElement()) {
            this.composeEnum(t, "StructureMap", "typeMode", element.getTypeModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeStructureMapStructureMapGroupInputComponent(t, "StructureMap", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleComponent(t, "StructureMap", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapGroupInputComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupInputComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "input", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "StructureMap", "type", element.getTypeElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "StructureMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getSource().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleSourceComponent(t, "StructureMap", "source", element.getSource().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleTargetComponent(t, "StructureMap", "target", element.getTarget().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleComponent(t, "StructureMap", "rule", element.getRule().get(i), i);
        }
        for (i = 0; i < element.getDependent().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleDependentComponent(t, "StructureMap", "dependent", element.getDependent().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleSourceComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasContextElement()) {
            this.composeId(t, "StructureMap", "context", element.getContextElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "StructureMap", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "StructureMap", "max", element.getMaxElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "StructureMap", "type", element.getTypeElement(), -1);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "StructureMap", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasElementElement()) {
            this.composeString(t, "StructureMap", "element", element.getElementElement(), -1);
        }
        if (element.hasListModeElement()) {
            this.composeEnum(t, "StructureMap", "listMode", element.getListModeElement(), -1);
        }
        if (element.hasVariableElement()) {
            this.composeId(t, "StructureMap", "variable", element.getVariableElement(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "StructureMap", "condition", element.getConditionElement(), -1);
        }
        if (element.hasCheckElement()) {
            this.composeString(t, "StructureMap", "check", element.getCheckElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleTargetComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasContextElement()) {
            this.composeId(t, "StructureMap", "context", element.getContextElement(), -1);
        }
        if (element.hasContextTypeElement()) {
            this.composeEnum(t, "StructureMap", "contextType", element.getContextTypeElement(), -1);
        }
        if (element.hasElementElement()) {
            this.composeString(t, "StructureMap", "element", element.getElementElement(), -1);
        }
        if (element.hasVariableElement()) {
            this.composeId(t, "StructureMap", "variable", element.getVariableElement(), -1);
        }
        for (i = 0; i < element.getListMode().size(); ++i) {
            this.composeEnum(t, "StructureMap", "listMode", element.getListMode().get(i), i);
        }
        if (element.hasListRuleIdElement()) {
            this.composeId(t, "StructureMap", "listRuleId", element.getListRuleIdElement(), -1);
        }
        if (element.hasTransformElement()) {
            this.composeEnum(t, "StructureMap", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleTargetParameterComponent(t, "StructureMap", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleTargetParameterComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "StructureMap", "value", element.getValue(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleDependentComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleDependentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dependent", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getVariable().size(); ++i) {
            this.composeString(t, "StructureMap", "variable", element.getVariable().get(i), i);
        }
    }

    protected void composeSubscription(Turtle.Complex parent, String parentType, String name, Subscription element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Subscription", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Subscription", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Subscription", "contact", element.getContact().get(i), i);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Subscription", "end", element.getEndElement(), -1);
        }
        if (element.hasReasonElement()) {
            this.composeString(t, "Subscription", "reason", element.getReasonElement(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Subscription", "criteria", element.getCriteriaElement(), -1);
        }
        if (element.hasErrorElement()) {
            this.composeString(t, "Subscription", "error", element.getErrorElement(), -1);
        }
        if (element.hasChannel()) {
            this.composeSubscriptionSubscriptionChannelComponent(t, "Subscription", "channel", element.getChannel(), -1);
        }
        for (i = 0; i < element.getTag().size(); ++i) {
            this.composeCoding(t, "Subscription", "tag", element.getTag().get(i), i);
        }
    }

    protected void composeSubscriptionSubscriptionChannelComponent(Turtle.Complex parent, String parentType, String name, Subscription.SubscriptionChannelComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "channel", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Subscription", "type", element.getTypeElement(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "Subscription", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasPayloadElement()) {
            this.composeString(t, "Subscription", "payload", element.getPayloadElement(), -1);
        }
        for (int i = 0; i < element.getHeader().size(); ++i) {
            this.composeString(t, "Subscription", "header", element.getHeader().get(i), i);
        }
    }

    protected void composeSubstance(Turtle.Complex parent, String parentType, String name, Substance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Substance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Substance", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Substance", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Substance", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Substance", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Substance", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeSubstanceSubstanceInstanceComponent(t, "Substance", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeSubstanceSubstanceIngredientComponent(t, "Substance", "ingredient", element.getIngredient().get(i), i);
        }
    }

    protected void composeSubstanceSubstanceInstanceComponent(Turtle.Complex parent, String parentType, String name, Substance.SubstanceInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Substance", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTime(t, "Substance", "expiry", element.getExpiryElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Substance", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeSubstanceSubstanceIngredientComponent(Turtle.Complex parent, String parentType, String name, Substance.SubstanceIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasQuantity()) {
            this.composeRatio(t, "Substance", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSubstance()) {
            this.composeType(t, "Substance", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeSubstancePolymer(Turtle.Complex parent, String parentType, String name, SubstancePolymer element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SubstancePolymer", name, element, index);
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "class", element.getClass_(), -1);
        }
        if (element.hasGeometry()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "geometry", element.getGeometry(), -1);
        }
        for (i = 0; i < element.getCopolymerConnectivity().size(); ++i) {
            this.composeCodeableConcept(t, "SubstancePolymer", "copolymerConnectivity", element.getCopolymerConnectivity().get(i), i);
        }
        for (i = 0; i < element.getModification().size(); ++i) {
            this.composeString(t, "SubstancePolymer", "modification", element.getModification().get(i), i);
        }
        for (i = 0; i < element.getMonomerSet().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerMonomerSetComponent(t, "SubstancePolymer", "monomerSet", element.getMonomerSet().get(i), i);
        }
        for (i = 0; i < element.getRepeat().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatComponent(t, "SubstancePolymer", "repeat", element.getRepeat().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerMonomerSetComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerMonomerSetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "monomerSet", name, element, index);
        if (element.hasRatioType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "ratioType", element.getRatioType(), -1);
        }
        for (int i = 0; i < element.getStartingMaterial().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerMonomerSetStartingMaterialComponent(t, "SubstancePolymer", "startingMaterial", element.getStartingMaterial().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerMonomerSetStartingMaterialComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerMonomerSetStartingMaterialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "startingMaterial", name, element, index);
        if (element.hasMaterial()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "material", element.getMaterial(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "type", element.getType(), -1);
        }
        if (element.hasIsDefiningElement()) {
            this.composeBoolean(t, "SubstancePolymer", "isDefining", element.getIsDefiningElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstancePolymer", "amount", element.getAmount(), -1);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "repeat", name, element, index);
        if (element.hasNumberOfUnitsElement()) {
            this.composeInteger(t, "SubstancePolymer", "numberOfUnits", element.getNumberOfUnitsElement(), -1);
        }
        if (element.hasAverageMolecularFormulaElement()) {
            this.composeString(t, "SubstancePolymer", "averageMolecularFormula", element.getAverageMolecularFormulaElement(), -1);
        }
        if (element.hasRepeatUnitAmountType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "repeatUnitAmountType", element.getRepeatUnitAmountType(), -1);
        }
        for (int i = 0; i < element.getRepeatUnit().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatRepeatUnitComponent(t, "SubstancePolymer", "repeatUnit", element.getRepeatUnit().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatRepeatUnitComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatRepeatUnitComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "repeatUnit", name, element, index);
        if (element.hasOrientationOfPolymerisation()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "orientationOfPolymerisation", element.getOrientationOfPolymerisation(), -1);
        }
        if (element.hasRepeatUnitElement()) {
            this.composeString(t, "SubstancePolymer", "repeatUnit", element.getRepeatUnitElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstancePolymer", "amount", element.getAmount(), -1);
        }
        for (i = 0; i < element.getDegreeOfPolymerisation().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent(t, "SubstancePolymer", "degreeOfPolymerisation", element.getDegreeOfPolymerisation().get(i), i);
        }
        for (i = 0; i < element.getStructuralRepresentation().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent(t, "SubstancePolymer", "structuralRepresentation", element.getStructuralRepresentation().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "degreeOfPolymerisation", name, element, index);
        if (element.hasDegree()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "degree", element.getDegree(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstancePolymer", "amount", element.getAmount(), -1);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "structuralRepresentation", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "type", element.getType(), -1);
        }
        if (element.hasRepresentationElement()) {
            this.composeString(t, "SubstancePolymer", "representation", element.getRepresentationElement(), -1);
        }
        if (element.hasAttachment()) {
            this.composeAttachment(t, "SubstancePolymer", "attachment", element.getAttachment(), -1);
        }
    }

    protected void composeSubstanceReferenceInformation(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SubstanceReferenceInformation", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "SubstanceReferenceInformation", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getGene().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationGeneComponent(t, "SubstanceReferenceInformation", "gene", element.getGene().get(i), i);
        }
        for (i = 0; i < element.getGene().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationGeneComponent(t, "SubstanceReferenceInformation", "geneElement", element.getGene().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationClassificationComponent(t, "SubstanceReferenceInformation", "classification", element.getClassification().get(i), i);
        }
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationRelationshipComponent(t, "SubstanceReferenceInformation", "relationship", element.getRelationship().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationTargetComponent(t, "SubstanceReferenceInformation", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationGeneComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationGeneComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "gene", name, element, index);
        if (element.hasGeneSequenceOrigin()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "geneSequenceOrigin", element.getGeneSequenceOrigin(), -1);
        }
        if (element.hasGene()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "gene", element.getGene(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationGeneElementComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationGeneElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "geneElement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "type", element.getType(), -1);
        }
        if (element.hasElement()) {
            this.composeIdentifier(t, "SubstanceReferenceInformation", "element", element.getElement(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationClassificationComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationClassificationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasDomain()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "domain", element.getDomain(), -1);
        }
        if (element.hasClassification()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "classification", element.getClassification(), -1);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "subtype", element.getSubtype().get(i), i);
        }
        for (i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationRelationshipComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationRelationshipComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "relationship", name, element, index);
        if (element.hasSubstance()) {
            this.composeType(t, "SubstanceReferenceInformation", "substance", element.getSubstance(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "relationship", element.getRelationship(), -1);
        }
        if (element.hasInteraction()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "interaction", element.getInteraction(), -1);
        }
        if (element.hasIsDefiningElement()) {
            this.composeBoolean(t, "SubstanceReferenceInformation", "isDefining", element.getIsDefiningElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceReferenceInformation", "amount", element.getAmount(), -1);
        }
        if (element.hasAmountType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "amountType", element.getAmountType(), -1);
        }
        if (element.hasAmountTextElement()) {
            this.composeString(t, "SubstanceReferenceInformation", "amountText", element.getAmountTextElement(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationTargetComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasTarget()) {
            this.composeIdentifier(t, "SubstanceReferenceInformation", "target", element.getTarget(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "type", element.getType(), -1);
        }
        if (element.hasInteraction()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "interaction", element.getInteraction(), -1);
        }
        if (element.hasOrganism()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "organism", element.getOrganism(), -1);
        }
        if (element.hasOrganismType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "organismType", element.getOrganismType(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceReferenceInformation", "amount", element.getAmount(), -1);
        }
        if (element.hasAmountType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "amountType", element.getAmountType(), -1);
        }
    }

    protected void composeSubstanceSpecification(Turtle.Complex parent, String parentType, String name, SubstanceSpecification element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SubstanceSpecification", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "SubstanceSpecification", "comment", element.getCommentElement(), -1);
        }
        if (element.hasStoichiometricElement()) {
            this.composeBoolean(t, "SubstanceSpecification", "stoichiometric", element.getStoichiometricElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceSpecification", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getReferenceSource().size(); ++i) {
            this.composeString(t, "SubstanceSpecification", "referenceSource", element.getReferenceSource().get(i), i);
        }
        for (i = 0; i < element.getMoiety().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationMoietyComponent(t, "SubstanceSpecification", "moiety", element.getMoiety().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationPropertyComponent(t, "SubstanceSpecification", "property", element.getProperty().get(i), i);
        }
        if (element.hasReferenceInformation()) {
            this.composeReference(t, "SubstanceSpecification", "referenceInformation", element.getReferenceInformation(), -1);
        }
        if (element.hasStructure()) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureComponent(t, "SubstanceSpecification", "structure", element.getStructure(), -1);
        }
        for (i = 0; i < element.getSubstanceCode().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationSubstanceCodeComponent(t, "SubstanceSpecification", "substanceCode", element.getSubstanceCode().get(i), i);
        }
        for (i = 0; i < element.getSubstanceName().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationSubstanceNameComponent(t, "SubstanceSpecification", "substanceName", element.getSubstanceName().get(i), i);
        }
        for (i = 0; i < element.getMolecularWeight().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeMolecularWeightComponent(t, "SubstanceSpecification", "molecularWeight", element.getMolecularWeight().get(i), i);
        }
        if (element.hasPolymer()) {
            this.composeReference(t, "SubstanceSpecification", "polymer", element.getPolymer(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationMoietyComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationMoietyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "moiety", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "role", element.getRole(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceSpecification", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SubstanceSpecification", "name", element.getNameElement(), -1);
        }
        if (element.hasStereochemistry()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "stereochemistry", element.getStereochemistry(), -1);
        }
        if (element.hasOpticalActivity()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "opticalActivity", element.getOpticalActivity(), -1);
        }
        if (element.hasMolecularFormulaElement()) {
            this.composeString(t, "SubstanceSpecification", "molecularFormula", element.getMolecularFormulaElement(), -1);
        }
        if (element.hasAmountElement()) {
            this.composeString(t, "SubstanceSpecification", "amount", element.getAmountElement(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationPropertyComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "type", element.getType(), -1);
        }
        if (element.hasName()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "name", element.getName(), -1);
        }
        if (element.hasParametersElement()) {
            this.composeString(t, "SubstanceSpecification", "parameters", element.getParametersElement(), -1);
        }
        if (element.hasSubstanceId()) {
            this.composeIdentifier(t, "SubstanceSpecification", "substanceId", element.getSubstanceId(), -1);
        }
        if (element.hasSubstanceNameElement()) {
            this.composeString(t, "SubstanceSpecification", "substanceName", element.getSubstanceNameElement(), -1);
        }
        if (element.hasAmountElement()) {
            this.composeString(t, "SubstanceSpecification", "amount", element.getAmountElement(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationStructureComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationStructureComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "structure", name, element, index);
        if (element.hasStereochemistry()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "stereochemistry", element.getStereochemistry(), -1);
        }
        if (element.hasOpticalActivity()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "opticalActivity", element.getOpticalActivity(), -1);
        }
        if (element.hasMolecularFormulaElement()) {
            this.composeString(t, "SubstanceSpecification", "molecularFormula", element.getMolecularFormulaElement(), -1);
        }
        if (element.hasMolecularFormulaByMoietyElement()) {
            this.composeString(t, "SubstanceSpecification", "molecularFormulaByMoiety", element.getMolecularFormulaByMoietyElement(), -1);
        }
        for (i = 0; i < element.getIsotope().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeComponent(t, "SubstanceSpecification", "isotope", element.getIsotope().get(i), i);
        }
        if (element.hasMolecularWeight()) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeMolecularWeightComponent(t, "SubstanceSpecification", "molecularWeight", element.getMolecularWeight(), -1);
        }
        for (i = 0; i < element.getReferenceSource().size(); ++i) {
            this.composeReference(t, "SubstanceSpecification", "referenceSource", element.getReferenceSource().get(i), i);
        }
        for (i = 0; i < element.getStructuralRepresentation().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureStructuralRepresentationComponent(t, "SubstanceSpecification", "structuralRepresentation", element.getStructuralRepresentation().get(i), i);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationStructureIsotopeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "isotope", name, element, index);
        if (element.hasNuclideId()) {
            this.composeIdentifier(t, "SubstanceSpecification", "nuclideId", element.getNuclideId(), -1);
        }
        if (element.hasNuclideName()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "nuclideName", element.getNuclideName(), -1);
        }
        if (element.hasSubstitutionType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "substitutionType", element.getSubstitutionType(), -1);
        }
        if (element.hasNuclideHalfLife()) {
            this.composeQuantity(t, "SubstanceSpecification", "nuclideHalfLife", element.getNuclideHalfLife(), -1);
        }
        if (element.hasAmountElement()) {
            this.composeString(t, "SubstanceSpecification", "amount", element.getAmountElement(), -1);
        }
        if (element.hasMolecularWeight()) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeMolecularWeightComponent(t, "SubstanceSpecification", "molecularWeight", element.getMolecularWeight(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeMolecularWeightComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationStructureIsotopeMolecularWeightComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "molecularWeight", name, element, index);
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "method", element.getMethod(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "type", element.getType(), -1);
        }
        if (element.hasAmountElement()) {
            this.composeString(t, "SubstanceSpecification", "amount", element.getAmountElement(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationStructureStructuralRepresentationComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationStructureStructuralRepresentationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "structuralRepresentation", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "type", element.getType(), -1);
        }
        if (element.hasRepresentationElement()) {
            this.composeString(t, "SubstanceSpecification", "representation", element.getRepresentationElement(), -1);
        }
        if (element.hasAttachment()) {
            this.composeAttachment(t, "SubstanceSpecification", "attachment", element.getAttachment(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationSubstanceCodeComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationSubstanceCodeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "substanceCode", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "code", element.getCode(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "SubstanceSpecification", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "SubstanceSpecification", "comment", element.getCommentElement(), -1);
        }
        for (int i = 0; i < element.getReferenceSource().size(); ++i) {
            this.composeString(t, "SubstanceSpecification", "referenceSource", element.getReferenceSource().get(i), i);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationSubstanceNameComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationSubstanceNameComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "substanceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "SubstanceSpecification", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getLanguage().size(); ++i) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "language", element.getLanguage().get(i), i);
        }
        for (i = 0; i < element.getDomain().size(); ++i) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "domain", element.getDomain().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        for (i = 0; i < element.getOfficialName().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationSubstanceNameOfficialNameComponent(t, "SubstanceSpecification", "officialName", element.getOfficialName().get(i), i);
        }
        for (i = 0; i < element.getReferenceSource().size(); ++i) {
            this.composeString(t, "SubstanceSpecification", "referenceSource", element.getReferenceSource().get(i), i);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationSubstanceNameOfficialNameComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationSubstanceNameOfficialNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "officialName", name, element, index);
        if (element.hasAuthority()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "authority", element.getAuthority(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "status", element.getStatus(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "SubstanceSpecification", "date", element.getDateElement(), -1);
        }
    }

    protected void composeSupplyDelivery(Turtle.Complex parent, String parentType, String name, SupplyDelivery element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SupplyDelivery", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "SupplyDelivery", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "SupplyDelivery", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "SupplyDelivery", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SupplyDelivery", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "SupplyDelivery", "patient", element.getPatient(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SupplyDelivery", "type", element.getType(), -1);
        }
        if (element.hasSuppliedItem()) {
            this.composeSupplyDeliverySupplyDeliverySuppliedItemComponent(t, "SupplyDelivery", "suppliedItem", element.getSuppliedItem(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "SupplyDelivery", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasSupplier()) {
            this.composeReference(t, "SupplyDelivery", "supplier", element.getSupplier(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "SupplyDelivery", "destination", element.getDestination(), -1);
        }
        for (i = 0; i < element.getReceiver().size(); ++i) {
            this.composeReference(t, "SupplyDelivery", "receiver", element.getReceiver().get(i), i);
        }
    }

    protected void composeSupplyDeliverySupplyDeliverySuppliedItemComponent(Turtle.Complex parent, String parentType, String name, SupplyDelivery.SupplyDeliverySuppliedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "suppliedItem", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SupplyDelivery", "quantity", element.getQuantity(), -1);
        }
        if (element.hasItem()) {
            this.composeType(t, "SupplyDelivery", "item", element.getItem(), -1);
        }
    }

    protected void composeSupplyRequest(Turtle.Complex parent, String parentType, String name, SupplyRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "SupplyRequest", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SupplyRequest", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SupplyRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SupplyRequest", "category", element.getCategory(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "SupplyRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasItem()) {
            this.composeType(t, "SupplyRequest", "item", element.getItem(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SupplyRequest", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeSupplyRequestSupplyRequestParameterComponent(t, "SupplyRequest", "parameter", element.getParameter().get(i), i);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "SupplyRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "SupplyRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "SupplyRequest", "requester", element.getRequester(), -1);
        }
        for (i = 0; i < element.getSupplier().size(); ++i) {
            this.composeReference(t, "SupplyRequest", "supplier", element.getSupplier().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "SupplyRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "SupplyRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasDeliverFrom()) {
            this.composeReference(t, "SupplyRequest", "deliverFrom", element.getDeliverFrom(), -1);
        }
        if (element.hasDeliverTo()) {
            this.composeReference(t, "SupplyRequest", "deliverTo", element.getDeliverTo(), -1);
        }
    }

    protected void composeSupplyRequestSupplyRequestParameterComponent(Turtle.Complex parent, String parentType, String name, SupplyRequest.SupplyRequestParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SupplyRequest", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "SupplyRequest", "value", element.getValue(), -1);
        }
    }

    protected void composeTask(Turtle.Complex parent, String parentType, String name, Task element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "Task", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Task", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasInstantiates()) {
            this.composeType(t, "Task", "instantiates", element.getInstantiates(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Task", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "Task", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Task", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Task", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Task", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasBusinessStatus()) {
            this.composeCodeableConcept(t, "Task", "businessStatus", element.getBusinessStatus(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "Task", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "Task", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Task", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Task", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasFocus()) {
            this.composeReference(t, "Task", "focus", element.getFocus(), -1);
        }
        if (element.hasFor()) {
            this.composeReference(t, "Task", "for", element.getFor(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Task", "context", element.getContext(), -1);
        }
        if (element.hasExecutionPeriod()) {
            this.composePeriod(t, "Task", "executionPeriod", element.getExecutionPeriod(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "Task", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeDateTime(t, "Task", "lastModified", element.getLastModifiedElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "Task", "requester", element.getRequester(), -1);
        }
        for (i = 0; i < element.getPerformerType().size(); ++i) {
            this.composeCodeableConcept(t, "Task", "performerType", element.getPerformerType().get(i), i);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Task", "owner", element.getOwner(), -1);
        }
        if (element.hasReasonCode()) {
            this.composeCodeableConcept(t, "Task", "reasonCode", element.getReasonCode(), -1);
        }
        if (element.hasReasonReference()) {
            this.composeReference(t, "Task", "reasonReference", element.getReasonReference(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Task", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "Task", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
        if (element.hasRestriction()) {
            this.composeTaskTaskRestrictionComponent(t, "Task", "restriction", element.getRestriction(), -1);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeTaskParameterComponent(t, "Task", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getOutput().size(); ++i) {
            this.composeTaskTaskOutputComponent(t, "Task", "output", element.getOutput().get(i), i);
        }
    }

    protected void composeTaskTaskRestrictionComponent(Turtle.Complex parent, String parentType, String name, Task.TaskRestrictionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "restriction", name, element, index);
        if (element.hasRepetitionsElement()) {
            this.composePositiveInt(t, "Task", "repetitions", element.getRepetitionsElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Task", "period", element.getPeriod(), -1);
        }
        for (int i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "Task", "recipient", element.getRecipient().get(i), i);
        }
    }

    protected void composeTaskParameterComponent(Turtle.Complex parent, String parentType, String name, Task.ParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "input", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Task", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Task", "value", element.getValue(), -1);
        }
    }

    protected void composeTaskTaskOutputComponent(Turtle.Complex parent, String parentType, String name, Task.TaskOutputComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "output", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Task", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Task", "value", element.getValue(), -1);
        }
    }

    protected void composeTerminologyCapabilities(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "TerminologyCapabilities", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "TerminologyCapabilities", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "TerminologyCapabilities", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TerminologyCapabilities", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "TerminologyCapabilities", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "TerminologyCapabilities", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "TerminologyCapabilities", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "TerminologyCapabilities", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "TerminologyCapabilities", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "TerminologyCapabilities", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "TerminologyCapabilities", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "TerminologyCapabilities", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "TerminologyCapabilities", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "TerminologyCapabilities", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasLockedDateElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "lockedDate", element.getLockedDateElement(), -1);
        }
        for (i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesCodeSystemComponent(t, "TerminologyCapabilities", "codeSystem", element.getCodeSystem().get(i), i);
        }
        if (element.hasExpansion()) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesExpansionComponent(t, "TerminologyCapabilities", "expansion", element.getExpansion(), -1);
        }
        if (element.hasCodeSearchElement()) {
            this.composeEnum(t, "TerminologyCapabilities", "codeSearch", element.getCodeSearchElement(), -1);
        }
        if (element.hasValidateCode()) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesValidateCodeComponent(t, "TerminologyCapabilities", "validateCode", element.getValidateCode(), -1);
        }
        if (element.hasTranslation()) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesTranslationComponent(t, "TerminologyCapabilities", "translation", element.getTranslation(), -1);
        }
        if (element.hasClosure()) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesClosureComponent(t, "TerminologyCapabilities", "closure", element.getClosure(), -1);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesCodeSystemComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "codeSystem", name, element, index);
        if (element.hasUriElement()) {
            this.composeCanonical(t, "TerminologyCapabilities", "uri", element.getUriElement(), -1);
        }
        for (int i = 0; i < element.getVersion().size(); ++i) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesCodeSystemVersionComponent(t, "TerminologyCapabilities", "version", element.getVersion().get(i), i);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesCodeSystemVersionComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasCodeElement()) {
            this.composeString(t, "TerminologyCapabilities", "code", element.getCodeElement(), -1);
        }
        if (element.hasIsDefaultElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "isDefault", element.getIsDefaultElement(), -1);
        }
        if (element.hasCompositionalElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "compositional", element.getCompositionalElement(), -1);
        }
        for (i = 0; i < element.getLanguage().size(); ++i) {
            this.composeCode(t, "TerminologyCapabilities", "language", element.getLanguage().get(i), i);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeTerminologyCapabilitiesTerminologyCapabilitiesCodeSystemVersionFilterComponent(t, "TerminologyCapabilities", "filter", element.getFilter().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCode(t, "TerminologyCapabilities", "property", element.getProperty().get(i), i);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesCodeSystemVersionFilterComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "TerminologyCapabilities", "code", element.getCodeElement(), -1);
        }
        for (int i = 0; i < element.getOp().size(); ++i) {
            this.composeCode(t, "TerminologyCapabilities", "op", element.getOp().get(i), i);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesExpansionComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "expansion", name, element, index);
        if (element.hasHierarchicalElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "hierarchical", element.getHierarchicalElement(), -1);
        }
        if (element.hasPagingElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "paging", element.getPagingElement(), -1);
        }
        if (element.hasIncompleteElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "incomplete", element.getIncompleteElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "TerminologyCapabilities", "definition", element.getDefinitionElement(), -1);
        }
        for (int i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "TerminologyCapabilities", "profile", element.getProfile().get(i), i);
        }
        if (element.hasTextFilterElement()) {
            this.composeMarkdown(t, "TerminologyCapabilities", "textFilter", element.getTextFilterElement(), -1);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesValidateCodeComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "validateCode", name, element, index);
        if (element.hasTranslationsElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "translations", element.getTranslationsElement(), -1);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesTranslationComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "translation", name, element, index);
        if (element.hasNeedsMapElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "needsMap", element.getNeedsMapElement(), -1);
        }
    }

    protected void composeTerminologyCapabilitiesTerminologyCapabilitiesClosureComponent(Turtle.Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesClosureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "closure", name, element, index);
        if (element.hasTranslationElement()) {
            this.composeBoolean(t, "TerminologyCapabilities", "translation", element.getTranslationElement(), -1);
        }
    }

    protected void composeTestReport(Turtle.Complex parent, String parentType, String name, TestReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "TestReport", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "TestReport", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TestReport", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "TestReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasTestScript()) {
            this.composeReference(t, "TestReport", "testScript", element.getTestScript(), -1);
        }
        if (element.hasResultElement()) {
            this.composeEnum(t, "TestReport", "result", element.getResultElement(), -1);
        }
        if (element.hasScoreElement()) {
            this.composeDecimal(t, "TestReport", "score", element.getScoreElement(), -1);
        }
        if (element.hasTesterElement()) {
            this.composeString(t, "TestReport", "tester", element.getTesterElement(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "TestReport", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeTestReportTestReportParticipantComponent(t, "TestReport", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasSetup()) {
            this.composeTestReportTestReportSetupComponent(t, "TestReport", "setup", element.getSetup(), -1);
        }
        for (i = 0; i < element.getTest().size(); ++i) {
            this.composeTestReportTestReportTestComponent(t, "TestReport", "test", element.getTest().get(i), i);
        }
        if (element.hasTeardown()) {
            this.composeTestReportTestReportTeardownComponent(t, "TestReport", "teardown", element.getTeardown(), -1);
        }
    }

    protected void composeTestReportTestReportParticipantComponent(Turtle.Complex parent, String parentType, String name, TestReport.TestReportParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "TestReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "TestReport", "uri", element.getUriElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "TestReport", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeTestReportTestReportSetupComponent(Turtle.Complex parent, String parentType, String name, TestReport.TestReportSetupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "setup", name, element, index);
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestReportSetupActionComponent(t, "TestReport", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestReportSetupActionComponent(Turtle.Complex parent, String parentType, String name, TestReport.SetupActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestReportSetupActionOperationComponent(t, "TestReport", "operation", element.getOperation(), -1);
        }
        if (element.hasAssert()) {
            this.composeTestReportSetupActionAssertComponent(t, "TestReport", "assert", element.getAssert(), -1);
        }
    }

    protected void composeTestReportSetupActionOperationComponent(Turtle.Complex parent, String parentType, String name, TestReport.SetupActionOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasResultElement()) {
            this.composeEnum(t, "TestReport", "result", element.getResultElement(), -1);
        }
        if (element.hasMessageElement()) {
            this.composeMarkdown(t, "TestReport", "message", element.getMessageElement(), -1);
        }
        if (element.hasDetailElement()) {
            this.composeUri(t, "TestReport", "detail", element.getDetailElement(), -1);
        }
    }

    protected void composeTestReportSetupActionAssertComponent(Turtle.Complex parent, String parentType, String name, TestReport.SetupActionAssertComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "assert", name, element, index);
        if (element.hasResultElement()) {
            this.composeEnum(t, "TestReport", "result", element.getResultElement(), -1);
        }
        if (element.hasMessageElement()) {
            this.composeMarkdown(t, "TestReport", "message", element.getMessageElement(), -1);
        }
        if (element.hasDetailElement()) {
            this.composeString(t, "TestReport", "detail", element.getDetailElement(), -1);
        }
    }

    protected void composeTestReportTestReportTestComponent(Turtle.Complex parent, String parentType, String name, TestReport.TestReportTestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "test", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestReport", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestReport", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestReportTestActionComponent(t, "TestReport", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestReportTestActionComponent(Turtle.Complex parent, String parentType, String name, TestReport.TestActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestReportSetupActionOperationComponent(t, "TestReport", "operation", element.getOperation(), -1);
        }
        if (element.hasAssert()) {
            this.composeTestReportSetupActionAssertComponent(t, "TestReport", "assert", element.getAssert(), -1);
        }
    }

    protected void composeTestReportTestReportTeardownComponent(Turtle.Complex parent, String parentType, String name, TestReport.TestReportTeardownComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "teardown", name, element, index);
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestReportTeardownActionComponent(t, "TestReport", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestReportTeardownActionComponent(Turtle.Complex parent, String parentType, String name, TestReport.TeardownActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestReportSetupActionOperationComponent(t, "TestReport", "operation", element.getOperation(), -1);
        }
    }

    protected void composeTestScript(Turtle.Complex parent, String parentType, String name, TestScript element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "TestScript", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "TestScript", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "TestScript", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "TestScript", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "TestScript", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "TestScript", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "TestScript", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "TestScript", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "TestScript", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "TestScript", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "TestScript", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "TestScript", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "TestScript", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "TestScript", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getOrigin().size(); ++i) {
            this.composeTestScriptTestScriptOriginComponent(t, "TestScript", "origin", element.getOrigin().get(i), i);
        }
        for (i = 0; i < element.getDestination().size(); ++i) {
            this.composeTestScriptTestScriptDestinationComponent(t, "TestScript", "destination", element.getDestination().get(i), i);
        }
        if (element.hasMetadata()) {
            this.composeTestScriptTestScriptMetadataComponent(t, "TestScript", "metadata", element.getMetadata(), -1);
        }
        for (i = 0; i < element.getFixture().size(); ++i) {
            this.composeTestScriptTestScriptFixtureComponent(t, "TestScript", "fixture", element.getFixture().get(i), i);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeReference(t, "TestScript", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getVariable().size(); ++i) {
            this.composeTestScriptTestScriptVariableComponent(t, "TestScript", "variable", element.getVariable().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeTestScriptTestScriptRuleComponent(t, "TestScript", "rule", element.getRule().get(i), i);
        }
        for (i = 0; i < element.getRuleset().size(); ++i) {
            this.composeTestScriptTestScriptRulesetComponent(t, "TestScript", "ruleset", element.getRuleset().get(i), i);
        }
        if (element.hasSetup()) {
            this.composeTestScriptTestScriptSetupComponent(t, "TestScript", "setup", element.getSetup(), -1);
        }
        for (i = 0; i < element.getTest().size(); ++i) {
            this.composeTestScriptTestScriptTestComponent(t, "TestScript", "test", element.getTest().get(i), i);
        }
        if (element.hasTeardown()) {
            this.composeTestScriptTestScriptTeardownComponent(t, "TestScript", "teardown", element.getTeardown(), -1);
        }
    }

    protected void composeTestScriptTestScriptOriginComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptOriginComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "origin", name, element, index);
        if (element.hasIndexElement()) {
            this.composeInteger(t, "TestScript", "index", element.getIndexElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeCoding(t, "TestScript", "profile", element.getProfile(), -1);
        }
    }

    protected void composeTestScriptTestScriptDestinationComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasIndexElement()) {
            this.composeInteger(t, "TestScript", "index", element.getIndexElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeCoding(t, "TestScript", "profile", element.getProfile(), -1);
        }
    }

    protected void composeTestScriptTestScriptMetadataComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptMetadataComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "metadata", name, element, index);
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeTestScriptTestScriptMetadataLinkComponent(t, "TestScript", "link", element.getLink().get(i), i);
        }
        for (i = 0; i < element.getCapability().size(); ++i) {
            this.composeTestScriptTestScriptMetadataCapabilityComponent(t, "TestScript", "capability", element.getCapability().get(i), i);
        }
    }

    protected void composeTestScriptTestScriptMetadataLinkComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptMetadataLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "TestScript", "url", element.getUrlElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptMetadataCapabilityComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptMetadataCapabilityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "capability", name, element, index);
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "TestScript", "required", element.getRequiredElement(), -1);
        }
        if (element.hasValidatedElement()) {
            this.composeBoolean(t, "TestScript", "validated", element.getValidatedElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getOrigin().size(); ++i) {
            this.composeInteger(t, "TestScript", "origin", element.getOrigin().get(i), i);
        }
        if (element.hasDestinationElement()) {
            this.composeInteger(t, "TestScript", "destination", element.getDestinationElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeUri(t, "TestScript", "link", element.getLink().get(i), i);
        }
        if (element.hasCapabilitiesElement()) {
            this.composeCanonical(t, "TestScript", "capabilities", element.getCapabilitiesElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptFixtureComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptFixtureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "fixture", name, element, index);
        if (element.hasAutocreateElement()) {
            this.composeBoolean(t, "TestScript", "autocreate", element.getAutocreateElement(), -1);
        }
        if (element.hasAutodeleteElement()) {
            this.composeBoolean(t, "TestScript", "autodelete", element.getAutodeleteElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "TestScript", "resource", element.getResource(), -1);
        }
    }

    protected void composeTestScriptTestScriptVariableComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptVariableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "variable", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasDefaultValueElement()) {
            this.composeString(t, "TestScript", "defaultValue", element.getDefaultValueElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "TestScript", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasHeaderFieldElement()) {
            this.composeString(t, "TestScript", "headerField", element.getHeaderFieldElement(), -1);
        }
        if (element.hasHintElement()) {
            this.composeString(t, "TestScript", "hint", element.getHintElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "TestScript", "path", element.getPathElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "TestScript", "sourceId", element.getSourceIdElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptRuleComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasResource()) {
            this.composeReference(t, "TestScript", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptRuleParamComponent(Turtle.Complex parent, String parentType, String name, TestScript.RuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptRulesetComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptRulesetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "ruleset", name, element, index);
        if (element.hasResource()) {
            this.composeReference(t, "TestScript", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getRule().size(); ++i) {
            this.composeTestScriptRulesetRuleComponent(t, "TestScript", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeTestScriptRulesetRuleComponent(Turtle.Complex parent, String parentType, String name, TestScript.RulesetRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasRuleIdElement()) {
            this.composeId(t, "TestScript", "ruleId", element.getRuleIdElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptRulesetRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptRulesetRuleParamComponent(Turtle.Complex parent, String parentType, String name, TestScript.RulesetRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptSetupComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptSetupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "setup", name, element, index);
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestScriptSetupActionComponent(t, "TestScript", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestScriptSetupActionComponent(Turtle.Complex parent, String parentType, String name, TestScript.SetupActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestScriptSetupActionOperationComponent(t, "TestScript", "operation", element.getOperation(), -1);
        }
        if (element.hasAssert()) {
            this.composeTestScriptSetupActionAssertComponent(t, "TestScript", "assert", element.getAssert(), -1);
        }
    }

    protected void composeTestScriptSetupActionOperationComponent(Turtle.Complex parent, String parentType, String name, TestScript.SetupActionOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "TestScript", "type", element.getType(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCode(t, "TestScript", "resource", element.getResourceElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "TestScript", "label", element.getLabelElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAcceptElement()) {
            this.composeCode(t, "TestScript", "accept", element.getAcceptElement(), -1);
        }
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "TestScript", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasDestinationElement()) {
            this.composeInteger(t, "TestScript", "destination", element.getDestinationElement(), -1);
        }
        if (element.hasEncodeRequestUrlElement()) {
            this.composeBoolean(t, "TestScript", "encodeRequestUrl", element.getEncodeRequestUrlElement(), -1);
        }
        if (element.hasOriginElement()) {
            this.composeInteger(t, "TestScript", "origin", element.getOriginElement(), -1);
        }
        if (element.hasParamsElement()) {
            this.composeString(t, "TestScript", "params", element.getParamsElement(), -1);
        }
        for (int i = 0; i < element.getRequestHeader().size(); ++i) {
            this.composeTestScriptSetupActionOperationRequestHeaderComponent(t, "TestScript", "requestHeader", element.getRequestHeader().get(i), i);
        }
        if (element.hasRequestIdElement()) {
            this.composeId(t, "TestScript", "requestId", element.getRequestIdElement(), -1);
        }
        if (element.hasResponseIdElement()) {
            this.composeId(t, "TestScript", "responseId", element.getResponseIdElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "TestScript", "sourceId", element.getSourceIdElement(), -1);
        }
        if (element.hasTargetIdElement()) {
            this.composeId(t, "TestScript", "targetId", element.getTargetIdElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeString(t, "TestScript", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeTestScriptSetupActionOperationRequestHeaderComponent(Turtle.Complex parent, String parentType, String name, TestScript.SetupActionOperationRequestHeaderComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "requestHeader", name, element, index);
        if (element.hasFieldElement()) {
            this.composeString(t, "TestScript", "field", element.getFieldElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptSetupActionAssertComponent(Turtle.Complex parent, String parentType, String name, TestScript.SetupActionAssertComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "assert", name, element, index);
        if (element.hasLabelElement()) {
            this.composeString(t, "TestScript", "label", element.getLabelElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDirectionElement()) {
            this.composeEnum(t, "TestScript", "direction", element.getDirectionElement(), -1);
        }
        if (element.hasCompareToSourceIdElement()) {
            this.composeString(t, "TestScript", "compareToSourceId", element.getCompareToSourceIdElement(), -1);
        }
        if (element.hasCompareToSourceExpressionElement()) {
            this.composeString(t, "TestScript", "compareToSourceExpression", element.getCompareToSourceExpressionElement(), -1);
        }
        if (element.hasCompareToSourcePathElement()) {
            this.composeString(t, "TestScript", "compareToSourcePath", element.getCompareToSourcePathElement(), -1);
        }
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "TestScript", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "TestScript", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasHeaderFieldElement()) {
            this.composeString(t, "TestScript", "headerField", element.getHeaderFieldElement(), -1);
        }
        if (element.hasMinimumIdElement()) {
            this.composeString(t, "TestScript", "minimumId", element.getMinimumIdElement(), -1);
        }
        if (element.hasNavigationLinksElement()) {
            this.composeBoolean(t, "TestScript", "navigationLinks", element.getNavigationLinksElement(), -1);
        }
        if (element.hasOperatorElement()) {
            this.composeEnum(t, "TestScript", "operator", element.getOperatorElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "TestScript", "path", element.getPathElement(), -1);
        }
        if (element.hasRequestMethodElement()) {
            this.composeEnum(t, "TestScript", "requestMethod", element.getRequestMethodElement(), -1);
        }
        if (element.hasRequestURLElement()) {
            this.composeString(t, "TestScript", "requestURL", element.getRequestURLElement(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCode(t, "TestScript", "resource", element.getResourceElement(), -1);
        }
        if (element.hasResponseElement()) {
            this.composeEnum(t, "TestScript", "response", element.getResponseElement(), -1);
        }
        if (element.hasResponseCodeElement()) {
            this.composeString(t, "TestScript", "responseCode", element.getResponseCodeElement(), -1);
        }
        if (element.hasRule()) {
            this.composeTestScriptActionAssertRuleComponent(t, "TestScript", "rule", element.getRule(), -1);
        }
        if (element.hasRuleset()) {
            this.composeTestScriptActionAssertRulesetComponent(t, "TestScript", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "TestScript", "sourceId", element.getSourceIdElement(), -1);
        }
        if (element.hasValidateProfileIdElement()) {
            this.composeId(t, "TestScript", "validateProfileId", element.getValidateProfileIdElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
        if (element.hasWarningOnlyElement()) {
            this.composeBoolean(t, "TestScript", "warningOnly", element.getWarningOnlyElement(), -1);
        }
    }

    protected void composeTestScriptActionAssertRuleComponent(Turtle.Complex parent, String parentType, String name, TestScript.ActionAssertRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasRuleIdElement()) {
            this.composeId(t, "TestScript", "ruleId", element.getRuleIdElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptActionAssertRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptActionAssertRuleParamComponent(Turtle.Complex parent, String parentType, String name, TestScript.ActionAssertRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptActionAssertRulesetComponent(Turtle.Complex parent, String parentType, String name, TestScript.ActionAssertRulesetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "ruleset", name, element, index);
        if (element.hasRulesetIdElement()) {
            this.composeId(t, "TestScript", "rulesetId", element.getRulesetIdElement(), -1);
        }
        for (int i = 0; i < element.getRule().size(); ++i) {
            this.composeTestScriptActionAssertRulesetRuleComponent(t, "TestScript", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeTestScriptActionAssertRulesetRuleComponent(Turtle.Complex parent, String parentType, String name, TestScript.ActionAssertRulesetRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasRuleIdElement()) {
            this.composeId(t, "TestScript", "ruleId", element.getRuleIdElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptActionAssertRulesetRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptActionAssertRulesetRuleParamComponent(Turtle.Complex parent, String parentType, String name, TestScript.ActionAssertRulesetRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptTestComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptTestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "test", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestScriptTestActionComponent(t, "TestScript", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestScriptTestActionComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestScriptSetupActionOperationComponent(t, "TestScript", "operation", element.getOperation(), -1);
        }
        if (element.hasAssert()) {
            this.composeTestScriptSetupActionAssertComponent(t, "TestScript", "assert", element.getAssert(), -1);
        }
    }

    protected void composeTestScriptTestScriptTeardownComponent(Turtle.Complex parent, String parentType, String name, TestScript.TestScriptTeardownComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "teardown", name, element, index);
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestScriptTeardownActionComponent(t, "TestScript", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestScriptTeardownActionComponent(Turtle.Complex parent, String parentType, String name, TestScript.TeardownActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestScriptSetupActionOperationComponent(t, "TestScript", "operation", element.getOperation(), -1);
        }
    }

    protected void composeUserSession(Turtle.Complex parent, String parentType, String name, UserSession element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "UserSession", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "UserSession", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasUser()) {
            this.composeReference(t, "UserSession", "user", element.getUser(), -1);
        }
        if (element.hasStatus()) {
            this.composeUserSessionUserSessionStatusComponent(t, "UserSession", "status", element.getStatus(), -1);
        }
        if (element.hasWorkstation()) {
            this.composeIdentifier(t, "UserSession", "workstation", element.getWorkstation(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeReference(t, "UserSession", "focus", element.getFocus().get(i), i);
        }
        if (element.hasCreatedElement()) {
            this.composeInstant(t, "UserSession", "created", element.getCreatedElement(), -1);
        }
        if (element.hasExpiresElement()) {
            this.composeInstant(t, "UserSession", "expires", element.getExpiresElement(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeUserSessionUserSessionContextComponent(t, "UserSession", "context", element.getContext().get(i), i);
        }
    }

    protected void composeUserSessionUserSessionStatusComponent(Turtle.Complex parent, String parentType, String name, UserSession.UserSessionStatusComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "status", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "UserSession", "code", element.getCodeElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeEnum(t, "UserSession", "source", element.getSourceElement(), -1);
        }
    }

    protected void composeUserSessionUserSessionContextComponent(Turtle.Complex parent, String parentType, String name, UserSession.UserSessionContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasTypeElement()) {
            this.composeString(t, "UserSession", "type", element.getTypeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "UserSession", "value", element.getValue(), -1);
        }
    }

    protected void composeValueSet(Turtle.Complex parent, String parentType, String name, ValueSet element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "ValueSet", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ValueSet", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ValueSet", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ValueSet", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ValueSet", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ValueSet", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ValueSet", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ValueSet", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ValueSet", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ValueSet", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ValueSet", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ValueSet", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ValueSet", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ValueSet", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasImmutableElement()) {
            this.composeBoolean(t, "ValueSet", "immutable", element.getImmutableElement(), -1);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ValueSet", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ValueSet", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasExtensibleElement()) {
            this.composeBoolean(t, "ValueSet", "extensible", element.getExtensibleElement(), -1);
        }
        if (element.hasCompose()) {
            this.composeValueSetValueSetComposeComponent(t, "ValueSet", "compose", element.getCompose(), -1);
        }
        if (element.hasExpansion()) {
            this.composeValueSetValueSetExpansionComponent(t, "ValueSet", "expansion", element.getExpansion(), -1);
        }
    }

    protected void composeValueSetValueSetComposeComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ValueSetComposeComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "compose", name, element, index);
        if (element.hasLockedDateElement()) {
            this.composeDate(t, "ValueSet", "lockedDate", element.getLockedDateElement(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "ValueSet", "inactive", element.getInactiveElement(), -1);
        }
        for (i = 0; i < element.getInclude().size(); ++i) {
            this.composeValueSetConceptSetComponent(t, "ValueSet", "include", element.getInclude().get(i), i);
        }
        for (i = 0; i < element.getExclude().size(); ++i) {
            this.composeValueSetConceptSetComponent(t, "ValueSet", "exclude", element.getExclude().get(i), i);
        }
    }

    protected void composeValueSetConceptSetComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ConceptSetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "include", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ValueSet", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ValueSet", "version", element.getVersionElement(), -1);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeValueSetConceptReferenceComponent(t, "ValueSet", "concept", element.getConcept().get(i), i);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeValueSetConceptSetFilterComponent(t, "ValueSet", "filter", element.getFilter().get(i), i);
        }
        for (i = 0; i < element.getValueSet().size(); ++i) {
            this.composeCanonical(t, "ValueSet", "valueSet", element.getValueSet().get(i), i);
        }
    }

    protected void composeValueSetConceptReferenceComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ConceptReferenceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ValueSet", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ValueSet", "display", element.getDisplayElement(), -1);
        }
        for (int i = 0; i < element.getDesignation().size(); ++i) {
            this.composeValueSetConceptReferenceDesignationComponent(t, "ValueSet", "designation", element.getDesignation().get(i), i);
        }
    }

    protected void composeValueSetConceptReferenceDesignationComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ConceptReferenceDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ValueSet", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ValueSet", "use", element.getUse(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ValueSet", "value", element.getValueElement(), -1);
        }
    }

    protected void composeValueSetConceptSetFilterComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ConceptSetFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasPropertyElement()) {
            this.composeCode(t, "ValueSet", "property", element.getPropertyElement(), -1);
        }
        if (element.hasOpElement()) {
            this.composeEnum(t, "ValueSet", "op", element.getOpElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ValueSet", "value", element.getValueElement(), -1);
        }
    }

    protected void composeValueSetValueSetExpansionComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ValueSetExpansionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "expansion", name, element, index);
        if (element.hasIdentifierElement()) {
            this.composeUri(t, "ValueSet", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasTimestampElement()) {
            this.composeDateTime(t, "ValueSet", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeInteger(t, "ValueSet", "total", element.getTotalElement(), -1);
        }
        if (element.hasOffsetElement()) {
            this.composeInteger(t, "ValueSet", "offset", element.getOffsetElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeValueSetValueSetExpansionParameterComponent(t, "ValueSet", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getContains().size(); ++i) {
            this.composeValueSetValueSetExpansionContainsComponent(t, "ValueSet", "contains", element.getContains().get(i), i);
        }
    }

    protected void composeValueSetValueSetExpansionParameterComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ValueSetExpansionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ValueSet", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ValueSet", "value", element.getValue(), -1);
        }
    }

    protected void composeValueSetValueSetExpansionContainsComponent(Turtle.Complex parent, String parentType, String name, ValueSet.ValueSetExpansionContainsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "contains", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ValueSet", "system", element.getSystemElement(), -1);
        }
        if (element.hasAbstractElement()) {
            this.composeBoolean(t, "ValueSet", "abstract", element.getAbstractElement(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "ValueSet", "inactive", element.getInactiveElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ValueSet", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ValueSet", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ValueSet", "display", element.getDisplayElement(), -1);
        }
        for (i = 0; i < element.getDesignation().size(); ++i) {
            this.composeValueSetConceptReferenceDesignationComponent(t, "ValueSet", "designation", element.getDesignation().get(i), i);
        }
        for (i = 0; i < element.getContains().size(); ++i) {
            this.composeValueSetValueSetExpansionContainsComponent(t, "ValueSet", "contains", element.getContains().get(i), i);
        }
    }

    protected void composeVerificationResult(Turtle.Complex parent, String parentType, String name, VerificationResult element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "VerificationResult", name, element, index);
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeReference(t, "VerificationResult", "target", element.getTarget().get(i), i);
        }
        for (i = 0; i < element.getTargetLocation().size(); ++i) {
            this.composeString(t, "VerificationResult", "targetLocation", element.getTargetLocation().get(i), i);
        }
        if (element.hasNeedElement()) {
            this.composeEnum(t, "VerificationResult", "need", element.getNeedElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "VerificationResult", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "VerificationResult", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasValidationTypeElement()) {
            this.composeEnum(t, "VerificationResult", "validationType", element.getValidationTypeElement(), -1);
        }
        for (i = 0; i < element.getValidationProcess().size(); ++i) {
            this.composeCodeableConcept(t, "VerificationResult", "validationProcess", element.getValidationProcess().get(i), i);
        }
        if (element.hasFrequency()) {
            this.composeTiming(t, "VerificationResult", "frequency", element.getFrequency(), -1);
        }
        if (element.hasLastPerformedElement()) {
            this.composeDateTime(t, "VerificationResult", "lastPerformed", element.getLastPerformedElement(), -1);
        }
        if (element.hasNextScheduledElement()) {
            this.composeDate(t, "VerificationResult", "nextScheduled", element.getNextScheduledElement(), -1);
        }
        if (element.hasFailureActionElement()) {
            this.composeEnum(t, "VerificationResult", "failureAction", element.getFailureActionElement(), -1);
        }
        for (i = 0; i < element.getPrimarySource().size(); ++i) {
            this.composeVerificationResultVerificationResultPrimarySourceComponent(t, "VerificationResult", "primarySource", element.getPrimarySource().get(i), i);
        }
        if (element.hasAttestation()) {
            this.composeVerificationResultVerificationResultAttestationComponent(t, "VerificationResult", "attestation", element.getAttestation(), -1);
        }
        for (i = 0; i < element.getValidator().size(); ++i) {
            this.composeVerificationResultVerificationResultValidatorComponent(t, "VerificationResult", "validator", element.getValidator().get(i), i);
        }
    }

    protected void composeVerificationResultVerificationResultPrimarySourceComponent(Turtle.Complex parent, String parentType, String name, VerificationResult.VerificationResultPrimarySourceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "primarySource", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "VerificationResult", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "VerificationResult", "organization", element.getOrganization(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "VerificationResult", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getValidationProcess().size(); ++i) {
            this.composeCodeableConcept(t, "VerificationResult", "validationProcess", element.getValidationProcess().get(i), i);
        }
        if (element.hasValidationStatusElement()) {
            this.composeEnum(t, "VerificationResult", "validationStatus", element.getValidationStatusElement(), -1);
        }
        if (element.hasValidationDateElement()) {
            this.composeDateTime(t, "VerificationResult", "validationDate", element.getValidationDateElement(), -1);
        }
        if (element.hasCanPushUpdatesElement()) {
            this.composeEnum(t, "VerificationResult", "canPushUpdates", element.getCanPushUpdatesElement(), -1);
        }
        for (i = 0; i < element.getPushTypeAvailable().size(); ++i) {
            this.composeEnum(t, "VerificationResult", "pushTypeAvailable", element.getPushTypeAvailable().get(i), i);
        }
    }

    protected void composeVerificationResultVerificationResultAttestationComponent(Turtle.Complex parent, String parentType, String name, VerificationResult.VerificationResultAttestationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "attestation", name, element, index);
        if (element.hasSource()) {
            this.composeReference(t, "VerificationResult", "source", element.getSource(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "VerificationResult", "organization", element.getOrganization(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "VerificationResult", "method", element.getMethod(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "VerificationResult", "date", element.getDateElement(), -1);
        }
        if (element.hasSourceIdentityCertificateElement()) {
            this.composeString(t, "VerificationResult", "sourceIdentityCertificate", element.getSourceIdentityCertificateElement(), -1);
        }
        if (element.hasProxyIdentityCertificateElement()) {
            this.composeString(t, "VerificationResult", "proxyIdentityCertificate", element.getProxyIdentityCertificateElement(), -1);
        }
    }

    protected void composeVerificationResultVerificationResultValidatorComponent(Turtle.Complex parent, String parentType, String name, VerificationResult.VerificationResultValidatorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "validator", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "VerificationResult", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "VerificationResult", "organization", element.getOrganization(), -1);
        }
        if (element.hasIdentityCertificateElement()) {
            this.composeString(t, "VerificationResult", "identityCertificate", element.getIdentityCertificateElement(), -1);
        }
        if (element.hasDateValidatedElement()) {
            this.composeDate(t, "VerificationResult", "dateValidated", element.getDateValidatedElement(), -1);
        }
    }

    protected void composeVisionPrescription(Turtle.Complex parent, String parentType, String name, VisionPrescription element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeDomainResource(t, "VisionPrescription", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "VisionPrescription", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "VisionPrescription", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "VisionPrescription", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "VisionPrescription", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateWrittenElement()) {
            this.composeDateTime(t, "VisionPrescription", "dateWritten", element.getDateWrittenElement(), -1);
        }
        if (element.hasPrescriber()) {
            this.composeReference(t, "VisionPrescription", "prescriber", element.getPrescriber(), -1);
        }
        if (element.hasReason()) {
            this.composeType(t, "VisionPrescription", "reason", element.getReason(), -1);
        }
        for (i = 0; i < element.getDispense().size(); ++i) {
            this.composeVisionPrescriptionVisionPrescriptionDispenseComponent(t, "VisionPrescription", "dispense", element.getDispense().get(i), i);
        }
    }

    protected void composeVisionPrescriptionVisionPrescriptionDispenseComponent(Turtle.Complex parent, String parentType, String name, VisionPrescription.VisionPrescriptionDispenseComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "dispense", name, element, index);
        if (element.hasProduct()) {
            this.composeCodeableConcept(t, "VisionPrescription", "product", element.getProduct(), -1);
        }
        if (element.hasEyeElement()) {
            this.composeEnum(t, "VisionPrescription", "eye", element.getEyeElement(), -1);
        }
        if (element.hasSphereElement()) {
            this.composeDecimal(t, "VisionPrescription", "sphere", element.getSphereElement(), -1);
        }
        if (element.hasCylinderElement()) {
            this.composeDecimal(t, "VisionPrescription", "cylinder", element.getCylinderElement(), -1);
        }
        if (element.hasAxisElement()) {
            this.composeInteger(t, "VisionPrescription", "axis", element.getAxisElement(), -1);
        }
        for (i = 0; i < element.getPrism().size(); ++i) {
            this.composeVisionPrescriptionPrismComponent(t, "VisionPrescription", "prism", element.getPrism().get(i), i);
        }
        if (element.hasAddElement()) {
            this.composeDecimal(t, "VisionPrescription", "add", element.getAddElement(), -1);
        }
        if (element.hasPowerElement()) {
            this.composeDecimal(t, "VisionPrescription", "power", element.getPowerElement(), -1);
        }
        if (element.hasBackCurveElement()) {
            this.composeDecimal(t, "VisionPrescription", "backCurve", element.getBackCurveElement(), -1);
        }
        if (element.hasDiameterElement()) {
            this.composeDecimal(t, "VisionPrescription", "diameter", element.getDiameterElement(), -1);
        }
        if (element.hasDuration()) {
            this.composeQuantity(t, "VisionPrescription", "duration", element.getDuration(), -1);
        }
        if (element.hasColorElement()) {
            this.composeString(t, "VisionPrescription", "color", element.getColorElement(), -1);
        }
        if (element.hasBrandElement()) {
            this.composeString(t, "VisionPrescription", "brand", element.getBrandElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "VisionPrescription", "note", element.getNote().get(i), i);
        }
    }

    protected void composeVisionPrescriptionPrismComponent(Turtle.Complex parent, String parentType, String name, VisionPrescription.PrismComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + '.' + name);
        this.composeBackboneElement(t, "prism", name, element, index);
        if (element.hasAmountElement()) {
            this.composeDecimal(t, "VisionPrescription", "amount", element.getAmountElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeEnum(t, "VisionPrescription", "base", element.getBaseElement(), -1);
        }
    }

    @Override
    protected void composeResource(Turtle.Complex parent, Resource resource) {
        if (resource instanceof Parameters) {
            this.composeParameters(parent, null, "Parameters", (Parameters)resource, -1);
        } else if (resource instanceof Account) {
            this.composeAccount(parent, null, "Account", (Account)resource, -1);
        } else if (resource instanceof ActivityDefinition) {
            this.composeActivityDefinition(parent, null, "ActivityDefinition", (ActivityDefinition)resource, -1);
        } else if (resource instanceof AdverseEvent) {
            this.composeAdverseEvent(parent, null, "AdverseEvent", (AdverseEvent)resource, -1);
        } else if (resource instanceof AllergyIntolerance) {
            this.composeAllergyIntolerance(parent, null, "AllergyIntolerance", (AllergyIntolerance)resource, -1);
        } else if (resource instanceof Appointment) {
            this.composeAppointment(parent, null, "Appointment", (Appointment)resource, -1);
        } else if (resource instanceof AppointmentResponse) {
            this.composeAppointmentResponse(parent, null, "AppointmentResponse", (AppointmentResponse)resource, -1);
        } else if (resource instanceof AuditEvent) {
            this.composeAuditEvent(parent, null, "AuditEvent", (AuditEvent)resource, -1);
        } else if (resource instanceof Basic) {
            this.composeBasic(parent, null, "Basic", (Basic)resource, -1);
        } else if (resource instanceof Binary) {
            this.composeBinary(parent, null, "Binary", (Binary)resource, -1);
        } else if (resource instanceof BiologicallyDerivedProduct) {
            this.composeBiologicallyDerivedProduct(parent, null, "BiologicallyDerivedProduct", (BiologicallyDerivedProduct)resource, -1);
        } else if (resource instanceof BodyStructure) {
            this.composeBodyStructure(parent, null, "BodyStructure", (BodyStructure)resource, -1);
        } else if (resource instanceof Bundle) {
            this.composeBundle(parent, null, "Bundle", (Bundle)resource, -1);
        } else if (resource instanceof CapabilityStatement) {
            this.composeCapabilityStatement(parent, null, "CapabilityStatement", (CapabilityStatement)resource, -1);
        } else if (resource instanceof CarePlan) {
            this.composeCarePlan(parent, null, "CarePlan", (CarePlan)resource, -1);
        } else if (resource instanceof CareTeam) {
            this.composeCareTeam(parent, null, "CareTeam", (CareTeam)resource, -1);
        } else if (resource instanceof ChargeItem) {
            this.composeChargeItem(parent, null, "ChargeItem", (ChargeItem)resource, -1);
        } else if (resource instanceof Claim) {
            this.composeClaim(parent, null, "Claim", (Claim)resource, -1);
        } else if (resource instanceof ClaimResponse) {
            this.composeClaimResponse(parent, null, "ClaimResponse", (ClaimResponse)resource, -1);
        } else if (resource instanceof ClinicalImpression) {
            this.composeClinicalImpression(parent, null, "ClinicalImpression", (ClinicalImpression)resource, -1);
        } else if (resource instanceof CodeSystem) {
            this.composeCodeSystem(parent, null, "CodeSystem", (CodeSystem)resource, -1);
        } else if (resource instanceof Communication) {
            this.composeCommunication(parent, null, "Communication", (Communication)resource, -1);
        } else if (resource instanceof CommunicationRequest) {
            this.composeCommunicationRequest(parent, null, "CommunicationRequest", (CommunicationRequest)resource, -1);
        } else if (resource instanceof CompartmentDefinition) {
            this.composeCompartmentDefinition(parent, null, "CompartmentDefinition", (CompartmentDefinition)resource, -1);
        } else if (resource instanceof Composition) {
            this.composeComposition(parent, null, "Composition", (Composition)resource, -1);
        } else if (resource instanceof ConceptMap) {
            this.composeConceptMap(parent, null, "ConceptMap", (ConceptMap)resource, -1);
        } else if (resource instanceof Condition) {
            this.composeCondition(parent, null, "Condition", (Condition)resource, -1);
        } else if (resource instanceof Consent) {
            this.composeConsent(parent, null, "Consent", (Consent)resource, -1);
        } else if (resource instanceof Contract) {
            this.composeContract(parent, null, "Contract", (Contract)resource, -1);
        } else if (resource instanceof Coverage) {
            this.composeCoverage(parent, null, "Coverage", (Coverage)resource, -1);
        } else if (resource instanceof DetectedIssue) {
            this.composeDetectedIssue(parent, null, "DetectedIssue", (DetectedIssue)resource, -1);
        } else if (resource instanceof Device) {
            this.composeDevice(parent, null, "Device", (Device)resource, -1);
        } else if (resource instanceof DeviceComponent) {
            this.composeDeviceComponent(parent, null, "DeviceComponent", (DeviceComponent)resource, -1);
        } else if (resource instanceof DeviceMetric) {
            this.composeDeviceMetric(parent, null, "DeviceMetric", (DeviceMetric)resource, -1);
        } else if (resource instanceof DeviceRequest) {
            this.composeDeviceRequest(parent, null, "DeviceRequest", (DeviceRequest)resource, -1);
        } else if (resource instanceof DeviceUseStatement) {
            this.composeDeviceUseStatement(parent, null, "DeviceUseStatement", (DeviceUseStatement)resource, -1);
        } else if (resource instanceof DiagnosticReport) {
            this.composeDiagnosticReport(parent, null, "DiagnosticReport", (DiagnosticReport)resource, -1);
        } else if (resource instanceof DocumentManifest) {
            this.composeDocumentManifest(parent, null, "DocumentManifest", (DocumentManifest)resource, -1);
        } else if (resource instanceof DocumentReference) {
            this.composeDocumentReference(parent, null, "DocumentReference", (DocumentReference)resource, -1);
        } else if (resource instanceof EligibilityRequest) {
            this.composeEligibilityRequest(parent, null, "EligibilityRequest", (EligibilityRequest)resource, -1);
        } else if (resource instanceof EligibilityResponse) {
            this.composeEligibilityResponse(parent, null, "EligibilityResponse", (EligibilityResponse)resource, -1);
        } else if (resource instanceof Encounter) {
            this.composeEncounter(parent, null, "Encounter", (Encounter)resource, -1);
        } else if (resource instanceof Endpoint) {
            this.composeEndpoint(parent, null, "Endpoint", (Endpoint)resource, -1);
        } else if (resource instanceof EnrollmentRequest) {
            this.composeEnrollmentRequest(parent, null, "EnrollmentRequest", (EnrollmentRequest)resource, -1);
        } else if (resource instanceof EnrollmentResponse) {
            this.composeEnrollmentResponse(parent, null, "EnrollmentResponse", (EnrollmentResponse)resource, -1);
        } else if (resource instanceof EntryDefinition) {
            this.composeEntryDefinition(parent, null, "EntryDefinition", (EntryDefinition)resource, -1);
        } else if (resource instanceof EpisodeOfCare) {
            this.composeEpisodeOfCare(parent, null, "EpisodeOfCare", (EpisodeOfCare)resource, -1);
        } else if (resource instanceof EventDefinition) {
            this.composeEventDefinition(parent, null, "EventDefinition", (EventDefinition)resource, -1);
        } else if (resource instanceof ExampleScenario) {
            this.composeExampleScenario(parent, null, "ExampleScenario", (ExampleScenario)resource, -1);
        } else if (resource instanceof ExpansionProfile) {
            this.composeExpansionProfile(parent, null, "ExpansionProfile", (ExpansionProfile)resource, -1);
        } else if (resource instanceof ExplanationOfBenefit) {
            this.composeExplanationOfBenefit(parent, null, "ExplanationOfBenefit", (ExplanationOfBenefit)resource, -1);
        } else if (resource instanceof FamilyMemberHistory) {
            this.composeFamilyMemberHistory(parent, null, "FamilyMemberHistory", (FamilyMemberHistory)resource, -1);
        } else if (resource instanceof Flag) {
            this.composeFlag(parent, null, "Flag", (Flag)resource, -1);
        } else if (resource instanceof Goal) {
            this.composeGoal(parent, null, "Goal", (Goal)resource, -1);
        } else if (resource instanceof GraphDefinition) {
            this.composeGraphDefinition(parent, null, "GraphDefinition", (GraphDefinition)resource, -1);
        } else if (resource instanceof Group) {
            this.composeGroup(parent, null, "Group", (Group)resource, -1);
        } else if (resource instanceof GuidanceResponse) {
            this.composeGuidanceResponse(parent, null, "GuidanceResponse", (GuidanceResponse)resource, -1);
        } else if (resource instanceof HealthcareService) {
            this.composeHealthcareService(parent, null, "HealthcareService", (HealthcareService)resource, -1);
        } else if (resource instanceof ImagingStudy) {
            this.composeImagingStudy(parent, null, "ImagingStudy", (ImagingStudy)resource, -1);
        } else if (resource instanceof Immunization) {
            this.composeImmunization(parent, null, "Immunization", (Immunization)resource, -1);
        } else if (resource instanceof ImmunizationEvaluation) {
            this.composeImmunizationEvaluation(parent, null, "ImmunizationEvaluation", (ImmunizationEvaluation)resource, -1);
        } else if (resource instanceof ImmunizationRecommendation) {
            this.composeImmunizationRecommendation(parent, null, "ImmunizationRecommendation", (ImmunizationRecommendation)resource, -1);
        } else if (resource instanceof ImplementationGuide) {
            this.composeImplementationGuide(parent, null, "ImplementationGuide", (ImplementationGuide)resource, -1);
        } else if (resource instanceof Invoice) {
            this.composeInvoice(parent, null, "Invoice", (Invoice)resource, -1);
        } else if (resource instanceof ItemInstance) {
            this.composeItemInstance(parent, null, "ItemInstance", (ItemInstance)resource, -1);
        } else if (resource instanceof Library) {
            this.composeLibrary(parent, null, "Library", (Library)resource, -1);
        } else if (resource instanceof Linkage) {
            this.composeLinkage(parent, null, "Linkage", (Linkage)resource, -1);
        } else if (resource instanceof ListResource) {
            this.composeListResource(parent, null, "ListResource", (ListResource)resource, -1);
        } else if (resource instanceof Location) {
            this.composeLocation(parent, null, "Location", (Location)resource, -1);
        } else if (resource instanceof Measure) {
            this.composeMeasure(parent, null, "Measure", (Measure)resource, -1);
        } else if (resource instanceof MeasureReport) {
            this.composeMeasureReport(parent, null, "MeasureReport", (MeasureReport)resource, -1);
        } else if (resource instanceof Media) {
            this.composeMedia(parent, null, "Media", (Media)resource, -1);
        } else if (resource instanceof Medication) {
            this.composeMedication(parent, null, "Medication", (Medication)resource, -1);
        } else if (resource instanceof MedicationAdministration) {
            this.composeMedicationAdministration(parent, null, "MedicationAdministration", (MedicationAdministration)resource, -1);
        } else if (resource instanceof MedicationDispense) {
            this.composeMedicationDispense(parent, null, "MedicationDispense", (MedicationDispense)resource, -1);
        } else if (resource instanceof MedicationRequest) {
            this.composeMedicationRequest(parent, null, "MedicationRequest", (MedicationRequest)resource, -1);
        } else if (resource instanceof MedicationStatement) {
            this.composeMedicationStatement(parent, null, "MedicationStatement", (MedicationStatement)resource, -1);
        } else if (resource instanceof MedicinalProduct) {
            this.composeMedicinalProduct(parent, null, "MedicinalProduct", (MedicinalProduct)resource, -1);
        } else if (resource instanceof MedicinalProductAuthorization) {
            this.composeMedicinalProductAuthorization(parent, null, "MedicinalProductAuthorization", (MedicinalProductAuthorization)resource, -1);
        } else if (resource instanceof MedicinalProductClinicals) {
            this.composeMedicinalProductClinicals(parent, null, "MedicinalProductClinicals", (MedicinalProductClinicals)resource, -1);
        } else if (resource instanceof MedicinalProductDeviceSpec) {
            this.composeMedicinalProductDeviceSpec(parent, null, "MedicinalProductDeviceSpec", (MedicinalProductDeviceSpec)resource, -1);
        } else if (resource instanceof MedicinalProductIngredient) {
            this.composeMedicinalProductIngredient(parent, null, "MedicinalProductIngredient", (MedicinalProductIngredient)resource, -1);
        } else if (resource instanceof MedicinalProductPackaged) {
            this.composeMedicinalProductPackaged(parent, null, "MedicinalProductPackaged", (MedicinalProductPackaged)resource, -1);
        } else if (resource instanceof MedicinalProductPharmaceutical) {
            this.composeMedicinalProductPharmaceutical(parent, null, "MedicinalProductPharmaceutical", (MedicinalProductPharmaceutical)resource, -1);
        } else if (resource instanceof MessageDefinition) {
            this.composeMessageDefinition(parent, null, "MessageDefinition", (MessageDefinition)resource, -1);
        } else if (resource instanceof MessageHeader) {
            this.composeMessageHeader(parent, null, "MessageHeader", (MessageHeader)resource, -1);
        } else if (resource instanceof NamingSystem) {
            this.composeNamingSystem(parent, null, "NamingSystem", (NamingSystem)resource, -1);
        } else if (resource instanceof NutritionOrder) {
            this.composeNutritionOrder(parent, null, "NutritionOrder", (NutritionOrder)resource, -1);
        } else if (resource instanceof Observation) {
            this.composeObservation(parent, null, "Observation", (Observation)resource, -1);
        } else if (resource instanceof ObservationDefinition) {
            this.composeObservationDefinition(parent, null, "ObservationDefinition", (ObservationDefinition)resource, -1);
        } else if (resource instanceof OccupationalData) {
            this.composeOccupationalData(parent, null, "OccupationalData", (OccupationalData)resource, -1);
        } else if (resource instanceof OperationDefinition) {
            this.composeOperationDefinition(parent, null, "OperationDefinition", (OperationDefinition)resource, -1);
        } else if (resource instanceof OperationOutcome) {
            this.composeOperationOutcome(parent, null, "OperationOutcome", (OperationOutcome)resource, -1);
        } else if (resource instanceof Organization) {
            this.composeOrganization(parent, null, "Organization", (Organization)resource, -1);
        } else if (resource instanceof OrganizationRole) {
            this.composeOrganizationRole(parent, null, "OrganizationRole", (OrganizationRole)resource, -1);
        } else if (resource instanceof Patient) {
            this.composePatient(parent, null, "Patient", (Patient)resource, -1);
        } else if (resource instanceof PaymentNotice) {
            this.composePaymentNotice(parent, null, "PaymentNotice", (PaymentNotice)resource, -1);
        } else if (resource instanceof PaymentReconciliation) {
            this.composePaymentReconciliation(parent, null, "PaymentReconciliation", (PaymentReconciliation)resource, -1);
        } else if (resource instanceof Person) {
            this.composePerson(parent, null, "Person", (Person)resource, -1);
        } else if (resource instanceof PlanDefinition) {
            this.composePlanDefinition(parent, null, "PlanDefinition", (PlanDefinition)resource, -1);
        } else if (resource instanceof Practitioner) {
            this.composePractitioner(parent, null, "Practitioner", (Practitioner)resource, -1);
        } else if (resource instanceof PractitionerRole) {
            this.composePractitionerRole(parent, null, "PractitionerRole", (PractitionerRole)resource, -1);
        } else if (resource instanceof Procedure) {
            this.composeProcedure(parent, null, "Procedure", (Procedure)resource, -1);
        } else if (resource instanceof ProcessRequest) {
            this.composeProcessRequest(parent, null, "ProcessRequest", (ProcessRequest)resource, -1);
        } else if (resource instanceof ProcessResponse) {
            this.composeProcessResponse(parent, null, "ProcessResponse", (ProcessResponse)resource, -1);
        } else if (resource instanceof Provenance) {
            this.composeProvenance(parent, null, "Provenance", (Provenance)resource, -1);
        } else if (resource instanceof Questionnaire) {
            this.composeQuestionnaire(parent, null, "Questionnaire", (Questionnaire)resource, -1);
        } else if (resource instanceof QuestionnaireResponse) {
            this.composeQuestionnaireResponse(parent, null, "QuestionnaireResponse", (QuestionnaireResponse)resource, -1);
        } else if (resource instanceof RelatedPerson) {
            this.composeRelatedPerson(parent, null, "RelatedPerson", (RelatedPerson)resource, -1);
        } else if (resource instanceof RequestGroup) {
            this.composeRequestGroup(parent, null, "RequestGroup", (RequestGroup)resource, -1);
        } else if (resource instanceof ResearchStudy) {
            this.composeResearchStudy(parent, null, "ResearchStudy", (ResearchStudy)resource, -1);
        } else if (resource instanceof ResearchSubject) {
            this.composeResearchSubject(parent, null, "ResearchSubject", (ResearchSubject)resource, -1);
        } else if (resource instanceof RiskAssessment) {
            this.composeRiskAssessment(parent, null, "RiskAssessment", (RiskAssessment)resource, -1);
        } else if (resource instanceof Schedule) {
            this.composeSchedule(parent, null, "Schedule", (Schedule)resource, -1);
        } else if (resource instanceof SearchParameter) {
            this.composeSearchParameter(parent, null, "SearchParameter", (SearchParameter)resource, -1);
        } else if (resource instanceof Sequence) {
            this.composeSequence(parent, null, "Sequence", (Sequence)resource, -1);
        } else if (resource instanceof ServiceRequest) {
            this.composeServiceRequest(parent, null, "ServiceRequest", (ServiceRequest)resource, -1);
        } else if (resource instanceof Slot) {
            this.composeSlot(parent, null, "Slot", (Slot)resource, -1);
        } else if (resource instanceof Specimen) {
            this.composeSpecimen(parent, null, "Specimen", (Specimen)resource, -1);
        } else if (resource instanceof SpecimenDefinition) {
            this.composeSpecimenDefinition(parent, null, "SpecimenDefinition", (SpecimenDefinition)resource, -1);
        } else if (resource instanceof StructureDefinition) {
            this.composeStructureDefinition(parent, null, "StructureDefinition", (StructureDefinition)resource, -1);
        } else if (resource instanceof StructureMap) {
            this.composeStructureMap(parent, null, "StructureMap", (StructureMap)resource, -1);
        } else if (resource instanceof Subscription) {
            this.composeSubscription(parent, null, "Subscription", (Subscription)resource, -1);
        } else if (resource instanceof Substance) {
            this.composeSubstance(parent, null, "Substance", (Substance)resource, -1);
        } else if (resource instanceof SubstancePolymer) {
            this.composeSubstancePolymer(parent, null, "SubstancePolymer", (SubstancePolymer)resource, -1);
        } else if (resource instanceof SubstanceReferenceInformation) {
            this.composeSubstanceReferenceInformation(parent, null, "SubstanceReferenceInformation", (SubstanceReferenceInformation)resource, -1);
        } else if (resource instanceof SubstanceSpecification) {
            this.composeSubstanceSpecification(parent, null, "SubstanceSpecification", (SubstanceSpecification)resource, -1);
        } else if (resource instanceof SupplyDelivery) {
            this.composeSupplyDelivery(parent, null, "SupplyDelivery", (SupplyDelivery)resource, -1);
        } else if (resource instanceof SupplyRequest) {
            this.composeSupplyRequest(parent, null, "SupplyRequest", (SupplyRequest)resource, -1);
        } else if (resource instanceof Task) {
            this.composeTask(parent, null, "Task", (Task)resource, -1);
        } else if (resource instanceof TerminologyCapabilities) {
            this.composeTerminologyCapabilities(parent, null, "TerminologyCapabilities", (TerminologyCapabilities)resource, -1);
        } else if (resource instanceof TestReport) {
            this.composeTestReport(parent, null, "TestReport", (TestReport)resource, -1);
        } else if (resource instanceof TestScript) {
            this.composeTestScript(parent, null, "TestScript", (TestScript)resource, -1);
        } else if (resource instanceof UserSession) {
            this.composeUserSession(parent, null, "UserSession", (UserSession)resource, -1);
        } else if (resource instanceof ValueSet) {
            this.composeValueSet(parent, null, "ValueSet", (ValueSet)resource, -1);
        } else if (resource instanceof VerificationResult) {
            this.composeVerificationResult(parent, null, "VerificationResult", (VerificationResult)resource, -1);
        } else if (resource instanceof VisionPrescription) {
            this.composeVisionPrescription(parent, null, "VisionPrescription", (VisionPrescription)resource, -1);
        } else {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
    }

    protected void composeType(Turtle.Complex parent, String parentType, String name, Type value, int index) {
        if (value == null) {
            return;
        }
        if (value instanceof DateType) {
            this.composeDate(parent, parentType, name, (DateType)value, index);
        } else if (value instanceof DateTimeType) {
            this.composeDateTime(parent, parentType, name, (DateTimeType)value, index);
        } else if (value instanceof CodeType) {
            this.composeCode(parent, parentType, name, (CodeType)value, index);
        } else if (value instanceof StringType) {
            this.composeString(parent, parentType, name, (StringType)value, index);
        } else if (value instanceof IntegerType) {
            this.composeInteger(parent, parentType, name, (IntegerType)value, index);
        } else if (value instanceof OidType) {
            this.composeOid(parent, parentType, name, (OidType)value, index);
        } else if (value instanceof CanonicalType) {
            this.composeCanonical(parent, parentType, name, (CanonicalType)value, index);
        } else if (value instanceof UriType) {
            this.composeUri(parent, parentType, name, (UriType)value, index);
        } else if (value instanceof UuidType) {
            this.composeUuid(parent, parentType, name, (UuidType)value, index);
        } else if (value instanceof UrlType) {
            this.composeUrl(parent, parentType, name, (UrlType)value, index);
        } else if (value instanceof InstantType) {
            this.composeInstant(parent, parentType, name, (InstantType)value, index);
        } else if (value instanceof BooleanType) {
            this.composeBoolean(parent, parentType, name, (BooleanType)value, index);
        } else if (value instanceof Base64BinaryType) {
            this.composeBase64Binary(parent, parentType, name, (Base64BinaryType)value, index);
        } else if (value instanceof UnsignedIntType) {
            this.composeUnsignedInt(parent, parentType, name, (UnsignedIntType)value, index);
        } else if (value instanceof MarkdownType) {
            this.composeMarkdown(parent, parentType, name, (MarkdownType)value, index);
        } else if (value instanceof TimeType) {
            this.composeTime(parent, parentType, name, (TimeType)value, index);
        } else if (value instanceof IdType) {
            this.composeId(parent, parentType, name, (IdType)value, index);
        } else if (value instanceof PositiveIntType) {
            this.composePositiveInt(parent, parentType, name, (PositiveIntType)value, index);
        } else if (value instanceof DecimalType) {
            this.composeDecimal(parent, parentType, name, (DecimalType)value, index);
        } else if (value instanceof Extension) {
            this.composeExtension(parent, parentType, name, (Extension)value, index);
        } else if (value instanceof Narrative) {
            this.composeNarrative(parent, parentType, name, (Narrative)value, index);
        } else if (value instanceof Meta) {
            this.composeMeta(parent, parentType, name, (Meta)value, index);
        } else if (value instanceof Address) {
            this.composeAddress(parent, parentType, name, (Address)value, index);
        } else if (value instanceof Contributor) {
            this.composeContributor(parent, parentType, name, (Contributor)value, index);
        } else if (value instanceof Attachment) {
            this.composeAttachment(parent, parentType, name, (Attachment)value, index);
        } else if (value instanceof Count) {
            this.composeCount(parent, parentType, name, (Count)value, index);
        } else if (value instanceof DataRequirement) {
            this.composeDataRequirement(parent, parentType, name, (DataRequirement)value, index);
        } else if (value instanceof Dosage) {
            this.composeDosage(parent, parentType, name, (Dosage)value, index);
        } else if (value instanceof Money) {
            this.composeMoney(parent, parentType, name, (Money)value, index);
        } else if (value instanceof HumanName) {
            this.composeHumanName(parent, parentType, name, (HumanName)value, index);
        } else if (value instanceof ContactPoint) {
            this.composeContactPoint(parent, parentType, name, (ContactPoint)value, index);
        } else if (value instanceof Identifier) {
            this.composeIdentifier(parent, parentType, name, (Identifier)value, index);
        } else if (value instanceof Coding) {
            this.composeCoding(parent, parentType, name, (Coding)value, index);
        } else if (value instanceof SampledData) {
            this.composeSampledData(parent, parentType, name, (SampledData)value, index);
        } else if (value instanceof Ratio) {
            this.composeRatio(parent, parentType, name, (Ratio)value, index);
        } else if (value instanceof Distance) {
            this.composeDistance(parent, parentType, name, (Distance)value, index);
        } else if (value instanceof Age) {
            this.composeAge(parent, parentType, name, (Age)value, index);
        } else if (value instanceof Reference) {
            this.composeReference(parent, parentType, name, (Reference)value, index);
        } else if (value instanceof TriggerDefinition) {
            this.composeTriggerDefinition(parent, parentType, name, (TriggerDefinition)value, index);
        } else if (value instanceof Quantity) {
            this.composeQuantity(parent, parentType, name, (Quantity)value, index);
        } else if (value instanceof Period) {
            this.composePeriod(parent, parentType, name, (Period)value, index);
        } else if (value instanceof Duration) {
            this.composeDuration(parent, parentType, name, (Duration)value, index);
        } else if (value instanceof Range) {
            this.composeRange(parent, parentType, name, (Range)value, index);
        } else if (value instanceof RelatedArtifact) {
            this.composeRelatedArtifact(parent, parentType, name, (RelatedArtifact)value, index);
        } else if (value instanceof Annotation) {
            this.composeAnnotation(parent, parentType, name, (Annotation)value, index);
        } else if (value instanceof ContactDetail) {
            this.composeContactDetail(parent, parentType, name, (ContactDetail)value, index);
        } else if (value instanceof UsageContext) {
            this.composeUsageContext(parent, parentType, name, (UsageContext)value, index);
        } else if (value instanceof Signature) {
            this.composeSignature(parent, parentType, name, (Signature)value, index);
        } else if (value instanceof Timing) {
            this.composeTiming(parent, parentType, name, (Timing)value, index);
        } else if (value instanceof CodeableConcept) {
            this.composeCodeableConcept(parent, parentType, name, (CodeableConcept)value, index);
        } else if (value instanceof ParameterDefinition) {
            this.composeParameterDefinition(parent, parentType, name, (ParameterDefinition)value, index);
        } else {
            throw new Error("Unhandled type");
        }
    }
}

