/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Consent", profile="http://hl7.org/fhir/Profile/Consent")
public class Consent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for this record (external references)", formalDefinition="Unique identifier for this copy of the Consent Statement.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | proposed | active | rejected | inactive | entered-in-error", formalDefinition="Indicates the current state of this consent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<ConsentState> status;
    @Child(name="scope", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Which of the four areas this resource covers (extensible)", formalDefinition="A selector of the type of consent being presented: ADR, Privacy, Treatment, Research.  This list is now extensible.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-scope")
    protected CodeableConcept scope;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the consent statement - for indexing/retrieval", formalDefinition="A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-category")
    protected List<CodeableConcept> category;
    @Child(name="patient", type={Patient.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the consent applies to", formalDefinition="The patient/healthcare consumer to whom this consent applies.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="dateTime", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this Consent was created or indexed", formalDefinition="When this  Consent was issued / created / indexed.")
    protected DateTimeType dateTime;
    @Child(name="performer", type={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is agreeing to the policy and rules", formalDefinition="Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.")
    protected List<Reference> performer;
    protected List<Resource> performerTarget;
    @Child(name="organization", type={Organization.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Custodian of the consent", formalDefinition="The organization that manages the consent, and the framework within which it is executed.")
    protected List<Reference> organization;
    protected List<Organization> organizationTarget;
    @Child(name="source", type={Attachment.class, Identifier.class, Consent.class, DocumentReference.class, Contract.class, QuestionnaireResponse.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Source from which this consent is taken", formalDefinition="The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.")
    protected Type source;
    @Child(name="policy", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Policies covered by this consent", formalDefinition="The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.")
    protected List<ConsentPolicyComponent> policy;
    @Child(name="policyRule", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Regulation that this consents to", formalDefinition="A reference to the specific base computable regulation or policy.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-policy")
    protected CodeableConcept policyRule;
    @Child(name="verification", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Consent Verified by patient or family", formalDefinition="Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.")
    protected List<ConsentVerificationComponent> verification;
    @Child(name="provision", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Constraints to the base Consent.policyRule", formalDefinition="An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.")
    protected provisionComponent provision;
    private static final long serialVersionUID = 206528051L;
    @SearchParamDefinition(name="date", path="Consent.dateTime", description="When this Consent was created or indexed", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Consent.identifier", description="Identifier for this record (external references)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="securitylabel", path="Consent.provision.securityLabel", description="Security Labels that define affected resources", type="token")
    public static final String SP_SECURITYLABEL = "securitylabel";
    public static final TokenClientParam SECURITYLABEL = new TokenClientParam("securitylabel");
    @SearchParamDefinition(name="period", path="Consent.provision.period", description="Timeframe for this rule", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="data", path="Consent.provision.data.reference", description="The actual data reference", type="reference")
    public static final String SP_DATA = "data";
    public static final ReferenceClientParam DATA = new ReferenceClientParam("data");
    public static final Include INCLUDE_DATA = new Include("Consent:data").toLocked();
    @SearchParamDefinition(name="purpose", path="Consent.provision.purpose", description="Context of activities covered by this rule", type="token")
    public static final String SP_PURPOSE = "purpose";
    public static final TokenClientParam PURPOSE = new TokenClientParam("purpose");
    @SearchParamDefinition(name="source-reference", path="Consent.source", description="Search by reference to a Consent, DocumentReference, Contract  or QuestionnaireResponse", type="reference", target={Consent.class, Contract.class, DocumentReference.class, QuestionnaireResponse.class})
    public static final String SP_SOURCE_REFERENCE = "source-reference";
    public static final ReferenceClientParam SOURCE_REFERENCE = new ReferenceClientParam("source-reference");
    public static final Include INCLUDE_SOURCE_REFERENCE = new Include("Consent:source-reference").toLocked();
    @SearchParamDefinition(name="source-identifier", path="Consent.source", description="Search by token to an identifier", type="token")
    public static final String SP_SOURCE_IDENTIFIER = "source-identifier";
    public static final TokenClientParam SOURCE_IDENTIFIER = new TokenClientParam("source-identifier");
    @SearchParamDefinition(name="actor", path="Consent.provision.actor.reference", description="Resource for the actor (or group, by role)", type="reference", target={CareTeam.class, Device.class, Group.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Consent:actor").toLocked();
    @SearchParamDefinition(name="patient", path="Consent.patient", description="Who the consent applies to", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Consent:patient").toLocked();
    @SearchParamDefinition(name="organization", path="Consent.organization", description="Custodian of the consent", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Consent:organization").toLocked();
    @SearchParamDefinition(name="scope", path="Consent.scope", description="Which of the four areas this resource covers (extensible)", type="token")
    public static final String SP_SCOPE = "scope";
    public static final TokenClientParam SCOPE = new TokenClientParam("scope");
    @SearchParamDefinition(name="action", path="Consent.provision.action", description="Actions controlled by this rule", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="consentor", path="Consent.performer", description="Who is agreeing to the policy and rules", type="reference", target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_CONSENTOR = "consentor";
    public static final ReferenceClientParam CONSENTOR = new ReferenceClientParam("consentor");
    public static final Include INCLUDE_CONSENTOR = new Include("Consent:consentor").toLocked();
    @SearchParamDefinition(name="category", path="Consent.category", description="Classification of the consent statement - for indexing/retrieval", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="Consent.status", description="draft | proposed | active | rejected | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Consent() {
    }

    public Consent(Enumeration<ConsentState> status, CodeableConcept scope) {
        this.status = status;
        this.scope = scope;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Consent setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Consent addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ConsentState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Consent setStatusElement(Enumeration<ConsentState> value) {
        this.status = value;
        return this;
    }

    public ConsentState getStatus() {
        return this.status == null ? null : (ConsentState)((Object)this.status.getValue());
    }

    public Consent setStatus(ConsentState value) {
        if (this.status == null) {
            this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getScope() {
        if (this.scope == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.scope");
            }
            if (Configuration.doAutoCreate()) {
                this.scope = new CodeableConcept();
            }
        }
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null && !this.scope.isEmpty();
    }

    public Consent setScope(CodeableConcept value) {
        this.scope = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Consent setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Consent addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Consent setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Consent setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getDateTimeElement() {
        if (this.dateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.dateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.dateTime = new DateTimeType();
            }
        }
        return this.dateTime;
    }

    public boolean hasDateTimeElement() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public boolean hasDateTime() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public Consent setDateTimeElement(DateTimeType value) {
        this.dateTime = value;
        return this;
    }

    public Date getDateTime() {
        return this.dateTime == null ? null : (Date)this.dateTime.getValue();
    }

    public Consent setDateTime(Date value) {
        if (value == null) {
            this.dateTime = null;
        } else {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Consent setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public Consent addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    @Deprecated
    public List<Resource> getPerformerTarget() {
        if (this.performerTarget == null) {
            this.performerTarget = new ArrayList<Resource>();
        }
        return this.performerTarget;
    }

    public List<Reference> getOrganization() {
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        return this.organization;
    }

    public Consent setOrganization(List<Reference> theOrganization) {
        this.organization = theOrganization;
        return this;
    }

    public boolean hasOrganization() {
        if (this.organization == null) {
            return false;
        }
        for (Reference item : this.organization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addOrganization() {
        Reference t = new Reference();
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        this.organization.add(t);
        return t;
    }

    public Consent addOrganization(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        this.organization.add(t);
        return this;
    }

    public Reference getOrganizationFirstRep() {
        if (this.getOrganization().isEmpty()) {
            this.addOrganization();
        }
        return this.getOrganization().get(0);
    }

    @Deprecated
    public List<Organization> getOrganizationTarget() {
        if (this.organizationTarget == null) {
            this.organizationTarget = new ArrayList<Organization>();
        }
        return this.organizationTarget;
    }

    @Deprecated
    public Organization addOrganizationTarget() {
        Organization r = new Organization();
        if (this.organizationTarget == null) {
            this.organizationTarget = new ArrayList<Organization>();
        }
        this.organizationTarget.add(r);
        return r;
    }

    public Type getSource() {
        return this.source;
    }

    public Attachment getSourceAttachment() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Attachment)this.source;
    }

    public boolean hasSourceAttachment() {
        return this != null && this.source instanceof Attachment;
    }

    public Identifier getSourceIdentifier() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Identifier)this.source;
    }

    public boolean hasSourceIdentifier() {
        return this != null && this.source instanceof Identifier;
    }

    public Reference getSourceReference() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Reference)this.source;
    }

    public boolean hasSourceReference() {
        return this != null && this.source instanceof Reference;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public Consent setSource(Type value) {
        if (!(value == null || value instanceof Attachment || value instanceof Identifier || value instanceof Reference)) {
            throw new Error("Not the right type for Consent.source[x]: " + value.fhirType());
        }
        this.source = value;
        return this;
    }

    public List<ConsentPolicyComponent> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        return this.policy;
    }

    public Consent setPolicy(List<ConsentPolicyComponent> thePolicy) {
        this.policy = thePolicy;
        return this;
    }

    public boolean hasPolicy() {
        if (this.policy == null) {
            return false;
        }
        for (ConsentPolicyComponent item : this.policy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentPolicyComponent addPolicy() {
        ConsentPolicyComponent t = new ConsentPolicyComponent();
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        this.policy.add(t);
        return t;
    }

    public Consent addPolicy(ConsentPolicyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        this.policy.add(t);
        return this;
    }

    public ConsentPolicyComponent getPolicyFirstRep() {
        if (this.getPolicy().isEmpty()) {
            this.addPolicy();
        }
        return this.getPolicy().get(0);
    }

    public CodeableConcept getPolicyRule() {
        if (this.policyRule == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.policyRule");
            }
            if (Configuration.doAutoCreate()) {
                this.policyRule = new CodeableConcept();
            }
        }
        return this.policyRule;
    }

    public boolean hasPolicyRule() {
        return this.policyRule != null && !this.policyRule.isEmpty();
    }

    public Consent setPolicyRule(CodeableConcept value) {
        this.policyRule = value;
        return this;
    }

    public List<ConsentVerificationComponent> getVerification() {
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        return this.verification;
    }

    public Consent setVerification(List<ConsentVerificationComponent> theVerification) {
        this.verification = theVerification;
        return this;
    }

    public boolean hasVerification() {
        if (this.verification == null) {
            return false;
        }
        for (ConsentVerificationComponent item : this.verification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentVerificationComponent addVerification() {
        ConsentVerificationComponent t = new ConsentVerificationComponent();
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        this.verification.add(t);
        return t;
    }

    public Consent addVerification(ConsentVerificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        this.verification.add(t);
        return this;
    }

    public ConsentVerificationComponent getVerificationFirstRep() {
        if (this.getVerification().isEmpty()) {
            this.addVerification();
        }
        return this.getVerification().get(0);
    }

    public provisionComponent getProvision() {
        if (this.provision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.provision");
            }
            if (Configuration.doAutoCreate()) {
                this.provision = new provisionComponent();
            }
        }
        return this.provision;
    }

    public boolean hasProvision() {
        return this.provision != null && !this.provision.isEmpty();
    }

    public Consent setProvision(provisionComponent value) {
        this.provision = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates the current state of this consent.", 0, 1, this.status));
        children.add(new Property(SP_SCOPE, "CodeableConcept", "A selector of the type of consent being presented: ADR, Privacy, Treatment, Research.  This list is now extensible.", 0, 1, this.scope));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient/healthcare consumer to whom this consent applies.", 0, 1, this.patient));
        children.add(new Property("dateTime", "dateTime", "When this  Consent was issued / created / indexed.", 0, 1, this.dateTime));
        children.add(new Property("performer", "Reference(Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization that manages the consent, and the framework within which it is executed.", 0, Integer.MAX_VALUE, this.organization));
        children.add(new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source));
        children.add(new Property("policy", "", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, Integer.MAX_VALUE, this.policy));
        children.add(new Property("policyRule", "CodeableConcept", "A reference to the specific base computable regulation or policy.", 0, 1, this.policyRule));
        children.add(new Property("verification", "", "Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.", 0, Integer.MAX_VALUE, this.verification));
        children.add(new Property("provision", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, 1, this.provision));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current state of this consent.", 0, 1, this.status);
            }
            case 109264468: {
                return new Property(SP_SCOPE, "CodeableConcept", "A selector of the type of consent being presented: ADR, Privacy, Treatment, Research.  This list is now extensible.", 0, 1, this.scope);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient/healthcare consumer to whom this consent applies.", 0, 1, this.patient);
            }
            case 1792749467: {
                return new Property("dateTime", "dateTime", "When this  Consent was issued / created / indexed.", 0, 1, this.dateTime);
            }
            case 481140686: {
                return new Property("performer", "Reference(Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization that manages the consent, and the framework within which it is executed.", 0, Integer.MAX_VALUE, this.organization);
            }
            case -1698413947: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -896505829: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case 1964406686: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -1985492188: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -244259472: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -982670030: {
                return new Property("policy", "", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, Integer.MAX_VALUE, this.policy);
            }
            case 1593493326: {
                return new Property("policyRule", "CodeableConcept", "A reference to the specific base computable regulation or policy.", 0, 1, this.policyRule);
            }
            case -1484401125: {
                return new Property("verification", "", "Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.", 0, Integer.MAX_VALUE, this.verification);
            }
            case -547120939: {
                return new Property("provision", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, 1, this.provision);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 109264468: {
                Base[] baseArray;
                if (this.scope == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.scope;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 1792749467: {
                Base[] baseArray;
                if (this.dateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.dateTime;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1178922291: {
                return this.organization == null ? new Base[]{} : this.organization.toArray(new Base[this.organization.size()]);
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.source;
                }
                return baseArray;
            }
            case -982670030: {
                return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
            }
            case 1593493326: {
                Base[] baseArray;
                if (this.policyRule == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.policyRule;
                }
                return baseArray;
            }
            case -1484401125: {
                return this.verification == null ? new Base[]{} : this.verification.toArray(new Base[this.verification.size()]);
            }
            case -547120939: {
                Base[] baseArray;
                if (this.provision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.provision;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ConsentStateEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 109264468: {
                this.scope = this.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 1792749467: {
                this.dateTime = this.castToDateTime(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(this.castToReference(value));
                return value;
            }
            case 1178922291: {
                this.getOrganization().add(this.castToReference(value));
                return value;
            }
            case -896505829: {
                this.source = this.castToType(value);
                return value;
            }
            case -982670030: {
                this.getPolicy().add((ConsentPolicyComponent)((Object)value));
                return value;
            }
            case 1593493326: {
                this.policyRule = this.castToCodeableConcept(value);
                return value;
            }
            case -1484401125: {
                this.getVerification().add((ConsentVerificationComponent)((Object)value));
                return value;
            }
            case -547120939: {
                this.provision = (provisionComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ConsentStateEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SCOPE)) {
            this.scope = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("dateTime")) {
            this.dateTime = this.castToDateTime(value);
        } else if (name.equals("performer")) {
            this.getPerformer().add(this.castToReference(value));
        } else if (name.equals(SP_ORGANIZATION)) {
            this.getOrganization().add(this.castToReference(value));
        } else if (name.equals("source[x]")) {
            this.source = this.castToType(value);
        } else if (name.equals("policy")) {
            this.getPolicy().add((ConsentPolicyComponent)((Object)value));
        } else if (name.equals("policyRule")) {
            this.policyRule = this.castToCodeableConcept(value);
        } else if (name.equals("verification")) {
            this.getVerification().add((ConsentVerificationComponent)((Object)value));
        } else if (name.equals("provision")) {
            this.provision = (provisionComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 109264468: {
                return this.getScope();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1792749467: {
                return this.getDateTimeElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1178922291: {
                return this.addOrganization();
            }
            case -1698413947: {
                return this.getSource();
            }
            case -896505829: {
                return this.getSource();
            }
            case -982670030: {
                return this.addPolicy();
            }
            case 1593493326: {
                return this.getPolicyRule();
            }
            case -1484401125: {
                return this.addVerification();
            }
            case -547120939: {
                return this.getProvision();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 109264468: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1792749467: {
                return new String[]{"dateTime"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case -896505829: {
                return new String[]{"Attachment", "Identifier", "Reference"};
            }
            case -982670030: {
                return new String[0];
            }
            case 1593493326: {
                return new String[]{"CodeableConcept"};
            }
            case -1484401125: {
                return new String[0];
            }
            case -547120939: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Consent.status");
        }
        if (name.equals(SP_SCOPE)) {
            this.scope = new CodeableConcept();
            return this.scope;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("dateTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type Consent.dateTime");
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals(SP_ORGANIZATION)) {
            return this.addOrganization();
        }
        if (name.equals("sourceAttachment")) {
            this.source = new Attachment();
            return this.source;
        }
        if (name.equals("sourceIdentifier")) {
            this.source = new Identifier();
            return this.source;
        }
        if (name.equals("sourceReference")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("policy")) {
            return this.addPolicy();
        }
        if (name.equals("policyRule")) {
            this.policyRule = new CodeableConcept();
            return this.policyRule;
        }
        if (name.equals("verification")) {
            return this.addVerification();
        }
        if (name.equals("provision")) {
            this.provision = new provisionComponent();
            return this.provision;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Consent";
    }

    @Override
    public Consent copy() {
        Consent dst = new Consent();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.scope = this.scope == null ? null : this.scope.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        DateTimeType dateTimeType = dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference : this.performer) {
                dst.performer.add(reference.copy());
            }
        }
        if (this.organization != null) {
            dst.organization = new ArrayList<Reference>();
            for (Reference reference : this.organization) {
                dst.organization.add(reference.copy());
            }
        }
        Type type = dst.source = this.source == null ? null : this.source.copy();
        if (this.policy != null) {
            dst.policy = new ArrayList<ConsentPolicyComponent>();
            for (ConsentPolicyComponent consentPolicyComponent : this.policy) {
                dst.policy.add(consentPolicyComponent.copy());
            }
        }
        CodeableConcept codeableConcept3 = dst.policyRule = this.policyRule == null ? null : this.policyRule.copy();
        if (this.verification != null) {
            dst.verification = new ArrayList<ConsentVerificationComponent>();
            for (ConsentVerificationComponent consentVerificationComponent : this.verification) {
                dst.verification.add(consentVerificationComponent.copy());
            }
        }
        dst.provision = this.provision == null ? null : this.provision.copy();
        return dst;
    }

    protected Consent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareDeep(this.identifier, o.identifier, true) && Consent.compareDeep(this.status, o.status, true) && Consent.compareDeep(this.scope, o.scope, true) && Consent.compareDeep(this.category, o.category, true) && Consent.compareDeep(this.patient, o.patient, true) && Consent.compareDeep(this.dateTime, o.dateTime, true) && Consent.compareDeep(this.performer, o.performer, true) && Consent.compareDeep(this.organization, o.organization, true) && Consent.compareDeep(this.source, o.source, true) && Consent.compareDeep(this.policy, o.policy, true) && Consent.compareDeep(this.policyRule, o.policyRule, true) && Consent.compareDeep(this.verification, o.verification, true) && Consent.compareDeep(this.provision, o.provision, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareValues(this.status, o.status, true) && Consent.compareValues(this.dateTime, o.dateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.scope, this.category, this.patient, this.dateTime, this.performer, this.organization, this.source, this.policy, this.policyRule, this.verification, this.provision});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Consent;
    }

    @Block
    public static class provisionDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="meaning", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="instance | related | dependents | authoredby", formalDefinition="How the resource reference is interpreted when testing consent restrictions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning")
        protected Enumeration<ConsentDataMeaning> meaning;
        @Child(name="reference", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual data reference", formalDefinition="A reference to a specific resource that defines which resources are covered by this consent.")
        protected Reference reference;
        protected Resource referenceTarget;
        private static final long serialVersionUID = -424898645L;

        public provisionDataComponent() {
        }

        public provisionDataComponent(Enumeration<ConsentDataMeaning> meaning, Reference reference) {
            this.meaning = meaning;
            this.reference = reference;
        }

        public Enumeration<ConsentDataMeaning> getMeaningElement() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionDataComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
                }
            }
            return this.meaning;
        }

        public boolean hasMeaningElement() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public provisionDataComponent setMeaningElement(Enumeration<ConsentDataMeaning> value) {
            this.meaning = value;
            return this;
        }

        public ConsentDataMeaning getMeaning() {
            return this.meaning == null ? null : (ConsentDataMeaning)((Object)this.meaning.getValue());
        }

        public provisionDataComponent setMeaning(ConsentDataMeaning value) {
            if (this.meaning == null) {
                this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
            }
            this.meaning.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionDataComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public provisionDataComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public provisionDataComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning));
            children.add(new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938160637: {
                    return new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    Base[] baseArray;
                    if (this.meaning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.meaning;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    value = new ConsentDataMeaningEnumFactory().fromType(this.castToCode(value));
                    this.meaning = value;
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("meaning")) {
                value = new ConsentDataMeaningEnumFactory().fromType(this.castToCode(value));
                this.meaning = value;
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return this.getMeaningElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("meaning")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.meaning");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public provisionDataComponent copy() {
            provisionDataComponent dst = new provisionDataComponent();
            this.copyValues(dst);
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof provisionDataComponent)) {
                return false;
            }
            provisionDataComponent o = (provisionDataComponent)other_;
            return provisionDataComponent.compareDeep(this.meaning, o.meaning, true) && provisionDataComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof provisionDataComponent)) {
                return false;
            }
            provisionDataComponent o = (provisionDataComponent)other_;
            return provisionDataComponent.compareValues(this.meaning, o.meaning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.provision.data";
        }
    }

    @Block
    public static class provisionActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the actor is involved", formalDefinition="How the individual is involved in the resources content that is described in the exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected CodeableConcept role;
        @Child(name="reference", type={Device.class, Group.class, CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource for the actor (or group, by role)", formalDefinition="The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected Reference reference;
        protected Resource referenceTarget;
        private static final long serialVersionUID = 1152919415L;

        public provisionActorComponent() {
        }

        public provisionActorComponent(CodeableConcept role, Reference reference) {
            this.role = role;
            this.reference = reference;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionActorComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public provisionActorComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionActorComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public provisionActorComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public provisionActorComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public provisionActorComponent copy() {
            provisionActorComponent dst = new provisionActorComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof provisionActorComponent)) {
                return false;
            }
            provisionActorComponent o = (provisionActorComponent)other_;
            return provisionActorComponent.compareDeep(this.role, o.role, true) && provisionActorComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof provisionActorComponent)) {
                return false;
            }
            provisionActorComponent o = (provisionActorComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.provision.actor";
        }
    }

    @Block
    public static class provisionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="deny | permit", formalDefinition="Action  to take - permit or deny - when the rule conditions are met.  Not permitted in root rule, required in all nested rules.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-provision-type")
        protected Enumeration<ConsentProvisionType> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for this rule", formalDefinition="The timeframe in this rule is valid.")
        protected Period period;
        @Child(name="actor", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who|what controlled by this rule (or group, by role)", formalDefinition="Who or what is controlled by this rule. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected List<provisionActorComponent> actor;
        @Child(name="action", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Actions controlled by this rule", formalDefinition="Actions controlled by this Rule.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-action")
        protected List<CodeableConcept> action;
        @Child(name="securityLabel", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Security Labels that define affected resources", formalDefinition="A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        protected List<Coding> securityLabel;
        @Child(name="purpose", type={Coding.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Context of activities covered by this rule", formalDefinition="The context of the activities a user is taking - why the user is accessing the data - that are controlled by this rule.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-PurposeOfUse")
        protected List<Coding> purpose;
        @Child(name="class", type={Coding.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. Resource Type, Profile, CDA, etc.", formalDefinition="The class of information covered by this rule. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
        protected List<Coding> class_;
        @Child(name="code", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. LOINC or SNOMED CT code, etc. in the content", formalDefinition="If this code is found in an instance, then the rule applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-code")
        protected List<CodeableConcept> code;
        @Child(name="dataPeriod", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for data controlled by this rule", formalDefinition="Clinical or Operational Relevant period of time that bounds the data controlled by this rule.")
        protected Period dataPeriod;
        @Child(name="data", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Data controlled by this rule", formalDefinition="The resources controlled by this rule if specific resources are referenced.")
        protected List<provisionDataComponent> data;
        @Child(name="provision", type={provisionComponent.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Exception Rules", formalDefinition="Rules which provide exceptions to the base rule or subrules.")
        protected List<provisionComponent> provision;
        private static final long serialVersionUID = -1280172451L;

        public Enumeration<ConsentProvisionType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConsentProvisionType>(new ConsentProvisionTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public provisionComponent setTypeElement(Enumeration<ConsentProvisionType> value) {
            this.type = value;
            return this;
        }

        public ConsentProvisionType getType() {
            return this.type == null ? null : (ConsentProvisionType)((Object)this.type.getValue());
        }

        public provisionComponent setType(ConsentProvisionType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<ConsentProvisionType>(new ConsentProvisionTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public provisionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<provisionActorComponent> getActor() {
            if (this.actor == null) {
                this.actor = new ArrayList<provisionActorComponent>();
            }
            return this.actor;
        }

        public provisionComponent setActor(List<provisionActorComponent> theActor) {
            this.actor = theActor;
            return this;
        }

        public boolean hasActor() {
            if (this.actor == null) {
                return false;
            }
            for (provisionActorComponent item : this.actor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public provisionActorComponent addActor() {
            provisionActorComponent t = new provisionActorComponent();
            if (this.actor == null) {
                this.actor = new ArrayList<provisionActorComponent>();
            }
            this.actor.add(t);
            return t;
        }

        public provisionComponent addActor(provisionActorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.actor == null) {
                this.actor = new ArrayList<provisionActorComponent>();
            }
            this.actor.add(t);
            return this;
        }

        public provisionActorComponent getActorFirstRep() {
            if (this.getActor().isEmpty()) {
                this.addActor();
            }
            return this.getActor().get(0);
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public provisionComponent setAction(List<CodeableConcept> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public provisionComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public CodeableConcept getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public provisionComponent setSecurityLabel(List<Coding> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public provisionComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public Coding getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public List<Coding> getPurpose() {
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            return this.purpose;
        }

        public provisionComponent setPurpose(List<Coding> thePurpose) {
            this.purpose = thePurpose;
            return this;
        }

        public boolean hasPurpose() {
            if (this.purpose == null) {
                return false;
            }
            for (Coding item : this.purpose) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPurpose() {
            Coding t = new Coding();
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return t;
        }

        public provisionComponent addPurpose(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return this;
        }

        public Coding getPurposeFirstRep() {
            if (this.getPurpose().isEmpty()) {
                this.addPurpose();
            }
            return this.getPurpose().get(0);
        }

        public List<Coding> getClass_() {
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            return this.class_;
        }

        public provisionComponent setClass_(List<Coding> theClass_) {
            this.class_ = theClass_;
            return this;
        }

        public boolean hasClass_() {
            if (this.class_ == null) {
                return false;
            }
            for (Coding item : this.class_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addClass_() {
            Coding t = new Coding();
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            this.class_.add(t);
            return t;
        }

        public provisionComponent addClass_(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            this.class_.add(t);
            return this;
        }

        public Coding getClass_FirstRep() {
            if (this.getClass_().isEmpty()) {
                this.addClass_();
            }
            return this.getClass_().get(0);
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public provisionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public provisionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public Period getDataPeriod() {
            if (this.dataPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create provisionComponent.dataPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataPeriod = new Period();
                }
            }
            return this.dataPeriod;
        }

        public boolean hasDataPeriod() {
            return this.dataPeriod != null && !this.dataPeriod.isEmpty();
        }

        public provisionComponent setDataPeriod(Period value) {
            this.dataPeriod = value;
            return this;
        }

        public List<provisionDataComponent> getData() {
            if (this.data == null) {
                this.data = new ArrayList<provisionDataComponent>();
            }
            return this.data;
        }

        public provisionComponent setData(List<provisionDataComponent> theData) {
            this.data = theData;
            return this;
        }

        public boolean hasData() {
            if (this.data == null) {
                return false;
            }
            for (provisionDataComponent item : this.data) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public provisionDataComponent addData() {
            provisionDataComponent t = new provisionDataComponent();
            if (this.data == null) {
                this.data = new ArrayList<provisionDataComponent>();
            }
            this.data.add(t);
            return t;
        }

        public provisionComponent addData(provisionDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new ArrayList<provisionDataComponent>();
            }
            this.data.add(t);
            return this;
        }

        public provisionDataComponent getDataFirstRep() {
            if (this.getData().isEmpty()) {
                this.addData();
            }
            return this.getData().get(0);
        }

        public List<provisionComponent> getProvision() {
            if (this.provision == null) {
                this.provision = new ArrayList<provisionComponent>();
            }
            return this.provision;
        }

        public provisionComponent setProvision(List<provisionComponent> theProvision) {
            this.provision = theProvision;
            return this;
        }

        public boolean hasProvision() {
            if (this.provision == null) {
                return false;
            }
            for (provisionComponent item : this.provision) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public provisionComponent addProvision() {
            provisionComponent t = new provisionComponent();
            if (this.provision == null) {
                this.provision = new ArrayList<provisionComponent>();
            }
            this.provision.add(t);
            return t;
        }

        public provisionComponent addProvision(provisionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.provision == null) {
                this.provision = new ArrayList<provisionComponent>();
            }
            this.provision.add(t);
            return this;
        }

        public provisionComponent getProvisionFirstRep() {
            if (this.getProvision().isEmpty()) {
                this.addProvision();
            }
            return this.getProvision().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Action  to take - permit or deny - when the rule conditions are met.  Not permitted in root rule, required in all nested rules.", 0, 1, this.type));
            children.add(new Property(Consent.SP_PERIOD, "Period", "The timeframe in this rule is valid.", 0, 1, this.period));
            children.add(new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this rule. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor));
            children.add(new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this Rule.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("securityLabel", "Coding", "A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this rule.", 0, Integer.MAX_VALUE, this.purpose));
            children.add(new Property("class", "Coding", "The class of information covered by this rule. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.class_));
            children.add(new Property("code", "CodeableConcept", "If this code is found in an instance, then the rule applies.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this rule.", 0, 1, this.dataPeriod));
            children.add(new Property(Consent.SP_DATA, "", "The resources controlled by this rule if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data));
            children.add(new Property("provision", "@Consent.provision", "Rules which provide exceptions to the base rule or subrules.", 0, Integer.MAX_VALUE, this.provision));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Action  to take - permit or deny - when the rule conditions are met.  Not permitted in root rule, required in all nested rules.", 0, 1, this.type);
                }
                case -991726143: {
                    return new Property(Consent.SP_PERIOD, "Period", "The timeframe in this rule is valid.", 0, 1, this.period);
                }
                case 92645877: {
                    return new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this rule. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor);
                }
                case -1422950858: {
                    return new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this Rule.", 0, Integer.MAX_VALUE, this.action);
                }
                case -722296940: {
                    return new Property("securityLabel", "Coding", "A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case -220463842: {
                    return new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this rule.", 0, Integer.MAX_VALUE, this.purpose);
                }
                case 94742904: {
                    return new Property("class", "Coding", "The class of information covered by this rule. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.class_);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "If this code is found in an instance, then the rule applies.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1177250315: {
                    return new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this rule.", 0, 1, this.dataPeriod);
                }
                case 3076010: {
                    return new Property(Consent.SP_DATA, "", "The resources controlled by this rule if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data);
                }
                case -547120939: {
                    return new Property("provision", "@Consent.provision", "Rules which provide exceptions to the base rule or subrules.", 0, Integer.MAX_VALUE, this.provision);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 92645877: {
                    return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case -220463842: {
                    return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
                }
                case 94742904: {
                    return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1177250315: {
                    Base[] baseArray;
                    if (this.dataPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dataPeriod;
                    }
                    return baseArray;
                }
                case 3076010: {
                    return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
                }
                case -547120939: {
                    return this.provision == null ? new Base[]{} : this.provision.toArray(new Base[this.provision.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ConsentProvisionTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case 92645877: {
                    this.getActor().add((provisionActorComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(this.castToCoding(value));
                    return value;
                }
                case -220463842: {
                    this.getPurpose().add(this.castToCoding(value));
                    return value;
                }
                case 94742904: {
                    this.getClass_().add(this.castToCoding(value));
                    return value;
                }
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1177250315: {
                    this.dataPeriod = this.castToPeriod(value);
                    return value;
                }
                case 3076010: {
                    this.getData().add((provisionDataComponent)((Object)value));
                    return value;
                }
                case -547120939: {
                    this.getProvision().add((provisionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ConsentProvisionTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals(Consent.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else if (name.equals(Consent.SP_ACTOR)) {
                this.getActor().add((provisionActorComponent)((Object)value));
            } else if (name.equals(Consent.SP_ACTION)) {
                this.getAction().add(this.castToCodeableConcept(value));
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(this.castToCoding(value));
            } else if (name.equals(Consent.SP_PURPOSE)) {
                this.getPurpose().add(this.castToCoding(value));
            } else if (name.equals("class")) {
                this.getClass_().add(this.castToCoding(value));
            } else if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("dataPeriod")) {
                this.dataPeriod = this.castToPeriod(value);
            } else if (name.equals(Consent.SP_DATA)) {
                this.getData().add((provisionDataComponent)((Object)value));
            } else if (name.equals("provision")) {
                this.getProvision().add((provisionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 92645877: {
                    return this.addActor();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case -220463842: {
                    return this.addPurpose();
                }
                case 94742904: {
                    return this.addClass_();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1177250315: {
                    return this.getDataPeriod();
                }
                case 3076010: {
                    return this.addData();
                }
                case -547120939: {
                    return this.addProvision();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 92645877: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case -722296940: {
                    return new String[]{"Coding"};
                }
                case -220463842: {
                    return new String[]{"Coding"};
                }
                case 94742904: {
                    return new String[]{"Coding"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1177250315: {
                    return new String[]{"Period"};
                }
                case 3076010: {
                    return new String[0];
                }
                case -547120939: {
                    return new String[]{"@Consent.provision"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.type");
            }
            if (name.equals(Consent.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals(Consent.SP_ACTOR)) {
                return this.addActor();
            }
            if (name.equals(Consent.SP_ACTION)) {
                return this.addAction();
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals(Consent.SP_PURPOSE)) {
                return this.addPurpose();
            }
            if (name.equals("class")) {
                return this.addClass_();
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("dataPeriod")) {
                this.dataPeriod = new Period();
                return this.dataPeriod;
            }
            if (name.equals(Consent.SP_DATA)) {
                return this.addData();
            }
            if (name.equals("provision")) {
                return this.addProvision();
            }
            return super.addChild(name);
        }

        @Override
        public provisionComponent copy() {
            provisionComponent dst = new provisionComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.actor != null) {
                dst.actor = new ArrayList<provisionActorComponent>();
                for (provisionActorComponent provisionActorComponent2 : this.actor) {
                    dst.actor.add(provisionActorComponent2.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.action) {
                    dst.action.add(codeableConcept.copy());
                }
            }
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding : this.securityLabel) {
                    dst.securityLabel.add(coding.copy());
                }
            }
            if (this.purpose != null) {
                dst.purpose = new ArrayList<Coding>();
                for (Coding coding : this.purpose) {
                    dst.purpose.add(coding.copy());
                }
            }
            if (this.class_ != null) {
                dst.class_ = new ArrayList<Coding>();
                for (Coding coding : this.class_) {
                    dst.class_.add(coding.copy());
                }
            }
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            Period period2 = dst.dataPeriod = this.dataPeriod == null ? null : this.dataPeriod.copy();
            if (this.data != null) {
                dst.data = new ArrayList<provisionDataComponent>();
                for (provisionDataComponent provisionDataComponent2 : this.data) {
                    dst.data.add(provisionDataComponent2.copy());
                }
            }
            if (this.provision != null) {
                dst.provision = new ArrayList<provisionComponent>();
                for (provisionComponent provisionComponent2 : this.provision) {
                    dst.provision.add(provisionComponent2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof provisionComponent)) {
                return false;
            }
            provisionComponent o = (provisionComponent)other_;
            return provisionComponent.compareDeep(this.type, o.type, true) && provisionComponent.compareDeep(this.period, o.period, true) && provisionComponent.compareDeep(this.actor, o.actor, true) && provisionComponent.compareDeep(this.action, o.action, true) && provisionComponent.compareDeep(this.securityLabel, o.securityLabel, true) && provisionComponent.compareDeep(this.purpose, o.purpose, true) && provisionComponent.compareDeep(this.class_, o.class_, true) && provisionComponent.compareDeep(this.code, o.code, true) && provisionComponent.compareDeep(this.dataPeriod, o.dataPeriod, true) && provisionComponent.compareDeep(this.data, o.data, true) && provisionComponent.compareDeep(this.provision, o.provision, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof provisionComponent)) {
                return false;
            }
            provisionComponent o = (provisionComponent)other_;
            return provisionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.period, this.actor, this.action, this.securityLabel, this.purpose, this.class_, this.code, this.dataPeriod, this.data, this.provision});
        }

        @Override
        public String fhirType() {
            return "Consent.provision";
        }
    }

    @Block
    public static class ConsentVerificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="verified", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Has been verified", formalDefinition="Has the instruction been verified.")
        protected BooleanType verified;
        @Child(name="verifiedWith", type={Patient.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Person who verified", formalDefinition="Who verified the instruction (Patient, Relative or other Authorized Person).")
        protected Reference verifiedWith;
        protected Resource verifiedWithTarget;
        @Child(name="verificationDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When consent verified", formalDefinition="Date verification was collected.")
        protected DateTimeType verificationDate;
        private static final long serialVersionUID = 1305161458L;

        public ConsentVerificationComponent() {
        }

        public ConsentVerificationComponent(BooleanType verified) {
            this.verified = verified;
        }

        public BooleanType getVerifiedElement() {
            if (this.verified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verified");
                }
                if (Configuration.doAutoCreate()) {
                    this.verified = new BooleanType();
                }
            }
            return this.verified;
        }

        public boolean hasVerifiedElement() {
            return this.verified != null && !this.verified.isEmpty();
        }

        public boolean hasVerified() {
            return this.verified != null && !this.verified.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedElement(BooleanType value) {
            this.verified = value;
            return this;
        }

        public boolean getVerified() {
            return this.verified == null || this.verified.isEmpty() ? false : (Boolean)this.verified.getValue();
        }

        public ConsentVerificationComponent setVerified(boolean value) {
            if (this.verified == null) {
                this.verified = new BooleanType();
            }
            this.verified.setValue((Object)value);
            return this;
        }

        public Reference getVerifiedWith() {
            if (this.verifiedWith == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verifiedWith");
                }
                if (Configuration.doAutoCreate()) {
                    this.verifiedWith = new Reference();
                }
            }
            return this.verifiedWith;
        }

        public boolean hasVerifiedWith() {
            return this.verifiedWith != null && !this.verifiedWith.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedWith(Reference value) {
            this.verifiedWith = value;
            return this;
        }

        public Resource getVerifiedWithTarget() {
            return this.verifiedWithTarget;
        }

        public ConsentVerificationComponent setVerifiedWithTarget(Resource value) {
            this.verifiedWithTarget = value;
            return this;
        }

        public DateTimeType getVerificationDateElement() {
            if (this.verificationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verificationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.verificationDate = new DateTimeType();
                }
            }
            return this.verificationDate;
        }

        public boolean hasVerificationDateElement() {
            return this.verificationDate != null && !this.verificationDate.isEmpty();
        }

        public boolean hasVerificationDate() {
            return this.verificationDate != null && !this.verificationDate.isEmpty();
        }

        public ConsentVerificationComponent setVerificationDateElement(DateTimeType value) {
            this.verificationDate = value;
            return this;
        }

        public Date getVerificationDate() {
            return this.verificationDate == null ? null : (Date)this.verificationDate.getValue();
        }

        public ConsentVerificationComponent setVerificationDate(Date value) {
            if (value == null) {
                this.verificationDate = null;
            } else {
                if (this.verificationDate == null) {
                    this.verificationDate = new DateTimeType();
                }
                this.verificationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("verified", "boolean", "Has the instruction been verified.", 0, 1, this.verified));
            children.add(new Property("verifiedWith", "Reference(Patient|RelatedPerson)", "Who verified the instruction (Patient, Relative or other Authorized Person).", 0, 1, this.verifiedWith));
            children.add(new Property("verificationDate", "dateTime", "Date verification was collected.", 0, 1, this.verificationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1994383672: {
                    return new Property("verified", "boolean", "Has the instruction been verified.", 0, 1, this.verified);
                }
                case -1425236050: {
                    return new Property("verifiedWith", "Reference(Patient|RelatedPerson)", "Who verified the instruction (Patient, Relative or other Authorized Person).", 0, 1, this.verifiedWith);
                }
                case 642233449: {
                    return new Property("verificationDate", "dateTime", "Date verification was collected.", 0, 1, this.verificationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    Base[] baseArray;
                    if (this.verified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.verified;
                    }
                    return baseArray;
                }
                case -1425236050: {
                    Base[] baseArray;
                    if (this.verifiedWith == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.verifiedWith;
                    }
                    return baseArray;
                }
                case 642233449: {
                    Base[] baseArray;
                    if (this.verificationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.verificationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    this.verified = this.castToBoolean(value);
                    return value;
                }
                case -1425236050: {
                    this.verifiedWith = this.castToReference(value);
                    return value;
                }
                case 642233449: {
                    this.verificationDate = this.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("verified")) {
                this.verified = this.castToBoolean(value);
            } else if (name.equals("verifiedWith")) {
                this.verifiedWith = this.castToReference(value);
            } else if (name.equals("verificationDate")) {
                this.verificationDate = this.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    return this.getVerifiedElement();
                }
                case -1425236050: {
                    return this.getVerifiedWith();
                }
                case 642233449: {
                    return this.getVerificationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    return new String[]{"boolean"};
                }
                case -1425236050: {
                    return new String[]{"Reference"};
                }
                case 642233449: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("verified")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.verified");
            }
            if (name.equals("verifiedWith")) {
                this.verifiedWith = new Reference();
                return this.verifiedWith;
            }
            if (name.equals("verificationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.verificationDate");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentVerificationComponent copy() {
            ConsentVerificationComponent dst = new ConsentVerificationComponent();
            this.copyValues(dst);
            dst.verified = this.verified == null ? null : this.verified.copy();
            dst.verifiedWith = this.verifiedWith == null ? null : this.verifiedWith.copy();
            dst.verificationDate = this.verificationDate == null ? null : this.verificationDate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentVerificationComponent)) {
                return false;
            }
            ConsentVerificationComponent o = (ConsentVerificationComponent)other_;
            return ConsentVerificationComponent.compareDeep(this.verified, o.verified, true) && ConsentVerificationComponent.compareDeep(this.verifiedWith, o.verifiedWith, true) && ConsentVerificationComponent.compareDeep(this.verificationDate, o.verificationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentVerificationComponent)) {
                return false;
            }
            ConsentVerificationComponent o = (ConsentVerificationComponent)other_;
            return ConsentVerificationComponent.compareValues(this.verified, o.verified, true) && ConsentVerificationComponent.compareValues(this.verificationDate, o.verificationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.verified, this.verifiedWith, this.verificationDate});
        }

        @Override
        public String fhirType() {
            return "Consent.verification";
        }
    }

    @Block
    public static class ConsentPolicyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authority", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Enforcement source for policy", formalDefinition="Entity or Organization having regulatory jurisdiction or accountability for \u00a0enforcing policies pertaining to Consent Directives.")
        protected UriType authority;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific policy covered by this consent", formalDefinition="The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.")
        protected UriType uri;
        private static final long serialVersionUID = 672275705L;

        public UriType getAuthorityElement() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new UriType();
                }
            }
            return this.authority;
        }

        public boolean hasAuthorityElement() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public ConsentPolicyComponent setAuthorityElement(UriType value) {
            this.authority = value;
            return this;
        }

        public String getAuthority() {
            return this.authority == null ? null : (String)this.authority.getValue();
        }

        public ConsentPolicyComponent setAuthority(String value) {
            if (Utilities.noString((String)value)) {
                this.authority = null;
            } else {
                if (this.authority == null) {
                    this.authority = new UriType();
                }
                this.authority.setValue(value);
            }
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ConsentPolicyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ConsentPolicyComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authority", "uri", "Entity or Organization having regulatory jurisdiction or accountability for \u00a0enforcing policies pertaining to Consent Directives.", 0, 1, this.authority));
            children.add(new Property("uri", "uri", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, 1, this.uri));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1475610435: {
                    return new Property("authority", "uri", "Entity or Organization having regulatory jurisdiction or accountability for \u00a0enforcing policies pertaining to Consent Directives.", 0, 1, this.authority);
                }
                case 116076: {
                    return new Property("uri", "uri", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, 1, this.uri);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authority;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    this.authority = this.castToUri(value);
                    return value;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = this.castToUri(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return this.getAuthorityElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return new String[]{"uri"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authority")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.authority");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.uri");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentPolicyComponent copy() {
            ConsentPolicyComponent dst = new ConsentPolicyComponent();
            this.copyValues(dst);
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyComponent)) {
                return false;
            }
            ConsentPolicyComponent o = (ConsentPolicyComponent)other_;
            return ConsentPolicyComponent.compareDeep(this.authority, o.authority, true) && ConsentPolicyComponent.compareDeep(this.uri, o.uri, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyComponent)) {
                return false;
            }
            ConsentPolicyComponent o = (ConsentPolicyComponent)other_;
            return ConsentPolicyComponent.compareValues(this.authority, o.authority, true) && ConsentPolicyComponent.compareValues(this.uri, o.uri, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authority, this.uri});
        }

        @Override
        public String fhirType() {
            return "Consent.policy";
        }
    }

    public static class ConsentDataMeaningEnumFactory
    implements EnumFactory<ConsentDataMeaning> {
        @Override
        public ConsentDataMeaning fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return ConsentDataMeaning.INSTANCE;
            }
            if ("related".equals(codeString)) {
                return ConsentDataMeaning.RELATED;
            }
            if ("dependents".equals(codeString)) {
                return ConsentDataMeaning.DEPENDENTS;
            }
            if ("authoredby".equals(codeString)) {
                return ConsentDataMeaning.AUTHOREDBY;
            }
            throw new IllegalArgumentException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        public Enumeration<ConsentDataMeaning> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentDataMeaning>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.INSTANCE);
            }
            if ("related".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.RELATED);
            }
            if ("dependents".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.DEPENDENTS);
            }
            if ("authoredby".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.AUTHOREDBY);
            }
            throw new FHIRException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentDataMeaning code) {
            if (code == ConsentDataMeaning.INSTANCE) {
                return "instance";
            }
            if (code == ConsentDataMeaning.RELATED) {
                return "related";
            }
            if (code == ConsentDataMeaning.DEPENDENTS) {
                return "dependents";
            }
            if (code == ConsentDataMeaning.AUTHOREDBY) {
                return "authoredby";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentDataMeaning code) {
            return code.getSystem();
        }
    }

    public static enum ConsentDataMeaning {
        INSTANCE,
        RELATED,
        DEPENDENTS,
        AUTHOREDBY,
        NULL;


        public static ConsentDataMeaning fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("related".equals(codeString)) {
                return RELATED;
            }
            if ("dependents".equals(codeString)) {
                return DEPENDENTS;
            }
            if ("authoredby".equals(codeString)) {
                return AUTHOREDBY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case RELATED: {
                    return "related";
                }
                case DEPENDENTS: {
                    return "dependents";
                }
                case AUTHOREDBY: {
                    return "authoredby";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case RELATED: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case DEPENDENTS: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case AUTHOREDBY: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The consent applies directly to the instance of the resource";
                }
                case RELATED: {
                    return "The consent applies directly to the instance of the resource and instances it refers to";
                }
                case DEPENDENTS: {
                    return "The consent applies directly to the instance of the resource and instances that refer to it";
                }
                case AUTHOREDBY: {
                    return "The consent applies to instances of resources that are authored by";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case RELATED: {
                    return "Related";
                }
                case DEPENDENTS: {
                    return "Dependents";
                }
                case AUTHOREDBY: {
                    return "AuthoredBy";
                }
            }
            return "?";
        }
    }

    public static class ConsentProvisionTypeEnumFactory
    implements EnumFactory<ConsentProvisionType> {
        @Override
        public ConsentProvisionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return ConsentProvisionType.DENY;
            }
            if ("permit".equals(codeString)) {
                return ConsentProvisionType.PERMIT;
            }
            throw new IllegalArgumentException("Unknown ConsentProvisionType code '" + codeString + "'");
        }

        public Enumeration<ConsentProvisionType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentProvisionType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return new Enumeration<ConsentProvisionType>(this, ConsentProvisionType.DENY);
            }
            if ("permit".equals(codeString)) {
                return new Enumeration<ConsentProvisionType>(this, ConsentProvisionType.PERMIT);
            }
            throw new FHIRException("Unknown ConsentProvisionType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentProvisionType code) {
            if (code == ConsentProvisionType.DENY) {
                return "deny";
            }
            if (code == ConsentProvisionType.PERMIT) {
                return "permit";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentProvisionType code) {
            return code.getSystem();
        }
    }

    public static enum ConsentProvisionType {
        DENY,
        PERMIT,
        NULL;


        public static ConsentProvisionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return DENY;
            }
            if ("permit".equals(codeString)) {
                return PERMIT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentProvisionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DENY: {
                    return "deny";
                }
                case PERMIT: {
                    return "permit";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DENY: {
                    return "http://hl7.org/fhir/consent-provision-type";
                }
                case PERMIT: {
                    return "http://hl7.org/fhir/consent-provision-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DENY: {
                    return "Consent is denied for actions meeting these rules";
                }
                case PERMIT: {
                    return "Consent is provided for actions meeting these rules";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DENY: {
                    return "Opt Out";
                }
                case PERMIT: {
                    return "Opt In";
                }
            }
            return "?";
        }
    }

    public static class ConsentStateEnumFactory
    implements EnumFactory<ConsentState> {
        @Override
        public ConsentState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return ConsentState.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return ConsentState.INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return ConsentState.NOTDONE;
            }
            if ("suspended".equals(codeString)) {
                return ConsentState.SUSPENDED;
            }
            if ("aborted".equals(codeString)) {
                return ConsentState.ABORTED;
            }
            if ("completed".equals(codeString)) {
                return ConsentState.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ConsentState.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ConsentState.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ConsentState code '" + codeString + "'");
        }

        public Enumeration<ConsentState> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentState>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.PREPARATION);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.INPROGRESS);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.NOTDONE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.SUSPENDED);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ABORTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.UNKNOWN);
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentState code) {
            if (code == ConsentState.PREPARATION) {
                return "preparation";
            }
            if (code == ConsentState.INPROGRESS) {
                return "in-progress";
            }
            if (code == ConsentState.NOTDONE) {
                return "not-done";
            }
            if (code == ConsentState.SUSPENDED) {
                return "suspended";
            }
            if (code == ConsentState.ABORTED) {
                return "aborted";
            }
            if (code == ConsentState.COMPLETED) {
                return "completed";
            }
            if (code == ConsentState.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ConsentState.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentState code) {
            return code.getSystem();
        }
    }

    public static enum ConsentState {
        PREPARATION,
        INPROGRESS,
        NOTDONE,
        SUSPENDED,
        ABORTED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ConsentState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case ABORTED: {
                    return "aborted";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/event-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/event-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/event-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
                }
                case INPROGRESS: {
                    return "The event is currently occurring";
                }
                case NOTDONE: {
                    return "The event was terminated prior to any impact on the subject (though preparatory actions may have been taken)";
                }
                case SUSPENDED: {
                    return "The event has been temporarily stopped but is expected to resume in the future";
                }
                case ABORTED: {
                    return "The event was  terminated prior to the full completion of the intended actions but after having at least some impact on the subject.";
                }
                case COMPLETED: {
                    return "The event has now concluded";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case NOTDONE: {
                    return "Not Done";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

