/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DeviceComponent", profile="http://hl7.org/fhir/Profile/DeviceComponent")
public class DeviceComponent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What kind of component it is", formalDefinition="The component type as defined in the object-oriented or metric nomenclature partition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    protected CodeableConcept type;
    @Child(name="lastSystemChange", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Recent system change timestamp", formalDefinition="The timestamp for the most recent system change which includes device configuration or setting change.")
    protected InstantType lastSystemChange;
    @Child(name="source", type={Device.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Top-level device resource link", formalDefinition="The link to the source Device that contains administrative device information such as manufacture, serial number, etc.")
    protected Reference source;
    protected Device sourceTarget;
    @Child(name="parent", type={DeviceComponent.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Parent resource link", formalDefinition="The link to the parent resource. For example: Channel is linked to its VMD parent.")
    protected Reference parent;
    protected DeviceComponent parentTarget;
    @Child(name="operationalStatus", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Current operational status of the component, for example On, Off or Standby", formalDefinition="The current operational status of the device. For example: On, Off, Standby, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/operational-status")
    protected List<CodeableConcept> operationalStatus;
    @Child(name="parameterGroup", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Current supported parameter group", formalDefinition="The parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/parameter-group")
    protected CodeableConcept parameterGroup;
    @Child(name="measurementPrinciple", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="other | chemical | electrical | impedance | nuclear | optical | thermal | biological | mechanical | acoustical | manual+", formalDefinition="The physical principle of the measurement. For example: thermal, chemical, acoustical, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measurement-principle")
    protected Enumeration<MeasmntPrinciple> measurementPrinciple;
    @Child(name="productionSpecification", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specification details such as Component Revisions, or Serial Numbers", formalDefinition="The production specification such as component revision, serial number, etc.")
    protected List<DeviceComponentProductionSpecificationComponent> productionSpecification;
    @Child(name="languageCode", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Language code for the human-readable text strings produced by the device", formalDefinition="The language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected CodeableConcept languageCode;
    @Child(name="property", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other Attributes", formalDefinition="Other device properties expressed as a `type` which identifies the property and a value(s) either as a quantity or a code.")
    protected List<DeviceComponentPropertyComponent> property;
    private static final long serialVersionUID = -972124604L;
    @SearchParamDefinition(name="parent", path="DeviceComponent.parent", description="The parent DeviceComponent resource", type="reference", target={DeviceComponent.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("DeviceComponent:parent").toLocked();
    @SearchParamDefinition(name="identifier", path="DeviceComponent.identifier", description="The identifier of the component", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="source", path="DeviceComponent.source", description="The device source", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("DeviceComponent:source").toLocked();
    @SearchParamDefinition(name="type", path="DeviceComponent.type", description="The device component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public DeviceComponent() {
    }

    public DeviceComponent(CodeableConcept type) {
        this.type = type;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceComponent setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceComponent addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DeviceComponent setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public InstantType getLastSystemChangeElement() {
        if (this.lastSystemChange == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.lastSystemChange");
            }
            if (Configuration.doAutoCreate()) {
                this.lastSystemChange = new InstantType();
            }
        }
        return this.lastSystemChange;
    }

    public boolean hasLastSystemChangeElement() {
        return this.lastSystemChange != null && !this.lastSystemChange.isEmpty();
    }

    public boolean hasLastSystemChange() {
        return this.lastSystemChange != null && !this.lastSystemChange.isEmpty();
    }

    public DeviceComponent setLastSystemChangeElement(InstantType value) {
        this.lastSystemChange = value;
        return this;
    }

    public Date getLastSystemChange() {
        return this.lastSystemChange == null ? null : (Date)this.lastSystemChange.getValue();
    }

    public DeviceComponent setLastSystemChange(Date value) {
        if (value == null) {
            this.lastSystemChange = null;
        } else {
            if (this.lastSystemChange == null) {
                this.lastSystemChange = new InstantType();
            }
            this.lastSystemChange.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public DeviceComponent setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Device getSourceTarget() {
        if (this.sourceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceTarget = new Device();
            }
        }
        return this.sourceTarget;
    }

    public DeviceComponent setSourceTarget(Device value) {
        this.sourceTarget = value;
        return this;
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public DeviceComponent setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public DeviceComponent getParentTarget() {
        if (this.parentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parentTarget = new DeviceComponent();
            }
        }
        return this.parentTarget;
    }

    public DeviceComponent setParentTarget(DeviceComponent value) {
        this.parentTarget = value;
        return this;
    }

    public List<CodeableConcept> getOperationalStatus() {
        if (this.operationalStatus == null) {
            this.operationalStatus = new ArrayList<CodeableConcept>();
        }
        return this.operationalStatus;
    }

    public DeviceComponent setOperationalStatus(List<CodeableConcept> theOperationalStatus) {
        this.operationalStatus = theOperationalStatus;
        return this;
    }

    public boolean hasOperationalStatus() {
        if (this.operationalStatus == null) {
            return false;
        }
        for (CodeableConcept item : this.operationalStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addOperationalStatus() {
        CodeableConcept t = new CodeableConcept();
        if (this.operationalStatus == null) {
            this.operationalStatus = new ArrayList<CodeableConcept>();
        }
        this.operationalStatus.add(t);
        return t;
    }

    public DeviceComponent addOperationalStatus(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.operationalStatus == null) {
            this.operationalStatus = new ArrayList<CodeableConcept>();
        }
        this.operationalStatus.add(t);
        return this;
    }

    public CodeableConcept getOperationalStatusFirstRep() {
        if (this.getOperationalStatus().isEmpty()) {
            this.addOperationalStatus();
        }
        return this.getOperationalStatus().get(0);
    }

    public CodeableConcept getParameterGroup() {
        if (this.parameterGroup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.parameterGroup");
            }
            if (Configuration.doAutoCreate()) {
                this.parameterGroup = new CodeableConcept();
            }
        }
        return this.parameterGroup;
    }

    public boolean hasParameterGroup() {
        return this.parameterGroup != null && !this.parameterGroup.isEmpty();
    }

    public DeviceComponent setParameterGroup(CodeableConcept value) {
        this.parameterGroup = value;
        return this;
    }

    public Enumeration<MeasmntPrinciple> getMeasurementPrincipleElement() {
        if (this.measurementPrinciple == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.measurementPrinciple");
            }
            if (Configuration.doAutoCreate()) {
                this.measurementPrinciple = new Enumeration<MeasmntPrinciple>(new MeasmntPrincipleEnumFactory());
            }
        }
        return this.measurementPrinciple;
    }

    public boolean hasMeasurementPrincipleElement() {
        return this.measurementPrinciple != null && !this.measurementPrinciple.isEmpty();
    }

    public boolean hasMeasurementPrinciple() {
        return this.measurementPrinciple != null && !this.measurementPrinciple.isEmpty();
    }

    public DeviceComponent setMeasurementPrincipleElement(Enumeration<MeasmntPrinciple> value) {
        this.measurementPrinciple = value;
        return this;
    }

    public MeasmntPrinciple getMeasurementPrinciple() {
        return this.measurementPrinciple == null ? null : (MeasmntPrinciple)((Object)this.measurementPrinciple.getValue());
    }

    public DeviceComponent setMeasurementPrinciple(MeasmntPrinciple value) {
        if (value == null) {
            this.measurementPrinciple = null;
        } else {
            if (this.measurementPrinciple == null) {
                this.measurementPrinciple = new Enumeration<MeasmntPrinciple>(new MeasmntPrincipleEnumFactory());
            }
            this.measurementPrinciple.setValue((Object)value);
        }
        return this;
    }

    public List<DeviceComponentProductionSpecificationComponent> getProductionSpecification() {
        if (this.productionSpecification == null) {
            this.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
        }
        return this.productionSpecification;
    }

    public DeviceComponent setProductionSpecification(List<DeviceComponentProductionSpecificationComponent> theProductionSpecification) {
        this.productionSpecification = theProductionSpecification;
        return this;
    }

    public boolean hasProductionSpecification() {
        if (this.productionSpecification == null) {
            return false;
        }
        for (DeviceComponentProductionSpecificationComponent item : this.productionSpecification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceComponentProductionSpecificationComponent addProductionSpecification() {
        DeviceComponentProductionSpecificationComponent t = new DeviceComponentProductionSpecificationComponent();
        if (this.productionSpecification == null) {
            this.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
        }
        this.productionSpecification.add(t);
        return t;
    }

    public DeviceComponent addProductionSpecification(DeviceComponentProductionSpecificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.productionSpecification == null) {
            this.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
        }
        this.productionSpecification.add(t);
        return this;
    }

    public DeviceComponentProductionSpecificationComponent getProductionSpecificationFirstRep() {
        if (this.getProductionSpecification().isEmpty()) {
            this.addProductionSpecification();
        }
        return this.getProductionSpecification().get(0);
    }

    public CodeableConcept getLanguageCode() {
        if (this.languageCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.languageCode");
            }
            if (Configuration.doAutoCreate()) {
                this.languageCode = new CodeableConcept();
            }
        }
        return this.languageCode;
    }

    public boolean hasLanguageCode() {
        return this.languageCode != null && !this.languageCode.isEmpty();
    }

    public DeviceComponent setLanguageCode(CodeableConcept value) {
        this.languageCode = value;
        return this;
    }

    public List<DeviceComponentPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<DeviceComponentPropertyComponent>();
        }
        return this.property;
    }

    public DeviceComponent setProperty(List<DeviceComponentPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (DeviceComponentPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceComponentPropertyComponent addProperty() {
        DeviceComponentPropertyComponent t = new DeviceComponentPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<DeviceComponentPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public DeviceComponent addProperty(DeviceComponentPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<DeviceComponentPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public DeviceComponentPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The component type as defined in the object-oriented or metric nomenclature partition.", 0, 1, this.type));
        children.add(new Property("lastSystemChange", "instant", "The timestamp for the most recent system change which includes device configuration or setting change.", 0, 1, this.lastSystemChange));
        children.add(new Property(SP_SOURCE, "Reference(Device)", "The link to the source Device that contains administrative device information such as manufacture, serial number, etc.", 0, 1, this.source));
        children.add(new Property(SP_PARENT, "Reference(DeviceComponent)", "The link to the parent resource. For example: Channel is linked to its VMD parent.", 0, 1, this.parent));
        children.add(new Property("operationalStatus", "CodeableConcept", "The current operational status of the device. For example: On, Off, Standby, etc.", 0, Integer.MAX_VALUE, this.operationalStatus));
        children.add(new Property("parameterGroup", "CodeableConcept", "The parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.", 0, 1, this.parameterGroup));
        children.add(new Property("measurementPrinciple", "code", "The physical principle of the measurement. For example: thermal, chemical, acoustical, etc.", 0, 1, this.measurementPrinciple));
        children.add(new Property("productionSpecification", "", "The production specification such as component revision, serial number, etc.", 0, Integer.MAX_VALUE, this.productionSpecification));
        children.add(new Property("languageCode", "CodeableConcept", "The language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.", 0, 1, this.languageCode));
        children.add(new Property("property", "", "Other device properties expressed as a `type` which identifies the property and a value(s) either as a quantity or a code.", 0, Integer.MAX_VALUE, this.property));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The component type as defined in the object-oriented or metric nomenclature partition.", 0, 1, this.type);
            }
            case -2072475531: {
                return new Property("lastSystemChange", "instant", "The timestamp for the most recent system change which includes device configuration or setting change.", 0, 1, this.lastSystemChange);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "Reference(Device)", "The link to the source Device that contains administrative device information such as manufacture, serial number, etc.", 0, 1, this.source);
            }
            case -995424086: {
                return new Property(SP_PARENT, "Reference(DeviceComponent)", "The link to the parent resource. For example: Channel is linked to its VMD parent.", 0, 1, this.parent);
            }
            case -2103166364: {
                return new Property("operationalStatus", "CodeableConcept", "The current operational status of the device. For example: On, Off, Standby, etc.", 0, Integer.MAX_VALUE, this.operationalStatus);
            }
            case 1111110742: {
                return new Property("parameterGroup", "CodeableConcept", "The parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.", 0, 1, this.parameterGroup);
            }
            case 24324384: {
                return new Property("measurementPrinciple", "code", "The physical principle of the measurement. For example: thermal, chemical, acoustical, etc.", 0, 1, this.measurementPrinciple);
            }
            case -455527222: {
                return new Property("productionSpecification", "", "The production specification such as component revision, serial number, etc.", 0, Integer.MAX_VALUE, this.productionSpecification);
            }
            case -2092349083: {
                return new Property("languageCode", "CodeableConcept", "The language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.", 0, 1, this.languageCode);
            }
            case -993141291: {
                return new Property("property", "", "Other device properties expressed as a `type` which identifies the property and a value(s) either as a quantity or a code.", 0, Integer.MAX_VALUE, this.property);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -2072475531: {
                Base[] baseArray;
                if (this.lastSystemChange == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.lastSystemChange;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.source;
                }
                return baseArray;
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.parent;
                }
                return baseArray;
            }
            case -2103166364: {
                return this.operationalStatus == null ? new Base[]{} : this.operationalStatus.toArray(new Base[this.operationalStatus.size()]);
            }
            case 1111110742: {
                Base[] baseArray;
                if (this.parameterGroup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.parameterGroup;
                }
                return baseArray;
            }
            case 24324384: {
                Base[] baseArray;
                if (this.measurementPrinciple == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.measurementPrinciple;
                }
                return baseArray;
            }
            case -455527222: {
                return this.productionSpecification == null ? new Base[]{} : this.productionSpecification.toArray(new Base[this.productionSpecification.size()]);
            }
            case -2092349083: {
                Base[] baseArray;
                if (this.languageCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.languageCode;
                }
                return baseArray;
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -2072475531: {
                this.lastSystemChange = this.castToInstant(value);
                return value;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                return value;
            }
            case -995424086: {
                this.parent = this.castToReference(value);
                return value;
            }
            case -2103166364: {
                this.getOperationalStatus().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1111110742: {
                this.parameterGroup = this.castToCodeableConcept(value);
                return value;
            }
            case 24324384: {
                value = new MeasmntPrincipleEnumFactory().fromType(this.castToCode(value));
                this.measurementPrinciple = value;
                return value;
            }
            case -455527222: {
                this.getProductionSpecification().add((DeviceComponentProductionSpecificationComponent)((Object)value));
                return value;
            }
            case -2092349083: {
                this.languageCode = this.castToCodeableConcept(value);
                return value;
            }
            case -993141291: {
                this.getProperty().add((DeviceComponentPropertyComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("lastSystemChange")) {
            this.lastSystemChange = this.castToInstant(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_PARENT)) {
            this.parent = this.castToReference(value);
        } else if (name.equals("operationalStatus")) {
            this.getOperationalStatus().add(this.castToCodeableConcept(value));
        } else if (name.equals("parameterGroup")) {
            this.parameterGroup = this.castToCodeableConcept(value);
        } else if (name.equals("measurementPrinciple")) {
            value = new MeasmntPrincipleEnumFactory().fromType(this.castToCode(value));
            this.measurementPrinciple = value;
        } else if (name.equals("productionSpecification")) {
            this.getProductionSpecification().add((DeviceComponentProductionSpecificationComponent)((Object)value));
        } else if (name.equals("languageCode")) {
            this.languageCode = this.castToCodeableConcept(value);
        } else if (name.equals("property")) {
            this.getProperty().add((DeviceComponentPropertyComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -2072475531: {
                return this.getLastSystemChangeElement();
            }
            case -896505829: {
                return this.getSource();
            }
            case -995424086: {
                return this.getParent();
            }
            case -2103166364: {
                return this.addOperationalStatus();
            }
            case 1111110742: {
                return this.getParameterGroup();
            }
            case 24324384: {
                return this.getMeasurementPrincipleElement();
            }
            case -455527222: {
                return this.addProductionSpecification();
            }
            case -2092349083: {
                return this.getLanguageCode();
            }
            case -993141291: {
                return this.addProperty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -2072475531: {
                return new String[]{"instant"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case -2103166364: {
                return new String[]{"CodeableConcept"};
            }
            case 1111110742: {
                return new String[]{"CodeableConcept"};
            }
            case 24324384: {
                return new String[]{"code"};
            }
            case -455527222: {
                return new String[0];
            }
            case -2092349083: {
                return new String[]{"CodeableConcept"};
            }
            case -993141291: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("lastSystemChange")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceComponent.lastSystemChange");
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_PARENT)) {
            this.parent = new Reference();
            return this.parent;
        }
        if (name.equals("operationalStatus")) {
            return this.addOperationalStatus();
        }
        if (name.equals("parameterGroup")) {
            this.parameterGroup = new CodeableConcept();
            return this.parameterGroup;
        }
        if (name.equals("measurementPrinciple")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceComponent.measurementPrinciple");
        }
        if (name.equals("productionSpecification")) {
            return this.addProductionSpecification();
        }
        if (name.equals("languageCode")) {
            this.languageCode = new CodeableConcept();
            return this.languageCode;
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceComponent";
    }

    @Override
    public DeviceComponent copy() {
        DeviceComponent dst = new DeviceComponent();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.lastSystemChange = this.lastSystemChange == null ? null : this.lastSystemChange.copy();
        dst.source = this.source == null ? null : this.source.copy();
        Reference reference = dst.parent = this.parent == null ? null : this.parent.copy();
        if (this.operationalStatus != null) {
            dst.operationalStatus = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.operationalStatus) {
                dst.operationalStatus.add(codeableConcept.copy());
            }
        }
        dst.parameterGroup = this.parameterGroup == null ? null : this.parameterGroup.copy();
        Enumeration<MeasmntPrinciple> enumeration = dst.measurementPrinciple = this.measurementPrinciple == null ? null : this.measurementPrinciple.copy();
        if (this.productionSpecification != null) {
            dst.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
            for (DeviceComponentProductionSpecificationComponent deviceComponentProductionSpecificationComponent : this.productionSpecification) {
                dst.productionSpecification.add(deviceComponentProductionSpecificationComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.languageCode = this.languageCode == null ? null : this.languageCode.copy();
        if (this.property != null) {
            dst.property = new ArrayList<DeviceComponentPropertyComponent>();
            for (DeviceComponentPropertyComponent deviceComponentPropertyComponent : this.property) {
                dst.property.add(deviceComponentPropertyComponent.copy());
            }
        }
        return dst;
    }

    protected DeviceComponent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceComponent)) {
            return false;
        }
        DeviceComponent o = (DeviceComponent)other_;
        return DeviceComponent.compareDeep(this.identifier, o.identifier, true) && DeviceComponent.compareDeep(this.type, o.type, true) && DeviceComponent.compareDeep(this.lastSystemChange, o.lastSystemChange, true) && DeviceComponent.compareDeep(this.source, o.source, true) && DeviceComponent.compareDeep(this.parent, o.parent, true) && DeviceComponent.compareDeep(this.operationalStatus, o.operationalStatus, true) && DeviceComponent.compareDeep(this.parameterGroup, o.parameterGroup, true) && DeviceComponent.compareDeep(this.measurementPrinciple, o.measurementPrinciple, true) && DeviceComponent.compareDeep(this.productionSpecification, o.productionSpecification, true) && DeviceComponent.compareDeep(this.languageCode, o.languageCode, true) && DeviceComponent.compareDeep(this.property, o.property, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceComponent)) {
            return false;
        }
        DeviceComponent o = (DeviceComponent)other_;
        return DeviceComponent.compareValues(this.lastSystemChange, o.lastSystemChange, true) && DeviceComponent.compareValues(this.measurementPrinciple, o.measurementPrinciple, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.lastSystemChange, this.source, this.parent, this.operationalStatus, this.parameterGroup, this.measurementPrinciple, this.productionSpecification, this.languageCode, this.property});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceComponent;
    }

    @Block
    public static class DeviceComponentPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code that specifies the property", formalDefinition="The code for the device property identifying the property being reported such as 'time capability'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-component-property")
        protected CodeableConcept type;
        @Child(name="valueQuantity", type={Quantity.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Property value as a quantity", formalDefinition="The property value when the property being reported is a quantity such as the resolution of a real time clock.")
        protected List<Quantity> valueQuantity;
        @Child(name="valueCode", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Property value as a code", formalDefinition="The property value when the property being reported is a code, such as the code indicating that the device supports a real time clock using absolute time.")
        protected List<CodeableConcept> valueCode;
        private static final long serialVersionUID = 1512172633L;

        public DeviceComponentPropertyComponent() {
        }

        public DeviceComponentPropertyComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceComponentPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Quantity> getValueQuantity() {
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            return this.valueQuantity;
        }

        public DeviceComponentPropertyComponent setValueQuantity(List<Quantity> theValueQuantity) {
            this.valueQuantity = theValueQuantity;
            return this;
        }

        public boolean hasValueQuantity() {
            if (this.valueQuantity == null) {
                return false;
            }
            for (Quantity item : this.valueQuantity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addValueQuantity() {
            Quantity t = new Quantity();
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return t;
        }

        public DeviceComponentPropertyComponent addValueQuantity(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return this;
        }

        public Quantity getValueQuantityFirstRep() {
            if (this.getValueQuantity().isEmpty()) {
                this.addValueQuantity();
            }
            return this.getValueQuantity().get(0);
        }

        public List<CodeableConcept> getValueCode() {
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            return this.valueCode;
        }

        public DeviceComponentPropertyComponent setValueCode(List<CodeableConcept> theValueCode) {
            this.valueCode = theValueCode;
            return this;
        }

        public boolean hasValueCode() {
            if (this.valueCode == null) {
                return false;
            }
            for (CodeableConcept item : this.valueCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addValueCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            this.valueCode.add(t);
            return t;
        }

        public DeviceComponentPropertyComponent addValueCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            this.valueCode.add(t);
            return this;
        }

        public CodeableConcept getValueCodeFirstRep() {
            if (this.getValueCode().isEmpty()) {
                this.addValueCode();
            }
            return this.getValueCode().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceComponent.SP_TYPE, "CodeableConcept", "The code for the device property identifying the property being reported such as 'time capability'.", 0, 1, this.type));
            children.add(new Property("valueQuantity", "Quantity", "The property value when the property being reported is a quantity such as the resolution of a real time clock.", 0, Integer.MAX_VALUE, this.valueQuantity));
            children.add(new Property("valueCode", "CodeableConcept", "The property value when the property being reported is a code, such as the code indicating that the device supports a real time clock using absolute time.", 0, Integer.MAX_VALUE, this.valueCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceComponent.SP_TYPE, "CodeableConcept", "The code for the device property identifying the property being reported such as 'time capability'.", 0, 1, this.type);
                }
                case -2029823716: {
                    return new Property("valueQuantity", "Quantity", "The property value when the property being reported is a quantity such as the resolution of a real time clock.", 0, Integer.MAX_VALUE, this.valueQuantity);
                }
                case -766209282: {
                    return new Property("valueCode", "CodeableConcept", "The property value when the property being reported is a code, such as the code indicating that the device supports a real time clock using absolute time.", 0, Integer.MAX_VALUE, this.valueCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -2029823716: {
                    return this.valueQuantity == null ? new Base[]{} : this.valueQuantity.toArray(new Base[this.valueQuantity.size()]);
                }
                case -766209282: {
                    return this.valueCode == null ? new Base[]{} : this.valueCode.toArray(new Base[this.valueCode.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -2029823716: {
                    this.getValueQuantity().add(this.castToQuantity(value));
                    return value;
                }
                case -766209282: {
                    this.getValueCode().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceComponent.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("valueQuantity")) {
                this.getValueQuantity().add(this.castToQuantity(value));
            } else if (name.equals("valueCode")) {
                this.getValueCode().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -2029823716: {
                    return this.addValueQuantity();
                }
                case -766209282: {
                    return this.addValueCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -2029823716: {
                    return new String[]{"Quantity"};
                }
                case -766209282: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceComponent.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                return this.addValueQuantity();
            }
            if (name.equals("valueCode")) {
                return this.addValueCode();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceComponentPropertyComponent copy() {
            DeviceComponentPropertyComponent dst = new DeviceComponentPropertyComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.valueQuantity != null) {
                dst.valueQuantity = new ArrayList<Quantity>();
                for (Quantity quantity : this.valueQuantity) {
                    dst.valueQuantity.add(quantity.copy());
                }
            }
            if (this.valueCode != null) {
                dst.valueCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.valueCode) {
                    dst.valueCode.add(codeableConcept2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceComponentPropertyComponent)) {
                return false;
            }
            DeviceComponentPropertyComponent o = (DeviceComponentPropertyComponent)other_;
            return DeviceComponentPropertyComponent.compareDeep(this.type, o.type, true) && DeviceComponentPropertyComponent.compareDeep(this.valueQuantity, o.valueQuantity, true) && DeviceComponentPropertyComponent.compareDeep(this.valueCode, o.valueCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceComponentPropertyComponent)) {
                return false;
            }
            DeviceComponentPropertyComponent o = (DeviceComponentPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.valueQuantity, this.valueCode});
        }

        @Override
        public String fhirType() {
            return "DeviceComponent.property";
        }
    }

    @Block
    public static class DeviceComponentProductionSpecificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="specType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type or kind of production specification, for example serial number or software revision", formalDefinition="The specification type, such as, serial number, part number, hardware revision, software revision, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specification-type")
        protected CodeableConcept specType;
        @Child(name="componentId", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Internal component unique identification", formalDefinition="The internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacturer can make use of.")
        protected Identifier componentId;
        @Child(name="productionSpec", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A printable string defining the component", formalDefinition="The printable string defining the component.")
        protected StringType productionSpec;
        private static final long serialVersionUID = -1476597516L;

        public CodeableConcept getSpecType() {
            if (this.specType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentProductionSpecificationComponent.specType");
                }
                if (Configuration.doAutoCreate()) {
                    this.specType = new CodeableConcept();
                }
            }
            return this.specType;
        }

        public boolean hasSpecType() {
            return this.specType != null && !this.specType.isEmpty();
        }

        public DeviceComponentProductionSpecificationComponent setSpecType(CodeableConcept value) {
            this.specType = value;
            return this;
        }

        public Identifier getComponentId() {
            if (this.componentId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentProductionSpecificationComponent.componentId");
                }
                if (Configuration.doAutoCreate()) {
                    this.componentId = new Identifier();
                }
            }
            return this.componentId;
        }

        public boolean hasComponentId() {
            return this.componentId != null && !this.componentId.isEmpty();
        }

        public DeviceComponentProductionSpecificationComponent setComponentId(Identifier value) {
            this.componentId = value;
            return this;
        }

        public StringType getProductionSpecElement() {
            if (this.productionSpec == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentProductionSpecificationComponent.productionSpec");
                }
                if (Configuration.doAutoCreate()) {
                    this.productionSpec = new StringType();
                }
            }
            return this.productionSpec;
        }

        public boolean hasProductionSpecElement() {
            return this.productionSpec != null && !this.productionSpec.isEmpty();
        }

        public boolean hasProductionSpec() {
            return this.productionSpec != null && !this.productionSpec.isEmpty();
        }

        public DeviceComponentProductionSpecificationComponent setProductionSpecElement(StringType value) {
            this.productionSpec = value;
            return this;
        }

        public String getProductionSpec() {
            return this.productionSpec == null ? null : (String)this.productionSpec.getValue();
        }

        public DeviceComponentProductionSpecificationComponent setProductionSpec(String value) {
            if (Utilities.noString((String)value)) {
                this.productionSpec = null;
            } else {
                if (this.productionSpec == null) {
                    this.productionSpec = new StringType();
                }
                this.productionSpec.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("specType", "CodeableConcept", "The specification type, such as, serial number, part number, hardware revision, software revision, etc.", 0, 1, this.specType));
            children.add(new Property("componentId", "Identifier", "The internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacturer can make use of.", 0, 1, this.componentId));
            children.add(new Property("productionSpec", "string", "The printable string defining the component.", 0, 1, this.productionSpec));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -2133482091: {
                    return new Property("specType", "CodeableConcept", "The specification type, such as, serial number, part number, hardware revision, software revision, etc.", 0, 1, this.specType);
                }
                case -985933064: {
                    return new Property("componentId", "Identifier", "The internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacturer can make use of.", 0, 1, this.componentId);
                }
                case 182147092: {
                    return new Property("productionSpec", "string", "The printable string defining the component.", 0, 1, this.productionSpec);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    Base[] baseArray;
                    if (this.specType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.specType;
                    }
                    return baseArray;
                }
                case -985933064: {
                    Base[] baseArray;
                    if (this.componentId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.componentId;
                    }
                    return baseArray;
                }
                case 182147092: {
                    Base[] baseArray;
                    if (this.productionSpec == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.productionSpec;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    this.specType = this.castToCodeableConcept(value);
                    return value;
                }
                case -985933064: {
                    this.componentId = this.castToIdentifier(value);
                    return value;
                }
                case 182147092: {
                    this.productionSpec = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("specType")) {
                this.specType = this.castToCodeableConcept(value);
            } else if (name.equals("componentId")) {
                this.componentId = this.castToIdentifier(value);
            } else if (name.equals("productionSpec")) {
                this.productionSpec = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    return this.getSpecType();
                }
                case -985933064: {
                    return this.getComponentId();
                }
                case 182147092: {
                    return this.getProductionSpecElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    return new String[]{"CodeableConcept"};
                }
                case -985933064: {
                    return new String[]{"Identifier"};
                }
                case 182147092: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("specType")) {
                this.specType = new CodeableConcept();
                return this.specType;
            }
            if (name.equals("componentId")) {
                this.componentId = new Identifier();
                return this.componentId;
            }
            if (name.equals("productionSpec")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceComponent.productionSpec");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceComponentProductionSpecificationComponent copy() {
            DeviceComponentProductionSpecificationComponent dst = new DeviceComponentProductionSpecificationComponent();
            this.copyValues(dst);
            dst.specType = this.specType == null ? null : this.specType.copy();
            dst.componentId = this.componentId == null ? null : this.componentId.copy();
            dst.productionSpec = this.productionSpec == null ? null : this.productionSpec.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceComponentProductionSpecificationComponent)) {
                return false;
            }
            DeviceComponentProductionSpecificationComponent o = (DeviceComponentProductionSpecificationComponent)other_;
            return DeviceComponentProductionSpecificationComponent.compareDeep(this.specType, o.specType, true) && DeviceComponentProductionSpecificationComponent.compareDeep(this.componentId, o.componentId, true) && DeviceComponentProductionSpecificationComponent.compareDeep(this.productionSpec, o.productionSpec, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceComponentProductionSpecificationComponent)) {
                return false;
            }
            DeviceComponentProductionSpecificationComponent o = (DeviceComponentProductionSpecificationComponent)other_;
            return DeviceComponentProductionSpecificationComponent.compareValues(this.productionSpec, o.productionSpec, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.specType, this.componentId, this.productionSpec});
        }

        @Override
        public String fhirType() {
            return "DeviceComponent.productionSpecification";
        }
    }

    public static class MeasmntPrincipleEnumFactory
    implements EnumFactory<MeasmntPrinciple> {
        @Override
        public MeasmntPrinciple fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("other".equals(codeString)) {
                return MeasmntPrinciple.OTHER;
            }
            if ("chemical".equals(codeString)) {
                return MeasmntPrinciple.CHEMICAL;
            }
            if ("electrical".equals(codeString)) {
                return MeasmntPrinciple.ELECTRICAL;
            }
            if ("impedance".equals(codeString)) {
                return MeasmntPrinciple.IMPEDANCE;
            }
            if ("nuclear".equals(codeString)) {
                return MeasmntPrinciple.NUCLEAR;
            }
            if ("optical".equals(codeString)) {
                return MeasmntPrinciple.OPTICAL;
            }
            if ("thermal".equals(codeString)) {
                return MeasmntPrinciple.THERMAL;
            }
            if ("biological".equals(codeString)) {
                return MeasmntPrinciple.BIOLOGICAL;
            }
            if ("mechanical".equals(codeString)) {
                return MeasmntPrinciple.MECHANICAL;
            }
            if ("acoustical".equals(codeString)) {
                return MeasmntPrinciple.ACOUSTICAL;
            }
            if ("manual".equals(codeString)) {
                return MeasmntPrinciple.MANUAL;
            }
            throw new IllegalArgumentException("Unknown MeasmntPrinciple code '" + codeString + "'");
        }

        public Enumeration<MeasmntPrinciple> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MeasmntPrinciple>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("other".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.OTHER);
            }
            if ("chemical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.CHEMICAL);
            }
            if ("electrical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.ELECTRICAL);
            }
            if ("impedance".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.IMPEDANCE);
            }
            if ("nuclear".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.NUCLEAR);
            }
            if ("optical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.OPTICAL);
            }
            if ("thermal".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.THERMAL);
            }
            if ("biological".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.BIOLOGICAL);
            }
            if ("mechanical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.MECHANICAL);
            }
            if ("acoustical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.ACOUSTICAL);
            }
            if ("manual".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.MANUAL);
            }
            throw new FHIRException("Unknown MeasmntPrinciple code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasmntPrinciple code) {
            if (code == MeasmntPrinciple.OTHER) {
                return "other";
            }
            if (code == MeasmntPrinciple.CHEMICAL) {
                return "chemical";
            }
            if (code == MeasmntPrinciple.ELECTRICAL) {
                return "electrical";
            }
            if (code == MeasmntPrinciple.IMPEDANCE) {
                return "impedance";
            }
            if (code == MeasmntPrinciple.NUCLEAR) {
                return "nuclear";
            }
            if (code == MeasmntPrinciple.OPTICAL) {
                return "optical";
            }
            if (code == MeasmntPrinciple.THERMAL) {
                return "thermal";
            }
            if (code == MeasmntPrinciple.BIOLOGICAL) {
                return "biological";
            }
            if (code == MeasmntPrinciple.MECHANICAL) {
                return "mechanical";
            }
            if (code == MeasmntPrinciple.ACOUSTICAL) {
                return "acoustical";
            }
            if (code == MeasmntPrinciple.MANUAL) {
                return "manual";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasmntPrinciple code) {
            return code.getSystem();
        }
    }

    public static enum MeasmntPrinciple {
        OTHER,
        CHEMICAL,
        ELECTRICAL,
        IMPEDANCE,
        NUCLEAR,
        OPTICAL,
        THERMAL,
        BIOLOGICAL,
        MECHANICAL,
        ACOUSTICAL,
        MANUAL,
        NULL;


        public static MeasmntPrinciple fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if ("chemical".equals(codeString)) {
                return CHEMICAL;
            }
            if ("electrical".equals(codeString)) {
                return ELECTRICAL;
            }
            if ("impedance".equals(codeString)) {
                return IMPEDANCE;
            }
            if ("nuclear".equals(codeString)) {
                return NUCLEAR;
            }
            if ("optical".equals(codeString)) {
                return OPTICAL;
            }
            if ("thermal".equals(codeString)) {
                return THERMAL;
            }
            if ("biological".equals(codeString)) {
                return BIOLOGICAL;
            }
            if ("mechanical".equals(codeString)) {
                return MECHANICAL;
            }
            if ("acoustical".equals(codeString)) {
                return ACOUSTICAL;
            }
            if ("manual".equals(codeString)) {
                return MANUAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MeasmntPrinciple code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OTHER: {
                    return "other";
                }
                case CHEMICAL: {
                    return "chemical";
                }
                case ELECTRICAL: {
                    return "electrical";
                }
                case IMPEDANCE: {
                    return "impedance";
                }
                case NUCLEAR: {
                    return "nuclear";
                }
                case OPTICAL: {
                    return "optical";
                }
                case THERMAL: {
                    return "thermal";
                }
                case BIOLOGICAL: {
                    return "biological";
                }
                case MECHANICAL: {
                    return "mechanical";
                }
                case ACOUSTICAL: {
                    return "acoustical";
                }
                case MANUAL: {
                    return "manual";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OTHER: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case CHEMICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case ELECTRICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case IMPEDANCE: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case NUCLEAR: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case OPTICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case THERMAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case BIOLOGICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case MECHANICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case ACOUSTICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case MANUAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OTHER: {
                    return "Measurement principle isn't in the list.";
                }
                case CHEMICAL: {
                    return "Measurement is done using the chemical principle.";
                }
                case ELECTRICAL: {
                    return "Measurement is done using the electrical principle.";
                }
                case IMPEDANCE: {
                    return "Measurement is done using the impedance principle.";
                }
                case NUCLEAR: {
                    return "Measurement is done using the nuclear principle.";
                }
                case OPTICAL: {
                    return "Measurement is done using the optical principle.";
                }
                case THERMAL: {
                    return "Measurement is done using the thermal principle.";
                }
                case BIOLOGICAL: {
                    return "Measurement is done using the biological principle.";
                }
                case MECHANICAL: {
                    return "Measurement is done using the mechanical principle.";
                }
                case ACOUSTICAL: {
                    return "Measurement is done using the acoustical principle.";
                }
                case MANUAL: {
                    return "Measurement is done using the manual principle.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OTHER: {
                    return "MSP Other";
                }
                case CHEMICAL: {
                    return "MSP Chemical";
                }
                case ELECTRICAL: {
                    return "MSP Electrical";
                }
                case IMPEDANCE: {
                    return "MSP Impedance";
                }
                case NUCLEAR: {
                    return "MSP Nuclear";
                }
                case OPTICAL: {
                    return "MSP Optical";
                }
                case THERMAL: {
                    return "MSP Thermal";
                }
                case BIOLOGICAL: {
                    return "MSP Biological";
                }
                case MECHANICAL: {
                    return "MSP Mechanical";
                }
                case ACOUSTICAL: {
                    return "MSP Acoustical";
                }
                case MANUAL: {
                    return "MSP Manual";
                }
            }
            return "?";
        }
    }
}

