/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DocumentReference", profile="http://hl7.org/fhir/Profile/DocumentReference")
public class DocumentReference
extends DomainResource {
    @Child(name="masterIdentifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Master Version Specific Identifier", formalDefinition="Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.")
    protected Identifier masterIdentifier;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the document", formalDefinition="Other identifiers associated with the document, including version independent identifiers.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="current | superseded | entered-in-error", formalDefinition="The status of this document reference.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-reference-status")
    protected Enumeration<Enumerations.DocumentReferenceStatus> status;
    @Child(name="docStatus", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="preliminary | final | appended | amended | entered-in-error", formalDefinition="The status of the underlying document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-status")
    protected Enumeration<ReferredDocumentStatus> docStatus;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of document (LOINC if possible)", formalDefinition="Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-doc-typecodes")
    protected CodeableConcept type;
    @Child(name="class", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Categorization of document", formalDefinition="A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-doc-classcodes")
    protected CodeableConcept class_;
    @Child(name="subject", type={Patient.class, Practitioner.class, Group.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is the subject of the document", formalDefinition="Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="created", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Document creation time", formalDefinition="When the document was created.")
    protected DateTimeType created;
    @Child(name="date", type={InstantType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this document reference was created", formalDefinition="When the document reference was created.")
    protected InstantType date;
    @Child(name="agent", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Agent involved", formalDefinition="An actor taking an active role in the document.")
    protected List<DocumentReferenceAgentComponent> agent;
    @Child(name="authenticator", type={Practitioner.class, Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who/what authenticated the document", formalDefinition="Which person or organization authenticates that this document is valid.")
    protected Reference authenticator;
    protected Resource authenticatorTarget;
    @Child(name="custodian", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization which maintains the document", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.")
    protected Reference custodian;
    protected Organization custodianTarget;
    @Child(name="relatesTo", type={}, order=12, min=0, max=-1, modifier=true, summary=true)
    @Description(shortDefinition="Relationships to other documents", formalDefinition="Relationships that this document has with other document references that already exist.")
    protected List<DocumentReferenceRelatesToComponent> relatesTo;
    @Child(name="description", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable description (title)", formalDefinition="Human-readable description of the source document. This is sometimes known as the \"title\".")
    protected StringType description;
    @Child(name="securityLabel", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document security-tags", formalDefinition="A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    protected List<CodeableConcept> securityLabel;
    @Child(name="content", type={}, order=15, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document referenced", formalDefinition="The document and format referenced. There may be multiple content element repetitions, each with a different format.")
    protected List<DocumentReferenceContentComponent> content;
    @Child(name="context", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical context of document", formalDefinition="The clinical context in which the document was prepared.")
    protected DocumentReferenceContextComponent context;
    private static final long serialVersionUID = 1762186370L;
    @SearchParamDefinition(name="date", path="DocumentReference.date", description="When this document reference was created", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="securitylabel", path="DocumentReference.securityLabel", description="Document security-tags", type="token")
    public static final String SP_SECURITYLABEL = "securitylabel";
    public static final TokenClientParam SECURITYLABEL = new TokenClientParam("securitylabel");
    @SearchParamDefinition(name="agent", path="DocumentReference.agent.who", description="Who and/or what authored the document", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("DocumentReference:agent").toLocked();
    @SearchParamDefinition(name="subject", path="DocumentReference.subject", description="Who/what is the subject of the document", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Device.class, Group.class, Patient.class, Practitioner.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentReference:subject").toLocked();
    @SearchParamDefinition(name="description", path="DocumentReference.description", description="Human-readable description (title)", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="language", path="DocumentReference.content.attachment.language", description="Human language of the content (BCP-47)", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="type", path="DocumentReference.type", description="Kind of document (LOINC if possible)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="relation", path="DocumentReference.relatesTo.code", description="replaces | transforms | signs | appends", type="token")
    public static final String SP_RELATION = "relation";
    public static final TokenClientParam RELATION = new TokenClientParam("relation");
    @SearchParamDefinition(name="setting", path="DocumentReference.context.practiceSetting", description="Additional details about where the content was created (e.g. clinical specialty)", type="token")
    public static final String SP_SETTING = "setting";
    public static final TokenClientParam SETTING = new TokenClientParam("setting");
    @SearchParamDefinition(name="patient", path="DocumentReference.subject", description="Who/what is the subject of the document", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DocumentReference:patient").toLocked();
    @SearchParamDefinition(name="relationship", path="DocumentReference.relatesTo", description="Combination of relation and relatesTo", type="composite", compositeOf={"relatesto", "relation"})
    public static final String SP_RELATIONSHIP = "relationship";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATIONSHIP = new CompositeClientParam("relationship");
    @SearchParamDefinition(name="event", path="DocumentReference.context.event", description="Main clinical acts documented", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="class", path="DocumentReference.class", description="Categorization of document", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="authenticator", path="DocumentReference.authenticator", description="Who/what authenticated the document", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_AUTHENTICATOR = "authenticator";
    public static final ReferenceClientParam AUTHENTICATOR = new ReferenceClientParam("authenticator");
    public static final Include INCLUDE_AUTHENTICATOR = new Include("DocumentReference:authenticator").toLocked();
    @SearchParamDefinition(name="identifier", path="DocumentReference.masterIdentifier | DocumentReference.identifier", description="Master Version Specific Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="period", path="DocumentReference.context.period", description="Time of service that is being documented", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="related-id", path="DocumentReference.context.related.identifier", description="Identifier of related objects or events", type="token")
    public static final String SP_RELATED_ID = "related-id";
    public static final TokenClientParam RELATED_ID = new TokenClientParam("related-id");
    @SearchParamDefinition(name="custodian", path="DocumentReference.custodian", description="Organization which maintains the document", type="reference", target={Organization.class})
    public static final String SP_CUSTODIAN = "custodian";
    public static final ReferenceClientParam CUSTODIAN = new ReferenceClientParam("custodian");
    public static final Include INCLUDE_CUSTODIAN = new Include("DocumentReference:custodian").toLocked();
    @SearchParamDefinition(name="created", path="DocumentReference.created", description="Document creation time", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="format", path="DocumentReference.content.format", description="Format/content rules for the document", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="encounter", path="DocumentReference.context.encounter", description="Context of the document  content", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DocumentReference:encounter").toLocked();
    @SearchParamDefinition(name="contenttype", path="DocumentReference.content.attachment.contentType", description="Mime type of the content, with charset etc.", type="token")
    public static final String SP_CONTENTTYPE = "contenttype";
    public static final TokenClientParam CONTENTTYPE = new TokenClientParam("contenttype");
    @SearchParamDefinition(name="related-ref", path="DocumentReference.context.related.ref", description="Related Resource", type="reference")
    public static final String SP_RELATED_REF = "related-ref";
    public static final ReferenceClientParam RELATED_REF = new ReferenceClientParam("related-ref");
    public static final Include INCLUDE_RELATED_REF = new Include("DocumentReference:related-ref").toLocked();
    @SearchParamDefinition(name="location", path="DocumentReference.content.attachment.url", description="Uri where the data can be found", type="uri")
    public static final String SP_LOCATION = "location";
    public static final UriClientParam LOCATION = new UriClientParam("location");
    @SearchParamDefinition(name="relatesto", path="DocumentReference.relatesTo.target", description="Target of the relationship", type="reference", target={DocumentReference.class})
    public static final String SP_RELATESTO = "relatesto";
    public static final ReferenceClientParam RELATESTO = new ReferenceClientParam("relatesto");
    public static final Include INCLUDE_RELATESTO = new Include("DocumentReference:relatesto").toLocked();
    @SearchParamDefinition(name="facility", path="DocumentReference.context.facilityType", description="Kind of facility where patient was seen", type="token")
    public static final String SP_FACILITY = "facility";
    public static final TokenClientParam FACILITY = new TokenClientParam("facility");
    @SearchParamDefinition(name="status", path="DocumentReference.status", description="current | superseded | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public DocumentReference() {
    }

    public DocumentReference(Enumeration<Enumerations.DocumentReferenceStatus> status) {
        this.status = status;
    }

    public Identifier getMasterIdentifier() {
        if (this.masterIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.masterIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.masterIdentifier = new Identifier();
            }
        }
        return this.masterIdentifier;
    }

    public boolean hasMasterIdentifier() {
        return this.masterIdentifier != null && !this.masterIdentifier.isEmpty();
    }

    public DocumentReference setMasterIdentifier(Identifier value) {
        this.masterIdentifier = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DocumentReference setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DocumentReference addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.DocumentReferenceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DocumentReference setStatusElement(Enumeration<Enumerations.DocumentReferenceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.DocumentReferenceStatus getStatus() {
        return this.status == null ? null : (Enumerations.DocumentReferenceStatus)((Object)this.status.getValue());
    }

    public DocumentReference setStatus(Enumerations.DocumentReferenceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<ReferredDocumentStatus> getDocStatusElement() {
        if (this.docStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.docStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.docStatus = new Enumeration<ReferredDocumentStatus>(new ReferredDocumentStatusEnumFactory());
            }
        }
        return this.docStatus;
    }

    public boolean hasDocStatusElement() {
        return this.docStatus != null && !this.docStatus.isEmpty();
    }

    public boolean hasDocStatus() {
        return this.docStatus != null && !this.docStatus.isEmpty();
    }

    public DocumentReference setDocStatusElement(Enumeration<ReferredDocumentStatus> value) {
        this.docStatus = value;
        return this;
    }

    public ReferredDocumentStatus getDocStatus() {
        return this.docStatus == null ? null : (ReferredDocumentStatus)((Object)this.docStatus.getValue());
    }

    public DocumentReference setDocStatus(ReferredDocumentStatus value) {
        if (value == null) {
            this.docStatus = null;
        } else {
            if (this.docStatus == null) {
                this.docStatus = new Enumeration<ReferredDocumentStatus>(new ReferredDocumentStatusEnumFactory());
            }
            this.docStatus.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DocumentReference setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new CodeableConcept();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public DocumentReference setClass_(CodeableConcept value) {
        this.class_ = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DocumentReference setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DocumentReference setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public DocumentReference setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public DocumentReference setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public InstantType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new InstantType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public DocumentReference setDateElement(InstantType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public DocumentReference setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new InstantType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<DocumentReferenceAgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<DocumentReferenceAgentComponent>();
        }
        return this.agent;
    }

    public DocumentReference setAgent(List<DocumentReferenceAgentComponent> theAgent) {
        this.agent = theAgent;
        return this;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (DocumentReferenceAgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceAgentComponent addAgent() {
        DocumentReferenceAgentComponent t = new DocumentReferenceAgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<DocumentReferenceAgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public DocumentReference addAgent(DocumentReferenceAgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<DocumentReferenceAgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public DocumentReferenceAgentComponent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public Reference getAuthenticator() {
        if (this.authenticator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.authenticator");
            }
            if (Configuration.doAutoCreate()) {
                this.authenticator = new Reference();
            }
        }
        return this.authenticator;
    }

    public boolean hasAuthenticator() {
        return this.authenticator != null && !this.authenticator.isEmpty();
    }

    public DocumentReference setAuthenticator(Reference value) {
        this.authenticator = value;
        return this;
    }

    public Resource getAuthenticatorTarget() {
        return this.authenticatorTarget;
    }

    public DocumentReference setAuthenticatorTarget(Resource value) {
        this.authenticatorTarget = value;
        return this;
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public DocumentReference setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public Organization getCustodianTarget() {
        if (this.custodianTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodianTarget = new Organization();
            }
        }
        return this.custodianTarget;
    }

    public DocumentReference setCustodianTarget(Organization value) {
        this.custodianTarget = value;
        return this;
    }

    public List<DocumentReferenceRelatesToComponent> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        return this.relatesTo;
    }

    public DocumentReference setRelatesTo(List<DocumentReferenceRelatesToComponent> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (DocumentReferenceRelatesToComponent item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceRelatesToComponent addRelatesTo() {
        DocumentReferenceRelatesToComponent t = new DocumentReferenceRelatesToComponent();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public DocumentReference addRelatesTo(DocumentReferenceRelatesToComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public DocumentReferenceRelatesToComponent getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public DocumentReference setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public DocumentReference setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getSecurityLabel() {
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        return this.securityLabel;
    }

    public DocumentReference setSecurityLabel(List<CodeableConcept> theSecurityLabel) {
        this.securityLabel = theSecurityLabel;
        return this;
    }

    public boolean hasSecurityLabel() {
        if (this.securityLabel == null) {
            return false;
        }
        for (CodeableConcept item : this.securityLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSecurityLabel() {
        CodeableConcept t = new CodeableConcept();
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        this.securityLabel.add(t);
        return t;
    }

    public DocumentReference addSecurityLabel(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        this.securityLabel.add(t);
        return this;
    }

    public CodeableConcept getSecurityLabelFirstRep() {
        if (this.getSecurityLabel().isEmpty()) {
            this.addSecurityLabel();
        }
        return this.getSecurityLabel().get(0);
    }

    public List<DocumentReferenceContentComponent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        return this.content;
    }

    public DocumentReference setContent(List<DocumentReferenceContentComponent> theContent) {
        this.content = theContent;
        return this;
    }

    public boolean hasContent() {
        if (this.content == null) {
            return false;
        }
        for (DocumentReferenceContentComponent item : this.content) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceContentComponent addContent() {
        DocumentReferenceContentComponent t = new DocumentReferenceContentComponent();
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        this.content.add(t);
        return t;
    }

    public DocumentReference addContent(DocumentReferenceContentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        this.content.add(t);
        return this;
    }

    public DocumentReferenceContentComponent getContentFirstRep() {
        if (this.getContent().isEmpty()) {
            this.addContent();
        }
        return this.getContent().get(0);
    }

    public DocumentReferenceContextComponent getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new DocumentReferenceContextComponent();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public DocumentReference setContext(DocumentReferenceContextComponent value) {
        this.context = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("masterIdentifier", "Identifier", "Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.", 0, 1, this.masterIdentifier));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Other identifiers associated with the document, including version independent identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of this document reference.", 0, 1, this.status));
        children.add(new Property("docStatus", "code", "The status of the underlying document.", 0, 1, this.docStatus));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.", 0, 1, this.type));
        children.add(new Property(SP_CLASS, "CodeableConcept", "A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.", 0, 1, this.class_));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, 1, this.subject));
        children.add(new Property(SP_CREATED, "dateTime", "When the document was created.", 0, 1, this.created));
        children.add(new Property(SP_DATE, "instant", "When the document reference was created.", 0, 1, this.date));
        children.add(new Property(SP_AGENT, "", "An actor taking an active role in the document.", 0, Integer.MAX_VALUE, this.agent));
        children.add(new Property(SP_AUTHENTICATOR, "Reference(Practitioner|Organization)", "Which person or organization authenticates that this document is valid.", 0, 1, this.authenticator));
        children.add(new Property(SP_CUSTODIAN, "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, 1, this.custodian));
        children.add(new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property(SP_DESCRIPTION, "string", "Human-readable description of the source document. This is sometimes known as the \"title\".", 0, 1, this.description));
        children.add(new Property("securityLabel", "CodeableConcept", "A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.", 0, Integer.MAX_VALUE, this.securityLabel));
        children.add(new Property("content", "", "The document and format referenced. There may be multiple content element repetitions, each with a different format.", 0, Integer.MAX_VALUE, this.content));
        children.add(new Property("context", "", "The clinical context in which the document was prepared.", 0, 1, this.context));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 243769515: {
                return new Property("masterIdentifier", "Identifier", "Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.", 0, 1, this.masterIdentifier);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Other identifiers associated with the document, including version independent identifiers.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this document reference.", 0, 1, this.status);
            }
            case -23496886: {
                return new Property("docStatus", "code", "The status of the underlying document.", 0, 1, this.docStatus);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.", 0, 1, this.type);
            }
            case 94742904: {
                return new Property(SP_CLASS, "CodeableConcept", "A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.", 0, 1, this.class_);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, 1, this.subject);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "When the document was created.", 0, 1, this.created);
            }
            case 3076014: {
                return new Property(SP_DATE, "instant", "When the document reference was created.", 0, 1, this.date);
            }
            case 92750597: {
                return new Property(SP_AGENT, "", "An actor taking an active role in the document.", 0, Integer.MAX_VALUE, this.agent);
            }
            case 1815000435: {
                return new Property(SP_AUTHENTICATOR, "Reference(Practitioner|Organization)", "Which person or organization authenticates that this document is valid.", 0, 1, this.authenticator);
            }
            case 1611297262: {
                return new Property(SP_CUSTODIAN, "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, 1, this.custodian);
            }
            case -7765931: {
                return new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "string", "Human-readable description of the source document. This is sometimes known as the \"title\".", 0, 1, this.description);
            }
            case -722296940: {
                return new Property("securityLabel", "CodeableConcept", "A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.", 0, Integer.MAX_VALUE, this.securityLabel);
            }
            case 951530617: {
                return new Property("content", "", "The document and format referenced. There may be multiple content element repetitions, each with a different format.", 0, Integer.MAX_VALUE, this.content);
            }
            case 951530927: {
                return new Property("context", "", "The clinical context in which the document was prepared.", 0, 1, this.context);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 243769515: {
                Base[] baseArray;
                if (this.masterIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.masterIdentifier;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -23496886: {
                Base[] baseArray;
                if (this.docStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.docStatus;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.class_;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.created;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case 1815000435: {
                Base[] baseArray;
                if (this.authenticator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.authenticator;
                }
                return baseArray;
            }
            case 1611297262: {
                Base[] baseArray;
                if (this.custodian == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.custodian;
                }
                return baseArray;
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -722296940: {
                return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
            }
            case 951530617: {
                return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.context;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 243769515: {
                this.masterIdentifier = this.castToIdentifier(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.DocumentReferenceStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -23496886: {
                value = new ReferredDocumentStatusEnumFactory().fromType(this.castToCode(value));
                this.docStatus = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 94742904: {
                this.class_ = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToInstant(value);
                return value;
            }
            case 92750597: {
                this.getAgent().add((DocumentReferenceAgentComponent)((Object)value));
                return value;
            }
            case 1815000435: {
                this.authenticator = this.castToReference(value);
                return value;
            }
            case 1611297262: {
                this.custodian = this.castToReference(value);
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add((DocumentReferenceRelatesToComponent)((Object)value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -722296940: {
                this.getSecurityLabel().add(this.castToCodeableConcept(value));
                return value;
            }
            case 951530617: {
                this.getContent().add((DocumentReferenceContentComponent)((Object)value));
                return value;
            }
            case 951530927: {
                this.context = (DocumentReferenceContextComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("masterIdentifier")) {
            this.masterIdentifier = this.castToIdentifier(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.DocumentReferenceStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("docStatus")) {
            value = new ReferredDocumentStatusEnumFactory().fromType(this.castToCode(value));
            this.docStatus = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CLASS)) {
            this.class_ = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToInstant(value);
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((DocumentReferenceAgentComponent)((Object)value));
        } else if (name.equals(SP_AUTHENTICATOR)) {
            this.authenticator = this.castToReference(value);
        } else if (name.equals(SP_CUSTODIAN)) {
            this.custodian = this.castToReference(value);
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add((DocumentReferenceRelatesToComponent)((Object)value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("securityLabel")) {
            this.getSecurityLabel().add(this.castToCodeableConcept(value));
        } else if (name.equals("content")) {
            this.getContent().add((DocumentReferenceContentComponent)((Object)value));
        } else if (name.equals("context")) {
            this.context = (DocumentReferenceContextComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 243769515: {
                return this.getMasterIdentifier();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -23496886: {
                return this.getDocStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 94742904: {
                return this.getClass_();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 92750597: {
                return this.addAgent();
            }
            case 1815000435: {
                return this.getAuthenticator();
            }
            case 1611297262: {
                return this.getCustodian();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -722296940: {
                return this.addSecurityLabel();
            }
            case 951530617: {
                return this.addContent();
            }
            case 951530927: {
                return this.getContext();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 243769515: {
                return new String[]{"Identifier"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -23496886: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 94742904: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 3076014: {
                return new String[]{"instant"};
            }
            case 92750597: {
                return new String[0];
            }
            case 1815000435: {
                return new String[]{"Reference"};
            }
            case 1611297262: {
                return new String[]{"Reference"};
            }
            case -7765931: {
                return new String[0];
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -722296940: {
                return new String[]{"CodeableConcept"};
            }
            case 951530617: {
                return new String[0];
            }
            case 951530927: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("masterIdentifier")) {
            this.masterIdentifier = new Identifier();
            return this.masterIdentifier;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.status");
        }
        if (name.equals("docStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.docStatus");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CLASS)) {
            this.class_ = new CodeableConcept();
            return this.class_;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.created");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.date");
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_AUTHENTICATOR)) {
            this.authenticator = new Reference();
            return this.authenticator;
        }
        if (name.equals(SP_CUSTODIAN)) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.description");
        }
        if (name.equals("securityLabel")) {
            return this.addSecurityLabel();
        }
        if (name.equals("content")) {
            return this.addContent();
        }
        if (name.equals("context")) {
            this.context = new DocumentReferenceContextComponent();
            return this.context;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DocumentReference";
    }

    @Override
    public DocumentReference copy() {
        DocumentReference dst = new DocumentReference();
        this.copyValues(dst);
        Identifier identifier = dst.masterIdentifier = this.masterIdentifier == null ? null : this.masterIdentifier.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.identifier) {
                dst.identifier.add(identifier2.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.docStatus = this.docStatus == null ? null : this.docStatus.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.class_ = this.class_ == null ? null : this.class_.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.created = this.created == null ? null : this.created.copy();
        InstantType instantType = dst.date = this.date == null ? null : this.date.copy();
        if (this.agent != null) {
            dst.agent = new ArrayList<DocumentReferenceAgentComponent>();
            for (DocumentReferenceAgentComponent documentReferenceAgentComponent : this.agent) {
                dst.agent.add(documentReferenceAgentComponent.copy());
            }
        }
        dst.authenticator = this.authenticator == null ? null : this.authenticator.copy();
        Reference reference = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
            for (DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : this.relatesTo) {
                dst.relatesTo.add(documentReferenceRelatesToComponent.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.securityLabel != null) {
            dst.securityLabel = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.securityLabel) {
                dst.securityLabel.add(codeableConcept.copy());
            }
        }
        if (this.content != null) {
            dst.content = new ArrayList<DocumentReferenceContentComponent>();
            for (DocumentReferenceContentComponent documentReferenceContentComponent : this.content) {
                dst.content.add(documentReferenceContentComponent.copy());
            }
        }
        dst.context = this.context == null ? null : this.context.copy();
        return dst;
    }

    protected DocumentReference typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DocumentReference)) {
            return false;
        }
        DocumentReference o = (DocumentReference)other_;
        return DocumentReference.compareDeep(this.masterIdentifier, o.masterIdentifier, true) && DocumentReference.compareDeep(this.identifier, o.identifier, true) && DocumentReference.compareDeep(this.status, o.status, true) && DocumentReference.compareDeep(this.docStatus, o.docStatus, true) && DocumentReference.compareDeep(this.type, o.type, true) && DocumentReference.compareDeep(this.class_, o.class_, true) && DocumentReference.compareDeep(this.subject, o.subject, true) && DocumentReference.compareDeep(this.created, o.created, true) && DocumentReference.compareDeep(this.date, o.date, true) && DocumentReference.compareDeep(this.agent, o.agent, true) && DocumentReference.compareDeep(this.authenticator, o.authenticator, true) && DocumentReference.compareDeep(this.custodian, o.custodian, true) && DocumentReference.compareDeep(this.relatesTo, o.relatesTo, true) && DocumentReference.compareDeep(this.description, o.description, true) && DocumentReference.compareDeep(this.securityLabel, o.securityLabel, true) && DocumentReference.compareDeep(this.content, o.content, true) && DocumentReference.compareDeep(this.context, o.context, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DocumentReference)) {
            return false;
        }
        DocumentReference o = (DocumentReference)other_;
        return DocumentReference.compareValues(this.status, o.status, true) && DocumentReference.compareValues(this.docStatus, o.docStatus, true) && DocumentReference.compareValues(this.created, o.created, true) && DocumentReference.compareValues(this.date, o.date, true) && DocumentReference.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.masterIdentifier, this.identifier, this.status, this.docStatus, this.type, this.class_, this.subject, this.created, this.date, this.agent, this.authenticator, this.custodian, this.relatesTo, this.description, this.securityLabel, this.content, this.context});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DocumentReference;
    }

    @Block
    public static class DocumentReferenceContextRelatedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier of related objects or events", formalDefinition="Related identifier to this DocumentReference. If both id and ref are present they shall refer to the same thing.")
        protected Identifier identifier;
        @Child(name="ref", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Related Resource", formalDefinition="Related Resource to this DocumentReference. If both id and ref are present they shall refer to the same thing.")
        protected Reference ref;
        protected Resource refTarget;
        private static final long serialVersionUID = -1670123330L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextRelatedComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public DocumentReferenceContextRelatedComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public Reference getRef() {
            if (this.ref == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextRelatedComponent.ref");
                }
                if (Configuration.doAutoCreate()) {
                    this.ref = new Reference();
                }
            }
            return this.ref;
        }

        public boolean hasRef() {
            return this.ref != null && !this.ref.isEmpty();
        }

        public DocumentReferenceContextRelatedComponent setRef(Reference value) {
            this.ref = value;
            return this;
        }

        public Resource getRefTarget() {
            return this.refTarget;
        }

        public DocumentReferenceContextRelatedComponent setRefTarget(Resource value) {
            this.refTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DocumentReference.SP_IDENTIFIER, "Identifier", "Related identifier to this DocumentReference. If both id and ref are present they shall refer to the same thing.", 0, 1, this.identifier));
            children.add(new Property("ref", "Reference(Any)", "Related Resource to this DocumentReference. If both id and ref are present they shall refer to the same thing.", 0, 1, this.ref));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(DocumentReference.SP_IDENTIFIER, "Identifier", "Related identifier to this DocumentReference. If both id and ref are present they shall refer to the same thing.", 0, 1, this.identifier);
                }
                case 112787: {
                    return new Property("ref", "Reference(Any)", "Related Resource to this DocumentReference. If both id and ref are present they shall refer to the same thing.", 0, 1, this.ref);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 112787: {
                    Base[] baseArray;
                    if (this.ref == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.ref;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 112787: {
                    this.ref = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DocumentReference.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("ref")) {
                this.ref = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 112787: {
                    return this.getRef();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 112787: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DocumentReference.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("ref")) {
                this.ref = new Reference();
                return this.ref;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceContextRelatedComponent copy() {
            DocumentReferenceContextRelatedComponent dst = new DocumentReferenceContextRelatedComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.ref = this.ref == null ? null : this.ref.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContextRelatedComponent)) {
                return false;
            }
            DocumentReferenceContextRelatedComponent o = (DocumentReferenceContextRelatedComponent)other_;
            return DocumentReferenceContextRelatedComponent.compareDeep(this.identifier, o.identifier, true) && DocumentReferenceContextRelatedComponent.compareDeep(this.ref, o.ref, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContextRelatedComponent)) {
                return false;
            }
            DocumentReferenceContextRelatedComponent o = (DocumentReferenceContextRelatedComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.ref});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.context.related";
        }
    }

    @Block
    public static class DocumentReferenceContextComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="encounter", type={Encounter.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Context of the document  content", formalDefinition="Describes the clinical encounter or type of care that the document content is associated with.")
        protected Reference encounter;
        protected Encounter encounterTarget;
        @Child(name="event", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Main clinical acts documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActCode")
        protected List<CodeableConcept> event;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Time of service that is being documented", formalDefinition="The time period over which the service that is described by the document was provided.")
        protected Period period;
        @Child(name="facilityType", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of facility where patient was seen", formalDefinition="The kind of facility where the patient was seen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-facilitycodes")
        protected CodeableConcept facilityType;
        @Child(name="practiceSetting", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional details about where the content was created (e.g. clinical specialty)", formalDefinition="This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
        protected CodeableConcept practiceSetting;
        @Child(name="sourcePatientInfo", type={Patient.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Patient demographics from source", formalDefinition="The Patient Information as known when the document was published. May be a reference to a version specific, or contained.")
        protected Reference sourcePatientInfo;
        protected Patient sourcePatientInfoTarget;
        @Child(name="related", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Related identifiers or resources", formalDefinition="Related identifiers or resources associated with the DocumentReference.")
        protected List<DocumentReferenceContextRelatedComponent> related;
        private static final long serialVersionUID = 994799273L;

        public Reference getEncounter() {
            if (this.encounter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.encounter");
                }
                if (Configuration.doAutoCreate()) {
                    this.encounter = new Reference();
                }
            }
            return this.encounter;
        }

        public boolean hasEncounter() {
            return this.encounter != null && !this.encounter.isEmpty();
        }

        public DocumentReferenceContextComponent setEncounter(Reference value) {
            this.encounter = value;
            return this;
        }

        public Encounter getEncounterTarget() {
            if (this.encounterTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.encounter");
                }
                if (Configuration.doAutoCreate()) {
                    this.encounterTarget = new Encounter();
                }
            }
            return this.encounterTarget;
        }

        public DocumentReferenceContextComponent setEncounterTarget(Encounter value) {
            this.encounterTarget = value;
            return this;
        }

        public List<CodeableConcept> getEvent() {
            if (this.event == null) {
                this.event = new ArrayList<CodeableConcept>();
            }
            return this.event;
        }

        public DocumentReferenceContextComponent setEvent(List<CodeableConcept> theEvent) {
            this.event = theEvent;
            return this;
        }

        public boolean hasEvent() {
            if (this.event == null) {
                return false;
            }
            for (CodeableConcept item : this.event) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addEvent() {
            CodeableConcept t = new CodeableConcept();
            if (this.event == null) {
                this.event = new ArrayList<CodeableConcept>();
            }
            this.event.add(t);
            return t;
        }

        public DocumentReferenceContextComponent addEvent(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.event == null) {
                this.event = new ArrayList<CodeableConcept>();
            }
            this.event.add(t);
            return this;
        }

        public CodeableConcept getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                this.addEvent();
            }
            return this.getEvent().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public DocumentReferenceContextComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public CodeableConcept getFacilityType() {
            if (this.facilityType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.facilityType");
                }
                if (Configuration.doAutoCreate()) {
                    this.facilityType = new CodeableConcept();
                }
            }
            return this.facilityType;
        }

        public boolean hasFacilityType() {
            return this.facilityType != null && !this.facilityType.isEmpty();
        }

        public DocumentReferenceContextComponent setFacilityType(CodeableConcept value) {
            this.facilityType = value;
            return this;
        }

        public CodeableConcept getPracticeSetting() {
            if (this.practiceSetting == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.practiceSetting");
                }
                if (Configuration.doAutoCreate()) {
                    this.practiceSetting = new CodeableConcept();
                }
            }
            return this.practiceSetting;
        }

        public boolean hasPracticeSetting() {
            return this.practiceSetting != null && !this.practiceSetting.isEmpty();
        }

        public DocumentReferenceContextComponent setPracticeSetting(CodeableConcept value) {
            this.practiceSetting = value;
            return this;
        }

        public Reference getSourcePatientInfo() {
            if (this.sourcePatientInfo == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.sourcePatientInfo");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourcePatientInfo = new Reference();
                }
            }
            return this.sourcePatientInfo;
        }

        public boolean hasSourcePatientInfo() {
            return this.sourcePatientInfo != null && !this.sourcePatientInfo.isEmpty();
        }

        public DocumentReferenceContextComponent setSourcePatientInfo(Reference value) {
            this.sourcePatientInfo = value;
            return this;
        }

        public Patient getSourcePatientInfoTarget() {
            if (this.sourcePatientInfoTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContextComponent.sourcePatientInfo");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourcePatientInfoTarget = new Patient();
                }
            }
            return this.sourcePatientInfoTarget;
        }

        public DocumentReferenceContextComponent setSourcePatientInfoTarget(Patient value) {
            this.sourcePatientInfoTarget = value;
            return this;
        }

        public List<DocumentReferenceContextRelatedComponent> getRelated() {
            if (this.related == null) {
                this.related = new ArrayList<DocumentReferenceContextRelatedComponent>();
            }
            return this.related;
        }

        public DocumentReferenceContextComponent setRelated(List<DocumentReferenceContextRelatedComponent> theRelated) {
            this.related = theRelated;
            return this;
        }

        public boolean hasRelated() {
            if (this.related == null) {
                return false;
            }
            for (DocumentReferenceContextRelatedComponent item : this.related) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DocumentReferenceContextRelatedComponent addRelated() {
            DocumentReferenceContextRelatedComponent t = new DocumentReferenceContextRelatedComponent();
            if (this.related == null) {
                this.related = new ArrayList<DocumentReferenceContextRelatedComponent>();
            }
            this.related.add(t);
            return t;
        }

        public DocumentReferenceContextComponent addRelated(DocumentReferenceContextRelatedComponent t) {
            if (t == null) {
                return this;
            }
            if (this.related == null) {
                this.related = new ArrayList<DocumentReferenceContextRelatedComponent>();
            }
            this.related.add(t);
            return this;
        }

        public DocumentReferenceContextRelatedComponent getRelatedFirstRep() {
            if (this.getRelated().isEmpty()) {
                this.addRelated();
            }
            return this.getRelated().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DocumentReference.SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care that the document content is associated with.", 0, 1, this.encounter));
            children.add(new Property(DocumentReference.SP_EVENT, "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.event));
            children.add(new Property(DocumentReference.SP_PERIOD, "Period", "The time period over which the service that is described by the document was provided.", 0, 1, this.period));
            children.add(new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, 1, this.facilityType));
            children.add(new Property("practiceSetting", "CodeableConcept", "This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.", 0, 1, this.practiceSetting));
            children.add(new Property("sourcePatientInfo", "Reference(Patient)", "The Patient Information as known when the document was published. May be a reference to a version specific, or contained.", 0, 1, this.sourcePatientInfo));
            children.add(new Property("related", "", "Related identifiers or resources associated with the DocumentReference.", 0, Integer.MAX_VALUE, this.related));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1524132147: {
                    return new Property(DocumentReference.SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care that the document content is associated with.", 0, 1, this.encounter);
                }
                case 96891546: {
                    return new Property(DocumentReference.SP_EVENT, "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.event);
                }
                case -991726143: {
                    return new Property(DocumentReference.SP_PERIOD, "Period", "The time period over which the service that is described by the document was provided.", 0, 1, this.period);
                }
                case 370698365: {
                    return new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, 1, this.facilityType);
                }
                case 331373717: {
                    return new Property("practiceSetting", "CodeableConcept", "This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.", 0, 1, this.practiceSetting);
                }
                case 2031381048: {
                    return new Property("sourcePatientInfo", "Reference(Patient)", "The Patient Information as known when the document was published. May be a reference to a version specific, or contained.", 0, 1, this.sourcePatientInfo);
                }
                case 1090493483: {
                    return new Property("related", "", "Related identifiers or resources associated with the DocumentReference.", 0, Integer.MAX_VALUE, this.related);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1524132147: {
                    Base[] baseArray;
                    if (this.encounter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.encounter;
                    }
                    return baseArray;
                }
                case 96891546: {
                    return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 370698365: {
                    Base[] baseArray;
                    if (this.facilityType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.facilityType;
                    }
                    return baseArray;
                }
                case 331373717: {
                    Base[] baseArray;
                    if (this.practiceSetting == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.practiceSetting;
                    }
                    return baseArray;
                }
                case 2031381048: {
                    Base[] baseArray;
                    if (this.sourcePatientInfo == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.sourcePatientInfo;
                    }
                    return baseArray;
                }
                case 1090493483: {
                    return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1524132147: {
                    this.encounter = this.castToReference(value);
                    return value;
                }
                case 96891546: {
                    this.getEvent().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case 370698365: {
                    this.facilityType = this.castToCodeableConcept(value);
                    return value;
                }
                case 331373717: {
                    this.practiceSetting = this.castToCodeableConcept(value);
                    return value;
                }
                case 2031381048: {
                    this.sourcePatientInfo = this.castToReference(value);
                    return value;
                }
                case 1090493483: {
                    this.getRelated().add((DocumentReferenceContextRelatedComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DocumentReference.SP_ENCOUNTER)) {
                this.encounter = this.castToReference(value);
            } else if (name.equals(DocumentReference.SP_EVENT)) {
                this.getEvent().add(this.castToCodeableConcept(value));
            } else if (name.equals(DocumentReference.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("facilityType")) {
                this.facilityType = this.castToCodeableConcept(value);
            } else if (name.equals("practiceSetting")) {
                this.practiceSetting = this.castToCodeableConcept(value);
            } else if (name.equals("sourcePatientInfo")) {
                this.sourcePatientInfo = this.castToReference(value);
            } else if (name.equals("related")) {
                this.getRelated().add((DocumentReferenceContextRelatedComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1524132147: {
                    return this.getEncounter();
                }
                case 96891546: {
                    return this.addEvent();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 370698365: {
                    return this.getFacilityType();
                }
                case 331373717: {
                    return this.getPracticeSetting();
                }
                case 2031381048: {
                    return this.getSourcePatientInfo();
                }
                case 1090493483: {
                    return this.addRelated();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1524132147: {
                    return new String[]{"Reference"};
                }
                case 96891546: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 370698365: {
                    return new String[]{"CodeableConcept"};
                }
                case 331373717: {
                    return new String[]{"CodeableConcept"};
                }
                case 2031381048: {
                    return new String[]{"Reference"};
                }
                case 1090493483: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DocumentReference.SP_ENCOUNTER)) {
                this.encounter = new Reference();
                return this.encounter;
            }
            if (name.equals(DocumentReference.SP_EVENT)) {
                return this.addEvent();
            }
            if (name.equals(DocumentReference.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("facilityType")) {
                this.facilityType = new CodeableConcept();
                return this.facilityType;
            }
            if (name.equals("practiceSetting")) {
                this.practiceSetting = new CodeableConcept();
                return this.practiceSetting;
            }
            if (name.equals("sourcePatientInfo")) {
                this.sourcePatientInfo = new Reference();
                return this.sourcePatientInfo;
            }
            if (name.equals("related")) {
                return this.addRelated();
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceContextComponent copy() {
            DocumentReferenceContextComponent dst = new DocumentReferenceContextComponent();
            this.copyValues(dst);
            Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
            if (this.event != null) {
                dst.event = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.event) {
                    dst.event.add(codeableConcept.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
            dst.facilityType = this.facilityType == null ? null : this.facilityType.copy();
            dst.practiceSetting = this.practiceSetting == null ? null : this.practiceSetting.copy();
            Reference reference2 = dst.sourcePatientInfo = this.sourcePatientInfo == null ? null : this.sourcePatientInfo.copy();
            if (this.related != null) {
                dst.related = new ArrayList<DocumentReferenceContextRelatedComponent>();
                for (DocumentReferenceContextRelatedComponent documentReferenceContextRelatedComponent : this.related) {
                    dst.related.add(documentReferenceContextRelatedComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContextComponent)) {
                return false;
            }
            DocumentReferenceContextComponent o = (DocumentReferenceContextComponent)other_;
            return DocumentReferenceContextComponent.compareDeep(this.encounter, o.encounter, true) && DocumentReferenceContextComponent.compareDeep(this.event, o.event, true) && DocumentReferenceContextComponent.compareDeep(this.period, o.period, true) && DocumentReferenceContextComponent.compareDeep(this.facilityType, o.facilityType, true) && DocumentReferenceContextComponent.compareDeep(this.practiceSetting, o.practiceSetting, true) && DocumentReferenceContextComponent.compareDeep(this.sourcePatientInfo, o.sourcePatientInfo, true) && DocumentReferenceContextComponent.compareDeep(this.related, o.related, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContextComponent)) {
                return false;
            }
            DocumentReferenceContextComponent o = (DocumentReferenceContextComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.encounter, this.event, this.period, this.facilityType, this.practiceSetting, this.sourcePatientInfo, this.related});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.context";
        }
    }

    @Block
    public static class DocumentReferenceContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="attachment", type={Attachment.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to access the document", formalDefinition="The document or URL of the document along with critical metadata to prove content has integrity.")
        protected Attachment attachment;
        @Child(name="format", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Format/content rules for the document", formalDefinition="An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/formatcodes")
        protected Coding format;
        private static final long serialVersionUID = -1313860217L;

        public DocumentReferenceContentComponent() {
        }

        public DocumentReferenceContentComponent(Attachment attachment) {
            this.attachment = attachment;
        }

        public Attachment getAttachment() {
            if (this.attachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContentComponent.attachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.attachment = new Attachment();
                }
            }
            return this.attachment;
        }

        public boolean hasAttachment() {
            return this.attachment != null && !this.attachment.isEmpty();
        }

        public DocumentReferenceContentComponent setAttachment(Attachment value) {
            this.attachment = value;
            return this;
        }

        public Coding getFormat() {
            if (this.format == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContentComponent.format");
                }
                if (Configuration.doAutoCreate()) {
                    this.format = new Coding();
                }
            }
            return this.format;
        }

        public boolean hasFormat() {
            return this.format != null && !this.format.isEmpty();
        }

        public DocumentReferenceContentComponent setFormat(Coding value) {
            this.format = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("attachment", "Attachment", "The document or URL of the document along with critical metadata to prove content has integrity.", 0, 1, this.attachment));
            children.add(new Property(DocumentReference.SP_FORMAT, "Coding", "An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.", 0, 1, this.format));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1963501277: {
                    return new Property("attachment", "Attachment", "The document or URL of the document along with critical metadata to prove content has integrity.", 0, 1, this.attachment);
                }
                case -1268779017: {
                    return new Property(DocumentReference.SP_FORMAT, "Coding", "An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.", 0, 1, this.format);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    Base[] baseArray;
                    if (this.attachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.attachment;
                    }
                    return baseArray;
                }
                case -1268779017: {
                    Base[] baseArray;
                    if (this.format == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.format;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    this.attachment = this.castToAttachment(value);
                    return value;
                }
                case -1268779017: {
                    this.format = this.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = this.castToAttachment(value);
            } else if (name.equals(DocumentReference.SP_FORMAT)) {
                this.format = this.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    return this.getAttachment();
                }
                case -1268779017: {
                    return this.getFormat();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    return new String[]{"Attachment"};
                }
                case -1268779017: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = new Attachment();
                return this.attachment;
            }
            if (name.equals(DocumentReference.SP_FORMAT)) {
                this.format = new Coding();
                return this.format;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceContentComponent copy() {
            DocumentReferenceContentComponent dst = new DocumentReferenceContentComponent();
            this.copyValues(dst);
            dst.attachment = this.attachment == null ? null : this.attachment.copy();
            dst.format = this.format == null ? null : this.format.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentComponent)) {
                return false;
            }
            DocumentReferenceContentComponent o = (DocumentReferenceContentComponent)other_;
            return DocumentReferenceContentComponent.compareDeep(this.attachment, o.attachment, true) && DocumentReferenceContentComponent.compareDeep(this.format, o.format, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentComponent)) {
                return false;
            }
            DocumentReferenceContentComponent o = (DocumentReferenceContentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.attachment, this.format});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.content";
        }
    }

    @Block
    public static class DocumentReferenceRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="replaces | transforms | signs | appends", formalDefinition="The type of relationship that this document has with anther document.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-relationship-type")
        protected Enumeration<DocumentRelationshipType> code;
        @Child(name="target", type={DocumentReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Target of the relationship", formalDefinition="The target document of this relationship.")
        protected Reference target;
        protected DocumentReference targetTarget;
        private static final long serialVersionUID = -347257495L;

        public DocumentReferenceRelatesToComponent() {
        }

        public DocumentReferenceRelatesToComponent(Enumeration<DocumentRelationshipType> code, Reference target) {
            this.code = code;
            this.target = target;
        }

        public Enumeration<DocumentRelationshipType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<DocumentRelationshipType>(new DocumentRelationshipTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DocumentReferenceRelatesToComponent setCodeElement(Enumeration<DocumentRelationshipType> value) {
            this.code = value;
            return this;
        }

        public DocumentRelationshipType getCode() {
            return this.code == null ? null : (DocumentRelationshipType)((Object)this.code.getValue());
        }

        public DocumentReferenceRelatesToComponent setCode(DocumentRelationshipType value) {
            if (this.code == null) {
                this.code = new Enumeration<DocumentRelationshipType>(new DocumentRelationshipTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public DocumentReferenceRelatesToComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public DocumentReference getTargetTarget() {
            if (this.targetTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetTarget = new DocumentReference();
                }
            }
            return this.targetTarget;
        }

        public DocumentReferenceRelatesToComponent setTargetTarget(DocumentReference value) {
            this.targetTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "The type of relationship that this document has with anther document.", 0, 1, this.code));
            children.add(new Property("target", "Reference(DocumentReference)", "The target document of this relationship.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "The type of relationship that this document has with anther document.", 0, 1, this.code);
                }
                case -880905839: {
                    return new Property("target", "Reference(DocumentReference)", "The target document of this relationship.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new DocumentRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case -880905839: {
                    this.target = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new DocumentRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("target")) {
                this.target = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.code");
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceRelatesToComponent copy() {
            DocumentReferenceRelatesToComponent dst = new DocumentReferenceRelatesToComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.target = this.target == null ? null : this.target.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceRelatesToComponent)) {
                return false;
            }
            DocumentReferenceRelatesToComponent o = (DocumentReferenceRelatesToComponent)other_;
            return DocumentReferenceRelatesToComponent.compareDeep(this.code, o.code, true) && DocumentReferenceRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceRelatesToComponent)) {
                return false;
            }
            DocumentReferenceRelatesToComponent o = (DocumentReferenceRelatesToComponent)other_;
            return DocumentReferenceRelatesToComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.target});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.relatesTo";
        }
    }

    @Block
    public static class DocumentReferenceAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How agent participated", formalDefinition="Specification of the participation type the agent played.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept type;
        @Child(name="who", type={Practitioner.class, PractitionerRole.class, Organization.class, Device.class, Patient.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who and/or what authored the document", formalDefinition="Identifies who is responsible for adding the information to the document.")
        protected Reference who;
        protected Resource whoTarget;
        private static final long serialVersionUID = -1480994789L;

        public DocumentReferenceAgentComponent() {
        }

        public DocumentReferenceAgentComponent(Reference who) {
            this.who = who;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAgentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DocumentReferenceAgentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAgentComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public DocumentReferenceAgentComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public Resource getWhoTarget() {
            return this.whoTarget;
        }

        public DocumentReferenceAgentComponent setWhoTarget(Resource value) {
            this.whoTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DocumentReference.SP_TYPE, "CodeableConcept", "Specification of the participation type the agent played.", 0, 1, this.type));
            children.add(new Property("who", "Reference(Practitioner|PractitionerRole|Organization|Device|Patient|RelatedPerson)", "Identifies who is responsible for adding the information to the document.", 0, 1, this.who));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DocumentReference.SP_TYPE, "CodeableConcept", "Specification of the participation type the agent played.", 0, 1, this.type);
                }
                case 117694: {
                    return new Property("who", "Reference(Practitioner|PractitionerRole|Organization|Device|Patient|RelatedPerson)", "Identifies who is responsible for adding the information to the document.", 0, 1, this.who);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.who;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 117694: {
                    this.who = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DocumentReference.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("who")) {
                this.who = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 117694: {
                    return this.getWho();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 117694: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DocumentReference.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceAgentComponent copy() {
            DocumentReferenceAgentComponent dst = new DocumentReferenceAgentComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.who = this.who == null ? null : this.who.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceAgentComponent)) {
                return false;
            }
            DocumentReferenceAgentComponent o = (DocumentReferenceAgentComponent)other_;
            return DocumentReferenceAgentComponent.compareDeep(this.type, o.type, true) && DocumentReferenceAgentComponent.compareDeep(this.who, o.who, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceAgentComponent)) {
                return false;
            }
            DocumentReferenceAgentComponent o = (DocumentReferenceAgentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.who});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.agent";
        }
    }

    public static class DocumentRelationshipTypeEnumFactory
    implements EnumFactory<DocumentRelationshipType> {
        @Override
        public DocumentRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return DocumentRelationshipType.REPLACES;
            }
            if ("transforms".equals(codeString)) {
                return DocumentRelationshipType.TRANSFORMS;
            }
            if ("signs".equals(codeString)) {
                return DocumentRelationshipType.SIGNS;
            }
            if ("appends".equals(codeString)) {
                return DocumentRelationshipType.APPENDS;
            }
            throw new IllegalArgumentException("Unknown DocumentRelationshipType code '" + codeString + "'");
        }

        public Enumeration<DocumentRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DocumentRelationshipType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.REPLACES);
            }
            if ("transforms".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.TRANSFORMS);
            }
            if ("signs".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.SIGNS);
            }
            if ("appends".equals(codeString)) {
                return new Enumeration<DocumentRelationshipType>(this, DocumentRelationshipType.APPENDS);
            }
            throw new FHIRException("Unknown DocumentRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentRelationshipType code) {
            if (code == DocumentRelationshipType.REPLACES) {
                return "replaces";
            }
            if (code == DocumentRelationshipType.TRANSFORMS) {
                return "transforms";
            }
            if (code == DocumentRelationshipType.SIGNS) {
                return "signs";
            }
            if (code == DocumentRelationshipType.APPENDS) {
                return "appends";
            }
            return "?";
        }

        @Override
        public String toSystem(DocumentRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum DocumentRelationshipType {
        REPLACES,
        TRANSFORMS,
        SIGNS,
        APPENDS,
        NULL;


        public static DocumentRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("transforms".equals(codeString)) {
                return TRANSFORMS;
            }
            if ("signs".equals(codeString)) {
                return SIGNS;
            }
            if ("appends".equals(codeString)) {
                return APPENDS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DocumentRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REPLACES: {
                    return "replaces";
                }
                case TRANSFORMS: {
                    return "transforms";
                }
                case SIGNS: {
                    return "signs";
                }
                case APPENDS: {
                    return "appends";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REPLACES: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
                case TRANSFORMS: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
                case SIGNS: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
                case APPENDS: {
                    return "http://hl7.org/fhir/document-relationship-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REPLACES: {
                    return "This document logically replaces or supersedes the target document.";
                }
                case TRANSFORMS: {
                    return "This document was generated by transforming the target document (e.g. format or language conversion).";
                }
                case SIGNS: {
                    return "This document is a signature of the target document.";
                }
                case APPENDS: {
                    return "This document adds additional information to the target document.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REPLACES: {
                    return "Replaces";
                }
                case TRANSFORMS: {
                    return "Transforms";
                }
                case SIGNS: {
                    return "Signs";
                }
                case APPENDS: {
                    return "Appends";
                }
            }
            return "?";
        }
    }

    public static class ReferredDocumentStatusEnumFactory
    implements EnumFactory<ReferredDocumentStatus> {
        @Override
        public ReferredDocumentStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return ReferredDocumentStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return ReferredDocumentStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return ReferredDocumentStatus.AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ReferredDocumentStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ReferredDocumentStatus code '" + codeString + "'");
        }

        public Enumeration<ReferredDocumentStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReferredDocumentStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<ReferredDocumentStatus>(this, ReferredDocumentStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<ReferredDocumentStatus>(this, ReferredDocumentStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<ReferredDocumentStatus>(this, ReferredDocumentStatus.AMENDED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ReferredDocumentStatus>(this, ReferredDocumentStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ReferredDocumentStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferredDocumentStatus code) {
            if (code == ReferredDocumentStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == ReferredDocumentStatus.FINAL) {
                return "final";
            }
            if (code == ReferredDocumentStatus.AMENDED) {
                return "amended";
            }
            if (code == ReferredDocumentStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferredDocumentStatus code) {
            return code.getSystem();
        }
    }

    public static enum ReferredDocumentStatus {
        PRELIMINARY,
        FINAL,
        AMENDED,
        ENTEREDINERROR,
        NULL;


        public static ReferredDocumentStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReferredDocumentStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/composition-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRELIMINARY: {
                    return "This is a preliminary composition or document (also known as initial or interim). The content may be incomplete or unverified.";
                }
                case FINAL: {
                    return "This version of the composition is complete and verified by an appropriate person and no further work is planned. Any subsequent updates would be on a new version of the composition.";
                }
                case AMENDED: {
                    return "The composition content or the referenced resources have been modified (edited or added to) subsequent to being released as \"final\" and the composition is complete and verified by an authorized person.";
                }
                case ENTEREDINERROR: {
                    return "The composition or document was originally created/issued in error, and this is an amendment that marks that the entire series should not be considered as valid.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

