/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImplementationGuide", profile="http://hl7.org/fhir/Profile/ImplementationGuide")
@ChildOrder(names={"url", "version", "name", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "copyright", "fhirVersion", "dependsOn", "global", "definition", "manifest"})
public class ImplementationGuide
extends MetadataResource {
    @Child(name="copyright", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.")
    protected MarkdownType copyright;
    @Child(name="fhirVersion", type={IdType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version this Implementation Guide targets", formalDefinition="The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.4.0 for this version.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-versions")
    protected IdType fhirVersion;
    @Child(name="dependsOn", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Another Implementation guide this depends on", formalDefinition="Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.")
    protected List<ImplementationGuideDependsOnComponent> dependsOn;
    @Child(name="global", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Profiles that apply globally", formalDefinition="A set of profiles that all resources covered by this implementation guide must conform to.")
    protected List<ImplementationGuideGlobalComponent> global;
    @Child(name="definition", type={}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information needed to build the IG", formalDefinition="The information needed by an IG publisher tool to publish the whole implementation guide.")
    protected ImplementationGuideDefinitionComponent definition;
    @Child(name="manifest", type={}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about an assembled IG", formalDefinition="Information about an assembled implementation guide, created by the publication tooling.")
    protected ImplementationGuideManifestComponent manifest;
    private static final long serialVersionUID = 1856906052L;
    @SearchParamDefinition(name="date", path="ImplementationGuide.date", description="The implementation guide publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="depends-on", path="ImplementationGuide.dependsOn.uri", description="Identity of the IG that this depends on", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("ImplementationGuide:depends-on").toLocked();
    @SearchParamDefinition(name="jurisdiction", path="ImplementationGuide.jurisdiction", description="Intended jurisdiction for the implementation guide", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ImplementationGuide.name", description="Computationally friendly name of the implementation guide", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="description", path="ImplementationGuide.description", description="The description of the implementation guide", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="publisher", path="ImplementationGuide.publisher", description="Name of the publisher of the implementation guide", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="experimental", path="ImplementationGuide.experimental", description="For testing purposes, not real usage", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="version", path="ImplementationGuide.version", description="The business version of the implementation guide", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ImplementationGuide.url", description="The uri that identifies the implementation guide", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="ImplementationGuide.status", description="The current status of the implementation guide", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ImplementationGuide() {
    }

    public ImplementationGuide(UriType url, StringType name, Enumeration<Enumerations.PublicationStatus> status) {
        this.url = url;
        this.name = name;
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ImplementationGuide setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ImplementationGuide setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ImplementationGuide setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ImplementationGuide setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ImplementationGuide setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ImplementationGuide setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ImplementationGuide setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ImplementationGuide setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ImplementationGuide setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ImplementationGuide setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ImplementationGuide setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ImplementationGuide setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ImplementationGuide setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ImplementationGuide setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ImplementationGuide setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ImplementationGuide setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ImplementationGuide setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ImplementationGuide setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ImplementationGuide setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ImplementationGuide setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ImplementationGuide setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public IdType getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new IdType();
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public ImplementationGuide setFhirVersionElement(IdType value) {
        this.fhirVersion = value;
        return this;
    }

    public String getFhirVersion() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public ImplementationGuide setFhirVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.fhirVersion = null;
        } else {
            if (this.fhirVersion == null) {
                this.fhirVersion = new IdType();
            }
            this.fhirVersion.setValue(value);
        }
        return this;
    }

    public List<ImplementationGuideDependsOnComponent> getDependsOn() {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
        }
        return this.dependsOn;
    }

    public ImplementationGuide setDependsOn(List<ImplementationGuideDependsOnComponent> theDependsOn) {
        this.dependsOn = theDependsOn;
        return this;
    }

    public boolean hasDependsOn() {
        if (this.dependsOn == null) {
            return false;
        }
        for (ImplementationGuideDependsOnComponent item : this.dependsOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideDependsOnComponent addDependsOn() {
        ImplementationGuideDependsOnComponent t = new ImplementationGuideDependsOnComponent();
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
        }
        this.dependsOn.add(t);
        return t;
    }

    public ImplementationGuide addDependsOn(ImplementationGuideDependsOnComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
        }
        this.dependsOn.add(t);
        return this;
    }

    public ImplementationGuideDependsOnComponent getDependsOnFirstRep() {
        if (this.getDependsOn().isEmpty()) {
            this.addDependsOn();
        }
        return this.getDependsOn().get(0);
    }

    public List<ImplementationGuideGlobalComponent> getGlobal() {
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        return this.global;
    }

    public ImplementationGuide setGlobal(List<ImplementationGuideGlobalComponent> theGlobal) {
        this.global = theGlobal;
        return this;
    }

    public boolean hasGlobal() {
        if (this.global == null) {
            return false;
        }
        for (ImplementationGuideGlobalComponent item : this.global) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideGlobalComponent addGlobal() {
        ImplementationGuideGlobalComponent t = new ImplementationGuideGlobalComponent();
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return t;
    }

    public ImplementationGuide addGlobal(ImplementationGuideGlobalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return this;
    }

    public ImplementationGuideGlobalComponent getGlobalFirstRep() {
        if (this.getGlobal().isEmpty()) {
            this.addGlobal();
        }
        return this.getGlobal().get(0);
    }

    public ImplementationGuideDefinitionComponent getDefinition() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new ImplementationGuideDefinitionComponent();
            }
        }
        return this.definition;
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public ImplementationGuide setDefinition(ImplementationGuideDefinitionComponent value) {
        this.definition = value;
        return this;
    }

    public ImplementationGuideManifestComponent getManifest() {
        if (this.manifest == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.manifest");
            }
            if (Configuration.doAutoCreate()) {
                this.manifest = new ImplementationGuideManifestComponent();
            }
        }
        return this.manifest;
    }

    public boolean hasManifest() {
        return this.manifest != null && !this.manifest.isEmpty();
    }

    public ImplementationGuide setManifest(ImplementationGuideManifestComponent value) {
        this.manifest = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which this implementation guide is (or will be) published.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this implementation guide. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_EXPERIMENTAL, "boolean", "A Boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the implementation guide was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the implementation guide.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the implementation guide from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate implementation guide instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the implementation guide is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.", 0, 1, this.copyright));
        children.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.4.0 for this version.", 0, 1, this.fhirVersion));
        children.add(new Property("dependsOn", "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependsOn));
        children.add(new Property("global", "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global));
        children.add(new Property("definition", "", "The information needed by an IG publisher tool to publish the whole implementation guide.", 0, 1, this.definition));
        children.add(new Property("manifest", "", "Information about an assembled implementation guide, created by the publication tooling.", 0, 1, this.manifest));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which this implementation guide is (or will be) published.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this implementation guide. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property(SP_EXPERIMENTAL, "boolean", "A Boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the implementation guide was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the implementation guide.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the implementation guide from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate implementation guide instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the implementation guide is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.", 0, 1, this.copyright);
            }
            case 461006061: {
                return new Property("fhirVersion", "id", "The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.4.0 for this version.", 0, 1, this.fhirVersion);
            }
            case -1109214266: {
                return new Property("dependsOn", "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependsOn);
            }
            case -1243020381: {
                return new Property("global", "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global);
            }
            case -1014418093: {
                return new Property("definition", "", "The information needed by an IG publisher tool to publish the whole implementation guide.", 0, 1, this.definition);
            }
            case 130625071: {
                return new Property("manifest", "", "Information about an assembled implementation guide, created by the publication tooling.", 0, 1, this.manifest);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case -1109214266: {
                return this.dependsOn == null ? new Base[]{} : this.dependsOn.toArray(new Base[this.dependsOn.size()]);
            }
            case -1243020381: {
                return this.global == null ? new Base[]{} : this.global.toArray(new Base[this.global.size()]);
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.definition;
                }
                return baseArray;
            }
            case 130625071: {
                Base[] baseArray;
                if (this.manifest == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.manifest;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 461006061: {
                this.fhirVersion = this.castToId(value);
                return value;
            }
            case -1109214266: {
                this.getDependsOn().add((ImplementationGuideDependsOnComponent)((Object)value));
                return value;
            }
            case -1243020381: {
                this.getGlobal().add((ImplementationGuideGlobalComponent)((Object)value));
                return value;
            }
            case -1014418093: {
                this.definition = (ImplementationGuideDefinitionComponent)((Object)value);
                return value;
            }
            case 130625071: {
                this.manifest = (ImplementationGuideManifestComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("fhirVersion")) {
            this.fhirVersion = this.castToId(value);
        } else if (name.equals("dependsOn")) {
            this.getDependsOn().add((ImplementationGuideDependsOnComponent)((Object)value));
        } else if (name.equals("global")) {
            this.getGlobal().add((ImplementationGuideGlobalComponent)((Object)value));
        } else if (name.equals("definition")) {
            this.definition = (ImplementationGuideDefinitionComponent)((Object)value);
        } else if (name.equals("manifest")) {
            this.manifest = (ImplementationGuideManifestComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 461006061: {
                return this.getFhirVersionElement();
            }
            case -1109214266: {
                return this.addDependsOn();
            }
            case -1243020381: {
                return this.addGlobal();
            }
            case -1014418093: {
                return this.getDefinition();
            }
            case 130625071: {
                return this.getManifest();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 461006061: {
                return new String[]{"id"};
            }
            case -1109214266: {
                return new String[0];
            }
            case -1243020381: {
                return new String[0];
            }
            case -1014418093: {
                return new String[0];
            }
            case 130625071: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.copyright");
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.fhirVersion");
        }
        if (name.equals("dependsOn")) {
            return this.addDependsOn();
        }
        if (name.equals("global")) {
            return this.addGlobal();
        }
        if (name.equals("definition")) {
            this.definition = new ImplementationGuideDefinitionComponent();
            return this.definition;
        }
        if (name.equals("manifest")) {
            this.manifest = new ImplementationGuideManifestComponent();
            return this.manifest;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImplementationGuide";
    }

    @Override
    public ImplementationGuide copy() {
        ImplementationGuide dst = new ImplementationGuide();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        IdType idType = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.dependsOn != null) {
            dst.dependsOn = new ArrayList<ImplementationGuideDependsOnComponent>();
            for (ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : this.dependsOn) {
                dst.dependsOn.add(implementationGuideDependsOnComponent.copy());
            }
        }
        if (this.global != null) {
            dst.global = new ArrayList<ImplementationGuideGlobalComponent>();
            for (ImplementationGuideGlobalComponent implementationGuideGlobalComponent : this.global) {
                dst.global.add(implementationGuideGlobalComponent.copy());
            }
        }
        dst.definition = this.definition == null ? null : this.definition.copy();
        dst.manifest = this.manifest == null ? null : this.manifest.copy();
        return dst;
    }

    protected ImplementationGuide typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other_;
        return ImplementationGuide.compareDeep(this.copyright, o.copyright, true) && ImplementationGuide.compareDeep(this.fhirVersion, o.fhirVersion, true) && ImplementationGuide.compareDeep(this.dependsOn, o.dependsOn, true) && ImplementationGuide.compareDeep(this.global, o.global, true) && ImplementationGuide.compareDeep(this.definition, o.definition, true) && ImplementationGuide.compareDeep(this.manifest, o.manifest, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other_;
        return ImplementationGuide.compareValues(this.copyright, o.copyright, true) && ImplementationGuide.compareValues(this.fhirVersion, o.fhirVersion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.copyright, this.fhirVersion, this.dependsOn, this.global, this.definition, this.manifest});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImplementationGuide;
    }

    @Block
    public static class ImplementationGuideManifestPageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTML page name", formalDefinition="Relative path to the page.")
        protected StringType name;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Title of the page, for references", formalDefinition="Label for the page intended for human display.")
        protected StringType title;
        @Child(name="anchor", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Anchor available on the page", formalDefinition="The name of an anchor available on the page.")
        protected List<StringType> anchor;
        private static final long serialVersionUID = 1920576611L;

        public ImplementationGuideManifestPageComponent() {
        }

        public ImplementationGuideManifestPageComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideManifestPageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideManifestPageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuideManifestPageComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideManifestPageComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImplementationGuideManifestPageComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImplementationGuideManifestPageComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public List<StringType> getAnchor() {
            if (this.anchor == null) {
                this.anchor = new ArrayList<StringType>();
            }
            return this.anchor;
        }

        public ImplementationGuideManifestPageComponent setAnchor(List<StringType> theAnchor) {
            this.anchor = theAnchor;
            return this;
        }

        public boolean hasAnchor() {
            if (this.anchor == null) {
                return false;
            }
            for (StringType item : this.anchor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addAnchorElement() {
            StringType t = new StringType();
            if (this.anchor == null) {
                this.anchor = new ArrayList<StringType>();
            }
            this.anchor.add(t);
            return t;
        }

        public ImplementationGuideManifestPageComponent addAnchor(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.anchor == null) {
                this.anchor = new ArrayList<StringType>();
            }
            this.anchor.add(t);
            return this;
        }

        public boolean hasAnchor(String value) {
            if (this.anchor == null) {
                return false;
            }
            for (StringType v : this.anchor) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "Relative path to the page.", 0, 1, this.name));
            children.add(new Property("title", "string", "Label for the page intended for human display.", 0, 1, this.title));
            children.add(new Property("anchor", "string", "The name of an anchor available on the page.", 0, Integer.MAX_VALUE, this.anchor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "Relative path to the page.", 0, 1, this.name);
                }
                case 110371416: {
                    return new Property("title", "string", "Label for the page intended for human display.", 0, 1, this.title);
                }
                case -1413299531: {
                    return new Property("anchor", "string", "The name of an anchor available on the page.", 0, Integer.MAX_VALUE, this.anchor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case -1413299531: {
                    return this.anchor == null ? new Base[]{} : this.anchor.toArray(new Base[this.anchor.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case -1413299531: {
                    this.getAnchor().add(this.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("anchor")) {
                this.getAnchor().add(this.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1413299531: {
                    return this.addAnchorElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1413299531: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.title");
            }
            if (name.equals("anchor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.anchor");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideManifestPageComponent copy() {
            ImplementationGuideManifestPageComponent dst = new ImplementationGuideManifestPageComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.title = this.title == null ? null : this.title.copy();
            if (this.anchor != null) {
                dst.anchor = new ArrayList<StringType>();
                for (StringType i : this.anchor) {
                    dst.anchor.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestPageComponent)) {
                return false;
            }
            ImplementationGuideManifestPageComponent o = (ImplementationGuideManifestPageComponent)other_;
            return ImplementationGuideManifestPageComponent.compareDeep(this.name, o.name, true) && ImplementationGuideManifestPageComponent.compareDeep(this.title, o.title, true) && ImplementationGuideManifestPageComponent.compareDeep(this.anchor, o.anchor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestPageComponent)) {
                return false;
            }
            ImplementationGuideManifestPageComponent o = (ImplementationGuideManifestPageComponent)other_;
            return ImplementationGuideManifestPageComponent.compareValues(this.name, o.name, true) && ImplementationGuideManifestPageComponent.compareValues(this.title, o.title, true) && ImplementationGuideManifestPageComponent.compareValues(this.anchor, o.anchor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.title, this.anchor});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.manifest.page";
        }
    }

    @Block
    public static class ImplementationGuideManifestResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Reference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of the resource", formalDefinition="Where this resource is found.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="example", type={BooleanType.class, CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is an example/What is this an example of?", formalDefinition="If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.")
        protected Type example;
        @Child(name="relativePath", type={UrlType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relative path for page in IG", formalDefinition="The relative path for primary page for this resource within the IG.")
        protected UrlType relativePath;
        private static final long serialVersionUID = 1150095716L;

        public ImplementationGuideManifestResourceComponent() {
        }

        public ImplementationGuideManifestResourceComponent(Reference reference) {
            this.reference = reference;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideManifestResourceComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ImplementationGuideManifestResourceComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public ImplementationGuideManifestResourceComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public Type getExample() {
            return this.example;
        }

        public BooleanType getExampleBooleanType() throws FHIRException {
            if (this.example == null) {
                return null;
            }
            if (!(this.example instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.example;
        }

        public boolean hasExampleBooleanType() {
            return this != null && this.example instanceof BooleanType;
        }

        public CanonicalType getExampleCanonicalType() throws FHIRException {
            if (this.example == null) {
                return null;
            }
            if (!(this.example instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.example;
        }

        public boolean hasExampleCanonicalType() {
            return this != null && this.example instanceof CanonicalType;
        }

        public boolean hasExample() {
            return this.example != null && !this.example.isEmpty();
        }

        public ImplementationGuideManifestResourceComponent setExample(Type value) {
            if (value != null && !(value instanceof BooleanType) && !(value instanceof CanonicalType)) {
                throw new Error("Not the right type for ImplementationGuide.manifest.resource.example[x]: " + value.fhirType());
            }
            this.example = value;
            return this;
        }

        public UrlType getRelativePathElement() {
            if (this.relativePath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideManifestResourceComponent.relativePath");
                }
                if (Configuration.doAutoCreate()) {
                    this.relativePath = new UrlType();
                }
            }
            return this.relativePath;
        }

        public boolean hasRelativePathElement() {
            return this.relativePath != null && !this.relativePath.isEmpty();
        }

        public boolean hasRelativePath() {
            return this.relativePath != null && !this.relativePath.isEmpty();
        }

        public ImplementationGuideManifestResourceComponent setRelativePathElement(UrlType value) {
            this.relativePath = value;
            return this;
        }

        public String getRelativePath() {
            return this.relativePath == null ? null : (String)this.relativePath.getValue();
        }

        public ImplementationGuideManifestResourceComponent setRelativePath(String value) {
            if (Utilities.noString((String)value)) {
                this.relativePath = null;
            } else {
                if (this.relativePath == null) {
                    this.relativePath = new UrlType();
                }
                this.relativePath.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference));
            children.add(new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example));
            children.add(new Property("relativePath", ImplementationGuide.SP_URL, "The relative path for primary page for this resource within the IG.", 0, 1, this.relativePath));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference);
                }
                case -2002328874: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -1322970774: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 159803230: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 2016979626: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -70808303: {
                    return new Property("relativePath", ImplementationGuide.SP_URL, "The relative path for primary page for this resource within the IG.", 0, 1, this.relativePath);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case -1322970774: {
                    Base[] baseArray;
                    if (this.example == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.example;
                    }
                    return baseArray;
                }
                case -70808303: {
                    Base[] baseArray;
                    if (this.relativePath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relativePath;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
                case -1322970774: {
                    this.example = this.castToType(value);
                    return value;
                }
                case -70808303: {
                    this.relativePath = this.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else if (name.equals("example[x]")) {
                this.example = this.castToType(value);
            } else if (name.equals("relativePath")) {
                this.relativePath = this.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case -2002328874: {
                    return this.getExample();
                }
                case -1322970774: {
                    return this.getExample();
                }
                case -70808303: {
                    return this.getRelativePathElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case -1322970774: {
                    return new String[]{"boolean", "canonical"};
                }
                case -70808303: {
                    return new String[]{ImplementationGuide.SP_URL};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("exampleBoolean")) {
                this.example = new BooleanType();
                return this.example;
            }
            if (name.equals("exampleCanonical")) {
                this.example = new CanonicalType();
                return this.example;
            }
            if (name.equals("relativePath")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.relativePath");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideManifestResourceComponent copy() {
            ImplementationGuideManifestResourceComponent dst = new ImplementationGuideManifestResourceComponent();
            this.copyValues(dst);
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.example = this.example == null ? null : this.example.copy();
            dst.relativePath = this.relativePath == null ? null : this.relativePath.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestResourceComponent)) {
                return false;
            }
            ImplementationGuideManifestResourceComponent o = (ImplementationGuideManifestResourceComponent)other_;
            return ImplementationGuideManifestResourceComponent.compareDeep(this.reference, o.reference, true) && ImplementationGuideManifestResourceComponent.compareDeep(this.example, o.example, true) && ImplementationGuideManifestResourceComponent.compareDeep(this.relativePath, o.relativePath, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestResourceComponent)) {
                return false;
            }
            ImplementationGuideManifestResourceComponent o = (ImplementationGuideManifestResourceComponent)other_;
            return ImplementationGuideManifestResourceComponent.compareValues(this.relativePath, o.relativePath, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.reference, this.example, this.relativePath});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.manifest.resource";
        }
    }

    @Block
    public static class ImplementationGuideManifestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="rendering", type={UrlType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of rendered implementation guide", formalDefinition="A pointer to official web page, PDF or other rendering of the implementation guide.")
        protected UrlType rendering;
        @Child(name="resource", type={}, order=2, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource in the implementation guide", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.")
        protected List<ImplementationGuideManifestResourceComponent> resource;
        @Child(name="page", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="HTML page within the parent IG", formalDefinition="Information about a page within the IG.")
        protected List<ImplementationGuideManifestPageComponent> page;
        @Child(name="image", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Image within the IG", formalDefinition="Indicates a relative path to an image that exists within the IG.")
        protected List<StringType> image;
        @Child(name="other", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional linkable file in IG", formalDefinition="Indicates the relative path of an additional non-page, non-image file that is part of the IG - e.g. zip, jar and similar files that could be the target of a hyperlink in a derived IG.")
        protected List<StringType> other;
        private static final long serialVersionUID = -212447764L;

        public UrlType getRenderingElement() {
            if (this.rendering == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideManifestComponent.rendering");
                }
                if (Configuration.doAutoCreate()) {
                    this.rendering = new UrlType();
                }
            }
            return this.rendering;
        }

        public boolean hasRenderingElement() {
            return this.rendering != null && !this.rendering.isEmpty();
        }

        public boolean hasRendering() {
            return this.rendering != null && !this.rendering.isEmpty();
        }

        public ImplementationGuideManifestComponent setRenderingElement(UrlType value) {
            this.rendering = value;
            return this;
        }

        public String getRendering() {
            return this.rendering == null ? null : (String)this.rendering.getValue();
        }

        public ImplementationGuideManifestComponent setRendering(String value) {
            if (Utilities.noString((String)value)) {
                this.rendering = null;
            } else {
                if (this.rendering == null) {
                    this.rendering = new UrlType();
                }
                this.rendering.setValue(value);
            }
            return this;
        }

        public List<ImplementationGuideManifestResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideManifestResourceComponent>();
            }
            return this.resource;
        }

        public ImplementationGuideManifestComponent setResource(List<ImplementationGuideManifestResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ImplementationGuideManifestResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideManifestResourceComponent addResource() {
            ImplementationGuideManifestResourceComponent t = new ImplementationGuideManifestResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideManifestResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addResource(ImplementationGuideManifestResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideManifestResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public ImplementationGuideManifestResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<ImplementationGuideManifestPageComponent> getPage() {
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideManifestPageComponent>();
            }
            return this.page;
        }

        public ImplementationGuideManifestComponent setPage(List<ImplementationGuideManifestPageComponent> thePage) {
            this.page = thePage;
            return this;
        }

        public boolean hasPage() {
            if (this.page == null) {
                return false;
            }
            for (ImplementationGuideManifestPageComponent item : this.page) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideManifestPageComponent addPage() {
            ImplementationGuideManifestPageComponent t = new ImplementationGuideManifestPageComponent();
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideManifestPageComponent>();
            }
            this.page.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addPage(ImplementationGuideManifestPageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideManifestPageComponent>();
            }
            this.page.add(t);
            return this;
        }

        public ImplementationGuideManifestPageComponent getPageFirstRep() {
            if (this.getPage().isEmpty()) {
                this.addPage();
            }
            return this.getPage().get(0);
        }

        public List<StringType> getImage() {
            if (this.image == null) {
                this.image = new ArrayList<StringType>();
            }
            return this.image;
        }

        public ImplementationGuideManifestComponent setImage(List<StringType> theImage) {
            this.image = theImage;
            return this;
        }

        public boolean hasImage() {
            if (this.image == null) {
                return false;
            }
            for (StringType item : this.image) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addImageElement() {
            StringType t = new StringType();
            if (this.image == null) {
                this.image = new ArrayList<StringType>();
            }
            this.image.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addImage(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.image == null) {
                this.image = new ArrayList<StringType>();
            }
            this.image.add(t);
            return this;
        }

        public boolean hasImage(String value) {
            if (this.image == null) {
                return false;
            }
            for (StringType v : this.image) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getOther() {
            if (this.other == null) {
                this.other = new ArrayList<StringType>();
            }
            return this.other;
        }

        public ImplementationGuideManifestComponent setOther(List<StringType> theOther) {
            this.other = theOther;
            return this;
        }

        public boolean hasOther() {
            if (this.other == null) {
                return false;
            }
            for (StringType item : this.other) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addOtherElement() {
            StringType t = new StringType();
            if (this.other == null) {
                this.other = new ArrayList<StringType>();
            }
            this.other.add(t);
            return t;
        }

        public ImplementationGuideManifestComponent addOther(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.other == null) {
                this.other = new ArrayList<StringType>();
            }
            this.other.add(t);
            return this;
        }

        public boolean hasOther(String value) {
            if (this.other == null) {
                return false;
            }
            for (StringType v : this.other) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("rendering", ImplementationGuide.SP_URL, "A pointer to official web page, PDF or other rendering of the implementation guide.", 0, 1, this.rendering));
            children.add(new Property("resource", "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("page", "", "Information about a page within the IG.", 0, Integer.MAX_VALUE, this.page));
            children.add(new Property("image", "string", "Indicates a relative path to an image that exists within the IG.", 0, Integer.MAX_VALUE, this.image));
            children.add(new Property("other", "string", "Indicates the relative path of an additional non-page, non-image file that is part of the IG - e.g. zip, jar and similar files that could be the target of a hyperlink in a derived IG.", 0, Integer.MAX_VALUE, this.other));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1839654540: {
                    return new Property("rendering", ImplementationGuide.SP_URL, "A pointer to official web page, PDF or other rendering of the implementation guide.", 0, 1, this.rendering);
                }
                case -341064690: {
                    return new Property("resource", "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 3433103: {
                    return new Property("page", "", "Information about a page within the IG.", 0, Integer.MAX_VALUE, this.page);
                }
                case 100313435: {
                    return new Property("image", "string", "Indicates a relative path to an image that exists within the IG.", 0, Integer.MAX_VALUE, this.image);
                }
                case 106069776: {
                    return new Property("other", "string", "Indicates the relative path of an additional non-page, non-image file that is part of the IG - e.g. zip, jar and similar files that could be the target of a hyperlink in a derived IG.", 0, Integer.MAX_VALUE, this.other);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    Base[] baseArray;
                    if (this.rendering == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.rendering;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 3433103: {
                    return this.page == null ? new Base[]{} : this.page.toArray(new Base[this.page.size()]);
                }
                case 100313435: {
                    return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
                }
                case 106069776: {
                    return this.other == null ? new Base[]{} : this.other.toArray(new Base[this.other.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    this.rendering = this.castToUrl(value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((ImplementationGuideManifestResourceComponent)value);
                    return value;
                }
                case 3433103: {
                    this.getPage().add((ImplementationGuideManifestPageComponent)value);
                    return value;
                }
                case 100313435: {
                    this.getImage().add(this.castToString(value));
                    return value;
                }
                case 106069776: {
                    this.getOther().add(this.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("rendering")) {
                this.rendering = this.castToUrl(value);
            } else if (name.equals("resource")) {
                this.getResource().add((ImplementationGuideManifestResourceComponent)value);
            } else if (name.equals("page")) {
                this.getPage().add((ImplementationGuideManifestPageComponent)value);
            } else if (name.equals("image")) {
                this.getImage().add(this.castToString(value));
            } else if (name.equals("other")) {
                this.getOther().add(this.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    return this.getRenderingElement();
                }
                case -341064690: {
                    return this.addResource();
                }
                case 3433103: {
                    return this.addPage();
                }
                case 100313435: {
                    return this.addImageElement();
                }
                case 106069776: {
                    return this.addOtherElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1839654540: {
                    return new String[]{ImplementationGuide.SP_URL};
                }
                case -341064690: {
                    return new String[0];
                }
                case 3433103: {
                    return new String[0];
                }
                case 100313435: {
                    return new String[]{"string"};
                }
                case 106069776: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("rendering")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.rendering");
            }
            if (name.equals("resource")) {
                return this.addResource();
            }
            if (name.equals("page")) {
                return this.addPage();
            }
            if (name.equals("image")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.image");
            }
            if (name.equals("other")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.other");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideManifestComponent copy() {
            ImplementationGuideManifestComponent dst = new ImplementationGuideManifestComponent();
            this.copyValues(dst);
            UrlType urlType = dst.rendering = this.rendering == null ? null : this.rendering.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<ImplementationGuideManifestResourceComponent>();
                for (ImplementationGuideManifestResourceComponent implementationGuideManifestResourceComponent : this.resource) {
                    dst.resource.add(implementationGuideManifestResourceComponent.copy());
                }
            }
            if (this.page != null) {
                dst.page = new ArrayList<ImplementationGuideManifestPageComponent>();
                for (ImplementationGuideManifestPageComponent implementationGuideManifestPageComponent : this.page) {
                    dst.page.add(implementationGuideManifestPageComponent.copy());
                }
            }
            if (this.image != null) {
                dst.image = new ArrayList<StringType>();
                for (StringType stringType : this.image) {
                    dst.image.add(stringType.copy());
                }
            }
            if (this.other != null) {
                dst.other = new ArrayList<StringType>();
                for (StringType stringType : this.other) {
                    dst.other.add(stringType.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestComponent)) {
                return false;
            }
            ImplementationGuideManifestComponent o = (ImplementationGuideManifestComponent)other_;
            return ImplementationGuideManifestComponent.compareDeep(this.rendering, o.rendering, true) && ImplementationGuideManifestComponent.compareDeep(this.resource, o.resource, true) && ImplementationGuideManifestComponent.compareDeep(this.page, o.page, true) && ImplementationGuideManifestComponent.compareDeep(this.image, o.image, true) && ImplementationGuideManifestComponent.compareDeep(this.other, o.other, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideManifestComponent)) {
                return false;
            }
            ImplementationGuideManifestComponent o = (ImplementationGuideManifestComponent)other_;
            return ImplementationGuideManifestComponent.compareValues(this.rendering, o.rendering, true) && ImplementationGuideManifestComponent.compareValues(this.image, o.image, true) && ImplementationGuideManifestComponent.compareValues(this.other, o.other, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.rendering, this.resource, this.page, this.image, this.other});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.manifest";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionTemplateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of template specified", formalDefinition="Type of template specified.")
        protected CodeType code;
        @Child(name="source", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source location for the template", formalDefinition="The source location for the template.")
        protected StringType source;
        @Child(name="scope", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The scope in which the template applies", formalDefinition="The scope in which the template applies.")
        protected StringType scope;
        private static final long serialVersionUID = 923832457L;

        public ImplementationGuideDefinitionTemplateComponent() {
        }

        public ImplementationGuideDefinitionTemplateComponent(CodeType code, StringType source) {
            this.code = code;
            this.source = source;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionTemplateComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImplementationGuideDefinitionTemplateComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ImplementationGuideDefinitionTemplateComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionTemplateComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ImplementationGuideDefinitionTemplateComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ImplementationGuideDefinitionTemplateComponent setSource(String value) {
            if (this.source == null) {
                this.source = new StringType();
            }
            this.source.setValue(value);
            return this;
        }

        public StringType getScopeElement() {
            if (this.scope == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionTemplateComponent.scope");
                }
                if (Configuration.doAutoCreate()) {
                    this.scope = new StringType();
                }
            }
            return this.scope;
        }

        public boolean hasScopeElement() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public boolean hasScope() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public ImplementationGuideDefinitionTemplateComponent setScopeElement(StringType value) {
            this.scope = value;
            return this;
        }

        public String getScope() {
            return this.scope == null ? null : (String)this.scope.getValue();
        }

        public ImplementationGuideDefinitionTemplateComponent setScope(String value) {
            if (Utilities.noString((String)value)) {
                this.scope = null;
            } else {
                if (this.scope == null) {
                    this.scope = new StringType();
                }
                this.scope.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Type of template specified.", 0, 1, this.code));
            children.add(new Property("source", "string", "The source location for the template.", 0, 1, this.source));
            children.add(new Property("scope", "string", "The scope in which the template applies.", 0, 1, this.scope));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Type of template specified.", 0, 1, this.code);
                }
                case -896505829: {
                    return new Property("source", "string", "The source location for the template.", 0, 1, this.source);
                }
                case 109264468: {
                    return new Property("scope", "string", "The scope in which the template applies.", 0, 1, this.scope);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 109264468: {
                    Base[] baseArray;
                    if (this.scope == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.scope;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case -896505829: {
                    this.source = this.castToString(value);
                    return value;
                }
                case 109264468: {
                    this.scope = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("source")) {
                this.source = this.castToString(value);
            } else if (name.equals("scope")) {
                this.scope = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
                case 109264468: {
                    return this.getScopeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -896505829: {
                    return new String[]{"string"};
                }
                case 109264468: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.code");
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.source");
            }
            if (name.equals("scope")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.scope");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionTemplateComponent copy() {
            ImplementationGuideDefinitionTemplateComponent dst = new ImplementationGuideDefinitionTemplateComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.scope = this.scope == null ? null : this.scope.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionTemplateComponent)) {
                return false;
            }
            ImplementationGuideDefinitionTemplateComponent o = (ImplementationGuideDefinitionTemplateComponent)other_;
            return ImplementationGuideDefinitionTemplateComponent.compareDeep(this.code, o.code, true) && ImplementationGuideDefinitionTemplateComponent.compareDeep(this.source, o.source, true) && ImplementationGuideDefinitionTemplateComponent.compareDeep(this.scope, o.scope, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionTemplateComponent)) {
                return false;
            }
            ImplementationGuideDefinitionTemplateComponent o = (ImplementationGuideDefinitionTemplateComponent)other_;
            return ImplementationGuideDefinitionTemplateComponent.compareValues(this.code, o.code, true) && ImplementationGuideDefinitionTemplateComponent.compareValues(this.source, o.source, true) && ImplementationGuideDefinitionTemplateComponent.compareValues(this.scope, o.scope, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.source, this.scope});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.template";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="apply-business-version | apply-jurisdiction | path-resource | path-pages | path-tx-cache | expansion-profile | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template", formalDefinition="apply-business-version | apply-jurisdiction | path-resource | path-pages | path-tx-cache | expansion-profile | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/guide-parameter-code")
        protected Enumeration<GuideParameterCode> code;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value for named type", formalDefinition="Value for named type.")
        protected StringType value;
        private static final long serialVersionUID = 1188999138L;

        public ImplementationGuideDefinitionParameterComponent() {
        }

        public ImplementationGuideDefinitionParameterComponent(Enumeration<GuideParameterCode> code, StringType value) {
            this.code = code;
            this.value = value;
        }

        public Enumeration<GuideParameterCode> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionParameterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<GuideParameterCode>(new GuideParameterCodeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImplementationGuideDefinitionParameterComponent setCodeElement(Enumeration<GuideParameterCode> value) {
            this.code = value;
            return this;
        }

        public GuideParameterCode getCode() {
            return this.code == null ? null : (GuideParameterCode)((Object)this.code.getValue());
        }

        public ImplementationGuideDefinitionParameterComponent setCode(GuideParameterCode value) {
            if (this.code == null) {
                this.code = new Enumeration<GuideParameterCode>(new GuideParameterCodeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionParameterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ImplementationGuideDefinitionParameterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ImplementationGuideDefinitionParameterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "apply-business-version | apply-jurisdiction | path-resource | path-pages | path-tx-cache | expansion-profile | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template.", 0, 1, this.code));
            children.add(new Property("value", "string", "Value for named type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "apply-business-version | apply-jurisdiction | path-resource | path-pages | path-tx-cache | expansion-profile | rule-broken-links | generate-xml | generate-json | generate-turtle | html-template.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "string", "Value for named type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new GuideParameterCodeEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new GuideParameterCodeEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.code");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.value");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionParameterComponent copy() {
            ImplementationGuideDefinitionParameterComponent dst = new ImplementationGuideDefinitionParameterComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionParameterComponent)) {
                return false;
            }
            ImplementationGuideDefinitionParameterComponent o = (ImplementationGuideDefinitionParameterComponent)other_;
            return ImplementationGuideDefinitionParameterComponent.compareDeep(this.code, o.code, true) && ImplementationGuideDefinitionParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionParameterComponent)) {
                return false;
            }
            ImplementationGuideDefinitionParameterComponent o = (ImplementationGuideDefinitionParameterComponent)other_;
            return ImplementationGuideDefinitionParameterComponent.compareValues(this.code, o.code, true) && ImplementationGuideDefinitionParameterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.parameter";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionPageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={UrlType.class, Binary.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where to find that page", formalDefinition="The source address for the page.")
        protected Type name;
        @Child(name="title", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short title shown for navigational assistance", formalDefinition="A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.")
        protected StringType title;
        @Child(name="generation", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="html | markdown | xml | generated", formalDefinition="A code that indicates how the page is generated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/guide-page-generation")
        protected Enumeration<GuidePageGeneration> generation;
        @Child(name="page", type={ImplementationGuideDefinitionPageComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Pages / Sections", formalDefinition="Nested Pages/Sections under this page.")
        protected List<ImplementationGuideDefinitionPageComponent> page;
        private static final long serialVersionUID = -365655658L;

        public ImplementationGuideDefinitionPageComponent() {
        }

        public ImplementationGuideDefinitionPageComponent(Type name, StringType title, Enumeration<GuidePageGeneration> generation) {
            this.name = name;
            this.title = title;
            this.generation = generation;
        }

        public Type getName() {
            return this.name;
        }

        public UrlType getNameUrlType() throws FHIRException {
            if (this.name == null) {
                return null;
            }
            if (!(this.name instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.name.getClass().getName() + " was encountered");
            }
            return (UrlType)this.name;
        }

        public boolean hasNameUrlType() {
            return this != null && this.name instanceof UrlType;
        }

        public Reference getNameReference() throws FHIRException {
            if (this.name == null) {
                return null;
            }
            if (!(this.name instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.name.getClass().getName() + " was encountered");
            }
            return (Reference)this.name;
        }

        public boolean hasNameReference() {
            return this != null && this.name instanceof Reference;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideDefinitionPageComponent setName(Type value) {
            if (value != null && !(value instanceof UrlType) && !(value instanceof Reference)) {
                throw new Error("Not the right type for ImplementationGuide.definition.page.name[x]: " + value.fhirType());
            }
            this.name = value;
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionPageComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImplementationGuideDefinitionPageComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImplementationGuideDefinitionPageComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public Enumeration<GuidePageGeneration> getGenerationElement() {
            if (this.generation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionPageComponent.generation");
                }
                if (Configuration.doAutoCreate()) {
                    this.generation = new Enumeration<GuidePageGeneration>(new GuidePageGenerationEnumFactory());
                }
            }
            return this.generation;
        }

        public boolean hasGenerationElement() {
            return this.generation != null && !this.generation.isEmpty();
        }

        public boolean hasGeneration() {
            return this.generation != null && !this.generation.isEmpty();
        }

        public ImplementationGuideDefinitionPageComponent setGenerationElement(Enumeration<GuidePageGeneration> value) {
            this.generation = value;
            return this;
        }

        public GuidePageGeneration getGeneration() {
            return this.generation == null ? null : (GuidePageGeneration)((Object)this.generation.getValue());
        }

        public ImplementationGuideDefinitionPageComponent setGeneration(GuidePageGeneration value) {
            if (this.generation == null) {
                this.generation = new Enumeration<GuidePageGeneration>(new GuidePageGenerationEnumFactory());
            }
            this.generation.setValue((Object)value);
            return this;
        }

        public List<ImplementationGuideDefinitionPageComponent> getPage() {
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
            }
            return this.page;
        }

        public ImplementationGuideDefinitionPageComponent setPage(List<ImplementationGuideDefinitionPageComponent> thePage) {
            this.page = thePage;
            return this;
        }

        public boolean hasPage() {
            if (this.page == null) {
                return false;
            }
            for (ImplementationGuideDefinitionPageComponent item : this.page) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionPageComponent addPage() {
            ImplementationGuideDefinitionPageComponent t = new ImplementationGuideDefinitionPageComponent();
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
            }
            this.page.add(t);
            return t;
        }

        public ImplementationGuideDefinitionPageComponent addPage(ImplementationGuideDefinitionPageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
            }
            this.page.add(t);
            return this;
        }

        public ImplementationGuideDefinitionPageComponent getPageFirstRep() {
            if (this.getPage().isEmpty()) {
                this.addPage();
            }
            return this.getPage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name));
            children.add(new Property("title", "string", "A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, 1, this.title));
            children.add(new Property("generation", "code", "A code that indicates how the page is generated.", 0, 1, this.generation));
            children.add(new Property("page", "@ImplementationGuide.definition.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1721948693: {
                    return new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 3373707: {
                    return new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 1721942756: {
                    return new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 1833144576: {
                    return new Property("name[x]", "url|Reference(Binary)", "The source address for the page.", 0, 1, this.name);
                }
                case 110371416: {
                    return new Property("title", "string", "A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, 1, this.title);
                }
                case 305703192: {
                    return new Property("generation", "code", "A code that indicates how the page is generated.", 0, 1, this.generation);
                }
                case 3433103: {
                    return new Property("page", "@ImplementationGuide.definition.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case 305703192: {
                    Base[] baseArray;
                    if (this.generation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.generation;
                    }
                    return baseArray;
                }
                case 3433103: {
                    return this.page == null ? new Base[]{} : this.page.toArray(new Base[this.page.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToType(value);
                    return value;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case 305703192: {
                    value = new GuidePageGenerationEnumFactory().fromType(this.castToCode(value));
                    this.generation = value;
                    return value;
                }
                case 3433103: {
                    this.getPage().add((ImplementationGuideDefinitionPageComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name[x]")) {
                this.name = this.castToType(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("generation")) {
                value = new GuidePageGenerationEnumFactory().fromType(this.castToCode(value));
                this.generation = value;
            } else if (name.equals("page")) {
                this.getPage().add((ImplementationGuideDefinitionPageComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1721948693: {
                    return this.getName();
                }
                case 3373707: {
                    return this.getName();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case 305703192: {
                    return this.getGenerationElement();
                }
                case 3433103: {
                    return this.addPage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{ImplementationGuide.SP_URL, "Reference"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case 305703192: {
                    return new String[]{"code"};
                }
                case 3433103: {
                    return new String[]{"@ImplementationGuide.definition.page"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nameUrl")) {
                this.name = new UrlType();
                return this.name;
            }
            if (name.equals("nameReference")) {
                this.name = new Reference();
                return this.name;
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.title");
            }
            if (name.equals("generation")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.generation");
            }
            if (name.equals("page")) {
                return this.addPage();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionPageComponent copy() {
            ImplementationGuideDefinitionPageComponent dst = new ImplementationGuideDefinitionPageComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.title = this.title == null ? null : this.title.copy();
            Enumeration<GuidePageGeneration> enumeration = dst.generation = this.generation == null ? null : this.generation.copy();
            if (this.page != null) {
                dst.page = new ArrayList<ImplementationGuideDefinitionPageComponent>();
                for (ImplementationGuideDefinitionPageComponent i : this.page) {
                    dst.page.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionPageComponent)) {
                return false;
            }
            ImplementationGuideDefinitionPageComponent o = (ImplementationGuideDefinitionPageComponent)other_;
            return ImplementationGuideDefinitionPageComponent.compareDeep(this.name, o.name, true) && ImplementationGuideDefinitionPageComponent.compareDeep(this.title, o.title, true) && ImplementationGuideDefinitionPageComponent.compareDeep(this.generation, o.generation, true) && ImplementationGuideDefinitionPageComponent.compareDeep(this.page, o.page, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionPageComponent)) {
                return false;
            }
            ImplementationGuideDefinitionPageComponent o = (ImplementationGuideDefinitionPageComponent)other_;
            return ImplementationGuideDefinitionPageComponent.compareValues(this.title, o.title, true) && ImplementationGuideDefinitionPageComponent.compareValues(this.generation, o.generation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.title, this.generation, this.page});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.page";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location of the resource", formalDefinition="Where this resource is found.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human Name for the resource", formalDefinition="A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason why included in guide", formalDefinition="A description of the reason that a resource has been included in the implementation guide.")
        protected StringType description;
        @Child(name="example", type={BooleanType.class, CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is an example/What is this an example of?", formalDefinition="If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.")
        protected Type example;
        @Child(name="package", type={IdType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pack this is part of", formalDefinition="Reference to the id of the pack this resource appears in.")
        protected IdType package_;
        private static final long serialVersionUID = 1199251259L;

        public ImplementationGuideDefinitionResourceComponent() {
        }

        public ImplementationGuideDefinitionResourceComponent(Reference reference) {
            this.reference = reference;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public ImplementationGuideDefinitionResourceComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuideDefinitionResourceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuideDefinitionResourceComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Type getExample() {
            return this.example;
        }

        public BooleanType getExampleBooleanType() throws FHIRException {
            if (this.example == null) {
                return null;
            }
            if (!(this.example instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.example;
        }

        public boolean hasExampleBooleanType() {
            return this != null && this.example instanceof BooleanType;
        }

        public CanonicalType getExampleCanonicalType() throws FHIRException {
            if (this.example == null) {
                return null;
            }
            if (!(this.example instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.example.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.example;
        }

        public boolean hasExampleCanonicalType() {
            return this != null && this.example instanceof CanonicalType;
        }

        public boolean hasExample() {
            return this.example != null && !this.example.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setExample(Type value) {
            if (value != null && !(value instanceof BooleanType) && !(value instanceof CanonicalType)) {
                throw new Error("Not the right type for ImplementationGuide.definition.resource.example[x]: " + value.fhirType());
            }
            this.example = value;
            return this;
        }

        public IdType getPackageElement() {
            if (this.package_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionResourceComponent.package_");
                }
                if (Configuration.doAutoCreate()) {
                    this.package_ = new IdType();
                }
            }
            return this.package_;
        }

        public boolean hasPackageElement() {
            return this.package_ != null && !this.package_.isEmpty();
        }

        public boolean hasPackage() {
            return this.package_ != null && !this.package_.isEmpty();
        }

        public ImplementationGuideDefinitionResourceComponent setPackageElement(IdType value) {
            this.package_ = value;
            return this;
        }

        public String getPackage() {
            return this.package_ == null ? null : this.package_.getValue();
        }

        public ImplementationGuideDefinitionResourceComponent setPackage(String value) {
            if (Utilities.noString((String)value)) {
                this.package_ = null;
            } else {
                if (this.package_ == null) {
                    this.package_ = new IdType();
                }
                this.package_.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference));
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, 1, this.description));
            children.add(new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example));
            children.add(new Property("package", "id", "Reference to the id of the pack this resource appears in.", 0, 1, this.package_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "Where this resource is found.", 0, 1, this.reference);
                }
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, 1, this.description);
                }
                case -2002328874: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -1322970774: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 159803230: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case 2016979626: {
                    return new Property("example[x]", "boolean|canonical(StructureDefinition)", "If true or a reference, indicates the resource is an example instance.  If a reference is present, indicates that the example is an example of the specified profile.", 0, 1, this.example);
                }
                case -807062458: {
                    return new Property("package", "id", "Reference to the id of the pack this resource appears in.", 0, 1, this.package_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1322970774: {
                    Base[] baseArray;
                    if (this.example == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.example;
                    }
                    return baseArray;
                }
                case -807062458: {
                    Base[] baseArray;
                    if (this.package_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.package_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1322970774: {
                    this.example = this.castToType(value);
                    return value;
                }
                case -807062458: {
                    this.package_ = this.castToId(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("example[x]")) {
                this.example = this.castToType(value);
            } else if (name.equals("package")) {
                this.package_ = this.castToId(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -2002328874: {
                    return this.getExample();
                }
                case -1322970774: {
                    return this.getExample();
                }
                case -807062458: {
                    return this.getPackageElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1322970774: {
                    return new String[]{"boolean", "canonical"};
                }
                case -807062458: {
                    return new String[]{"id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
            }
            if (name.equals("exampleBoolean")) {
                this.example = new BooleanType();
                return this.example;
            }
            if (name.equals("exampleCanonical")) {
                this.example = new CanonicalType();
                return this.example;
            }
            if (name.equals("package")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.package");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionResourceComponent copy() {
            ImplementationGuideDefinitionResourceComponent dst = new ImplementationGuideDefinitionResourceComponent();
            this.copyValues(dst);
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.example = this.example == null ? null : this.example.copy();
            dst.package_ = this.package_ == null ? null : this.package_.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionResourceComponent)) {
                return false;
            }
            ImplementationGuideDefinitionResourceComponent o = (ImplementationGuideDefinitionResourceComponent)other_;
            return ImplementationGuideDefinitionResourceComponent.compareDeep(this.reference, o.reference, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.name, o.name, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.description, o.description, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.example, o.example, true) && ImplementationGuideDefinitionResourceComponent.compareDeep(this.package_, o.package_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionResourceComponent)) {
                return false;
            }
            ImplementationGuideDefinitionResourceComponent o = (ImplementationGuideDefinitionResourceComponent)other_;
            return ImplementationGuideDefinitionResourceComponent.compareValues(this.name, o.name, true) && ImplementationGuideDefinitionResourceComponent.compareValues(this.description, o.description, true) && ImplementationGuideDefinitionResourceComponent.compareValues(this.package_, o.package_, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.reference, this.name, this.description, this.example, this.package_});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.resource";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionPackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name used .resource.package and .page.package", formalDefinition="The name for the group, as used in ImplementationGuide.definition.resource.package and ImplementationGuide.definition.page.package.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable text describing the package", formalDefinition="Human readable text describing the package.")
        protected StringType description;
        private static final long serialVersionUID = -1105523499L;

        public ImplementationGuideDefinitionPackageComponent() {
        }

        public ImplementationGuideDefinitionPackageComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionPackageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideDefinitionPackageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuideDefinitionPackageComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionPackageComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuideDefinitionPackageComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuideDefinitionPackageComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "The name for the group, as used in ImplementationGuide.definition.resource.package and ImplementationGuide.definition.page.package.", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "The name for the group, as used in ImplementationGuide.definition.resource.package and ImplementationGuide.definition.page.package.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionPackageComponent copy() {
            ImplementationGuideDefinitionPackageComponent dst = new ImplementationGuideDefinitionPackageComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionPackageComponent)) {
                return false;
            }
            ImplementationGuideDefinitionPackageComponent o = (ImplementationGuideDefinitionPackageComponent)other_;
            return ImplementationGuideDefinitionPackageComponent.compareDeep(this.name, o.name, true) && ImplementationGuideDefinitionPackageComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionPackageComponent)) {
                return false;
            }
            ImplementationGuideDefinitionPackageComponent o = (ImplementationGuideDefinitionPackageComponent)other_;
            return ImplementationGuideDefinitionPackageComponent.compareValues(this.name, o.name, true) && ImplementationGuideDefinitionPackageComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.description});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition.package";
        }
    }

    @Block
    public static class ImplementationGuideDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="package", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Group of resources as used in .page.package", formalDefinition="A logical group of resources. Logical groups can be used when building pages.")
        protected List<ImplementationGuideDefinitionPackageComponent> package_;
        @Child(name="resource", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resource in the implementation guide", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.")
        protected List<ImplementationGuideDefinitionResourceComponent> resource;
        @Child(name="page", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Page/Section in the Guide", formalDefinition="A page / section in the implementation guide. The root page is the implementation guide home page.")
        protected ImplementationGuideDefinitionPageComponent page;
        @Child(name="parameter", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Defines how IG is built by tools", formalDefinition="Defines how IG is built by tools.")
        protected List<ImplementationGuideDefinitionParameterComponent> parameter;
        @Child(name="template", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A template for building resources", formalDefinition="A template for building resources.")
        protected List<ImplementationGuideDefinitionTemplateComponent> template;
        private static final long serialVersionUID = 1395079915L;

        public List<ImplementationGuideDefinitionPackageComponent> getPackage() {
            if (this.package_ == null) {
                this.package_ = new ArrayList<ImplementationGuideDefinitionPackageComponent>();
            }
            return this.package_;
        }

        public ImplementationGuideDefinitionComponent setPackage(List<ImplementationGuideDefinitionPackageComponent> thePackage) {
            this.package_ = thePackage;
            return this;
        }

        public boolean hasPackage() {
            if (this.package_ == null) {
                return false;
            }
            for (ImplementationGuideDefinitionPackageComponent item : this.package_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionPackageComponent addPackage() {
            ImplementationGuideDefinitionPackageComponent t = new ImplementationGuideDefinitionPackageComponent();
            if (this.package_ == null) {
                this.package_ = new ArrayList<ImplementationGuideDefinitionPackageComponent>();
            }
            this.package_.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addPackage(ImplementationGuideDefinitionPackageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.package_ == null) {
                this.package_ = new ArrayList<ImplementationGuideDefinitionPackageComponent>();
            }
            this.package_.add(t);
            return this;
        }

        public ImplementationGuideDefinitionPackageComponent getPackageFirstRep() {
            if (this.getPackage().isEmpty()) {
                this.addPackage();
            }
            return this.getPackage().get(0);
        }

        public List<ImplementationGuideDefinitionResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
            }
            return this.resource;
        }

        public ImplementationGuideDefinitionComponent setResource(List<ImplementationGuideDefinitionResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ImplementationGuideDefinitionResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionResourceComponent addResource() {
            ImplementationGuideDefinitionResourceComponent t = new ImplementationGuideDefinitionResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addResource(ImplementationGuideDefinitionResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public ImplementationGuideDefinitionResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public ImplementationGuideDefinitionPageComponent getPage() {
            if (this.page == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDefinitionComponent.page");
                }
                if (Configuration.doAutoCreate()) {
                    this.page = new ImplementationGuideDefinitionPageComponent();
                }
            }
            return this.page;
        }

        public boolean hasPage() {
            return this.page != null && !this.page.isEmpty();
        }

        public ImplementationGuideDefinitionComponent setPage(ImplementationGuideDefinitionPageComponent value) {
            this.page = value;
            return this;
        }

        public List<ImplementationGuideDefinitionParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
            }
            return this.parameter;
        }

        public ImplementationGuideDefinitionComponent setParameter(List<ImplementationGuideDefinitionParameterComponent> theParameter) {
            this.parameter = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (ImplementationGuideDefinitionParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionParameterComponent addParameter() {
            ImplementationGuideDefinitionParameterComponent t = new ImplementationGuideDefinitionParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addParameter(ImplementationGuideDefinitionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public ImplementationGuideDefinitionParameterComponent getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public List<ImplementationGuideDefinitionTemplateComponent> getTemplate() {
            if (this.template == null) {
                this.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
            }
            return this.template;
        }

        public ImplementationGuideDefinitionComponent setTemplate(List<ImplementationGuideDefinitionTemplateComponent> theTemplate) {
            this.template = theTemplate;
            return this;
        }

        public boolean hasTemplate() {
            if (this.template == null) {
                return false;
            }
            for (ImplementationGuideDefinitionTemplateComponent item : this.template) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuideDefinitionTemplateComponent addTemplate() {
            ImplementationGuideDefinitionTemplateComponent t = new ImplementationGuideDefinitionTemplateComponent();
            if (this.template == null) {
                this.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
            }
            this.template.add(t);
            return t;
        }

        public ImplementationGuideDefinitionComponent addTemplate(ImplementationGuideDefinitionTemplateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.template == null) {
                this.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
            }
            this.template.add(t);
            return this;
        }

        public ImplementationGuideDefinitionTemplateComponent getTemplateFirstRep() {
            if (this.getTemplate().isEmpty()) {
                this.addTemplate();
            }
            return this.getTemplate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("package", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.package_));
            children.add(new Property("resource", "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, 1, this.page));
            children.add(new Property("parameter", "", "Defines how IG is built by tools.", 0, Integer.MAX_VALUE, this.parameter));
            children.add(new Property("template", "", "A template for building resources.", 0, Integer.MAX_VALUE, this.template));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -807062458: {
                    return new Property("package", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.package_);
                }
                case -341064690: {
                    return new Property("resource", "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 3433103: {
                    return new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, 1, this.page);
                }
                case 1954460585: {
                    return new Property("parameter", "", "Defines how IG is built by tools.", 0, Integer.MAX_VALUE, this.parameter);
                }
                case -1321546630: {
                    return new Property("template", "", "A template for building resources.", 0, Integer.MAX_VALUE, this.template);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -807062458: {
                    return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 3433103: {
                    Base[] baseArray;
                    if (this.page == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.page;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
                case -1321546630: {
                    return this.template == null ? new Base[]{} : this.template.toArray(new Base[this.template.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -807062458: {
                    this.getPackage().add((ImplementationGuideDefinitionPackageComponent)value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((ImplementationGuideDefinitionResourceComponent)value);
                    return value;
                }
                case 3433103: {
                    this.page = (ImplementationGuideDefinitionPageComponent)value;
                    return value;
                }
                case 1954460585: {
                    this.getParameter().add((ImplementationGuideDefinitionParameterComponent)value);
                    return value;
                }
                case -1321546630: {
                    this.getTemplate().add((ImplementationGuideDefinitionTemplateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("package")) {
                this.getPackage().add((ImplementationGuideDefinitionPackageComponent)value);
            } else if (name.equals("resource")) {
                this.getResource().add((ImplementationGuideDefinitionResourceComponent)value);
            } else if (name.equals("page")) {
                this.page = (ImplementationGuideDefinitionPageComponent)value;
            } else if (name.equals("parameter")) {
                this.getParameter().add((ImplementationGuideDefinitionParameterComponent)value);
            } else if (name.equals("template")) {
                this.getTemplate().add((ImplementationGuideDefinitionTemplateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -807062458: {
                    return this.addPackage();
                }
                case -341064690: {
                    return this.addResource();
                }
                case 3433103: {
                    return this.getPage();
                }
                case 1954460585: {
                    return this.addParameter();
                }
                case -1321546630: {
                    return this.addTemplate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -807062458: {
                    return new String[0];
                }
                case -341064690: {
                    return new String[0];
                }
                case 3433103: {
                    return new String[0];
                }
                case 1954460585: {
                    return new String[0];
                }
                case -1321546630: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("package")) {
                return this.addPackage();
            }
            if (name.equals("resource")) {
                return this.addResource();
            }
            if (name.equals("page")) {
                this.page = new ImplementationGuideDefinitionPageComponent();
                return this.page;
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("template")) {
                return this.addTemplate();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDefinitionComponent copy() {
            ImplementationGuideDefinitionComponent dst = new ImplementationGuideDefinitionComponent();
            this.copyValues(dst);
            if (this.package_ != null) {
                dst.package_ = new ArrayList<ImplementationGuideDefinitionPackageComponent>();
                for (ImplementationGuideDefinitionPackageComponent implementationGuideDefinitionPackageComponent : this.package_) {
                    dst.package_.add(implementationGuideDefinitionPackageComponent.copy());
                }
            }
            if (this.resource != null) {
                dst.resource = new ArrayList<ImplementationGuideDefinitionResourceComponent>();
                for (ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : this.resource) {
                    dst.resource.add(implementationGuideDefinitionResourceComponent.copy());
                }
            }
            ImplementationGuideDefinitionPageComponent implementationGuideDefinitionPageComponent = dst.page = this.page == null ? null : this.page.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<ImplementationGuideDefinitionParameterComponent>();
                for (ImplementationGuideDefinitionParameterComponent implementationGuideDefinitionParameterComponent : this.parameter) {
                    dst.parameter.add(implementationGuideDefinitionParameterComponent.copy());
                }
            }
            if (this.template != null) {
                dst.template = new ArrayList<ImplementationGuideDefinitionTemplateComponent>();
                for (ImplementationGuideDefinitionTemplateComponent implementationGuideDefinitionTemplateComponent : this.template) {
                    dst.template.add(implementationGuideDefinitionTemplateComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionComponent)) {
                return false;
            }
            ImplementationGuideDefinitionComponent o = (ImplementationGuideDefinitionComponent)other_;
            return ImplementationGuideDefinitionComponent.compareDeep(this.package_, o.package_, true) && ImplementationGuideDefinitionComponent.compareDeep(this.resource, o.resource, true) && ImplementationGuideDefinitionComponent.compareDeep(this.page, o.page, true) && ImplementationGuideDefinitionComponent.compareDeep(this.parameter, o.parameter, true) && ImplementationGuideDefinitionComponent.compareDeep(this.template, o.template, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDefinitionComponent)) {
                return false;
            }
            ImplementationGuideDefinitionComponent o = (ImplementationGuideDefinitionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.package_, this.resource, this.page, this.parameter, this.template});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.definition";
        }
    }

    @Block
    public static class ImplementationGuideGlobalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type this profile applies to", formalDefinition="The type of resource that all instances must conform to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType type;
        @Child(name="profile", type={CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Profile that all resources must conform to", formalDefinition="A reference to the profile that all instances must conform to.")
        protected CanonicalType profile;
        private static final long serialVersionUID = 33894666L;

        public ImplementationGuideGlobalComponent() {
        }

        public ImplementationGuideGlobalComponent(CodeType type, CanonicalType profile) {
            this.type = type;
            this.profile = profile;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImplementationGuideGlobalComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ImplementationGuideGlobalComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ImplementationGuideGlobalComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public ImplementationGuideGlobalComponent setProfile(String value) {
            if (this.profile == null) {
                this.profile = new CanonicalType();
            }
            this.profile.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of resource that all instances must conform to.", 0, 1, this.type));
            children.add(new Property("profile", "canonical(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of resource that all instances must conform to.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = this.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.profile");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideGlobalComponent copy() {
            ImplementationGuideGlobalComponent dst = new ImplementationGuideGlobalComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other_;
            return ImplementationGuideGlobalComponent.compareDeep(this.type, o.type, true) && ImplementationGuideGlobalComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other_;
            return ImplementationGuideGlobalComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.profile});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.global";
        }
    }

    @Block
    public static class ImplementationGuideDependsOnComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uri", type={CanonicalType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identity of the IG that this depends on", formalDefinition="The canonical URL of the Implementation guide for the dependency.")
        protected CanonicalType uri;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version of the IG", formalDefinition="The version of the IG that is depended on, when the correct version is required to understand the IG correctly.")
        protected StringType version;
        private static final long serialVersionUID = -1431104269L;

        public ImplementationGuideDependsOnComponent() {
        }

        public ImplementationGuideDependsOnComponent(CanonicalType uri) {
            this.uri = uri;
        }

        public CanonicalType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependsOnComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new CanonicalType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ImplementationGuideDependsOnComponent setUriElement(CanonicalType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ImplementationGuideDependsOnComponent setUri(String value) {
            if (this.uri == null) {
                this.uri = new CanonicalType();
            }
            this.uri.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependsOnComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ImplementationGuideDependsOnComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ImplementationGuideDependsOnComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uri", "canonical", "The canonical URL of the Implementation guide for the dependency.", 0, 1, this.uri));
            children.add(new Property(ImplementationGuide.SP_VERSION, "string", "The version of the IG that is depended on, when the correct version is required to understand the IG correctly.", 0, 1, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116076: {
                    return new Property("uri", "canonical", "The canonical URL of the Implementation guide for the dependency.", 0, 1, this.uri);
                }
                case 351608024: {
                    return new Property(ImplementationGuide.SP_VERSION, "string", "The version of the IG that is depended on, when the correct version is required to understand the IG correctly.", 0, 1, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uri;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116076: {
                    this.uri = this.castToCanonical(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uri")) {
                this.uri = this.castToCanonical(value);
            } else if (name.equals(ImplementationGuide.SP_VERSION)) {
                this.version = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return this.getUriElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return new String[]{"canonical"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.uri");
            }
            if (name.equals(ImplementationGuide.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.version");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDependsOnComponent copy() {
            ImplementationGuideDependsOnComponent dst = new ImplementationGuideDependsOnComponent();
            this.copyValues(dst);
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDependsOnComponent)) {
                return false;
            }
            ImplementationGuideDependsOnComponent o = (ImplementationGuideDependsOnComponent)other_;
            return ImplementationGuideDependsOnComponent.compareDeep(this.uri, o.uri, true) && ImplementationGuideDependsOnComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDependsOnComponent)) {
                return false;
            }
            ImplementationGuideDependsOnComponent o = (ImplementationGuideDependsOnComponent)other_;
            return ImplementationGuideDependsOnComponent.compareValues(this.uri, o.uri, true) && ImplementationGuideDependsOnComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.uri, this.version});
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.dependsOn";
        }
    }

    public static class GuideParameterCodeEnumFactory
    implements EnumFactory<GuideParameterCode> {
        @Override
        public GuideParameterCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("apply-business-version".equals(codeString)) {
                return GuideParameterCode.APPLYBUSINESSVERSION;
            }
            if ("apply-jurisdiction".equals(codeString)) {
                return GuideParameterCode.APPLYJURISDICTION;
            }
            if ("path-resource".equals(codeString)) {
                return GuideParameterCode.PATHRESOURCE;
            }
            if ("path-pages".equals(codeString)) {
                return GuideParameterCode.PATHPAGES;
            }
            if ("path-tx-cache".equals(codeString)) {
                return GuideParameterCode.PATHTXCACHE;
            }
            if ("expansion-profile".equals(codeString)) {
                return GuideParameterCode.EXPANSIONPROFILE;
            }
            if ("rule-broken-links".equals(codeString)) {
                return GuideParameterCode.RULEBROKENLINKS;
            }
            if ("generate-xml".equals(codeString)) {
                return GuideParameterCode.GENERATEXML;
            }
            if ("generate-json".equals(codeString)) {
                return GuideParameterCode.GENERATEJSON;
            }
            if ("generate-turtle".equals(codeString)) {
                return GuideParameterCode.GENERATETURTLE;
            }
            if ("html-template".equals(codeString)) {
                return GuideParameterCode.HTMLTEMPLATE;
            }
            throw new IllegalArgumentException("Unknown GuideParameterCode code '" + codeString + "'");
        }

        public Enumeration<GuideParameterCode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuideParameterCode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("apply-business-version".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.APPLYBUSINESSVERSION);
            }
            if ("apply-jurisdiction".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.APPLYJURISDICTION);
            }
            if ("path-resource".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.PATHRESOURCE);
            }
            if ("path-pages".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.PATHPAGES);
            }
            if ("path-tx-cache".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.PATHTXCACHE);
            }
            if ("expansion-profile".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.EXPANSIONPROFILE);
            }
            if ("rule-broken-links".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.RULEBROKENLINKS);
            }
            if ("generate-xml".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.GENERATEXML);
            }
            if ("generate-json".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.GENERATEJSON);
            }
            if ("generate-turtle".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.GENERATETURTLE);
            }
            if ("html-template".equals(codeString)) {
                return new Enumeration<GuideParameterCode>(this, GuideParameterCode.HTMLTEMPLATE);
            }
            throw new FHIRException("Unknown GuideParameterCode code '" + codeString + "'");
        }

        @Override
        public String toCode(GuideParameterCode code) {
            if (code == GuideParameterCode.APPLYBUSINESSVERSION) {
                return "apply-business-version";
            }
            if (code == GuideParameterCode.APPLYJURISDICTION) {
                return "apply-jurisdiction";
            }
            if (code == GuideParameterCode.PATHRESOURCE) {
                return "path-resource";
            }
            if (code == GuideParameterCode.PATHPAGES) {
                return "path-pages";
            }
            if (code == GuideParameterCode.PATHTXCACHE) {
                return "path-tx-cache";
            }
            if (code == GuideParameterCode.EXPANSIONPROFILE) {
                return "expansion-profile";
            }
            if (code == GuideParameterCode.RULEBROKENLINKS) {
                return "rule-broken-links";
            }
            if (code == GuideParameterCode.GENERATEXML) {
                return "generate-xml";
            }
            if (code == GuideParameterCode.GENERATEJSON) {
                return "generate-json";
            }
            if (code == GuideParameterCode.GENERATETURTLE) {
                return "generate-turtle";
            }
            if (code == GuideParameterCode.HTMLTEMPLATE) {
                return "html-template";
            }
            return "?";
        }

        @Override
        public String toSystem(GuideParameterCode code) {
            return code.getSystem();
        }
    }

    public static enum GuideParameterCode {
        APPLYBUSINESSVERSION,
        APPLYJURISDICTION,
        PATHRESOURCE,
        PATHPAGES,
        PATHTXCACHE,
        EXPANSIONPROFILE,
        RULEBROKENLINKS,
        GENERATEXML,
        GENERATEJSON,
        GENERATETURTLE,
        HTMLTEMPLATE,
        NULL;


        public static GuideParameterCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("apply-business-version".equals(codeString)) {
                return APPLYBUSINESSVERSION;
            }
            if ("apply-jurisdiction".equals(codeString)) {
                return APPLYJURISDICTION;
            }
            if ("path-resource".equals(codeString)) {
                return PATHRESOURCE;
            }
            if ("path-pages".equals(codeString)) {
                return PATHPAGES;
            }
            if ("path-tx-cache".equals(codeString)) {
                return PATHTXCACHE;
            }
            if ("expansion-profile".equals(codeString)) {
                return EXPANSIONPROFILE;
            }
            if ("rule-broken-links".equals(codeString)) {
                return RULEBROKENLINKS;
            }
            if ("generate-xml".equals(codeString)) {
                return GENERATEXML;
            }
            if ("generate-json".equals(codeString)) {
                return GENERATEJSON;
            }
            if ("generate-turtle".equals(codeString)) {
                return GENERATETURTLE;
            }
            if ("html-template".equals(codeString)) {
                return HTMLTEMPLATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuideParameterCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case APPLYBUSINESSVERSION: {
                    return "apply-business-version";
                }
                case APPLYJURISDICTION: {
                    return "apply-jurisdiction";
                }
                case PATHRESOURCE: {
                    return "path-resource";
                }
                case PATHPAGES: {
                    return "path-pages";
                }
                case PATHTXCACHE: {
                    return "path-tx-cache";
                }
                case EXPANSIONPROFILE: {
                    return "expansion-profile";
                }
                case RULEBROKENLINKS: {
                    return "rule-broken-links";
                }
                case GENERATEXML: {
                    return "generate-xml";
                }
                case GENERATEJSON: {
                    return "generate-json";
                }
                case GENERATETURTLE: {
                    return "generate-turtle";
                }
                case HTMLTEMPLATE: {
                    return "html-template";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case APPLYBUSINESSVERSION: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case APPLYJURISDICTION: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case PATHRESOURCE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case PATHPAGES: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case PATHTXCACHE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case EXPANSIONPROFILE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case RULEBROKENLINKS: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case GENERATEXML: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case GENERATEJSON: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case GENERATETURTLE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
                case HTMLTEMPLATE: {
                    return "http://hl7.org/fhir/guide-parameter-code";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case APPLYBUSINESSVERSION: {
                    return "If the value of this boolean 0..1 parameter is \"true\" then all conformance resources will have any specified [Resource].version overwritten with the ImplementationGuide.version";
                }
                case APPLYJURISDICTION: {
                    return "If the value of this boolean 0..1 parameter is \"true\" then all conformance resources will have any specified [Resource].jurisdiction overwritten with the ImplementationGuide.jurisdiction";
                }
                case PATHRESOURCE: {
                    return "The value of this string 0..* parameter is a subfolder of the build context's location that is to be scanned to load resources. Scope is (if present) a particular resource type";
                }
                case PATHPAGES: {
                    return "The value of this string 0..1 parameter is a subfolder of the build context's location that contains files that are part of the html content processed by the builder";
                }
                case PATHTXCACHE: {
                    return "The value of this string 0..1 parameter is a subfolder of the build context's location that is used as the terminology cache. If this is not present, the terminology cache is on the local system, not under version control";
                }
                case EXPANSIONPROFILE: {
                    return "The value of this string 0..1 parameter is a path to the ExpansionProfile used when expanding value sets for this implementation guide. This is particularly used to specify the versions of published terminologies such as SNOMED CT";
                }
                case RULEBROKENLINKS: {
                    return "The value of this string 0..1 parameter is either \"warning\" or \"error\" (default = \"error\"). If the value is \"warning\" then IG build tools allow the IG to be considered successfully build even when there is no internal broken links";
                }
                case GENERATEXML: {
                    return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in XML format. If not present, the Publication Tool decides whether to generate XML";
                }
                case GENERATEJSON: {
                    return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in JSON format. If not present, the Publication Tool decides whether to generate JSON";
                }
                case GENERATETURTLE: {
                    return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in Turtle format. If not present, the Publication Tool decides whether to generate Turtle";
                }
                case HTMLTEMPLATE: {
                    return "The value of this string singleton parameter is the name of the file to use as the builder template for each generated page (see templating)";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case APPLYBUSINESSVERSION: {
                    return "Apply Business Version";
                }
                case APPLYJURISDICTION: {
                    return "Apply Jurisdiction";
                }
                case PATHRESOURCE: {
                    return "Resource Path";
                }
                case PATHPAGES: {
                    return "Pages Path";
                }
                case PATHTXCACHE: {
                    return "Terminology Cache Path";
                }
                case EXPANSIONPROFILE: {
                    return "Expansion Profile";
                }
                case RULEBROKENLINKS: {
                    return "Broken Links Rule";
                }
                case GENERATEXML: {
                    return "Generate XML";
                }
                case GENERATEJSON: {
                    return "Generate JSON";
                }
                case GENERATETURTLE: {
                    return "Generate Turtle";
                }
                case HTMLTEMPLATE: {
                    return "HTML Template";
                }
            }
            return "?";
        }
    }

    public static class GuidePageGenerationEnumFactory
    implements EnumFactory<GuidePageGeneration> {
        @Override
        public GuidePageGeneration fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("html".equals(codeString)) {
                return GuidePageGeneration.HTML;
            }
            if ("markdown".equals(codeString)) {
                return GuidePageGeneration.MARKDOWN;
            }
            if ("xml".equals(codeString)) {
                return GuidePageGeneration.XML;
            }
            if ("generated".equals(codeString)) {
                return GuidePageGeneration.GENERATED;
            }
            throw new IllegalArgumentException("Unknown GuidePageGeneration code '" + codeString + "'");
        }

        public Enumeration<GuidePageGeneration> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuidePageGeneration>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("html".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.HTML);
            }
            if ("markdown".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.MARKDOWN);
            }
            if ("xml".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.XML);
            }
            if ("generated".equals(codeString)) {
                return new Enumeration<GuidePageGeneration>(this, GuidePageGeneration.GENERATED);
            }
            throw new FHIRException("Unknown GuidePageGeneration code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidePageGeneration code) {
            if (code == GuidePageGeneration.HTML) {
                return "html";
            }
            if (code == GuidePageGeneration.MARKDOWN) {
                return "markdown";
            }
            if (code == GuidePageGeneration.XML) {
                return "xml";
            }
            if (code == GuidePageGeneration.GENERATED) {
                return "generated";
            }
            return "?";
        }

        @Override
        public String toSystem(GuidePageGeneration code) {
            return code.getSystem();
        }
    }

    public static enum GuidePageGeneration {
        HTML,
        MARKDOWN,
        XML,
        GENERATED,
        NULL;


        public static GuidePageGeneration fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("html".equals(codeString)) {
                return HTML;
            }
            if ("markdown".equals(codeString)) {
                return MARKDOWN;
            }
            if ("xml".equals(codeString)) {
                return XML;
            }
            if ("generated".equals(codeString)) {
                return GENERATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuidePageGeneration code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HTML: {
                    return "html";
                }
                case MARKDOWN: {
                    return "markdown";
                }
                case XML: {
                    return "xml";
                }
                case GENERATED: {
                    return "generated";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HTML: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case MARKDOWN: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case XML: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
                case GENERATED: {
                    return "http://hl7.org/fhir/guide-page-generation";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HTML: {
                    return "Page is proper xhtml with no templating.  Will be brought across unchanged for standard post-processing";
                }
                case MARKDOWN: {
                    return "Page is markdown with templating.  Will use the template to create a file that imports the markdown file prior to post-processing";
                }
                case XML: {
                    return "Page is xml with templating.  Will use the template to create a file that imports the source file and run the nominated XSLT transform (see parameters) if present prior to post-processing";
                }
                case GENERATED: {
                    return "Page will be generated by the publication process - no source to bring across";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HTML: {
                    return "HTML";
                }
                case MARKDOWN: {
                    return "Markdown";
                }
                case XML: {
                    return "XML";
                }
                case GENERATED: {
                    return "Generated";
                }
            }
            return "?";
        }
    }
}

