/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hl7.fhir.r4.model.BaseDateTimeType;

@DatatypeDef(name="instant")
public class InstantType
extends BaseDateTimeType {
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.MILLI;
    private static final long serialVersionUID = 3L;

    public InstantType() {
    }

    public InstantType(Calendar theCalendar) {
        super(theCalendar.getTime(), DEFAULT_PRECISION, theCalendar.getTimeZone());
    }

    public InstantType(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimezone) {
        super(theDate, thePrecision, theTimezone);
    }

    public InstantType(BaseDateTimeType theDateTime) {
        this.setValue((Date)theDateTime.getValue());
        this.setPrecision(DEFAULT_PRECISION);
        this.setTimeZone(theDateTime.getTimeZone());
    }

    public InstantType(Date theDate) {
        super(theDate, DEFAULT_PRECISION, TimeZone.getDefault());
    }

    public InstantType(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.setValue(theDate);
        this.setPrecision(thePrecision);
        this.setTimeZone(TimeZone.getDefault());
    }

    public InstantType(String theString) {
        super(theString);
    }

    public boolean after(Date theDate) {
        return ((Date)this.getValue()).after(theDate);
    }

    public boolean before(Date theDate) {
        return ((Date)this.getValue()).before(theDate);
    }

    @Override
    public InstantType copy() {
        return new InstantType(this.getValueAsString());
    }

    @Override
    public String fhirType() {
        return "instant";
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case SECOND: 
            case MILLI: {
                return true;
            }
        }
        return false;
    }

    public void setToCurrentTimeInLocalTimeZone() {
        this.setValue(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    public static InstantType now() {
        return new InstantType(new Date(), TemporalPrecisionEnum.MILLI, TimeZone.getDefault());
    }

    public static InstantType parseV3(String theV3String) {
        InstantType retVal = new InstantType();
        retVal.setValueAsV3String(theV3String);
        return retVal;
    }

    public static InstantType withCurrentTime() {
        return new InstantType(new Date(), TemporalPrecisionEnum.MILLI, TimeZone.getDefault());
    }
}

